/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.dml;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001m1AAA\u0002\u0001!!)q\u0003\u0001C\u00011\t\u0019B+Z:u\u0007>l\u0007/Y2uS>tG+\u00192mK*\u0011A!B\u0001\u0004I6d'B\u0001\u0004\b\u0003\u0011AW\u000fZ5\u000b\u0005!I\u0011aA:rY*\u0011!bC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00195\ta!\u00199bG\",'\"\u0001\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\t\u0002C\u0001\n\u0016\u001b\u0005\u0019\"B\u0001\u000b\u0006\u0003\u0019\u0019w.\\7p]&\u0011ac\u0005\u0002\u0017\u0011>|G-[3Ta\u0006\u00148nU9m)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012!\u0007\t\u00035\u0001i\u0011a\u0001")
public class TestCompactionTable
extends HoodieSparkSqlTestBase {
    public static final /* synthetic */ void $anonfun$new$3(TestCompactionTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(326).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("'\n           | tblproperties (\n           |  primaryKey ='id',\n           |  type = 'mor',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql("set hoodie.parquet.max.file.size = 10000");
        $this.spark().sql("set hoodie.compact.inline=false");
        $this.spark().sql("set hoodie.compact.schedule.inline=false");
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(4, 'a4', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 11 where id = 1").toString());
        $this.spark().sql(new StringBuilder(24).append("schedule compaction  on ").append(tableName).toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 12 where id = 2").toString());
        $this.spark().sql(new StringBuilder(24).append("schedule compaction  on ").append(tableName).toString());
        Row[] compactionRows = (Row[])$this.spark().sql(new StringBuilder(28).append("show compaction on ").append(tableName).append(" limit 10").toString()).collect();
        String[] timestamps = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])compactionRows)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)timestamps.length), Prettifier$.MODULE$.default(), new Position("TestCompactionTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        $this.spark().sql(new StringBuilder(22).append("run compaction on ").append(tableName).append(" at ").append(timestamps[1]).toString());
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)11.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)((Row[])$this.spark().sql(new StringBuilder(19).append("show compaction on ").append(tableName).toString()).collect()).length), Prettifier$.MODULE$.default(), new Position("TestCompactionTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        $this.spark().sql(new StringBuilder(22).append("run compaction on ").append(tableName).append(" at ").append(timestamps[0]).toString());
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)11.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)((Row[])$this.spark().sql(new StringBuilder(19).append("show compaction on ").append(tableName).toString()).collect()).length), Prettifier$.MODULE$.default(), new Position("TestCompactionTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
    }

    public static final /* synthetic */ void $anonfun$new$6(TestCompactionTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(326).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("'\n           | tblproperties (\n           |  primaryKey ='id',\n           |  type = 'mor',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql("set hoodie.parquet.max.file.size = 10000");
        $this.spark().sql("set hoodie.compact.inline=false");
        $this.spark().sql("set hoodie.compact.schedule.inline=false");
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 11 where id = 1").toString());
        $this.spark().sql(new StringBuilder(20).append("run compaction on '").append(tmp.getCanonicalPath()).append("'").toString());
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)11.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.assertResult(BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)((Row[])$this.spark().sql(new StringBuilder(21).append("show compaction on '").append(tmp.getCanonicalPath()).append("'").toString()).collect()).length), Prettifier$.MODULE$.default(), new Position("TestCompactionTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 12 where id = 1").toString());
        $this.spark().sql(new StringBuilder(25).append("schedule compaction on '").append(tmp.getCanonicalPath()).append("'").toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 12 where id = 2").toString());
        $this.spark().sql(new StringBuilder(25).append("schedule compaction on '").append(tmp.getCanonicalPath()).append("'").toString());
        $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)((Row[])$this.spark().sql(new StringBuilder(21).append("show compaction on '").append(tmp.getCanonicalPath()).append("'").toString()).collect()).length), Prettifier$.MODULE$.default(), new Position("TestCompactionTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        $this.spark().sql(new StringBuilder(20).append("run compaction on '").append(tmp.getCanonicalPath()).append("'").toString());
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)((Row[])$this.spark().sql(new StringBuilder(21).append("show compaction on '").append(tmp.getCanonicalPath()).append("'").toString()).collect()).length), Prettifier$.MODULE$.default(), new Position("TestCompactionTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        $this.checkException(new StringBuilder(29).append("run compaction on '").append(tmp.getCanonicalPath()).append("' at 12345").toString(), "specific 12345 instants is not exist");
    }

    public static final /* synthetic */ void $anonfun$new$8(TestCompactionTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(326).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("'\n           | tblproperties (\n           |  primaryKey ='id',\n           |  type = 'mor',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql("set hoodie.parquet.max.file.size = 10000");
        $this.spark().sql("set hoodie.compact.inline=false");
        $this.spark().sql("set hoodie.compact.schedule.inline=false");
        $this.spark().sql("set hoodie.compact.inline.max.delta.commits=2");
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 11 where id = 1").toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 12 where id = 2").toString());
        $this.spark().sql(new StringBuilder(23).append("schedule compaction on ").append(tableName).toString());
        Row[] compactionRows = (Row[])$this.spark().sql(new StringBuilder(28).append("show compaction on ").append(tableName).append(" limit 10").toString()).collect();
        String[] timestamps = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])compactionRows)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)timestamps.length), Prettifier$.MODULE$.default(), new Position("TestCompactionTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        $this.spark().sql(new StringBuilder(22).append("run compaction on ").append(tableName).append(" at ").append(timestamps[0]).toString());
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)11.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)((Row[])$this.spark().sql(new StringBuilder(19).append("show compaction on ").append(tableName).toString()).collect()).length), Prettifier$.MODULE$.default(), new Position("TestCompactionTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        $this.spark().sql(new StringBuilder(26).append("DELETE FROM ").append(tableName).append(" WHERE id = 41").toString());
        $this.spark().sql(new StringBuilder(30).append("DELETE FROM ").append(tableName).append(" WHERE name = 'a2'").toString());
        $this.spark().sql(new StringBuilder(23).append("schedule compaction on ").append(tableName).toString());
        compactionRows = (Row[])$this.spark().sql(new StringBuilder(28).append("show compaction on ").append(tableName).append(" limit 10").toString()).collect();
        timestamps = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])compactionRows)).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).sorted((Ordering)Ordering.String$.MODULE$);
        $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)timestamps.length), Prettifier$.MODULE$.default(), new Position("TestCompactionTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        $this.spark().sql(new StringBuilder(22).append("run compaction on ").append(tableName).append(" at ").append(timestamps[1]).toString());
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)11.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)((Row[])$this.spark().sql(new StringBuilder(28).append("show compaction on ").append(tableName).append(" limit 10").toString()).collect()).length), Prettifier$.MODULE$.default(), new Position("TestCompactionTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
    }

    public TestCompactionTable() {
        this.test("Test compaction table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCompactionTable.$anonfun$new$3(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestCompactionTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 24));
        this.test("Test compaction path", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCompactionTable.$anonfun$new$6(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCompactionTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("Test compaction before and after deletes", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCompactionTable.$anonfun$new$8(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCompactionTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
    }
}

