/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.dml;

import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.testutils.DataSourceTestUtils;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001m1AAA\u0002\u0001!!)q\u0003\u0001C\u00011\tiB+Z:u\u0011>|G-[3UC\ndWMV1mk\u0016$g)\u001e8di&|gN\u0003\u0002\u0005\u000b\u0005\u0019A-\u001c7\u000b\u0005\u00199\u0011\u0001\u00025vI&T!\u0001C\u0005\u0002\u0007M\fHN\u0003\u0002\u000b\u0017\u0005)1\u000f]1sW*\u0011A\"D\u0001\u0007CB\f7\r[3\u000b\u00039\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I)R\"A\n\u000b\u0005Q)\u0011AB2p[6|g.\u0003\u0002\u0017'\t1\u0002j\\8eS\u0016\u001c\u0006/\u0019:l'FdG+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011!\u0004A\u0007\u0002\u0007\u0001")
public class TestHoodieTableValuedFunction
extends HoodieSparkSqlTestBase {
    public static final /* synthetic */ void $anonfun$new$3(TestHoodieTableValuedFunction $this, File tmp$1, String tableType) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringBuilder(11).append("set ").append(DataSourceWriteOptions$.MODULE$.SPARK_SQL_INSERT_INTO_OPERATION().key()).append("=upsert").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(353).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             |tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             |)\n             |location '").append(tmp$1.getCanonicalPath()).append("/").append(tableName).append("'\n             |").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(128).append("\n             | insert into ").append(tableName).append("\n             | values (1, 'a1', 10, 1000), (2, 'a2', 20, 1000), (3, 'a3', 30, 1000)\n             | ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(64).append("select id, name, price, ts from hudi_query('").append(tableName).append("', 'read_optimized')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)30.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(134).append("\n             | insert into ").append(tableName).append("\n             | values (1, 'a1_1', 10, 1100), (2, 'a2_2', 20, 1100), (3, 'a3_3', 30, 1100)\n             | ").toString())).stripMargin());
        String string = tableType;
        String string2 = "cow";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            $this.checkAnswer(new StringBuilder(64).append("select id, name, price, ts from hudi_query('").append(tableName).append("', 'read_optimized')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1_1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1100)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2_2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1100)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3_3", BoxesRunTime.boxToDouble((double)30.0), BoxesRunTime.boxToInteger((int)1100)}))}));
            return;
        }
        $this.checkAnswer(new StringBuilder(64).append("select id, name, price, ts from hudi_query('").append(tableName).append("', 'read_optimized')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)30.0), BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$2(TestHoodieTableValuedFunction $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestHoodieTableValuedFunction.$anonfun$new$3($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$6(TestHoodieTableValuedFunction $this, File tmp$2, Tuple2 parameters) {
        String tableType = (String)parameters._1();
        boolean isTableId = parameters._2$mcZ$sp();
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp$2.getCanonicalPath()).append("/").append(tableName).toString();
        String identifier = isTableId ? tableName : tablePath;
        $this.spark().sql("set hoodie.sql.insert.mode = non-strict");
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(352).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             |tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             |)\n             |location '").append(tablePath).append("'\n             |").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(128).append("\n             | insert into ").append(tableName).append("\n             | values (1, 'a1', 10, 1000), (2, 'a2', 20, 1000), (3, 'a3', 30, 1000)\n             | ").toString())).stripMargin());
        FileSystem fs = HadoopFSUtils.getFs((String)tablePath, (Configuration)$this.spark().sessionState().newHadoopConf());
        $this.checkAnswer(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(153).append("select id,\n             |name,\n             |price,\n             |ts\n             |from hudi_table_changes('").append(identifier).append("', 'latest_state', 'earliest')\n             |").toString())).stripMargin(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)30.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(134).append("\n             | insert into ").append(tableName).append("\n             | values (1, 'a1_1', 10, 1100), (2, 'a2_2', 20, 1100), (3, 'a3_3', 30, 1100)\n             | ").toString())).stripMargin());
        String secondCompletionTime = DataSourceTestUtils.latestCommitCompletionTime(fs, tablePath);
        String secondInstant = ((Row)$this.spark().sql(new StringBuilder(72).append("select max(_hoodie_commit_time) as commitTime from  ").append(tableName).append(" order by commitTime").toString()).first()).getString(0);
        $this.checkAnswer(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(188).append("select id,\n             |name,\n             |price,\n             |ts\n             |from hudi_table_changes(\n             |'").append(identifier).append("',\n             |'latest_state',\n             |'").append(secondCompletionTime).append("')\n             |").toString())).stripMargin(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1_1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1100)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2_2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1100)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3_3", BoxesRunTime.boxToDouble((double)30.0), BoxesRunTime.boxToInteger((int)1100)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(134).append("\n             | insert into ").append(tableName).append("\n             | values (1, 'a1_1', 10, 1200), (2, 'a2_2', 20, 1200), (3, 'a3_3', 30, 1200)\n             | ").toString())).stripMargin());
        $this.checkAnswer(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(215).append("select id,\n             | name,\n             | price,\n             | ts\n             | from hudi_table_changes(\n             | '").append(identifier).append("',\n             | 'latest_state',\n             | '").append(secondCompletionTime).append("',\n             | '").append(secondCompletionTime).append("')\n             | ").toString())).stripMargin(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1_1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1100)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2_2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1100)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3_3", BoxesRunTime.boxToDouble((double)30.0), BoxesRunTime.boxToInteger((int)1100)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$5(TestHoodieTableValuedFunction $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)new Tuple2((Object)"cow", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"mor", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"cow", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)"mor", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)parameters -> {
            TestHoodieTableValuedFunction.$anonfun$new$6($this, tmp, parameters);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$9(TestHoodieTableValuedFunction $this, File tmp$3, Tuple2 parameters) {
        String tableType = (String)parameters._1();
        boolean isTableId = parameters._2$mcZ$sp();
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp$3.getCanonicalPath()).append("/").append(tableName).toString();
        String identifier = isTableId ? tableName : tablePath;
        $this.spark().sql("set hoodie.sql.insert.mode = non-strict");
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(324).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double\n             |) using hudi\n             |partitioned by (price)\n             |tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id'\n             |)\n             |location '").append(tablePath).append("'\n             |").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(116).append("\n             | insert into ").append(tableName).append("\n             | values (1, 'a1', 10.0), (2, 'a2', 20.0), (3, 'a3', 30.0)\n             | ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(116).append("\n             | insert into ").append(tableName).append("\n             | values (4, 'a4', 10.0), (5, 'a5', 20.0), (6, 'a6', 30.0)\n             | ").toString())).stripMargin());
        Dataset result1DF = $this.spark().sql(new StringBuilder(48).append("select * from hudi_filesystem_view('").append(identifier).append("', 'price*')").toString());
        Row[] result1Array = (Row[])result1DF.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("Partition_Path")})).orderBy("Partition_Path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).take(10);
        $this.checkAnswer(result1Array, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"price=10.0", (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)"price=10.0", (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)"price=20.0", (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)"price=20.0", (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)"price=30.0", (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)"price=30.0", (List)Nil$.MODULE$)}));
    }

    public static final /* synthetic */ void $anonfun$new$8(TestHoodieTableValuedFunction $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)new Tuple2((Object)"cow", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"mor", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"cow", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)"mor", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)parameters -> {
            TestHoodieTableValuedFunction.$anonfun$new$9($this, tmp, parameters);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$12(TestHoodieTableValuedFunction $this, File tmp$4, Tuple2 parameters) {
        String tableType = (String)parameters._1();
        boolean isTableId = parameters._2$mcZ$sp();
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp$4.getCanonicalPath()).append("/").append(tableName).toString();
        String identifier = isTableId ? tableName : tablePath;
        $this.spark().sql("set hoodie.sql.insert.mode = upsert");
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(489).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             |tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts',\n             |  'hoodie.table.cdc.enabled' = 'true',\n             |  'hoodie.table.cdc.supplemental.logging.mode' = 'data_before_after'\n             |)\n             |location '").append(tablePath).append("'\n             |").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(128).append("\n             | insert into ").append(tableName).append("\n             | values (1, 'a1', 10, 1000), (2, 'a2', 20, 1000), (3, 'a3', 30, 1000)\n             | ").toString())).stripMargin());
        StructType originSchema = $this.spark().read().format("hudi").load(tablePath).schema();
        String firstInstant = ((Row)$this.spark().sql(new StringBuilder(72).append("select min(_hoodie_commit_time) as commitTime from  ").append(tableName).append(" order by commitTime").toString()).first()).getString(0);
        Dataset cdcDataOnly1 = $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(145).append("select\n             | op,\n             | before,\n             | after\n             |from hudi_table_changes('").append(identifier).append("', 'cdc', 'earliest')\n             |").toString())).stripMargin());
        Row[] change1 = (Row[])cdcDataOnly1.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("op"), functions$.MODULE$.col("before"), functions$.MODULE$.from_json(functions$.MODULE$.col("after"), originSchema).as("after")})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("op"), functions$.MODULE$.col("before"), functions$.MODULE$.col("after.id"), functions$.MODULE$.col("after.name"), functions$.MODULE$.col("after.price"), functions$.MODULE$.col("after.ts")})).orderBy("after.id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).take(10);
        $this.checkAnswer(change1, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"i", null, BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"i", null, BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"i", null, BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)30.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(134).append("\n             | insert into ").append(tableName).append("\n             | values (1, 'a1_1', 10, 1100), (2, 'a2_2', 20, 1100), (3, 'a3_3', 30, 1100)\n             | ").toString())).stripMargin());
        String secondInstant = ((Row)$this.spark().sql(new StringBuilder(72).append("select max(_hoodie_commit_time) as commitTime from  ").append(tableName).append(" order by commitTime").toString()).first()).getString(0);
        Dataset cdcDataOnly2 = $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(180).append("select\n             | op,\n             | before,\n             | after\n             |from hudi_table_changes(\n             |'").append(identifier).append("',\n             |'cdc',\n             |'").append(firstInstant).append("')\n             |").toString())).stripMargin());
        Row[] change2 = (Row[])cdcDataOnly2.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("op"), functions$.MODULE$.from_json(functions$.MODULE$.col("before"), originSchema).as("before"), functions$.MODULE$.from_json(functions$.MODULE$.col("after"), originSchema).as("after")})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("op"), functions$.MODULE$.col("before.id"), functions$.MODULE$.col("before.name"), functions$.MODULE$.col("before.price"), functions$.MODULE$.col("before.ts"), functions$.MODULE$.col("after.id"), functions$.MODULE$.col("after.name"), functions$.MODULE$.col("after.price"), functions$.MODULE$.col("after.ts")})).orderBy("after.id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).take(10);
        $this.checkAnswer(change2, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"u", BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)1), "a1_1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1100)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"u", BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)2), "a2_2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1100)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"u", BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)30.0), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)3), "a3_3", BoxesRunTime.boxToDouble((double)30.0), BoxesRunTime.boxToInteger((int)1100)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(134).append("\n             | insert into ").append(tableName).append("\n             | values (1, 'a1_1', 11, 1200), (2, 'a2_2', 21, 1200), (3, 'a3_3', 31, 1200)\n             | ").toString())).stripMargin());
        Dataset cdcDataOnly3 = $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(204).append("select\n             | op,\n             | before,\n             | after\n             | from hudi_table_changes(\n             | '").append(identifier).append("',\n             | 'cdc',\n             | '").append(firstInstant).append("',\n             | '").append(secondInstant).append("')\n             | ").toString())).stripMargin());
        Row[] change3 = (Row[])cdcDataOnly3.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("op"), functions$.MODULE$.from_json(functions$.MODULE$.col("before"), originSchema).as("before"), functions$.MODULE$.from_json(functions$.MODULE$.col("after"), originSchema).as("after")})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("op"), functions$.MODULE$.col("before.id"), functions$.MODULE$.col("before.name"), functions$.MODULE$.col("before.price"), functions$.MODULE$.col("before.ts"), functions$.MODULE$.col("after.id"), functions$.MODULE$.col("after.name"), functions$.MODULE$.col("after.price"), functions$.MODULE$.col("after.ts")})).orderBy("after.id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).take(10);
        $this.checkAnswer(change3, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"u", BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)1), "a1_1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1100)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"u", BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)2), "a2_2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1100)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"u", BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)30.0), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)3), "a3_3", BoxesRunTime.boxToDouble((double)30.0), BoxesRunTime.boxToInteger((int)1100)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$11(TestHoodieTableValuedFunction $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)new Tuple2((Object)"cow", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"mor", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"cow", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)"mor", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)parameters -> {
            TestHoodieTableValuedFunction.$anonfun$new$12($this, tmp, parameters);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$15(TestHoodieTableValuedFunction $this, File tmp$5, Tuple2 parameters) {
        String string;
        String tableType = (String)parameters._1();
        boolean isTableId = parameters._2$mcZ$sp();
        String string2 = tableType;
        if ("cow".equals(string2)) {
            string = "commit";
        } else if ("mor".equals(string2)) {
            string = "deltacommit";
        } else {
            throw new MatchError((Object)string2);
        }
        String action = string;
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp$5.getCanonicalPath()).append("/").append(tableName).toString();
        String identifier = isTableId ? tableName : tablePath;
        $this.spark().sql("set hoodie.sql.insert.mode = non-strict");
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(352).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             |tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             |)\n             |location '").append(tablePath).append("'\n             |").toString())).stripMargin());
        $this.spark().sql("set hoodie.merge.allow.duplicate.on.inserts = false");
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(128).append("\n             | insert into ").append(tableName).append("\n             | values (1, 'a1', 10, 1000), (2, 'a2', 20, 1000), (3, 'a3', 30, 1000)\n             | ").toString())).stripMargin());
        Row[] result1Array = (Row[])$this.spark().sql(new StringBuilder(45).append("select * from hudi_query_timeline('").append(identifier).append("', 'true')").toString()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("action"), functions$.MODULE$.col("state"), functions$.MODULE$.col("total_files_updated"), functions$.MODULE$.col("total_partitions_written"), functions$.MODULE$.col("total_records_written"), functions$.MODULE$.col("total_updated_records_written"), functions$.MODULE$.col("total_write_errors")})).orderBy("timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).take(10);
        $this.checkAnswer(result1Array, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action, "COMPLETED", BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(132).append("\n             | insert into ").append(tableName).append("\n             | values (4, 'a4', 10, 1100), (5, 'a2_2', 20, 1100), (6, 'a3_3', 30, 1100)\n             | ").toString())).stripMargin());
        Dataset result2DF = $this.spark().sql(new StringBuilder(46).append("select * from hudi_query_timeline('").append(identifier).append("', 'false')").toString());
        Row[] result2Array = (Row[])result2DF.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("action"), functions$.MODULE$.col("state"), functions$.MODULE$.col("total_files_updated"), functions$.MODULE$.col("total_partitions_written"), functions$.MODULE$.col("total_records_written"), functions$.MODULE$.col("total_updated_records_written"), functions$.MODULE$.col("total_write_errors")})).orderBy("timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).take(10);
        $this.checkAnswer(result2Array, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action, "COMPLETED", BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action, "COMPLETED", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(134).append("\n             | insert into ").append(tableName).append("\n             | values (1, 'a1_1', 10, 1200), (2, 'a2_2', 20, 1200), (3, 'a3_3', 30, 1200)\n             | ").toString())).stripMargin());
        Dataset result3DF = $this.spark().sql(new StringBuilder(45).append("select * from hudi_query_timeline('").append(identifier).append("', 'true')").toString());
        Row[] result3Array = (Row[])result3DF.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("action"), functions$.MODULE$.col("state"), functions$.MODULE$.col("total_files_updated"), functions$.MODULE$.col("total_partitions_written"), functions$.MODULE$.col("total_records_written"), functions$.MODULE$.col("total_updated_records_written"), functions$.MODULE$.col("total_write_errors")})).orderBy("timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).take(10);
        $this.checkAnswer(result3Array, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action, "COMPLETED", BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action, "COMPLETED", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action, "COMPLETED", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)0)}))}));
        Dataset result4DF = $this.spark().sql(new StringBuilder(88).append("select action, state from hudi_query_timeline('").append(identifier).append("', 'true') where total_files_updated > 0 ").toString());
        Row[] result4Array = (Row[])result4DF.take(10);
        $this.checkAnswer(result4Array, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)action, (List)new .colon.colon((Object)"COMPLETED", (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)action, (List)new .colon.colon((Object)"COMPLETED", (List)Nil$.MODULE$))}));
        Dataset result5DF = $this.spark().sql(new StringBuilder(65).append("select * from hudi_query_timeline('").append(identifier).append("', 'false')  where action = '").append(action).append("'").toString());
        Row[] result5Array = (Row[])result5DF.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("action"), functions$.MODULE$.col("state"), functions$.MODULE$.col("total_files_updated"), functions$.MODULE$.col("total_partitions_written"), functions$.MODULE$.col("total_records_written"), functions$.MODULE$.col("total_updated_records_written"), functions$.MODULE$.col("total_write_errors")})).orderBy("timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).take(10);
        $this.checkAnswer(result5Array, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action, "COMPLETED", BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action, "COMPLETED", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action, "COMPLETED", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)0)}))}));
        Dataset result6DF = $this.spark().sql(new StringBuilder(95).append("select action, state from hudi_query_timeline('").append(identifier).append("', 'false')  where timestamp > '202312190000000'").toString());
        Row[] result6Array = (Row[])result6DF.take(10);
        $this.checkAnswer(result6Array, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)action, (List)new .colon.colon((Object)"COMPLETED", (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)action, (List)new .colon.colon((Object)"COMPLETED", (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)action, (List)new .colon.colon((Object)"COMPLETED", (List)Nil$.MODULE$))}));
    }

    public static final /* synthetic */ void $anonfun$new$14(TestHoodieTableValuedFunction $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)new Tuple2((Object)"cow", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"mor", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"cow", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)"mor", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)parameters -> {
            TestHoodieTableValuedFunction.$anonfun$new$15($this, tmp, parameters);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$17(TestHoodieTableValuedFunction $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            String tableName;
            String identifier = tableName = $this.generateTableName();
            $this.spark().sql(new StringBuilder(11).append("set ").append(DataSourceWriteOptions$.MODULE$.SPARK_SQL_INSERT_INTO_OPERATION().key()).append("=upsert").toString());
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(655).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  ts long,\n             |  price int\n             |) using hudi\n             |partitioned by (price)\n             |tblproperties (\n             |  type = '").append((String)tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts',\n             |  hoodie.datasource.write.recordkey.field = 'id',\n             |  hoodie.metadata.record.index.enable = 'true',\n             |  hoodie.metadata.index.column.stats.enable = 'true',\n             |  hoodie.metadata.index.column.stats.column.list = 'price'\n             |)\n             |location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n             |").toString())).stripMargin());
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(128).append("\n             | insert into ").append(tableName).append("\n             | values (1, 'a1', 1000, 10), (2, 'a2', 2000, 20), (3, 'a3', 3000, 30)\n             | ").toString())).stripMargin());
            Dataset result2DF = $this.spark().sql(new StringBuilder(71).append("select type, key, filesystemmetadata from hudi_metadata('").append(identifier).append("') where type=").append(MetadataPartitionType.ALL_PARTITIONS.getRecordType()).toString());
            long $org_scalatest_assert_macro_left = result2DF.count();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TestHoodieTableValuedFunction.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 592));
            Dataset result3DF = $this.spark().sql(new StringBuilder(71).append("select type, key, filesystemmetadata from hudi_metadata('").append(identifier).append("') where type=").append(MetadataPartitionType.FILES.getRecordType()).toString());
            long $org_scalatest_assert_macro_left2 = result3DF.count();
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TestHoodieTableValuedFunction.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 597));
            Dataset result4DF = $this.spark().sql(new StringBuilder(72).append("select type, key, ColumnStatsMetadata from hudi_metadata('").append(identifier).append("') where type=").append(MetadataPartitionType.COLUMN_STATS.getRecordType()).toString());
            long $org_scalatest_assert_macro_left3 = result4DF.count();
            int $org_scalatest_assert_macro_right3 = 12;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == (long)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TestHoodieTableValuedFunction.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 603));
            Dataset result5DF = $this.spark().sql(new StringBuilder(72).append("select type, key, recordIndexMetadata from hudi_metadata('").append(identifier).append("') where type=").append(MetadataPartitionType.RECORD_INDEX.getRecordType()).toString());
            long $org_scalatest_assert_macro_left4 = result5DF.count();
            int $org_scalatest_assert_macro_right4 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == (long)$org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TestHoodieTableValuedFunction.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 608));
            Dataset result6DF = $this.spark().sql(new StringBuilder(98).append("select type, key, BloomFilterMetadata from hudi_metadata('").append(identifier).append("') where BloomFilterMetadata is not null").toString());
            long $org_scalatest_assert_macro_left5 = result6DF.count();
            int $org_scalatest_assert_macro_right5 = 0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == (long)$org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("TestHoodieTableValuedFunction.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 613));
            Dataset result7DF = $this.spark().sql(new StringBuilder(72).append("select type, key, ColumnStatsMetadata from hudi_metadata('").append(identifier).append("') where type=").append(MetadataPartitionType.PARTITION_STATS.getRecordType()).toString());
            long $org_scalatest_assert_macro_left6 = result7DF.count();
            int $org_scalatest_assert_macro_right6 = 12;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == (long)$org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("TestHoodieTableValuedFunction.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 619));
        });
    }

    public static final /* synthetic */ void $anonfun$new$21(TestHoodieTableValuedFunction $this, File tmp$7, String tableType) {
        String tableName;
        String identifier = tableName = $this.generateTableName();
        $this.spark().sql(new StringBuilder(11).append("set ").append(DataSourceWriteOptions$.MODULE$.SPARK_SQL_INSERT_INTO_OPERATION().key()).append("=upsert").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(716).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  ts long,\n             |  price int\n             |) using hudi\n             |partitioned by (ts)\n             |tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts',\n             |  hoodie.datasource.write.recordkey.field = 'id',\n             |  hoodie.metadata.index.partition.stats.enable = 'true',\n             |  hoodie.metadata.index.column.stats.enable = 'true',\n             |  hoodie.metadata.index.column.stats.column.list = 'price',\n             |  hoodie.populate.meta.fields = 'false'\n             |)\n             |location '").append(tmp$7.getCanonicalPath()).append("/").append(tableName).append("'\n             |").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(191).append("\n             | insert into ").append(tableName).append("\n             | values (1, 'a1', 1000, 10), (2, 'a2', 2000, 20), (3, 'a3', 3000, 30), (4, 'a4', 2000, 10), (5, 'a5', 3000, 20), (6, 'a6', 4000, 30)\n             | ").toString())).stripMargin());
        Dataset result2DF = $this.spark().sql(new StringBuilder(71).append("select type, key, filesystemmetadata from hudi_metadata('").append(identifier).append("') where type=").append(MetadataPartitionType.ALL_PARTITIONS.getRecordType()).toString());
        long $org_scalatest_assert_macro_left = result2DF.count();
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TestHoodieTableValuedFunction.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 664));
        Dataset result3DF = $this.spark().sql(new StringBuilder(71).append("select type, key, filesystemmetadata from hudi_metadata('").append(identifier).append("') where type=").append(MetadataPartitionType.FILES.getRecordType()).toString());
        long $org_scalatest_assert_macro_left2 = result3DF.count();
        int $org_scalatest_assert_macro_right2 = 3;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TestHoodieTableValuedFunction.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 669));
        Dataset result4DF = $this.spark().sql(new StringBuilder(43).append("select * from hudi_metadata('").append(identifier).append("') where type=").append(MetadataPartitionType.PARTITION_STATS.getRecordType()).toString());
        long $org_scalatest_assert_macro_left3 = result4DF.count();
        int $org_scalatest_assert_macro_right3 = 3;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == (long)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TestHoodieTableValuedFunction.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 674));
        $this.checkAnswer(new StringBuilder(89).append("select key, ColumnStatsMetadata.minValue.member1.value from hudi_metadata('").append(identifier).append("') where type=").append(MetadataPartitionType.PARTITION_STATS.getRecordType()).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=10", (String)"price"), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=20", (String)"price"), BoxesRunTime.boxToInteger((int)2000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=30", (String)"price"), BoxesRunTime.boxToInteger((int)3000)}))}));
        $this.checkAnswer(new StringBuilder(89).append("select key, ColumnStatsMetadata.maxValue.member1.value from hudi_metadata('").append(identifier).append("') where type=").append(MetadataPartitionType.PARTITION_STATS.getRecordType()).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=10", (String)"price"), BoxesRunTime.boxToInteger((int)2000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=20", (String)"price"), BoxesRunTime.boxToInteger((int)3000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"ts=30", (String)"price"), BoxesRunTime.boxToInteger((int)4000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$20(TestHoodieTableValuedFunction $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestHoodieTableValuedFunction.$anonfun$new$21($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public TestHoodieTableValuedFunction() {
        this.test("Test hudi_query Table-Valued Function", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestHoodieTableValuedFunction.$anonfun$new$2(this, tmp);
                return BoxedUnit.UNIT;
            });
            this.spark().sessionState().conf().unsetConf(DataSourceWriteOptions$.MODULE$.SPARK_SQL_INSERT_INTO_OPERATION().key());
        }, new Position("TestHoodieTableValuedFunction.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        this.test("Test hudi_table_changes latest_state", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestHoodieTableValuedFunction.$anonfun$new$5(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestHoodieTableValuedFunction.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("Test hudi_filesystem_view", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestHoodieTableValuedFunction.$anonfun$new$8(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestHoodieTableValuedFunction.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        this.test("Test hudi_table_changes cdc", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestHoodieTableValuedFunction.$anonfun$new$11(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestHoodieTableValuedFunction.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
        this.test("Test hudi_query_timeline", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestHoodieTableValuedFunction.$anonfun$new$14(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestHoodieTableValuedFunction.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 412));
        this.test("Test hudi_metadata Table-Valued Function", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestHoodieTableValuedFunction.$anonfun$new$17(this, tmp);
                return BoxedUnit.UNIT;
            });
            this.spark().sessionState().conf().unsetConf(DataSourceWriteOptions$.MODULE$.SPARK_SQL_INSERT_INTO_OPERATION().key());
        }, new Position("TestHoodieTableValuedFunction.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 554));
        this.test("Test hudi_metadata Table-Valued Function For PARTITION_STATS index", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestHoodieTableValuedFunction.$anonfun$new$20(this, tmp);
                return BoxedUnit.UNIT;
            });
            this.spark().sessionState().conf().unsetConf(DataSourceWriteOptions$.MODULE$.SPARK_SQL_INSERT_INTO_OPERATION().key());
        }, new Position("TestHoodieTableValuedFunction.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 625));
    }
}

