/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.dml;

import java.io.File;
import java.io.Serializable;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00192A\u0001B\u0003\u0001%!)\u0011\u0004\u0001C\u00015!9Q\u0004\u0001b\u0001\n\u0013q\u0002BB\u0013\u0001A\u0003%qDA\nUKN$X*\u001a:hK&sGo\u001c+bE2,'G\u0003\u0002\u0007\u000f\u0005\u0019A-\u001c7\u000b\u0005!I\u0011\u0001\u00025vI&T!AC\u0006\u0002\u0007M\fHN\u0003\u0002\r\u001b\u0005)1\u000f]1sW*\u0011abD\u0001\u0007CB\f7\r[3\u000b\u0003A\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\n\u0011\u0005Q9R\"A\u000b\u000b\u0005Y9\u0011AB2p[6|g.\u0003\u0002\u0019+\t1\u0002j\\8eS\u0016\u001c\u0006/\u0019:l'FdG+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u000b\u0005\u0019An\\4\u0016\u0003}\u0001\"\u0001I\u0012\u000e\u0003\u0005R!AI\b\u0002\u000bMdg\r\u000e6\n\u0005\u0011\n#A\u0002'pO\u001e,'/\u0001\u0003m_\u001e\u0004\u0003")
public class TestMergeIntoTable2
extends HoodieSparkSqlTestBase {
    private final Logger log = LoggerFactory.getLogger((Class)this.getClass());

    private Logger log() {
        return this.log;
    }

    public static final /* synthetic */ void $anonfun$new$3(TestMergeIntoTable2 $this, File tmp) {
        $this.spark().sql("set hoodie.payload.combined.schema.validate = true");
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(388).append("\n           | create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  dt string\n           | ) using hudi\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n           | partitioned by(dt)\n           | location '").append(tmp.getCanonicalPath()).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(264).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 1 as id, 'a1' as name, 10 as price, 1000L as ts, '2021-03-21' as dt\n           | ) as s0\n           | on t0.id = s0.id\n           | when not matched and s0.id % 2 = 1 then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(29).append("select id,name,price,dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-03-21"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(264).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 2 as id, 'a2' as name, 10 as price, 1000L as ts, '2021-03-21' as dt\n           | ) as s0\n           | on t0.id = s0.id\n           | when not matched and s0.id % 2 = 1 then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(29).append("select id,name,price,dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-03-21"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(364).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 1 as id, 'a1' as name, 11 as price, 1000L as ts, '2021-03-21' as dt\n           | ) as s0\n           | on t0.id = s0.id\n           | when matched and s0.id % 2 = 0 then update set *\n           | when matched and s0.id % 3 = 2 then delete\n           | when not matched then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(29).append("select id,name,price,dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-03-21"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(460).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 1 as id, 'a1' as name, 11 as price, 1000L as ts, '2021-03-21' as dt\n           | ) as s0\n           | on t0.id = s0.id\n           | when matched and s0.id % 2 = 1 then update set id = s0.id, name = s0.name,\n           |  price = s0.price * 2, ts = s0.ts, dt = s0.dt\n           | when not matched then insert (id,name,price,ts,dt) values(s0.id, s0.name, s0.price, s0.ts, s0.dt)\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(29).append("select id,name,price,dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)22), "2021-03-21"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(516).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 1 as id, 'a1' as name, 11 as price, 1000L as ts, '2021-03-21' as dt\n           | ) as s0\n           | on t0.id = s0.id\n           | when matched and s0.id % 2 = 0 then update set id = s0.id, name = s0.name,\n           |  price = s0.price * 2, ts = s0.ts, dt = s0.dt\n           | when matched and s0.id % 2 = 1 then delete\n           | when not matched then insert (id,name,price,ts,dt) values(s0.id, s0.name, s0.price, s0.ts, s0.dt)\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(21).append("select count(1) from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))}));
        $this.checkException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(356).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 1 as id, 'a1' as name, 10 as price, 1000L as ts, '2021-03-21' as dt\n           | ) as s0\n           | on t0.id = s0.id\n           | when matched and s0.id % 2 = 1 then update set id = s0.id, name = s0.name,\n           |  price = s0.price + t0.price, ts = s0.ts, dt = s0.dt\n         ").toString())).stripMargin(), "assertion failed: Target table's field(price) cannot be the right-value of the update clause for MOR table.");
    }

    public static final /* synthetic */ void $anonfun$new$5(TestMergeIntoTable2 $this, File tmp) {
        $this.spark().sql("set hoodie.payload.combined.schema.validate = true");
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(175).append("\n           |create table ").append(tableName).append(" using hudi\n           |tblproperties(primaryKey = 'id')\n           |location '").append(tmp.getCanonicalPath()).append("'\n           |as\n           |select 1 as id, 'a1' as name\n           |").toString())).stripMargin());
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)tmp.getCanonicalPath());
        $this.assertResult("id", new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metaClient.getTableConfig().getRecordKeyFields().get())).mkString(","), Prettifier$.MODULE$.default(), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(193).append("\n           |merge into ").append(tableName).append(" h0\n           |using (\n           | select 1 as id, 'a1_1' as name\n           |) s0\n           |on h0.id = s0.id\n           |when matched then update set *\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(21).append("select id, name from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1_1"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$8(TestMergeIntoTable2 $this, File tmp) {
        $this.spark().sql("set hoodie.payload.combined.schema.validate = true");
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(434).append("\n           | create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  s_value struct<f0: int, f1: string>,\n           |  a_value array<string>,\n           |  m_value map<string, string>,\n           |  ts long\n           | ) using hudi\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n           | location '").append(tmp.getCanonicalPath()).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(374).append("\n           |merge into ").append(tableName).append(" h0\n           |using (\n           |select\n           |  1 as id,\n           |  'a1' as name,\n           |  struct(1, '10') as s_value,\n           |  split('a0,a1', ',') as a_value,\n           |  map('k0', 'v0') as m_value,\n           |  1000 as ts\n           |) s0\n           |on h0.id = s0.id\n           |when not matched then insert *\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(52).append("select id, name, s_value, a_value, m_value, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "10"})), new .colon.colon((Object)"a0", (List)new .colon.colon((Object)"a1", (List)Nil$.MODULE$)), Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k0"), (Object)"v0")})), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(420).append("\n           |merge into ").append(tableName).append(" h0\n           |using (\n           |select\n           |  1 as id,\n           |  'a1' as name,\n           |  struct(1, '12') as s_value,\n           |  split('a0,a1,a2', ',') as a_value,\n           |  map('k1', 'v1') as m_value,\n           |  1000 as ts\n           |) s0\n           |on h0.id = s0.id\n           |when matched then update set *\n           |when not matched then insert *\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(52).append("select id, name, s_value, a_value, m_value, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "12"})), new .colon.colon((Object)"a0", (List)new .colon.colon((Object)"a1", (List)new .colon.colon((Object)"a2", (List)Nil$.MODULE$))), Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k1"), (Object)"v1")})), BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$10(TestMergeIntoTable2 $this, File tmp) {
        $this.spark().sql("set hoodie.payload.combined.schema.validate = true");
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(324).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  dt string\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  primaryKey ='id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(48).append("insert into ").append(tableName).append(" select 1, 'a1', 1, 10, '2021-03-21'").toString());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)10), "2021-03-21"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(483).append("\n           |merge into ").append(tableName).append(" as t0\n           |using (\n           |  select 1 as id, 'a1' as name, 97 as price, 1002 as ts, '2021-05-05' as dt union all\n           |  select 1 as id, 'a2' as name, 98 as price, 1003 as ts, '2021-05-05' as dt union all\n           |  select 2 as id, 'a3' as name, 99 as price, 1001 as ts, '2021-05-05' as dt\n           | ) as s0\n           |on t0.id = s0.id\n           |when matched then update set *\n           |when not matched then insert *\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2", BoxesRunTime.boxToDouble((double)98.0), BoxesRunTime.boxToInteger((int)1003), "2021-05-05"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a3", BoxesRunTime.boxToDouble((double)99.0), BoxesRunTime.boxToInteger((int)1001), "2021-05-05"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(625).append("\n           |merge into ").append(tableName).append(" as t0\n           |using (\n           |  select 1 as id, 'a1' as name, 1004 as ts, '2021-05-05' as dt, 100 as price union all\n           |  select 2 as id, 'a5' as name, 1000 as ts, '2021-05-05' as dt, 101 as price union all\n           |  select 3 as id, 'a3' as name, 1000 as ts, '2021-05-05' as dt, 102 as price\n           | ) as s0\n           |on t0.id = s0.id\n           |when matched then update set t0.name = s0.name, t0.ts = s0.ts, t0.dt = s0.dt, t0.price = s0.price\n           |when not matched then insert (id, name, ts, dt, price) values (s0.id, s0.name, s0.ts, s0.dt, s0.price)\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)100.0), BoxesRunTime.boxToInteger((int)1004), "2021-05-05"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a3", BoxesRunTime.boxToDouble((double)99.0), BoxesRunTime.boxToInteger((int)1001), "2021-05-05"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)102.0), BoxesRunTime.boxToInteger((int)1000), "2021-05-05"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(443).append("\n           |merge into ").append(tableName).append(" as t0\n           |using (\n           |  select 1 as id, 'a6' as name, 106 as price, 1006 as ts, '2021-05-05' as dt, '0' as flag union all\n           |  select 4 as id, 'a4' as name, 100 as price, 1000 as ts, '2021-05-06' as dt, '1' as flag\n           | ) as s0\n           |on t0.id = s0.id\n           |when matched and flag = '1' then update set *\n           |when not matched and flag = '1' then insert *\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)100.0), BoxesRunTime.boxToInteger((int)1004), "2021-05-05"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a3", BoxesRunTime.boxToDouble((double)99.0), BoxesRunTime.boxToInteger((int)1001), "2021-05-05"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)102.0), BoxesRunTime.boxToInteger((int)1000), "2021-05-05"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)100.0), BoxesRunTime.boxToInteger((int)1000), "2021-05-06"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$12(TestMergeIntoTable2 $this, File tmp) {
        $this.spark().sql("set hoodie.payload.combined.schema.validate = true");
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(299).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  primaryKey ='id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        String mergeSql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(358).append("\n           | merge into ").append(tableName).append("\n           | using (\n           |  select 1, 'a1', 10, 1000, '1'\n           | ) s0(id,name,price,ts,flag)\n           | on s0.id = ").append(tableName).append(".id\n           | when matched and flag = '1' then update set\n           | id = s0.id, name = s0.name, price = s0.price, ts = s0.ts\n           | when not matched and flag = '1' then insert *\n           |").toString())).stripMargin();
        if (HoodieSparkUtils$.MODULE$.isSpark3()) {
            $this.checkExceptionContain(mergeSql, "Columns aliases are not allowed in MERGE");
            return;
        }
        $this.spark().sql(mergeSql);
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$14(TestMergeIntoTable2 $this, File tmp) {
        $this.spark().sql("set hoodie.payload.combined.schema.validate = true");
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(324).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  dt string\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  primaryKey ='id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(48).append("insert into ").append(tableName).append(" select 1, 'a1', 1, 10, '2022-08-18'").toString());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)10), "2022-08-18"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(341).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 1 as id, 'a1' as name, 11 as price, 110 as ts, '2022-08-19' as dt union all\n           |  select 2 as id, 'a2' as name, 10 as price, 100 as ts, '2022-08-18' as dt\n           | ) as s0\n           | on t0.id = s0.id\n           | when not matched then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)10), "2022-08-18"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)100), "2022-08-18"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$17(TestMergeIntoTable2 $this, File tmp) {
        $this.spark().sql("set hoodie.payload.combined.schema.validate = true");
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(353).append("\n           |create table ").append(tableName).append(" (\n           |  id1 int,\n           |  id2 int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  dt string\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  primaryKey ='id1,id2',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(51).append("insert into ").append(tableName).append(" select 1, 1, 'a1', 1, 10, '2022-08-18'").toString());
        $this.checkAnswer(new StringBuilder(42).append("select id1, id2, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)10), "2022-08-18"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(385).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 1 as id1, 1 as id2, 'a1' as name, 11 as price, 110 as ts, '2022-08-19' as dt union all\n           |  select 1 as id1, 2 as id2, 'a2' as name, 10 as price, 100 as ts, '2022-08-18' as dt\n           | ) as s0\n           | on t0.id1 = s0.id1 and t0.id2 = s0.id2\n           | when not matched then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(42).append("select id1, id2, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)10), "2022-08-18"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)100), "2022-08-18"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$19(TestMergeIntoTable2 $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(388).append("\n           | create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  dt string\n           | ) using hudi\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n           | partitioned by(dt)\n           | location '").append(tmp.getCanonicalPath()).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(263).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 1 as id, 'a1' as name, 10 as price, 1000 as ts, '2021-03-21' as dt\n           | ) as s0\n           | on t0.id = s0.id\n           | when not matched and s0.id % 2 = 1 then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(29).append("select id,name,price,dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-03-21"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$22(TestMergeIntoTable2 $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(388).append("\n           | create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  dt string\n           | ) using hudi\n           | tblproperties (\n           |  type = 'cow',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n           | partitioned by(dt)\n           | location '").append(tmp.getCanonicalPath()).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(68).append("insert into ").append(tableName).append(" select 1, 'a1', cast(10.0 as double), 999, '2021-03-21'").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(326).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 'a1' as name, 1 as id, '10.1' as price, 1000 as ts, '2021-03-21' as dt\n           | ) as s0\n           | on t0.id = s0.id\n           | when matched then update set t0.price = s0.price, t0.ts = s0.ts\n           | when not matched then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(29).append("select id,name,price,dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.1), "2021-03-21"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$25(TestMergeIntoTable2 $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(403).append("\n           | create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  ts long\n           | ) using hudi\n           | tblproperties (\n           |  type = 'cow',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts',\n           |  hoodie.datasource.write.payload.class = 'org.apache.hudi.common.model.DefaultHoodieRecordPayload'\n           | ) location '").append(tmp.getCanonicalPath()).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(32).append("insert into ").append(tableName).append(" select 1, 'a1', 999").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(287).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 1 as id, 'a2' as name, 1000 as ts\n           | ) as s0\n           | on t0.id = s0.id\n           | when matched then update set t0.name = s0.name, t0.ts = s0.ts\n           | when not matched then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(23).append("select id,name,ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2", BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$28(TestMergeIntoTable2 $this, String tableType$1, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(441).append("\n               | create table ").append(tableName).append(" (\n               |  id int,\n               |  name string,\n               |  price double,\n               |  ts long,\n               |  dt string\n               | ) using hudi\n               | tblproperties (\n               |  type = '").append(tableType$1).append("',\n               |  primaryKey = 'id',\n               |  preCombineField = 'ts'\n               | )\n               | partitioned by(dt)\n               | location '").append(tmp.getCanonicalPath()).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(393).append("\n               | merge into ").append(tableName).append(" as t0\n               | using (\n               |  select 1 as id, 'a1' as name, 10.1 as price, 1000 as ts, '2021-03-21' as dt\n               |  union all\n               |  select 1 as id, 'a2' as name, 10.2 as price, 1002 as ts, '2021-03-21' as dt\n               | ) as s0\n               | on t0.id = s0.id\n               | when not matched then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2", BoxesRunTime.boxToDouble((double)10.2), BoxesRunTime.boxToInteger((int)1002), "2021-03-21"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(567).append("\n               | merge into ").append(tableName).append(" as t0\n               | using (\n               |  select 1 as id, 'a1_new' as name, 10.1 as price, 1003 as ts, '2021-03-21' as dt\n               |  union all\n               |  select 3 as id, 'a3' as name, 10.3 as price, 1003 as ts, '2021-03-21' as dt\n               |  union all\n               |  select 3 as id, 'a3' as name, 10.3 as price, 1003 as ts, '2021-03-21' as dt\n               | ) as s0\n               | on t0.id = s0.id\n               | when matched then update set *\n               | when not matched then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1_new", BoxesRunTime.boxToDouble((double)10.1), BoxesRunTime.boxToInteger((int)1003), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.3), BoxesRunTime.boxToInteger((int)1003), "2021-03-21"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$31(TestMergeIntoTable2 $this, String tableType$2, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(399).append("\n               | create table ").append(tableName).append(" (\n               |  id int,\n               |  name string,\n               |  price double,\n               |  ts long,\n               |  dt string\n               | ) using hudi\n               | tblproperties (\n               |  type = '").append(tableType$2).append("',\n               |  primaryKey = 'id'\n               | )\n               | partitioned by(dt)\n               | location '").append(tmp.getCanonicalPath()).append("'\n         ").toString())).stripMargin());
        $this.spark().sql("set hoodie.merge.allow.duplicate.on.inserts = true");
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(393).append("\n               | merge into ").append(tableName).append(" as t0\n               | using (\n               |  select 1 as id, 'a1' as name, 10.1 as price, 1000 as ts, '2021-03-21' as dt\n               |  union all\n               |  select 1 as id, 'a2' as name, 10.2 as price, 1002 as ts, '2021-03-21' as dt\n               | ) as s0\n               | on t0.id = s0.id\n               | when not matched then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.1), BoxesRunTime.boxToInteger((int)1000), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2", BoxesRunTime.boxToDouble((double)10.2), BoxesRunTime.boxToInteger((int)1002), "2021-03-21"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(441).append("\n               | merge into ").append(tableName).append(" as t0\n               | using (\n               |  select 3 as id, 'a3' as name, 10.3 as price, 1003 as ts, '2021-03-21' as dt\n               |  union all\n               |  select 1 as id, 'a2' as name, 10.4 as price, 1004 as ts, '2021-03-21' as dt\n               | ) as s0\n               | on t0.id = s0.id\n               | when matched then update set *\n               | when not matched then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2", BoxesRunTime.boxToDouble((double)10.4), BoxesRunTime.boxToInteger((int)1004), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2", BoxesRunTime.boxToDouble((double)10.4), BoxesRunTime.boxToInteger((int)1004), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.3), BoxesRunTime.boxToInteger((int)1003), "2021-03-21"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$33(TestMergeIntoTable2 $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(384).append("\n           | create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  dt string\n           | ) using hudi\n           | tblproperties (\n           |  type = 'cow',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n           | partitioned by(dt)\n           | location '").append(tmp.getCanonicalPath()).append("'\n     ").toString())).stripMargin());
        $this.spark().sql("set hoodie.merge.allow.duplicate.on.inserts = false");
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(139).append("\n           |insert into ").append(tableName).append(" values\n           |  (1, 'a1', 10, 1000, '2021-03-21'),\n           |  (3, 'a3', 10, 2000, '2021-03-21')\n         ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(391).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 1 as id, 'a1' as name, 10.1 as price, 1003 as ts, '2021-03-21' as dt\n           | ) as s0\n           | on t0.id = s0.id\n           | when matched then update set t0.ts = s0.ts,\n           |      t0.price = if(nvl(s0.price,0) <> nvl(t0.price,0), s0.price, t0.price)\n           | when not matched then insert *\n        ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.1), BoxesRunTime.boxToInteger((int)1003), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)2000), "2021-03-21"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$35(TestMergeIntoTable2 $this, File tmp) {
        String sourceTable = $this.generateTableName();
        String path1 = tmp.getCanonicalPath().concat("/source");
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(388).append("\n           | create table ").append(sourceTable).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  dt string\n           | ) using hudi\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n           | partitioned by(dt)\n           | location '").append(path1).append("'\n         ").toString())).stripMargin());
        $this.spark().sql("set hoodie.merge.allow.duplicate.on.inserts = false");
        $this.spark().sql(new StringBuilder(218).append("insert into ").append(sourceTable).append(" values(1, 'a1', cast(3.01 as double), 11, '2022-09-26'),(2, 'a2', cast(3.02 as double), 12, '2022-09-27'),(3, 'a3', cast(3.03 as double), 13, '2022-09-28'),(4, 'a4', cast(3.04 as double), 14, '2022-09-29')").toString());
        $this.checkAnswer(new StringBuilder(48).append("select id, name, price, ts, dt from ").append(sourceTable).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)3.01), BoxesRunTime.boxToInteger((int)11), "2022-09-26"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)3.02), BoxesRunTime.boxToInteger((int)12), "2022-09-27"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)3.03), BoxesRunTime.boxToInteger((int)13), "2022-09-28"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)3.04), BoxesRunTime.boxToInteger((int)14), "2022-09-29"}))}));
        String path2 = tmp.getCanonicalPath().concat("/target");
        String destTable = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(388).append("\n           | create table ").append(destTable).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  dt string\n           | ) using hudi\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n           | partitioned by(dt)\n           | location '").append(path2).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(168).append("insert into ").append(destTable).append(" values(1, 'd1', cast(3.01 as double), 11, '2022-09-26'),(2, 'd2', cast(3.02 as double), 12, '2022-09-26'),(3, 'd3', cast(3.03 as double), 13, '2022-09-26')").toString());
        $this.checkAnswer(new StringBuilder(48).append("select id, name, price, ts, dt from ").append(destTable).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "d1", BoxesRunTime.boxToDouble((double)3.01), BoxesRunTime.boxToInteger((int)11), "2022-09-26"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "d2", BoxesRunTime.boxToDouble((double)3.02), BoxesRunTime.boxToInteger((int)12), "2022-09-26"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "d3", BoxesRunTime.boxToDouble((double)3.03), BoxesRunTime.boxToInteger((int)13), "2022-09-26"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(220).append("\n           |merge into ").append(destTable).append(" h0\n           |using (\n           | select id, name, price, ts, dt from ").append(sourceTable).append("\n           | ) s0\n           | on h0.id = s0.id and h0.dt = s0.dt\n           | when matched then update set *\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(48).append("select id, name, price, ts, dt from ").append(destTable).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)3.01), BoxesRunTime.boxToInteger((int)11), "2022-09-26"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "d2", BoxesRunTime.boxToDouble((double)3.02), BoxesRunTime.boxToInteger((int)12), "2022-09-26"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "d3", BoxesRunTime.boxToDouble((double)3.03), BoxesRunTime.boxToInteger((int)13), "2022-09-26"}))}));
        $this.checkAnswer(new StringBuilder(16).append("show partitions ").append(destTable).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"dt=2022-09-26", (List)Nil$.MODULE$)}));
    }

    public static final /* synthetic */ void $anonfun$new$37(TestMergeIntoTable2 $this, String tableType) {
        ((IterableLike)new .colon.colon((Object)"COMMIT_TIME_ORDERING", (List)new .colon.colon((Object)"EVENT_TIME_ORDERING", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)mergeMode -> {
            $this.withRecordType($this.withRecordType$default$1(), $this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                $this.withSparkSqlSessionConfig((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.ENABLE_MERGE_INTO_PARTIAL_UPDATES().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    Dataset dataset;
                    $this.log().info(new StringBuilder(36).append("Testing table type ").append(tableType$3).append(" with merge mode ").append(mergeMode$1).toString());
                    String tableName = $this.generateTableName();
                    $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(510).append("\n                 |create table ").append(tableName).append(" (\n                 |  id int,\n                 |  name string,\n                 |  price double,\n                 |  ts int,\n                 |  dt string\n                 |) using hudi\n                 | tblproperties (\n                 |  type = '").append(tableType$3).append("',\n                 |  primaryKey = 'id',\n                 |  preCombineField = 'ts',\n                 |  recordMergeMode = '").append(mergeMode$1).append("'\n                 | )\n                 | partitioned by(dt)\n                 | location '").append(tmp.getCanonicalPath()).append("'\n           ").toString())).stripMargin());
                    $this.spark().sql(new StringBuilder(53).append("insert into ").append(tableName).append(" values (1, 'a1', 10, 1000, '2021-03-21')").toString());
                    if (tableType$3.equals("mor")) {
                        $this.checkException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(516).append("\n                   |merge into ").append(tableName).append(" as t0\n                   |using (\n                   |  select 1 as id, 'a1' as name, 11 as price, 1001 as ts, '2021-03-21' as dt\n                   |) as s0\n                   |on t0.id = s0.id\n                   |when matched and s0.id = 1 then update set\n                   |  name = s0.name,\n                   |  price = s0.price,\n                   |  ts = s0.ts,\n                   |  dt = s0.dt\n                   |when matched and s0.id = 2 then update set *\n               ").toString())).stripMargin(), "No matching assignment found for target table record key field `id`");
                        $this.checkException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(437).append("\n                   |merge into ").append(tableName).append(" as t0\n                   |using (\n                   |  select 1 as id, 'a1' as name, 11 as price, 1001 as ts, '2021-03-21' as dt\n                   |) as s0\n                   |on t0.id = s0.id\n                   |when matched then update set\n                   |  name = s0.name,\n                   |  price = s0.price,\n                   |  ts = s0.ts,\n                   |  dt = s0.dt\n               ").toString())).stripMargin(), "No matching assignment found for target table record key field `id`");
                    }
                    $this.checkException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(438).append("\n                 |merge into ").append(tableName).append(" as t0\n                 |using (\n                 |  select 2 as id, 'a2' as name, 12 as price, 1002 as ts, '2021-03-21' as dt\n                 |) as s0\n                 |on t0.id = s0.id\n                 |when not matched and s0.id = 1 then insert (name, price, ts, dt)\n                 |values (s0.name, s0.price, s0.ts, s0.dt)\n                 |when not matched and s0.id = 2 then insert *\n               ").toString())).stripMargin(), "No matching assignment found for target table record key field `id`");
                    $this.checkException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(361).append("\n                 |merge into ").append(tableName).append(" as t0\n                 |using (\n                 |  select 2 as id, 'a2' as name, 12 as price, 1002 as ts, '2021-03-21' as dt\n                 |) as s0\n                 |on t0.id = s0.id\n                 |when not matched then insert (name, price, ts, dt)\n                 |values (s0.name, s0.price, s0.ts, s0.dt)\n               ").toString())).stripMargin(), "No matching assignment found for target table record key field `id`");
                    String mergeStmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(438).append("\n                 |merge into ").append(tableName).append(" as t0\n                 |using (\n                 |  select 2 as id, 'a2' as name, 12 as price, 1002 as ts, '2021-03-21' as dt\n                 |) as s0\n                 |on t0.id = s0.id\n                 |when not matched and s0.id = 1 then insert (id, name, price, dt)\n                 |values (s0.id, s0.name, s0.price, s0.dt)\n                 |when not matched and s0.id = 2 then insert *\n               ").toString())).stripMargin();
                    String string = mergeMode$1;
                    String string2 = "EVENT_TIME_ORDERING";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        $this.checkException(mergeStmt, "No matching assignment found for target table precombine field `ts`");
                        dataset = BoxedUnit.UNIT;
                    } else {
                        dataset = $this.spark().sql(mergeStmt);
                    }
                    String string3 = mergeMode$1;
                    String string4 = "COMMIT_TIME_ORDERING";
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                        $this.checkAnswer(new StringBuilder(48).append("select id, name, price, ts, dt from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1002), "2021-03-21"}))}));
                        return;
                    }
                    $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021-03-21"}))}));
                });
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$45(TestMergeIntoTable2 $this, File tmp$2, String tableType) {
        ((IterableLike)new .colon.colon((Object)"COMMIT_TIME_ORDERING", (List)new .colon.colon((Object)"EVENT_TIME_ORDERING", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)mergeMode -> {
            $this.withSparkSqlSessionConfig((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.ENABLE_MERGE_INTO_PARTIAL_UPDATES().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String tableName = $this.generateTableName();
                $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(480).append("\n                 |create table ").append(tableName).append(" (\n                 |  id int,\n                 |  name string,\n                 |  value int,\n                 |  ts int\n                 |) using hudi\n                 | location '").append(tmp$2.getCanonicalPath()).append("/").append(tableName).append("'\n                 | partitioned by(value)\n                 | tblproperties (\n                 |  type = '").append(tableType$4).append("',\n                 |  primaryKey ='id',\n                 |  preCombineField = 'ts',\n                 |  recordMergeMode = '").append(mergeMode).append("'\n                 | )\n            ").toString())).stripMargin());
                $this.spark().sql(new StringBuilder(66).append("insert into ").append(tableName).append(" select 1 as id, 'a1' as name, 10 as value, 1000 as ts").toString());
                $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(247).append("\n                 |merge into ").append(tableName).append(" h0\n                 |using (\n                 |  select 1 as id, 1003 as ts\n                 | ) s0\n                 | on h0.id = s0.id\n                 | when matched then update set h0.id = s0.id\n                 |").toString())).stripMargin());
                $this.checkAnswer(new StringBuilder(32).append("select id, name, value, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000)}))}));
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$44(TestMergeIntoTable2 $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestMergeIntoTable2.$anonfun$new$45($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$51(TestMergeIntoTable2 $this, String tableType$5, File tmp$3, String recordMergeMode) {
        String sourceTable = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(309).append("\n               |CREATE TABLE ").append(sourceTable).append(" (\n               |    id INT,\n               |    name STRING,\n               |    price INT,\n               |    ts BIGINT\n               |) USING hudi\n               | tblproperties (\n               |  type = '").append(tableType$5).append("'\n               | )\n               |LOCATION '").append(tmp$3.getCanonicalPath()).append("/").append(sourceTable).append("'\n               |").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(147).append("\n               | INSERT INTO ").append(sourceTable).append("\n               | VALUES (1, 'John Doe', 19, 1),\n               |        (4, 'Alice Johnson', 49, 2)\n               |").toString())).stripMargin());
        String targetTable = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(419).append("\n               |create table ").append(targetTable).append(" (\n               |  id INT,\n               |  name STRING,\n               |  price INT,\n               |  ts BIGINT\n               |) using hudi\n               |TBLPROPERTIES (\n               |  type = '").append(tableType$5).append("',\n               |  primaryKey = 'id',\n               |  preCombineField = 'ts',\n               |  recordMergeMode = '").append(recordMergeMode).append("'\n               | )\n               |LOCATION '").append(tmp$3.getCanonicalPath()).append("/").append(targetTable).append("'\n               |").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(395).append("\n               |INSERT INTO ").append(targetTable).append("\n               |SELECT id, name, price, ts\n               |FROM (\n               |    SELECT 1 as id, 'John Doe' as name, 19 as price, 1598886001 as ts\n               |     UNION ALL\n               |     SELECT 2, 'Jane Doe', 24, 1598972400\n               |     UNION ALL\n               |     SELECT 3, 'Bob Smith', 14, 1599058800\n               |)\n               |").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(455).append("\n               |MERGE INTO ").append(targetTable).append(" t\n               |USING ").append(sourceTable).append(" s\n               |ON t.price = s.price\n               |WHEN MATCHED THEN UPDATE SET\n               |    t.id = s.id,\n               |    t.name = s.name,\n               |    t.price = s.price,\n               |    t.ts = s.ts\n               |WHEN NOT MATCHED THEN INSERT\n               |    (id, name, price, ts)\n               |VALUES\n               |    (s.id, s.name, s.price, s.ts)\n               |").toString())).stripMargin());
        Seq[] seqArray = new Seq[4];
        Object[] objectArray = new Object[4];
        objectArray[0] = BoxesRunTime.boxToInteger((int)1);
        objectArray[1] = "John Doe";
        objectArray[2] = BoxesRunTime.boxToInteger((int)19);
        String string = recordMergeMode;
        String string2 = RecordMergeMode.EVENT_TIME_ORDERING.name();
        objectArray[3] = !(string != null ? !string.equals(string2) : string2 != null) ? BoxesRunTime.boxToLong((long)1598886001L) : BoxesRunTime.boxToLong((long)1L);
        seqArray[0] = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray));
        seqArray[1] = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Jane Doe", BoxesRunTime.boxToInteger((int)24), BoxesRunTime.boxToLong((long)1598972400L)}));
        seqArray[2] = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Bob Smith", BoxesRunTime.boxToInteger((int)14), BoxesRunTime.boxToLong((long)1599058800L)}));
        seqArray[3] = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "Alice Johnson", BoxesRunTime.boxToInteger((int)49), BoxesRunTime.boxToLong((long)2L)}));
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(targetTable).append(" ORDER BY id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])seqArray));
    }

    public static final /* synthetic */ void $anonfun$new$50(TestMergeIntoTable2 $this, String tableType$5, File tmp) {
        ((IterableLike)new .colon.colon((Object)RecordMergeMode.COMMIT_TIME_ORDERING.name(), (List)new .colon.colon((Object)RecordMergeMode.EVENT_TIME_ORDERING.name(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)recordMergeMode -> {
            TestMergeIntoTable2.$anonfun$new$51($this, tableType$5, tmp, recordMergeMode);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$55(TestMergeIntoTable2 $this, File tmp$4, String tableType) {
        String sourceTable = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(276).append("\n            |CREATE TABLE ").append(sourceTable).append(" (\n            |    id INT,\n            |    name STRING,\n            |    price INT,\n            |    ts BIGINT\n            |) USING hudi\n            | tblproperties (\n            |  type = '").append(tableType).append("'\n            | )\n            |LOCATION '").append(tmp$4.getCanonicalPath()).append("/").append(sourceTable).append("'\n            |").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(214).append("\n            | INSERT INTO ").append(sourceTable).append("\n            | VALUES (1, 'John Doe Updated', 19, 1598886001),\n            |        (2, 'Jane Doe Updated', 24, 1598972401),\n            |        (4, 'Alice Johnson', 49, 2)\n            |").toString())).stripMargin());
        String targetTable = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(552).append("\n            |create table ").append(targetTable).append(" (\n            |  id INT,\n            |  name STRING,\n            |  price INT,\n            |  ts BIGINT\n            |) using hudi\n            |TBLPROPERTIES (\n            |  type = 'cow',\n            |  primaryKey = 'id',\n            |  preCombineField = 'ts',\n            |  recordMergeMode = '").append(RecordMergeMode.CUSTOM.name()).append("',\n            |  'hoodie.datasource.write.payload.class'='org.apache.hudi.common.model.FirstValueAvroPayload',\n            |  hoodie.datasource.write.recordkey.field = 'id'\n            | )\n            |LOCATION '").append(tmp$4.getCanonicalPath()).append("/").append(targetTable).append("'\n            |").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(373).append("\n            |INSERT INTO ").append(targetTable).append("\n            |SELECT id, name, price, ts\n            |FROM (\n            |    SELECT 1 as id, 'John Doe Initial' as name, 19 as price, 1598886001 as ts\n            |     UNION ALL\n            |     SELECT 2, 'Jane Doe', 24, 1598972400\n            |     UNION ALL\n            |     SELECT 3, 'Bob Smith', 14, 1599058800\n            |)\n            |").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(416).append("\n            |MERGE INTO ").append(targetTable).append(" t\n            |USING ").append(sourceTable).append(" s\n            |ON t.price = s.price\n            |WHEN MATCHED THEN UPDATE SET\n            |    t.id = s.id,\n            |    t.name = s.name,\n            |    t.price = s.price,\n            |    t.ts = s.ts\n            |WHEN NOT MATCHED THEN INSERT\n            |    (id, name, price, ts)\n            |VALUES\n            |    (s.id, s.name, s.price, s.ts)\n            |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(targetTable).append(" ORDER BY id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "John Doe Initial", BoxesRunTime.boxToInteger((int)19), BoxesRunTime.boxToLong((long)1598886001L)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "Jane Doe Updated", BoxesRunTime.boxToInteger((int)24), BoxesRunTime.boxToLong((long)1598972401L)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "Bob Smith", BoxesRunTime.boxToInteger((int)14), BoxesRunTime.boxToLong((long)1599058800L)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "Alice Johnson", BoxesRunTime.boxToInteger((int)49), BoxesRunTime.boxToLong((long)2L)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$54(TestMergeIntoTable2 $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestMergeIntoTable2.$anonfun$new$55($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public TestMergeIntoTable2() {
        this.test("Test MergeInto for MOR table 2", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringBuilder(8).append("set ").append(HoodieWriteConfig.MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT.key()).append(" = 0").toString());
            this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestMergeIntoTable2.$anonfun$new$3(this, tmp);
                return BoxedUnit.UNIT;
            }));
        }, new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        this.test("Test Merge Into CTAS Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable2.$anonfun$new$5(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        this.test("Test Merge With Complex Data Type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringBuilder(8).append("set ").append(HoodieWriteConfig.MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT.key()).append(" = 0").toString());
            this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestMergeIntoTable2.$anonfun$new$8(this, tmp);
                return BoxedUnit.UNIT;
            }));
        }, new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.test("Test column name matching for insert * and update set *", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable2.$anonfun$new$10(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
        this.test("Test MergeInto For Source Table With Column Aliases", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable2.$anonfun$new$12(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
        this.test("Test only insert when source table contains history", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable2.$anonfun$new$14(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 563));
        this.test("Test only insert when source table contains history and target table has multiple keys", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable2.$anonfun$new$17(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 609));
        this.test("Test Merge Into For Source Table With Different Column Order", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringBuilder(8).append("set ").append(HoodieWriteConfig.MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT.key()).append(" = 0").toString());
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestMergeIntoTable2.$anonfun$new$19(this, tmp);
                return BoxedUnit.UNIT;
            });
        }, new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 656));
        this.test("Test Merge into with String cast to Double", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable2.$anonfun$new$22(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 695));
        this.test("Test Merge into where manually set DefaultHoodieRecordPayload", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable2.$anonfun$new$25(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 735));
        this.test("Test only insert for source table in dup key with preCombineField", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringBuilder(8).append("set ").append(HoodieWriteConfig.MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT.key()).append(" = 0").toString());
            ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
                this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                    TestMergeIntoTable2.$anonfun$new$28($this, tableType, tmp);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 773));
        this.test("Test only insert for source table in dup key without preCombineField", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringBuilder(7).append("set ").append(HoodieWriteConfig.MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT.key()).append(" = ").append(HoodieWriteConfig.MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT.defaultValue()).toString());
            ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
                this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                    TestMergeIntoTable2.$anonfun$new$31($this, tableType, tmp);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 839));
        this.test("Test Merge into with RuntimeReplaceable func such as nvl", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable2.$anonfun$new$33(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 906));
        this.test("Test MOR Table with create empty partitions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable2.$anonfun$new$35(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 954));
        this.test("Test MergeInto Anti-Patterns of assignment clauses", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestMergeIntoTable2.$anonfun$new$37(this, tableType);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1036));
        this.test("Test merge into Allowed-patterns of assignment clauses", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable2.$anonfun$new$44(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1167));
        this.test("Test MergeInto with commit time/event time ordering coverage", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestMergeIntoTable2.$anonfun$new$50($this, tableType, tmp);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1219));
        this.test("Test MergeInto with CUSTOM merge mode using FirstValueAvroPayload", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable2.$anonfun$new$54(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestMergeIntoTable2.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1303));
    }
}

