/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.dml;

import java.io.File;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Y2Aa\u0001\u0003\u0001#!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C\u0001;\t\u0011C+Z:u#V,'/_'fe\u001e,wJ\u001c*fC\u0012|\u0005\u000f^5nSj,G\rV1cY\u0016T!!\u0002\u0004\u0002\u0007\u0011lGN\u0003\u0002\b\u0011\u0005!\u0001.\u001e3j\u0015\tI!\"A\u0002tc2T!a\u0003\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\r\u000511m\\7n_:L!a\u0006\u000b\u0003-!{w\u000eZ5f'B\f'o[*rYR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#\u0001\u000e\u0011\u0005m\u0001Q\"\u0001\u0003\u0002#\u0005\u001c8/\u001a:u#V,'/\u001f*fgVdG\u000fF\u0002\u001fI%\u0002\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012A!\u00168ji\")QE\u0001a\u0001M\u0005AQ\r\u001f9fGR,G\r\u0005\u0002 O%\u0011\u0001\u0006\t\u0002\u0004\u0003:L\b\"\u0002\u0016\u0003\u0001\u0004Y\u0013!\u0003;bE2,\u0007+\u0019;i!\ta3G\u0004\u0002.cA\u0011a\u0006I\u0007\u0002_)\u0011\u0001\u0007E\u0001\u0007yI|w\u000e\u001e \n\u0005I\u0002\u0013A\u0002)sK\u0012,g-\u0003\u00025k\t11\u000b\u001e:j]\u001eT!A\r\u0011")
public class TestQueryMergeOnReadOptimizedTable
extends HoodieSparkSqlTestBase {
    public void assertQueryResult(Object expected, String tablePath) {
        long actual = this.spark().read().format("org.apache.hudi").option("hoodie.datasource.query.type", "read_optimized").load(tablePath).count();
        this.assertResult(expected, BoxesRunTime.boxToLong((long)actual), Prettifier$.MODULE$.default(), new Position("TestQueryMergeOnReadOptimizedTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
    }

    public static final /* synthetic */ void $anonfun$new$2(TestQueryMergeOnReadOptimizedTable $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(397).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  partition long\n           |) using hudi\n           | partitioned by (partition)\n           | location '").append(tablePath).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql("set hoodie.parquet.max.file.size = 10000");
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000, 1000)").toString());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1000, 1000)").toString());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1000, 1000)").toString());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(4, 'a4', 10, 1000, 1000)").toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 11 where id = 1").toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 21 where id = 2").toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 31 where id = 3").toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 41 where id = 4").toString());
        $this.assertQueryResult(BoxesRunTime.boxToInteger((int)4), tablePath);
        $this.spark().sql(new StringBuilder(50).append("call run_compaction(op => 'schedule', table => '").append(tableName).append("')").toString()).collect();
        $this.assertQueryResult(BoxesRunTime.boxToInteger((int)4), tablePath);
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(5, 'a5', 10, 1000, 1000)").toString());
        $this.assertQueryResult(BoxesRunTime.boxToInteger((int)5), tablePath);
        $this.spark().sql(new StringBuilder(45).append("call run_compaction(op => 'run', table => '").append(tableName).append("')").toString()).collect();
        $this.assertQueryResult(BoxesRunTime.boxToInteger((int)5), tablePath);
    }

    public TestQueryMergeOnReadOptimizedTable() {
        this.test("Test Query Merge_On_Read Read_Optimized table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)tmp -> {
            TestQueryMergeOnReadOptimizedTable.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestQueryMergeOnReadOptimizedTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 23));
    }
}

