/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.dml;

import java.io.File;
import java.io.Serializable;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.junit.jupiter.api.Assertions;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001m1AAA\u0002\u0001!!)q\u0003\u0001C\u00011\tyA+Z:u+B$\u0017\r^3UC\ndWM\u0003\u0002\u0005\u000b\u0005\u0019A-\u001c7\u000b\u0005\u00199\u0011\u0001\u00025vI&T!\u0001C\u0005\u0002\u0007M\fHN\u0003\u0002\u000b\u0017\u0005)1\u000f]1sW*\u0011A\"D\u0001\u0007CB\f7\r[3\u000b\u00039\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I)R\"A\n\u000b\u0005Q)\u0011AB2p[6|g.\u0003\u0002\u0017'\t1\u0002j\\8eS\u0016\u001c\u0006/\u0019:l'FdG+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011!\u0004A\u0007\u0002\u0007\u0001")
public class TestUpdateTable
extends HoodieSparkSqlTestBase {
    public static final /* synthetic */ void $anonfun$new$5(TestUpdateTable $this, File tmp$1, boolean sparkSqlOptimizedWrites$1, String tableType) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(375).append("\n               |create table ").append(tableName).append(" (\n               |  id int,\n               |  name string,\n               |  price double,\n               |  ts long\n               |) using hudi\n               | location '").append(tmp$1.getCanonicalPath()).append("/").append(tableName).append("'\n               | tblproperties (\n               |  type = '").append(tableType).append("',\n               |  primaryKey = 'id',\n               |  preCombineField = 'ts'\n               | )\n         ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(37).append("insert into ").append(tableName).append(" select 1, 'a1', 10, 1000").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringBuilder(5).append("set ").append(DataSourceWriteOptions$.MODULE$.SPARK_SQL_OPTIMIZED_WRITES().key()).append("=").append(sparkSqlOptimizedWrites$1).toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 20 where id = 1").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringBuilder(42).append("update ").append(tableName).append(" set price = price * 2 where id = 1").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)40.0), BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$4(TestUpdateTable $this, File tmp$1, boolean sparkSqlOptimizedWrites) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestUpdateTable.$anonfun$new$5($this, tmp$1, sparkSqlOptimizedWrites, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$3(TestUpdateTable $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)sparkSqlOptimizedWrites -> {
            TestUpdateTable.$anonfun$new$4($this, tmp, BoxesRunTime.unboxToBoolean((Object)sparkSqlOptimizedWrites));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$10(TestUpdateTable $this, File tmp$2, String tableType$1, boolean isPartitioned) {
        String tableName = $this.generateTableName();
        String partitionedClause = isPartitioned ? "PARTITIONED BY (name)" : "";
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(359).append("\n               |create table ").append(tableName).append(" (\n               |  id int,\n               |  price double,\n               |  ts long,\n               |  name string\n               |) using hudi\n               | location '").append(tmp$2.getCanonicalPath()).append("/").append(tableName).append("'\n               | tblproperties (\n               |  type = '").append(tableType$1).append("',\n               |  preCombineField = 'ts'\n               | )\n               | ").append(partitionedClause).append("\n            ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(36).append("insert into ").append(tableName).append(" select 1,10, 1000, 'a1'").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringBuilder(9).append("set ").append(DataSourceWriteOptions$.MODULE$.SPARK_SQL_OPTIMIZED_WRITES().key()).append("=true").toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 20 where id = 1").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringBuilder(42).append("update ").append(tableName).append(" set price = price * 2 where id = 1").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)40.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        if (tableType$1.equals(HoodieTableType.MERGE_ON_READ)) {
            $this.spark().sql(new StringBuilder(42).append("update ").append(tableName).append(" set price = price * 2 where id = 1").toString());
            $this.spark().sql(new StringBuilder(42).append("update ").append(tableName).append(" set price = price * 2 where id = 1").toString());
            $this.spark().sql(new StringBuilder(42).append("update ").append(tableName).append(" set price = price * 2 where id = 1").toString());
            HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)new StringBuilder(1).append(tmp$2.getCanonicalPath()).append("/").append(tableName).toString());
            Assertions.assertEquals((Object)((HoodieInstant)((Pair)metaClient.getActiveTimeline().getLastCommitMetadataWithValidData().get()).getLeft()).getAction(), (Object)"commit");
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$new$9(TestUpdateTable $this, File tmp$2, String tableType) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)isPartitioned -> {
            TestUpdateTable.$anonfun$new$10($this, tmp$2, tableType, BoxesRunTime.unboxToBoolean((Object)isPartitioned));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$8(TestUpdateTable $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestUpdateTable.$anonfun$new$9($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$14(TestUpdateTable $this, File tmp$3, String tableType) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(349).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | location '").append(tmp$3.getCanonicalPath()).append("/").append(tableName).append("'\n             | tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(64).append("insert into ").append(tableName).append(" values (1, 'a1', 10.0, 1000), (2, 'a2', 20.0, 1000)").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringBuilder(53).append("update ").append(tableName).append(" set price = 11.0, ts = 1001 where name = 'a1'").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)11.0), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        String ptTableName = new StringBuilder(3).append($this.generateTableName()).append("_pt").toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(414).append("\n             |create table ").append(ptTableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long,\n             |  pt string\n             |) using hudi\n             | location '").append(tmp$3.getCanonicalPath()).append("/").append(ptTableName).append("'\n             | tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n             | partitioned by (pt)\n          ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(155).append("\n             |insert into ").append(ptTableName).append("\n             |values (1, 'a1', 10.0, 1000, \"2021\"), (2, 'a2', 20.0, 1000, \"2021\"), (3, 'a2', 30.0, 1000, \"2022\")\n             |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, pt from ").append(ptTableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1000), "2021"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a2", BoxesRunTime.boxToDouble((double)30.0), BoxesRunTime.boxToInteger((int)1000), "2022"}))}));
        $this.spark().sql(new StringBuilder(62).append("update ").append(ptTableName).append(" set price = price * 1.1, ts = ts + 1 where name = 'a2'").toString());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, pt from ").append(ptTableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)22.0), BoxesRunTime.boxToInteger((int)1001), "2021"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a2", BoxesRunTime.boxToDouble((double)33.0), BoxesRunTime.boxToInteger((int)1001), "2022"}))}));
        $this.spark().sql(new StringBuilder(60).append("update ").append(ptTableName).append(" set price = price + 5, ts = ts + 1 where pt = '2021'").toString());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, pt from ").append(ptTableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)15.0), BoxesRunTime.boxToInteger((int)1001), "2021"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)27.0), BoxesRunTime.boxToInteger((int)1002), "2021"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a2", BoxesRunTime.boxToDouble((double)33.0), BoxesRunTime.boxToInteger((int)1001), "2022"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$13(TestUpdateTable $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestUpdateTable.$anonfun$new$14($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$17(TestUpdateTable $this, File tmp$4, String tableType) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(343).append("\n             |create table ").append(tableName).append(" (\n             |  ID int,\n             |  NAME string,\n             |  PRICE double,\n             |  TS long\n             |) using hudi\n             | location '").append(tmp$4.getCanonicalPath()).append("/").append(tableName).append("'\n             | options (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'ID',\n             |  preCombineField = 'TS'\n             | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(37).append("insert into ").append(tableName).append(" select 1, 'a1', 10, 1000").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set PRICE = 20 where ID = 1").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringBuilder(42).append("update ").append(tableName).append(" set PRICE = PRICE * 2 where ID = 1").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)40.0), BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$16(TestUpdateTable $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestUpdateTable.$anonfun$new$17($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$20(TestUpdateTable $this, File tmp$5, boolean sparkSqlOptimizedWrites) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(386).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long,\n             |  ff decimal(38, 10)\n             |) using hudi\n             | location '").append(tmp$5.getCanonicalPath()).append("/").append(tableName).append("'\n             | tblproperties (\n             |  type = 'mor',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n     ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(43).append("insert into ").append(tableName).append(" select 1, 'a1', 10, 1000, 10.0").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringBuilder(5).append("set ").append(DataSourceWriteOptions$.MODULE$.SPARK_SQL_OPTIMIZED_WRITES().key()).append("=").append(sparkSqlOptimizedWrites).toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 22 where id = 1").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)22.0), BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$19(TestUpdateTable $this, File tmp) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)sparkSqlOptimizedWrites -> {
            TestUpdateTable.$anonfun$new$20($this, tmp, BoxesRunTime.unboxToBoolean((Object)sparkSqlOptimizedWrites));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$23(TestUpdateTable $this, File tmp$6, String tableType) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp$6.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(524).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long,\n             |  partition long\n             |) using hudi\n             | partitioned by (partition)\n             | location '").append(basePath).append("'\n             | tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts',\n             |  hoodie.clustering.keygen.class = \"org.apache.hudi.keygen.NonpartitionedKeyGenerator\"\n             | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000, 1000)").toString());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1001, 1001)").toString());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1002, 1002)").toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 20 where id > 1").toString());
        $this.checkAnswer(new StringBuilder(45).append("select id, name, price, ts from ").append(tableName).append(" where id > 1").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1002)}))}));
        $this.spark().sql(new StringBuilder(42).append("update ").append(tableName).append(" set price = price * 2 where id = 2").toString());
        $this.checkAnswer(new StringBuilder(45).append("select id, name, price, ts from ").append(tableName).append(" where id = 2").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)40.0), BoxesRunTime.boxToInteger((int)1001)}))}));
        SparkRDDWriteClient client = HoodieCLIUtils$.MODULE$.createHoodieWriteClient($this.spark(), basePath, Predef$.MODULE$.Map().empty(), Option$.MODULE$.apply((Object)tableName));
        String firstScheduleInstant = client.createNewInstantTime();
        client.scheduleClusteringAtInstant(firstScheduleInstant, Option.empty());
        $this.checkAnswer(new StringBuilder(65).append("call show_clustering(path => '").append(basePath).append("', show_involved_partition => true)").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{firstScheduleInstant, BoxesRunTime.boxToInteger((int)3), HoodieInstant.State.REQUESTED.name(), "partition=1000,partition=1001,partition=1002"}))}));
        $this.checkAnswer(new StringBuilder(53).append("call run_clustering(path => '").append(basePath).append("', order => 'partition')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{firstScheduleInstant, BoxesRunTime.boxToInteger((int)3), HoodieInstant.State.COMPLETED.name(), "*"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$22(TestUpdateTable $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestUpdateTable.$anonfun$new$23($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$27(TestUpdateTable $this, File tmp$7, String tableType) {
        Assertion assertion;
        Assertion assertion2;
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(411).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long,\n             |  pt string\n             |) using hudi\n             | location '").append(tmp$7.getCanonicalPath()).append("/").append(tableName).append("'\n             | tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n             | partitioned by (pt)\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(49).append("insert into ").append(tableName).append(" values (1, 'a1', 10.0, 1000, '2021')").toString());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, pt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021"}))}));
        AnalysisException e1 = (AnalysisException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql(new StringBuilder(31).append("update ").append(tableName).append(" set id = 2 where id = 1").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("TestUpdateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
        if (HoodieSparkUtils$.MODULE$.gteqSpark3_4()) {
            String $org_scalatest_assert_macro_left = e1.getMessage();
            String $org_scalatest_assert_macro_right = new StringBuilder(175).append("Detected disallowed assignment clause in UPDATE statement for record key field `id`").append(" for table `spark_catalog.default.").append(tableName).append("`. Please remove the assignment clause to avoid the error.").toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            assertion2 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TestUpdateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 407));
        } else {
            String $org_scalatest_assert_macro_left = e1.getMessage();
            String $org_scalatest_assert_macro_right = new StringBuilder(161).append("Detected disallowed assignment clause in UPDATE statement for record key field `id`").append(" for table `default.").append(tableName).append("`. Please remove the assignment clause to avoid the error.").toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            assertion2 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TestUpdateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 410));
        }
        AnalysisException e2 = (AnalysisException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql(new StringBuilder(36).append("update ").append(tableName).append(" set pt = '2022' where id = 1").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("TestUpdateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
        if (HoodieSparkUtils$.MODULE$.gteqSpark3_4()) {
            String $org_scalatest_assert_macro_left = e2.getMessage();
            String $org_scalatest_assert_macro_right = new StringBuilder(174).append("Detected disallowed assignment clause in UPDATE statement for partition field `pt`").append(" for table `spark_catalog.default.").append(tableName).append("`. Please remove the assignment clause to avoid the error.").toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TestUpdateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
        } else {
            String $org_scalatest_assert_macro_left = e2.getMessage();
            String $org_scalatest_assert_macro_right = new StringBuilder(160).append("Detected disallowed assignment clause in UPDATE statement for partition field `pt`").append(" for table `default.").append(tableName).append("`. Please remove the assignment clause to avoid the error.").toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TestUpdateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
        }
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, pt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2021"}))}));
        $this.spark().sql(new StringBuilder(37).append("update ").append(tableName).append(" set price = 20.0 where id = 1").toString());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, pt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1000), "2021"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$26(TestUpdateTable $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestUpdateTable.$anonfun$new$27($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public TestUpdateTable() {
        this.test("Test Update Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestUpdateTable.$anonfun$new$3(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestUpdateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
        this.test("Test Update Table Without Primary Key", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestUpdateTable.$anonfun$new$8(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestUpdateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        this.test("Test Update Table On Non-PK Condition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestUpdateTable.$anonfun$new$13(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestUpdateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
        this.test("Test ignoring case for Update Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestUpdateTable.$anonfun$new$16(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestUpdateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
        this.test("Test decimal type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestUpdateTable.$anonfun$new$19(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestUpdateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
        this.test("Test Update Table with Clustering", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestUpdateTable.$anonfun$new$22(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestUpdateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
        this.test("Test Update Table With Primary Key and Partition Key Updates error out", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestUpdateTable.$anonfun$new$26(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestUpdateTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
    }
}

