/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.procedure;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.sql.catalyst.plans.logical.CallArgument;
import org.apache.spark.sql.catalyst.plans.logical.CallCommand;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.NamedArgument;
import org.apache.spark.sql.catalyst.plans.logical.PositionalArgument;
import org.apache.spark.sql.hudi.command.procedures.HelpProcedure$;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0005\u000b\u0001]AQA\b\u0001\u0005\u0002}AqA\t\u0001C\u0002\u0013%1\u0005\u0003\u0004,\u0001\u0001\u0006I\u0001\n\u0005\u0006Y\u0001!\t\"\f\u0005\u0006\u0007\u0002!I\u0001\u0012\u0005\u0006\u0007\u0002!I!\u0019\u0005\u0006Q\u0002!I!\u001b\u0005\u0006i\u0002!I!\u001e\u0002\u0016)\u0016\u001cHoQ1mY\u000e{W.\\1oIB\u000b'o]3s\u0015\tYA\"A\u0005qe>\u001cW\rZ;sK*\u0011QBD\u0001\u0005QV$\u0017N\u0003\u0002\u0010!\u0005\u00191/\u001d7\u000b\u0005E\u0011\u0012!B:qCJ\\'BA\n\u0015\u0003\u0019\t\u0007/Y2iK*\tQ#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00011A\u0011\u0011\u0004H\u0007\u00025)\u00111\u0004D\u0001\u0007G>lWn\u001c8\n\u0005uQ\"A\u0006%p_\u0012LWm\u00159be.\u001c\u0016\u000f\u001c+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005\u0001\u0003CA\u0011\u0001\u001b\u0005Q\u0011A\u00029beN,'/F\u0001%!\t)\u0013&D\u0001'\u0015\t\u0011sE\u0003\u0002)\u001d\u0005A1-\u0019;bYf\u001cH/\u0003\u0002+M\ty\u0001+\u0019:tKJLe\u000e^3sM\u0006\u001cW-A\u0004qCJ\u001cXM\u001d\u0011\u00025\rDWmY6QCJ\u001cX-\u0012=dKB$\u0018n\u001c8D_:$\u0018-\u001b8\u0015\u00059\u0012ECA\u00186!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u0011)f.\u001b;\t\u000bY\"\u0001\u0019A\u001c\u0002\u0011\u0015\u0014(o\u001c:Ng\u001e\u0004\"\u0001O \u000f\u0005ej\u0004C\u0001\u001e2\u001b\u0005Y$B\u0001\u001f\u0017\u0003\u0019a$o\\8u}%\u0011a(M\u0001\u0007!J,G-\u001a4\n\u0005\u0001\u000b%AB*ue&twM\u0003\u0002?c!)q\u0002\u0002a\u0001o\u0005A1\r[3dW\u0006\u0013x\rF\u00030\u000b>#\u0016\fC\u0003G\u000b\u0001\u0007q)\u0001\u0003dC2d\u0007C\u0001%N\u001b\u0005I%B\u0001&L\u0003\u001dawnZ5dC2T!\u0001T\u0014\u0002\u000bAd\u0017M\\:\n\u00059K%aC\"bY2\u001cu.\\7b]\u0012DQ\u0001U\u0003A\u0002E\u000bQ!\u001b8eKb\u0004\"\u0001\r*\n\u0005M\u000b$aA%oi\")Q+\u0002a\u0001-\u0006iQ\r\u001f9fGR,GMV1mk\u0016\u0004\"\u0001M,\n\u0005a\u000b$aA!os\")!,\u0002a\u00017\u0006aQ\r\u001f9fGR,G\rV=qKB\u0011AlX\u0007\u0002;*\u0011aLD\u0001\u0006if\u0004Xm]\u0005\u0003Av\u0013\u0001\u0002R1uCRK\b/\u001a\u000b\u0007_\t\u001cGMZ4\t\u000b\u00193\u0001\u0019A$\t\u000bA3\u0001\u0019A)\t\u000b\u00154\u0001\u0019A\u001c\u0002\u0019\u0015D\b/Z2uK\u0012t\u0015-\\3\t\u000bU3\u0001\u0019\u0001,\t\u000bi3\u0001\u0019A.\u0002\u001dQ|7\u000b]1sW2KG/\u001a:bYR\u0019!\u000e\u001d:\u0011\u0005-tW\"\u00017\u000b\u00055<\u0013aC3yaJ,7o]5p]NL!a\u001c7\u0003\u000f1KG/\u001a:bY\")\u0011o\u0002a\u0001-\u0006)a/\u00197vK\")1o\u0002a\u00017\u0006AA-\u0019;b)f\u0004X-A\u0005dQ\u0016\u001c7nQ1tiV\u0011a/\u001f\u000b\u0005o~\f\t\u0001\u0005\u0002ys2\u0001A!\u0002>\t\u0005\u0004Y(!\u0001+\u0012\u0005q4\u0006C\u0001\u0019~\u0013\tq\u0018GA\u0004O_RD\u0017N\\4\t\u000bED\u0001\u0019\u0001,\t\u000f\u0005\r\u0001\u00021\u0001\u0002\u0006\u0005iQ\r\u001f9fGR,Gm\u00117bgN\u0004B\u0001OA\u0004o&\u0019\u0011\u0011B!\u0003\u000b\rc\u0017m]:")
public class TestCallCommandParser
extends HoodieSparkSqlTestBase {
    private final ParserInterface parser = this.spark().sessionState().sqlParser();

    private ParserInterface parser() {
        return this.parser;
    }

    public void checkParseExceptionContain(String sql, String errorMsg) {
        LogicalPlan logicalPlan;
        boolean hasException = false;
        try {
            logicalPlan = this.parser().parsePlan(sql);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && (throwable2 = throwable3).getMessage().contains(errorMsg)) {
                hasException = true;
                logicalPlan = BoxedUnit.UNIT;
            }
            if (throwable3 != null) {
                Throwable throwable4 = throwable3;
                throw this.fail(new StringBuilder(43).append("Exception should contain: ").append(errorMsg).append(", error message: ").append(throwable4.getMessage()).toString(), throwable4, new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            }
            throw throwable;
        }
        this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)hasException), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
    }

    private void checkArg(CallCommand call, int index, Object expectedValue, DataType expectedType) {
        this.checkArg(call, index, null, expectedValue, expectedType);
    }

    private void checkArg(CallCommand call, int index, String expectedName, Object expectedValue, DataType expectedType) {
        PositionalArgument positionalArgument;
        if (expectedName != null) {
            NamedArgument arg = this.checkCast(call.args().apply(index), NamedArgument.class);
            positionalArgument = this.assertResult(expectedName, arg.name(), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        } else {
            CallArgument arg = (CallArgument)call.args().apply(index);
            positionalArgument = this.checkCast(arg, PositionalArgument.class);
        }
        Literal expectedExpr = this.toSparkLiteral(expectedValue, expectedType);
        Expression actualExpr = ((CallArgument)call.args().apply(index)).expr();
        this.assertResult(expectedExpr.dataType(), actualExpr.dataType(), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
    }

    private Literal toSparkLiteral(Object value, DataType dataType) {
        return Literal$.MODULE$.create(value, dataType);
    }

    private <T> T checkCast(Object value, Class<T> expectedClass) {
        this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)expectedClass.isInstance(value)), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        return expectedClass.cast(value);
    }

    public TestCallCommandParser() {
        this.test("Test Call Produce with Positional Arguments", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CallCommand call = (CallCommand)this.parser().parsePlan(new StringBuilder(50).append("CALL c.n.").append(HelpProcedure$.MODULE$.NAME()).append("(1, '2', 3L, true, 1.0D, 9.0e1, 900e-1BD)").toString());
            this.assertResult(CollectionUtils.createImmutableList((Object[])new String[]{"c", "n", HelpProcedure$.MODULE$.NAME()}), JavaConverters$.MODULE$.seqAsJavaListConverter(call.name()).asJava(), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
            this.assertResult(BoxesRunTime.boxToInteger((int)7), BoxesRunTime.boxToInteger((int)call.args().size()), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
            this.checkArg(call, 0, BoxesRunTime.boxToInteger((int)1), DataTypes.IntegerType);
            this.checkArg(call, 1, "2", DataTypes.StringType);
            this.checkArg(call, 2, BoxesRunTime.boxToLong((long)3L), DataTypes.LongType);
            this.checkArg(call, 3, BoxesRunTime.boxToBoolean((boolean)true), DataTypes.BooleanType);
            this.checkArg(call, 4, BoxesRunTime.boxToDouble((double)1.0), DataTypes.DoubleType);
            this.checkArg(call, 5, BoxesRunTime.boxToDouble((double)90.0), DataTypes.DoubleType);
            this.checkArg(call, 6, new BigDecimal("900e-1"), (DataType)DataTypes.createDecimalType((int)3, (int)1));
        }, new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        this.test("Test Call Produce with Named Arguments", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CallCommand call = (CallCommand)this.parser().parsePlan(new StringBuilder(44).append("CALL system.").append(HelpProcedure$.MODULE$.NAME()).append("(c1 => 1, c2 => '2', c3 => true)").toString());
            this.assertResult(CollectionUtils.createImmutableList((Object[])new String[]{"system", HelpProcedure$.MODULE$.NAME()}), JavaConverters$.MODULE$.seqAsJavaListConverter(call.name()).asJava(), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            this.assertResult(BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)call.args().size()), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            this.checkArg(call, 0, "c1", BoxesRunTime.boxToInteger((int)1), DataTypes.IntegerType);
            this.checkArg(call, 1, "c2", "2", DataTypes.StringType);
            this.checkArg(call, 2, "c3", BoxesRunTime.boxToBoolean((boolean)true), DataTypes.BooleanType);
        }, new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        this.test("Test Call Produce with Var Substitution", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CallCommand call = (CallCommand)this.parser().parsePlan(new StringBuilder(35).append("CALL system.").append(HelpProcedure$.MODULE$.NAME()).append("('${spark.extra.prop}')").toString());
            this.assertResult(CollectionUtils.createImmutableList((Object[])new String[]{"system", HelpProcedure$.MODULE$.NAME()}), JavaConverters$.MODULE$.seqAsJavaListConverter(call.name()).asJava(), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)call.args().size()), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            this.checkArg(call, 0, "value", DataTypes.StringType);
        }, new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("Test Call Produce with Mixed Arguments", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CallCommand call = (CallCommand)this.parser().parsePlan(new StringBuilder(26).append("CALL system.").append(HelpProcedure$.MODULE$.NAME()).append("(c1 => 1, '2')").toString());
            this.assertResult(CollectionUtils.createImmutableList((Object[])new String[]{"system", HelpProcedure$.MODULE$.NAME()}), JavaConverters$.MODULE$.seqAsJavaListConverter(call.name()).asJava(), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)call.args().size()), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            this.checkArg(call, 0, "c1", BoxesRunTime.boxToInteger((int)1), DataTypes.IntegerType);
            this.checkArg(call, 1, "2", DataTypes.StringType);
        }, new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("Test Call Parse Error", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkParseExceptionContain("CALL cat.system radish kebab", "Syntax error at or near 'CALL'"), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        this.test("Test Call Produce with semicolon", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CallCommand call = (CallCommand)this.parser().parsePlan(new StringBuilder(44).append("CALL system.").append(HelpProcedure$.MODULE$.NAME()).append("(c1 => 1, c2 => '2', c3 => true)").toString());
            this.assertResult(CollectionUtils.createImmutableList((Object[])new String[]{"system", HelpProcedure$.MODULE$.NAME()}), JavaConverters$.MODULE$.seqAsJavaListConverter(call.name()).asJava(), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            this.assertResult(BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)call.args().size()), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            this.checkArg(call, 0, "c1", BoxesRunTime.boxToInteger((int)1), DataTypes.IntegerType);
            this.checkArg(call, 1, "c2", "2", DataTypes.StringType);
            this.checkArg(call, 2, "c3", BoxesRunTime.boxToBoolean((boolean)true), DataTypes.BooleanType);
            CallCommand call2 = (CallCommand)this.parser().parsePlan(new StringBuilder(45).append("CALL system.").append(HelpProcedure$.MODULE$.NAME()).append("(c1 => 1, c2 => '2', c3 => true);").toString());
            this.assertResult(CollectionUtils.createImmutableList((Object[])new String[]{"system", HelpProcedure$.MODULE$.NAME()}), JavaConverters$.MODULE$.seqAsJavaListConverter(call2.name()).asJava(), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            this.assertResult(BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)call2.args().size()), Prettifier$.MODULE$.default(), new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            this.checkArg(call2, 0, "c1", BoxesRunTime.boxToInteger((int)1), DataTypes.IntegerType);
            this.checkArg(call2, 1, "c2", "2", DataTypes.StringType);
            this.checkArg(call2, 2, "c3", BoxesRunTime.boxToBoolean((boolean)true), DataTypes.BooleanType);
        }, new Position("TestCallCommandParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
    }
}

