/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.procedure;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.HoodieFileIndex;
import org.apache.hudi.HoodieFileIndex$;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.execution.datasources.PartitionDirectory;
import org.apache.spark.sql.hudi.procedure.HoodieSparkProcedureTestBase;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Integral;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000154AAB\u0004\u0001)!)\u0011\u0004\u0001C\u00015!)A\u0004\u0001C\u0001;!)\u0011\u0007\u0001C\u0001e!)!\f\u0001C\u00017\")A\r\u0001C\u0001K\n9B+Z:u\u00072,8\u000f^3sS:<\u0007K]8dK\u0012,(/\u001a\u0006\u0003\u0011%\t\u0011\u0002\u001d:pG\u0016$WO]3\u000b\u0005)Y\u0011\u0001\u00025vI&T!\u0001D\u0007\u0002\u0007M\fHN\u0003\u0002\u000f\u001f\u0005)1\u000f]1sW*\u0011\u0001#E\u0001\u0007CB\f7\r[3\u000b\u0003I\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u000b\u0011\u0005Y9R\"A\u0004\n\u0005a9!\u0001\b%p_\u0012LWm\u00159be.\u0004&o\\2fIV\u0014X\rV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"A\u0006\u0001\u0002\u0013\u00054xMU3d_J$GC\u0001\u0010%!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0011auN\\4\t\u000b\u0015\u0012\u0001\u0019\u0001\u0014\u0002\u001d\r|W.\\5u)&lW\r\\5oKB\u0011qeL\u0007\u0002Q)\u0011\u0011FK\u0001\ti&lW\r\\5oK*\u00111\u0006L\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003[9\naaY8n[>t'B\u0001\u0006\u0010\u0013\t\u0001\u0004F\u0001\bI_>$\u0017.\u001a+j[\u0016d\u0017N\\3\u0002\u0019]\u0014\u0018\u000e^3SK\u000e|'\u000fZ:\u0015\rMzDI\u0012%V!\r!\u0014hO\u0007\u0002k)\u0011agN\u0001\u0005kRLGNC\u00019\u0003\u0011Q\u0017M^1\n\u0005i*$!C!se\u0006LH*[:u!\taT(D\u0001\f\u0013\tq4BA\u0002S_^DQ\u0001Q\u0002A\u0002\u0005\u000bQAZ5mKN\u0004\"a\b\"\n\u0005\r\u0003#aA%oi\")Qi\u0001a\u0001\u0003\u0006Qa.^7SK\u000e|'\u000fZ:\t\u000b\u001d\u001b\u0001\u0019A!\u0002\u0015A\f'\u000f^5uS>t7\u000fC\u0003J\u0007\u0001\u0007!*\u0001\u0005m_\u000e\fG/[8o!\tY%K\u0004\u0002M!B\u0011Q\nI\u0007\u0002\u001d*\u0011qjE\u0001\u0007yI|w\u000e\u001e \n\u0005E\u0003\u0013A\u0002)sK\u0012,g-\u0003\u0002T)\n11\u000b\u001e:j]\u001eT!!\u0015\u0011\t\u000bY\u001b\u0001\u0019A,\u0002\u000f=\u0004H/[8ogB!1\n\u0017&K\u0013\tIFKA\u0002NCB\f\u0011c\u001e:ji\u0016\u0014VmY8sIN\f%O]1z)\u0015av\f\u00192d!\tyR,\u0003\u0002_A\t!QK\\5u\u0011\u0015\u0001E\u00011\u0001B\u0011\u0015\tG\u00011\u00014\u0003\u001d\u0011XmY8sINDQ!\u0013\u0003A\u0002)CQA\u0016\u0003A\u0002]\u000bqa\u001e:ji\u0016$e\t\u0006\u0003]M.d\u0007\"B4\u0006\u0001\u0004A\u0017A\u00013g!\ra\u0014nO\u0005\u0003U.\u0011q\u0001R1uCN,G\u000fC\u0003J\u000b\u0001\u0007!\nC\u0003W\u000b\u0001\u0007q\u000b")
public class TestClusteringProcedure
extends HoodieSparkProcedureTestBase {
    public long avgRecord(HoodieTimeline commitTimeline) {
        LongRef totalByteSize = LongRef.create((long)0L);
        LongRef totalRecordsCount = LongRef.create((long)0L);
        TimelineLayout layout = TimelineLayout.fromVersion((TimelineLayoutVersion)commitTimeline.getTimelineLayoutVersion());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(commitTimeline.getReverseOrderedInstants().toArray())).foreach((Function1 & Serializable & scala.Serializable)instant -> {
            TestClusteringProcedure.$anonfun$avgRecord$1(layout, commitTimeline, totalByteSize, totalRecordsCount, instant);
            return BoxedUnit.UNIT;
        });
        return (long)Math.ceil(1.0 * (double)totalByteSize.elem / (double)totalRecordsCount.elem);
    }

    public ArrayList<Row> writeRecords(int files, int numRecords, int partitions, String location, scala.collection.immutable.Map<String, String> options) {
        ArrayList<Row> records = new ArrayList<Row>(numRecords);
        int rowDimension = (int)Math.ceil(Math.sqrt(numRecords));
        Stream data = (Stream)package$.MODULE$.Stream().range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)rowDimension), (Object)BoxesRunTime.boxToInteger((int)1), (Integral)Numeric.IntIsIntegral$.MODULE$).flatMap((Function1 & Serializable & scala.Serializable)x -> TestClusteringProcedure.$anonfun$writeRecords$1(rowDimension, BoxesRunTime.unboxToInt((Object)x)), Stream$.MODULE$.canBuildFrom());
        if (partitions > 0) {
            data.foreach((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)records.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)i.getLeft()) % partitions)), new StringBuilder(3).append("foo").append(i.getLeft()).toString(), new StringBuilder(3).append("bar").append(i.getRight()).toString()})))));
        } else {
            data.foreach((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)records.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{i.getLeft(), new StringBuilder(3).append("foo").append(i.getLeft()).toString(), new StringBuilder(3).append("bar").append(i.getRight()).toString()})))));
        }
        StructType struct = new StructType((StructField[])((Object[])new StructField[]{new StructField("c1", DataTypes.IntegerType, true, Metadata$.MODULE$.empty()), new StructField("c2", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("c3", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
        Dataset df = this.spark().createDataFrame(records, struct).repartition(files);
        this.writeDF((Dataset<Row>)df, location, options);
        return records;
    }

    public void writeRecordsArray(int files, ArrayList<Row> records, String location, scala.collection.immutable.Map<String, String> options) {
        StructType struct = new StructType((StructField[])((Object[])new StructField[]{new StructField("c1", DataTypes.IntegerType, true, Metadata$.MODULE$.empty()), new StructField("c2", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("c3", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
        Dataset df = this.spark().createDataFrame(records, struct).repartition(files);
        this.writeDF((Dataset<Row>)df, location, options);
    }

    public void writeDF(Dataset<Row> df, String location, scala.collection.immutable.Map<String, String> options) {
        df.select("c1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c2", "c3"})).sortWithinPartitions("c1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c2"})).write().format("hudi").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), WriteOperationType.INSERT.value()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "c1").options(options).mode("append").save(location);
    }

    public static final /* synthetic */ boolean $anonfun$new$4(HoodieInstant p) {
        String string = p.getAction();
        String string2 = "replacecommit";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$5(HoodieInstant p) {
        String string = p.getAction();
        String string2 = "replacecommit";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$3(TestClusteringProcedure $this, File tmp$1, String tableType) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp$1.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(414).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long,\n             |  partition long\n             |) using hudi\n             | options (\n             |  primaryKey ='id',\n             |  type = '").append(tableType).append("',\n             |  preCombineField = 'ts'\n             | )\n             | partitioned by(partition)\n             | location '").append(basePath).append("'\n       ").toString())).stripMargin());
        $this.spark().sql("set hoodie.compact.inline=false");
        $this.spark().sql("set hoodie.compact.schedule.inline=false");
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000, 1000)").toString());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1001, 1001)").toString());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1002, 1002)").toString());
        SparkRDDWriteClient client = HoodieCLIUtils$.MODULE$.createHoodieWriteClient($this.spark(), basePath, Predef$.MODULE$.Map().empty(), Option$.MODULE$.apply((Object)tableName));
        String firstScheduleInstant = client.createNewInstantTime();
        client.scheduleClusteringAtInstant(firstScheduleInstant, org.apache.hudi.common.util.Option.empty());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(4, 'a4', 10, 1003, 1003)").toString());
        String secondScheduleInstant = client.createNewInstantTime();
        client.scheduleClusteringAtInstant(secondScheduleInstant, org.apache.hudi.common.util.Option.empty());
        $this.checkAnswer(new StringBuilder(24).append("call show_clustering('").append(tableName).append("')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{secondScheduleInstant, BoxesRunTime.boxToInteger((int)1), HoodieInstant.State.REQUESTED.name(), "*"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{firstScheduleInstant, BoxesRunTime.boxToInteger((int)3), HoodieInstant.State.REQUESTED.name(), "*"}))}));
        $this.checkAnswer(new StringBuilder(87).append("call run_clustering(table => '").append(tableName).append("', order => 'partition', show_involved_partition => true)").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{secondScheduleInstant, BoxesRunTime.boxToInteger((int)1), HoodieInstant.State.COMPLETED.name(), "partition=1003"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{firstScheduleInstant, BoxesRunTime.boxToInteger((int)3), HoodieInstant.State.COMPLETED.name(), "partition=1000,partition=1001,partition=1002"}))}));
        FileSystem fs = new Path(basePath).getFileSystem($this.spark().sessionState().newHadoopConf());
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)fs, (String)basePath, (String)secondScheduleInstant)), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        Seq finishedClustering = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(HoodieDataSourceHelpers.allCompletedCommitsCompactions((FileSystem)fs, (String)basePath).getInstants().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TestClusteringProcedure.$anonfun$new$4(p))).toSeq();
        $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)finishedClustering.size()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        $this.checkAnswer(new StringBuilder(55).append("select id, name, price, ts, partition from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1001), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1002), BoxesRunTime.boxToInteger((int)1002)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1003), BoxesRunTime.boxToInteger((int)1003)}))}));
        $this.checkAnswer(new StringBuilder(33).append("call show_clustering(table => '").append(tableName).append("')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{secondScheduleInstant, BoxesRunTime.boxToInteger((int)1), HoodieInstant.State.COMPLETED.name(), "*"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{firstScheduleInstant, BoxesRunTime.boxToInteger((int)3), HoodieInstant.State.COMPLETED.name(), "*"}))}));
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(5, 'a5', 10, 1004, 1004)").toString());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(6, 'a6', 10, 1005, 1005)").toString());
        $this.spark().sql(new StringBuilder(87).append("call run_clustering(table => '").append(tableName).append("', order => 'partition', show_involved_partition => true)").toString()).show();
        Seq thirdClusteringInstant = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(HoodieDataSourceHelpers.allCompletedCommitsCompactions((FileSystem)fs, (String)basePath).findInstantsAfter(secondScheduleInstant).getInstants().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TestClusteringProcedure.$anonfun$new$5(p))).toSeq();
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)thirdClusteringInstant.size()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        $this.checkAnswer(new StringBuilder(55).append("select id, name, price, ts, partition from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1001), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1002), BoxesRunTime.boxToInteger((int)1002)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1003), BoxesRunTime.boxToInteger((int)1003)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "a5", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1004), BoxesRunTime.boxToInteger((int)1004)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "a6", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1005), BoxesRunTime.boxToInteger((int)1005)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$2(TestClusteringProcedure $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestClusteringProcedure.$anonfun$new$3($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$9(HoodieInstant p) {
        String string = p.getAction();
        String string2 = "replacecommit";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$11(HoodieInstant p) {
        String string = p.getAction();
        String string2 = "replacecommit";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$7(TestClusteringProcedure $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            String tableName = $this.generateTableName();
            String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(414).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long,\n             |  partition long\n             |) using hudi\n             | options (\n             |  primaryKey ='id',\n             |  type = '").append((String)tableType).append("',\n             |  preCombineField = 'ts'\n             | )\n             | partitioned by(partition)\n             | location '").append(basePath).append("'\n       ").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(31).append("call run_clustering(path => '").append(basePath).append("')").toString()).show();
            $this.checkAnswer(new StringBuilder(32).append("call show_clustering(path => '").append(basePath).append("')").toString(), (Seq<Seq<Object>>)Nil$.MODULE$);
            $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000, 1000)").toString());
            $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1001, 1001)").toString());
            $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1002, 1002)").toString());
            SparkRDDWriteClient client = HoodieCLIUtils$.MODULE$.createHoodieWriteClient($this.spark(), basePath, Predef$.MODULE$.Map().empty(), Option$.MODULE$.apply((Object)tableName));
            String firstScheduleInstant = client.createNewInstantTime();
            client.scheduleClusteringAtInstant(firstScheduleInstant, org.apache.hudi.common.util.Option.empty());
            $this.checkAnswer(new StringBuilder(65).append("call show_clustering(path => '").append(basePath).append("', show_involved_partition => true)").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{firstScheduleInstant, BoxesRunTime.boxToInteger((int)3), HoodieInstant.State.REQUESTED.name(), "partition=1000,partition=1001,partition=1002"}))}));
            $this.checkAnswer(new StringBuilder(53).append("call run_clustering(path => '").append(basePath).append("', order => 'partition')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{firstScheduleInstant, BoxesRunTime.boxToInteger((int)3), HoodieInstant.State.COMPLETED.name(), "*"}))}));
            $this.checkAnswer(new StringBuilder(55).append("select id, name, price, ts, partition from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1001), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1002), BoxesRunTime.boxToInteger((int)1002)}))}));
            FileSystem fs = new Path(basePath).getFileSystem($this.spark().sessionState().newHadoopConf());
            $this.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)fs, (String)basePath, (String)firstScheduleInstant)), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
            Seq finishedClustering = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(HoodieDataSourceHelpers.allCompletedCommitsCompactions((FileSystem)fs, (String)basePath).getInstants().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TestClusteringProcedure.$anonfun$new$9(p))).toSeq();
            $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)finishedClustering.size()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(4, 'a4', 10, 1003, 1003)").toString());
            $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(5, 'a5', 10, 1004, 1004)").toString());
            Seq[] resultA = (Seq[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(100).append("call run_clustering(table => '").append(tableName).append("', predicate => 'partition >= 1003L', show_involved_partition => true)").toString()).collect())).map((Function1 & Serializable & scala.Serializable)row -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row.getString(0), BoxesRunTime.boxToInteger((int)row.getInt(1)), row.getString(2), row.getString(3)})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)));
            $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)resultA.length), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
            $this.assertResult("partition=1003,partition=1004", resultA[0].apply(3), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
            $this.checkAnswer(new StringBuilder(55).append("select id, name, price, ts, partition from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1001), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1002), BoxesRunTime.boxToInteger((int)1002)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1003), BoxesRunTime.boxToInteger((int)1003)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "a5", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1004), BoxesRunTime.boxToInteger((int)1004)}))}));
            finishedClustering = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(HoodieDataSourceHelpers.allCompletedCommitsCompactions((FileSystem)fs, (String)basePath).getInstants().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TestClusteringProcedure.$anonfun$new$11(p))).toSeq();
            return $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)finishedClustering.size()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$16(HoodieInstant p) {
        String string = p.getAction();
        String string2 = "replacecommit";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$18(HoodieInstant p) {
        String string = p.getAction();
        String string2 = "replacecommit";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$20(HoodieInstant p) {
        String string = p.getAction();
        String string2 = "replacecommit";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$13(TestClusteringProcedure $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            String tableName = $this.generateTableName();
            String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(414).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long,\n             |  partition long\n             |) using hudi\n             | options (\n             |  primaryKey ='id',\n             |  type = '").append((String)tableType).append("',\n             |  preCombineField = 'ts'\n             | )\n             | partitioned by(partition)\n             | location '").append(basePath).append("'\n       ").toString())).stripMargin());
            FileSystem fs = new Path(basePath).getFileSystem($this.spark().sessionState().newHadoopConf());
            Seq[] resultA = (Seq[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Seq.class));
            $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000, 1000)").toString());
            $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1001, 1001)").toString());
            $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1002, 1002)").toString());
            $this.checkException(new StringBuilder(101).append("call run_clustering(table => '").append(tableName).append("', predicate => 'partition <= 1001L and id = 10', order => 'partition')").toString(), "Only partition predicates are allowed");
            resultA = (Seq[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(122).append("call run_clustering(table => '").append(tableName).append("', predicate => 'partition <= 1001L', order => 'partition', show_involved_partition => true)").toString()).collect())).map((Function1 & Serializable & scala.Serializable)row -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row.getString(0), BoxesRunTime.boxToInteger((int)row.getInt(1)), row.getString(2), row.getString(3)})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)));
            $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)resultA.length), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
            $this.assertResult("partition=1000,partition=1001", resultA[0].apply(3), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
            Seq clusteringInstants = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(HoodieDataSourceHelpers.allCompletedCommitsCompactions((FileSystem)fs, (String)basePath).getInstants().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TestClusteringProcedure.$anonfun$new$16(p))).toSeq();
            $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)clusteringInstants.size()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
            HoodieInstant clusteringInstant = (HoodieInstant)clusteringInstants.last();
            org.apache.hudi.common.util.Option clusteringPlan = HoodieDataSourceHelpers.getClusteringPlan((FileSystem)fs, (String)basePath, (String)clusteringInstant.requestedTime());
            $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)clusteringPlan.isPresent()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
            $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)((HoodieClusteringPlan)clusteringPlan.get()).getInputGroups().size()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
            $this.assertResult(resultA[0].apply(1), BoxesRunTime.boxToInteger((int)((HoodieClusteringPlan)clusteringPlan.get()).getInputGroups().size()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
            $this.checkAnswer(new StringBuilder(66).append("call show_clustering(table => '").append(tableName).append("', show_involved_partition => true)").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultA[0].head(), resultA[0].apply(1), HoodieInstant.State.COMPLETED.name(), "partition=1000,partition=1001"}))}));
            $this.checkAnswer(new StringBuilder(55).append("select id, name, price, ts, partition from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1001), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1002), BoxesRunTime.boxToInteger((int)1002)}))}));
            Seq[] resultB = (Seq[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Seq.class));
            $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(4, 'a4', 10, 1003, 1003)").toString());
            $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(5, 'a5', 10, 1004, 1004)").toString());
            $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(6, 'a6', 10, 1005, 1005)").toString());
            $this.checkException(new StringBuilder(123).append("call run_clustering(table => '").append(tableName).append("', predicate => 'partition > 1001L and partition <= 1005L and id = 10', order => 'partition')").toString(), "Only partition predicates are allowed");
            resultB = (Seq[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(144).append("call run_clustering(table => '").append(tableName).append("', predicate => 'partition > 1001L and partition <= 1005L', order => 'partition', show_involved_partition => true)").toString()).collect())).map((Function1 & Serializable & scala.Serializable)row -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row.getString(0), BoxesRunTime.boxToInteger((int)row.getInt(1)), row.getString(2), row.getString(3)})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)));
            $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)resultB.length), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 317));
            $this.assertResult("partition=1002,partition=1003,partition=1004,partition=1005", resultB[0].apply(3), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
            Seq clusteringInstants2 = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(HoodieDataSourceHelpers.allCompletedCommitsCompactions((FileSystem)fs, (String)basePath).getInstants().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TestClusteringProcedure.$anonfun$new$18(p))).toSeq();
            $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)clusteringInstants2.size()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
            HoodieInstant clusteringInstant2 = (HoodieInstant)clusteringInstants2.last();
            org.apache.hudi.common.util.Option clusteringPlan2 = HoodieDataSourceHelpers.getClusteringPlan((FileSystem)fs, (String)basePath, (String)clusteringInstant2.requestedTime());
            $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)clusteringPlan2.isPresent()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
            $this.assertResult(BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)((HoodieClusteringPlan)clusteringPlan2.get()).getInputGroups().size()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332));
            $this.checkAnswer(new StringBuilder(66).append("call show_clustering(table => '").append(tableName).append("', show_involved_partition => true)").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultA[0].head(), resultA[0].apply(1), HoodieInstant.State.COMPLETED.name(), "partition=1000,partition=1001"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultB[0].head(), resultB[0].apply(1), HoodieInstant.State.COMPLETED.name(), "partition=1002,partition=1003,partition=1004,partition=1005"}))}));
            $this.checkAnswer(new StringBuilder(55).append("select id, name, price, ts, partition from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1001), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1002), BoxesRunTime.boxToInteger((int)1002)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1003), BoxesRunTime.boxToInteger((int)1003)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "a5", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1004), BoxesRunTime.boxToInteger((int)1004)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "a6", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1005), BoxesRunTime.boxToInteger((int)1005)}))}));
            Seq[] resultC = (Seq[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Seq.class));
            $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(7, 'a7', 10, 1006, 1006)").toString());
            $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(8, 'a8', 10, 1007, 1007)").toString());
            $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(9, 'a9', 10, 1008, 1008)").toString());
            $this.spark().sql(new StringBuilder(46).append("insert into ").append(tableName).append(" values(10, 'a10', 10, 1009, 1009)").toString());
            $this.checkException(new StringBuilder(121).append("call run_clustering(table => '").append(tableName).append("', predicate => 'partition < 1007L or partition >= 1008L or id = 10', order => 'partition')").toString(), "Only partition predicates are allowed");
            resultC = (Seq[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(168).append("call run_clustering(table => '").append(tableName).append("', predicate => '(partition >= 1006L and partition < 1008L) or partition >= 1009L', order => 'partition', show_involved_partition => true)").toString()).collect())).map((Function1 & Serializable & scala.Serializable)row -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row.getString(0), BoxesRunTime.boxToInteger((int)row.getInt(1)), row.getString(2), row.getString(3)})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)));
            $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)resultC.length), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367));
            $this.assertResult("partition=1006,partition=1007,partition=1009", resultC[0].apply(3), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
            Seq clusteringInstants3 = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(HoodieDataSourceHelpers.allCompletedCommitsCompactions((FileSystem)fs, (String)basePath).getInstants().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TestClusteringProcedure.$anonfun$new$20(p))).toSeq();
            $this.assertResult(BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)clusteringInstants3.size()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
            HoodieInstant clusteringInstant3 = (HoodieInstant)clusteringInstants3.last();
            org.apache.hudi.common.util.Option clusteringPlan3 = HoodieDataSourceHelpers.getClusteringPlan((FileSystem)fs, (String)basePath, (String)clusteringInstant3.requestedTime());
            $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)clusteringPlan3.isPresent()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
            $this.assertResult(BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)((HoodieClusteringPlan)clusteringPlan3.get()).getInputGroups().size()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
            $this.checkAnswer(new StringBuilder(66).append("call show_clustering(table => '").append(tableName).append("', show_involved_partition => true)").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultA[0].head(), resultA[0].apply(1), HoodieInstant.State.COMPLETED.name(), "partition=1000,partition=1001"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultB[0].head(), resultB[0].apply(1), HoodieInstant.State.COMPLETED.name(), "partition=1002,partition=1003,partition=1004,partition=1005"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultC[0].head(), resultC[0].apply(1), HoodieInstant.State.COMPLETED.name(), "partition=1006,partition=1007,partition=1009"}))}));
            $this.checkAnswer(new StringBuilder(55).append("select id, name, price, ts, partition from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1001), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1002), BoxesRunTime.boxToInteger((int)1002)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1003), BoxesRunTime.boxToInteger((int)1003)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "a5", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1004), BoxesRunTime.boxToInteger((int)1004)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "a6", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1005), BoxesRunTime.boxToInteger((int)1005)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), "a7", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1006), BoxesRunTime.boxToInteger((int)1006)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), "a8", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1007), BoxesRunTime.boxToInteger((int)1007)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), "a9", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1008), BoxesRunTime.boxToInteger((int)1008)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10), "a10", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1009), BoxesRunTime.boxToInteger((int)1009)}))}));
            Seq[] resultD = (Seq[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(121).append("call run_clustering(table => '").append(tableName).append("', predicate => 'partition > 1111L', order => 'partition', show_involved_partition => true)").toString()).collect())).map((Function1 & Serializable & scala.Serializable)row -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row.getString(0), BoxesRunTime.boxToInteger((int)row.getInt(1)), row.getString(2), row.getString(3)})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)));
            return $this.assertResult(BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)resultD.length), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 410));
        });
    }

    public static final /* synthetic */ void $anonfun$new$23(TestClusteringProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(478).append("\n           |create table ").append(tableName).append(" (\n           |  c1 int,\n           |  c2 string,\n           |  c3 double\n           |) using hudi\n           | options (\n           |  primaryKey = 'c1',\n           |  type = 'cow',\n           |  hoodie.metadata.enable = 'true',\n           |  hoodie.metadata.index.column.stats.enable = 'true',\n           |  hoodie.enable.data.skipping = 'true',\n           |  hoodie.datasource.write.operation = 'insert'\n           | )\n           | location '").append(basePath).append("'\n     ").toString())).stripMargin());
        $this.writeRecords(2, 4, 0, basePath, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.avro.schema.validate"), (Object)"false")}))));
        $this.spark().sql(new StringBuilder(50).append("call run_clustering(table => '").append(tableName).append("', op => 'schedule')").toString());
        $this.writeRecords(2, 4, 0, basePath, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.avro.schema.validate"), (Object)"false")}))));
        $this.spark().sql(new StringBuilder(50).append("call run_clustering(table => '").append(tableName).append("', op => 'schedule')").toString());
        Configuration conf = new Configuration();
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)new HadoopStorageConfiguration(conf), (String)basePath);
        Seq instants = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(metaClient.getActiveTimeline().filterPendingClusteringTimeline().getInstants().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.requestedTime()).toSeq();
        int $org_scalatest_assert_macro_left = 2;
        int $org_scalatest_assert_macro_right = instants.size();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
        $this.checkExceptionContain(new StringBuilder(56).append("call run_clustering(table => '").append(tableName).append("', instants => '000000, ").append(instants.head()).append("')").toString(), "specific 000000 instants is not exist");
        metaClient.reloadActiveTimeline();
        int $org_scalatest_assert_macro_left2 = 0;
        int $org_scalatest_assert_macro_right2 = metaClient.getActiveTimeline().getCompletedReplaceTimeline().getInstants().size();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 454));
        int $org_scalatest_assert_macro_left3 = 2;
        int $org_scalatest_assert_macro_right3 = metaClient.getActiveTimeline().filterPendingClusteringTimeline().getInstants().size();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 455));
        $this.writeRecords(2, 4, 0, basePath, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.avro.schema.validate"), (Object)"false")}))));
        $this.spark().sql(new StringBuilder(48).append("call run_clustering(table => '").append(tableName).append("', instants => '").append(instants.mkString(",")).append("')").toString());
        metaClient.reloadActiveTimeline();
        int $org_scalatest_assert_macro_left4 = 2;
        int $org_scalatest_assert_macro_right4 = metaClient.getActiveTimeline().getCompletedReplaceTimeline().getInstants().size();
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 461));
        int $org_scalatest_assert_macro_left5 = 0;
        int $org_scalatest_assert_macro_right5 = metaClient.getActiveTimeline().filterPendingClusteringTimeline().getInstants().size();
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
        $this.checkExceptionContain(new StringBuilder(72).append("call run_clustering(table => '").append(tableName).append("', instants => '000000', op => 'schedule')").toString(), "specific instants only can be used in 'execute' op or not specific op");
        $this.checkExceptionContain(new StringBuilder(82).append("call run_clustering(table => '").append(tableName).append("', instants => '000000', op => 'scheduleAndExecute')").toString(), "specific instants only can be used in 'execute' op or not specific op");
        $this.spark().sql(new StringBuilder(50).append("call run_clustering(table => '").append(tableName).append("', op => 'schedule')").toString());
        metaClient.reloadActiveTimeline();
        Seq instants2 = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(metaClient.getActiveTimeline().filterPendingClusteringTimeline().getInstants().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.requestedTime()).toSeq();
        $this.spark().sql(new StringBuilder(65).append("call run_clustering(table => '").append(tableName).append("', instants => '").append(instants2.mkString(",")).append("', op => 'execute')").toString());
        metaClient.reloadActiveTimeline();
        int $org_scalatest_assert_macro_left6 = 3;
        int $org_scalatest_assert_macro_right6 = metaClient.getActiveTimeline().getCompletedReplaceTimeline().getInstants().size();
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
        int $org_scalatest_assert_macro_left7 = 0;
        int $org_scalatest_assert_macro_right7 = metaClient.getActiveTimeline().filterPendingClusteringTimeline().getInstants().size();
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
    }

    public static final /* synthetic */ void $anonfun$new$27(TestClusteringProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        scala.collection.immutable.Map config = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.avro.schema.validate"), (Object)"false")}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(478).append("\n           |create table ").append(tableName).append(" (\n           |  c1 int,\n           |  c2 string,\n           |  c3 double\n           |) using hudi\n           | options (\n           |  primaryKey = 'c1',\n           |  type = 'cow',\n           |  hoodie.metadata.enable = 'true',\n           |  hoodie.metadata.index.column.stats.enable = 'true',\n           |  hoodie.enable.data.skipping = 'true',\n           |  hoodie.datasource.write.operation = 'insert'\n           | )\n           | location '").append(basePath).append("'\n     ").toString())).stripMargin());
        $this.writeRecords(2, 4, 0, basePath, (scala.collection.immutable.Map<String, String>)config);
        Configuration conf = new Configuration();
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)new HadoopStorageConfiguration(conf), (String)basePath);
        int $org_scalatest_assert_macro_left = 0;
        int $org_scalatest_assert_macro_right = metaClient.getActiveTimeline().getCompletedReplaceTimeline().getInstants().size();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 512));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metaClient.getActiveTimeline().filterPendingClusteringTimeline().empty(), "metaClient.getActiveTimeline().filterPendingClusteringTimeline().empty()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 513));
        $this.spark().sql(new StringBuilder(50).append("call run_clustering(table => '").append(tableName).append("', op => 'schedule')").toString());
        metaClient.reloadActiveTimeline();
        int $org_scalatest_assert_macro_left2 = 0;
        int $org_scalatest_assert_macro_right2 = metaClient.getActiveTimeline().getCompletedReplaceTimeline().getInstants().size();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 517));
        int $org_scalatest_assert_macro_left3 = 1;
        int $org_scalatest_assert_macro_right3 = metaClient.getActiveTimeline().filterPendingClusteringTimeline().getInstants().size();
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 518));
        $this.writeRecords(2, 4, 0, basePath, (scala.collection.immutable.Map<String, String>)config);
        $this.spark().sql(new StringBuilder(49).append("call run_clustering(table => '").append(tableName).append("', op => 'execute')").toString());
        metaClient.reloadActiveTimeline();
        int $org_scalatest_assert_macro_left4 = 1;
        int $org_scalatest_assert_macro_right4 = metaClient.getActiveTimeline().getCompletedReplaceTimeline().getInstants().size();
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 523));
        int $org_scalatest_assert_macro_left5 = 0;
        int $org_scalatest_assert_macro_right5 = metaClient.getActiveTimeline().filterPendingClusteringTimeline().getInstants().size();
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 524));
        $this.writeRecords(2, 4, 0, basePath, (scala.collection.immutable.Map<String, String>)config);
        $this.spark().sql(new StringBuilder(32).append("call run_clustering(table => '").append(tableName).append("')").toString());
        metaClient.reloadActiveTimeline();
        int $org_scalatest_assert_macro_left6 = 2;
        int $org_scalatest_assert_macro_right6 = metaClient.getActiveTimeline().getCompletedReplaceTimeline().getInstants().size();
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 529));
        int $org_scalatest_assert_macro_left7 = 0;
        int $org_scalatest_assert_macro_right7 = metaClient.getActiveTimeline().filterPendingClusteringTimeline().getInstants().size();
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 530));
        $this.writeRecords(2, 4, 0, basePath, (scala.collection.immutable.Map<String, String>)config);
        $this.spark().sql(new StringBuilder(32).append("call run_clustering(table => '").append(tableName).append("')").toString());
        metaClient.reloadActiveTimeline();
        int $org_scalatest_assert_macro_left8 = 3;
        int $org_scalatest_assert_macro_right8 = metaClient.getActiveTimeline().getCompletedReplaceTimeline().getInstants().size();
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 == $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 535));
        int $org_scalatest_assert_macro_left9 = 0;
        int $org_scalatest_assert_macro_right9 = metaClient.getActiveTimeline().filterPendingClusteringTimeline().getInstants().size();
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9 == $org_scalatest_assert_macro_right9, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 536));
        $this.checkExceptionContain(new StringBuilder(46).append("call run_clustering(table => '").append(tableName).append("', op => 'null')").toString(), "Invalid value");
    }

    public static final /* synthetic */ void $anonfun$new$29(TestClusteringProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        scala.collection.immutable.Map metadataOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true")}));
        scala.collection.immutable.Map queryOpts = metadataOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)basePath), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE().key()), (Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL())})));
        String x$1 = "c2";
        StringType$ x$2 = StringType$.MODULE$;
        boolean x$3 = false;
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$4);
        EqualTo dataFilterC2 = new EqualTo((Expression)new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$5, x$6), (Expression)Literal$.MODULE$.apply((Object)"foo23"));
        String x$7 = "c3";
        StringType$ x$8 = StringType$.MODULE$;
        boolean x$9 = false;
        Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$11 = AttributeReference$.MODULE$.apply$default$5(x$7, (DataType)x$8, x$9, x$10);
        Seq x$12 = AttributeReference$.MODULE$.apply$default$6(x$7, (DataType)x$8, x$9, x$10);
        EqualTo dataFilterC3 = new EqualTo((Expression)new AttributeReference(x$7, (DataType)x$8, x$9, x$10, x$11, x$12), (Expression)Literal$.MODULE$.apply((Object)"bar23"));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(478).append("\n           |create table ").append(tableName).append(" (\n           |  c1 int,\n           |  c2 string,\n           |  c3 double\n           |) using hudi\n           | options (\n           |  primaryKey = 'c1',\n           |  type = 'cow',\n           |  hoodie.metadata.enable = 'true',\n           |  hoodie.metadata.index.column.stats.enable = 'true',\n           |  hoodie.enable.data.skipping = 'true',\n           |  hoodie.datasource.write.operation = 'insert'\n           | )\n           | location '").append(basePath).append("'\n     ").toString())).stripMargin());
        int fileNum = 20;
        int numRecords = 400000;
        scala.collection.immutable.Map config = metadataOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.avro.schema.validate"), (Object)"false")})));
        ArrayList<Row> records = $this.writeRecords(fileNum, numRecords, 0, basePath, (scala.collection.immutable.Map<String, String>)config);
        Configuration conf = new Configuration();
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)new HadoopStorageConfiguration(conf), (String)basePath);
        long avgSize = $this.avgRecord((HoodieTimeline)metaClient.getActiveTimeline());
        long avgCount = (long)Math.ceil(1.0 * (double)numRecords / (double)fileNum);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(491).append("call run_clustering(table => '").append(tableName).append("', order => 'c2,c3', order_strategy => 'linear', options => \"\n           | hoodie.copyonwrite.record.size.estimate=").append(avgSize).append(",\n           | hoodie.parquet.max.file.size=").append(avgSize * avgCount).append(",\n           | hoodie.parquet.small.file.limit=0,\n           | hoodie.clustering.plan.strategy.target.file.max.bytes=").append(avgSize * avgCount).append(",\n           | hoodie.clustering.plan.strategy.max.bytes.per.group=").append(4L * avgSize * avgCount).append(",\n           | hoodie.metadata.enable=true,\n           | hoodie.metadata.index.column.stats.enable=true\n           |\")").toString())).stripMargin());
        metaClient.reloadActiveTimeline();
        HoodieFileIndex fileIndex1 = new HoodieFileIndex($this.spark(), metaClient, (Option)None$.MODULE$, queryOpts, HoodieFileIndex$.MODULE$.apply$default$5(), HoodieFileIndex$.MODULE$.apply$default$6(), HoodieFileIndex$.MODULE$.apply$default$7());
        int orderAllFiles = fileIndex1.allBaseFiles().size();
        int c2OrderFilterCount = ((PartitionDirectory)fileIndex1.listFiles((Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)dataFilterC2, (List)Nil$.MODULE$)).head()).files().size();
        int c3OrderFilterCount = ((PartitionDirectory)fileIndex1.listFiles((Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)dataFilterC3, (List)Nil$.MODULE$)).head()).files().size();
        FileSystem fs = new Path(basePath).getFileSystem($this.spark().sessionState().newHadoopConf());
        fs.delete(new Path(basePath), true);
        $this.writeRecordsArray(fileNum, records, basePath, (scala.collection.immutable.Map<String, String>)config.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.table.name"), (Object)tableName)}))));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(492).append("call run_clustering(table => '").append(tableName).append("', order => 'c2,c3', order_strategy => 'z-order', options => \"\n           | hoodie.copyonwrite.record.size.estimate=").append(avgSize).append(",\n           | hoodie.parquet.max.file.size=").append(avgSize * avgCount).append(",\n           | hoodie.parquet.small.file.limit=0,\n           | hoodie.clustering.plan.strategy.target.file.max.bytes=").append(avgSize * avgCount).append(",\n           | hoodie.clustering.plan.strategy.max.bytes.per.group=").append(4L * avgSize * avgCount).append(",\n           | hoodie.metadata.enable=true,\n           | hoodie.metadata.index.column.stats.enable=true\n           |\")").toString())).stripMargin());
        metaClient.reloadActiveTimeline();
        HoodieFileIndex fileIndex2 = new HoodieFileIndex($this.spark(), metaClient, (Option)None$.MODULE$, queryOpts, HoodieFileIndex$.MODULE$.apply$default$5(), HoodieFileIndex$.MODULE$.apply$default$6(), HoodieFileIndex$.MODULE$.apply$default$7());
        int ZOrderAllFiles = fileIndex2.allBaseFiles().size();
        int c2ZOrderFilterCount = ((PartitionDirectory)fileIndex2.listFiles((Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)dataFilterC2, (List)Nil$.MODULE$)).head()).files().size();
        int c3ZOrderFilterCount = ((PartitionDirectory)fileIndex2.listFiles((Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)dataFilterC3, (List)Nil$.MODULE$)).head()).files().size();
        double $org_scalatest_assert_macro_left = 1.0 * (double)c2OrderFilterCount / (double)orderAllFiles;
        double $org_scalatest_assert_macro_right = 1.0 * (double)c2ZOrderFilterCount / (double)ZOrderAllFiles;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 628));
        double $org_scalatest_assert_macro_left2 = 1.0 * (double)c3OrderFilterCount / (double)orderAllFiles;
        double $org_scalatest_assert_macro_right2 = 1.0 * (double)c3ZOrderFilterCount / (double)ZOrderAllFiles;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 629));
    }

    public static final /* synthetic */ void $anonfun$new$31(TestClusteringProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(387).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  partition long\n           |) using hudi\n           | options (\n           |  primaryKey ='id',\n           |  type = 'cow',\n           |  preCombineField = 'ts'\n           | )\n           | partitioned by(partition)\n           | location '").append(basePath).append("'\n     ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1010, 1010)").toString());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1010, 1010)").toString());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1011, 1011)").toString());
        Seq[] result = (Seq[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(106).append("call run_clustering(table => '").append(tableName).append("', ").append("selected_partitions => 'partition=1010', show_involved_partition => true)").toString()).collect())).map((Function1 & Serializable & scala.Serializable)row -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row.getString(0), BoxesRunTime.boxToInteger((int)row.getInt(1)), row.getString(2), row.getString(3)})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)));
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)result.length), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 665));
        $this.assertResult("partition=1010", result[0].apply(3), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 666));
        $this.checkAnswer(new StringBuilder(55).append("select id, name, price, ts, partition from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1010), BoxesRunTime.boxToInteger((int)1010)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1010), BoxesRunTime.boxToInteger((int)1010)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1011), BoxesRunTime.boxToInteger((int)1011)}))}));
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(4, 'a4', 10, 1010, 1010)").toString());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(5, 'a5', 10, 1011, 1011)").toString());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(6, 'a6', 10, 1012, 1012)").toString());
        Seq[] result2 = (Seq[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(136).append("call run_clustering(table => '").append(tableName).append("', ").append("selected_partitions => 'partition=1010,partition=1011,partition=1012', show_involved_partition => true)").toString()).collect())).map((Function1 & Serializable & scala.Serializable)row -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row.getString(0), BoxesRunTime.boxToInteger((int)row.getInt(1)), row.getString(2), row.getString(3)})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)));
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)result2.length), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 684));
        $this.assertResult("partition=1010,partition=1011,partition=1012", result2[0].apply(3), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 685));
        $this.checkAnswer(new StringBuilder(55).append("select id, name, price, ts, partition from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1010), BoxesRunTime.boxToInteger((int)1010)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1010), BoxesRunTime.boxToInteger((int)1010)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1011), BoxesRunTime.boxToInteger((int)1011)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1010), BoxesRunTime.boxToInteger((int)1010)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "a5", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1011), BoxesRunTime.boxToInteger((int)1011)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), "a6", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1012), BoxesRunTime.boxToInteger((int)1012)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$35(TestClusteringProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(491).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  partition long\n           |) using hudi\n           | tblproperties (\n           |  primaryKey ='id',\n           |  type = 'cow',\n           |  preCombineField = 'ts',\n           |  hoodie.index.type = 'BUCKET',\n           |  hoodie.bucket.index.hash.field = 'id'\n           | )\n           | partitioned by (partition)\n           | location '").append(basePath).append("'\n     ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1010, 1010)").toString());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1010, 1010)").toString());
        $this.checkExceptionContain(new StringBuilder(32).append("call run_clustering(table => '").append(tableName).append("')").toString(), "Executor SparkExecuteClusteringCommitActionExecutor is not compatible with table layout HoodieSimpleBucketLayout");
    }

    public static final /* synthetic */ void $anonfun$new$37(TestClusteringProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(478).append("\n           |create table ").append(tableName).append(" (\n           |  c1 int,\n           |  c2 string,\n           |  c3 double\n           |) using hudi\n           | options (\n           |  primaryKey = 'c1',\n           |  type = 'cow',\n           |  hoodie.metadata.enable = 'true',\n           |  hoodie.metadata.index.column.stats.enable = 'true',\n           |  hoodie.enable.data.skipping = 'true',\n           |  hoodie.datasource.write.operation = 'insert'\n           | )\n           | location '").append(basePath).append("'\n     ").toString())).stripMargin());
        Configuration conf = new Configuration();
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)new HadoopStorageConfiguration(conf), (String)basePath);
        int $org_scalatest_assert_macro_left = 0;
        int $org_scalatest_assert_macro_right = metaClient.getActiveTimeline().getCompletedReplaceTimeline().getInstants().size();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 755));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metaClient.getActiveTimeline().filterPendingClusteringTimeline().empty(), "metaClient.getActiveTimeline().filterPendingClusteringTimeline().empty()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 756));
        $this.writeRecords(2, 4, 0, basePath, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.avro.schema.validate"), (Object)"false")}))));
        $this.spark().sql(new StringBuilder(50).append("call run_clustering(table => '").append(tableName).append("', op => 'schedule')").toString());
        $this.writeRecords(2, 4, 0, basePath, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.avro.schema.validate"), (Object)"false")}))));
        $this.spark().sql(new StringBuilder(50).append("call run_clustering(table => '").append(tableName).append("', op => 'schedule')").toString());
        metaClient.reloadActiveTimeline();
        int $org_scalatest_assert_macro_left2 = 0;
        int $org_scalatest_assert_macro_right2 = metaClient.getActiveTimeline().getCompletedReplaceTimeline().getInstants().size();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 765));
        int $org_scalatest_assert_macro_left3 = 2;
        int $org_scalatest_assert_macro_right3 = metaClient.getActiveTimeline().filterPendingClusteringTimeline().getInstants().size();
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 766));
        $this.spark().sql(new StringBuilder(49).append("call run_clustering(table => '").append(tableName).append("', op => 'execute')").toString());
        metaClient.reloadActiveTimeline();
        int $org_scalatest_assert_macro_left4 = 2;
        int $org_scalatest_assert_macro_right4 = metaClient.getActiveTimeline().getCompletedReplaceTimeline().getInstants().size();
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 770));
        int $org_scalatest_assert_macro_left5 = 0;
        int $org_scalatest_assert_macro_right5 = metaClient.getActiveTimeline().filterPendingClusteringTimeline().getInstants().size();
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 771));
        $this.writeRecords(2, 4, 0, basePath, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.avro.schema.validate"), (Object)"false")}))));
        $this.spark().sql(new StringBuilder(50).append("call run_clustering(table => '").append(tableName).append("', op => 'schedule')").toString());
        $this.writeRecords(2, 4, 0, basePath, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.avro.schema.validate"), (Object)"false")}))));
        $this.spark().sql(new StringBuilder(50).append("call run_clustering(table => '").append(tableName).append("', op => 'schedule')").toString());
        $this.spark().sql(new StringBuilder(61).append("call run_clustering(table => '").append(tableName).append("', op => 'execute', limit => 1)").toString());
        metaClient.reloadActiveTimeline();
        int $org_scalatest_assert_macro_left6 = 3;
        int $org_scalatest_assert_macro_right6 = metaClient.getActiveTimeline().getCompletedReplaceTimeline().getInstants().size();
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 781));
        int $org_scalatest_assert_macro_left7 = 1;
        int $org_scalatest_assert_macro_right7 = metaClient.getActiveTimeline().filterPendingClusteringTimeline().getInstants().size();
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 782));
    }

    public static final /* synthetic */ void $anonfun$new$39(TestClusteringProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        scala.collection.immutable.Map hudiOptions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.table.name"), (Object)tableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.write.table.type"), (Object)"COPY_ON_WRITE"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.write.recordkey.field"), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.write.partitionpath.field"), (Object)"a,b,c"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.clean.automatic"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.metadata.enable"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.clustering.inline"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.clustering.inline.max.commits"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.cleaner.commits.retained"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.write.operation"), (Object)"insert_overwrite")}));
        Seq data = (Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)4)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)4)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3)), (List)Nil$.MODULE$)));
        StructType schema = new StructType((StructField[])((Object[])new StructField[]{new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("c", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4())}));
        Dataset df = $this.spark().createDataFrame($this.spark().sparkContext().parallelize(data, $this.spark().sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple3.class)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                int a = BoxesRunTime.unboxToInt((Object)tuple3._1());
                int b = BoxesRunTime.unboxToInt((Object)tuple3._2());
                int c = BoxesRunTime.unboxToInt((Object)tuple3._3());
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)a), BoxesRunTime.boxToInteger((int)b), BoxesRunTime.boxToInteger((int)c)}));
            }
            throw new MatchError((Object)tuple3);
        }, ClassTag$.MODULE$.apply(Row.class)), schema);
        df.write().options((Map)hudiOptions).format("hudi").mode("append").save(String.valueOf(basePath));
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)$this.spark().sql(new StringBuilder(32).append("call show_clustering(path => '").append(basePath).append("')").toString()).count()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 824));
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)$this.spark().sql(new StringBuilder(44).append("call show_clustering(path => '").append(basePath).append("', limit => 1)").toString()).count()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 825));
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)$this.spark().sql(new StringBuilder(44).append("call show_clustering(path => '").append(basePath).append("', limit => 2)").toString()).count()), Prettifier$.MODULE$.default(), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 826));
    }

    public static final /* synthetic */ void $anonfun$avgRecord$1(TimelineLayout layout$1, HoodieTimeline commitTimeline$1, LongRef totalByteSize$1, LongRef totalRecordsCount$1, Object instant) {
        HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)layout$1.getCommitMetadataSerDe().deserialize((HoodieInstant)instant, (byte[])commitTimeline$1.getInstantDetails((HoodieInstant)instant).get(), HoodieCommitMetadata.class);
        totalByteSize$1.elem += commitMetadata.fetchTotalBytesWritten();
        totalRecordsCount$1.elem += commitMetadata.fetchTotalRecordsWritten();
    }

    public static final /* synthetic */ Pair $anonfun$writeRecords$2(int x$3, int y) {
        return Pair.of((Object)BoxesRunTime.boxToInteger((int)x$3), (Object)BoxesRunTime.boxToInteger((int)y));
    }

    public static final /* synthetic */ Stream $anonfun$writeRecords$1(int rowDimension$1, int x) {
        return (Stream)package$.MODULE$.Stream().range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)rowDimension$1), (Object)BoxesRunTime.boxToInteger((int)1), (Integral)Numeric.IntIsIntegral$.MODULE$).map((Function1 & Serializable & scala.Serializable)y -> TestClusteringProcedure.$anonfun$writeRecords$2(x, BoxesRunTime.unboxToInt((Object)y)), Stream$.MODULE$.canBuildFrom());
    }

    public TestClusteringProcedure() {
        this.test("Test Call run_clustering Procedure By Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestClusteringProcedure.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test("Test Call run_clustering Procedure By Path", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestClusteringProcedure.$anonfun$new$7(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        this.test("Test Call run_clustering Procedure With Partition Pruning", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestClusteringProcedure.$anonfun$new$13(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
        this.test("Test Call run_clustering Procedure with specific instants", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestClusteringProcedure.$anonfun$new$23(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416));
        this.test("Test Call run_clustering Procedure op", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestClusteringProcedure.$anonfun$new$27(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 485));
        this.test("Test Call run_clustering Procedure Order Strategy", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestClusteringProcedure.$anonfun$new$29(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 542));
        this.test("Test Call run_clustering with partition selected", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestClusteringProcedure.$anonfun$new$31(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 633));
        this.test("Test Call run_clustering with unsupported bucket index", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestClusteringProcedure.$anonfun$new$35(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 699));
        this.test("Test Call run_clustering with limit parameter", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestClusteringProcedure.$anonfun$new$37(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 731));
        this.test("Test Call show_clustering with limit", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestClusteringProcedure.$anonfun$new$39(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestClusteringProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 786));
    }
}

