/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.procedure;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.hudi.procedure.HoodieSparkProcedureTestBase;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001a1AAA\u0002\u0001!!)Q\u0003\u0001C\u0001-\t9B+Z:u\u0007>l\u0007/Y2uS>t\u0007K]8dK\u0012,(/\u001a\u0006\u0003\t\u0015\t\u0011\u0002\u001d:pG\u0016$WO]3\u000b\u0005\u00199\u0011\u0001\u00025vI&T!\u0001C\u0005\u0002\u0007M\fHN\u0003\u0002\u000b\u0017\u0005)1\u000f]1sW*\u0011A\"D\u0001\u0007CB\f7\r[3\u000b\u00039\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I\u0019R\"A\u0002\n\u0005Q\u0019!\u0001\b%p_\u0012LWm\u00159be.\u0004&o\\2fIV\u0014X\rV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"A\u0005\u0001")
public class TestCompactionProcedure
extends HoodieSparkProcedureTestBase {
    public static final /* synthetic */ void $anonfun$new$2(TestCompactionProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(326).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("'\n           | tblproperties (\n           |  primaryKey ='id',\n           |  type = 'mor',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql("set hoodie.parquet.max.file.size = 10000");
        $this.spark().sql("set hoodie.compact.inline=false");
        $this.spark().sql("set hoodie.compact.schedule.inline=false");
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(4, 'a4', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 11 where id = 1").toString());
        Seq[] resultA = (Seq[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(50).append("call run_compaction(op => 'schedule', table => '").append(tableName).append("')").toString()).collect())).map((Function1 & Serializable & scala.Serializable)row -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row.getString(0), BoxesRunTime.boxToInteger((int)row.getInt(1)), row.getString(2)})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)));
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 12 where id = 2").toString());
        Seq[] resultB = (Seq[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(35).append("call run_compaction('schedule', '").append(tableName).append("')").toString()).collect())).map((Function1 & Serializable & scala.Serializable)row -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row.getString(0), BoxesRunTime.boxToInteger((int)row.getInt(1)), row.getString(2)})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)));
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)resultA.length), Prettifier$.MODULE$.default(), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)resultB.length), Prettifier$.MODULE$.default(), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        String showCompactionSql = new StringBuilder(46).append("call show_compaction(table => '").append(tableName).append("', limit => 10)").toString();
        $this.checkAnswer(showCompactionSql, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{resultA[0], resultB[0]}));
        Row[] compactionRows = (Row[])$this.spark().sql(showCompactionSql).collect();
        String[] timestamps = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])compactionRows)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).sorted((Ordering)Ordering.String$.MODULE$);
        $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)timestamps.length), Prettifier$.MODULE$.default(), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        $this.checkAnswer(new StringBuilder(60).append("call run_compaction(op => 'run', table => '").append(tableName).append("', timestamp => ").append(timestamps[1]).append(")").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultB[0].head(), resultB[0].apply(1), HoodieInstant.State.COMPLETED.name()}))}));
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)11.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        Seq[] resultC = (Seq[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(24).append("call show_compaction('").append(tableName).append("')").toString()).collect())).map((Function1 & Serializable & scala.Serializable)row -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row.getString(0), BoxesRunTime.boxToInteger((int)row.getInt(1)), row.getString(2)})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)));
        $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)resultC.length), Prettifier$.MODULE$.default(), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        $this.checkAnswer(new StringBuilder(60).append("call run_compaction(op => 'run', table => '").append(tableName).append("', timestamp => ").append(timestamps[0]).append(")").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultA[0].head(), resultA[0].apply(1), HoodieInstant.State.COMPLETED.name()}))}));
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)11.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)((Row[])$this.spark().sql(new StringBuilder(33).append("call show_compaction(table => '").append(tableName).append("')").toString()).collect()).length), Prettifier$.MODULE$.default(), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
    }

    public static final /* synthetic */ void $anonfun$new$8(TestCompactionProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(326).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("'\n           | tblproperties (\n           |  primaryKey ='id',\n           |  type = 'mor',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql("set hoodie.parquet.max.file.size = 10000");
        $this.spark().sql("set hoodie.compact.inline=false");
        $this.spark().sql("set hoodie.compact.schedule.inline=false");
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 11 where id = 1").toString());
        $this.checkAnswer(new StringBuilder(44).append("call run_compaction(op => 'run', path => '").append(tmp.getCanonicalPath()).append("')").toString(), (Seq<Seq<Object>>)Nil$.MODULE$);
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)11.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.assertResult(BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)((Row[])$this.spark().sql(new StringBuilder(32).append("call show_compaction(path => '").append(tmp.getCanonicalPath()).append("')").toString()).collect()).length), Prettifier$.MODULE$.default(), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 12 where id = 1").toString());
        Seq[] resultA = (Seq[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(48).append("call run_compaction(op=> 'schedule', path => '").append(tmp.getCanonicalPath()).append("')").toString()).collect())).map((Function1 & Serializable & scala.Serializable)row -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row.getString(0), BoxesRunTime.boxToInteger((int)row.getInt(1)), row.getString(2)})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)));
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 12 where id = 2").toString());
        Seq[] resultB = (Seq[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(49).append("call run_compaction(op => 'schedule', path => '").append(tmp.getCanonicalPath()).append("')").toString()).collect())).map((Function1 & Serializable & scala.Serializable)row -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row.getString(0), BoxesRunTime.boxToInteger((int)row.getInt(1)), row.getString(2)})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)));
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)resultA.length), Prettifier$.MODULE$.default(), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)resultB.length), Prettifier$.MODULE$.default(), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
        $this.checkAnswer(new StringBuilder(32).append("call show_compaction(path => '").append(tmp.getCanonicalPath()).append("')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{resultA[0], resultB[0]}));
        $this.checkAnswer(new StringBuilder(44).append("call run_compaction(op => 'run', path => '").append(tmp.getCanonicalPath()).append("')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultA[0].head(), resultA[0].apply(1), HoodieInstant.State.COMPLETED.name()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultB[0].head(), resultB[0].apply(1), HoodieInstant.State.COMPLETED.name()}))}));
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)((Row[])$this.spark().sql(new StringBuilder(32).append("call show_compaction(path => '").append(tmp.getCanonicalPath()).append("')").toString()).collect()).length), Prettifier$.MODULE$.default(), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        $this.checkException(new StringBuilder(65).append("call run_compaction(op => 'run', path => '").append(tmp.getCanonicalPath()).append("', timestamp => 12345L)").toString(), "specific 12345 instants is not exist");
    }

    public static final /* synthetic */ void $anonfun$new$12(TestCompactionProcedure $this, File tmp) {
        String tableName1 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(328).append("\n           |create table ").append(tableName1).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName1).append("'\n       ").toString())).stripMargin());
        $this.spark().sql("set hoodie.compact.inline=true");
        $this.spark().sql("set hoodie.compact.inline.max.delta.commits=2");
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName1).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(36).append("update ").append(tableName1).append(" set name = 'a2' where id = 1").toString());
        $this.spark().sql(new StringBuilder(36).append("update ").append(tableName1).append(" set name = 'a3' where id = 1").toString());
        $this.spark().sql(new StringBuilder(36).append("update ").append(tableName1).append(" set name = 'a4' where id = 1").toString());
        $this.assertResult(BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)((Row[])$this.spark().sql(new StringBuilder(33).append("call show_compaction(path => '").append(tmp.getCanonicalPath()).append("/").append(tableName1).append("')").toString()).collect()).length), Prettifier$.MODULE$.default(), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
    }

    public static final /* synthetic */ void $anonfun$new$15(TestCompactionProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(351).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  type = 'mor',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n             | location '").append(tmp.getCanonicalPath()).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(36).append("update ").append(tableName).append(" set name = 'a2' where id = 1").toString());
        $this.spark().sql(new StringBuilder(36).append("update ").append(tableName).append(" set name = 'a3' where id = 1").toString());
        Row[] result1 = (Row[])$this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(255).append("call run_compaction(table => '").append(tableName).append("', op => 'run', options => \"\n             | hoodie.compaction.strategy=org.apache.hudi.table.action.compact.strategy.LogFileNumBasedCompactionStrategy,\n             | hoodie.compaction.logfile.num.threshold=3\n             |\")").toString())).stripMargin()).collect();
        $this.assertResult(BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)result1.length), Prettifier$.MODULE$.default(), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
        $this.spark().sql(new StringBuilder(36).append("update ").append(tableName).append(" set name = 'a4' where id = 1").toString());
        Row[] result2 = (Row[])$this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(255).append("call run_compaction(table => '").append(tableName).append("', op => 'run', options => \"\n             | hoodie.compaction.strategy=org.apache.hudi.table.action.compact.strategy.LogFileNumBasedCompactionStrategy,\n             | hoodie.compaction.logfile.num.threshold=3\n             |\")").toString())).stripMargin()).collect();
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)result2.length), Prettifier$.MODULE$.default(), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
    }

    public static final /* synthetic */ void $anonfun$new$18(TestCompactionProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(351).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  type = 'mor',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n             | location '").append(tmp.getCanonicalPath()).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(36).append("update ").append(tableName).append(" set name = 'a2' where id = 1").toString());
        $this.spark().sql(new StringBuilder(50).append("call run_compaction(table => '").append(tableName).append("', op => 'schedule')").toString());
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((String)tmp.getCanonicalPath());
        List instants = metaClient.getActiveTimeline().filterPendingCompactionTimeline().getInstants();
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)instants.size()), Prettifier$.MODULE$.default(), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
        String ts = ((HoodieInstant)instants.get(0)).requestedTime();
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)((Row[])$this.spark().sql(new StringBuilder(65).append("call run_compaction(table => '").append(tableName).append("', op => 'execute', instants => '").append(ts).append("')").toString()).collect()).length), Prettifier$.MODULE$.default(), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        $this.checkExceptionContain(new StringBuilder(71).append("call run_compaction(table => '").append(tableName).append("', op => 'execute', instants => '000000')").toString(), "specific 000000 instants is not exist");
    }

    public static final /* synthetic */ void $anonfun$new$21(TestCompactionProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(351).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  type = 'mor',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n             | location '").append(tmp.getCanonicalPath()).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(36).append("update ").append(tableName).append(" set name = 'a2' where id = 1").toString());
        $this.assertResult(BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)((Row[])$this.spark().sql(new StringBuilder(49).append("call run_compaction(table => '").append(tableName).append("', op => 'execute')").toString()).collect()).length), Prettifier$.MODULE$.default(), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)((Row[])$this.spark().sql(new StringBuilder(50).append("call run_compaction(table => '").append(tableName).append("', op => 'schedule')").toString()).collect()).length), Prettifier$.MODULE$.default(), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)((Row[])$this.spark().sql(new StringBuilder(49).append("call run_compaction(table => '").append(tableName).append("', op => 'execute')").toString()).collect()).length), Prettifier$.MODULE$.default(), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
        $this.spark().sql(new StringBuilder(36).append("update ").append(tableName).append(" set name = 'a3' where id = 1").toString());
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)((Row[])$this.spark().sql(new StringBuilder(60).append("call run_compaction(table => '").append(tableName).append("', op => 'scheduleAndExecute')").toString()).collect()).length), Prettifier$.MODULE$.default(), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
    }

    public static final /* synthetic */ void $anonfun$new$24(TestCompactionProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(351).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  type = 'mor',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n             | location '").append(basePath).append("'\n       ").toString())).stripMargin());
        Configuration conf = new Configuration();
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)new HadoopStorageConfiguration(conf), (String)basePath);
        int $org_scalatest_assert_macro_left = 0;
        int $org_scalatest_assert_macro_right = metaClient.getActiveTimeline().getCompletedReplaceTimeline().getInstants().size();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metaClient.getActiveTimeline().filterPendingClusteringTimeline().empty(), "metaClient.getActiveTimeline().filterPendingClusteringTimeline().empty()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(36).append("update ").append(tableName).append(" set name = 'a2' where id = 1").toString());
        $this.spark().sql(new StringBuilder(50).append("call run_compaction(table => '").append(tableName).append("', op => 'schedule')").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'b1', 20, 3000)").toString());
        $this.spark().sql(new StringBuilder(36).append("update ").append(tableName).append(" set name = 'b3' where id = 2").toString());
        $this.spark().sql(new StringBuilder(50).append("call run_compaction(table => '").append(tableName).append("', op => 'schedule')").toString());
        metaClient.reloadActiveTimeline();
        int $org_scalatest_assert_macro_left2 = 2;
        int $org_scalatest_assert_macro_right2 = metaClient.getActiveTimeline().filterPendingCompactionTimeline().getInstants().size();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
        $this.spark().sql(new StringBuilder(61).append("call run_compaction(table => '").append(tableName).append("', op => 'execute', limit => 1)").toString());
        metaClient.reloadActiveTimeline();
        int $org_scalatest_assert_macro_left3 = 1;
        int $org_scalatest_assert_macro_right3 = metaClient.getActiveTimeline().filterPendingCompactionTimeline().getInstants().size();
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
    }

    public TestCompactionProcedure() {
        this.test("Test Call run_compaction Procedure by Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCompactionProcedure.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        this.test("Test Call run_compaction Procedure by Path", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCompactionProcedure.$anonfun$new$8(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        this.test("Test show_compaction Procedure by Path", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCompactionProcedure.$anonfun$new$12(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        this.test("Test run_compaction Procedure with options", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.compact.inline"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.compact.inline.max.delta.commits"), (Object)"1")}), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCompactionProcedure.$anonfun$new$15(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
        this.test("Test Call run_compaction Procedure with specific instants", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.compact.inline"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.compact.inline.max.delta.commits"), (Object)"1")}), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCompactionProcedure.$anonfun$new$18(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
        this.test("Test Call run_compaction Procedure with operation", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.compact.inline"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.compact.inline.max.delta.commits"), (Object)"1")}), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCompactionProcedure.$anonfun$new$21(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
        this.test("Test Call run_clustering with limit parameter", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.compact.inline"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.compact.inline.max.delta.commits"), (Object)"1")}), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestCompactionProcedure.$anonfun$new$24(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestCompactionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
    }
}

