/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.procedure;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.hudi.procedure.HoodieSparkProcedureTestBase;
import org.junit.jupiter.api.Assertions;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple8;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t-a\u0001B\u0011#\u0001=BQ\u0001\u000e\u0001\u0005\u0002UBQa\u000e\u0001\u0005\u0002aBq!a\u000b\u0001\t\u0003\ti\u0003C\u0004\u0002J\u0001!I!a\u0013\u0007\r\u0005-\u0004\u0001AA7\u0011)\t)(\u0002BA\u0002\u0013\u0005\u0011q\u000f\u0005\u000b\u0003\u007f*!\u00111A\u0005\u0002\u0005\u0005\u0005BCAD\u000b\t\u0005\t\u0015)\u0003\u0002z!I\u0011\u0011R\u0003\u0003\u0002\u0004%\tA\u001c\u0005\u000b\u0003\u0017+!\u00111A\u0005\u0002\u00055\u0005\"CAI\u000b\t\u0005\t\u0015)\u0003b\u0011%\t\u0019*\u0002BA\u0002\u0013\u0005a\u000e\u0003\u0006\u0002\u0016\u0016\u0011\t\u0019!C\u0001\u0003/C\u0011\"a'\u0006\u0005\u0003\u0005\u000b\u0015B1\t\u0013\u0005uUA!a\u0001\n\u0003q\u0007BCAP\u000b\t\u0005\r\u0011\"\u0001\u0002\"\"I\u0011QU\u0003\u0003\u0002\u0003\u0006K!\u0019\u0005\u000b\u0003O+!\u00111A\u0005\u0002\u0005%\u0006BCAY\u000b\t\u0005\r\u0011\"\u0001\u00024\"Q\u0011qW\u0003\u0003\u0002\u0003\u0006K!a+\t\u0015\u0005eVA!a\u0001\n\u0003\tI\u000b\u0003\u0006\u0002<\u0016\u0011\t\u0019!C\u0001\u0003{C!\"!1\u0006\u0005\u0003\u0005\u000b\u0015BAV\u0011)\t\u0019-\u0002BA\u0002\u0013\u0005\u0011\u0011\u0016\u0005\u000b\u0003\u000b,!\u00111A\u0005\u0002\u0005\u001d\u0007BCAf\u000b\t\u0005\t\u0015)\u0003\u0002,\"Q\u0011QZ\u0003\u0003\u0002\u0004%\t!!+\t\u0015\u0005=WA!a\u0001\n\u0003\t\t\u000e\u0003\u0006\u0002V\u0016\u0011\t\u0011)Q\u0005\u0003WCa\u0001N\u0003\u0005\u0002\u0005]\u0007bBAw\u000b\u0011\u0005\u0013q\u001e\u0005\b\u0005\u0003)A\u0011\tB\u0002\u0005y!Vm\u001d;II\u001a\u001c\b+\u0019:rk\u0016$\u0018*\u001c9peR\u0004&o\\2fIV\u0014XM\u0003\u0002$I\u0005I\u0001O]8dK\u0012,(/\u001a\u0006\u0003K\u0019\nA\u0001[;eS*\u0011q\u0005K\u0001\u0004gFd'BA\u0015+\u0003\u0015\u0019\b/\u0019:l\u0015\tYC&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002[\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\r\t\u0003cIj\u0011AI\u0005\u0003g\t\u0012A\u0004S8pI&,7\u000b]1sWB\u0013xnY3ekJ,G+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u0002mA\u0011\u0011\u0007A\u0001\u0014GJ,\u0017\r^3J]N,'\u000f\u001e*fG>\u0014Hm\u001d\u000b\u0003s%\u00032AO B\u001b\u0005Y$B\u0001\u001f>\u0003\u0011)H/\u001b7\u000b\u0003y\nAA[1wC&\u0011\u0001i\u000f\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002C\u000f6\t1I\u0003\u0002E\u000b\u00069q-\u001a8fe&\u001c'B\u0001$+\u0003\u0011\tgO]8\n\u0005!\u001b%!D$f]\u0016\u0014\u0018n\u0019*fG>\u0014H\rC\u0003K\u0005\u0001\u00071*A\u0005te\u000e4u\u000e\u001c3feB\u0011A*U\u0007\u0002\u001b*\u0011ajT\u0001\u0003MNT!\u0001\u0015\u0016\u0002\r!\fGm\\8q\u0013\t\u0011VJ\u0001\u0003QCRD\u0007f\u0001\u0002UAB\u0019Q\u000b\u0017.\u000e\u0003YS\u0011aV\u0001\u0006g\u000e\fG.Y\u0005\u00033Z\u0013a\u0001\u001e5s_^\u001c\bCA._\u001b\u0005a&BA/>\u0003\tIw.\u0003\u0002`9\nY\u0011jT#yG\u0016\u0004H/[8oc\u0015q\u0012\r\\A\u0006!\t\u0011\u0017N\u0004\u0002dOB\u0011AMV\u0007\u0002K*\u0011aML\u0001\u0007yI|w\u000e\u001e \n\u0005!4\u0016A\u0002)sK\u0012,g-\u0003\u0002kW\n11\u000b\u001e:j]\u001eT!\u0001\u001b,2\r\rj\u0017/!\u0001s+\tqw.F\u0001b\t\u0015\u0001hF1\u0001v\u0005\u0005!\u0016B\u0001:t\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0011AOV\u0001\u0007i\"\u0014xn^:\u0012\u0005YL\bCA+x\u0013\tAhKA\u0004O_RD\u0017N\\4\u0011\u0005ilhBA+|\u0013\tah+A\u0004qC\u000e\\\u0017mZ3\n\u0005y|(!\u0003+ie><\u0018M\u00197f\u0015\tah+\r\u0005$\u0003\u0007\t)!a\u0002u\u001d\r)\u0016QA\u0005\u0003iZ\u000bTAI+W\u0003\u0013\u0011Qa]2bY\u0006\f$A\n.)\u000b\t\ty!!\t\u0011\tUC\u0016\u0011\u0003\t\u0005\u0003'\ti\"\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003\u0019\u0001\u0018M]:fe*\u0019\u00111\u0004\u0014\u0002\u0011\r\fG/\u00197zgRLA!a\b\u0002\u0016\tq\u0001+\u0019:tK\u0016C8-\u001a9uS>t\u0017G\u0002\u0010b\u0003G\tI#\r\u0004$[F\f)C]\u0019\tG\u0005\r\u0011QAA\u0014iF*!%\u0016,\u0002\nE\u001aa%!\u0005\u0002'\r\u0014X-\u0019;f+B\u001cXM\u001d;SK\u000e|'\u000fZ:\u0015\u0007e\ny\u0003C\u0003K\u0007\u0001\u00071\n\u000b\u0003\u0004)\u0006M\u0012G\u0002\u0010b\u0003k\tY$\r\u0004$[F\f9D]\u0019\tG\u0005\r\u0011QAA\u001diF*!%\u0016,\u0002\nE\u0012aE\u0017\u0015\u0006\u0007\u0005=\u0011qH\u0019\u0007=\u0005\f\t%a\u00122\r\rj\u0017/a\u0011sc!\u0019\u00131AA\u0003\u0003\u000b\"\u0018'\u0002\u0012V-\u0006%\u0011g\u0001\u0014\u0002\u0012\u0005\u0001b/\u001a:jMf\u0014Vm];mi\u0012\u000bG/\u0019\u000b\t\u0003\u001b\n\u0019&a\u0016\u0002hA\u0019Q+a\u0014\n\u0007\u0005EcK\u0001\u0003V]&$\bBBA+\t\u0001\u0007\u0011(\u0001\u0006fqB,7\r\u001e#bi\u0006Dq!!\u0017\u0005\u0001\u0004\tY&A\u0004ti>\u0014\u0018mZ3\u0011\t\u0005u\u00131M\u0007\u0003\u0003?RA!!\u0017\u0002b)\u0011QEK\u0005\u0005\u0003K\nyFA\u0007I_>$\u0017.Z*u_J\fw-\u001a\u0005\u0007\u0003S\"\u0001\u0019A1\u0002\u0013Q\f'\r\\3QCRD'a\u0004%p_\u0012LW\r\u0016:ja6{G-\u001a7\u0014\u0007\u0015\ty\u0007E\u0002V\u0003cJ1!a\u001dW\u0005\u0019\te.\u001f*fM\u0006IA/[7fgR\fW\u000e]\u000b\u0003\u0003s\u00022!VA>\u0013\r\tiH\u0016\u0002\u0005\u0019>tw-A\u0007uS6,7\u000f^1na~#S-\u001d\u000b\u0005\u0003\u001b\n\u0019\tC\u0005\u0002\u0006\u001e\t\t\u00111\u0001\u0002z\u0005\u0019\u0001\u0010J\u0019\u0002\u0015QLW.Z:uC6\u0004\b%\u0001\u0004s_^\\U-_\u0001\u000be><8*Z=`I\u0015\fH\u0003BA'\u0003\u001fC\u0001\"!\"\u000b\u0003\u0003\u0005\r!Y\u0001\be><8*Z=!\u0003\u0015\u0011\u0018\u000eZ3s\u0003%\u0011\u0018\u000eZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002N\u0005e\u0005\u0002CAC\u001b\u0005\u0005\t\u0019A1\u0002\rILG-\u001a:!\u0003\u0019!'/\u001b<fe\u0006QAM]5wKJ|F%Z9\u0015\t\u00055\u00131\u0015\u0005\t\u0003\u000b\u0003\u0012\u0011!a\u0001C\u00069AM]5wKJ\u0004\u0013\u0001\u00032fO&tG*\u0019;\u0016\u0005\u0005-\u0006cA+\u0002.&\u0019\u0011q\u0016,\u0003\r\u0011{WO\u00197f\u00031\u0011WmZ5o\u0019\u0006$x\fJ3r)\u0011\ti%!.\t\u0013\u0005\u00155#!AA\u0002\u0005-\u0016!\u00032fO&tG*\u0019;!\u0003!\u0011WmZ5o\u0019>t\u0017\u0001\u00042fO&tGj\u001c8`I\u0015\fH\u0003BA'\u0003\u007fC\u0011\"!\"\u0017\u0003\u0003\u0005\r!a+\u0002\u0013\t,w-\u001b8M_:\u0004\u0013AB3oI2\u000bG/\u0001\u0006f]\u0012d\u0015\r^0%KF$B!!\u0014\u0002J\"I\u0011QQ\r\u0002\u0002\u0003\u0007\u00111V\u0001\bK:$G*\u0019;!\u0003\u0019)g\u000e\u001a'p]\u0006QQM\u001c3M_:|F%Z9\u0015\t\u00055\u00131\u001b\u0005\n\u0003\u000bc\u0012\u0011!a\u0001\u0003W\u000bq!\u001a8e\u0019>t\u0007\u0005\u0006\n\u0002Z\u0006u\u0017q\\Aq\u0003G\f)/a:\u0002j\u0006-\bcAAn\u000b5\t\u0001\u0001C\u0004\u0002vy\u0001\r!!\u001f\t\r\u0005%e\u00041\u0001b\u0011\u0019\t\u0019J\ba\u0001C\"1\u0011Q\u0014\u0010A\u0002\u0005Dq!a*\u001f\u0001\u0004\tY\u000bC\u0004\u0002:z\u0001\r!a+\t\u000f\u0005\rg\u00041\u0001\u0002,\"9\u0011Q\u001a\u0010A\u0002\u0005-\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0002r\u0006]\bcA+\u0002t&\u0019\u0011Q\u001f,\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011`\u0010A\u0002\u0005m\u0018!A8\u0011\u0007U\u000bi0C\u0002\u0002\u0000Z\u00131!\u00118z\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B\u0003!\r)&qA\u0005\u0004\u0005\u00131&aA%oi\u0002")
public class TestHdfsParquetImportProcedure
extends HoodieSparkProcedureTestBase {
    public List<GenericRecord> createInsertRecords(Path srcFolder) throws ParseException, IOException {
        Path srcFile = new Path(srcFolder.toString(), "file1.parquet");
        long startTime = TimelineUtils.parseDateFromInstantTime((String)"20170203000000").getTime() / 1000L;
        ArrayList<GenericRecord> records = new ArrayList<GenericRecord>();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 96).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)recordNum -> records.add(new HoodieTestDataGenerator().generateGenericRecord(Integer.toString(recordNum), "0", new StringBuilder(6).append("rider-").append(recordNum).toString(), new StringBuilder(7).append("driver-").append(recordNum).toString(), startTime + TimeUnit.HOURS.toSeconds(recordNum))));
        try (ParquetWriter writer = AvroParquetWriter.builder((Path)srcFile).withSchema(HoodieTestDataGenerator.AVRO_SCHEMA).withConf((Configuration)HoodieTestUtils.getDefaultStorageConf().unwrap()).build();){
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(records).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
                writer.write((Object)record);
                return BoxedUnit.UNIT;
            });
        }
        return records;
    }

    public List<GenericRecord> createUpsertRecords(Path srcFolder) throws ParseException, IOException {
        Path srcFile = new Path(srcFolder.toString(), "file1.parquet");
        long startTime = TimelineUtils.parseDateFromInstantTime((String)"20170203000000").getTime() / 1000L;
        ArrayList<GenericRecord> records = new ArrayList<GenericRecord>();
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 11).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)recordNum -> records.add(dataGen.generateGenericRecord(Integer.toString(recordNum), "0", new StringBuilder(13).append("rider-upsert-").append(recordNum).toString(), new StringBuilder(13).append("driver-upsert").append(recordNum).toString(), startTime + TimeUnit.HOURS.toSeconds(recordNum))));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(96), 100).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)recordNum -> records.add(dataGen.generateGenericRecord(Integer.toString(recordNum), "0", new StringBuilder(13).append("rider-upsert-").append(recordNum).toString(), new StringBuilder(13).append("driver-upsert").append(recordNum).toString(), startTime + TimeUnit.HOURS.toSeconds(recordNum))));
        try (ParquetWriter writer = AvroParquetWriter.builder((Path)srcFile).withSchema(HoodieTestDataGenerator.AVRO_SCHEMA).withConf((Configuration)HoodieTestUtils.getDefaultStorageConf().unwrap()).build();){
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(records).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
                writer.write((Object)record);
                return BoxedUnit.UNIT;
            });
        }
        return records;
    }

    private void verifyResultData(List<GenericRecord> expectData, HoodieStorage storage, String tablePath) {
        JavaSparkContext jsc = new JavaSparkContext(this.spark().sparkContext());
        Dataset ds = HoodieClientTestUtils.read((JavaSparkContext)jsc, (String)tablePath, (SQLContext)this.spark().sqlContext(), (HoodieStorage)storage, (String[])new String[]{new StringBuilder(8).append(tablePath).append("/*/*/*/*").toString()});
        List readData = ds.select("timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_row_key", "rider", "driver", "begin_lat", "begin_lon", "end_lat", "end_lon"})).collectAsList();
        Buffer result = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(readData).asScala()).map((Function1 & Serializable & scala.Serializable)row -> new HoodieTripModel(this, row.getLong(0), row.getString(1), row.getString(2), row.getString(3), row.getDouble(4), row.getDouble(5), row.getDouble(6), row.getDouble(7)), Buffer$.MODULE$.canBuildFrom());
        Buffer expected = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(expectData).asScala()).map((Function1 & Serializable & scala.Serializable)g -> new HoodieTripModel(this, BoxesRunTime.unboxToLong((Object)g.get("timestamp")), g.get("_row_key").toString(), g.get("rider").toString(), g.get("driver").toString(), new StringOps(Predef$.MODULE$.augmentString(g.get("begin_lat").toString())).toDouble(), new StringOps(Predef$.MODULE$.augmentString(g.get("begin_lon").toString())).toDouble(), new StringOps(Predef$.MODULE$.augmentString(g.get("end_lat").toString())).toDouble(), new StringOps(Predef$.MODULE$.augmentString(g.get("end_lon").toString())).toDouble()), Buffer$.MODULE$.canBuildFrom());
        Assertions.assertTrue((expected.size() == result.size() || ((List)JavaConverters$.MODULE$.bufferAsJavaListConverter(result).asJava()).containsAll((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(expected).asJava()) && ((List)JavaConverters$.MODULE$.bufferAsJavaListConverter(expected).asJava()).containsAll((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(result).asJava()) ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$new$2(TestHdfsParquetImportProcedure $this, File tmp) {
        HoodieStorage storage = HoodieStorageUtils.getStorage((String)tmp.getCanonicalPath(), (StorageConfiguration)HadoopFSUtils.getStorageConf((Configuration)$this.spark().sparkContext().hadoopConfiguration()));
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        Path sourcePath = new Path(tmp.getCanonicalPath(), "source");
        Path targetPath = new Path(tablePath);
        String schemaFile = new Path(tmp.getCanonicalPath(), "file.schema").toString();
        try (OutputStream schemaFileOS = storage.create(new StoragePath(schemaFile));){
            schemaFileOS.write(StringUtils.getUTF8Bytes((String)"{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}"));
        }
        List<GenericRecord> insertData = $this.createInsertRecords(sourcePath);
        $this.checkExceptionContain("call hdfs_parquet_import(table_type => 'mor')", "Argument: table is required");
        $this.checkAnswer(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(216).append("call hdfs_parquet_import(\n           |table => '").append(tableName).append("', table_type => '").append(HoodieTableType.COPY_ON_WRITE.name()).append("',\n           |src_path => '").append(sourcePath).append("', target_path => '").append(targetPath).append("',\n           |row_key => '_row_key', partition_key => 'timestamp',\n           |schema_file_path => '").append(schemaFile).append("')").toString())).stripMargin(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))}));
        $this.verifyResultData(insertData, storage, tablePath);
    }

    public static final /* synthetic */ void $anonfun$new$4(TestHdfsParquetImportProcedure $this, File tmp) {
        HoodieStorage storage = HoodieStorageUtils.getStorage((String)tmp.getCanonicalPath(), (StorageConfiguration)HadoopFSUtils.getStorageConf((Configuration)$this.spark().sparkContext().hadoopConfiguration()));
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        Path sourcePath = new Path(tmp.getCanonicalPath(), "source");
        Path targetPath = new Path(tablePath);
        String schemaFile = new Path(tmp.getCanonicalPath(), "file.schema").toString();
        try (OutputStream schemaFileOS = storage.create(new StoragePath(schemaFile));){
            schemaFileOS.write(StringUtils.getUTF8Bytes((String)"{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}"));
        }
        List<GenericRecord> insertData = $this.createUpsertRecords(sourcePath);
        $this.checkExceptionContain("call hdfs_parquet_import(table_type => 'mor')", "Argument: table is required");
        $this.checkAnswer(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(237).append("call hdfs_parquet_import(\n           |table => '").append(tableName).append("', table_type => '").append(HoodieTableType.COPY_ON_WRITE.name()).append("',\n           |src_path => '").append(sourcePath).append("', target_path => '").append(targetPath).append("',\n           |row_key => '_row_key', partition_key => 'timestamp',\n           |schema_file_path => '").append(schemaFile).append("', command => 'upsert')").toString())).stripMargin(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))}));
        $this.verifyResultData(insertData, storage, tablePath);
    }

    public TestHdfsParquetImportProcedure() {
        this.test("Test Call hdfs_parquet_import Procedure with insert operation", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestHdfsParquetImportProcedure.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestHdfsParquetImportProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        this.test("Test Call hdfs_parquet_import Procedure with upsert operation", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestHdfsParquetImportProcedure.$anonfun$new$4(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestHdfsParquetImportProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
    }

    public class HoodieTripModel {
        private long timestamp;
        private String rowKey;
        private String rider;
        private String driver;
        private double beginLat;
        private double beginLon;
        private double endLat;
        private double endLon;
        public final /* synthetic */ TestHdfsParquetImportProcedure $outer;

        public long timestamp() {
            return this.timestamp;
        }

        public void timestamp_$eq(long x$1) {
            this.timestamp = x$1;
        }

        public String rowKey() {
            return this.rowKey;
        }

        public void rowKey_$eq(String x$1) {
            this.rowKey = x$1;
        }

        public String rider() {
            return this.rider;
        }

        public void rider_$eq(String x$1) {
            this.rider = x$1;
        }

        public String driver() {
            return this.driver;
        }

        public void driver_$eq(String x$1) {
            this.driver = x$1;
        }

        public double beginLat() {
            return this.beginLat;
        }

        public void beginLat_$eq(double x$1) {
            this.beginLat = x$1;
        }

        public double beginLon() {
            return this.beginLon;
        }

        public void beginLon_$eq(double x$1) {
            this.beginLon = x$1;
        }

        public double endLat() {
            return this.endLat;
        }

        public void endLat_$eq(double x$1) {
            this.endLat = x$1;
        }

        public double endLon() {
            return this.endLon;
        }

        public void endLon_$eq(double x$1) {
            this.endLon = x$1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            HoodieTripModel hoodieTripModel = this;
            Object object = o;
            if (hoodieTripModel == null) {
                if (object == null) return true;
            } else if (((Object)hoodieTripModel).equals(object)) {
                return true;
            }
            if (o == null) return false;
            if (this.getClass() != o.getClass()) {
                return false;
            }
            HoodieTripModel other = (HoodieTripModel)o;
            if (this.timestamp() != other.timestamp()) return false;
            String string = this.rowKey();
            String string2 = other.rowKey();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.rider();
            String string4 = other.rider();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.driver();
            String string6 = other.driver();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            if (this.beginLat() != other.beginLat()) return false;
            if (this.beginLon() != other.beginLon()) return false;
            if (this.endLat() != other.endLat()) return false;
            if (this.endLon() != other.endLon()) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hashCode(new Tuple8((Object)BoxesRunTime.boxToLong((long)this.timestamp()), (Object)this.rowKey(), (Object)this.rider(), (Object)this.driver(), (Object)BoxesRunTime.boxToDouble((double)this.beginLat()), (Object)BoxesRunTime.boxToDouble((double)this.beginLon()), (Object)BoxesRunTime.boxToDouble((double)this.endLat()), (Object)BoxesRunTime.boxToDouble((double)this.endLon())));
        }

        public /* synthetic */ TestHdfsParquetImportProcedure org$apache$spark$sql$hudi$procedure$TestHdfsParquetImportProcedure$HoodieTripModel$$$outer() {
            return this.$outer;
        }

        public HoodieTripModel(TestHdfsParquetImportProcedure $outer, long timestamp, String rowKey, String rider, String driver, double beginLat, double beginLon, double endLat, double endLon) {
            this.timestamp = timestamp;
            this.rowKey = rowKey;
            this.rider = rider;
            this.driver = driver;
            this.beginLat = beginLat;
            this.beginLon = beginLon;
            this.endLat = endLat;
            this.endLon = endLon;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

