/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieIndexMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.index.HoodieSparkIndexClient;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.hudi.command.DropIndexCommand$;
import org.apache.spark.sql.hudi.command.IndexBaseCommand;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001\u0002\u000e\u001c\u0001\"B\u0001B\u000e\u0001\u0003\u0016\u0004%\ta\u000e\u0005\t\u0001\u0002\u0011\t\u0012)A\u0005q!A\u0011\t\u0001BK\u0002\u0013\u0005!\t\u0003\u0005O\u0001\tE\t\u0015!\u0003D\u0011!y\u0005A!f\u0001\n\u0003\u0001\u0006\u0002\u0003+\u0001\u0005#\u0005\u000b\u0011B)\t\u000bU\u0003A\u0011\u0001,\t\u000bm\u0003A\u0011\t/\t\u000f=\u0004\u0011\u0011!C\u0001a\"9A\u000fAI\u0001\n\u0003)\b\"CA\u0001\u0001E\u0005I\u0011AA\u0002\u0011%\t9\u0001AI\u0001\n\u0003\tI\u0001C\u0005\u0002\u000e\u0001\t\t\u0011\"\u0011\u0002\u0010!I\u0011q\u0004\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0005\u0005\n\u0003S\u0001\u0011\u0011!C\u0001\u0003WA\u0011\"a\u000e\u0001\u0003\u0003%\t%!\u000f\t\u0013\u0005\u001d\u0003!!A\u0005\u0002\u0005%\u0003\"CA'\u0001\u0005\u0005I\u0011IA(\u000f%\t\u0019fGA\u0001\u0012\u0003\t)F\u0002\u0005\u001b7\u0005\u0005\t\u0012AA,\u0011\u0019)F\u0003\"\u0001\u0002f!I\u0011q\r\u000b\u0002\u0002\u0013\u0015\u0013\u0011\u000e\u0005\n\u0003W\"\u0012\u0011!CA\u0003[B\u0011\"!\u001e\u0015\u0003\u0003%\t)a\u001e\t\u0013\u0005%E#!A\u0005\n\u0005-%\u0001\u0005#s_BLe\u000eZ3y\u0007>lW.\u00198e\u0015\taR$A\u0004d_6l\u0017M\u001c3\u000b\u0005yy\u0012\u0001\u00025vI&T!\u0001I\u0011\u0002\u0007M\fHN\u0003\u0002#G\u0005)1\u000f]1sW*\u0011A%J\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u0015.gA\u0011!fK\u0007\u00027%\u0011Af\u0007\u0002\u0011\u0013:$W\r\u001f\"bg\u0016\u001cu.\\7b]\u0012\u0004\"AL\u0019\u000e\u0003=R\u0011\u0001M\u0001\u0006g\u000e\fG.Y\u0005\u0003e=\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002/i%\u0011Qg\f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006i\u0006\u0014G.Z\u000b\u0002qA\u0011\u0011HP\u0007\u0002u)\u00111\bP\u0001\bG\u0006$\u0018\r\\8h\u0015\tit$\u0001\u0005dCR\fG._:u\u0013\ty$H\u0001\u0007DCR\fGn\\4UC\ndW-\u0001\u0004uC\ndW\rI\u0001\nS:$W\r\u001f(b[\u0016,\u0012a\u0011\t\u0003\t.s!!R%\u0011\u0005\u0019{S\"A$\u000b\u0005!;\u0013A\u0002\u001fs_>$h(\u0003\u0002K_\u00051\u0001K]3eK\u001aL!\u0001T'\u0003\rM#(/\u001b8h\u0015\tQu&\u0001\u0006j]\u0012,\u0007PT1nK\u0002\n\u0011#[4o_J,\u0017J\u001a(pi\u0016C\u0018n\u001d;t+\u0005\t\u0006C\u0001\u0018S\u0013\t\u0019vFA\u0004C_>dW-\u00198\u0002%%<gn\u001c:f\u0013\u001atu\u000e^#ySN$8\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t]C\u0016L\u0017\t\u0003U\u0001AQAN\u0004A\u0002aBQ!Q\u0004A\u0002\rCQaT\u0004A\u0002E\u000b1A];o)\ti&\u000eE\u0002_G\u001at!aX1\u000f\u0005\u0019\u0003\u0017\"\u0001\u0019\n\u0005\t|\u0013a\u00029bG.\fw-Z\u0005\u0003I\u0016\u00141aU3r\u0015\t\u0011w\u0006\u0005\u0002hQ6\tq$\u0003\u0002j?\t\u0019!k\\<\t\u000b-D\u0001\u0019\u00017\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005\u001dl\u0017B\u00018 \u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0011\u0019w\u000e]=\u0015\t]\u000b(o\u001d\u0005\bm%\u0001\n\u00111\u00019\u0011\u001d\t\u0015\u0002%AA\u0002\rCqaT\u0005\u0011\u0002\u0003\u0007\u0011+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003YT#\u0001O<,\u0003a\u0004\"!\u001f@\u000e\u0003iT!a\u001f?\u0002\u0013Ut7\r[3dW\u0016$'BA?0\u0003)\tgN\\8uCRLwN\\\u0005\u0003\u007fj\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!\u0002+\u0005\r;\u0018AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003\u0017Q#!U<\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\t\u0002\u0005\u0003\u0002\u0014\u0005uQBAA\u000b\u0015\u0011\t9\"!\u0007\u0002\t1\fgn\u001a\u0006\u0003\u00037\tAA[1wC&\u0019A*!\u0006\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\r\u0002c\u0001\u0018\u0002&%\u0019\u0011qE\u0018\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u00055\u00121\u0007\t\u0004]\u0005=\u0012bAA\u0019_\t\u0019\u0011I\\=\t\u0013\u0005Ur\"!AA\u0002\u0005\r\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002<A1\u0011QHA\"\u0003[i!!a\u0010\u000b\u0007\u0005\u0005s&\u0001\u0006d_2dWm\u0019;j_:LA!!\u0012\u0002@\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r\t\u00161\n\u0005\n\u0003k\t\u0012\u0011!a\u0001\u0003[\ta!Z9vC2\u001cHcA)\u0002R!I\u0011Q\u0007\n\u0002\u0002\u0003\u0007\u0011QF\u0001\u0011\tJ|\u0007/\u00138eKb\u001cu.\\7b]\u0012\u0004\"A\u000b\u000b\u0014\tQ\tIf\r\t\t\u00037\n\t\u0007O\"R/6\u0011\u0011Q\f\u0006\u0004\u0003?z\u0013a\u0002:v]RLW.Z\u0005\u0005\u0003G\niFA\tBEN$(/Y2u\rVt7\r^5p]N\"\"!!\u0016\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0005\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f]\u000by'!\u001d\u0002t!)ag\u0006a\u0001q!)\u0011i\u0006a\u0001\u0007\")qj\u0006a\u0001#\u00069QO\\1qa2LH\u0003BA=\u0003\u000b\u0003RALA>\u0003\u007fJ1!! 0\u0005\u0019y\u0005\u000f^5p]B1a&!!9\u0007FK1!a!0\u0005\u0019!V\u000f\u001d7fg!A\u0011q\u0011\r\u0002\u0002\u0003\u0007q+A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0012\t\u0005\u0003'\ty)\u0003\u0003\u0002\u0012\u0006U!AB(cU\u0016\u001cG\u000f")
public class DropIndexCommand
extends IndexBaseCommand
implements Serializable {
    private final CatalogTable table;
    private final String indexName;
    private final boolean ignoreIfNotExists;

    public static Option<Tuple3<CatalogTable, String, Object>> unapply(DropIndexCommand dropIndexCommand) {
        return DropIndexCommand$.MODULE$.unapply(dropIndexCommand);
    }

    public static Function1<Tuple3<CatalogTable, String, Object>, DropIndexCommand> tupled() {
        return DropIndexCommand$.MODULE$.tupled();
    }

    public static Function1<CatalogTable, Function1<String, Function1<Object, DropIndexCommand>>> curried() {
        return DropIndexCommand$.MODULE$.curried();
    }

    public CatalogTable table() {
        return this.table;
    }

    public String indexName() {
        return this.indexName;
    }

    public boolean ignoreIfNotExists() {
        return this.ignoreIfNotExists;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        TableIdentifier tableId = this.table().identifier();
        HoodieTableMetaClient metaClient = this.createHoodieTableMetaClient(tableId, sparkSession);
        org.apache.hudi.common.util.Option indexMetadataOpt = metaClient.getIndexMetadata();
        if (metaClient.getTableConfig().getMetadataPartitions().contains(this.indexName())) {
            new HoodieSparkIndexClient(sparkSession).drop(metaClient, this.indexName(), this.ignoreIfNotExists());
        } else if (indexMetadataOpt.isPresent()) {
            HoodieIndexMetadata indexMetadata = (HoodieIndexMetadata)indexMetadataOpt.get();
            List<HoodieIndexDefinition> indexDefinitions = indexMetadata.getIndexDefinitions().values().stream().filter(definition -> {
                MetadataPartitionType partitionType = MetadataPartitionType.fromPartitionPath((String)definition.getIndexName());
                return partitionType.getIndexNameWithoutPrefix(definition).equals(this.indexName());
            }).collect(Collectors.toList());
            if (indexDefinitions.isEmpty() && !this.ignoreIfNotExists()) {
                throw new HoodieIndexException(String.format("Index does not exist: %s", this.indexName()));
            }
            indexDefinitions.forEach(definition -> new HoodieSparkIndexClient(sparkSession).drop(metaClient, definition.getIndexName(), this.ignoreIfNotExists()));
        } else if (!this.ignoreIfNotExists()) {
            throw new HoodieIndexException(String.format("Index does not exist: %s", this.indexName()));
        }
        sparkSession.sessionState().catalog().invalidateCachedTable(tableId);
        return (Seq)Nil$.MODULE$;
    }

    public DropIndexCommand copy(CatalogTable table, String indexName, boolean ignoreIfNotExists) {
        return new DropIndexCommand(table, indexName, ignoreIfNotExists);
    }

    public CatalogTable copy$default$1() {
        return this.table();
    }

    public String copy$default$2() {
        return this.indexName();
    }

    public boolean copy$default$3() {
        return this.ignoreIfNotExists();
    }

    public String productPrefix() {
        return "DropIndexCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.table();
            }
            case 1: {
                return this.indexName();
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this.ignoreIfNotExists());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DropIndexCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DropIndexCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        DropIndexCommand dropIndexCommand = (DropIndexCommand)((Object)x$1);
        CatalogTable catalogTable = this.table();
        CatalogTable catalogTable2 = dropIndexCommand.table();
        if (catalogTable == null) {
            if (catalogTable2 != null) {
                return false;
            }
        } else if (!catalogTable.equals(catalogTable2)) return false;
        String string = this.indexName();
        String string2 = dropIndexCommand.indexName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.ignoreIfNotExists() != dropIndexCommand.ignoreIfNotExists()) return false;
        if (!dropIndexCommand.canEqual((Object)this)) return false;
        return true;
    }

    public DropIndexCommand(CatalogTable table, String indexName, boolean ignoreIfNotExists) {
        this.table = table;
        this.indexName = indexName;
        this.ignoreIfNotExists = ignoreIfNotExists;
    }
}

