/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.StringUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowArchivedCommitsProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\f\u0019\u0001\u001dB\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\u0006m\u0001!\ta\u000e\u0005\bu\u0001\u0011\r\u0011\"\u0003<\u0011\u0019\u0011\u0005\u0001)A\u0005y!91\t\u0001b\u0001\n\u0013!\u0005BB&\u0001A\u0003%Q\tC\u0004M\u0001\t\u0007I\u0011\u0002#\t\r5\u0003\u0001\u0015!\u0003F\u0011\u0015q\u0005\u0001\"\u0001<\u0011\u0015y\u0005\u0001\"\u0001E\u0011\u0015\u0001\u0006\u0001\"\u0011R\u0011\u00159\u0007\u0001\"\u0011i\u0011\u0015a\u0007\u0001\"\u0003n\u0011\u0019y\b\u0001\"\u0003\u0002\u0002!9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0002bBA\u0016\u0001\u0011\u0005\u0011QF\u0004\b\u0003\u0007B\u0002\u0012AA#\r\u00199\u0002\u0004#\u0001\u0002H!1aG\u0005C\u0001\u0003\u001fB\u0011\"!\u0015\u0013\u0005\u0004%\t!a\u0015\t\u0011\u0005}#\u0003)A\u0005\u0003+Bq!!\u0019\u0013\t\u0003\t\u0019G\u0001\u000fTQ><\u0018I]2iSZ,GmQ8n[&$8\u000f\u0015:pG\u0016$WO]3\u000b\u0005eQ\u0012A\u00039s_\u000e,G-\u001e:fg*\u00111\u0004H\u0001\bG>lW.\u00198e\u0015\tib$\u0001\u0003ik\u0012L'BA\u0010!\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003C\t\nQa\u001d9be.T!a\t\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0013aA8sO\u000e\u00011c\u0001\u0001)YA\u0011\u0011FK\u0007\u00021%\u00111\u0006\u0007\u0002\u000e\u0005\u0006\u001cX\r\u0015:pG\u0016$WO]3\u0011\u0005%j\u0013B\u0001\u0018\u0019\u0005A\u0001&o\\2fIV\u0014XMQ;jY\u0012,'/\u0001\u000bj]\u000edW\u000fZ3FqR\u0014\u0018-T3uC\u0012\fG/\u0019\t\u0003cQj\u0011A\r\u0006\u0002g\u0005)1oY1mC&\u0011QG\r\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q\u0011\u0001(\u000f\t\u0003S\u0001AQa\f\u0002A\u0002A\n!\u0002U!S\u00036+E+\u0012*T+\u0005a\u0004cA\u0019>\u007f%\u0011aH\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003S\u0001K!!\u0011\r\u0003%A\u0013xnY3ekJ,\u0007+\u0019:b[\u0016$XM]\u0001\f!\u0006\u0013\u0016)T#U\u000bJ\u001b\u0006%A\u0006P+R\u0003V\u000bV0U3B+U#A#\u0011\u0005\u0019KU\"A$\u000b\u0005!s\u0012!\u0002;za\u0016\u001c\u0018B\u0001&H\u0005)\u0019FO];diRK\b/Z\u0001\r\u001fV#\u0006+\u0016+`)f\u0003V\tI\u0001\u0015\u001b\u0016#\u0016\tR!U\u0003~{U\u000b\u0016)V)~#\u0016\fU#\u0002+5+E+\u0011#B)\u0006{v*\u0016+Q+R{F+\u0017)FA\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0002\u0015=,H\u000f];u)f\u0004X-\u0001\u0003dC2dGC\u0001*c!\r\u00196L\u0018\b\u0003)fs!!\u0016-\u000e\u0003YS!a\u0016\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0014B\u0001.3\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001X/\u0003\u0007M+\u0017O\u0003\u0002[eA\u0011q\fY\u0007\u0002=%\u0011\u0011M\b\u0002\u0004%><\b\"B2\f\u0001\u0004!\u0017\u0001B1sON\u0004\"!K3\n\u0005\u0019D\"!\u0004)s_\u000e,G-\u001e:f\u0003J<7/A\u0003ck&dG-F\u0001j!\tI#.\u0003\u0002l1\tI\u0001K]8dK\u0012,(/Z\u0001\u0017O\u0016$8i\\7nSR\u001cx+\u001b;i\u001b\u0016$\u0018\rZ1uCR\u0019!K\u001c>\t\u000b=l\u0001\u0019\u00019\u0002\u0011QLW.\u001a7j]\u0016\u0004\"!\u001d=\u000e\u0003IT!a\\:\u000b\u0005Q,\u0018!\u0002;bE2,'B\u0001<x\u0003\u0019\u0019w.\\7p]*\u0011QDI\u0005\u0003sJ\u0014a\u0002S8pI&,G+[7fY&tW\rC\u0003|\u001b\u0001\u0007A0A\u0003mS6LG\u000f\u0005\u00022{&\u0011aP\r\u0002\u0004\u0013:$\u0018AD4fiN{'\u000f^\"p[6LGo\u001d\u000b\u0005\u0003\u0007\t\t\u0003E\u00042\u0003\u000b\tI!!\u0007\n\u0007\u0005\u001d!G\u0001\u0004UkBdWM\r\t\u0006\u0003\u0017\t)BX\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005!Q\u000f^5m\u0015\t\t\u0019\"\u0001\u0003kCZ\f\u0017\u0002BA\f\u0003\u001b\u0011\u0011\"\u0011:sCfd\u0015n\u001d;\u0011\r\u0005-\u0011QCA\u000e!\r\t\u0018QD\u0005\u0004\u0003?\u0011(!\u0004%p_\u0012LW-\u00138ti\u0006tG\u000fC\u0003p\u001d\u0001\u0007\u0001/\u0001\u0006hKR\u001cu.\\7jiN$RAUA\u0014\u0003SAQa\\\bA\u0002ADQa_\bA\u0002q\fabZ3u)&lW\rR1zg\u0006;w\u000e\u0006\u0003\u00020\u0005}\u0002\u0003BA\u0019\u0003sqA!a\r\u00026A\u0011QKM\u0005\u0004\u0003o\u0011\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002<\u0005u\"AB*ue&twMC\u0002\u00028IBa!!\u0011\u0011\u0001\u0004a\u0018\u0001\u00048v[\n,'o\u00144ECf\u001c\u0018\u0001H*i_^\f%o\u00195jm\u0016$7i\\7nSR\u001c\bK]8dK\u0012,(/\u001a\t\u0003SI\u00192AEA%!\r\t\u00141J\u0005\u0004\u0003\u001b\u0012$AB!osJ+g\r\u0006\u0002\u0002F\u0005!a*Q'F+\t\t)\u0006\u0005\u0003\u0002X\u0005uSBAA-\u0015\u0011\tY&!\u0005\u0002\t1\fgnZ\u0005\u0005\u0003w\tI&A\u0003O\u00036+\u0005%A\u0004ck&dG-\u001a:\u0016\u0005\u0005\u0015\u0004#BA4\u0003[bSBAA5\u0015\u0011\tY'!\u0004\u0002\u0011\u0019,hn\u0019;j_:LA!a\u001c\u0002j\tA1+\u001e9qY&,'\u000f")
public class ShowArchivedCommitsProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final boolean includeExtraMetadata;
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private final StructType METADATA_OUTPUT_TYPE;

    public static Supplier<ProcedureBuilder> builder() {
        return ShowArchivedCommitsProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowArchivedCommitsProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    private StructType METADATA_OUTPUT_TYPE() {
        return this.METADATA_OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        if (this.includeExtraMetadata) {
            return this.METADATA_OUTPUT_TYPE();
        }
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        Seq<Row> seq;
        super.checkArgs(this.PARAMETERS(), args);
        String table = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[0]).get();
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get());
        String startTs = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[2]).get();
        String endTs = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[3]).get();
        HoodieCatalogTable hoodieCatalogTable = HoodieCLIUtils$.MODULE$.getHoodieCatalogTable(this.sparkSession(), table);
        String basePath = hoodieCatalogTable.tableLocation();
        HoodieTableMetaClient metaClient = this.createMetaClient(this.jsc(), basePath);
        if (StringUtils.isNullOrEmpty((String)startTs)) {
            startTs = this.getTimeDaysAgo(10);
        }
        if (StringUtils.isNullOrEmpty((String)endTs)) {
            endTs = this.getTimeDaysAgo(1);
        }
        HoodieArchivedTimeline archivedTimeline = metaClient.getArchivedTimeline();
        try {
            archivedTimeline.loadInstantDetailsInMemory(startTs, endTs);
            HoodieTimeline timelineRange = archivedTimeline.findInstantsInRange(startTs, endTs);
            seq = this.includeExtraMetadata ? this.getCommitsWithMetadata(timelineRange, limit) : this.getCommits(timelineRange, limit);
        }
        finally {
            archivedTimeline.clearInstantDetailsFromMemory(startTs, endTs);
        }
        return seq;
    }

    @Override
    public Procedure build() {
        return new ShowArchivedCommitsProcedure(this.includeExtraMetadata);
    }

    private Seq<Row> getCommitsWithMetadata(HoodieTimeline timeline, int limit) {
        ArrayList arrayList;
        ArrayList newCommits;
        block3: {
            Tuple2<ArrayList<Row>, ArrayList<HoodieInstant>> tuple2;
            block2: {
                tuple2 = this.getSortCommits(timeline);
                if (tuple2 == null) break block2;
                ArrayList rows = (ArrayList)tuple2._1();
                newCommits = (ArrayList)tuple2._2();
                if (rows == null) break block2;
                arrayList = rows;
                if (newCommits != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        ArrayList arrayList2 = newCommits;
        Tuple2 tuple2 = new Tuple2((Object)arrayList, (Object)arrayList2);
        ArrayList rows = (ArrayList)tuple2._1();
        ArrayList newCommits2 = (ArrayList)tuple2._2();
        TimelineLayout layout = TimelineLayout.fromVersion((TimelineLayoutVersion)timeline.getTimelineLayoutVersion());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), newCommits2.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            HoodieInstant commit = (HoodieInstant)newCommits2.get(i);
            HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)layout.getCommitMetadataSerDe().deserialize(commit, (byte[])timeline.getInstantDetails(commit).get(), HoodieCommitMetadata.class);
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(commitMetadata.getPartitionToWriteStats().entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)partitionWriteStat -> {
                ShowArchivedCommitsProcedure.$anonfun$getCommitsWithMetadata$2(rows, commit, partitionWriteStat);
                return BoxedUnit.UNIT;
            });
        });
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray())).map((Function1 & Serializable & scala.Serializable)r -> (Row)r, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))))).toList();
    }

    private Tuple2<ArrayList<Row>, ArrayList<HoodieInstant>> getSortCommits(HoodieTimeline timeline) {
        ArrayList rows = new ArrayList();
        List commits = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(timeline.getCommitsTimeline().filterCompletedInstants().getInstants().toArray())).map((Function1 & Serializable & scala.Serializable)instant -> (HoodieInstant)instant, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(HoodieInstant.class))))).toList()).asJava();
        ArrayList newCommits = new ArrayList(commits);
        TimelineLayout layout = TimelineLayout.fromVersion((TimelineLayoutVersion)timeline.getTimelineLayoutVersion());
        Collections.sort(newCommits, layout.getInstantComparator().requestedTimeOrderedComparator().reversed());
        return new Tuple2(rows, newCommits);
    }

    public Seq<Row> getCommits(HoodieTimeline timeline, int limit) {
        ArrayList arrayList;
        ArrayList newCommits;
        block3: {
            Tuple2<ArrayList<Row>, ArrayList<HoodieInstant>> tuple2;
            block2: {
                tuple2 = this.getSortCommits(timeline);
                if (tuple2 == null) break block2;
                ArrayList rows = (ArrayList)tuple2._1();
                newCommits = (ArrayList)tuple2._2();
                if (rows == null) break block2;
                arrayList = rows;
                if (newCommits != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        ArrayList arrayList2 = newCommits;
        Tuple2 tuple2 = new Tuple2((Object)arrayList, (Object)arrayList2);
        ArrayList rows = (ArrayList)tuple2._1();
        ArrayList newCommits2 = (ArrayList)tuple2._2();
        TimelineLayout layout = TimelineLayout.fromVersion((TimelineLayoutVersion)timeline.getTimelineLayoutVersion());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), newCommits2.size()).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> {
            HoodieInstant commit = (HoodieInstant)newCommits2.get(i);
            HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)layout.getCommitMetadataSerDe().deserialize(commit, (byte[])timeline.getInstantDetails(commit).get(), HoodieCommitMetadata.class);
            return rows.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{commit.requestedTime(), commit.getCompletionTime(), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalBytesWritten()), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalFilesInsert()), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalFilesUpdated()), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalPartitionsWritten()), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalRecordsWritten()), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalUpdateRecordsWritten()), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalWriteErrors())})));
        });
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray())).map((Function1 & Serializable & scala.Serializable)r -> (Row)r, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))))).toList();
    }

    public String getTimeDaysAgo(int numberOfDays) {
        Date date = Date.from(ZonedDateTime.now().minusDays(numberOfDays).toInstant());
        return TimelineUtils.formatDate((Date)date);
    }

    public static final /* synthetic */ void $anonfun$getCommitsWithMetadata$2(ArrayList rows$1, HoodieInstant commit$1, Map.Entry partitionWriteStat) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)partitionWriteStat.getValue()).asScala()).foreach((Function1 & Serializable & scala.Serializable)hoodieWriteStat -> BoxesRunTime.boxToBoolean((boolean)rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{commit$1.requestedTime(), commit$1.getCompletionTime(), commit$1.getAction(), hoodieWriteStat.getPartitionPath(), hoodieWriteStat.getFileId(), hoodieWriteStat.getPrevCommit(), BoxesRunTime.boxToLong((long)hoodieWriteStat.getNumWrites()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getNumInserts()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getNumDeletes()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getNumUpdateWrites()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalWriteErrors()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalLogBlocks()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalCorruptLogBlock()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalRollbackBlocks()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalLogRecords()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalUpdatedRecordsCompacted()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalWriteBytes())})))));
    }

    public ShowArchivedCommitsProcedure(boolean includeExtraMetadata) {
        this.includeExtraMetadata = includeExtraMetadata;
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(1, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10)), ProcedureParameter$.MODULE$.optional(2, "start_ts", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(3, "end_ts", DataTypes.StringType, "")});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("commit_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("state_transition_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("total_bytes_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_files_added", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_files_updated", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_partitions_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_records_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_update_records_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_errors", DataTypes.LongType, true, Metadata$.MODULE$.empty())}));
        this.METADATA_OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("commit_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("state_transition_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("action", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("partition", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("file_id", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("previous_commit", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("num_writes", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("num_inserts", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("num_deletes", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("num_update_writes", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_errors", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_log_blocks", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_corrupt_log_blocks", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_rollback_blocks", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_log_records", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_updated_records_compacted", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_bytes_written", DataTypes.LongType, true, Metadata$.MODULE$.empty())}));
    }
}

