/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowCommitWriteStatsProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001\u0002\n\u0014\u0001\tBQA\u000b\u0001\u0005\u0002-Bq!\f\u0001C\u0002\u0013%a\u0006\u0003\u00049\u0001\u0001\u0006Ia\f\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u0019\t\u0005\u0001)A\u0005w!)!\t\u0001C\u0001]!)1\t\u0001C\u0001u!)A\t\u0001C!\u000b\")1\f\u0001C!9\")\u0001\r\u0001C\u0005C\"9\u0011\u0011\u0002\u0001\u0005\n\u0005-qaBA\u0011'!\u0005\u00111\u0005\u0004\u0007%MA\t!!\n\t\r)jA\u0011AA\u0017\u0011%\ty#\u0004b\u0001\n\u0003\t\t\u0004\u0003\u0005\u0002B5\u0001\u000b\u0011BA\u001a\u0011\u001d\t\u0019%\u0004C\u0001\u0003\u000b\u0012Qd\u00155po\u000e{W.\\5u/JLG/Z*uCR\u001c\bK]8dK\u0012,(/\u001a\u0006\u0003)U\t!\u0002\u001d:pG\u0016$WO]3t\u0015\t1r#A\u0004d_6l\u0017M\u001c3\u000b\u0005aI\u0012\u0001\u00025vI&T!AG\u000e\u0002\u0007M\fHN\u0003\u0002\u001d;\u0005)1\u000f]1sW*\u0011adH\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\n1a\u001c:h\u0007\u0001\u00192\u0001A\u0012(!\t!S%D\u0001\u0014\u0013\t13CA\u0007CCN,\u0007K]8dK\u0012,(/\u001a\t\u0003I!J!!K\n\u0003!A\u0013xnY3ekJ,')^5mI\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001-!\t!\u0003!\u0001\u0006Q\u0003J\u000bU*\u0012+F%N+\u0012a\f\t\u0004aM*T\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u00112\u0014BA\u001c\u0014\u0005I\u0001&o\\2fIV\u0014X\rU1sC6,G/\u001a:\u0002\u0017A\u000b%+Q'F)\u0016\u00136\u000bI\u0001\f\u001fV#\u0006+\u0016+`)f\u0003V)F\u0001<!\tat(D\u0001>\u0015\tq\u0014$A\u0003usB,7/\u0003\u0002A{\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u0019=+F\u000bU+U?RK\u0006+\u0012\u0011\u0002\u0015A\f'/Y7fi\u0016\u00148/\u0001\u0006pkR\u0004X\u000f\u001e+za\u0016\fAaY1mYR\u0011aI\u0016\t\u0004\u000f>\u0013fB\u0001%N\u001d\tIE*D\u0001K\u0015\tY\u0015%\u0001\u0004=e>|GOP\u0005\u0002e%\u0011a*M\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0016KA\u0002TKFT!AT\u0019\u0011\u0005M#V\"A\r\n\u0005UK\"a\u0001*po\")q\u000b\u0003a\u00011\u0006!\u0011M]4t!\t!\u0013,\u0003\u0002['\ti\u0001K]8dK\u0012,(/Z!sON\fQAY;jY\u0012,\u0012!\u0018\t\u0003IyK!aX\n\u0003\u0013A\u0013xnY3ekJ,\u0017aE4fi\u000e{W.\\5u\r>\u0014\u0018J\\:uC:$H\u0003\u00022qmj\u00042\u0001M2f\u0013\t!\u0017G\u0001\u0004PaRLwN\u001c\t\u0003M:l\u0011a\u001a\u0006\u0003Q&\f\u0001\u0002^5nK2Lg.\u001a\u0006\u0003U.\fQ\u0001^1cY\u0016T!\u0001\\7\u0002\r\r|W.\\8o\u0015\tAR$\u0003\u0002pO\ni\u0001j\\8eS\u0016Len\u001d;b]RDQ!\u001d\u0006A\u0002I\f!\"\\3uC\u000ec\u0017.\u001a8u!\t\u0019H/D\u0001j\u0013\t)\u0018NA\u000bI_>$\u0017.\u001a+bE2,W*\u001a;b\u00072LWM\u001c;\t\u000b!T\u0001\u0019A<\u0011\u0005\u0019D\u0018BA=h\u00059Aun\u001c3jKRKW.\u001a7j]\u0016DQa\u001f\u0006A\u0002q\f1\"\u001b8ti\u0006tG\u000fV5nKB\u0019Q0a\u0001\u000f\u0005y|\bCA%2\u0013\r\t\t!M\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0011q\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005\u0011'A\fhKRDun\u001c3jK\u000e{W.\\5u\u001b\u0016$\u0018\rZ1uCR1\u0011QBA\u000e\u0003;\u0001B\u0001M2\u0002\u0010A!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016-\fQ!\\8eK2LA!!\u0007\u0002\u0014\t!\u0002j\\8eS\u0016\u001cu.\\7ji6+G/\u00193bi\u0006DQ\u0001[\u0006A\u0002]Da!a\b\f\u0001\u0004\u0011\u0017!\u00045p_\u0012LW-\u00138ti\u0006tG/A\u000fTQ><8i\\7nSR<&/\u001b;f'R\fGo\u001d)s_\u000e,G-\u001e:f!\t!SbE\u0002\u000e\u0003O\u00012\u0001MA\u0015\u0013\r\tY#\r\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005\r\u0012\u0001\u0002(B\u001b\u0016+\"!a\r\u0011\t\u0005U\u0012qH\u0007\u0003\u0003oQA!!\u000f\u0002<\u0005!A.\u00198h\u0015\t\ti$\u0001\u0003kCZ\f\u0017\u0002BA\u0003\u0003o\tQAT!N\u000b\u0002\nqAY;jY\u0012,'/\u0006\u0002\u0002HA)\u0011\u0011JA*O5\u0011\u00111\n\u0006\u0005\u0003\u001b\ny%\u0001\u0005gk:\u001cG/[8o\u0015\u0011\t\t&a\u000f\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003+\nYE\u0001\u0005TkB\u0004H.[3s\u0001")
public class ShowCommitWriteStatsProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final ProcedureParameter[] PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(1, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10)), ProcedureParameter$.MODULE$.required(2, "instant_time", DataTypes.StringType)});
    private final StructType OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("action", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("total_bytes_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_records_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("avg_record_size", DataTypes.LongType, true, Metadata$.MODULE$.empty())}));

    public static Supplier<ProcedureBuilder> builder() {
        return ShowCommitWriteStatsProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowCommitWriteStatsProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        super.checkArgs(this.PARAMETERS(), args);
        String table = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[0]).get();
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get());
        String instantTime = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[2]).get();
        HoodieCatalogTable hoodieCatalogTable = HoodieCLIUtils$.MODULE$.getHoodieCatalogTable(this.sparkSession(), table);
        String basePath = hoodieCatalogTable.tableLocation();
        HoodieTableMetaClient metaClient = this.createMetaClient(this.jsc(), basePath);
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCommitsTimeline().filterCompletedInstants();
        Option<HoodieInstant> hoodieInstantOption = this.getCommitForInstant(metaClient, timeline, instantTime);
        Option<HoodieCommitMetadata> commitMetadataOptional = this.getHoodieCommitMetadata(timeline, hoodieInstantOption);
        if (commitMetadataOptional.isEmpty()) {
            throw new HoodieException(new StringBuilder(30).append("Commit ").append(instantTime).append(" not found in Commits ").append(timeline).append(".").toString());
        }
        HoodieCommitMetadata meta = (HoodieCommitMetadata)commitMetadataOptional.get();
        String action = ((HoodieInstant)hoodieInstantOption.get()).getAction();
        long recordsWritten = meta.fetchTotalRecordsWritten();
        long bytesWritten = meta.fetchTotalBytesWritten();
        long avgRecSize = (long)Math.ceil(1.0 * (double)bytesWritten / (double)recordsWritten);
        ArrayList<Row> rows = new ArrayList<Row>();
        rows.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action, BoxesRunTime.boxToLong((long)bytesWritten), BoxesRunTime.boxToLong((long)recordsWritten), BoxesRunTime.boxToLong((long)avgRecSize)})));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray())).map((Function1 & Serializable & scala.Serializable)r -> (Row)r, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))))).toList();
    }

    @Override
    public Procedure build() {
        return new ShowCommitWriteStatsProcedure();
    }

    private Option<HoodieInstant> getCommitForInstant(HoodieTableMetaClient metaClient, HoodieTimeline timeline, String instantTime) {
        InstantGenerator instantGenerator = metaClient.getTimelineLayout().getInstantGenerator();
        List<Object> instants = Arrays.asList((Object[])new HoodieInstant[]{instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "commit", instantTime), instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "replacecommit", instantTime), instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "clustering", instantTime), instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", instantTime)});
        Option hoodieInstant = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(instants).asScala()).find((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)timeline.containsInstant(i)));
        return hoodieInstant;
    }

    private Option<HoodieCommitMetadata> getHoodieCommitMetadata(HoodieTimeline timeline, Option<HoodieInstant> hoodieInstant) {
        if (hoodieInstant.isDefined()) {
            if (ClusteringUtils.isClusteringOrReplaceCommitAction((String)((HoodieInstant)hoodieInstant.get()).getAction())) {
                return Option$.MODULE$.apply(HoodieReplaceCommitMetadata.fromBytes((byte[])((byte[])timeline.getInstantDetails((HoodieInstant)hoodieInstant.get()).get()), HoodieReplaceCommitMetadata.class));
            }
            TimelineLayout layout = TimelineLayout.fromVersion((TimelineLayoutVersion)timeline.getTimelineLayoutVersion());
            return Option$.MODULE$.apply(layout.getCommitMetadataSerDe().deserialize((HoodieInstant)hoodieInstant.get(), (byte[])timeline.getInstantDetails((HoodieInstant)hoodieInstant.get()).get(), HoodieCommitMetadata.class));
        }
        return Option$.MODULE$.empty();
    }
}

