/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.CompletionTimeQueryView;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001\u0002\u000b\u0016\u0001\u0011B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\u0006g\u0001!\t\u0001\u000e\u0005\bo\u0001\u0011\r\u0011\"\u00039\u0011\u0019\t\u0005\u0001)A\u0005s!9!\t\u0001b\u0001\n\u0013\u0019\u0005B\u0002&\u0001A\u0003%A\tC\u0004L\u0001\t\u0007I\u0011\u0002'\t\rM\u0003\u0001\u0015!\u0003N\u0011\u001d!\u0006A1A\u0005\n\rCa!\u0016\u0001!\u0002\u0013!\u0005b\u0002,\u0001\u0005\u0004%I\u0001\u0014\u0005\u0007/\u0002\u0001\u000b\u0011B'\t\u000ba\u0003A\u0011B-\t\u000f\u0005\r\u0001\u0001\"\u0003\u0002\u0006!9\u0011q\u0004\u0001\u0005\n\u0005\u0005\u0002BBA\"\u0001\u0011\u00053\t\u0003\u0004\u0002F\u0001!\t\u0005\u0014\u0005\b\u0003\u000f\u0002A\u0011IA%\u0011\u001d\t9\u0006\u0001C!\u00033\u00121d\u00155po\u001aKG.Z*zgR,WNV5foB\u0013xnY3ekJ,'B\u0001\f\u0018\u0003)\u0001(o\\2fIV\u0014Xm\u001d\u0006\u00031e\tqaY8n[\u0006tGM\u0003\u0002\u001b7\u0005!\u0001.\u001e3j\u0015\taR$A\u0002tc2T!AH\u0010\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0001\n\u0013AB1qC\u000eDWMC\u0001#\u0003\ry'oZ\u0002\u0001'\r\u0001Q%\u000b\t\u0003M\u001dj\u0011!F\u0005\u0003QU\u0011QBQ1tKB\u0013xnY3ekJ,\u0007C\u0001\u0014+\u0013\tYSC\u0001\tQe>\u001cW\rZ;sK\n+\u0018\u000e\u001c3fe\u0006Q1\u000f[8x\u0019\u0006$Xm\u001d;\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"\"!\u000e\u001c\u0011\u0005\u0019\u0002\u0001\"\u0002\u0017\u0003\u0001\u0004i\u0013AD!M\u0019~\u0003\u0016I\u0015+J)&{ejU\u000b\u0002sA\u0011!hP\u0007\u0002w)\u0011A(P\u0001\u0005Y\u0006twMC\u0001?\u0003\u0011Q\u0017M^1\n\u0005\u0001[$AB*ue&tw-A\bB\u00192{\u0006+\u0011*U\u0013RKuJT*!\u00039\u0001\u0016IU!N\u000bR+%kU0B\u00192+\u0012\u0001\u0012\t\u0004]\u0015;\u0015B\u0001$0\u0005\u0015\t%O]1z!\t1\u0003*\u0003\u0002J+\t\u0011\u0002K]8dK\u0012,(/\u001a)be\u0006lW\r^3s\u0003=\u0001\u0016IU!N\u000bR+%kU0B\u00192\u0003\u0013aD(V)B+Fk\u0018+Z!\u0016{\u0016\t\u0014'\u0016\u00035\u0003\"AT)\u000e\u0003=S!\u0001U\u000e\u0002\u000bQL\b/Z:\n\u0005I{%AC*ueV\u001cG\u000fV=qK\u0006\u0001r*\u0016+Q+R{F+\u0017)F?\u0006cE\nI\u0001\u0012!\u0006\u0013\u0016)T#U\u000bJ\u001bv\fT!U\u000bN#\u0016A\u0005)B%\u0006kU\tV#S'~c\u0015\tV#T)\u0002\n!cT+U!V#v\fV-Q\u000b~c\u0015\tV#T)\u0006\u0019r*\u0016+Q+R{F+\u0017)F?2\u000bE+R*UA\u0005\u0019\"-^5mI\u001aKG.Z*zgR,WNV5foRA!,Z9xsnlx\u0010\u0005\u0002\\G6\tAL\u0003\u0002^=\u0006!a/[3x\u0015\ty\u0006-A\u0003uC\ndWM\u0003\u0002bE\u000611m\\7n_:T!AG\u0010\n\u0005\u0011d&!\u0007%p_\u0012LW\rV1cY\u00164\u0015\u000e\\3TsN$X-\u001c,jK^DQAZ\u0007A\u0002\u001d\f\u0001BY1tKB\u000bG\u000f\u001b\t\u0003Q>t!![7\u0011\u0005)|S\"A6\u000b\u00051\u001c\u0013A\u0002\u001fs_>$h(\u0003\u0002o_\u00051\u0001K]3eK\u001aL!\u0001\u00119\u000b\u00059|\u0003\"\u0002:\u000e\u0001\u0004\u0019\u0018AC7fi\u0006\u001cE.[3oiB\u0011A/^\u0007\u0002=&\u0011aO\u0018\u0002\u0016\u0011>|G-[3UC\ndW-T3uC\u000ec\u0017.\u001a8u\u0011\u0015AX\u00021\u0001h\u0003%9Gn\u001c2SK\u001e,\u0007\u0010C\u0003{\u001b\u0001\u0007q-\u0001\u0006nCbLen\u001d;b]RDQ\u0001`\u0007A\u00025\n\u0011#\u001b8dYV$W-T1y\u0013:\u001cH/\u00198u\u0011\u0015qX\u00021\u0001.\u0003=Ign\u00197vI\u0016LeN\u001a7jO\"$\bBBA\u0001\u001b\u0001\u0007Q&A\tfq\u000edW\u000fZ3D_6\u0004\u0018m\u0019;j_:\f\u0011c\u001d5po\u0006cGNR5mKNc\u0017nY3t)\u0011\t9!a\u0007\u0011\r\u0005%\u0011qBA\n\u001b\t\tYAC\u0002\u0002\u000eu\nA!\u001e;jY&!\u0011\u0011CA\u0006\u0005\u0011a\u0015n\u001d;\u0011\t\u0005U\u0011qC\u0007\u00027%\u0019\u0011\u0011D\u000e\u0003\u0007I{w\u000f\u0003\u0004\u0002\u001e9\u0001\rAW\u0001\u0007MN4\u0016.Z<\u0002)MDwn\u001e'bi\u0016\u001cHOR5mKNc\u0017nY3t)1\t9!a\t\u0002&\u0005\u001d\u0012QHA \u0011\u0015\u0011x\u00021\u0001t\u0011\u0019\tib\u0004a\u00015\"9\u0011\u0011F\bA\u0002\u0005-\u0012A\u00039beRLG/[8ogB)\u0011QFA\u001cO:!\u0011qFA\u001a\u001d\rQ\u0017\u0011G\u0005\u0002a%\u0019\u0011QG\u0018\u0002\u000fA\f7m[1hK&!\u0011\u0011HA\u001e\u0005\r\u0019V-\u001d\u0006\u0004\u0003ky\u0003\"\u0002>\u0010\u0001\u00049\u0007BBA!\u001f\u0001\u0007Q&A\u0003nKJ<W-\u0001\u0006qCJ\fW.\u001a;feN\f!b\\;uaV$H+\u001f9f\u0003\u0011\u0019\u0017\r\u001c7\u0015\t\u0005-\u0013Q\n\t\u0007\u0003[\t9$a\u0005\t\u000f\u0005=#\u00031\u0001\u0002R\u0005!\u0011M]4t!\r1\u00131K\u0005\u0004\u0003+*\"!\u0004)s_\u000e,G-\u001e:f\u0003J<7/A\u0003ck&dG-\u0006\u0002\u0002\\A\u0019a%!\u0018\n\u0007\u0005}SCA\u0005Qe>\u001cW\rZ;sK\u0002")
public class ShowFileSystemViewProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final boolean showLatest;
    private final String ALL_PARTITIONS;
    private final ProcedureParameter[] PARAMETERS_ALL;
    private final StructType OUTPUT_TYPE_ALL;
    private final ProcedureParameter[] PARAMETERS_LATEST;
    private final StructType OUTPUT_TYPE_LATEST;

    private String ALL_PARTITIONS() {
        return this.ALL_PARTITIONS;
    }

    private ProcedureParameter[] PARAMETERS_ALL() {
        return this.PARAMETERS_ALL;
    }

    private StructType OUTPUT_TYPE_ALL() {
        return this.OUTPUT_TYPE_ALL;
    }

    private ProcedureParameter[] PARAMETERS_LATEST() {
        return this.PARAMETERS_LATEST;
    }

    private StructType OUTPUT_TYPE_LATEST() {
        return this.OUTPUT_TYPE_LATEST;
    }

    private HoodieTableFileSystemView buildFileSystemView(String basePath, HoodieTableMetaClient metaClient, String globRegex, String maxInstant, boolean includeMaxInstant, boolean includeInflight, boolean excludeCompaction) {
        HoodieTimeline timeline;
        List list;
        HoodieStorage storage = metaClient.getStorage();
        String string = globRegex;
        String string2 = this.ALL_PARTITIONS();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            list = FSUtils.getAllDataPathInfo((HoodieStorage)storage, (StoragePath)new StoragePath(basePath));
        } else {
            String globPath = String.format("%s/%s/*", basePath, globRegex);
            list = FSUtils.getGlobStatusExcludingMetaFolder((HoodieStorage)storage, (StoragePath)new StoragePath(globPath));
        }
        List statuses = list;
        HoodieTimeline hoodieTimeline = timeline = excludeCompaction ? metaClient.getActiveTimeline().getCommitsTimeline() : metaClient.getActiveTimeline().getWriteTimeline();
        if (!includeInflight) {
            timeline = timeline.filterCompletedInstants();
        }
        Iterator instants = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(timeline.getInstants().iterator()).asScala();
        if (new StringOps(Predef$.MODULE$.augmentString(maxInstant)).nonEmpty()) {
            BiPredicate predicate = includeMaxInstant ? InstantComparison.GREATER_THAN_OR_EQUALS : InstantComparison.GREATER_THAN;
            instants = instants.filter((Function1 & Serializable & scala.Serializable)instant -> BoxesRunTime.boxToBoolean((boolean)predicate.test(maxInstant, instant.requestedTime())));
        }
        Function<HoodieInstant, org.apache.hudi.common.util.Option<byte[]>> details = new Function<HoodieInstant, org.apache.hudi.common.util.Option<byte[]>>(null, metaClient){
            private final HoodieTableMetaClient metaClient$1;

            public <V> Function<V, org.apache.hudi.common.util.Option<byte[]>> compose(Function<? super V, ? extends HoodieInstant> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<HoodieInstant, V> andThen(Function<? super org.apache.hudi.common.util.Option<byte[]>, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public org.apache.hudi.common.util.Option<byte[]> apply(HoodieInstant instant) {
                return this.metaClient$1.getActiveTimeline().getInstantDetails(instant);
            }
            {
                this.metaClient$1 = metaClient$1;
            }
        };
        HoodieTimeline filteredTimeline = metaClient.getTimelineLayout().getTimelineFactory().createDefaultTimeline(new ArrayList((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)instants.toList()).asJava()).stream(), (Function)details);
        return new HoodieTableFileSystemView(metaClient, filteredTimeline, statuses);
    }

    private List<Row> showAllFileSlices(HoodieTableFileSystemView fsView) {
        ArrayList<Row> rows = new ArrayList<Row>();
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fsView.getAllFileGroups().iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)fg -> {
            ShowFileSystemViewProcedure.$anonfun$showAllFileSlices$1(rows, fg);
            return BoxedUnit.UNIT;
        });
        return rows;
    }

    private List<Row> showLatestFileSlices(HoodieTableMetaClient metaClient, HoodieTableFileSystemView fsView, Seq<String> partitions, String maxInstant, boolean merge) {
        ObjectRef fileSliceStream = ObjectRef.create(Stream.empty());
        CompletionTimeQueryView completionTimeQueryView = metaClient.getTimelineLayout().getTimelineFactory().createCompletionTimeQueryView(metaClient);
        if (merge) {
            partitions.foreach((Function1 & Serializable & scala.Serializable)p -> {
                fileSliceStream.elem = Stream.concat((Stream)fileSliceStream.elem, fsView.getLatestMergedFileSlicesBeforeOrOn(p, maxInstant));
                return BoxedUnit.UNIT;
            });
        } else {
            partitions.foreach((Function1 & Serializable & scala.Serializable)p -> {
                fileSliceStream.elem = Stream.concat((Stream)fileSliceStream.elem, fsView.getLatestFileSlices(p));
                return BoxedUnit.UNIT;
            });
        }
        ArrayList<Row> rows = new ArrayList<Row>();
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(((Stream)fileSliceStream.elem).iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)fs -> BoxesRunTime.boxToBoolean((boolean)ShowFileSystemViewProcedure.$anonfun$showLatestFileSlices$3(completionTimeQueryView, rows, fs)));
        completionTimeQueryView.close();
        return rows;
    }

    @Override
    public ProcedureParameter[] parameters() {
        if (this.showLatest) {
            return this.PARAMETERS_LATEST();
        }
        return this.PARAMETERS_ALL();
    }

    @Override
    public StructType outputType() {
        if (this.showLatest) {
            return this.OUTPUT_TYPE_LATEST();
        }
        return this.OUTPUT_TYPE_ALL();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<Row> call(ProcedureArgs args) {
        List<Row> list;
        String string;
        super.checkArgs(this.parameters(), args);
        Option<Object> table = this.getArgValueOrDefault(args, this.parameters()[0]);
        String maxInstant = (String)this.getArgValueOrDefault(args, this.parameters()[1]).get();
        boolean includeMax = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.parameters()[2]).get());
        boolean includeInflight = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.parameters()[3]).get());
        boolean excludeCompaction = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.parameters()[4]).get());
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.parameters()[5]).get());
        if (this.showLatest) {
            boolean isPathRegexDefined = this.isArgDefined(args, this.parameters()[6]);
            boolean isPartitionPathDefined = this.isArgDefined(args, this.parameters()[7]);
            if (isPathRegexDefined && isPartitionPathDefined) {
                throw new HoodieException("path_regex and partition_path cannot be used together");
            }
            string = isPathRegexDefined ? (String)this.getArgValueOrDefault(args, this.parameters()[6]).get() : (String)this.getArgValueOrDefault(args, this.parameters()[7]).get();
        } else {
            string = (String)this.getArgValueOrDefault(args, this.parameters()[6]).get();
        }
        String globRegex = string;
        String basePath = this.getBasePath(table, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = this.createMetaClient(this.jsc(), basePath);
        HoodieTableFileSystemView fsView = this.buildFileSystemView(basePath, metaClient, globRegex, maxInstant, includeMax, includeInflight, excludeCompaction);
        if (this.showLatest) {
            String string2;
            boolean merge = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.parameters()[8]).get());
            if (merge && maxInstant.isEmpty()) {
                org.apache.hudi.common.util.Option lastInstant = metaClient.getActiveTimeline().filterCompletedAndCompactionInstants().lastInstant();
                if (!lastInstant.isPresent()) return (Seq)Nil$.MODULE$;
                string2 = ((HoodieInstant)lastInstant.get()).requestedTime();
            } else {
                string2 = maxInstant;
            }
            String maxInstantForMerge = string2;
            list = this.showLatestFileSlices(metaClient, fsView, (Seq<String>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(fsView.getPartitionNames()).asScala()).toSeq(), maxInstantForMerge, merge);
        } else {
            list = this.showAllFileSlices(fsView);
        }
        List<Row> rows = list;
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray())).map((Function1 & Serializable & scala.Serializable)r -> (Row)r, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))))).toList();
    }

    @Override
    public Procedure build() {
        return new ShowFileSystemViewProcedure(this.showLatest);
    }

    public static final /* synthetic */ boolean $anonfun$showAllFileSlices$2(HoodieFileGroup fg$1, List rows$1, FileSlice fs) {
        String fileId = fg$1.getFileGroupId().getFileId();
        String baseFilePath = "";
        long baseFileSize = 0L;
        if (fs.getBaseFile().isPresent()) {
            baseFilePath = ((BaseFile)fs.getBaseFile().get()).getPath();
            baseFileSize = ((BaseFile)fs.getBaseFile().get()).getFileSize();
        }
        long numLogFiles = fs.getLogFiles().count();
        long sumLogFileSize = BoxesRunTime.unboxToLong((Object)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fs.getLogFiles().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.getFileSize())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        String logFiles = fs.getLogFiles().collect(Collectors.toList()).toString();
        return rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fg$1.getPartitionPath(), fileId, fs.getBaseInstantTime(), baseFilePath, BoxesRunTime.boxToLong((long)baseFileSize), BoxesRunTime.boxToLong((long)numLogFiles), BoxesRunTime.boxToLong((long)sumLogFileSize), logFiles})));
    }

    public static final /* synthetic */ void $anonfun$showAllFileSlices$1(List rows$1, HoodieFileGroup fg) {
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fg.getAllFileSlices().iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)fs -> BoxesRunTime.boxToBoolean((boolean)ShowFileSystemViewProcedure.$anonfun$showAllFileSlices$2(fg, rows$1, fs)));
    }

    public static final /* synthetic */ boolean $anonfun$showLatestFileSlices$5(CompletionTimeQueryView completionTimeQueryView$1, HoodieLogFile logFile) {
        return completionTimeQueryView$1.getCompletionTime(logFile.getDeltaCommitTime()).isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$showLatestFileSlices$7(CompletionTimeQueryView completionTimeQueryView$1, HoodieLogFile logFile) {
        return !completionTimeQueryView$1.getCompletionTime(logFile.getDeltaCommitTime()).isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$showLatestFileSlices$9(FileSlice fs$1, HoodieLogFile logFile) {
        return logFile.getDeltaCommitTime().equals(fs$1.getBaseInstantTime());
    }

    public static final /* synthetic */ boolean $anonfun$showLatestFileSlices$10(FileSlice fs$1, HoodieLogFile logFile) {
        return !logFile.getDeltaCommitTime().equals(fs$1.getBaseInstantTime());
    }

    public static final /* synthetic */ boolean $anonfun$showLatestFileSlices$3(CompletionTimeQueryView completionTimeQueryView$1, ArrayList rows$2, FileSlice fs) {
        String fileId = fs.getFileId();
        String baseInstantTime = fs.getBaseInstantTime();
        String baseFilePath = "";
        long baseFileSize = 0L;
        if (fs.getBaseFile().isPresent()) {
            baseFilePath = ((BaseFile)fs.getBaseFile().get()).getPath();
            baseFileSize = ((BaseFile)fs.getBaseFile().get()).getFileSize();
        }
        long numLogFiles = fs.getLogFiles().count();
        long sumLogFileSize = BoxesRunTime.unboxToLong((Object)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fs.getLogFiles().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.getFileSize())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long logFilesScheduledForCompactionTotalSize = BoxesRunTime.unboxToLong((Object)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fs.getLogFiles().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)logFile -> BoxesRunTime.boxToBoolean((boolean)ShowFileSystemViewProcedure.$anonfun$showLatestFileSlices$5(completionTimeQueryView$1, logFile))).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.getFileSize())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long logFilesUnscheduledTotalSize = BoxesRunTime.unboxToLong((Object)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fs.getLogFiles().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)logFile -> BoxesRunTime.boxToBoolean((boolean)ShowFileSystemViewProcedure.$anonfun$showLatestFileSlices$7(completionTimeQueryView$1, logFile))).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.getFileSize())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        double logSelectedForCompactionToBaseRatio = baseFileSize > 0L ? (double)logFilesScheduledForCompactionTotalSize / ((double)baseFileSize * 1.0) : -1.0;
        double logUnscheduledToBaseRatio = baseFileSize > 0L ? (double)logFilesUnscheduledTotalSize / ((double)baseFileSize * 1.0) : -1.0;
        String logFilesCommitTimeEqualInstantTime = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fs.getLogFiles().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)logFile -> BoxesRunTime.boxToBoolean((boolean)ShowFileSystemViewProcedure.$anonfun$showLatestFileSlices$9(fs, logFile))).mkString("[", ",", "]");
        String logFilesCommitTimeNonEqualInstantTime = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fs.getLogFiles().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)logFile -> BoxesRunTime.boxToBoolean((boolean)ShowFileSystemViewProcedure.$anonfun$showLatestFileSlices$10(fs, logFile))).mkString("[", ",", "]");
        return rows$2.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fs.getFileGroupId().getPartitionPath(), fileId, baseInstantTime, baseFilePath, BoxesRunTime.boxToLong((long)baseFileSize), BoxesRunTime.boxToLong((long)numLogFiles), BoxesRunTime.boxToLong((long)sumLogFileSize), BoxesRunTime.boxToLong((long)logFilesScheduledForCompactionTotalSize), BoxesRunTime.boxToLong((long)logFilesUnscheduledTotalSize), BoxesRunTime.boxToDouble((double)logSelectedForCompactionToBaseRatio), BoxesRunTime.boxToDouble((double)logUnscheduledToBaseRatio), logFilesCommitTimeEqualInstantTime, logFilesCommitTimeNonEqualInstantTime})));
    }

    public ShowFileSystemViewProcedure(boolean showLatest) {
        this.showLatest = showLatest;
        this.ALL_PARTITIONS = "ALL_PARTITIONS";
        this.PARAMETERS_ALL = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(1, "max_instant", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(2, "include_max", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(3, "include_in_flight", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(4, "exclude_compaction", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(5, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10)), ProcedureParameter$.MODULE$.optional(6, "path_regex", DataTypes.StringType, this.ALL_PARTITIONS())});
        this.OUTPUT_TYPE_ALL = new StructType((StructField[])((Object[])new StructField[]{new StructField("partition", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("file_id", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("base_instant", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("data_file", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("data_file_size", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("num_delta_files", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_delta_file_size", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("delta_files", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
        this.PARAMETERS_LATEST = (ProcedureParameter[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.PARAMETERS_ALL())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.optional(7, "partition_path", DataTypes.StringType, this.ALL_PARTITIONS()), ProcedureParameter$.MODULE$.optional(8, "merge", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)true))})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ProcedureParameter.class)));
        this.OUTPUT_TYPE_LATEST = new StructType((StructField[])((Object[])new StructField[]{new StructField("partition", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("file_id", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("base_instant", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("data_file", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("data_file_size", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("num_delta_files", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_delta_file_size", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("delta_size_compaction_scheduled", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("delta_size_compaction_unscheduled", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("delta_to_base_radio_compaction_scheduled", DataTypes.DoubleType, true, Metadata$.MODULE$.empty()), new StructField("delta_to_base_radio_compaction_unscheduled", DataTypes.DoubleType, true, Metadata$.MODULE$.empty()), new StructField("delta_files_compaction_scheduled", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("delta_files_compaction_unscheduled", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }
}

