/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMemoryConfig;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowHoodieLogFileRecordsProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I4A\u0001D\u0007\u00019!)A\u0005\u0001C\u0001K!)q\u0005\u0001C!Q!)!\u0007\u0001C!g!)!\b\u0001C!w!)\u0011\u000b\u0001C!%\u001e)a+\u0004E\u0001/\u001a)A\"\u0004E\u00011\")Ae\u0002C\u00019\"9Ql\u0002b\u0001\n\u0003q\u0006BB4\bA\u0003%q\fC\u0003i\u000f\u0011\u0005\u0011NA\u0011TQ><\bj\\8eS\u0016dun\u001a$jY\u0016\u0014VmY8sIN\u0004&o\\2fIV\u0014XM\u0003\u0002\u000f\u001f\u0005Q\u0001O]8dK\u0012,(/Z:\u000b\u0005A\t\u0012aB2p[6\fg\u000e\u001a\u0006\u0003%M\tA\u0001[;eS*\u0011A#F\u0001\u0004gFd'B\u0001\f\u0018\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0012$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00025\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!H\u0011\u0011\u0005yyR\"A\u0007\n\u0005\u0001j!!\u0004\"bg\u0016\u0004&o\\2fIV\u0014X\r\u0005\u0002\u001fE%\u00111%\u0004\u0002\u0011!J|7-\u001a3ve\u0016\u0014U/\u001b7eKJ\fa\u0001P5oSRtD#\u0001\u0014\u0011\u0005y\u0001\u0011A\u00039be\u0006lW\r^3sgV\t\u0011\u0006E\u0002+[=j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003=AJ!!M\u0007\u0003%A\u0013xnY3ekJ,\u0007+\u0019:b[\u0016$XM]\u0001\u000b_V$\b/\u001e;UsB,W#\u0001\u001b\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]\u001a\u0012!\u0002;za\u0016\u001c\u0018BA\u001d7\u0005)\u0019FO];diRK\b/Z\u0001\u0005G\u0006dG\u000e\u0006\u0002=\u0019B\u0019Q(\u0012%\u000f\u0005y\u001aeBA C\u001b\u0005\u0001%BA!\u001c\u0003\u0019a$o\\8u}%\tA&\u0003\u0002EW\u00059\u0001/Y2lC\u001e,\u0017B\u0001$H\u0005\r\u0019V-\u001d\u0006\u0003\t.\u0002\"!\u0013&\u000e\u0003MI!aS\n\u0003\u0007I{w\u000fC\u0003N\t\u0001\u0007a*\u0001\u0003be\u001e\u001c\bC\u0001\u0010P\u0013\t\u0001VBA\u0007Qe>\u001cW\rZ;sK\u0006\u0013xm]\u0001\u0006EVLG\u000eZ\u000b\u0002'B\u0011a\u0004V\u0005\u0003+6\u0011\u0011\u0002\u0015:pG\u0016$WO]3\u0002CMCwn\u001e%p_\u0012LW\rT8h\r&dWMU3d_J$7\u000f\u0015:pG\u0016$WO]3\u0011\u0005y91CA\u0004Z!\tQ#,\u0003\u0002\\W\t1\u0011I\\=SK\u001a$\u0012aV\u0001\u0005\u001d\u0006kU)F\u0001`!\t\u0001W-D\u0001b\u0015\t\u00117-\u0001\u0003mC:<'\"\u00013\u0002\t)\fg/Y\u0005\u0003M\u0006\u0014aa\u0015;sS:<\u0017!\u0002(B\u001b\u0016\u0003\u0013a\u00022vS2$WM]\u000b\u0002UB\u00191\u000e]\u0011\u000e\u00031T!!\u001c8\u0002\u0011\u0019,hn\u0019;j_:T!a\\2\u0002\tU$\u0018\u000e\\\u0005\u0003c2\u0014\u0001bU;qa2LWM\u001d")
public class ShowHoodieLogFileRecordsProcedure
extends BaseProcedure
implements ProcedureBuilder {
    public static Supplier<ProcedureBuilder> builder() {
        return ShowHoodieLogFileRecordsProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowHoodieLogFileRecordsProcedure$.MODULE$.NAME();
    }

    @Override
    public ProcedureParameter[] parameters() {
        return (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.required(1, "log_file_path_pattern", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(2, "merge", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(3, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10))});
    }

    @Override
    public StructType outputType() {
        return new StructType((StructField[])((Object[])new StructField[]{new StructField("records", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        this.checkArgs(this.parameters(), args);
        Option<Object> table = this.getArgValueOrDefault(args, this.parameters()[0]);
        String logFilePathPattern = (String)this.getArgValueOrDefault(args, this.parameters()[1]).get();
        boolean merge = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.parameters()[2]).get());
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.parameters()[3]).get());
        String basePath = this.getBasePath(table, this.getBasePath$default$2());
        HoodieTableMetaClient client = this.createMetaClient(this.jsc(), basePath);
        HoodieStorage storage = client.getStorage();
        List logFilePaths = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(FSUtils.getGlobStatusExcludingMetaFolder((HoodieStorage)storage, (StoragePath)new StoragePath(logFilePathPattern)).iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getPath().toString()).toList();
        ValidationUtils.checkArgument((boolean)logFilePaths.nonEmpty(), (String)"There is no log file");
        ArrayList allRecords = new ArrayList();
        if (merge) {
            Schema schema = Objects.requireNonNull(TableSchemaResolver.readSchemaFromLogFile((HoodieStorage)storage, (StoragePath)new StoragePath((String)logFilePaths.last())));
            HoodieMergedLogRecordScanner scanner = HoodieMergedLogRecordScanner.newBuilder().withStorage(storage).withBasePath(basePath).withLogFilePaths((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)logFilePaths).asJava()).withReaderSchema(schema).withLatestInstantTime(((HoodieInstant)client.getActiveTimeline().getCommitAndReplaceTimeline().lastInstant().get()).requestedTime()).withReverseReader(Boolean.parseBoolean((String)HoodieReaderConfig.COMPACTION_REVERSE_LOG_READ_ENABLE.defaultValue())).withBufferSize(Predef$.MODULE$.Integer2int((Integer)HoodieMemoryConfig.MAX_DFS_STREAM_BUFFER_SIZE.defaultValue())).withMaxMemorySizeInBytes(Predef$.MODULE$.long2Long(0x40000000L)).withSpillableMapBasePath(FileIOUtils.getDefaultSpillableMapBasePath()).withDiskMapType((ExternalSpillableMap.DiskMapType)HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.defaultValue()).withBitCaskDiskMapCompressionEnabled(Predef$.MODULE$.Boolean2boolean((Boolean)HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.defaultValue())).build();
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)scanner).asScala()).foreach((Function1 & Serializable & scala.Serializable)hoodieRecord -> {
                IndexedRecord record = (IndexedRecord)((HoodieRecordPayload)hoodieRecord.getData()).getInsertValue(schema).get();
                if (allRecords.size() < limit) {
                    return BoxesRunTime.boxToBoolean((boolean)allRecords.add(record));
                }
                return BoxedUnit.UNIT;
            });
        } else {
            logFilePaths.toStream().takeWhile((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ShowHoodieLogFileRecordsProcedure.$anonfun$call$3(allRecords, limit, x$2))).foreach((Function1 & Serializable & scala.Serializable)logFilePath -> {
                ShowHoodieLogFileRecordsProcedure.$anonfun$call$4(storage, allRecords, limit, logFilePath);
                return BoxedUnit.UNIT;
            });
        }
        ArrayList rows = new ArrayList(allRecords.size());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(allRecords).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToBoolean((boolean)rows.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{record.toString()})))));
        return ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(rows).asScala()).toSeq();
    }

    @Override
    public Procedure build() {
        return new ShowHoodieLogFileRecordsProcedure();
    }

    public static final /* synthetic */ boolean $anonfun$call$3(java.util.List allRecords$1, int limit$1, String x$2) {
        return allRecords$1.size() < limit$1;
    }

    public static final /* synthetic */ void $anonfun$call$4(HoodieStorage storage$1, java.util.List allRecords$1, int limit$1, String logFilePath) {
        Schema schema = Objects.requireNonNull(TableSchemaResolver.readSchemaFromLogFile((HoodieStorage)storage$1, (StoragePath)new StoragePath(logFilePath)));
        HoodieLogFormat.Reader reader = HoodieLogFormat.newReader((HoodieStorage)storage$1, (HoodieLogFile)new HoodieLogFile(logFilePath), (Schema)schema);
        while (reader.hasNext()) {
            HoodieLogBlock block = (HoodieLogBlock)reader.next();
            HoodieLogBlock hoodieLogBlock = block;
            if (hoodieLogBlock instanceof HoodieDataBlock) {
                HoodieDataBlock hoodieDataBlock = (HoodieDataBlock)hoodieLogBlock;
                ClosableIterator recordItr = hoodieDataBlock.getRecordIterator(HoodieRecord.HoodieRecordType.AVRO);
                ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)recordItr).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
                    if (allRecords$1.size() < limit$1) {
                        return BoxesRunTime.boxToBoolean((boolean)allRecords$1.add((IndexedRecord)record.getData()));
                    }
                    return BoxedUnit.UNIT;
                });
                recordItr.close();
                continue;
            }
            throw new MatchError((Object)hoodieLogBlock);
        }
        reader.close();
    }
}

