/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.StatsWriteAmplificationProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001I4A\u0001D\u0007\u00019!)A\u0005\u0001C\u0001K!)q\u0005\u0001C!Q!)!\u0007\u0001C!g!)!\b\u0001C!w!)\u0011\u000b\u0001C!%\u001e)a+\u0004E\u0001/\u001a)A\"\u0004E\u00011\")Ae\u0002C\u00019\"9Ql\u0002b\u0001\n\u0003q\u0006BB4\bA\u0003%q\fC\u0003i\u000f\u0011\u0005\u0011N\u0001\u0011Ti\u0006$8o\u0016:ji\u0016\fU\u000e\u001d7jM&\u001c\u0017\r^5p]B\u0013xnY3ekJ,'B\u0001\b\u0010\u0003)\u0001(o\\2fIV\u0014Xm\u001d\u0006\u0003!E\tqaY8n[\u0006tGM\u0003\u0002\u0013'\u0005!\u0001.\u001e3j\u0015\t!R#A\u0002tc2T!AF\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005aI\u0012AB1qC\u000eDWMC\u0001\u001b\u0003\ry'oZ\u0002\u0001'\r\u0001Q$\t\t\u0003=}i\u0011!D\u0005\u0003A5\u0011QBQ1tKB\u0013xnY3ekJ,\u0007C\u0001\u0010#\u0013\t\u0019SB\u0001\tQe>\u001cW\rZ;sK\n+\u0018\u000e\u001c3fe\u00061A(\u001b8jiz\"\u0012A\n\t\u0003=\u0001\t!\u0002]1sC6,G/\u001a:t+\u0005I\u0003c\u0001\u0016._5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3FA\u0003BeJ\f\u0017\u0010\u0005\u0002\u001fa%\u0011\u0011'\u0004\u0002\u0013!J|7-\u001a3ve\u0016\u0004\u0016M]1nKR,'/\u0001\u0006pkR\u0004X\u000f\u001e+za\u0016,\u0012\u0001\u000e\t\u0003kaj\u0011A\u000e\u0006\u0003oM\tQ\u0001^=qKNL!!\u000f\u001c\u0003\u0015M#(/^2u)f\u0004X-\u0001\u0003dC2dGC\u0001\u001fM!\riT\t\u0013\b\u0003}\rs!a\u0010\"\u000e\u0003\u0001S!!Q\u000e\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0013B\u0001#,\u0003\u001d\u0001\u0018mY6bO\u0016L!AR$\u0003\u0007M+\u0017O\u0003\u0002EWA\u0011\u0011JS\u0007\u0002'%\u00111j\u0005\u0002\u0004%><\b\"B'\u0005\u0001\u0004q\u0015\u0001B1sON\u0004\"AH(\n\u0005Ak!!\u0004)s_\u000e,G-\u001e:f\u0003J<7/A\u0003ck&dG-F\u0001T!\tqB+\u0003\u0002V\u001b\tI\u0001K]8dK\u0012,(/Z\u0001!'R\fGo],sSR,\u0017)\u001c9mS\u001aL7-\u0019;j_:\u0004&o\\2fIV\u0014X\r\u0005\u0002\u001f\u000fM\u0011q!\u0017\t\u0003UiK!aW\u0016\u0003\r\u0005s\u0017PU3g)\u00059\u0016\u0001\u0002(B\u001b\u0016+\u0012a\u0018\t\u0003A\u0016l\u0011!\u0019\u0006\u0003E\u000e\fA\u0001\\1oO*\tA-\u0001\u0003kCZ\f\u0017B\u00014b\u0005\u0019\u0019FO]5oO\u0006)a*Q'FA\u00059!-^5mI\u0016\u0014X#\u00016\u0011\u0007-\u0004\u0018%D\u0001m\u0015\tig.\u0001\u0005gk:\u001cG/[8o\u0015\ty7-\u0001\u0003vi&d\u0017BA9m\u0005!\u0019V\u000f\u001d9mS\u0016\u0014\b")
public class StatsWriteAmplificationProcedure
extends BaseProcedure
implements ProcedureBuilder {
    public static Supplier<ProcedureBuilder> builder() {
        return StatsWriteAmplificationProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return StatsWriteAmplificationProcedure$.MODULE$.NAME();
    }

    @Override
    public ProcedureParameter[] parameters() {
        return (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(1, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10))});
    }

    @Override
    public StructType outputType() {
        return new StructType((StructField[])((Object[])new StructField[]{new StructField("commit_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("total_upserted", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("write_amplification_factor", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        this.checkArgs(this.parameters(), args);
        Option<Object> table = this.getArgValueOrDefault(args, this.parameters()[0]);
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.parameters()[1]).get());
        String basePath = this.getBasePath(table, this.getBasePath$default$2());
        HoodieTableMetaClient client = this.createMetaClient(this.jsc(), basePath);
        HoodieActiveTimeline activeTimeline = client.getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCommitAndReplaceTimeline().filterCompletedInstants();
        ArrayList<Row> rows = new ArrayList<Row>();
        DecimalFormat df = new DecimalFormat("#.00");
        LongRef totalRecordsUpserted = LongRef.create((long)0L);
        LongRef totalRecordsWritten = LongRef.create((long)0L);
        TimelineLayout layout = TimelineLayout.fromVersion((TimelineLayoutVersion)timeline.getTimelineLayoutVersion());
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(timeline.getInstants().iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)instantTime -> {
            StatsWriteAmplificationProcedure.$anonfun$call$1(layout, activeTimeline, df, rows, totalRecordsUpserted, totalRecordsWritten, instantTime);
            return BoxedUnit.UNIT;
        });
        String waf = "0";
        if (totalRecordsUpserted.elem > 0L) {
            waf = df.format((float)totalRecordsWritten.elem / (float)totalRecordsUpserted.elem);
        }
        rows.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Total", BoxesRunTime.boxToLong((long)totalRecordsUpserted.elem), BoxesRunTime.boxToLong((long)totalRecordsWritten.elem), waf})));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray())).map((Function1 & Serializable & scala.Serializable)r -> (Row)r, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))))).toList();
    }

    @Override
    public Procedure build() {
        return new StatsWriteAmplificationProcedure();
    }

    public static final /* synthetic */ void $anonfun$call$1(TimelineLayout layout$1, HoodieActiveTimeline activeTimeline$1, DecimalFormat df$1, ArrayList rows$1, LongRef totalRecordsUpserted$1, LongRef totalRecordsWritten$1, HoodieInstant instantTime) {
        String waf = "0";
        HoodieCommitMetadata commit = (HoodieCommitMetadata)layout$1.getCommitMetadataSerDe().deserialize(instantTime, (byte[])activeTimeline$1.getInstantDetails(instantTime).get(), HoodieCommitMetadata.class);
        if (commit.fetchTotalUpdateRecordsWritten() > 0L) {
            waf = df$1.format((float)commit.fetchTotalRecordsWritten() / (float)commit.fetchTotalUpdateRecordsWritten());
        }
        rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{instantTime.requestedTime(), BoxesRunTime.boxToLong((long)commit.fetchTotalUpdateRecordsWritten()), BoxesRunTime.boxToLong((long)commit.fetchTotalRecordsWritten()), waf})));
        totalRecordsUpserted$1.elem += commit.fetchTotalUpdateRecordsWritten();
        totalRecordsWritten$1.elem += commit.fetchTotalRecordsWritten();
    }
}

