/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import org.apache.hudi.TestAutoKeyGenForSQL$;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import scala.Predef$;
import scala.Tuple6;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000113A\u0001B\u0003\u0001\u0019!)1\u0003\u0001C\u0001)!)q\u0003\u0001C!1!)q\u0004\u0001C\u0001A\t!B+Z:u\u0003V$xnS3z\u000f\u0016tgi\u001c:T#2S!AB\u0004\u0002\t!,H-\u001b\u0006\u0003\u0011%\ta!\u00199bG\",'\"\u0001\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001i\u0001C\u0001\b\u0012\u001b\u0005y!B\u0001\t\u0006\u0003%!Xm\u001d;vi&d7/\u0003\u0002\u0013\u001f\t\u00013\u000b]1sW\u000ec\u0017.\u001a8u\rVt7\r^5p]\u0006dG+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\tQ!\u0001\u0003d_:4G#A\r\u0011\u0005iiR\"A\u000e\u000b\u0005q9\u0011!B:qCJ\\\u0017B\u0001\u0010\u001c\u0005%\u0019\u0006/\u0019:l\u0007>tg-\u0001\buKN$\u0018)\u001e;p\u0017\u0016Lx)\u001a8\u0015\u0005\u0005:\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#\u0001B+oSRDQ\u0001K\u0002A\u0002%\n\u0011\u0002^1cY\u0016$\u0016\u0010]3\u0011\u0005)\ndBA\u00160!\ta3%D\u0001.\u0015\tq3\"\u0001\u0004=e>|GOP\u0005\u0003a\r\na\u0001\u0015:fI\u00164\u0017B\u0001\u001a4\u0005\u0019\u0019FO]5oO*\u0011\u0001g\t\u0015\u0005\u0007U\n%\t\u0005\u00027\u007f5\tqG\u0003\u00029s\u0005A\u0001O]8wS\u0012,'O\u0003\u0002;w\u00051\u0001/\u0019:b[NT!\u0001P\u001f\u0002\u000f),\b/\u001b;fe*\u0011a(C\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u0001^\u0012\u0011bQ:w'>,(oY3\u0002\u000bY\fG.^3-\u0005\r+\u0015%\u0001#\u0002\u001b5+%kR#`\u001f:{&+R!EC\u00051\u0015!D\"P!f{vJT0X%&#V\t\u000b\u0002\u0004\u0011B\u0011\u0011JS\u0007\u0002s%\u00111*\u000f\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\b")
public class TestAutoKeyGenForSQL
extends SparkClientFunctionalTestHarness {
    public SparkConf conf() {
        return this.conf(SparkClientFunctionalTestHarness.getSparkSqlConf());
    }

    @ParameterizedTest
    @CsvSource(value={"MERGE_ON_READ", "COPY_ON_WRITE"})
    public void testAutoKeyGen(String tableType) {
        String tableName = new StringBuilder(12).append("hoodie_test_").append(tableType).toString();
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(564).append("\n         |create table ").append(tableName).append(" (\n         | ts BIGINT,\n         | uuid STRING,\n         | rider STRING,\n         | driver STRING,\n         | fare DOUBLE,\n         | city STRING\n         |) using hudi\n         | options (\n         |  hoodie.metadata.enable = 'true',\n         |  hoodie.enable.data.skipping = 'true',\n         |  hoodie.datasource.write.payload.class = 'org.apache.hudi.common.model.OverwriteWithLatestAvroPayload'\n         | )\n         | partitioned by(city)\n         | location '").append(this.basePath()).append("'\n         | TBLPROPERTIES (hoodie.datasource.write.table.type='").append(tableType).append("')\n       ").toString())).stripMargin());
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(909).append("\n         |INSERT INTO ").append(tableName).append(" VALUES\n         |  (1695159649087,'334e26e9-8355-45cc-97c6-c31daf0df330','rider-A','driver-K',19.10,'san_francisco'),\n         |  (1695091554788,'e96c4396-3fad-413a-a942-4cb36106d721','rider-C','driver-M',27.70 ,'san_francisco'),\n         |  (1695046462179,'9909a8b1-2d15-4d3d-8ec9-efc48c536a00','rider-D','driver-L',33.90 ,'san_francisco'),\n         |  (1695332066204,'1dced545-862b-4ceb-8b43-d2a568f6616b','rider-E','driver-O',93.50,'san_francisco'),\n         |  (1695516137016,'e3cf430c-889d-4015-bc98-59bdce1e530c','rider-F','driver-P',34.15,'sao_paulo'),\n         |  (1695376420876,'7a84095f-737f-40bc-b62f-6b69664712d2','rider-G','driver-Q',43.40 ,'sao_paulo'),\n         |  (1695173887231,'3eeb61f7-c2b0-4636-99bd-5d7a5a1d2c04','rider-I','driver-S',41.06 ,'chennai'),\n         |  (1695115999911,'c8abbe79-8d89-47ea-b4ce-4d224bae5bfa','rider-J','driver-T',17.85,'chennai');\n      ").toString())).stripMargin());
        this.spark().sql(new StringBuilder(48).append("UPDATE ").append(tableName).append(" SET fare = 25.0 WHERE rider = 'rider-D';").toString());
        this.spark().sql(new StringBuilder(65).append("DELETE FROM ").append(tableName).append(" WHERE uuid = '334e26e9-8355-45cc-97c6-c31daf0df330';").toString());
        this.spark().sql(new StringBuilder(65).append("DELETE FROM ").append(tableName).append(" WHERE uuid = '9909a8b1-2d15-4d3d-8ec9-efc48c536a00';").toString());
        Seq columns = (Seq)new .colon.colon((Object)"ts", (List)new .colon.colon((Object)"uuid", (List)new .colon.colon((Object)"rider", (List)new .colon.colon((Object)"driver", (List)new .colon.colon((Object)"fare", (List)new .colon.colon((Object)"city", (List)Nil$.MODULE$))))));
        Dataset actualDf = this.spark().sql(new StringBuilder(44).append("SELECT * FROM ").append(tableName).append(" WHERE city = 'san_francisco';").toString()).select("ts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uuid", "rider", "driver", "fare", "city"})).sort("uuid", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        Seq expected = (Seq)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToLong((long)1695091554788L), (Object)"e96c4396-3fad-413a-a942-4cb36106d721", (Object)"rider-C", (Object)"driver-M", (Object)BoxesRunTime.boxToDouble((double)27.7), (Object)"san_francisco"), (List)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToLong((long)1695332066204L), (Object)"1dced545-862b-4ceb-8b43-d2a568f6616b", (Object)"rider-E", (Object)"driver-O", (Object)BoxesRunTime.boxToDouble((double)93.5), (Object)"san_francisco"), (List)Nil$.MODULE$));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestAutoKeyGenForSQL.class.getClassLoader());
        public final class Org_apache_hudi_TestAutoKeyGenForSQL$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple6"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)))))));
            }

            public Org_apache_hudi_TestAutoKeyGenForSQL$$typecreator1$1(TestAutoKeyGenForSQL $outer) {
            }
        }
        Dataset expectedDf = this.spark().createDataFrame(expected, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestAutoKeyGenForSQL$$typecreator1$1(null))).toDF(columns);
        Dataset expectedMinusActual = expectedDf.except(actualDf);
        Dataset actualMinusExpected = actualDf.except(expectedDf);
        Assertions.assertTrue((expectedMinusActual.isEmpty() && actualMinusExpected.isEmpty() ? 1 : 0) != 0);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(this.basePath()).setConf((StorageConfiguration)new HadoopStorageConfiguration(this.spark().sparkContext().hadoopConfiguration())).build();
        Assertions.assertTrue((boolean)metaClient.getTableConfig().getRecordKeyFields().isEmpty());
    }
}

