/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import org.apache.spark.sql.HoodieCatalystExpressionUtils$;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001B\f\u0019\u0001}AQA\n\u0001\u0005\u0002\u001dB\u0001B\u000b\u0001\t\u0006\u0004%Ia\u000b\u0005\u0006m\u0001!Ia\u000e\u0005\u0006\u001f\u0002!\t\u0001\u0015\u0005\u0006?\u0002!\t\u0001\u0015\u0005\u0006C\u0002!IA\u0019\u0005\u0006e\u0002!Ia\u001d\u0005\u0006m\u0002!Ia\u001e\u0005\u0007\u007f\u0002!I!!\u0001\t\u000f\u0005\u001d\u0001\u0001\"\u0003\u0002\n!9\u0011q\u0002\u0001\u0005\n\u0005E\u0001bBA\f\u0001\u0011%\u0011\u0011\u0004\u0005\b\u0003?\u0001A\u0011BA\u0011\u0011\u001d\t9\u0003\u0001C\u0005\u0003SAq!a\u000e\u0001\t\u0013\tI\u0004C\u0004\u0002>\u0001!I!a\u0010\t\u000f\u0005\r\u0003\u0001\"\u0003\u0002F!9\u0011q\n\u0001\u0005\n\u0005E\u0003bBA,\u0001\u0011%\u0011\u0011\f\u0005\b\u0003?\u0002A\u0011BA1\u0011\u001d\t9\u0007\u0001C\u0005\u0003SBq!a\u001c\u0001\t\u0013\t\tHA\u0013UKN$8i\u001c8wKJ$h)\u001b7uKJ$vnQ1uC2L8\u000f^#yaJ,7o]5p]*\u0011\u0011DG\u0001\u0005QV$\u0017N\u0003\u0002\u001c9\u00051\u0011\r]1dQ\u0016T\u0011!H\u0001\u0004_J<7\u0001A\n\u0003\u0001\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001)!\tI\u0003!D\u0001\u0019\u0003-!\u0018M\u00197f'\u000eDW-\\1\u0016\u00031\u0002\"!\f\u001b\u000e\u00039R!a\f\u0019\u0002\u000bQL\b/Z:\u000b\u0005E\u0012\u0014aA:rY*\u00111GG\u0001\u0006gB\f'o[\u0005\u0003k9\u0012!b\u0015;sk\u000e$H+\u001f9f\u0003m\u0019wN\u001c<feR$vnQ1uC2L8\u000f^#yaJ,7o]5p]R\u0019\u0001h\u0011(\u0011\u0007\u0005J4(\u0003\u0002;E\t1q\n\u001d;j_:\u0004\"\u0001P!\u000e\u0003uR!AP \u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u0001B\n\u0001bY1uC2L8\u000f^\u0005\u0003\u0005v\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0011\u0015!5\u00011\u0001F\u0003\u001d1\u0017\u000e\u001c;feN\u00042!\t$I\u0013\t9%EA\u0003BeJ\f\u0017\u0010\u0005\u0002J\u00196\t!J\u0003\u0002La\u000591o\\;sG\u0016\u001c\u0018BA'K\u0005\u00191\u0015\u000e\u001c;fe\")!f\u0001a\u0001Y\u0005yA/Z:u\u0005\u0006\u001cXmQ8om\u0016\u0014H\u000fF\u0001R!\t\t#+\u0003\u0002TE\t!QK\\5uQ\t!Q\u000b\u0005\u0002W;6\tqK\u0003\u0002Y3\u0006\u0019\u0011\r]5\u000b\u0005i[\u0016a\u00026va&$XM\u001d\u0006\u00039r\tQA[;oSRL!AX,\u0003\tQ+7\u000f^\u0001\u0013i\u0016\u001cHoQ8om\u0016\u0014HOR5mi\u0016\u00148\u000f\u000b\u0002\u0006+\u0006\u00112\r[3dW\u000e{gN^3si\u001aKG\u000e^3s)\r\t6-\u001a\u0005\u0006I\u001a\u0001\r\u0001S\u0001\u0007M&dG/\u001a:\t\u000b\u00194\u0001\u0019A4\u0002!\u0015D\b/Z2u\u000bb\u0004(/Z:tS>t\u0007C\u00015p\u001d\tIW\u000e\u0005\u0002kE5\t1N\u0003\u0002m=\u00051AH]8pizJ!A\u001c\u0012\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0018O\u0001\u0004TiJLgn\u001a\u0006\u0003]\n\n1c\u00195fG.\u001cuN\u001c<feR4\u0015\u000e\u001c;feN$2!\u0015;v\u0011\u0015!u\u00011\u0001F\u0011\u00151w\u00011\u0001h\u0003\t)\u0017\u000fF\u0002IqjDQ!\u001f\u0005A\u0002\u001d\f\u0011\"\u0019;ue&\u0014W\u000f^3\t\u000bmD\u0001\u0019\u0001?\u0002\u000bY\fG.^3\u0011\u0005\u0005j\u0018B\u0001@#\u0005\r\te._\u0001\u0004KF\u001cH#\u0002%\u0002\u0004\u0005\u0015\u0001\"B=\n\u0001\u00049\u0007\"B>\n\u0001\u0004a\u0018AA4u)\u0015A\u00151BA\u0007\u0011\u0015I(\u00021\u0001h\u0011\u0015Y(\u00021\u0001}\u0003\r9G/\u001a\u000b\u0006\u0011\u0006M\u0011Q\u0003\u0005\u0006s.\u0001\ra\u001a\u0005\u0006w.\u0001\r\u0001`\u0001\u0003YR$R\u0001SA\u000e\u0003;AQ!\u001f\u0007A\u0002\u001dDQa\u001f\u0007A\u0002q\f1\u0001\u001c;f)\u0015A\u00151EA\u0013\u0011\u0015IX\u00021\u0001h\u0011\u0015YX\u00021\u0001}\u0003\tIg\u000eF\u0003I\u0003W\ti\u0003C\u0003z\u001d\u0001\u0007q\rC\u0004\u000209\u0001\r!!\r\u0002\rY\fG.^3t!\u0011\t\u00131\u0007?\n\u0007\u0005U\"E\u0001\u0006=e\u0016\u0004X-\u0019;fIz\na![:Ok2dGc\u0001%\u0002<!)\u0011p\u0004a\u0001O\u0006I\u0011n\u001d(pi:+H\u000e\u001c\u000b\u0004\u0011\u0006\u0005\u0003\"B=\u0011\u0001\u00049\u0017aA1oIR)\u0001*a\u0012\u0002L!1\u0011\u0011J\tA\u0002!\u000bA\u0001\\3gi\"1\u0011QJ\tA\u0002!\u000bQA]5hQR\f!a\u001c:\u0015\u000b!\u000b\u0019&!\u0016\t\r\u0005%#\u00031\u0001I\u0011\u0019\tiE\u0005a\u0001\u0011\u0006\u0019an\u001c;\u0015\u0007!\u000bY\u0006\u0003\u0004\u0002^M\u0001\r\u0001S\u0001\u0006G\"LG\u000eZ\u0001\ngR\f'\u000f^,ji\"$R\u0001SA2\u0003KBQ!\u001f\u000bA\u0002\u001dDQa\u001f\u000bA\u0002\u001d\fq!\u001a8e/&$\b\u000eF\u0003I\u0003W\ni\u0007C\u0003z+\u0001\u0007q\rC\u0003|+\u0001\u0007q-\u0001\u0005d_:$\u0018-\u001b8t)\u0015A\u00151OA;\u0011\u0015Ih\u00031\u0001h\u0011\u0015Yh\u00031\u0001h\u0001")
public class TestConvertFilterToCatalystExpression {
    private StructType tableSchema;
    private volatile boolean bitmap$0;

    private StructType tableSchema$lzycompute() {
        TestConvertFilterToCatalystExpression testConvertFilterToCatalystExpression = this;
        synchronized (testConvertFilterToCatalystExpression) {
            if (!this.bitmap$0) {
                ArrayBuffer fields = new ArrayBuffer();
                fields.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("id", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}));
                fields.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("name", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4())}));
                fields.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("price", (DataType)DoubleType$.MODULE$, true, StructField$.MODULE$.apply$default$4())}));
                fields.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("ts", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}));
                this.tableSchema = StructType$.MODULE$.apply(fields.toSeq());
                this.bitmap$0 = true;
            }
        }
        return this.tableSchema;
    }

    private StructType tableSchema() {
        if (!this.bitmap$0) {
            return this.tableSchema$lzycompute();
        }
        return this.tableSchema;
    }

    private Option<Expression> convertToCatalystExpression(Filter[] filters, StructType tableSchema) {
        Option[] expressions = (Option[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filters)).map((Function1 & Serializable & scala.Serializable)x$1 -> HoodieCatalystExpressionUtils$.MODULE$.convertToCatalystExpression(x$1, tableSchema), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Option.class)));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expressions)).nonEmpty() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expressions)).forall((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)p.isDefined()))) {
            return new Some(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expressions)).map((Function1 & Serializable & scala.Serializable)x$2 -> (Expression)x$2.get(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class))))).reduce((Function2)And$.MODULE$));
        }
        return None$.MODULE$;
    }

    @Test
    public void testBaseConvert() {
        this.checkConvertFilter(this.eq("id", BoxesRunTime.boxToInteger((int)1)), "(`id` = 1)");
        this.checkConvertFilter(this.eqs("name", "a1"), "(`name` <=> 'a1')");
        this.checkConvertFilter(this.lt("price", BoxesRunTime.boxToInteger((int)10)), "(`price` < 10)");
        this.checkConvertFilter(this.lte("ts", BoxesRunTime.boxToInteger((int)1)), "(`ts` <= 1)");
        this.checkConvertFilter(this.gt("price", BoxesRunTime.boxToInteger((int)10)), "(`price` > 10)");
        this.checkConvertFilter(this.gte("price", BoxesRunTime.boxToInteger((int)10)), "(`price` >= 10)");
        this.checkConvertFilter(this.in("id", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)})), "(`id` IN (1, 2, 3))");
        this.checkConvertFilter(this.isNull("id"), "(`id` IS NULL)");
        this.checkConvertFilter(this.isNotNull("name"), "(`name` IS NOT NULL)");
        this.checkConvertFilter(this.and(this.lt("ts", BoxesRunTime.boxToInteger((int)10)), this.gt("ts", BoxesRunTime.boxToInteger((int)1))), "((`ts` < 10) AND (`ts` > 1))");
        this.checkConvertFilter(this.or(this.lte("ts", BoxesRunTime.boxToInteger((int)10)), this.gte("ts", BoxesRunTime.boxToInteger((int)1))), "((`ts` <= 10) OR (`ts` >= 1))");
        this.checkConvertFilter(this.not(this.and(this.lt("ts", BoxesRunTime.boxToInteger((int)10)), this.gt("ts", BoxesRunTime.boxToInteger((int)1)))), "(NOT ((`ts` < 10) AND (`ts` > 1)))");
        this.checkConvertFilter(this.startWith("name", "ab"), "`name` LIKE 'ab%'");
        this.checkConvertFilter(this.endWith("name", "cd"), "`name` LIKE '%cd'");
        this.checkConvertFilter(this.contains("name", "e"), "`name` LIKE '%e%'");
    }

    @Test
    public void testConvertFilters() {
        this.checkConvertFilters((Filter[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Filter.class)), null);
        this.checkConvertFilters((Filter[])((Object[])new Filter[]{this.eq("id", BoxesRunTime.boxToInteger((int)1))}), "(`id` = 1)");
        this.checkConvertFilters((Filter[])((Object[])new Filter[]{this.lt("ts", BoxesRunTime.boxToInteger((int)10)), this.gt("ts", BoxesRunTime.boxToInteger((int)1))}), "((`ts` < 10) AND (`ts` > 1))");
    }

    private void checkConvertFilter(Filter filter, String expectExpression) {
        String removeQuotesIfNeed = expectExpression != null ? expectExpression.replace("`", "") : expectExpression;
        Option exp = HoodieCatalystExpressionUtils$.MODULE$.convertToCatalystExpression(filter, this.tableSchema());
        if (removeQuotesIfNeed == null) {
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)exp.isEmpty()), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            return;
        }
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)exp.isDefined()), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        Assertions.assertEquals((Object)removeQuotesIfNeed, (Object)((Expression)exp.get()).sql());
    }

    private void checkConvertFilters(Filter[] filters, String expectExpression) {
        String removeQuotesIfNeed = expectExpression != null ? expectExpression.replace("`", "") : expectExpression;
        Option<Expression> exp = this.convertToCatalystExpression(filters, this.tableSchema());
        if (removeQuotesIfNeed == null) {
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)exp.isEmpty()), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            return;
        }
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)exp.isDefined()), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        Assertions.assertEquals((Object)removeQuotesIfNeed, (Object)((Expression)exp.get()).sql());
    }

    private Filter eq(String attribute, Object value) {
        return new EqualTo(attribute, value);
    }

    private Filter eqs(String attribute, Object value) {
        return new EqualNullSafe(attribute, value);
    }

    private Filter gt(String attribute, Object value) {
        return new GreaterThan(attribute, value);
    }

    private Filter gte(String attribute, Object value) {
        return new GreaterThanOrEqual(attribute, value);
    }

    private Filter lt(String attribute, Object value) {
        return new LessThan(attribute, value);
    }

    private Filter lte(String attribute, Object value) {
        return new LessThanOrEqual(attribute, value);
    }

    private Filter in(String attribute, Seq<Object> values) {
        return new In(attribute, (Object[])values.toArray(ClassTag$.MODULE$.Any()));
    }

    private Filter isNull(String attribute) {
        return new IsNull(attribute);
    }

    private Filter isNotNull(String attribute) {
        return new IsNotNull(attribute);
    }

    private Filter and(Filter left, Filter right) {
        return new And(left, right);
    }

    private Filter or(Filter left, Filter right) {
        return new Or(left, right);
    }

    private Filter not(Filter child) {
        return new Not(child);
    }

    private Filter startWith(String attribute, String value) {
        return new StringStartsWith(attribute, value);
    }

    private Filter endWith(String attribute, String value) {
        return new StringEndsWith(attribute, value);
    }

    private Filter contains(String attribute, String value) {
        return new StringContains(attribute, value);
    }
}

