/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.DefaultSparkRecordMerger;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0003\u0006\u0001#!)\u0001\u0004\u0001C\u00013!9A\u0004\u0001b\u0001\n\u0003i\u0002B\u0002\u0018\u0001A\u0003%a\u0004C\u00040\u0001\t\u0007I\u0011A\u000f\t\rA\u0002\u0001\u0015!\u0003\u001f\u0011\u001d\t\u0004A1A\u0005\u0002IBaA\u000f\u0001!\u0002\u0013\u0019\u0004\"B\u001e\u0001\t\u0003a$a\u0007+fgR$UmY5nC2$\u0016\u0010]3ECR\fwk\u001c:lM2|wO\u0003\u0002\f\u0019\u0005!\u0001.\u001e3j\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+)\t\u0011\u0002^3tiV$\u0018\u000e\\:\n\u0005]!\"\u0001I*qCJ\\7\t\\5f]R4UO\\2uS>t\u0017\r\u001c+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#\u0001\u000e\u0011\u0005m\u0001Q\"\u0001\u0006\u0002\u0013M\u0004\u0018M]6PaR\u001cX#\u0001\u0010\u0011\t}A3f\u000b\b\u0003A\u0019\u0002\"!\t\u0013\u000e\u0003\tR!a\t\t\u0002\rq\u0012xn\u001c;?\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011F\u000b\u0002\u0004\u001b\u0006\u0004(BA\u0014%!\tyB&\u0003\u0002.U\t11\u000b\u001e:j]\u001e\f!b\u001d9be.|\u0005\u000f^:!\u000311wMU3bI\u0016\u0014x\n\u001d;t\u000351wMU3bI\u0016\u0014x\n\u001d;tA\u0005!q\u000e\u001d;t+\u0005\u0019\u0004\u0003\u0002\u001b:W-j\u0011!\u000e\u0006\u0003m]\n\u0011\"[7nkR\f'\r\\3\u000b\u0005a\"\u0013AC2pY2,7\r^5p]&\u0011\u0011&N\u0001\u0006_B$8\u000fI\u0001\"i\u0016\u001cH\u000fR3dS6\fG.\u00138tKJ$X\u000b\u001d3bi\u0016$U\r\\3uKJ+\u0017\r\u001a\u000b\u0004{\u0005\u001b\u0005C\u0001 @\u001b\u0005!\u0013B\u0001!%\u0005\u0011)f.\u001b;\t\u000b\tC\u0001\u0019A\u0016\u0002\u0013A\u0014XmY5tS>t\u0007\"\u0002#\t\u0001\u0004Y\u0013!B:dC2,\u0007\u0006\u0002\u0005G%N\u0003\"a\u0012)\u000e\u0003!S!!\u0013&\u0002\u0011A\u0014xN^5eKJT!a\u0013'\u0002\rA\f'/Y7t\u0015\tie*A\u0004kkBLG/\u001a:\u000b\u0005=s\u0011!\u00026v]&$\u0018BA)I\u0005%\u00195O^*pkJ\u001cW-A\u0003wC2,X\rL\u0003U-bSF,I\u0001V\u0003\u0011\t\u0004\u0007\f\u001a\"\u0003]\u000bA!M\u001b-k\u0005\n\u0011,A\u00033a1\n\u0004'I\u0001\\\u0003\u0015\u0019\u0004\bL\u00199C\u0005i\u0016aA\u001b-a!\u0012\u0001b\u0018\t\u0003A\u0006l\u0011AS\u0005\u0003E*\u0013\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0001")
public class TestDecimalTypeDataWorkflow
extends SparkClientFunctionalTestHarness {
    private final Map<String, String> sparkOpts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieStorageConfig.LOGFILE_DATA_BLOCK_FORMAT.key()), (Object)"parquet"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.RECORD_MERGE_IMPL_CLASSES.key()), (Object)DefaultSparkRecordMerger.class.getName())}));
    private final Map<String, String> fgReaderOpts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieReaderConfig.FILE_GROUP_READER_ENABLED.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieReaderConfig.MERGE_USE_RECORD_POSITIONS.key()), (Object)"true")}));
    private final Map<String, String> opts = this.sparkOpts().$plus$plus(this.fgReaderOpts());

    public Map<String, String> sparkOpts() {
        return this.sparkOpts;
    }

    public Map<String, String> fgReaderOpts() {
        return this.fgReaderOpts;
    }

    public Map<String, String> opts() {
        return this.opts;
    }

    @ParameterizedTest
    @CsvSource(value={"10,2", "15,5", "20,10", "38,18", "5,0"})
    public void testDecimalInsertUpdateDeleteRead(String precision, String scale) {
        StructType schema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("id", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("decimal_col", (DataType)new DecimalType(Predef$.MODULE$.Integer2int(Integer.valueOf(precision)), Predef$.MODULE$.Integer2int(Integer.valueOf(scale))), true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)));
        String tablePath = this.basePath();
        Seq data = (Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)Decimal$.MODULE$.apply("123.45")), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)Decimal$.MODULE$.apply("987.65")), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), (Object)Decimal$.MODULE$.apply("-10.23")), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)4), (Object)Decimal$.MODULE$.apply("0.01")), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)5), (Object)Decimal$.MODULE$.apply("1000.00")), (List)Nil$.MODULE$)))));
        Seq rows = (Seq)data.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int id = tuple2._1$mcI$sp();
                Decimal decimalVal = (Decimal)tuple2._2();
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), decimalVal.toJavaBigDecimal()}));
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        SparkContext qual$1 = this.spark().sparkContext();
        Seq x$1 = rows;
        int x$2 = qual$1.parallelize$default$2();
        RDD rddData = qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class));
        Dataset insertDf = this.spark().sqlContext().createDataFrame(rddData, schema).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "decimal_col"})).sort("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        insertDf.write().format("hudi").option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "decimal_col").option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), "MERGE_ON_READ").option(DataSourceWriteOptions$.MODULE$.TABLE_NAME().key(), "test_table").options(this.opts()).mode(SaveMode.Overwrite).save(tablePath);
        Seq update = (Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)Decimal$.MODULE$.apply("543.21")), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)Decimal$.MODULE$.apply("111.11")), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)6), (Object)Decimal$.MODULE$.apply("1001.00")), (List)Nil$.MODULE$)));
        Seq updateRows = (Seq)update.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                int id = tuple2._1$mcI$sp();
                Decimal decimalVal = (Decimal)tuple2._2();
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), decimalVal.toJavaBigDecimal()}));
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        SparkContext qual$2 = this.spark().sparkContext();
        Seq x$3 = updateRows;
        int x$4 = qual$2.parallelize$default$2();
        RDD rddUpdate = qual$2.parallelize(x$3, x$4, ClassTag$.MODULE$.apply(Row.class));
        Dataset updateDf = this.spark().createDataFrame(rddUpdate, schema).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "decimal_col"})).sort("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        updateDf.write().format("hudi").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), "upsert").options(this.opts()).mode(SaveMode.Append).save(tablePath);
        Seq delete = (Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), (Object)Decimal$.MODULE$.apply("543.21")), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)4), (Object)Decimal$.MODULE$.apply("111.11")), (List)Nil$.MODULE$));
        Seq deleteRows = (Seq)delete.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                int id = tuple2._1$mcI$sp();
                Decimal decimalVal = (Decimal)tuple2._2();
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), decimalVal.toJavaBigDecimal()}));
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        SparkContext qual$3 = this.spark().sparkContext();
        Seq x$5 = deleteRows;
        int x$6 = qual$3.parallelize$default$2();
        RDD rddDelete = qual$3.parallelize(x$5, x$6, ClassTag$.MODULE$.apply(Row.class));
        Dataset deleteDf = this.spark().createDataFrame(rddDelete, schema).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "decimal_col"})).sort("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        deleteDf.write().format("hudi").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), "delete").options(this.opts()).mode(SaveMode.Append).save(tablePath);
        Dataset actual = this.spark().read().format("hudi").load(tablePath).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"decimal_col"}));
        Seq expected = (Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)Decimal$.MODULE$.apply("543.21")), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)Decimal$.MODULE$.apply("987.65")), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)5), (Object)Decimal$.MODULE$.apply("1000.00")), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)6), (Object)Decimal$.MODULE$.apply("1001.00")), (List)Nil$.MODULE$))));
        Seq expectedRows = (Seq)expected.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                int id = tuple2._1$mcI$sp();
                Decimal decimalVal = (Decimal)tuple2._2();
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), decimalVal.toJavaBigDecimal()}));
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        SparkContext qual$4 = this.spark().sparkContext();
        Seq x$7 = expectedRows;
        int x$8 = qual$4.parallelize$default$2();
        RDD rddExpected = qual$4.parallelize(x$7, x$8, ClassTag$.MODULE$.apply(Row.class));
        Dataset expectedDf = this.spark().createDataFrame(rddExpected, schema).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "decimal_col"})).sort("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        Dataset expectedMinusActual = expectedDf.except(actual);
        Dataset actualMinusExpected = actual.except(expectedDf);
        expectedDf.show(false);
        actual.show(false);
        expectedMinusActual.show(false);
        actualMinusExpected.show(false);
        Assertions.assertTrue((expectedMinusActual.isEmpty() && actualMinusExpected.isEmpty() ? 1 : 0) != 0);
    }
}

