/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import org.apache.hudi.HoodieDataSourceHelper$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.sources.Filter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M3A\u0001B\u0003\u0001\u0019!)q\u0003\u0001C\u00011!)!\u0004\u0001C\u00017!)a\t\u0001C\u0001\u000f\nQB+Z:u\u0011>|G-[3ECR\f7k\\;sG\u0016DU\r\u001c9fe*\u0011aaB\u0001\u0005QV$\u0017N\u0003\u0002\t\u0013\u00051\u0011\r]1dQ\u0016T\u0011AC\u0001\u0004_J<7\u0001A\n\u0004\u00015\u0019\u0002C\u0001\b\u0012\u001b\u0005y!B\u0001\t\u0006\u0003%!Xm\u001d;vi&d7/\u0003\u0002\u0013\u001f\t!\u0002j\\8eS\u0016\u001cE.[3oiR+7\u000f\u001e\"bg\u0016\u0004\"\u0001F\u000b\u000e\u0003\u0015I!AF\u0003\u0003'M\u0003\u0018M]6BI\u0006\u0004H/\u001a:TkB\u0004xN\u001d;\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000b\u0001\u00039\u0019\u0007.Z2l\u0007>tG-\u001b;j_:$B\u0001\b\u00122\u0003B\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t!QK\\5u\u0011\u0015\u0019#\u00011\u0001%\u0003\u00191\u0017\u000e\u001c;feB\u0019Q$J\u0014\n\u0005\u0019r\"AB(qi&|g\u000e\u0005\u0002)_5\t\u0011F\u0003\u0002+W\u000591o\\;sG\u0016\u001c(B\u0001\u0017.\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003]\u001d\tQa\u001d9be.L!\u0001M\u0015\u0003\r\u0019KG\u000e^3s\u0011\u0015\u0011$\u00011\u00014\u0003%yW\u000f\u001e9viN+G\u000fE\u00025wyr!!N\u001d\u0011\u0005YrR\"A\u001c\u000b\u0005aZ\u0011A\u0002\u001fs_>$h(\u0003\u0002;=\u00051\u0001K]3eK\u001aL!\u0001P\u001f\u0003\u0007M+GO\u0003\u0002;=A\u0011AgP\u0005\u0003\u0001v\u0012aa\u0015;sS:<\u0007\"\u0002\"\u0003\u0001\u0004\u0019\u0015\u0001C3ya\u0016\u001cG/\u001a3\u0011\u0005u!\u0015BA#\u001f\u0005\r\te._\u0001%i\u0016\u001cH/\u0012=ue\u0006\u001cG\u000f\u0015:fI&\u001c\u0017\r^3t/&$\b.\u001b8PkR\u0004X\u000f^*fiR\tA\u0004\u000b\u0002\u0004\u0013B\u0011!*U\u0007\u0002\u0017*\u0011A*T\u0001\u0004CBL'B\u0001(P\u0003\u001dQW\u000f]5uKJT!\u0001U\u0005\u0002\u000b),h.\u001b;\n\u0005I[%\u0001\u0002+fgR\u0004")
public class TestHoodieDataSourceHelper
extends HoodieClientTestBase
implements SparkAdapterSupport {
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    private SparkAdapter sparkAdapter$lzycompute() {
        TestHoodieDataSourceHelper testHoodieDataSourceHelper = this;
        synchronized (testHoodieDataSourceHelper) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$((SparkAdapterSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    public SparkAdapter sparkAdapter() {
        if (!this.bitmap$0) {
            return this.sparkAdapter$lzycompute();
        }
        return this.sparkAdapter;
    }

    public void checkCondition(Option<Filter> filter, Set<String> outputSet, Object expected) {
        Option actual = HoodieDataSourceHelper$.MODULE$.extractPredicatesWithinOutputSet((Filter)filter.get(), outputSet);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testExtractPredicatesWithinOutputSet() {
        Set dataColsWithNoPartitionCols = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "extra_col"}));
        Option expr1 = this.sparkAdapter().translateFilter(functions$.MODULE$.expr("(region='reg2' and id = 1) or region='reg1'").expr(), this.sparkAdapter().translateFilter$default$2());
        this.checkCondition((Option<Filter>)expr1, (Set<String>)dataColsWithNoPartitionCols, None$.MODULE$);
        Option expr2 = this.sparkAdapter().translateFilter(functions$.MODULE$.expr("region='reg2' and id = 1").expr(), this.sparkAdapter().translateFilter$default$2());
        Option expectedExpr2 = this.sparkAdapter().translateFilter(functions$.MODULE$.expr("id = 1").expr(), this.sparkAdapter().translateFilter$default$2());
        this.checkCondition((Option<Filter>)expr2, (Set<String>)dataColsWithNoPartitionCols, expectedExpr2);
        Option expr3 = this.sparkAdapter().translateFilter(functions$.MODULE$.expr("not region='reg2' or not id = 1").expr(), this.sparkAdapter().translateFilter$default$2());
        this.checkCondition((Option<Filter>)expr3, (Set<String>)dataColsWithNoPartitionCols, None$.MODULE$);
        Option expr4 = this.sparkAdapter().translateFilter(functions$.MODULE$.expr("not region='reg2' and not id = 1").expr(), this.sparkAdapter().translateFilter$default$2());
        Option expectedExpr4 = this.sparkAdapter().translateFilter(functions$.MODULE$.expr("not(id=1)").expr(), this.sparkAdapter().translateFilter$default$2());
        this.checkCondition((Option<Filter>)expr4, (Set<String>)dataColsWithNoPartitionCols, expectedExpr4);
    }

    public TestHoodieDataSourceHelper() {
        SparkAdapterSupport.$init$((SparkAdapterSupport)this);
    }
}

