/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.NumRowGroupsAcc;
import org.apache.hudi.ScalaAssertionSupport;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.testutils.HoodieSparkClientTestBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.util.AccumulatorV2;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001=3A\u0001B\u0003\u0001\u0019!)q\u0003\u0001C\u00011!)!\u0004\u0001C\u00017!)!\n\u0001C\u0001\u0017\naB+Z:u\u0011>|G-[3QCJ\fX/\u001a;CY>|WNR5mi\u0016\u0014(B\u0001\u0004\b\u0003\u0011AW\u000fZ5\u000b\u0005!I\u0011AB1qC\u000eDWMC\u0001\u000b\u0003\ry'oZ\u0002\u0001'\r\u0001Qb\u0005\t\u0003\u001dEi\u0011a\u0004\u0006\u0003!\u0015\t\u0011\u0002^3tiV$\u0018\u000e\\:\n\u0005Iy!!\u0007%p_\u0012LWm\u00159be.\u001cE.[3oiR+7\u000f\u001e\"bg\u0016\u0004\"\u0001F\u000b\u000e\u0003\u0015I!AF\u0003\u0003+M\u001b\u0017\r\\1BgN,'\u000f^5p]N+\b\u000f]8si\u00061A(\u001b8jiz\"\u0012!\u0007\t\u0003)\u0001\tq\u0002^3ti\ncwn\\7GS2$XM\u001d\u000b\u00039\t\u0002\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011A!\u00168ji\")1E\u0001a\u0001I\u0005Iq\u000e]3sCRLwN\u001c\t\u0003K)j\u0011A\n\u0006\u0003O!\nQ!\\8eK2T!!K\u0003\u0002\r\r|W.\\8o\u0013\tYcE\u0001\nXe&$Xm\u00149fe\u0006$\u0018n\u001c8UsB,\u0007F\u0002\u0002.siZD\b\u0005\u0002/o5\tqF\u0003\u00021c\u0005A\u0001O]8wS\u0012,'O\u0003\u00023g\u00051\u0001/\u0019:b[NT!\u0001N\u001b\u0002\u000f),\b/\u001b;fe*\u0011a'C\u0001\u0006UVt\u0017\u000e^\u0005\u0003q=\u0012!\"\u00128v[N{WO]2f\u0003\u00151\u0018\r\\;fG\u0005!\u0013!\u00028b[\u0016\u001cH\u0006B\u001f@\u0003\u000e\u000b\u0013AP\u0001\f\u0005Vc5jX%O'\u0016\u0013F+I\u0001A\u0003\u0019IejU#S)\u0006\n!)\u0001\u0004V!N+%\u000bV\u0011\u0002\t\u0006\u0001\u0012JT*F%R{vJV#S/JKE+\u0012\u0015\u0003\u0005\u0019\u0003\"a\u0012%\u000e\u0003EJ!!S\u0019\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/A\u0010dkJ\u0014XM\u001c;Ta\u0006\u00148nU;qa>\u0014H\u000fU1scV,GO\u00117p_6$\u0012\u0001\u0014\t\u0003;5K!A\u0014\u0010\u0003\u000f\t{w\u000e\\3b]\u0002")
public class TestHoodieParquetBloomFilter
extends HoodieSparkClientTestBase
implements ScalaAssertionSupport {
    @Override
    public <T extends Throwable, R> T assertThrows(Class<T> expectedExceptionClass, Function0<R> f) {
        return (T)ScalaAssertionSupport.assertThrows$(this, expectedExceptionClass, f);
    }

    @ParameterizedTest
    @EnumSource(value=WriteOperationType.class, names={"BULK_INSERT", "INSERT", "UPSERT", "INSERT_OVERWRITE"})
    public void testBloomFilter(WriteOperationType operation) {
        this.jsc.hadoopConfiguration().set("parquet.bloom.filter.enabled#bloom_col", "true");
        this.jsc.hadoopConfiguration().set("parquet.bloom.filter.expected.ndv#bloom_col", "2");
        this.sparkSession.sql("set parquet.filter.columnindex.enabled=false");
        this.sparkSession.sql("set parquet.filter.stats.enabled=false");
        String basePath = ((Object)Files.createTempDirectory("hoodie_bloom_source_path", new FileAttribute[0]).toAbsolutePath()).toString();
        scala.collection.immutable.Map opts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_bloom"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)HoodieTableType.COPY_ON_WRITE.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()), (Object)operation.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition")}));
        Dataset inputDF = this.sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString("select '0' as _row_key, '1' as bloom_col, '2' as partition, '3' as ts\n        |union\n        |select '1', '2', '3', '4'\n        |")).stripMargin());
        inputDF.write().format("hudi").options((Map)opts).mode(SaveMode.Overwrite).save(basePath);
        NumRowGroupsAcc accu = new NumRowGroupsAcc();
        this.sparkSession.sparkContext().register((AccumulatorV2)accu);
        this.sparkSession.read().format("hudi").load(basePath).filter("bloom_col = '3'").foreachPartition((Function1 & Serializable & scala.Serializable)it -> {
            it.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                accu$1.add(Predef$.MODULE$.int2Integer(0));
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)(this.currentSparkSupportParquetBloom() ? 0 : 1), (Integer)accu.value());
        this.sparkSession.read().format("hudi").load(basePath).filter("bloom_col = '2'").foreachPartition((Function1 & Serializable & scala.Serializable)it -> {
            it.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                accu$1.add(Predef$.MODULE$.int2Integer(0));
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)1, (Integer)accu.value());
    }

    public boolean currentSparkSupportParquetBloom() {
        return Predef$.MODULE$.Integer2int(Integer.valueOf(this.sparkSession.version().charAt(0))) >= 3;
    }

    public TestHoodieParquetBloomFilter() {
        ScalaAssertionSupport.$init$(this);
    }
}

