/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieSparkSqlWriter$;
import org.apache.hudi.HoodieSparkSqlWriterInternal$;
import org.apache.hudi.HoodieSparkWriterTestBase;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.PartitionStatsIndexSupport;
import org.apache.hudi.PartitionStatsIndexSupport$;
import org.apache.hudi.TestHoodieSparkSqlWriter$;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieBootstrapConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.SchemaCompatibilityException;
import org.apache.hudi.execution.bulkinsert.BulkInsertSortMode;
import org.apache.hudi.functional.TestBootstrap;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.testutils.DataSourceTestUtils;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hudi.command.SqlKeyGenerator;
import org.apache.spark.sql.hudi.command.SqlKeyGenerator$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import org.scalatest.package$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tmh\u0001B\u001b7\u0001uBQA\u0011\u0001\u0005\u0002\rCQ!\u0012\u0001\u0005\u0002\u0019CqA\u0018\u0001\u0012\u0002\u0013\u0005q\fC\u0004k\u0001E\u0005I\u0011A0\t\u000b-\u0004A\u0011\u00017\t\u000ba\u0004A\u0011\u00017\t\u000bi\u0004A\u0011\u00017\t\u000bq\u0004A\u0011\u00017\t\u000by\u0004A\u0011\u00017\t\r\u0005\u0005\u0001\u0001\"\u0001m\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000fAa!a\u000b\u0001\t\u0003a\u0007bBA\u0018\u0001\u0011\u0005\u0011\u0011\u0007\u0005\u0007\u0003\u000f\u0002A\u0011\u00017\t\r\u0005-\u0003\u0001\"\u0001m\u0011\u0019\ty\u0005\u0001C\u0001Y\"1\u00111\u000b\u0001\u0005\u00021Da!a\u0016\u0001\t\u0003a\u0007BBA.\u0001\u0011\u0005A\u000eC\u0004\u0002`\u0001!\t!!\u0019\t\u000f\u0005M\u0005\u0001\"\u0001\u0002\u0016\"9\u0011Q\u0016\u0001\u0005\u0002\u0005=\u0006bBAc\u0001\u0011\u0005\u0011q\u0019\u0005\u0007\u0003S\u0004A\u0011\u00017\t\u000f\u00055\b\u0001\"\u0001\u0002p\"9!Q\u0004\u0001\u0005\u0002\t}\u0001b\u0002B\u0016\u0001\u0011%!Q\u0006\u0005\n\u0005o\u0001\u0011\u0013!C\u0005\u0005sA\u0001B!\u0010\u0001#\u0003%Ia\u0018\u0005\b\u0005\u007f\u0001A\u0011\u0001B!\u0011\u0019\u0011)\u0007\u0001C\u0001Y\"9!\u0011\u000e\u0001\u0005\u0002\t-\u0004B\u0002BC\u0001\u0011\u0005A\u000eC\u0004\u0003\n\u0002!\tAa#\t\r\tM\u0005\u0001\"\u0001m\u0011\u0019\u00119\n\u0001C\u0001Y\"1!1\u0014\u0001\u0005\u00021DaAa(\u0001\t\u0003a\u0007B\u0002BR\u0001\u0011\u0005A\u000e\u0003\u0004\u0003(\u0002!\t\u0001\u001c\u0005\u0007\u0005W\u0003A\u0011\u00017\t\r\t=\u0006\u0001\"\u0001m\u0011\u0019\u0011\u0019\f\u0001C\u0001Y\"1!q\u0017\u0001\u0005\u00021DaAa/\u0001\t\u0003a\u0007b\u0002B`\u0001\u0011%!\u0011Y\u0004\b\u0005\u001f4\u0004\u0012\u0001Bi\r\u0019)d\u0007#\u0001\u0003T\"1!\t\rC\u0001\u00057Dq!a$1\t\u0003\u0011i\u000eC\u0004\u0003bA\"\tA!?\t\u000f\u0005%\u0006\u0007\"\u0001\u0003z\nAB+Z:u\u0011>|G-[3Ta\u0006\u00148nU9m/JLG/\u001a:\u000b\u0005]B\u0014\u0001\u00025vI&T!!\u000f\u001e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0014aA8sO\u000e\u00011C\u0001\u0001?!\ty\u0004)D\u00017\u0013\t\teGA\rI_>$\u0017.Z*qCJ\\wK]5uKJ$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001E!\ty\u0004!\u0001\u000euKN$()\u001e7l\u0013:\u001cXM\u001d;XSRD7k\u001c:u\u001b>$W\r\u0006\u0003H\u001b^c\u0006C\u0001%L\u001b\u0005I%\"\u0001&\u0002\u000bM\u001c\u0017\r\\1\n\u00051K%\u0001B+oSRDQA\u0014\u0002A\u0002=\u000b\u0001b]8si6{G-\u001a\t\u0003!Vk\u0011!\u0015\u0006\u0003%N\u000b!BY;mW&t7/\u001a:u\u0015\t!f'A\u0005fq\u0016\u001cW\u000f^5p]&\u0011a+\u0015\u0002\u0013\u0005Vd7.\u00138tKJ$8k\u001c:u\u001b>$W\rC\u0004Y\u0005A\u0005\t\u0019A-\u0002%A|\u0007/\u001e7bi\u0016lU\r^1GS\u0016dGm\u001d\t\u0003\u0011jK!aW%\u0003\u000f\t{w\u000e\\3b]\"9QL\u0001I\u0001\u0002\u0004I\u0016\u0001E3oC\ndWmT\"D\u0007>tg-[4t\u0003\u0011\"Xm\u001d;Ck2\\\u0017J\\:feR<\u0016\u000e\u001e5T_J$Xj\u001c3fI\u0011,g-Y;mi\u0012\u0012T#\u00011+\u0005e\u000b7&\u00012\u0011\u0005\rDW\"\u00013\u000b\u0005\u00154\u0017!C;oG\",7m[3e\u0015\t9\u0017*\u0001\u0006b]:|G/\u0019;j_:L!!\u001b3\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0013uKN$()\u001e7l\u0013:\u001cXM\u001d;XSRD7k\u001c:u\u001b>$W\r\n3fM\u0006,H\u000e\u001e\u00134\u0003}!Xm\u001d;QCJ\fW.\u001a;feN<\u0016\u000e\u001e5Xe&$X\rR3gCVdGo\u001d\u000b\u0002\u000f\"\u0012QA\u001c\t\u0003_Zl\u0011\u0001\u001d\u0006\u0003cJ\f1!\u00199j\u0015\t\u0019H/A\u0004kkBLG/\u001a:\u000b\u0005UT\u0014!\u00026v]&$\u0018BA<q\u0005\u0011!Vm\u001d;\u0002GQ,7\u000f\u001e+ie><X\t_2faRLwN\\%om\u0006d\u0017\u000eZ*fe&\fG.\u001b>fe\"\u0012aA\\\u00012i\u0016\u001cH\u000f\u00165s_^,\u0005pY3qi&|g.\u00117sK\u0006$\u00170\u0012=jgR\u001cx+\u001b;i\u0003B\u0004XM\u001c3TCZ,Wj\u001c3fQ\t9a.\u0001\u0017uKN$h+\u00197jI\u0006$X\rV1cY\u0016\u001cuN\u001c4jO^KG\u000f[(wKJ<(/\u001b;f'\u00064X-T8eK\"\u0012\u0001B\\\u0001\u0018i\u0016\u001cHo\u00115b]\u001e,\u0007+\u0019:uSRLwN\u001c)bi\"D#!\u00038\u00027Q,7\u000f^\"iC:<Wm\u0016:ji\u0016$\u0016M\u00197f-\u0016\u00148/[8oQ\tQa.A\ruKN$()\u001e7l\u0013:\u001cXM\u001d;G_J\u001cvN\u001d;N_\u0012,GcA$\u0002\n!)aj\u0003a\u0001\u001f\":1\"!\u0004\u0002\u001e\u0005}\u0001\u0003BA\b\u00033i!!!\u0005\u000b\t\u0005M\u0011QC\u0001\taJ|g/\u001b3fe*\u0019\u0011q\u0003:\u0002\rA\f'/Y7t\u0013\u0011\tY\"!\u0005\u0003\u0015\u0015sW/\\*pkJ\u001cW-A\u0003wC2,XmI\u0001PQ\rY\u00111\u0005\t\u0005\u0003K\t9#\u0004\u0002\u0002\u0016%!\u0011\u0011FA\u000b\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001!i\u0016\u001cHOQ;mW&s7/\u001a:u\r>\u00148k\u001c:u\u001b>$WmV5uQ>\u001b5\t\u000b\u0002\r]\u0006\u0019C/Z:u\u0005Vd7.\u00138tKJ$hi\u001c:Q_B,H.\u0019;f\u001b\u0016$\u0018MR5fY\u0012\u001cHcA$\u00024!)\u0001,\u0004a\u00013\":Q\"a\u000e\u0002>\u0005}\u0002\u0003BA\b\u0003sIA!a\u000f\u0002\u0012\tYa+\u00197vKN{WO]2f\u0003!\u0011wn\u001c7fC:\u001cH\u0006BA!\u0003\u0007J\u0012!A\r\u0002\u0001!\u001aQ\"a\t\u0002IQ,7\u000f\u001e\"vY.Len]3si\u001a{'\u000f\u0012:paB\u000b'\u000f^5uS>t7i\u001c7v[:D#A\u00048\u0002=Q,7\u000f\u001e#jg\u0006\u0014G.Z!oI\u0016s\u0017M\u00197f\u001b\u0016$\u0018MR5fY\u0012\u001c\bFA\bo\u0003\t\"Xm\u001d;Ee>\u0004H)\u001e9mS\u000e\fG/Z:S_^4uN\u001d\"vY.Len]3si\"\u0012\u0001C\\\u0001(i\u0016\u001cH/\u00138tKJ$H)\u0019;bg\u0016$x+\u001b;i_V$\bK]3d_6\u0014\u0017N\\3GS\u0016dG\r\u000b\u0002\u0012]\u00061C/Z:u\u0013:\u001cXM\u001d;ECR\f7/\u001a;XSRDw.\u001e;QCJ$\u0018\u000e^5p]\u001aKW\r\u001c3)\u0005Iq\u0017!\u000e;fgR\u0014U\u000f\\6J]N,'\u000f\u001e#bi\u0006\u001cX\r^,ji\"$\u0015\r^1t_V\u00148-Z%na2lU\u000f\u001c;ja2,'k\\;oIND#a\u00058\u0002eQ,7\u000f\u001e#bi\u0006\u001cx.\u001e:dK&s7/\u001a:u\r>\u0014H+\u00192mKRK\b/\u001a\"bg\u00164\u0015\u000e\\3NKR\fg)[3mIN$raRA2\u0003{\ny\bC\u0004\u0002fQ\u0001\r!a\u001a\u0002\u0013Q\f'\r\\3UsB,\u0007\u0003BA5\u0003orA!a\u001b\u0002tA\u0019\u0011QN%\u000e\u0005\u0005=$bAA9y\u00051AH]8pizJ1!!\u001eJ\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011PA>\u0005\u0019\u0019FO]5oO*\u0019\u0011QO%\t\u000ba#\u0002\u0019A-\t\u000f\u0005\u0005E\u00031\u0001\u0002h\u0005q!-Y:f\r&dWMR8s[\u0006$\bf\u0002\u000b\u0002\u0006\u0006u\u00111\u0012\t\u0005\u0003\u001f\t9)\u0003\u0003\u0002\n\u0006E!\u0001D'fi\"|GmU8ve\u000e,GFAAGC\t\ty)\u0001\u000buKN$H)\u0019;bg>,(oY3J]N,'\u000f\u001e\u0015\u0004)\u0005\r\u0012a\n;fgR<\u0016\u000e\u001e5ECR\f7o\\;sG\u0016\u0014un\u001c;tiJ\f\u0007OR8s)\u0006\u0014G.\u001a+za\u0016$RaRAL\u00033Cq!!\u001a\u0016\u0001\u0004\t9\u0007C\u0004\u0002\u001cV\u0001\r!!(\u0002\u0019Q\f'\r\\3WKJ\u001c\u0018n\u001c8\u0011\u0007!\u000by*C\u0002\u0002\"&\u00131!\u00138uQ\u001d)\u0012QQA\u000f\u0003Kc#!a*\"\u0005\u0005%\u0016a\u00052p_R\u001cHO]1q)\u0016\u001cH\u000fU1sC6\u001c\bfA\u000b\u0002$\u0005\u0001\u0013N\\5uS\u0006d\u0017N_3NKR\f7\t\\5f]R4uN\u001d\"p_R\u001cHO]1q)%9\u0015\u0011WA^\u0003{\u000b\t\rC\u0004\u00024Z\u0001\r!!.\u0002\u001d\u0019|w\u000eV1cY\u0016\u0004\u0016M]1ngBA\u0011\u0011NA\\\u0003O\n9'\u0003\u0003\u0002:\u0006m$aA'ba\"9\u0011Q\r\fA\u0002\u0005\u001d\u0004BBA`-\u0001\u0007\u0011,\u0001\tbI\u0012\u0014un\u001c;tiJ\f\u0007\u000fU1uQ\"1\u00111\u0019\fA\u0002e\u000bA\"\u001b8ji\n\u000b7/\u001a)bi\"\fq\u0004^3tiN\u001b\u0007.Z7b\u000bZ|G.\u001e;j_:4uN\u001d+bE2,G+\u001f9f)\u00159\u0015\u0011ZAf\u0011\u001d\t)g\u0006a\u0001\u0003OBq!a'\u0018\u0001\u0004\ti\nK\u0004\u0018\u0003\u001f\fi\"!6\u0011\t\u0005=\u0011\u0011[\u0005\u0005\u0003'\f\tBA\u0005DgZ\u001cv.\u001e:dK2B\u0011q[An\u0003?\f\u0019/\t\u0002\u0002Z\u0006y1i\u0014)Z?>sul\u0016*J)\u0016cc'\t\u0002\u0002^\u0006y1i\u0014)Z?>sul\u0016*J)\u0016c\u0003(\t\u0002\u0002b\u0006yQ*\u0012*H\u000b~{ej\u0018*F\u0003\u0012cc'\t\u0002\u0002f\u0006yQ*\u0012*H\u000b~{ej\u0018*F\u0003\u0012c\u0003\bK\u0002\u0018\u0003G\t!\u0005^3ti&s7M]3nK:$\u0018\r\u001c,jK^<\u0016\u000e\u001e5SKBd\u0017mY3nK:$\bF\u0001\ro\u0003Q!W\r\\3uKB\u000b'\u000f^5uS>t7+\u001a;vaR\u0011\u0011\u0011\u001f\t\b\u0011\u0006M\u0018q_A[\u0013\r\t)0\u0013\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005e(q\u0003\b\u0005\u0003w\u0014\tB\u0004\u0003\u0002~\n-a\u0002BA\u0000\u0005\u000fqAA!\u0001\u0003\u00069!\u0011Q\u000eB\u0002\u0013\u0005Y\u0014BA\u001d;\u0013\r\u0011I\u0001O\u0001\u0006gB\f'o[\u0005\u0005\u0005\u001b\u0011y!A\u0002tc2T1A!\u00039\u0013\u0011\u0011\u0019B!\u0006\u0002\u000fA\f7m[1hK*!!Q\u0002B\b\u0013\u0011\u0011IBa\u0007\u0003\u0013\u0011\u000bG/\u0019$sC6,'\u0002\u0002B\n\u0005+\ta\u0003^3ti\u0012+G.\u001a;f!\u0006\u0014H/\u001b;j_:\u001chK\r\u000b\u0004\u000f\n\u0005\u0002B\u0002B\u00125\u0001\u0007\u0011,A\u000evg\u0016\u0004\u0016M\u001d;ji&|gn\u001d+p\t\u0016dW\r^3D_:4\u0017n\u001a\u0015\b5\u0005]\u0012Q\bB\u0014Y\u0011\t\t%a\u0011)\u0007i\t\u0019#A\u000fwC2LG-\u0019;f\t\u0006$\u0018-\u00118e!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;t)\u00159%q\u0006B\u001a\u0011%\u0011\td\u0007I\u0001\u0002\u0004\t90A\u0004j]B,H\u000f\u00124\t\u0011\tU2\u0004%AA\u0002e\u000b\u0011#[:EK2,G/\u001a)beRLG/[8o\u0003\u001d2\u0018\r\\5eCR,G)\u0019;b\u0003:$\u0007+\u0019:uSRLwN\\*uCR\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tm\"fAA|C\u00069c/\u00197jI\u0006$X\rR1uC\u0006sG\rU1si&$\u0018n\u001c8Ti\u0006$8\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003\u0001\"Xm\u001d;EK2,G/\u001a)beRLG/[8og^KG\u000f[,jY\u0012\u001c\u0017M\u001d3\u0015\u000b\u001d\u0013\u0019Ea\u0012\t\u000f\t\u0015c\u00041\u0001\u0002h\u0005I\u0001/\u0019:uSRLwN\u001c\u0005\b\u0005\u0013r\u0002\u0019\u0001B&\u0003I)\u0007\u0010]3di\u0016$\u0007+\u0019:uSRLwN\\:\u0011\r\t5#QKA4\u001d\u0011\u0011yEa\u0015\u000f\t\u00055$\u0011K\u0005\u0002\u0015&\u0019!1C%\n\t\t]#\u0011\f\u0002\u0004'\u0016\f(b\u0001B\n\u0013\":a$!\"\u0002\u001e\tuCF\u0001B0C\t\u0011\t'\u0001\u0012eK2,G/\u001a)beRLG/[8og^KG\u000eZ2be\u0012$Vm\u001d;QCJ\fWn\u001d\u0015\u0004=\u0005\r\u0012A\n;fgR$U\r\\3uKB\u000b'\u000f^5uS>t7oV5uQ^\u0013xN\\4QCJ$\u0018\u000e^5p]\"\u0012qD\\\u0001*i\u0016\u001cHOT8o!\u0006\u0014H/\u001b;j_:$\u0016M\u00197f/&$\b.T3uCR\f'\r\\3TkB\u0004xN\u001d;\u0015\u0007\u001d\u0013i\u0007C\u0004\u0002f\u0001\u0002\rAa\u001c\u0011\t\tE$1P\u0007\u0003\u0005gRAA!\u001e\u0003x\u0005)Qn\u001c3fY*\u0019!\u0011\u0010\u001c\u0002\r\r|W.\\8o\u0013\u0011\u0011iHa\u001d\u0003\u001f!{w\u000eZ5f)\u0006\u0014G.\u001a+za\u0016Ds\u0001IA\u0007\u0003;\u0011\ti\t\u0002\u0003p!\u001a\u0001%a\t\u0002}Q,7\u000f^+qg\u0016\u0014HoV5uQ>,H\u000f\u0015:fG>l'-\u001b8f\r&,G\u000eZ!oI\u000e{WNY5oK\n+gm\u001c:f+B\u001cXM\u001d;ESN\f'\r\\3eQ\t\tc.A\u0015uKN$X\u000b]:feR<\u0016\u000e\u001e5D_6\u0014\u0017N\\3CK\u001a|'/Z+qg\u0016\u0014H\u000fR5tC\ndW\r\u001a\u000b\u0004\u000f\n5\u0005bBA3E\u0001\u0007!q\u000e\u0015\bE\u00055\u0011Q\u0004BAQ\r\u0011\u00131E\u00018i\u0016\u001cH\u000fV8Xe&$XmV5uQ>,H\u000fU1sC6,G/\u001a:t\u0013:\u001cG.\u001e3fI&s\u0007j\\8eS\u0016$\u0016M\u00197f\u0007>tg-[4)\u0005\rr\u0017!\n;fgRtuN\u001c9beRLGo\u001c8fI^KG\u000f\u001b*fkN,G+\u00192mK\u000e{gNZ5hQ\t!c.\u0001\u0011uKN$H)\u001a4bk2$8*Z=HK:$vNT8oa\u0006\u0014H/\u001b;p]\u0016$\u0007FA\u0013o\u0003i!Xm\u001d;O_.+\u0017pR3o)>\u001c\u0016.\u001c9mK.+\u0017pR3oQ\t1c.\u0001\u000euKN$8+[7qY\u0016\\U-_$f]R{gj\\&fs\u001e+g\u000e\u000b\u0002(]\u0006IB/Z:u\u000f\u0016$xJ]5hS:\\U-_$f]\u0016\u0014\u0018\r^8sQ\tAc.\u0001\ruKN$8iT,D_:\u001c\u0018n\u001d;f]RD\u0015m\u001d5j]\u001eD#!\u000b8\u0002EQ,7\u000f^*i_VdG\r\u0012:pa\u0012+\b\u000f\\5dCR,7OR8s\u0013:\u001cXM\u001d;tQ\tQc.A\u0011uKN$8\u000b[8vY\u00124\u0015-\u001b7XQ\u0016tG)\u001e9mS\u000e\fG/Z:G_VtG\r\u000b\u0002,]\u0006YB/Z:u\u0013N$U\rZ;qY&\u001c\u0017\r^5p]J+\u0017/^5sK\u0012D#\u0001\f8\u00023Q,7\u000f^%t\t\u0016$W\u000f\u001d7jG\u0006$\u0018n\u001c8OK\u0016$W\r\u001a\u0015\u0003[9\f\u0011CZ3uG\"\f5\r^;bYN\u001b\u0007.Z7b)\t\u0011\u0019\r\u0005\u0003\u0003F\n-WB\u0001Bd\u0015\r\u0011I\rO\u0001\u0005CZ\u0014x.\u0003\u0003\u0003N\n\u001d'AB*dQ\u0016l\u0017-\u0001\rUKN$\bj\\8eS\u0016\u001c\u0006/\u0019:l'FdwK]5uKJ\u0004\"a\u0010\u0019\u0014\u0007A\u0012)\u000eE\u0002I\u0005/L1A!7J\u0005\u0019\te.\u001f*fMR\u0011!\u0011[\u000b\u0003\u0005?\u0004bA!9\u0003p\nMXB\u0001Br\u0015\u0011\u0011)Oa:\u0002\rM$(/Z1n\u0015\u0011\u0011IOa;\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0005[\fAA[1wC&!!\u0011\u001fBr\u0005\u0019\u0019FO]3b[B!\u0011q\u0002B{\u0013\u0011\u001190!\u0005\u0003\u0013\u0005\u0013x-^7f]R\u001cHC\u0001Bp\u0001")
public class TestHoodieSparkSqlWriter
extends HoodieSparkWriterTestBase {
    public static Stream<Arguments> bootstrapTestParams() {
        return TestHoodieSparkSqlWriter$.MODULE$.bootstrapTestParams();
    }

    public static Stream<Arguments> deletePartitionsWildcardTestParams() {
        return TestHoodieSparkSqlWriter$.MODULE$.deletePartitionsWildcardTestParams();
    }

    public static Stream<Arguments> testDatasourceInsert() {
        return TestHoodieSparkSqlWriter$.MODULE$.testDatasourceInsert();
    }

    public void testBulkInsertWithSortMode(BulkInsertSortMode sortMode, boolean populateMetaFields, boolean enableOCCConfigs) {
        Dataset<Row> trimmedDf;
        scala.collection.immutable.Map fooTableModifier = this.commonTableModifier().updated((Object)"hoodie.bulkinsert.shuffle.parallelism", (Object)"4").updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).updated((Object)DataSourceWriteOptions$.MODULE$.ENABLE_ROW_WRITER().key(), (Object)"true").updated((Object)HoodieTableConfig.POPULATE_META_FIELDS.key(), (Object)String.valueOf(populateMetaFields)).updated((Object)HoodieWriteConfig.BULK_INSERT_SORT_MODE.key(), (Object)sortMode.name());
        if (enableOCCConfigs) {
            fooTableModifier = fooTableModifier.updated((Object)"hoodie.write.concurrency.mode", (Object)"optimistic_concurrency_control").updated((Object)"hoodie.clean.failed.writes.policy", (Object)"LAZY").updated((Object)"hoodie.write.lock.provider", (Object)"org.apache.hudi.client.transaction.lock.InProcessLockProvider");
        }
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        java.util.List<Row> inserts = DataSourceTestUtils.generateRandomRows(1000);
        Dataset toUpdateDataset = this.sqlContext().createDataFrame(DataSourceTestUtils.getUniqueRows(inserts, 40), structType);
        java.util.List<Row> updates = DataSourceTestUtils.updateRowsWithUpdatedTs((Dataset<Row>)toUpdateDataset);
        Buffer records = (Buffer)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(inserts).asScala()).union((GenSeq)JavaConverters$.MODULE$.asScalaBufferConverter(updates).asScala(), Buffer$.MODULE$.canBuildFrom());
        Seq<Row> recordsSeq = this.convertRowListToSeq((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(records).asJava());
        SparkContext qual$1 = this.sc();
        Seq<Row> x$1 = recordsSeq;
        int x$2 = qual$1.parallelize$default$2();
        Dataset df = this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), structType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, df, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
        Seq partitions = (Seq)new .colon.colon((Object)"2016/03/15", (List)new .colon.colon((Object)"2015/03/16", (List)new .colon.colon((Object)"2015/03/17", (List)Nil$.MODULE$)));
        String[] fullPartitionPaths = new String[3];
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fullPartitionPaths)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            fullPartitionPaths$1[i] = String.format("%s/%s/*", this.tempBasePath(), partitions.apply(i));
        });
        Dataset actualDf = this.sqlContext().read().parquet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{fullPartitionPaths[0], fullPartitionPaths[1], fullPartitionPaths[2]}));
        if (!populateMetaFields) {
            List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assertions.assertEquals((long)0L, (long)actualDf.select((String)HoodieRecord.HOODIE_META_COLUMNS.get(i), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)TestHoodieSparkSqlWriter.$anonfun$testBulkInsertWithSortMode$3(entry))).count()));
        }
        Predef$.MODULE$.assert(df.except(trimmedDf = this.dropMetaFields((Dataset<Row>)actualDf)).count() == 0L);
    }

    public boolean testBulkInsertWithSortMode$default$2() {
        return true;
    }

    public boolean testBulkInsertWithSortMode$default$3() {
        return false;
    }

    @Test
    public void testParametersWithWriteDefaults() {
        scala.collection.immutable.Map originals = HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults(Predef$.MODULE$.Map().empty());
        String rhsKey = "hoodie.right.hand.side.key";
        String rhsVal = "hoodie.right.hand.side.val";
        scala.collection.immutable.Map modifier = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()), (Object)DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rhsKey), (Object)rhsVal)}));
        scala.collection.immutable.Map modified = HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults(modifier);
        Function2 & Serializable & scala.Serializable matcher = (Function2 & Serializable & scala.Serializable)(k, v) -> package$.MODULE$.Matchers().convertToAnyShouldWrapper(modified.apply(k), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128), Prettifier$.MODULE$.default()).should(package$.MODULE$.Matchers().be().apply(v));
        originals.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string;
            String string2;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null && "hoodie.datasource.write.operation".equals(string2 = (String)tuple2._1())) {
                return (Assertion)matcher.apply((Object)"hoodie.datasource.write.operation", (Object)DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL());
            }
            if (tuple2 != null && "hoodie.datasource.write.table.type".equals(string = (String)tuple2._1())) {
                return (Assertion)matcher.apply((Object)"hoodie.datasource.write.table.type", (Object)DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL());
            }
            if (tuple2 != null) {
                String string3 = (String)tuple2._1();
                String string4 = rhsKey;
                String string5 = string3;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    return (Assertion)matcher.apply((Object)rhsKey, (Object)rhsVal);
                }
            }
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return (Assertion)matcher.apply((Object)k, (Object)v);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    @Test
    public void testThrowExceptionInvalidSerializer() {
        this.spark().stop();
        SparkSession session = SparkSession$.MODULE$.builder().config(HoodieClientTestUtils.getSparkConfForTest((String)"hoodie_test").remove("spark.serializer")).getOrCreate();
        try {
            SQLContext sqlContext = session.sqlContext();
            scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)new StringBuilder(45).append(this.tempPath().toUri().toString()).append("/testThrowExceptionInvalidSerializer/basePath").toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test_tbl")}));
            HoodieException e = (HoodieException)package$.MODULE$.Matchers().intercept((Function0 & Serializable & scala.Serializable)() -> HoodieSparkSqlWriter$.MODULE$.write(sqlContext, SaveMode.ErrorIfExists, options, session.emptyDataFrame(), HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6()), ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            Predef$.MODULE$.assert(e.getMessage().contains("spark.serializer"));
        }
        finally {
            session.stop();
            this.initSparkContext();
        }
    }

    @Test
    public void testThrowExceptionAlreadyExistsWithAppendSaveMode() {
        scala.collection.immutable.Map fooTableModifier = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.tempBasePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)this.hoodieFooTableName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.write.recordkey.field"), (Object)"uuid"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4")}));
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.TestHoodieSparkSqlWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.HoodieSparkWriterTestBase"), "StringLongTest"), (List)Nil$.MODULE$);
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator1$1(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset dataFrame = this.spark().createDataFrame((Seq)new .colon.colon((Object)new HoodieSparkWriterTestBase.StringLongTest(this, UUID.randomUUID().toString(), new Date().getTime()), (List)Nil$.MODULE$), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator1$1(null)));
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, dataFrame, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
        scala.collection.immutable.Map barTableModifier = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.tempBasePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_bar_tbl"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.write.recordkey.field"), (Object)"uuid"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4")}));
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.TestHoodieSparkSqlWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.HoodieSparkWriterTestBase"), "StringLongTest"), (List)Nil$.MODULE$);
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator2$1(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset dataFrame2 = this.spark().createDataFrame((Seq)new .colon.colon((Object)new HoodieSparkWriterTestBase.StringLongTest(this, UUID.randomUUID().toString(), new Date().getTime()), (List)Nil$.MODULE$), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator2$1(null)));
        HoodieException tableAlreadyExistException = (HoodieException)package$.MODULE$.Matchers().intercept((Function0 & Serializable & scala.Serializable)() -> HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, barTableModifier, dataFrame2, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6()), ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
        Predef$.MODULE$.assert(tableAlreadyExistException.getMessage().contains("Config conflict"));
        Predef$.MODULE$.assert(tableAlreadyExistException.getMessage().contains(new StringBuilder(31).append(HoodieWriteConfig.TBL_NAME.key()).append(":\thoodie_bar_tbl\thoodie_foo_tbl").toString()));
        scala.collection.immutable.Map deleteTableModifier = barTableModifier.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()), (Object)"delete")})));
        HoodieException deleteCmdException = (HoodieException)package$.MODULE$.Matchers().intercept((Function0 & Serializable & scala.Serializable)() -> HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, deleteTableModifier, dataFrame2, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6()), ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        Predef$.MODULE$.assert(tableAlreadyExistException.getMessage().contains("Config conflict"));
        Predef$.MODULE$.assert(tableAlreadyExistException.getMessage().contains(new StringBuilder(31).append(HoodieWriteConfig.TBL_NAME.key()).append(":\thoodie_bar_tbl\thoodie_foo_tbl").toString()));
    }

    @Test
    public void testValidateTableConfigWithOverwriteSaveMode() {
        scala.collection.immutable.Map tableModifier1 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.tempBasePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)this.hoodieFooTableName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.write.recordkey.field"), (Object)"uuid")}));
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.TestHoodieSparkSqlWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.HoodieSparkWriterTestBase"), "StringLongTest"), (List)Nil$.MODULE$);
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator1$2(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset dataFrame = this.spark().createDataFrame((Seq)new .colon.colon((Object)new HoodieSparkWriterTestBase.StringLongTest(this, UUID.randomUUID().toString(), new Date().getTime()), (List)Nil$.MODULE$), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator1$2(null)));
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Overwrite, tableModifier1, dataFrame, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
        scala.collection.immutable.Map tableModifier2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.tempBasePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)this.hoodieFooTableName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.write.recordkey.field"), (Object)"ts")}));
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator2$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.TestHoodieSparkSqlWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.HoodieSparkWriterTestBase"), "StringLongTest"), (List)Nil$.MODULE$);
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator2$2(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset dataFrame2 = this.spark().createDataFrame((Seq)new .colon.colon((Object)new HoodieSparkWriterTestBase.StringLongTest(this, UUID.randomUUID().toString(), new Date().getTime()), (List)Nil$.MODULE$), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator2$2(null)));
        HoodieException hoodieException = (HoodieException)package$.MODULE$.Matchers().intercept((Function0 & Serializable & scala.Serializable)() -> HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, tableModifier2, dataFrame2, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6()), ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        Predef$.MODULE$.assert(hoodieException.getMessage().contains("Config conflict"));
        Predef$.MODULE$.assert(hoodieException.getMessage().contains("RecordKey:\tts\tuuid"));
        Predef$.MODULE$.assert(BoxesRunTime.unboxToBoolean((Object)HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Overwrite, tableModifier2, dataFrame2, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6())._1()));
    }

    @Test
    public void testChangePartitionPath() {
        scala.collection.immutable.Map tableModifier1 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.tempBasePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)this.hoodieFooTableName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.write.recordkey.field"), (Object)"uuid"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.write.partitionpath.field"), (Object)"ts")}));
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator1$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.TestHoodieSparkSqlWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.HoodieSparkWriterTestBase"), "StringLongTest"), (List)Nil$.MODULE$);
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator1$3(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset dataFrame = this.spark().createDataFrame((Seq)new .colon.colon((Object)new HoodieSparkWriterTestBase.StringLongTest(this, UUID.randomUUID().toString(), new Date().getTime()), (List)Nil$.MODULE$), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator1$3(null)));
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Overwrite, tableModifier1, dataFrame, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
        scala.collection.immutable.Map tableModifier2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.tempBasePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)this.hoodieFooTableName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.write.recordkey.field"), (Object)"uuid"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.write.partitionpath.field"), (Object)"uuid")}));
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator2$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.TestHoodieSparkSqlWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.HoodieSparkWriterTestBase"), "StringLongTest"), (List)Nil$.MODULE$);
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator2$3(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset dataFrame2 = this.spark().createDataFrame((Seq)new .colon.colon((Object)new HoodieSparkWriterTestBase.StringLongTest(this, UUID.randomUUID().toString(), new Date().getTime()), (List)Nil$.MODULE$), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator2$3(null)));
        HoodieException hoodieException = (HoodieException)package$.MODULE$.Matchers().intercept((Function0 & Serializable & scala.Serializable)() -> HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, tableModifier2, dataFrame2, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6()), ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
        Predef$.MODULE$.assert(hoodieException.getMessage().contains("Config conflict"));
        Predef$.MODULE$.assert(hoodieException.getMessage().contains("PartitionPath:\tuuid\tts"));
        Predef$.MODULE$.assert(BoxesRunTime.unboxToBoolean((Object)HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Overwrite, tableModifier2, dataFrame2, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6())._1()));
    }

    @Test
    public void testChangeWriteTableVersion() {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6, 8}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)tableVersion -> {
            String tempPath = new StringBuilder(1).append(this.tempBasePath()).append("/").append(tableVersion).toString();
            scala.collection.immutable.Map tableModifier1 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)tempPath), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)this.hoodieFooTableName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.write.table.version"), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)tableVersion))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.write.recordkey.field"), (Object)"uuid"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.write.partitionpath.field"), (Object)"ts")}));
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
            public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator1$4
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.TestHoodieSparkSqlWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.hudi.HoodieSparkWriterTestBase"), "StringLongTest"), (List)Nil$.MODULE$);
                }

                public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator1$4(TestHoodieSparkSqlWriter $outer) {
                }
            }
            Dataset dataFrame = this.spark().createDataFrame((Seq)new .colon.colon((Object)new HoodieSparkWriterTestBase.StringLongTest(this, UUID.randomUUID().toString(), new Date().getTime()), (List)Nil$.MODULE$), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator1$4(null)));
            HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Overwrite, tableModifier1, dataFrame, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(tempPath).setConf(HadoopFSUtils.getStorageConf((Configuration)this.spark().sessionState().newHadoopConf())).build();
            Assertions.assertEquals((int)metaClient.getTableConfig().getTableVersion().versionCode(), (int)tableVersion);
        });
    }

    @ParameterizedTest
    @EnumSource(value=BulkInsertSortMode.class)
    public void testBulkInsertForSortMode(BulkInsertSortMode sortMode) {
        this.testBulkInsertWithSortMode(sortMode, true, this.testBulkInsertWithSortMode$default$3());
    }

    @Test
    public void testBulkInsertForSortModeWithOCC() {
        this.testBulkInsertWithSortMode(BulkInsertSortMode.GLOBAL_SORT, true, true);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testBulkInsertForPopulateMetaFields(boolean populateMetaFields) {
        this.testBulkInsertWithSortMode(BulkInsertSortMode.NONE, populateMetaFields, this.testBulkInsertWithSortMode$default$3());
    }

    @Test
    public void testBulkInsertForDropPartitionColumn() {
        Seq columns = (Seq)new .colon.colon((Object)"ts", (List)new .colon.colon((Object)"uuid", (List)new .colon.colon((Object)"rider", (List)new .colon.colon((Object)"driver", (List)new .colon.colon((Object)"fare", (List)new .colon.colon((Object)"city", (List)Nil$.MODULE$))))));
        Seq data = (Seq)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToLong((long)1695159649087L), (Object)"334e26e9-8355-45cc-97c6-c31daf0df330", (Object)"rider-A", (Object)"driver-K", (Object)BoxesRunTime.boxToDouble((double)19.1), (Object)"san_francisco"), (List)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToLong((long)1695091554788L), (Object)"e96c4396-3fad-413a-a942-4cb36106d721", (Object)"rider-C", (Object)"driver-M", (Object)BoxesRunTime.boxToDouble((double)27.7), (Object)"san_francisco"), (List)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToLong((long)1695046462179L), (Object)"9909a8b1-2d15-4d3d-8ec9-efc48c536a00", (Object)"rider-D", (Object)"driver-L", (Object)BoxesRunTime.boxToDouble((double)33.9), (Object)"san_francisco"), (List)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToLong((long)1695516137016L), (Object)"e3cf430c-889d-4015-bc98-59bdce1e530c", (Object)"rider-F", (Object)"driver-P", (Object)BoxesRunTime.boxToDouble((double)34.15), (Object)"sao_paulo"), (List)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToLong((long)1695115999911L), (Object)"c8abbe79-8d89-47ea-b4ce-4d224bae5bfa", (Object)"rider-J", (Object)"driver-T", (Object)BoxesRunTime.boxToDouble((double)17.85), (Object)"chennai"), (List)Nil$.MODULE$)))));
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator1$5
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple6"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)))))));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator1$5(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset inserts = this.spark().createDataFrame(data, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator1$5(null))).toDF(columns);
        inserts.write().format("hudi").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "city").option(HoodieWriteConfig.TBL_NAME.key(), this.hoodieFooTableName()).option("hoodie.datasource.write.recordkey.field", "uuid").option("hoodie.datasource.write.precombine.field", "rider").option("hoodie.datasource.write.operation", "bulk_insert").option("hoodie.datasource.write.hive_style_partitioning", "true").option("hoodie.populate.meta.fields", "false").option("hoodie.datasource.write.drop.partition.columns", "true").mode(SaveMode.Overwrite).save(this.tempBasePath());
        Dataset tripsDF = this.spark().read().format("hudi").load(this.tempBasePath());
        tripsDF.show();
        tripsDF.select("city", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).foreach((Function1 & Serializable & scala.Serializable)row -> {
            TestHoodieSparkSqlWriter.$anonfun$testBulkInsertForDropPartitionColumn$1(row);
            return BoxedUnit.UNIT;
        });
        Seq partitions = (Seq)new .colon.colon((Object)"city=san_francisco", (List)new .colon.colon((Object)"city=chennai", (List)new .colon.colon((Object)"city=sao_paulo", (List)Nil$.MODULE$)));
        String[] partitionPaths = new String[3];
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionPaths)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            partitionPaths$1[i] = String.format("%s/%s/*", this.tempBasePath(), partitions.apply(i));
        });
        Dataset rawFileDf = this.spark().sqlContext().read().parquet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{partitionPaths[0], partitionPaths[1], partitionPaths[2]}));
        rawFileDf.show();
        rawFileDf.select("city", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).foreach((Function1 & Serializable & scala.Serializable)row -> {
            TestHoodieSparkSqlWriter.$anonfun$testBulkInsertForDropPartitionColumn$3(row);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDisableAndEnableMetaFields() {
        this.testBulkInsertWithSortMode(BulkInsertSortMode.NONE, false, this.testBulkInsertWithSortMode$default$3());
        scala.collection.immutable.Map fooTableModifier = this.commonTableModifier().updated((Object)"hoodie.bulkinsert.shuffle.parallelism", (Object)"4").updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).updated((Object)DataSourceWriteOptions$.MODULE$.ENABLE_ROW_WRITER().key(), (Object)"true").updated((Object)HoodieWriteConfig.BULK_INSERT_SORT_MODE.key(), (Object)BulkInsertSortMode.NONE.name()).updated((Object)HoodieTableConfig.POPULATE_META_FIELDS.key(), (Object)"true");
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        java.util.List<Row> inserts = DataSourceTestUtils.generateRandomRows(1000);
        SparkContext qual$1 = this.sc();
        Seq x$1 = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(inserts).asScala()).toSeq();
        int x$2 = qual$1.parallelize$default$2();
        Dataset df = this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), structType);
        try {
            HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, df, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (HoodieException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Config conflict"));
        }
        catch (Exception e) {
            Assertions.fail((Throwable)e);
        }
    }

    @Test
    public void testDropDuplicatesRowForBulkInsert() {
        try {
            scala.collection.immutable.Map fooTableModifier = this.commonTableModifier().updated((Object)"hoodie.bulkinsert.shuffle.parallelism", (Object)"4").updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).updated((Object)DataSourceWriteOptions$.MODULE$.ENABLE_ROW_WRITER().key(), (Object)"true").updated((Object)DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS().key(), (Object)"true");
            Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
            StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
            java.util.List<Row> records = DataSourceTestUtils.generateRandomRows(100);
            Seq<Row> recordsSeq = this.convertRowListToSeq(records);
            SparkContext qual$1 = this.spark().sparkContext();
            Seq<Row> x$1 = recordsSeq;
            int x$2 = qual$1.parallelize$default$2();
            Dataset df = this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), structType);
            HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, df, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
            Assertions.fail((String)"Drop duplicates with bulk insert in row writing should have thrown exception");
        }
        catch (HoodieException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Dropping duplicates with bulk_insert in row writer path is not supported yet"));
        }
    }

    @Test
    public void testInsertDatasetWithoutPrecombineField() {
        scala.collection.immutable.Map fooTableModifier = this.commonTableModifier().updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).updated((Object)DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS().key(), (Object)"false");
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        java.util.List<Row> records = DataSourceTestUtils.generateRandomRows(100);
        Seq<Row> recordsSeq = this.convertRowListToSeq(records);
        SparkContext qual$1 = this.sc();
        Seq<Row> x$1 = recordsSeq;
        int x$2 = qual$1.parallelize$default$2();
        Dataset df = this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), structType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, (scala.collection.immutable.Map)fooTableModifier.$minus((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), df, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
        Seq partitions = (Seq)new .colon.colon((Object)"2016/03/15", (List)new .colon.colon((Object)"2015/03/16", (List)new .colon.colon((Object)"2015/03/17", (List)Nil$.MODULE$)));
        String[] fullPartitionPaths = new String[3];
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fullPartitionPaths)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            fullPartitionPaths$2[i] = String.format("%s/%s/*", this.tempBasePath(), partitions.apply(i));
        });
        Dataset actualDf = this.spark().sqlContext().read().parquet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{fullPartitionPaths[0], fullPartitionPaths[1], fullPartitionPaths[2]}));
        Dataset<Row> trimmedDf = this.dropMetaFields((Dataset<Row>)actualDf);
        Predef$.MODULE$.assert(df.except(trimmedDf).count() == 0L);
    }

    @Test
    public void testInsertDatasetWithoutPartitionField() {
        scala.collection.immutable.Map tableOpts = this.commonTableModifier().updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL());
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        java.util.List<Row> records = DataSourceTestUtils.generateRandomRows(1);
        Seq<Row> recordsSeq = this.convertRowListToSeq(records);
        SparkContext qual$1 = this.sc();
        Seq<Row> x$1 = recordsSeq;
        int x$2 = qual$1.parallelize$default$2();
        Dataset df = this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), structType);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, (scala.collection.immutable.Map)tableOpts.$minus((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), df, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6()), ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443));
    }

    @Test
    public void testBulkInsertDatasetWithDatasourceImplMultipleRounds() {
        scala.collection.immutable.Map fooTableModifier = this.commonTableModifier().updated((Object)"hoodie.bulkinsert.shuffle.parallelism", (Object)"4").updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).updated((Object)DataSourceWriteOptions$.MODULE$.ENABLE_ROW_WRITER().key(), (Object)"true");
        Seq partitions = (Seq)new .colon.colon((Object)"2016/03/15", (List)new .colon.colon((Object)"2015/03/16", (List)new .colon.colon((Object)"2015/03/17", (List)Nil$.MODULE$)));
        String[] fullPartitionPaths = new String[3];
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            fullPartitionPaths$3[i] = String.format("%s/%s/*", this.tempBasePath(), partitions.apply(i));
        });
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        ObjectRef totalExpectedDf = ObjectRef.create((Object)this.spark().createDataFrame(this.sc().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), structType));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            java.util.List<Row> records = DataSourceTestUtils.generateRandomRows(200);
            Seq<Row> recordsSeq = this.convertRowListToSeq(records);
            SparkContext qual$1 = this.sc();
            Seq<Row> x$1 = recordsSeq;
            int x$2 = qual$1.parallelize$default$2();
            Dataset df = this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), structType);
            HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, df, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
            Dataset actualDf = this.sqlContext().read().parquet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{fullPartitionPaths[0], fullPartitionPaths[1], fullPartitionPaths[2]}));
            Dataset<Row> trimmedDf = this.dropMetaFields((Dataset<Row>)actualDf);
            totalExpectedDf$1.elem = ((Dataset)totalExpectedDf$1.elem).union(df);
            Predef$.MODULE$.assert(((Dataset)totalExpectedDf$1.elem).except(trimmedDf).count() == 0L);
        });
    }

    @ParameterizedTest
    @MethodSource(value={"testDatasourceInsert"})
    public void testDatasourceInsertForTableTypeBaseFileMetaFields(String tableType, boolean populateMetaFields, String baseFileFormat) {
        String hoodieFooTableName = "hoodie_foo_tbl";
        scala.collection.immutable.Map fooTableModifier = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.tempBasePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)hoodieFooTableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.BASE_FILE_FORMAT.key()), (Object)baseFileFormat), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()), (Object)DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTableConfig.POPULATE_META_FIELDS.key()), (Object)String.valueOf(populateMetaFields)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME().key()), (Object)DefaultHoodieRecordPayload.class.getCanonicalName())}));
        scala.collection.immutable.Map fooTableParams = HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults(fooTableModifier);
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        Schema modifiedSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)structType, "trip", "example.schema");
        java.util.List<Row> records = DataSourceTestUtils.generateRandomRows(100);
        Seq<Row> recordsSeq = this.convertRowListToSeq(records);
        SparkContext qual$1 = this.sc();
        Seq<Row> x$1 = recordsSeq;
        int x$2 = qual$1.parallelize$default$2();
        Dataset df = this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), structType);
        this.initializeMetaClientForBootstrap((scala.collection.immutable.Map<String, String>)fooTableParams, tableType, false, true);
        SparkRDDWriteClient client = (SparkRDDWriteClient)Mockito.spy((Object)DataSourceUtils.createHoodieClient((JavaSparkContext)new JavaSparkContext(this.sc()), (String)modifiedSchema.toString(), (String)this.tempBasePath(), (String)hoodieFooTableName, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)fooTableParams).asJava())));
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, df, Option$.MODULE$.empty(), Option$.MODULE$.apply((Object)client));
        ((BaseHoodieWriteClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)0))).scheduleCompaction((Option)ArgumentMatchers.any());
        ((BaseHoodieWriteClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).close();
        Seq partitions = (Seq)new .colon.colon((Object)"2016/03/15", (List)new .colon.colon((Object)"2015/03/16", (List)new .colon.colon((Object)"2015/03/17", (List)Nil$.MODULE$)));
        String[] fullPartitionPaths = new String[3];
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fullPartitionPaths)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            fullPartitionPaths$4[i] = String.format("%s/%s/*", this.tempBasePath(), partitions.apply(i));
        });
        Dataset actualDf = null;
        if (baseFileFormat.equalsIgnoreCase(HoodieFileFormat.PARQUET.name())) {
            actualDf = this.sqlContext().read().parquet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{fullPartitionPaths[0], fullPartitionPaths[1], fullPartitionPaths[2]}));
        } else if (baseFileFormat.equalsIgnoreCase(HoodieFileFormat.ORC.name())) {
            actualDf = this.sqlContext().read().orc((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{fullPartitionPaths[0], fullPartitionPaths[1], fullPartitionPaths[2]}));
        }
        Dataset<Row> trimmedDf = this.dropMetaFields(actualDf);
        Predef$.MODULE$.assert(df.except(trimmedDf).count() == 0L);
    }

    @ParameterizedTest
    @MethodSource(value={"bootstrapTestParams"})
    public void testWithDatasourceBootstrapForTableType(String tableType, int tableVersion) {
        Path srcPath = Files.createTempDirectory("hoodie_bootstrap_source_path", new FileAttribute[0]);
        try {
            Dataset<Row> sourceDF = TestBootstrap.generateTestRawTripDataset(Instant.now().toEpochMilli(), 0, 100, Collections.emptyList(), JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.spark().sqlContext());
            sourceDF.write().format("parquet").mode(SaveMode.Overwrite).save(((Object)srcPath.toAbsolutePath()).toString());
            scala.collection.immutable.Map fooTableModifier = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.tempBasePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieBootstrapConfig.BASE_PATH.key()), (Object)((Object)srcPath.toAbsolutePath()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)this.hoodieFooTableName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieBootstrapConfig.PARALLELISM_VALUE.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()), (Object)DataSourceWriteOptions$.MODULE$.BOOTSTRAP_OPERATION_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)NonpartitionedKeyGenerator.class.getCanonicalName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME().key()), (Object)DefaultHoodieRecordPayload.class.getCanonicalName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.write.table.version"), (Object)Integer.toString(tableVersion)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"false")}));
            scala.collection.immutable.Map fooTableParams = HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults(fooTableModifier);
            this.initializeMetaClientForBootstrap((scala.collection.immutable.Map<String, String>)fooTableParams, tableType, true, false);
            SparkRDDWriteClient client = (SparkRDDWriteClient)Mockito.spy((Object)DataSourceUtils.createHoodieClient((JavaSparkContext)new JavaSparkContext(this.sc()), null, (String)this.tempBasePath(), (String)this.hoodieFooTableName(), (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)fooTableParams).asJava())));
            HoodieSparkSqlWriter$.MODULE$.bootstrap(this.sqlContext(), SaveMode.Append, fooTableModifier, this.spark().emptyDataFrame(), Option$.MODULE$.empty(), Option$.MODULE$.empty(), Option$.MODULE$.apply((Object)client));
            ((BaseHoodieWriteClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).close();
            boolean ignoreResult = HoodieSparkSqlWriter$.MODULE$.bootstrap(this.sqlContext(), SaveMode.Ignore, fooTableModifier, this.spark().emptyDataFrame(), Option$.MODULE$.empty(), Option$.MODULE$.empty(), Option$.MODULE$.apply((Object)client));
            Assertions.assertFalse((boolean)ignoreResult);
            ((BaseHoodieWriteClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)2))).close();
            HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)this.spark(), (String)this.tempBasePath());
            Assertions.assertEquals((int)metaClient.getTableConfig().getTableVersion().versionCode(), (int)tableVersion);
            Dataset actualDf = this.sqlContext().read().parquet(this.tempBasePath());
            Predef$.MODULE$.assert(actualDf.count() == 100L);
        }
        finally {
            FileUtils.deleteDirectory((File)srcPath.toFile());
        }
    }

    public void initializeMetaClientForBootstrap(scala.collection.immutable.Map<String, String> fooTableParams, String tableType, boolean addBootstrapPath, boolean initBasePath) {
        HoodieTableMetaClient.TableBuilder tableMetaClientBuilder = HoodieTableMetaClient.newTableBuilder().setTableType(tableType).setTableName(this.hoodieFooTableName()).setRecordKeyFields((String)fooTableParams.apply((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key())).setBaseFileFormat((String)fooTableParams.getOrElse((Object)HoodieWriteConfig.BASE_FILE_FORMAT.key(), (Function0 & Serializable & scala.Serializable)() -> ((Enum)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).name())).setArchiveLogFolder((String)HoodieTableConfig.TIMELINE_HISTORY_PATH.defaultValue()).setPreCombineField((String)fooTableParams.getOrElse((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), (Function0 & Serializable & scala.Serializable)() -> null)).setPartitionFields((String)fooTableParams.apply((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key())).setKeyGeneratorClassProp((String)fooTableParams.getOrElse((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), (Function0 & Serializable & scala.Serializable)() -> (String)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().defaultValue()));
        Object object = addBootstrapPath ? tableMetaClientBuilder.setBootstrapBasePath((String)fooTableParams.apply((Object)HoodieBootstrapConfig.BASE_PATH.key())) : BoxedUnit.UNIT;
        if (initBasePath) {
            tableMetaClientBuilder.initTable(HadoopFSUtils.getStorageConfWithCopy((Configuration)this.sc().hadoopConfiguration()), this.tempBasePath());
            return;
        }
    }

    @ParameterizedTest
    @CsvSource(value={"COPY_ON_WRITE,6", "COPY_ON_WRITE,8", "MERGE_ON_READ,6", "MERGE_ON_READ,8"})
    public void testSchemaEvolutionForTableType(String tableType, int tableVersion) {
        scala.collection.immutable.Map opts = this.getCommonParams(this.tempPath(), this.hoodieFooTableName(), tableType);
        opts = opts.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTableConfig.VERSION.key()), (Object)Integer.toString(tableVersion)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.WRITE_TABLE_VERSION.key()), (Object)Integer.toString(tableVersion)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        scala.collection.immutable.Map noReconciliationOpts = opts.updated((Object)DataSourceWriteOptions$.MODULE$.RECONCILE_SCHEMA().key(), (Object)"false");
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        java.util.List<Row> records = DataSourceTestUtils.generateRandomRows(10);
        Seq<Row> recordsSeq = this.convertRowListToSeq(records);
        SparkContext qual$1 = this.sc();
        Seq<Row> x$1 = recordsSeq;
        int x$2 = qual$1.parallelize$default$2();
        Dataset df1 = this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), structType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Overwrite, noReconciliationOpts, df1, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
        Dataset snapshotDF1 = this.spark().read().format("org.apache.hudi").load(this.tempBasePath());
        Assertions.assertEquals((long)10L, (long)snapshotDF1.count());
        Assertions.assertEquals((long)df1.except(this.dropMetaFields((Dataset<Row>)snapshotDF1)).count(), (long)0L);
        Seq<Row> updatesSeq = this.convertRowListToSeq(DataSourceTestUtils.generateUpdates(records, 5));
        SparkContext qual$2 = this.sc();
        Seq<Row> x$3 = updatesSeq;
        int x$4 = qual$2.parallelize$default$2();
        Dataset df2 = this.spark().createDataFrame(qual$2.parallelize(x$3, x$4, ClassTag$.MODULE$.apply(Row.class)), structType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, noReconciliationOpts, df2, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
        Dataset snapshotDF2 = this.spark().read().format("org.apache.hudi").load(this.tempBasePath());
        Assertions.assertEquals((long)10L, (long)snapshotDF2.count());
        Assertions.assertEquals((long)df2.intersect(this.dropMetaFields((Dataset<Row>)snapshotDF2)).except(df2).count(), (long)0L);
        Schema evolSchema = DataSourceTestUtils.getStructTypeExampleEvolvedSchema();
        StructType evolStructType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(evolSchema);
        records = DataSourceTestUtils.generateRandomRowsEvolvedSchema(5);
        recordsSeq = this.convertRowListToSeq(records);
        SparkContext qual$3 = this.sc();
        Seq<Row> x$5 = recordsSeq;
        int x$6 = qual$3.parallelize$default$2();
        Dataset df3 = this.spark().createDataFrame(qual$3.parallelize(x$5, x$6, ClassTag$.MODULE$.apply(Row.class)), evolStructType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, noReconciliationOpts, df3, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
        Dataset snapshotDF3 = this.spark().read().format("org.apache.hudi").load(this.tempBasePath());
        Assertions.assertEquals((long)15L, (long)snapshotDF3.count());
        Assertions.assertEquals((long)df3.intersect(this.dropMetaFields((Dataset<Row>)snapshotDF3)).except(df3).count(), (long)0L);
        records = DataSourceTestUtils.generateRandomRows(10);
        recordsSeq = this.convertRowListToSeq(records);
        scala.collection.immutable.Map reconciliationOpts = noReconciliationOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECONCILE_SCHEMA().key()), (Object)"true")})));
        SparkContext qual$4 = this.sc();
        Seq<Row> x$7 = recordsSeq;
        int x$8 = qual$4.parallelize$default$2();
        Dataset df4 = this.spark().createDataFrame(qual$4.parallelize(x$7, x$8, ClassTag$.MODULE$.apply(Row.class)), structType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, reconciliationOpts, df4, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
        Dataset snapshotDF4 = this.spark().read().format("org.apache.hudi").load(this.tempBasePath());
        Assertions.assertEquals((long)25L, (long)snapshotDF4.count());
        Dataset reshapedDF4 = df4.withColumn("new_field", functions$.MODULE$.lit(null).cast("string"));
        Assertions.assertEquals((long)reshapedDF4.intersect(this.dropMetaFields((Dataset<Row>)snapshotDF4)).except(reshapedDF4).count(), (long)0L);
        Schema fourthBatchActualSchema = this.fetchActualSchema();
        Tuple2 tuple2 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(this.hoodieFooTableName());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String structName = (String)tuple2._1();
        String nameSpace = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)structName, (Object)nameSpace);
        String structName2 = (String)tuple22._1();
        String nameSpace2 = (String)tuple22._2();
        Schema fourthBatchExpectedSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)evolStructType, structName2, nameSpace2);
        Assertions.assertEquals((Object)fourthBatchExpectedSchema, (Object)fourthBatchActualSchema);
        records = DataSourceTestUtils.generateRandomRows(10);
        recordsSeq = this.convertRowListToSeq(records);
        SparkContext qual$5 = this.sc();
        Seq<Row> x$9 = recordsSeq;
        int x$10 = qual$5.parallelize$default$2();
        Dataset df5 = this.spark().createDataFrame(qual$5.parallelize(x$9, x$10, ClassTag$.MODULE$.apply(Row.class)), structType);
        scala.collection.immutable.Map disallowOpts = noReconciliationOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.SCHEMA_ALLOW_AUTO_EVOLUTION_COLUMN_DROP.key()), (Object)Boolean.toString(false))})));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, disallowOpts, df5, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6()), ClassTag$.MODULE$.apply(SchemaCompatibilityException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 736));
        scala.collection.immutable.Map allowOpts = noReconciliationOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.SCHEMA_ALLOW_AUTO_EVOLUTION_COLUMN_DROP.key()), (Object)Boolean.toString(true))})));
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, allowOpts, df5, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
        Dataset snapshotDF5 = this.spark().read().format("org.apache.hudi").load(this.tempBasePath());
        Assertions.assertEquals((long)35L, (long)snapshotDF5.count());
        Assertions.assertEquals((long)df5.intersect(this.dropMetaFields((Dataset<Row>)snapshotDF5)).except(df5).count(), (long)0L);
        Schema fifthBatchActualSchema = this.fetchActualSchema();
        Tuple2 tuple23 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(this.hoodieFooTableName());
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        String structName3 = (String)tuple23._1();
        String nameSpace3 = (String)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)structName3, (Object)nameSpace3);
        String structName4 = (String)tuple24._1();
        String nameSpace4 = (String)tuple24._2();
        Schema fifthBatchExpectedSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)df5.schema(), structName4, nameSpace4);
        Assertions.assertEquals((Object)fifthBatchExpectedSchema, (Object)fifthBatchActualSchema);
    }

    @Test
    public void testIncrementalViewWithReplacement() {
        new .colon.colon((Object)DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL(), (List)new .colon.colon((Object)DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestHoodieSparkSqlWriter.$anonfun$testIncrementalViewWithReplacement$1(this, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public Tuple2<Dataset<Row>, scala.collection.immutable.Map<String, String>> deletePartitionSetup() {
        scala.collection.immutable.Map<String, String> fooTableModifier = this.getCommonParams(this.tempPath(), this.hoodieFooTableName(), HoodieTableType.COPY_ON_WRITE.name());
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        java.util.List<Row> records = DataSourceTestUtils.generateRandomRows(10);
        Seq<Row> recordsSeq = this.convertRowListToSeq(records);
        SparkContext qual$1 = this.sc();
        Seq<Row> x$1 = recordsSeq;
        int x$2 = qual$1.parallelize$default$2();
        Dataset df1 = this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), structType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Overwrite, fooTableModifier, df1, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
        Dataset snapshotDF1 = this.spark().read().format("org.apache.hudi").load(this.tempBasePath());
        Assertions.assertEquals((long)10L, (long)snapshotDF1.count());
        Dataset<Row> trimmedDf1 = this.dropMetaFields((Dataset<Row>)snapshotDF1);
        Predef$.MODULE$.assert(df1.except(trimmedDf1).count() == 0L);
        Seq<Row> updatesSeq = this.convertRowListToSeq(DataSourceTestUtils.generateUpdates(records, 5));
        SparkContext qual$2 = this.sc();
        Seq<Row> x$3 = updatesSeq;
        int x$4 = qual$2.parallelize$default$2();
        Dataset updatesDf = this.spark().createDataFrame(qual$2.parallelize(x$3, x$4, ClassTag$.MODULE$.apply(Row.class)), structType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, updatesDf, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
        Dataset snapshotDF2 = this.spark().read().format("org.apache.hudi").load(this.tempBasePath());
        Assertions.assertEquals((long)10L, (long)snapshotDF2.count());
        Dataset<Row> trimmedDf2 = this.dropMetaFields((Dataset<Row>)snapshotDF2);
        Predef$.MODULE$.assert(updatesDf.intersect(trimmedDf2).except(updatesDf).count() == 0L);
        return new Tuple2((Object)df1, fooTableModifier);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDeletePartitionsV2(boolean usePartitionsToDeleteConfig) {
        Tuple2<Dataset<Row>, scala.collection.immutable.Map<String, String>> tuple2 = this.deletePartitionSetup();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Dataset df1 = (Dataset)tuple2._1();
        scala.collection.immutable.Map fooTableModifier = (scala.collection.immutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)df1, (Object)fooTableModifier);
        Dataset df12 = (Dataset)tuple22._1();
        scala.collection.immutable.Map fooTableModifier2 = (scala.collection.immutable.Map)tuple22._2();
        this.validateDataAndPartitionStats((Dataset<Row>)df12, this.validateDataAndPartitionStats$default$2());
        Dataset recordsToDelete = this.spark().emptyDataFrame();
        if (usePartitionsToDeleteConfig) {
            fooTableModifier2 = fooTableModifier2.updated((Object)DataSourceWriteOptions$.MODULE$.PARTITIONS_TO_DELETE().key(), (Object)"2016/03/15,2015/03/16");
        } else {
            recordsToDelete = df12.filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)TestHoodieSparkSqlWriter.$anonfun$testDeletePartitionsV2$1(entry)));
        }
        fooTableModifier2 = fooTableModifier2.updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)WriteOperationType.DELETE_PARTITION.name());
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier2, recordsToDelete, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
        this.validateDataAndPartitionStats((Dataset<Row>)recordsToDelete, true);
        Dataset snapshotDF3 = this.spark().read().format("hudi").load(this.tempBasePath());
        Assertions.assertEquals((long)0L, (long)snapshotDF3.filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)TestHoodieSparkSqlWriter.$anonfun$testDeletePartitionsV2$2(entry))).count());
    }

    private void validateDataAndPartitionStats(Dataset<Row> inputDf, boolean isDeletePartition) {
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)this.spark(), (String)this.tempBasePath());
        PartitionStatsIndexSupport partitionStatsIndex = new PartitionStatsIndexSupport(this.spark(), inputDf.schema(), HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexPartitionStats(true).build(), metaClient, PartitionStatsIndexSupport$.MODULE$.$lessinit$greater$default$5());
        .colon.colon x$1 = new .colon.colon((Object)"partition", (List)new .colon.colon((Object)"ts", (List)Nil$.MODULE$));
        boolean x$2 = true;
        scala.Option x$3 = partitionStatsIndex.loadColumnStatsIndexRecords$default$2();
        java.util.List partitionStats = partitionStatsIndex.loadColumnStatsIndexRecords((Seq)x$1, x$3, x$2).collectAsList();
        partitionStats.forEach(stat -> Assertions.assertTrue((stat.getColumnName().equals("partition") || stat.getColumnName().equals("ts") ? 1 : 0) != 0));
        if (isDeletePartition) {
            Assertions.assertEquals((int)2, (int)partitionStats.size());
            partitionStats.forEach(stat -> Assertions.assertEquals((Object)"2015/03/17", (Object)stat.getFileName()));
            return;
        }
        Assertions.assertEquals((int)6, (int)partitionStats.size());
        partitionStats.forEach(stat -> Assertions.assertTrue((stat.getFileName().equals("2016/03/15") || stat.getFileName().equals("2015/03/16") || stat.getFileName().equals("2015/03/17") ? 1 : 0) != 0));
        scala.collection.immutable.Map partitionStatsGrouped = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionStats).asScala()).groupBy((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getFileName());
        partitionStatsGrouped.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TestHoodieSparkSqlWriter.$anonfun$validateDataAndPartitionStats$5(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private Dataset<Row> validateDataAndPartitionStats$default$1() {
        return this.spark().emptyDataFrame();
    }

    private boolean validateDataAndPartitionStats$default$2() {
        return false;
    }

    @ParameterizedTest
    @MethodSource(value={"deletePartitionsWildcardTestParams"})
    public void testDeletePartitionsWithWildcard(String partition, Seq<String> expectedPartitions) {
        Tuple2<Dataset<Row>, scala.collection.immutable.Map<String, String>> tuple2 = this.deletePartitionSetup();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.immutable.Map fooTableModifier = (scala.collection.immutable.Map)tuple2._2();
        scala.collection.immutable.Map fooTableModifier2 = fooTableModifier;
        fooTableModifier2 = fooTableModifier2.updated((Object)DataSourceWriteOptions$.MODULE$.PARTITIONS_TO_DELETE().key(), (Object)partition);
        fooTableModifier2 = fooTableModifier2.updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)WriteOperationType.DELETE_PARTITION.name());
        Dataset recordsToDelete = this.spark().emptyDataFrame();
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier2, recordsToDelete, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
        Dataset snapshotDF3 = this.spark().read().format("org.apache.hudi").load(this.tempBasePath());
        snapshotDF3.show();
        Assertions.assertEquals((long)0L, (long)snapshotDF3.filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)TestHoodieSparkSqlWriter.$anonfun$testDeletePartitionsWithWildcard$1(expectedPartitions, entry))).count());
    }

    @Test
    public void testDeletePartitionsWithWrongPartition() {
        Tuple2<Dataset<Row>, scala.collection.immutable.Map<String, String>> tuple2 = this.deletePartitionSetup();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.immutable.Map fooTableModifier = (scala.collection.immutable.Map)tuple2._2();
        scala.collection.immutable.Map fooTableModifier2 = fooTableModifier;
        fooTableModifier2 = fooTableModifier2.updated((Object)DataSourceWriteOptions$.MODULE$.PARTITIONS_TO_DELETE().key(), (Object)"2016/03/15,2025/03").updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)WriteOperationType.DELETE_PARTITION.name());
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier2, this.spark().emptyDataFrame(), HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
        Dataset snapshotDF3 = this.spark().read().format("org.apache.hudi").load(this.tempBasePath());
        Assertions.assertEquals((long)0L, (long)snapshotDF3.filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)TestHoodieSparkSqlWriter.$anonfun$testDeletePartitionsWithWrongPartition$1(entry))).count());
        HoodieActiveTimeline activeTimeline = HoodieClientTestUtils.createMetaClient((SparkSession)this.spark(), (String)this.tempBasePath()).getActiveTimeline();
        HoodieReplaceCommitMetadata metadata = (HoodieReplaceCommitMetadata)TimelineUtils.getCommitMetadata((HoodieInstant)((HoodieInstant)activeTimeline.lastInstant().get()), (HoodieTimeline)activeTimeline);
        Assertions.assertTrue((boolean)metadata.getOperationType().equals((Object)WriteOperationType.DELETE_PARTITION));
        Assertions.assertEquals(Collections.singleton("2016/03/15"), metadata.getPartitionToReplaceFileIds().keySet());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testNonPartitionTableWithMetatableSupport(HoodieTableType tableType) {
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"col3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"keyid"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)"org.apache.hudi.keygen.NonpartitionedKeyGenerator"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.metadata.enable"), (Object)"true")}));
        Dataset df = this.spark().range(0L, 10L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keyid"})).withColumn("col3", functions$.MODULE$.expr("keyid")).withColumn("age", functions$.MODULE$.expr("keyid + 1000"));
        df.write().format("hudi").options((Map)options.updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)"insert")).mode(SaveMode.Overwrite).save(this.tempBasePath());
        Dataset df_update = this.spark().range(0L, 10L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keyid"})).withColumn("col3", functions$.MODULE$.expr("keyid")).withColumn("age", functions$.MODULE$.expr("keyid + 2000"));
        df_update.write().format("hudi").options((Map)options.updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)"upsert")).mode(SaveMode.Append).save(this.tempBasePath());
        Dataset df_result = this.spark().read().format("hudi").load(this.tempBasePath());
        Predef$.MODULE$.assert(df_result.count() == 10L);
        Predef$.MODULE$.assert(df_result.where("age >= 2000").count() == 10L);
    }

    @Test
    public void testUpsertWithoutPrecombineFieldAndCombineBeforeUpsertDisabled() {
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)HoodieTableType.COPY_ON_WRITE.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"keyid"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)"org.apache.hudi.keygen.NonpartitionedKeyGenerator"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.COMBINE_BEFORE_UPSERT.key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"1")}));
        Dataset df = this.spark().range(0L, 10L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keyid"})).withColumn("age", functions$.MODULE$.expr("keyid + 1000"));
        df.write().format("hudi").options((Map)options.updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)"insert")).mode(SaveMode.Overwrite).save(this.tempBasePath());
        Dataset df_update = this.spark().range(0L, 10L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keyid"})).withColumn("age", functions$.MODULE$.expr("keyid + 2000"));
        df_update.write().format("hudi").options((Map)options.updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)"upsert")).mode(SaveMode.Append).save(this.tempBasePath());
        Dataset df_result_1 = this.spark().read().format("hudi").load(this.tempBasePath()).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keyid", "age"}));
        Predef$.MODULE$.assert(df_result_1.count() == 10L);
        Predef$.MODULE$.assert(df_result_1.where("age >= 2000").count() == 10L);
        Dataset df_with_duplicates = df.union(df);
        df_with_duplicates.write().format("hudi").options((Map)options.updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)"insert")).mode(SaveMode.Overwrite).save(this.tempBasePath());
        Dataset df_result_2 = this.spark().read().format("hudi").load(this.tempBasePath()).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keyid", "age"}));
        Predef$.MODULE$.assert(df_result_2.count() == 20L);
        Predef$.MODULE$.assert(df_result_2.distinct().count() == 10L);
        Predef$.MODULE$.assert(df_result_2.where("age >= 1000 and age < 2000").count() == 20L);
        Dataset df_with_duplicates_update = df_with_duplicates.withColumn("age", functions$.MODULE$.expr("keyid + 3000"));
        df_with_duplicates_update.write().format("hudi").options((Map)options.updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)"upsert")).mode(SaveMode.Append).save(this.tempBasePath());
        Dataset df_result_3 = this.spark().read().format("hudi").load(this.tempBasePath()).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keyid", "age"}));
        Predef$.MODULE$.assert(df_result_3.distinct().count() == 10L);
        Predef$.MODULE$.assert(df_result_3.count() == 20L);
        Predef$.MODULE$.assert(df_result_3.where("age >= 3000").count() == 20L);
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testUpsertWithCombineBeforeUpsertDisabled(HoodieTableType tableType) {
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"col3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"keyid"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)"org.apache.hudi.keygen.NonpartitionedKeyGenerator"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.COMBINE_BEFORE_UPSERT.key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"1")}));
        Dataset df = this.spark().range(0L, 10L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keyid"})).withColumn("col3", functions$.MODULE$.expr("keyid")).withColumn("age", functions$.MODULE$.expr("keyid + 1000"));
        Dataset df_with_duplicates = df.union(df);
        df_with_duplicates.write().format("hudi").options((Map)options.updated((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Object)"upsert")).mode(SaveMode.Overwrite).save(this.tempBasePath());
        Dataset result_df = this.spark().read().format("hudi").load(this.tempBasePath()).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keyid", "col3", "age"}));
        Predef$.MODULE$.assert(result_df.count() == 20L);
        Predef$.MODULE$.assert(result_df.distinct().count() == 10L);
    }

    @Test
    public void testToWriteWithoutParametersIncludedInHoodieTableConfig() {
        SparkSession _spark = this.spark();
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator6$1(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToLong((long)1000L), (Object)"2021-10-16"), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator6$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"ts"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"dt")}));
        Tuple2 tuple2 = new Tuple2((Object)"hoodie_test_params_1", (Object)new StringBuilder(2).append(this.tempBasePath()).append("_1").toString());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String tableName1 = (String)tuple2._1();
        String tablePath1 = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableName1, (Object)tablePath1);
        String tableName12 = (String)tuple22._1();
        String tablePath12 = (String)tuple22._2();
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(329).append("\n         | create table ").append(tableName12).append(" (\n         |   id int,\n         |   name string,\n         |   value int,\n         |   ts long,\n         |   dt string\n         | ) using hudi\n         | partitioned by (dt)\n         | options (\n         |  primaryKey = 'id',\n         |  preCombineField = 'ts'\n         | )\n         | location '").append(tablePath12).append("'\n       ").toString())).stripMargin());
        HoodieTableConfig tableConfig1 = HoodieClientTestUtils.createMetaClient((SparkSession)this.spark(), (String)tablePath12).getTableConfig();
        String string = tableConfig1.getHiveStylePartitioningEnable();
        String string2 = "true";
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
        String string3 = tableConfig1.getUrlEncodePartitioning();
        String string4 = "false";
        Predef$.MODULE$.assert(!(string3 != null ? !string3.equals(string4) : string4 != null));
        String string5 = tableConfig1.getKeyGeneratorClassName();
        String string6 = SimpleKeyGenerator.class.getName();
        Predef$.MODULE$.assert(!(string5 != null ? !string5.equals(string6) : string6 != null));
        df.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).mode(SaveMode.Append).save(tablePath12);
        Dataset hudiDf = this.spark().read().format("hudi").load(tablePath12);
        Predef$.MODULE$.assert(hudiDf.count() == 1L);
        Tuple2 tuple23 = new Tuple2((Object)"hoodie_test_params_2", (Object)new StringBuilder(2).append(this.tempBasePath()).append("_2").toString());
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        String tableName2 = (String)tuple23._1();
        String tablePath2 = (String)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)tableName2, (Object)tablePath2);
        String tableName22 = (String)tuple24._1();
        String tablePath22 = (String)tuple24._2();
        df.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName22).option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), "true").mode(SaveMode.Overwrite).save(tablePath22);
        HoodieTableConfig tableConfig2 = HoodieClientTestUtils.createMetaClient((SparkSession)this.spark(), (String)tablePath22).getTableConfig();
        String string7 = tableConfig2.getHiveStylePartitioningEnable();
        String string8 = "false";
        Predef$.MODULE$.assert(!(string7 != null ? !string7.equals(string8) : string8 != null));
        String string9 = tableConfig2.getUrlEncodePartitioning();
        String string10 = "true";
        Predef$.MODULE$.assert(!(string9 != null ? !string9.equals(string10) : string10 != null));
        String string11 = tableConfig2.getKeyGeneratorClassName();
        String string12 = SimpleKeyGenerator.class.getName();
        Predef$.MODULE$.assert(!(string11 != null ? !string11.equals(string12) : string12 != null));
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator16$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator16$1(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df2 = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)2), (Object)"a2", (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToLong((long)1000L), (Object)"2021-10-16"), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator16$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        HoodieException configConflictException = (HoodieException)((Object)package$.MODULE$.Matchers().intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df2.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName22).option(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), ComplexKeyGenerator.class.getName()).mode(SaveMode.Append).save(tablePath22), ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1130)));
        Predef$.MODULE$.assert(configConflictException.getMessage().contains("Config conflict"));
        Predef$.MODULE$.assert(configConflictException.getMessage().contains(new StringBuilder(15).append("KeyGenerator:\t").append(ComplexKeyGenerator.class.getName()).append("\t").append(SimpleKeyGenerator.class.getName()).toString()));
        df2.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName22).mode(SaveMode.Append).save(tablePath22);
        Dataset data = this.spark().read().format("hudi").load(tablePath22);
        Predef$.MODULE$.assert(data.count() == 2L);
        Object object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data.select("_hoodie_partition_path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.getString(0), _spark.implicits().newStringEncoder()).distinct().collect())).head();
        String string13 = "2021-10-16";
        Predef$.MODULE$.assert(!(object != null ? !object.equals(string13) : string13 != null));
    }

    @Test
    public void testNonpartitonedWithReuseTableConfig() {
        SparkSession _spark = this.spark();
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator6$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator6$2(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16"), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator6$2(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"ts")}));
        Tuple2 tuple2 = new Tuple2((Object)"hoodie_test_params_1", (Object)new StringBuilder(2).append(this.tempBasePath()).append("_1").toString());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String tableName1 = (String)tuple2._1();
        String tablePath1 = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableName1, (Object)tablePath1);
        String tableName12 = (String)tuple22._1();
        String tablePath12 = (String)tuple22._2();
        df.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).mode(SaveMode.Overwrite).save(tablePath12);
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator16$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator16$2(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df2 = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)2), (Object)"a2", (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16"), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator16$2(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        df2.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).mode(SaveMode.Append).save(tablePath12);
    }

    @Test
    public void testDefaultKeyGenToNonpartitoned() {
        SparkSession _spark = this.spark();
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator6$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator6$3(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16"), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator6$3(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"ts"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"dt")}));
        Tuple2 tuple2 = new Tuple2((Object)"hoodie_test_params_1", (Object)new StringBuilder(2).append(this.tempBasePath()).append("_1").toString());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String tableName1 = (String)tuple2._1();
        String tablePath1 = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableName1, (Object)tablePath1);
        String tableName12 = (String)tuple22._1();
        String tablePath12 = (String)tuple22._2();
        df.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).mode(SaveMode.Overwrite).save(tablePath12);
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator16$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator16$3(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df2 = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)2), (Object)"a2", (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16"), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator16$3(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        HoodieException configConflictException = (HoodieException)((Object)package$.MODULE$.Matchers().intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df2.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).option(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), NonpartitionedKeyGenerator.class.getName()).mode(SaveMode.Append).save(tablePath12), ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1199)));
        Predef$.MODULE$.assert(configConflictException.getMessage().contains("Config conflict"));
        Predef$.MODULE$.assert(configConflictException.getMessage().contains(new StringBuilder(15).append("KeyGenerator:\t").append(NonpartitionedKeyGenerator.class.getName()).append("\t").append(SimpleKeyGenerator.class.getName()).toString()));
    }

    @Test
    public void testNoKeyGenToSimpleKeyGen() {
        SparkSession _spark = this.spark();
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator6$4
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator6$4(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16"), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator6$4(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"ts"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"dt")}));
        Tuple2 tuple2 = new Tuple2((Object)"hoodie_test_params_1", (Object)new StringBuilder(2).append(this.tempBasePath()).append("_1").toString());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String tableName1 = (String)tuple2._1();
        String tablePath1 = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableName1, (Object)tablePath1);
        String tableName12 = (String)tuple22._1();
        String tablePath12 = (String)tuple22._2();
        df.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).mode(SaveMode.Overwrite).save(tablePath12);
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator16$4
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator16$4(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df2 = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)2), (Object)"a2", (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16"), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator16$4(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        try {
            df2.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).option(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), SimpleKeyGenerator.class.getName()).mode(SaveMode.Append).save(tablePath12);
        }
        catch (Throwable throwable) {
            Assertions.fail((String)"Switching from no keygen to explicit SimpleKeyGenerator should not fail");
        }
    }

    @Test
    public void testSimpleKeyGenToNoKeyGen() {
        SparkSession _spark = this.spark();
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator6$5
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator6$5(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16"), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator6$5(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"ts"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"dt")}));
        Tuple2 tuple2 = new Tuple2((Object)"hoodie_test_params_1", (Object)new StringBuilder(2).append(this.tempBasePath()).append("_1").toString());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String tableName1 = (String)tuple2._1();
        String tablePath1 = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableName1, (Object)tablePath1);
        String tableName12 = (String)tuple22._1();
        String tablePath12 = (String)tuple22._2();
        df.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).option(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), SimpleKeyGenerator.class.getName()).mode(SaveMode.Overwrite).save(tablePath12);
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator16$5
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator16$5(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df2 = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)2), (Object)"a2", (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16"), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator16$5(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        try {
            df2.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).mode(SaveMode.Append).save(tablePath12);
        }
        catch (Throwable throwable) {
            Assertions.fail((String)"Switching from  explicit SimpleKeyGenerator to default keygen should not fail");
        }
    }

    @Test
    public void testGetOriginKeyGenerator() {
        String kg2;
        String kg1;
        scala.collection.immutable.Map m1 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key()), (Object)ComplexKeyGenerator.class.getName())}));
        String string = kg1 = HoodieWriterUtils$.MODULE$.getOriginKeyGenerator(m1);
        String string2 = ComplexKeyGenerator.class.getName();
        Assertions.assertTrue((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0);
        scala.collection.immutable.Map m2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key()), (Object)SqlKeyGenerator.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SqlKeyGenerator$.MODULE$.ORIGINAL_KEYGEN_CLASS_NAME()), (Object)SimpleKeyGenerator.class.getName())}));
        String string3 = kg2 = HoodieWriterUtils$.MODULE$.getOriginKeyGenerator(m2);
        String string4 = SimpleKeyGenerator.class.getName();
        Assertions.assertTrue((!(string3 != null ? !string3.equals(string4) : string4 != null) ? 1 : 0) != 0);
    }

    @Test
    public void testCOWConsistentHashing() {
        SparkSession _spark = this.spark();
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(TestHoodieSparkSqlWriter.class.getClassLoader());
        public final class Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator6$6
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator6$6(TestHoodieSparkSqlWriter $outer) {
            }
        }
        Dataset df = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-10-16"), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_TestHoodieSparkSqlWriter$$typecreator6$6(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "ts", "dt"}));
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"ts"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndexConfig.BUCKET_INDEX_ENGINE_TYPE.key()), (Object)"CONSISTENT_HASHING"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndexConfig.INDEX_TYPE.key()), (Object)"BUCKET")}));
        Tuple2 tuple2 = new Tuple2((Object)"hoodie_test_params_1", (Object)new StringBuilder(2).append(this.tempBasePath()).append("_1").toString());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String tableName1 = (String)tuple2._1();
        String tablePath1 = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableName1, (Object)tablePath1);
        String tableName12 = (String)tuple22._1();
        String tablePath12 = (String)tuple22._2();
        HoodieException exc = (HoodieException)((Object)package$.MODULE$.Matchers().intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.write().format("hudi").options((Map)options).option(HoodieWriteConfig.TBL_NAME.key(), tableName12).mode(SaveMode.Overwrite).save(tablePath12), ClassTag$.MODULE$.apply(HoodieException.class), new Position("TestHoodieSparkSqlWriter.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1310)));
        Predef$.MODULE$.assert(exc.getMessage().contains("Consistent hashing bucket index does not work with COW table. Use simple bucket index or an MOR table."));
    }

    @Test
    public void testShouldDropDuplicatesForInserts() {
        HoodieConfig hoodieConfig = new HoodieConfig();
        boolean shouldDrop = HoodieSparkSqlWriterInternal$.MODULE$.shouldDropDuplicatesForInserts(hoodieConfig);
        Assertions.assertFalse((boolean)shouldDrop);
        hoodieConfig.setValue(DataSourceWriteOptions$.MODULE$.INSERT_DUP_POLICY().key(), DataSourceWriteOptions$.MODULE$.DROP_INSERT_DUP_POLICY());
        shouldDrop = HoodieSparkSqlWriterInternal$.MODULE$.shouldDropDuplicatesForInserts(hoodieConfig);
        Assertions.assertTrue((boolean)shouldDrop);
    }

    @Test
    public void testShouldFailWhenDuplicatesFound() {
        HoodieConfig hoodieConfig = new HoodieConfig();
        boolean shouldFail = HoodieSparkSqlWriterInternal$.MODULE$.shouldFailWhenDuplicatesFound(hoodieConfig);
        Assertions.assertFalse((boolean)shouldFail);
        hoodieConfig.setValue(DataSourceWriteOptions$.MODULE$.INSERT_DUP_POLICY().key(), DataSourceWriteOptions$.MODULE$.FAIL_INSERT_DUP_POLICY());
        shouldFail = HoodieSparkSqlWriterInternal$.MODULE$.shouldFailWhenDuplicatesFound(hoodieConfig);
        Assertions.assertTrue((boolean)shouldFail);
    }

    @Test
    public void testIsDeduplicationRequired() {
        HoodieConfig hoodieConfig = new HoodieConfig();
        boolean isRequired = HoodieSparkSqlWriterInternal$.MODULE$.isDeduplicationRequired(hoodieConfig);
        Assertions.assertFalse((boolean)isRequired);
        hoodieConfig.setValue(DataSourceWriteOptions$.MODULE$.INSERT_DUP_POLICY().key(), DataSourceWriteOptions$.MODULE$.FAIL_INSERT_DUP_POLICY());
        isRequired = HoodieSparkSqlWriterInternal$.MODULE$.isDeduplicationRequired(hoodieConfig);
        Assertions.assertTrue((boolean)isRequired);
        hoodieConfig.setValue(DataSourceWriteOptions$.MODULE$.INSERT_DUP_POLICY().key(), DataSourceWriteOptions$.MODULE$.DROP_INSERT_DUP_POLICY());
        isRequired = HoodieSparkSqlWriterInternal$.MODULE$.isDeduplicationRequired(hoodieConfig);
        Assertions.assertTrue((boolean)isRequired);
        hoodieConfig.setValue(DataSourceWriteOptions$.MODULE$.INSERT_DUP_POLICY().key(), "");
        hoodieConfig.setValue(DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS().key(), "true");
        isRequired = HoodieSparkSqlWriterInternal$.MODULE$.isDeduplicationRequired(hoodieConfig);
        Assertions.assertTrue((boolean)isRequired);
    }

    @Test
    public void testIsDeduplicationNeeded() {
        Assertions.assertFalse((boolean)HoodieSparkSqlWriterInternal$.MODULE$.isDeduplicationNeeded(WriteOperationType.INSERT_OVERWRITE));
        Assertions.assertFalse((boolean)HoodieSparkSqlWriterInternal$.MODULE$.isDeduplicationNeeded(WriteOperationType.INSERT_OVERWRITE_TABLE));
        Assertions.assertFalse((boolean)HoodieSparkSqlWriterInternal$.MODULE$.isDeduplicationNeeded(WriteOperationType.UPSERT));
        Assertions.assertFalse((boolean)HoodieSparkSqlWriterInternal$.MODULE$.isDeduplicationNeeded(WriteOperationType.INSERT_PREPPED));
        Assertions.assertTrue((boolean)HoodieSparkSqlWriterInternal$.MODULE$.isDeduplicationNeeded(WriteOperationType.INSERT));
    }

    private Schema fetchActualSchema() {
        HoodieTableMetaClient tableMetaClient = HoodieClientTestUtils.createMetaClient((SparkSession)this.spark(), (String)this.tempBasePath());
        return new TableSchemaResolver(tableMetaClient).getTableAvroSchema(false);
    }

    public static final /* synthetic */ boolean $anonfun$testBulkInsertWithSortMode$3(Row entry) {
        return !entry.mkString(",").equals("");
    }

    public static final /* synthetic */ void $anonfun$testBulkInsertForDropPartitionColumn$1(Row row) {
        Assertions.assertNotNull((Object)row);
    }

    public static final /* synthetic */ void $anonfun$testBulkInsertForDropPartitionColumn$3(Row row) {
        Assertions.assertNull((Object)row.get(0));
    }

    public static final /* synthetic */ void $anonfun$testIncrementalViewWithReplacement$1(TestHoodieSparkSqlWriter $this, String tableType) {
        String baseBootStrapPath = ((Object)$this.tempBootStrapPath().toAbsolutePath()).toString();
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"col3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"keyid"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)"org.apache.hudi.keygen.NonpartitionedKeyGenerator"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"false")}));
        Dataset df = $this.spark().range(0L, 1000L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keyid"})).withColumn("col3", functions$.MODULE$.expr("keyid")).withColumn("age", functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))).withColumn("p", functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2)));
        df.write().format("hudi").options((Map)options).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), "insert").option("hoodie.insert.shuffle.parallelism", "4").mode(SaveMode.Overwrite).save($this.tempBasePath());
        df.write().format("hudi").options((Map)options).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), "insert_overwrite_table").option("hoodie.insert.shuffle.parallelism", "4").mode(SaveMode.Append).save($this.tempBasePath());
        String[] currentCommits = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().read().format("hudi").load($this.tempBasePath()).select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).take(1))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        long incrementalKeyIdNum = $this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.START_COMMIT().key(), "0000").option(DataSourceReadOptions$.MODULE$.END_COMMIT().key(), currentCommits[0]).load($this.tempBasePath()).select("keyid", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).orderBy("keyid", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count();
        Predef$.MODULE$.assert(incrementalKeyIdNum == 1000L);
        df.write().mode(SaveMode.Overwrite).save(baseBootStrapPath);
        $this.spark().emptyDataFrame().write().format("hudi").options((Map)options).option(HoodieBootstrapConfig.BASE_PATH.key(), baseBootStrapPath).option(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), NonpartitionedKeyGenerator.class.getCanonicalName()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BOOTSTRAP_OPERATION_OPT_VAL()).option(HoodieBootstrapConfig.PARALLELISM_VALUE.key(), "4").mode(SaveMode.Overwrite).save($this.tempBasePath());
        df.write().format("hudi").options((Map)options).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), "insert_overwrite_table").option("hoodie.insert.shuffle.parallelism", "4").mode(SaveMode.Append).save($this.tempBasePath());
        String[] currentCommitsBootstrap = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().read().format("hudi").load($this.tempBasePath()).select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).take(1))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        long incrementalKeyIdNumBootstrap = $this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.START_COMMIT().key(), "0000").option(DataSourceReadOptions$.MODULE$.END_COMMIT().key(), currentCommitsBootstrap[0]).load($this.tempBasePath()).select("keyid", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).orderBy("keyid", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count();
        Predef$.MODULE$.assert(incrementalKeyIdNumBootstrap == 1000L);
    }

    public static final /* synthetic */ boolean $anonfun$testDeletePartitionsV2$1(Row entry) {
        String partitionPath = entry.getString(1);
        return partitionPath.equals("2016/03/15") || partitionPath.equals("2015/03/16");
    }

    public static final /* synthetic */ boolean $anonfun$testDeletePartitionsV2$2(Row entry) {
        String partitionPath = entry.getString(3);
        return !partitionPath.equals("2015/03/17");
    }

    public static final /* synthetic */ void $anonfun$validateDataAndPartitionStats$5(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Buffer stats = (Buffer)tuple2._2();
            Assertions.assertEquals((int)2, (int)stats.size());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$testDeletePartitionsWithWildcard$1(Seq expectedPartitions$1, Row entry) {
        String partitionPath = entry.getString(3);
        return expectedPartitions$1.count((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)partitionPath.equals(p))) != 1;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletePartitionsWithWrongPartition$1(Row entry) {
        String partitionPath = entry.getString(3);
        return ((TraversableOnce)new .colon.colon((Object)"2015/03/16", (List)new .colon.colon((Object)"2015/03/17", (List)Nil$.MODULE$))).count((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)partitionPath.equals(p))) != 1;
    }
}

