/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.util.List;
import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieSparkSqlWriter$;
import org.apache.hudi.HoodieSparkWriterTestBase;
import org.apache.hudi.avro.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.config.HoodieTTLConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.testutils.DataSourceTestUtils;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00192Aa\u0001\u0003\u0001\u0017!)\u0001\u0003\u0001C\u0001#!)1\u0003\u0001C\u0001)\t!C+Z:u\u0011>|G-[3Ta\u0006\u00148nU9m/JLG/\u001a:QCJ$\u0018\u000e^5p]R#FJ\u0003\u0002\u0006\r\u0005!\u0001.\u001e3j\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001b9i\u0011\u0001B\u0005\u0003\u001f\u0011\u0011\u0011\u0004S8pI&,7\u000b]1sW^\u0013\u0018\u000e^3s)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012A\u0005\t\u0003\u001b\u0001\t!\u0005^3tiN\u0003\u0018M]6Tc2<&/\u001b;fe^KG\u000f\u001b)beRLG/[8o)RcE#A\u000b\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005q\u0001\"!\b\u0013\u000e\u0003yQ!a\b\u0011\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\"E\u00059!.\u001e9ji\u0016\u0014(BA\u0012\t\u0003\u0015QWO\\5u\u0013\t)cD\u0001\u0003UKN$\b")
public class TestHoodieSparkSqlWriterPartitionTTL
extends HoodieSparkWriterTestBase {
    @Test
    public void testSparkSqlWriterWithPartitionTTL() {
        String hoodieFooTableName = "hoodie_foo_tbl";
        Map fooTableModifier = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.tempBasePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)hoodieFooTableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.BASE_FILE_FORMAT.key()), (Object)HoodieFileFormat.PARQUET.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()), (Object)DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTableConfig.POPULATE_META_FIELDS.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTTLConfig.INLINE_PARTITION_TTL.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTTLConfig.DAYS_RETAIN.key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTTLConfig.PARTITION_TTL_STRATEGY_CLASS_NAME.key()), (Object)"org.apache.hudi.HoodieSparkSqlWriterTestStrategy")}));
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        List<Row> recordsForPart1 = DataSourceTestUtils.generateRandomRowsByPartition(100, "part1");
        Seq<Row> recordsSeqForPart1 = this.convertRowListToSeq(recordsForPart1);
        SparkContext qual$1 = this.sc();
        Seq<Row> x$1 = recordsSeqForPart1;
        int x$2 = qual$1.parallelize$default$2();
        Dataset part1DF = this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), structType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, part1DF, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
        List<Row> recordsForPart2 = DataSourceTestUtils.generateRandomRowsByPartition(100, "part2");
        Seq<Row> recordsSeqForPart2 = this.convertRowListToSeq(recordsForPart2);
        SparkContext qual$2 = this.sc();
        Seq<Row> x$3 = recordsSeqForPart2;
        int x$4 = qual$2.parallelize$default$2();
        Dataset part2DF = this.spark().createDataFrame(qual$2.parallelize(x$3, x$4, ClassTag$.MODULE$.apply(Row.class)), structType);
        HoodieSparkSqlWriter$.MODULE$.write(this.sqlContext(), SaveMode.Append, fooTableModifier, part2DF, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
        HoodieActiveTimeline timeline = HoodieTestUtils.createMetaClient((String)this.tempBasePath()).getActiveTimeline();
        Predef$.MODULE$.assert(timeline.getCompletedReplaceTimeline().getInstants().size() > 0);
        HoodieInstant replaceInstant = (HoodieInstant)timeline.getCompletedReplaceTimeline().getInstants().get(0);
        HoodieReplaceCommitMetadata replaceMetadata = timeline.readReplaceCommitMetadataToAvro(replaceInstant);
        Predef$.MODULE$.assert(replaceMetadata.getPartitionToReplaceFileIds().containsKey("part1"));
    }
}

