/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.SparkVersionsSupport;
import org.apache.hudi.TestHoodieSparkUtils$;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.testutils.DataSourceTestUtils;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\u0007\u000f\u0001UAQ\u0001\b\u0001\u0005\u0002uAQ\u0001\t\u0001\u0005\u0002\u0005BQA\u0014\u0001\u0005\u0002=CQa\u0016\u0001\u0005\u0002=CQ!\u0017\u0001\u0005\u0002i;QA\u001e\b\t\u0002]4Q!\u0004\b\t\u0002aDQ\u0001H\u0004\u0005\u0002eDQA_\u0004\u0005\u0002mDq!!\b\b\t\u0003\ty\u0002C\u0004\u0002&\u001d!\t!a\n\t\u000f\u0005-s\u0001\"\u0001\u0002N\t!B+Z:u\u0011>|G-[3Ta\u0006\u00148.\u0016;jYNT!a\u0004\t\u0002\t!,H-\u001b\u0006\u0003#I\ta!\u00199bG\",'\"A\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002=A\u0011q\u0004A\u0007\u0002\u001d\u0005AB/Z:u'B\f'o\u001b,feNLwN\\\"iK\u000e\\WM]:\u0015\u0005\t*\u0003CA\f$\u0013\t!\u0003D\u0001\u0003V]&$\b\"\u0002\u0014\u0003\u0001\u00049\u0013\u0001D:qCJ\\g+\u001a:tS>t\u0007C\u0001\u00150\u001d\tIS\u0006\u0005\u0002+15\t1F\u0003\u0002-)\u00051AH]8pizJ!A\f\r\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0014G\u0001\u0004TiJLgn\u001a\u0006\u0003]aACAA\u001a@\u0001B\u0011A'P\u0007\u0002k)\u0011agN\u0001\taJ|g/\u001b3fe*\u0011\u0001(O\u0001\u0007a\u0006\u0014\u0018-\\:\u000b\u0005iZ\u0014a\u00026va&$XM\u001d\u0006\u0003yI\tQA[;oSRL!AP\u001b\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\u0011\t5)R$\"\u0003\t\u000bQa\r\u00184]A\n\u0013\u0001R\u0001\u0006g9\u001adFM\u0011\u0002\r\u0006)1G\f\u001b/a\u0005\n\u0001*A\u00034]Ur\u0003\u0007\u000b\u0002\u0003\u0015B\u00111\nT\u0007\u0002o%\u0011Qj\u000e\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018a\u0006;fgR\u001c%/Z1uKJ#GmU2iK6\fWI^8m)\u0005\u0011\u0003FA\u0002R!\t\u0011V+D\u0001T\u0015\t!\u0016(A\u0002ba&L!AV*\u0003\tQ+7\u000f^\u0001\u001fi\u0016\u001cHo\u0011:fCR,'\u000b\u001a3XSRDg*Z:uK\u0012\u001c6\r[3nCND#\u0001B)\u0002'\r|gN^3siJ{w\u000fT5tiR{7+Z9\u0015\u0005mc\u0007c\u0001/bI:\u0011Ql\u0018\b\u0003UyK\u0011!G\u0005\u0003Ab\tq\u0001]1dW\u0006<W-\u0003\u0002cG\n\u00191+Z9\u000b\u0005\u0001D\u0002CA3k\u001b\u00051'BA4i\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003SB\tQa\u001d9be.L!a\u001b4\u0003\u0007I{w\u000fC\u0003n\u000b\u0001\u0007a.A\u0005j]B,H\u000fT5tiB\u0019q\u000e\u001e3\u000e\u0003AT!!\u001d:\u0002\tU$\u0018\u000e\u001c\u0006\u0002g\u0006!!.\u0019<b\u0013\t)\bO\u0001\u0003MSN$\u0018\u0001\u0006+fgRDun\u001c3jKN\u0003\u0018M]6Vi&d7\u000f\u0005\u0002 \u000fM\u0011qA\u0006\u000b\u0002o\u0006q1/\u001a;Ok2d\u0017M\u00197f%\u0016\u001cGc\u0002?\u0002\u0006\u0005%\u00111\u0003\t\u0004{\u0006\u0005Q\"\u0001@\u000b\u0005}4\u0017!\u0002;za\u0016\u001c\u0018bAA\u0002}\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\r\u0005\u001d\u0011\u00021\u0001}\u0003)\u0019HO];diRK\b/\u001a\u0005\b\u0003\u0017I\u0001\u0019AA\u0007\u0003)\u0019w\u000e\\;n]:\u000bW.\u001a\t\u0005/\u0005=q%C\u0002\u0002\u0012a\u0011Q!\u0011:sCfDq!!\u0006\n\u0001\u0004\t9\"A\u0003j]\u0012,\u0007\u0010E\u0002\u0018\u00033I1!a\u0007\u0019\u0005\rIe\u000e^\u0001\u001bO\u0016$8k\u00195f[\u0006\u001cu\u000e\\;n]:{GOT;mY\u0006\u0014G.\u001a\u000b\u0006y\u0006\u0005\u00121\u0005\u0005\u0007\u0003\u000fQ\u0001\u0019\u0001?\t\r\u0005-!\u00021\u0001(\u0003Q\u0019X\r^\"pYVlgNT8u\u001dVdG.\u00192mKR1\u0011\u0011FA#\u0003\u0013\u0002B!a\u000b\u0002@9!\u0011QFA\u001f\u001d\u0011\ty#a\u000f\u000f\t\u0005E\u0012\u0011\b\b\u0005\u0003g\t9DD\u0002+\u0003kI\u0011aE\u0005\u0003#II!!\u001b\t\n\u0005\u001dD\u0017B\u00011g\u0013\u0011\t\t%a\u0011\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u00011g\u0011\u001d\t9e\u0003a\u0001\u0003S\t!\u0001\u001a4\t\r\u0005-1\u00021\u0001(\u00039!'o\u001c9NKR\fg)[3mIN$B!!\u000b\u0002P!9\u0011q\t\u0007A\u0002\u0005%\u0002")
public class TestHoodieSparkUtils {
    public static Dataset<Row> dropMetaFields(Dataset<Row> dataset) {
        return TestHoodieSparkUtils$.MODULE$.dropMetaFields(dataset);
    }

    public static Dataset<Row> setColumnNotNullable(Dataset<Row> dataset, String string) {
        return TestHoodieSparkUtils$.MODULE$.setColumnNotNullable(dataset, string);
    }

    public static StructType getSchemaColumnNotNullable(StructType structType, String string) {
        return TestHoodieSparkUtils$.MODULE$.getSchemaColumnNotNullable(structType, string);
    }

    public static StructType setNullableRec(StructType structType, String[] stringArray, int n) {
        return TestHoodieSparkUtils$.MODULE$.setNullableRec(structType, stringArray, n);
    }

    @ParameterizedTest
    @ValueSource(strings={"3.3.0", "3.3.2", "3.4.0", "3.5.0"})
    public void testSparkVersionCheckers(String sparkVersion) {
        SparkVersionsSupport vsMock = new SparkVersionsSupport(null, sparkVersion){
            private final String sparkVersion$1;

            public boolean isSpark3() {
                return SparkVersionsSupport.isSpark3$((SparkVersionsSupport)this);
            }

            public boolean isSpark3_3() {
                return SparkVersionsSupport.isSpark3_3$((SparkVersionsSupport)this);
            }

            public boolean isSpark3_4() {
                return SparkVersionsSupport.isSpark3_4$((SparkVersionsSupport)this);
            }

            public boolean isSpark3_5() {
                return SparkVersionsSupport.isSpark3_5$((SparkVersionsSupport)this);
            }

            public boolean gteqSpark3_3_2() {
                return SparkVersionsSupport.gteqSpark3_3_2$((SparkVersionsSupport)this);
            }

            public boolean gteqSpark3_4() {
                return SparkVersionsSupport.gteqSpark3_4$((SparkVersionsSupport)this);
            }

            public boolean gteqSpark3_5() {
                return SparkVersionsSupport.gteqSpark3_5$((SparkVersionsSupport)this);
            }

            public String getSparkVersion() {
                return this.sparkVersion$1;
            }
            {
                this.sparkVersion$1 = sparkVersion$1;
                SparkVersionsSupport.$init$((SparkVersionsSupport)this);
            }
        };
        String string = sparkVersion;
        if ("3.3.0".equals(string)) {
            Assertions.assertTrue((boolean)vsMock.isSpark3());
            Assertions.assertTrue((boolean)vsMock.isSpark3_3());
            Assertions.assertFalse((boolean)vsMock.isSpark3_4());
            Assertions.assertFalse((boolean)vsMock.isSpark3_5());
            Assertions.assertFalse((boolean)vsMock.gteqSpark3_3_2());
            Assertions.assertFalse((boolean)vsMock.gteqSpark3_4());
            Assertions.assertFalse((boolean)vsMock.gteqSpark3_5());
            return;
        }
        if ("3.3.2".equals(string)) {
            Assertions.assertTrue((boolean)vsMock.isSpark3());
            Assertions.assertTrue((boolean)vsMock.isSpark3_3());
            Assertions.assertTrue((boolean)vsMock.gteqSpark3_3_2());
            Assertions.assertFalse((boolean)vsMock.isSpark3_4());
            Assertions.assertFalse((boolean)vsMock.isSpark3_5());
            Assertions.assertFalse((boolean)vsMock.gteqSpark3_4());
            Assertions.assertFalse((boolean)vsMock.gteqSpark3_5());
            return;
        }
        if ("3.4.0".equals(string)) {
            Assertions.assertTrue((boolean)vsMock.isSpark3());
            Assertions.assertTrue((boolean)vsMock.isSpark3_4());
            Assertions.assertTrue((boolean)vsMock.gteqSpark3_3_2());
            Assertions.assertTrue((boolean)vsMock.gteqSpark3_4());
            Assertions.assertFalse((boolean)vsMock.isSpark3_3());
            Assertions.assertFalse((boolean)vsMock.isSpark3_5());
            return;
        }
        if ("3.5.0".equals(string)) {
            Assertions.assertTrue((boolean)vsMock.isSpark3());
            Assertions.assertTrue((boolean)vsMock.isSpark3_5());
            Assertions.assertTrue((boolean)vsMock.gteqSpark3_3_2());
            Assertions.assertTrue((boolean)vsMock.gteqSpark3_4());
            Assertions.assertTrue((boolean)vsMock.gteqSpark3_5());
            Assertions.assertFalse((boolean)vsMock.isSpark3_3());
            Assertions.assertFalse((boolean)vsMock.isSpark3_4());
            return;
        }
        throw new MatchError((Object)string);
    }

    @Test
    public void testCreateRddSchemaEvol() {
        SparkSession spark = SparkSession$.MODULE$.builder().config(HoodieClientTestUtils.getSparkConfForTest((String)"Hoodie Datasource test")).getOrCreate();
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        java.util.List<Row> records = DataSourceTestUtils.generateRandomRows(5);
        Seq<Row> recordsSeq = this.convertRowListToSeq(records);
        Dataset df1 = spark.createDataFrame(spark.sparkContext().parallelize(recordsSeq, spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class)), structType);
        RDD genRecRDD = HoodieSparkUtils$.MODULE$.createRdd(df1, "test_struct_name", "test_namespace", true, Option.of((Object)schema));
        genRecRDD.collect();
        Schema evolSchema = DataSourceTestUtils.getStructTypeExampleEvolvedSchema();
        records = DataSourceTestUtils.generateRandomRowsEvolvedSchema(5);
        recordsSeq = this.convertRowListToSeq(records);
        genRecRDD = HoodieSparkUtils$.MODULE$.createRdd(df1, "test_struct_name", "test_namespace", true, Option.of((Object)evolSchema));
        genRecRDD.collect();
        genRecRDD = HoodieSparkUtils$.MODULE$.createRdd(df1, "test_struct_name", "test_namespace", true, Option.of((Object)evolSchema));
        GenericRecord[] genRecs = (GenericRecord[])genRecRDD.collect();
        Assertions.assertEquals((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])genRecs)).size(), (int)5);
        spark.stop();
    }

    @Test
    public void testCreateRddWithNestedSchemas() {
        Object object;
        SparkSession spark = SparkSession$.MODULE$.builder().config(HoodieClientTestUtils.getSparkConfForTest((String)"Hoodie Datasource test")).getOrCreate();
        StructType innerStruct1 = new StructType().add("innerKey", "string", false).add("innerValue", "long", true);
        StructType structType1 = new StructType().add("key", "string", false).add("nonNullableInnerStruct", (DataType)innerStruct1, false).add("nullableInnerStruct", (DataType)innerStruct1, true);
        Schema schema1 = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)structType1, "test_struct_name", "test_namespace");
        Seq records1 = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"key1", Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"innerKey1_1", BoxesRunTime.boxToLong((long)1L)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"innerKey1_2", BoxesRunTime.boxToLong((long)2L)}))})), (List)Nil$.MODULE$);
        Dataset df1 = spark.createDataFrame(spark.sparkContext().parallelize(records1, spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class)), structType1);
        RDD genRecRDD1 = HoodieSparkUtils$.MODULE$.createRdd(df1, "test_struct_name", "test_namespace", true, Option.of((Object)schema1));
        Predef$.MODULE$.assert(schema1.equals((Object)((GenericRecord[])genRecRDD1.collect())[0].getSchema()));
        StructType structType2 = new StructType().add("key", "string", false).add("nonNullableInnerStruct", (DataType)innerStruct1, false).add("nullableInnerStruct", (DataType)innerStruct1, true).add("nullableInnerStruct2", (DataType)innerStruct1, true);
        Schema schema2 = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)structType2, "test_struct_name", "test_namespace");
        Seq records2 = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"key2", Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"innerKey2_1", BoxesRunTime.boxToLong((long)2L)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"innerKey2_2", BoxesRunTime.boxToLong((long)2L)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"innerKey2_3", BoxesRunTime.boxToLong((long)2L)}))})), (List)Nil$.MODULE$);
        Dataset df2 = spark.createDataFrame(spark.sparkContext().parallelize(records2, spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class)), structType2);
        RDD genRecRDD2 = HoodieSparkUtils$.MODULE$.createRdd(df2, "test_struct_name", "test_namespace", true, Option.of((Object)schema2));
        Predef$.MODULE$.assert(schema2.equals((Object)((GenericRecord[])genRecRDD2.collect())[0].getSchema()));
        RDD genRecRDD3 = HoodieSparkUtils$.MODULE$.createRdd(df1, "test_struct_name", "test_namespace", true, Option.of((Object)schema2));
        Predef$.MODULE$.assert(((GenericRecord[])genRecRDD3.collect())[0].getSchema().equals((Object)schema2));
        genRecRDD3.foreach((Function1 & Serializable & scala.Serializable)entry -> {
            TestHoodieSparkUtils.$anonfun$testCreateRddWithNestedSchemas$1(entry);
            return BoxedUnit.UNIT;
        });
        StructType innerStruct3 = new StructType().add("innerKey", "string", false).add("innerValue", "long", true).add("new_nested_col", "string", true);
        StructType structType4 = new StructType().add("key", "string", false).add("nonNullableInnerStruct", (DataType)innerStruct1, false).add("nullableInnerStruct", (DataType)innerStruct3, true);
        Schema schema4 = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)structType4, "test_struct_name", "test_namespace");
        Seq records4 = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"key2", Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"innerKey2_1", BoxesRunTime.boxToLong((long)2L)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"innerKey2_2", BoxesRunTime.boxToLong((long)2L), "new_nested_col_val1"}))})), (List)Nil$.MODULE$);
        Dataset df4 = spark.createDataFrame(spark.sparkContext().parallelize(records4, spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class)), structType4);
        RDD genRecRDD4 = HoodieSparkUtils$.MODULE$.createRdd(df4, "test_struct_name", "test_namespace", true, Option.of((Object)schema4));
        Predef$.MODULE$.assert(schema4.equals((Object)((GenericRecord[])genRecRDD4.collect())[0].getSchema()));
        RDD genRecRDD5 = HoodieSparkUtils$.MODULE$.createRdd(df1, "test_struct_name", "test_namespace", true, Option.of((Object)schema4));
        Predef$.MODULE$.assert(schema4.equals((Object)((GenericRecord[])genRecRDD4.collect())[0].getSchema()));
        GenericRecord genRec = ((GenericRecord[])genRecRDD5.collect())[0];
        GenericRecord nestedRec = (GenericRecord)genRec.get("nullableInnerStruct");
        Assertions.assertNull((Object)nestedRec.get("new_nested_col"));
        Assertions.assertNotNull((Object)nestedRec.get("innerKey"));
        Assertions.assertNotNull((Object)nestedRec.get("innerValue"));
        StructType innerStruct4 = new StructType().add("innerKey", "string", false).add("innerValue", "long", true).add("new_nested_col", "string", false);
        StructType structType6 = new StructType().add("key", "string", false).add("nonNullableInnerStruct", (DataType)innerStruct1, false).add("nullableInnerStruct", (DataType)innerStruct4, true);
        Schema schema6 = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)structType6, "test_struct_name", "test_namespace");
        try {
            RDD genRecRDD6 = HoodieSparkUtils$.MODULE$.createRdd(df1, "test_struct_name", "test_namespace", true, Option.of((Object)schema6));
            genRecRDD6.collect();
            object = Assertions.fail((String)"createRdd should fail, because records don't have a column which is not nullable in the passed in schema");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Field nullableInnerStruct.new_nested_col has no default value and is non-nullable"));
            object = BoxedUnit.UNIT;
        }
        spark.stop();
    }

    public Seq<Row> convertRowListToSeq(java.util.List<Row> inputList) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(inputList.iterator()).asScala()).toSeq();
    }

    public static final /* synthetic */ void $anonfun$testCreateRddWithNestedSchemas$1(GenericRecord entry) {
        Assertions.assertNull((Object)entry.get("nullableInnerStruct2"));
    }
}

