/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.util.List;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.testutils.HoodieSparkClientTestBase;
import org.apache.spark.api.java.JavaRDD;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestMetadataTableSupport
extends HoodieSparkClientTestBase {
    TestMetadataTableSupport() {
    }

    @BeforeEach
    void start() throws Exception {
        super.setUp();
    }

    @AfterEach
    void end() throws Exception {
        super.tearDown();
    }

    @Test
    void testRecreateMDTForInsertOverwriteTableOperation() {
        HoodieWriteConfig config = this.getConfigBuilder().withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).withEnableRecordIndex(true).build()).build();
        try (SparkRDDWriteClient writeClient = this.getHoodieWriteClient(config);){
            String timestamp0 = "20241015000000000";
            List records0 = this.dataGen.generateInserts(timestamp0, Integer.valueOf(100));
            JavaRDD dataset0 = this.jsc.parallelize(records0, 2);
            writeClient.startCommitWithTime(timestamp0);
            writeClient.insert(dataset0, timestamp0).collect();
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            Assertions.assertTrue((boolean)this.metaClient.getTableConfig().isMetadataTableAvailable());
            StoragePath mdtBasePath = HoodieTableMetadata.getMetadataTableBasePath((StoragePath)this.metaClient.getBasePath());
            HoodieTableMetaClient mdtMetaClient = HoodieTableMetaClient.builder().setConf(this.storageConf.newInstance()).setBasePath(mdtBasePath).build();
            HoodieActiveTimeline timeline = mdtMetaClient.getActiveTimeline();
            List instants = timeline.getInstants();
            Assertions.assertEquals((int)5, (int)instants.size());
            Assertions.assertEquals((Object)"00000000000000000", (Object)((HoodieInstant)instants.get(0)).requestedTime());
            Assertions.assertEquals((Object)"00000000000000001", (Object)((HoodieInstant)instants.get(1)).requestedTime());
            Assertions.assertEquals((Object)"00000000000000002", (Object)((HoodieInstant)instants.get(2)).requestedTime());
            Assertions.assertEquals((Object)"00000000000000003", (Object)((HoodieInstant)instants.get(3)).requestedTime());
            Assertions.assertEquals((Object)timestamp0, (Object)((HoodieInstant)instants.get(4)).requestedTime());
            String timestamp1 = "20241015000000001";
            List records1 = this.dataGen.generateInserts(timestamp1, Integer.valueOf(50));
            JavaRDD dataset1 = this.jsc.parallelize(records1, 2);
            writeClient.startCommitWithTime(timestamp1, "replacecommit");
            writeClient.insertOverwriteTable(dataset1, timestamp1);
            mdtMetaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)mdtMetaClient);
            timeline = mdtMetaClient.getActiveTimeline();
            instants = timeline.getInstants();
            Assertions.assertEquals((int)5, (int)timeline.getInstants().size());
            Assertions.assertEquals((Object)"00000000000000000", (Object)((HoodieInstant)instants.get(0)).requestedTime());
            Assertions.assertEquals((Object)"00000000000000001", (Object)((HoodieInstant)instants.get(1)).requestedTime());
            Assertions.assertEquals((Object)"00000000000000002", (Object)((HoodieInstant)instants.get(2)).requestedTime());
            Assertions.assertEquals((Object)"00000000000000003", (Object)((HoodieInstant)instants.get(3)).requestedTime());
            Assertions.assertEquals((Object)timestamp1, (Object)((HoodieInstant)instants.get(4)).requestedTime());
        }
    }
}

