/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import org.apache.hudi.HoodieSparkWriterTestBase;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001%2A\u0001B\u0003\u0001\u0019!)\u0011\u0003\u0001C\u0001%!)A\u0003\u0001C\u0001+!)q\u0005\u0001C\u0001+\tyB+Z:u\u001bVdG/\u001b9mKR\u000b'\r\\3WKJ\u001c\u0018n\u001c8Xe&$\u0018N\\4\u000b\u0005\u00199\u0011\u0001\u00025vI&T!\u0001C\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0011aA8sO\u000e\u00011C\u0001\u0001\u000e!\tqq\"D\u0001\u0006\u0013\t\u0001RAA\rI_>$\u0017.Z*qCJ\\wK]5uKJ$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001\u0014!\tq\u0001!A\u0014uKN$H+\u00192mKZ+'o]5p]\u0006sGm\u0016:ji\u00164VM]:j_:l\u0015\r^2iS:<G#\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005u\u0001\"AH\u0013\u000e\u0003}Q!\u0001I\u0011\u0002\u0007\u0005\u0004\u0018N\u0003\u0002#G\u00059!.\u001e9ji\u0016\u0014(B\u0001\u0013\n\u0003\u0015QWO\\5u\u0013\t1sD\u0001\u0003UKN$\u0018A\f;fgR$\u0006N]8xg\u0016C8-\u001a9uS>tgi\u001c:J]\u000e|W\u000e]1uS\ndW\rV1cY\u00164VM]:j_:D#aA\u000f")
public class TestMultipleTableVersionWriting
extends HoodieSparkWriterTestBase {
    @Test
    public void testTableVersionAndWriteVersionMatching() {
        String basePath = new StringBuilder(6).append(this.tempBasePath()).append("/tbl_1").toString();
        Dataset df = this.spark().range(1L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1 as id", "1 as name", "1 as partition"}));
        df.write().format("hudi").option(HoodieWriteConfig.TBL_NAME.key(), "tbl_1").mode(SaveMode.Overwrite).save(basePath);
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((String)basePath);
        Assertions.assertEquals((int)HoodieTableVersion.current().versionCode(), (int)metaClient.getTableConfig().getTableVersion().versionCode());
    }

    @Test
    public void testThrowsExceptionForIncompatibleTableVersion() {
        String basePath = new StringBuilder(6).append(this.tempBasePath()).append("/tbl_2").toString();
        HoodieTestUtils.init((String)basePath, (HoodieTableType)HoodieTableType.COPY_ON_WRITE, (HoodieTableVersion)HoodieTableVersion.SIX);
        Dataset df = this.spark().range(1L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1 as id", "1 as name", "1 as partition"}));
        df.write().format("hudi").mode(SaveMode.Append).save(basePath);
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((String)basePath);
        Assertions.assertEquals((int)HoodieTableVersion.current().versionCode(), (int)metaClient.getTableConfig().getTableVersion().versionCode());
    }
}

