/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.functional;

import com.codahale.metrics.Gauge;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanPartitionMetadata;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.avro.model.HoodieMetadataRecord;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.client.functional.TestHoodieMetadataBase;
import org.apache.hudi.client.transaction.lock.InProcessLockProvider;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordGlobalLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.TableServiceType;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.table.view.TableFileSystemView;
import org.apache.hudi.common.testutils.FileCreateUtilsLegacy;
import org.apache.hudi.common.testutils.HoodieMetadataTestTable;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.InProcessTimeGenerator;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.common.util.collection.Triple;
import org.apache.hudi.common.util.hash.ColumnIndexID;
import org.apache.hudi.common.util.hash.PartitionIndexID;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.io.storage.HoodieAvroFileReader;
import org.apache.hudi.io.storage.HoodieAvroHFileReaderImplBase;
import org.apache.hudi.io.storage.HoodieSparkIOFactory;
import org.apache.hudi.metadata.FileSystemBackedTableMetadata;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieBackedTableMetadataWriter;
import org.apache.hudi.metadata.HoodieMetadataLogRecordReader;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.metadata.SparkHoodieBackedTableMetadataWriter;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.upgrade.SparkUpgradeDowngradeHelper;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeDowngrade;
import org.apache.hudi.testutils.Assertions;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.hudi.testutils.MetadataMergeWriteStatus;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SQLContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="functional")
public class TestHoodieBackedMetadata
extends TestHoodieMetadataBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestHoodieBackedMetadata.class);
    private final List<BaseHoodieWriteClient> clientsToClose = new ArrayList<BaseHoodieWriteClient>();

    public static List<Arguments> tableTypeAndEnableOperationArgs() {
        return Arrays.asList(Arguments.of((Object[])new Object[]{HoodieTableType.COPY_ON_WRITE, true}), Arguments.of((Object[])new Object[]{HoodieTableType.COPY_ON_WRITE, false}), Arguments.of((Object[])new Object[]{HoodieTableType.MERGE_ON_READ, true}), Arguments.of((Object[])new Object[]{HoodieTableType.MERGE_ON_READ, false}));
    }

    public static List<Arguments> tableOperationsTestArgs() {
        return Arrays.asList(Arguments.of((Object[])new Object[]{HoodieTableType.COPY_ON_WRITE, true}), Arguments.of((Object[])new Object[]{HoodieTableType.COPY_ON_WRITE, false}), Arguments.of((Object[])new Object[]{HoodieTableType.MERGE_ON_READ, true}), Arguments.of((Object[])new Object[]{HoodieTableType.MERGE_ON_READ, false}));
    }

    @AfterEach
    public void closeClients() {
        this.clientsToClose.forEach(BaseHoodieWriteClient::close);
    }

    @ParameterizedTest
    @MethodSource(value={"tableTypeAndEnableOperationArgs"})
    public void testMetadataTableBootstrap(HoodieTableType tableType, boolean addRollback) throws Exception {
        this.init(tableType, false);
        this.doPreBootstrapOperations(testTable);
        this.writeConfig = this.getWriteConfig(true, true);
        this.initWriteConfigAndMetatableWriter(this.writeConfig, true);
        this.syncTableMetadata(this.writeConfig);
        this.validateMetadata(testTable);
        this.doWriteInsertAndUpsert(testTable, "0000003", "0000004", false);
        this.validateMetadata(testTable);
        if (addRollback) {
            this.doWriteOperationAndValidate(testTable, "0000005");
            this.doRollbackAndValidate(testTable, "0000005", "0000006");
        }
        this.doWriteOperation(testTable, "0000007");
        this.doWriteOperation(testTable, "0000008");
        this.doWriteOperation(testTable, "0000009");
        this.doCleanAndValidate(testTable, "0000010", Arrays.asList("0000009"));
        this.validateMetadata(testTable, true);
    }

    @Test
    public void testTurnOffMetadataIndexAfterEnable() throws Exception {
        Object commitTime4;
        Object commitTime22;
        Object records;
        this.initPath();
        HoodieWriteConfig cfg = this.getConfigBuilder("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", HoodieIndex.IndexType.BLOOM, HoodieFailedWritesCleaningPolicy.EAGER).withParallelism(1, 1).withBulkInsertParallelism(1).withFinalizeWriteParallelism(1).withDeleteParallelism(1).withConsistencyGuardConfig(ConsistencyGuardConfig.newBuilder().withConsistencyCheckEnabled(true).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).build()).build();
        this.init(HoodieTableType.COPY_ON_WRITE);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, cfg);){
            String commitTime3 = "0000001";
            records = this.dataGen.generateInserts(commitTime3, Integer.valueOf(20));
            client.startCommitWithTime(commitTime3);
            List writeStatuses = client.insert(this.jsc.parallelize((List)records, 1), commitTime3).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            commitTime3 = "0000002";
            client.startCommitWithTime(commitTime3);
            records = this.dataGen.generateUniqueUpdates(commitTime3, Integer.valueOf(10));
            writeStatuses = client.upsert(this.jsc.parallelize((List)records, 1), commitTime3).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            this.validateMetadata(client);
        }
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieTableConfig tableConfig = this.metaClient.getTableConfig();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)tableConfig.getMetadataPartitions().isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tableConfig.getMetadataPartitions().contains(MetadataPartitionType.FILES.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)tableConfig.getMetadataPartitions().contains(MetadataPartitionType.COLUMN_STATS.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)tableConfig.getMetadataPartitions().contains(MetadataPartitionType.BLOOM_FILTERS.getPartitionPath()));
        HoodieWriteConfig cfgWithColStatsEnabled = HoodieWriteConfig.newBuilder().withProperties((Properties)cfg.getProps()).withMetadataConfig(HoodieMetadataConfig.newBuilder().withProperties((Properties)cfg.getMetadataConfig().getProps()).withMetadataIndexColumnStats(true).build()).build();
        SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, cfgWithColStatsEnabled);
        records = null;
        try {
            commitTime22 = "0000003";
            client.startCommitWithTime((String)commitTime22);
            List records2 = this.dataGen.generateUniqueUpdates((String)commitTime22, Integer.valueOf(10));
            List writeStatuses = client.upsert(this.jsc.parallelize(records2, 1), (String)commitTime22).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            this.validateMetadata(client);
        }
        catch (Throwable commitTime22) {
            records = commitTime22;
            throw commitTime22;
        }
        finally {
            if (client != null) {
                if (records != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable commitTime22) {
                        ((Throwable)records).addSuppressed(commitTime22);
                    }
                } else {
                    client.close();
                }
            }
        }
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        tableConfig = this.metaClient.getTableConfig();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)tableConfig.getMetadataPartitions().isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tableConfig.getMetadataPartitions().contains(MetadataPartitionType.FILES.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tableConfig.getMetadataPartitions().contains(MetadataPartitionType.COLUMN_STATS.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)tableConfig.getMetadataPartitions().contains(MetadataPartitionType.BLOOM_FILTERS.getPartitionPath()));
        HoodieWriteConfig cfgWithColStatsDisabled = HoodieWriteConfig.newBuilder().withProperties((Properties)cfg.getProps()).withMetadataConfig(HoodieMetadataConfig.newBuilder().withProperties((Properties)cfg.getMetadataConfig().getProps()).withMetadataIndexColumnStats(false).build()).build();
        SparkRDDWriteClient client2 = new SparkRDDWriteClient((HoodieEngineContext)engineContext, cfgWithColStatsDisabled);
        commitTime22 = null;
        try {
            commitTime4 = "0000004";
            client2.startCommitWithTime((String)commitTime4);
            List records3 = this.dataGen.generateUniqueUpdates((String)commitTime4, Integer.valueOf(10));
            List writeStatuses = client2.upsert(this.jsc.parallelize(records3, 1), (String)commitTime4).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            this.validateMetadata(client2);
        }
        catch (Throwable commitTime4) {
            commitTime22 = commitTime4;
            throw commitTime4;
        }
        finally {
            if (client2 != null) {
                if (commitTime22 != null) {
                    try {
                        client2.close();
                    }
                    catch (Throwable commitTime4) {
                        ((Throwable)commitTime22).addSuppressed(commitTime4);
                    }
                } else {
                    client2.close();
                }
            }
        }
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        tableConfig = this.metaClient.getTableConfig();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)tableConfig.getMetadataPartitions().isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tableConfig.getMetadataPartitions().contains(MetadataPartitionType.FILES.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)tableConfig.getMetadataPartitions().contains(MetadataPartitionType.COLUMN_STATS.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)tableConfig.getMetadataPartitions().contains(MetadataPartitionType.BLOOM_FILTERS.getPartitionPath()));
        HoodieWriteConfig cfgWithBloomFilterEnabled = HoodieWriteConfig.newBuilder().withProperties((Properties)cfgWithColStatsEnabled.getProps()).withMetadataConfig(HoodieMetadataConfig.newBuilder().withProperties((Properties)cfgWithColStatsEnabled.getMetadataConfig().getProps()).withMetadataIndexBloomFilter(true).build()).build();
        SparkRDDWriteClient client3 = new SparkRDDWriteClient((HoodieEngineContext)engineContext, cfgWithBloomFilterEnabled);
        commitTime4 = null;
        try {
            String commitTime5 = "0000005";
            client3.startCommitWithTime(commitTime5);
            List records4 = this.dataGen.generateUniqueUpdates(commitTime5, Integer.valueOf(10));
            List writeStatuses = client3.upsert(this.jsc.parallelize(records4, 1), commitTime5).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            this.validateMetadata(client3);
        }
        catch (Throwable throwable) {
            commitTime4 = throwable;
            throw throwable;
        }
        finally {
            if (client3 != null) {
                if (commitTime4 != null) {
                    try {
                        client3.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)commitTime4).addSuppressed(throwable);
                    }
                } else {
                    client3.close();
                }
            }
        }
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        tableConfig = this.metaClient.getTableConfig();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)tableConfig.getMetadataPartitions().isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tableConfig.getMetadataPartitions().contains(MetadataPartitionType.FILES.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tableConfig.getMetadataPartitions().contains(MetadataPartitionType.COLUMN_STATS.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tableConfig.getMetadataPartitions().contains(MetadataPartitionType.BLOOM_FILTERS.getPartitionPath()));
        HoodieWriteConfig cfgWithMetadataDisabled = this.getConfigBuilder("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", HoodieIndex.IndexType.BLOOM, HoodieFailedWritesCleaningPolicy.EAGER).withParallelism(1, 1).withBulkInsertParallelism(1).withFinalizeWriteParallelism(1).withDeleteParallelism(1).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(false).build()).build();
        try (SparkRDDWriteClient client4 = new SparkRDDWriteClient((HoodieEngineContext)engineContext, cfgWithMetadataDisabled);){
            String commitTime6 = "0000006";
            client4.startCommitWithTime(commitTime6);
            List records5 = this.dataGen.generateUniqueUpdates(commitTime6, Integer.valueOf(10));
            List writeStatuses = client4.upsert(this.jsc.parallelize(records5, 1), commitTime6).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
        }
        tableConfig = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tableConfig.getMetadataPartitions().isEmpty());
    }

    @Test
    public void testTurnOffMetadataTableAfterEnable() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE, true);
        String instant1 = "0000001";
        HoodieCommitMetadata hoodieCommitMetadata = this.doWriteOperationWithMeta(testTable, instant1, WriteOperationType.INSERT);
        File metaForP1 = new File(this.metaClient.getBasePath() + "/p1", ".hoodie_partition_metadata");
        File metaForP2 = new File(this.metaClient.getBasePath() + "/p2", ".hoodie_partition_metadata");
        metaForP1.createNewFile();
        metaForP2.createNewFile();
        this.metaClient.reloadActiveTimeline();
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)this.writeConfig, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        Option metadataWriter = table.getMetadataWriter(instant1);
        this.validateMetadata(testTable, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)metadataWriter.isPresent());
        Triple inferredMergeConfs = HoodieTableConfig.inferCorrectMergingBehavior((RecordMergeMode)this.writeConfig.getRecordMergeMode(), (String)this.writeConfig.getPayloadClass(), (String)this.writeConfig.getRecordMergeStrategyId(), (String)this.writeConfig.getPreCombineField(), (HoodieTableVersion)this.metaClient.getTableConfig().getTableVersion());
        HoodieTableConfig hoodieTableConfig = new HoodieTableConfig(this.storage, this.metaClient.getMetaPath(), (RecordMergeMode)inferredMergeConfs.getLeft(), (String)inferredMergeConfs.getMiddle(), (String)inferredMergeConfs.getRight());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)hoodieTableConfig.getMetadataPartitions().isEmpty());
        HoodieWriteConfig writeConfig2 = HoodieWriteConfig.newBuilder().withProperties((Properties)this.writeConfig.getProps()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(false).build()).build();
        testTable = HoodieTestTable.of((HoodieTableMetaClient)this.metaClient);
        String instant2 = "0000002";
        HoodieCommitMetadata hoodieCommitMetadata2 = this.doWriteOperationWithMeta(testTable, instant2, WriteOperationType.INSERT);
        this.metaClient.reloadActiveTimeline();
        HoodieSparkTable table2 = HoodieSparkTable.create((HoodieWriteConfig)writeConfig2, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        Option metadataWriter2 = table2.getMetadataWriter(instant2);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)metadataWriter2.isPresent());
        Triple inferredMergeConfs2 = HoodieTableConfig.inferCorrectMergingBehavior((RecordMergeMode)writeConfig2.getRecordMergeMode(), (String)writeConfig2.getPayloadClass(), (String)writeConfig2.getRecordMergeStrategyId(), (String)writeConfig2.getPreCombineField(), (HoodieTableVersion)this.metaClient.getTableConfig().getTableVersion());
        HoodieTableConfig hoodieTableConfig2 = new HoodieTableConfig(this.storage, this.metaClient.getMetaPath(), (RecordMergeMode)inferredMergeConfs2.getLeft(), (String)inferredMergeConfs2.getMiddle(), (String)inferredMergeConfs2.getRight());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), (Object)hoodieTableConfig2.getMetadataPartitions());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.metaClient.getStorage().exists(new StoragePath(HoodieTableMetadata.getMetadataTableBasePath((String)writeConfig2.getBasePath()))));
        HoodieWriteConfig writeConfig3 = HoodieWriteConfig.newBuilder().withProperties((Properties)this.writeConfig.getProps()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).build()).build();
        testTable = HoodieTestTable.of((HoodieTableMetaClient)this.metaClient);
        this.metaClient.reloadActiveTimeline();
        String instant3 = "0000003";
        HoodieCommitMetadata hoodieCommitMetadata3 = this.doWriteOperationWithMeta(testTable, instant3, WriteOperationType.INSERT);
        this.metaClient.reloadActiveTimeline();
        HoodieSparkTable table3 = HoodieSparkTable.create((HoodieWriteConfig)writeConfig3, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        Option metadataWriter3 = table3.getMetadataWriter(instant3);
        this.validateMetadata(testTable, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)metadataWriter3.isPresent());
        HoodieTableConfig hoodieTableConfig3 = new HoodieTableConfig(this.storage, this.metaClient.getMetaPath(), null, null, null);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)hoodieTableConfig3.getMetadataPartitions().isEmpty());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testOnlyValidPartitionsAdded(HoodieTableType tableType) throws Exception {
        this.init(tableType, false);
        String nonPartitionDirectory = HoodieTestDataGenerator.DEFAULT_PARTITION_PATHS[0] + "-nonpartition";
        Files.createDirectories(Paths.get(this.basePath, nonPartitionDirectory), new FileAttribute[0]);
        Files.createFile(Paths.get(this.basePath, nonPartitionDirectory, "randomFile.parquet"), new FileAttribute[0]);
        String filterDirRegex = ".*-filterDir\\d|\\..*";
        String filteredDirectoryOne = HoodieTestDataGenerator.DEFAULT_PARTITION_PATHS[0] + "-filterDir1";
        String filteredDirectoryTwo = HoodieTestDataGenerator.DEFAULT_PARTITION_PATHS[0] + "-filterDir2";
        String filteredDirectoryThree = ".backups";
        testTable.withPartitionMetaFiles(new String[]{"p1", "p2", filteredDirectoryOne, filteredDirectoryTwo, ".backups"}).addCommit("0000001").withBaseFilesInPartition("p1", new int[]{10}).withBaseFilesInPartition("p2", new int[]{10, 10}).addCommit("0000002").withBaseFilesInPartition("p1", new int[]{10}).withBaseFilesInPartition("p2", new int[]{10, 10, 10});
        this.writeConfig = this.getWriteConfigBuilder(HoodieFailedWritesCleaningPolicy.NEVER, true, true, false).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).withDirectoryFilterRegex(".*-filterDir\\d|\\..*").build()).build();
        testTable.doWriteOperation("0000003", WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 1, true);
        this.syncTableMetadata(this.writeConfig);
        List partitions = this.metadataWriter(this.writeConfig).getTableMetadata().getAllPartitionPaths();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)partitions.contains(nonPartitionDirectory), (String)("Must not contain the non-partition " + nonPartitionDirectory));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)partitions.contains("p1"), (String)"Must contain partition p1");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)partitions.contains("p2"), (String)"Must contain partition p2");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)partitions.contains(filteredDirectoryOne), (String)("Must not contain the filtered directory " + filteredDirectoryOne));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)partitions.contains(filteredDirectoryTwo), (String)("Must not contain the filtered directory " + filteredDirectoryTwo));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)partitions.contains(".backups"), (String)"Must not contain the filtered directory .backups");
        List allFilesList = this.metadata(this.writeConfig, (HoodieEngineContext)this.context).getAllFilesInPartition(new StoragePath(this.basePath, "p1"));
        org.junit.jupiter.api.Assertions.assertEquals((int)(tableType == HoodieTableType.COPY_ON_WRITE ? 3 : 4), (int)allFilesList.size());
        allFilesList = this.metadata(this.writeConfig, (HoodieEngineContext)this.context).getAllFilesInPartition(new StoragePath(this.basePath, "p2"));
        org.junit.jupiter.api.Assertions.assertEquals((int)(tableType == HoodieTableType.COPY_ON_WRITE ? 6 : 7), (int)allFilesList.size());
        Map partitionsToFilesMap = this.metadata(this.writeConfig, (HoodieEngineContext)this.context).getAllFilesInPartitions(Arrays.asList(this.basePath + "/p1", this.basePath + "/p2"));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)partitionsToFilesMap.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)(tableType == HoodieTableType.COPY_ON_WRITE ? 3 : 4), (int)((List)partitionsToFilesMap.get(this.basePath + "/p1")).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)(tableType == HoodieTableType.COPY_ON_WRITE ? 6 : 7), (int)((List)partitionsToFilesMap.get(this.basePath + "/p2")).size());
    }

    @ParameterizedTest
    @MethodSource(value={"tableOperationsTestArgs"})
    public void testTableOperations(HoodieTableType tableType, boolean enableFullScan) throws Exception {
        this.init(tableType, true, enableFullScan, false, false);
        ArrayList<Long> commitTimeList = new ArrayList<Long>();
        commitTimeList.add(Long.parseLong(this.getHoodieWriteClient(this.writeConfig).createNewInstantTime()));
        for (int i = 0; i < 8; ++i) {
            long nextCommitTime = HoodieTestDataGenerator.getNextCommitTime((long)((Long)commitTimeList.get(commitTimeList.size() - 1)));
            commitTimeList.add(nextCommitTime);
        }
        this.doWriteInsertAndUpsert(testTable, ((Long)commitTimeList.get(0)).toString(), ((Long)commitTimeList.get(1)).toString(), false);
        this.doWriteOperationAndValidate(testTable, ((Long)commitTimeList.get(2)).toString());
        if (HoodieTableType.MERGE_ON_READ.equals((Object)tableType)) {
            this.doCompactionAndValidate(testTable, ((Long)commitTimeList.get(3)).toString());
        }
        this.doWriteOperation(testTable, ((Long)commitTimeList.get(4)).toString());
        this.doCleanAndValidate(testTable, ((Long)commitTimeList.get(5)).toString(), Collections.singletonList(((Long)commitTimeList.get(0)).toString()));
        this.doWriteOperation(testTable, ((Long)commitTimeList.get(6)).toString());
        this.doWriteOperation(testTable, ((Long)commitTimeList.get(7)).toString());
        this.validateMetadata(testTable, Collections.emptyList(), true);
    }

    @Test
    public void testMetadataTableArchival() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE, false);
        this.writeConfig = this.getWriteConfigBuilder(true, true, false).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).enableMetrics(false).withMaxNumDeltaCommitsBeforeCompaction(1).build()).withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(1).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(4, 5).build()).build();
        this.initWriteConfigAndMetatableWriter(this.writeConfig, true);
        ArrayList<String> instants = new ArrayList<String>();
        for (int i = 1; i <= 5; ++i) {
            String instant = this.metaClient.createNewInstantTime();
            instants.add(instant);
            this.doWriteOperation(testTable, instant, WriteOperationType.INSERT);
        }
        HoodieTableMetaClient metadataMetaClient = this.createMetaClient(this.metadataTableBasePath);
        HoodieActiveTimeline metadataTimeline = metadataMetaClient.reloadActiveTimeline();
        org.junit.jupiter.api.Assertions.assertEquals(instants.get(0), (Object)((HoodieInstant)metadataTimeline.getCommitsTimeline().firstInstant().get()).requestedTime());
        this.doCluster(testTable, this.metaClient.createNewInstantTime());
        metadataTimeline = metadataMetaClient.reloadActiveTimeline();
        org.junit.jupiter.api.Assertions.assertEquals(instants.get(0), (Object)((HoodieInstant)metadataTimeline.getCommitsTimeline().firstInstant().get()).requestedTime());
        this.getHoodieWriteClient(this.writeConfig);
        this.doWriteOperation(testTable, this.metaClient.createNewInstantTime(), WriteOperationType.INSERT);
        this.archiveDataTable(this.writeConfig, this.createMetaClient(this.basePath));
        org.junit.jupiter.api.Assertions.assertEquals(instants.get(3), (Object)((HoodieInstant)this.metaClient.reloadActiveTimeline().getCommitsTimeline().firstInstant().get()).requestedTime());
        metadataTimeline = metadataMetaClient.reloadActiveTimeline();
        org.junit.jupiter.api.Assertions.assertEquals(instants.get(0), (Object)((HoodieInstant)metadataTimeline.getCommitsTimeline().firstInstant().get()).requestedTime());
        this.doWriteOperation(testTable, this.metaClient.createNewInstantTime(), WriteOperationType.INSERT);
        metadataTimeline = metadataMetaClient.reloadActiveTimeline();
        org.junit.jupiter.api.Assertions.assertEquals(instants.get(3), (Object)((HoodieInstant)metadataTimeline.getCommitsTimeline().firstInstant().get()).requestedTime());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testMetadataArchivalCleanConfig(HoodieTableType tableType) throws Exception {
        this.init(tableType, false);
        this.writeConfig = this.getWriteConfigBuilder(true, true, false).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).enableMetrics(false).withMaxNumDeltaCommitsBeforeCompaction(1).build()).withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(1).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(2, 3).build()).build();
        this.initWriteConfigAndMetatableWriter(this.writeConfig, true);
        ArrayList<String> instants = new ArrayList<String>();
        for (int i = 1; i <= 4; ++i) {
            String instant = this.metaClient.createNewInstantTime();
            instants.add(instant);
            this.doWriteOperation(testTable, instant, WriteOperationType.INSERT);
        }
        HoodieTableMetaClient metadataMetaClient = this.createMetaClient(this.metadataTableBasePath);
        HoodieActiveTimeline metadataTimeline = metadataMetaClient.reloadActiveTimeline();
        org.junit.jupiter.api.Assertions.assertEquals(instants.get(0), (Object)((HoodieInstant)metadataTimeline.getCommitsTimeline().firstInstant().get()).requestedTime());
        this.getHoodieWriteClient(this.writeConfig);
        this.archiveDataTable(this.writeConfig, this.createMetaClient(this.basePath));
        this.doWriteOperation(testTable, this.metaClient.createNewInstantTime(), WriteOperationType.INSERT);
        metadataTimeline = metadataMetaClient.reloadActiveTimeline();
        org.junit.jupiter.api.Assertions.assertEquals(instants.get(2), (Object)((HoodieInstant)metadataTimeline.getCommitsTimeline().firstInstant().get()).requestedTime());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testMetadataInsertUpsertClean(HoodieTableType tableType) throws Exception {
        this.init(tableType);
        this.doWriteOperation(testTable, "0000001", WriteOperationType.INSERT);
        this.doWriteOperation(testTable, "0000002");
        this.doCleanAndValidate(testTable, "0000003", Arrays.asList("0000001"));
        if (tableType == HoodieTableType.MERGE_ON_READ) {
            this.doCompaction(testTable, "0000004");
        }
        this.doWriteOperation(testTable, "0000005");
        this.validateMetadata(testTable, Collections.emptyList(), true);
    }

    @Test
    public void testMetadataInsertUpsertCleanNonPartitioned() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE);
        testTable.setNonPartitioned();
        this.doWriteOperationNonPartitioned(testTable, "0000001", WriteOperationType.INSERT);
        this.doWriteOperationNonPartitioned(testTable, "0000002", WriteOperationType.UPSERT);
        testTable.doCleanBasedOnCommits("0000003", Arrays.asList("0000001"));
        this.validateMetadata(testTable, Collections.emptyList(), true);
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testInsertUpsertCluster(HoodieTableType tableType) throws Exception {
        this.init(tableType);
        this.doWriteOperation(testTable, "0000001", WriteOperationType.INSERT);
        this.doWriteOperation(testTable, "0000002");
        this.doClusterAndValidate(testTable, "0000003");
        if (tableType == HoodieTableType.MERGE_ON_READ) {
            this.doCompaction(testTable, "0000004");
        }
        this.doCleanAndValidate(testTable, "0000005", Arrays.asList("0000001"));
        this.validateMetadata(testTable, Collections.emptyList(), true);
    }

    @Test
    public void testMetadataTableServices() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE, false);
        this.writeConfig = this.getWriteConfigBuilder(true, true, false).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).enableMetrics(false).withMaxNumDeltaCommitsBeforeCompaction(3).build()).build();
        this.initWriteConfigAndMetatableWriter(this.writeConfig, true);
        String firstInstant = this.metaClient.createNewInstantTime();
        this.doWriteOperation(testTable, firstInstant, WriteOperationType.INSERT);
        this.doCleanAndValidate(testTable, this.metaClient.createNewInstantTime(), Collections.singletonList(firstInstant));
        HoodieTableMetadata tableMetadata = this.metadata(this.writeConfig, (HoodieEngineContext)this.context);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)tableMetadata.getLatestCompactionTime().isPresent());
        this.doWriteOperation(testTable, this.metaClient.createNewInstantTime(), WriteOperationType.UPSERT);
        tableMetadata = this.metadata(this.writeConfig, (HoodieEngineContext)this.context);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tableMetadata.getLatestCompactionTime().isPresent());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testTableOperationsWithMetadataIndex(HoodieTableType tableType) throws Exception {
        this.initPath();
        HoodieWriteConfig writeConfig = this.getWriteConfigBuilder(true, true, false).withIndexConfig(HoodieIndexConfig.newBuilder().bloomIndexBucketizedChecking(false).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexBloomFilter(true).withMetadataIndexBloomFilterFileGroups(4).withMetadataIndexColumnStats(true).withMetadataIndexBloomFilterFileGroups(2).withMaxNumDeltaCommitsBeforeCompaction(12).build()).build();
        this.init(tableType, writeConfig);
        this.testTableOperationsForMetaIndexImpl(writeConfig);
    }

    private void testTableOperationsForMetaIndexImpl(HoodieWriteConfig writeConfig) throws Exception {
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        this.testTableOperationsImpl(engineContext, writeConfig);
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testMetadataTableDeletePartition(HoodieTableType tableType) throws Exception {
        this.initPath();
        int maxCommits = 1;
        HoodieWriteConfig cfg = this.getConfigBuilder("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", HoodieIndex.IndexType.BLOOM, HoodieFailedWritesCleaningPolicy.EAGER).withCleanConfig(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).retainCommits(maxCommits).build()).withParallelism(1, 1).withBulkInsertParallelism(1).withFinalizeWriteParallelism(1).withDeleteParallelism(1).withConsistencyGuardConfig(ConsistencyGuardConfig.newBuilder().withConsistencyCheckEnabled(true).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).build()).build();
        this.init(tableType);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, cfg);){
            String newCommitTime = "0000001";
            List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(20));
            client.startCommitWithTime(newCommitTime);
            List writeStatuses = client.bulkInsert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            this.validateMetadata(client);
            newCommitTime = "0000002";
            client.startCommitWithTime(newCommitTime);
            this.validateMetadata(client);
            records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(10));
            writeStatuses = client.upsert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            try (HoodieBackedTableMetadataWriter<JavaRDD<HoodieRecord>> metadataWriter = TestHoodieBackedMetadata.metadataWriter(client, this.storageConf, this.jsc);){
                org.junit.jupiter.api.Assertions.assertNotNull(metadataWriter, (String)"MetadataWriter should have been initialized");
                metadataWriter.deletePartitions("0000003", Arrays.asList(MetadataPartitionType.COLUMN_STATS));
                HoodieTableMetaClient metadataMetaClient = this.createMetaClient(this.metadataTableBasePath);
                List metadataTablePartitions = FSUtils.getAllPartitionPaths((HoodieEngineContext)engineContext, (HoodieStorage)metadataMetaClient.getStorage(), (StoragePath)metadataMetaClient.getBasePath(), (boolean)false);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)metadataTablePartitions.contains(MetadataPartitionType.COLUMN_STATS.getPartitionPath()));
                Option completedReplaceInstant = metadataMetaClient.reloadActiveTimeline().getCompletedReplaceTimeline().lastInstant();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)completedReplaceInstant.isPresent());
                org.junit.jupiter.api.Assertions.assertEquals((Object)"0000003", (Object)((HoodieInstant)completedReplaceInstant.get()).requestedTime());
                HashMap metadataEnabledPartitionTypes = new HashMap();
                metadataWriter.getEnabledPartitionTypes().forEach(e -> metadataEnabledPartitionTypes.put(e.getPartitionPath(), e));
                HoodieTableFileSystemView fsView = HoodieTableFileSystemView.fileListingBasedFileSystemView((HoodieEngineContext)engineContext, (HoodieTableMetaClient)metadataMetaClient, (HoodieTimeline)metadataMetaClient.getActiveTimeline());
                metadataTablePartitions.forEach(partition -> {
                    List latestSlices = fsView.getLatestFileSlices(partition).collect(Collectors.toList());
                    if (MetadataPartitionType.COLUMN_STATS.getPartitionPath().equals(partition)) {
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)latestSlices.isEmpty());
                    } else {
                        org.junit.jupiter.api.Assertions.assertFalse((boolean)latestSlices.isEmpty());
                        org.junit.jupiter.api.Assertions.assertTrue((latestSlices.stream().map(FileSlice::getBaseFile).count() <= (long)latestSlices.size() ? 1 : 0) != 0, (String)"Should have a single latest base file per file group");
                    }
                });
            }
        }
    }

    @Test
    public void testVirtualKeysInBaseFiles() throws Exception {
        boolean populateMetaFields = false;
        this.init(HoodieTableType.MERGE_ON_READ, false);
        this.writeConfig = this.getWriteConfigBuilder(true, true, false).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).enableMetrics(false).withMaxNumDeltaCommitsBeforeCompaction(2).build()).build();
        this.initWriteConfigAndMetatableWriter(this.writeConfig, true);
        String firstInstant = this.metaClient.createNewInstantTime();
        this.doWriteOperation(testTable, firstInstant, WriteOperationType.INSERT);
        this.doClean(testTable, this.metaClient.createNewInstantTime(), Collections.singletonList(firstInstant));
        this.doWriteOperation(testTable, this.metaClient.createNewInstantTime(), WriteOperationType.UPSERT);
        HoodieTableMetadata tableMetadata = this.metadata(this.writeConfig, (HoodieEngineContext)this.context);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tableMetadata.getLatestCompactionTime().isPresent());
        HoodieTableMetaClient metadataMetaClient = this.createMetaClient(this.metadataTableBasePath);
        HoodieWriteConfig metadataTableWriteConfig = this.getMetadataWriteConfig(this.writeConfig);
        metadataMetaClient.reloadActiveTimeline();
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)metadataTableWriteConfig, (HoodieEngineContext)this.context, (HoodieTableMetaClient)metadataMetaClient);
        table.getHoodieView().sync();
        List fileSlices = table.getSliceView().getLatestFileSlices("files").collect(Collectors.toList());
        HoodieBaseFile baseFile = (HoodieBaseFile)((FileSlice)fileSlices.get(0)).getBaseFile().get();
        HoodieAvroHFileReaderImplBase hoodieHFileReader = (HoodieAvroHFileReaderImplBase)HoodieSparkIOFactory.getHoodieSparkIOFactory((HoodieStorage)this.storage).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader((HoodieConfig)table.getConfig(), new StoragePath(baseFile.getPath()));
        List records = HoodieAvroHFileReaderImplBase.readAllRecords((HoodieAvroFileReader)hoodieHFileReader);
        records.forEach(entry -> {
            if (populateMetaFields) {
                org.junit.jupiter.api.Assertions.assertNotNull((Object)((GenericRecord)entry).get(HoodieRecord.RECORD_KEY_METADATA_FIELD));
            } else {
                org.junit.jupiter.api.Assertions.assertNull((Object)((GenericRecord)entry).get(HoodieRecord.RECORD_KEY_METADATA_FIELD));
            }
        });
    }

    @Test
    public void testMetadataTableCompactionWithPendingInstants() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE, false);
        this.writeConfig = this.getWriteConfigBuilder(true, true, false).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).enableMetrics(false).withMaxNumDeltaCommitsBeforeCompaction(4).withMetadataIndexColumnStats(false).build()).build();
        this.initWriteConfigAndMetatableWriter(this.writeConfig, true);
        this.doWriteOperation(testTable, this.metaClient.createNewInstantTime(), WriteOperationType.INSERT);
        this.doWriteOperation(testTable, this.metaClient.createNewInstantTime(), WriteOperationType.INSERT);
        String inflightInstant1 = this.metaClient.createNewInstantTime();
        HoodieCommitMetadata inflightCommitMeta = testTable.doWriteOperation(inflightInstant1, WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 2, false, true);
        this.doWriteOperation(testTable, this.metaClient.createNewInstantTime());
        HoodieTableMetadata tableMetadata = this.metadata(this.writeConfig, (HoodieEngineContext)this.context);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)tableMetadata.getLatestCompactionTime().isPresent());
        this.doWriteOperation(testTable, this.metaClient.createNewInstantTime(), WriteOperationType.INSERT);
        tableMetadata = this.metadata(this.writeConfig, (HoodieEngineContext)this.context);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tableMetadata.getLatestCompactionTime().isPresent(), (String)"Compaction of metadata table should kick in");
        testTable.moveInflightCommitToComplete(inflightInstant1, inflightCommitMeta);
        String inflightInstant2 = this.metaClient.createNewInstantTime();
        this.doWriteOperation(testTable, inflightInstant2, WriteOperationType.INSERT);
        testTable.moveCompleteCommitToInflight(inflightInstant2);
        this.doWriteOperation(testTable, this.metaClient.createNewInstantTime(), WriteOperationType.INSERT);
        this.doWriteOperation(testTable, this.metaClient.createNewInstantTime(), WriteOperationType.INSERT);
        tableMetadata = this.metadata(this.writeConfig, (HoodieEngineContext)this.context);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tableMetadata.getLatestCompactionTime().isPresent(), (String)"Compaction of metadata table should kick in");
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieInstantTimeGenerator.instantTimeMinusMillis((String)inflightInstant2, (long)1L), (Object)tableMetadata.getLatestCompactionTime().get());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testInitializeMetadataTableWithPendingInstant(HoodieTableType tableType) throws Exception {
        this.init(tableType, false);
        this.initWriteConfigAndMetatableWriter(this.writeConfig, false);
        this.doWriteOperation(testTable, this.metaClient.createNewInstantTime(), WriteOperationType.INSERT);
        this.doWriteOperation(testTable, this.metaClient.createNewInstantTime(), WriteOperationType.INSERT);
        String inflightInstant = this.metaClient.createNewInstantTime();
        HoodieCommitMetadata inflightCommitMeta = testTable.doWriteOperation(inflightInstant, WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 2, false, true);
        this.doWriteOperation(testTable, this.metaClient.createNewInstantTime());
        this.writeConfig = this.getWriteConfigBuilder(true, true, false).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).enableMetrics(false).withMaxNumDeltaCommitsBeforeCompaction(4).build()).build();
        this.initWriteConfigAndMetatableWriter(this.writeConfig, true);
        testTable.moveInflightCommitToComplete(inflightInstant, inflightCommitMeta);
        this.validateMetadata(testTable, true);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMetadataTableWithPendingCompaction(boolean simulateFailedCompaction) throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE, false);
        this.writeConfig = this.getWriteConfigBuilder(true, true, false).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).enableMetrics(false).withMaxNumDeltaCommitsBeforeCompaction(3).build()).build();
        this.initWriteConfigAndMetatableWriter(this.writeConfig, true);
        this.doWriteOperation(testTable, this.metaClient.createNewInstantTime(), WriteOperationType.INSERT);
        String commitInstant = this.metaClient.createNewInstantTime();
        this.doWriteOperation(testTable, commitInstant, WriteOperationType.INSERT);
        this.doWriteOperation(testTable, this.metaClient.createNewInstantTime(), WriteOperationType.INSERT);
        HoodieTableMetadata tableMetadata = this.metadata(this.writeConfig, (HoodieEngineContext)this.context);
        Option metadataCompactionInstant = tableMetadata.getLatestCompactionTime();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)metadataCompactionInstant.isPresent());
        Path metaFilePath = Paths.get(HoodieTestUtils.getCompleteInstantPath((HoodieStorage)this.metaClient.getStorage(), (StoragePath)new StoragePath(new StoragePath(this.metadataTableBasePath, ".hoodie"), "timeline"), (String)((String)metadataCompactionInstant.get()), (String)"commit").toUri());
        Path tempFilePath = FileCreateUtilsLegacy.renameFileToTemp((Path)metaFilePath, (String)((String)metadataCompactionInstant.get()));
        this.metaClient.reloadActiveTimeline();
        testTable = HoodieMetadataTestTable.of((HoodieTableMetaClient)this.metaClient, (HoodieTableMetadataWriter)this.metadataWriter, (Option)Option.of((Object)this.context));
        this.validateMetadata(testTable);
        if (simulateFailedCompaction) {
            this.doWriteOperation(testTable, this.metaClient.createNewInstantTime(), WriteOperationType.INSERT);
        } else {
            FileCreateUtilsLegacy.renameTempToMetaFile((Path)tempFilePath, (Path)metaFilePath);
        }
        this.validateMetadata(testTable);
        this.doWriteOperation(testTable, this.metaClient.createNewInstantTime(), WriteOperationType.INSERT);
        this.doWriteOperation(testTable, this.metaClient.createNewInstantTime(), WriteOperationType.UPSERT);
        this.validateMetadata(testTable);
        if (simulateFailedCompaction) {
            tableMetadata = this.metadata(this.writeConfig, (HoodieEngineContext)this.context);
            metadataCompactionInstant = tableMetadata.getLatestCompactionTime();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)metadataCompactionInstant.isPresent());
            metaFilePath = Paths.get(HoodieTestUtils.getCompleteInstantPath((HoodieStorage)this.metaClient.getStorage(), (StoragePath)new StoragePath(new StoragePath(this.metadataTableBasePath, ".hoodie"), "timeline"), (String)((String)metadataCompactionInstant.get()), (String)"commit").toUri());
            FileCreateUtilsLegacy.renameFileToTemp((Path)metaFilePath, (String)((String)metadataCompactionInstant.get()));
            this.validateMetadata(testTable);
            this.doWriteOperation(testTable, this.metaClient.createNewInstantTime(), WriteOperationType.INSERT);
            this.validateMetadata(testTable);
            this.doWriteOperation(testTable, this.metaClient.createNewInstantTime(), WriteOperationType.INSERT);
            this.doWriteOperation(testTable, this.metaClient.createNewInstantTime(), WriteOperationType.UPSERT);
            this.validateMetadata(testTable);
        }
    }

    @Test
    public void testMetadataRollbackWithCompaction() throws Exception {
        HoodieTableType tableType = HoodieTableType.COPY_ON_WRITE;
        this.init(tableType, false);
        this.writeConfig = this.getWriteConfigBuilder(false, true, false).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).build()).build();
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, this.writeConfig);){
            String newCommitTime1 = "0000001";
            List records = this.dataGen.generateInserts(newCommitTime1, Integer.valueOf(100));
            client.startCommitWithTime(newCommitTime1);
            JavaRDD writeStatuses = client.insert(this.jsc.parallelize(records, 1), newCommitTime1);
            client.commit(newCommitTime1, (Object)writeStatuses);
            String newCommitTime2 = "0000002";
            records = this.dataGen.generateUniqueUpdates(newCommitTime2, Integer.valueOf(20));
            client.startCommitWithTime(newCommitTime2);
            writeStatuses = client.upsert(this.jsc.parallelize(records, 1), newCommitTime2);
            client.commit(newCommitTime2, (Object)writeStatuses);
            String newCommitTime3 = "0000003";
            records = this.dataGen.generateUniqueUpdates(newCommitTime3, Integer.valueOf(20));
            client.startCommitWithTime(newCommitTime3);
            writeStatuses = client.upsert(this.jsc.parallelize(records, 1), newCommitTime3);
            client.commit(newCommitTime3, (Object)writeStatuses);
            client.rollback(newCommitTime3);
            StoragePath toDelete = HoodieTestUtils.getCompleteInstantPath((HoodieStorage)this.metaClient.getStorage(), (StoragePath)new StoragePath(this.metaClient.getMetaPath() + "/metadata/.hoodie/timeline/"), (String)newCommitTime2, (String)"deltacommit");
            this.metaClient.getStorage().deleteDirectory(toDelete);
            records = this.dataGen.generateUniqueUpdates(newCommitTime3, Integer.valueOf(20));
            client.startCommitWithTime(newCommitTime3);
            writeStatuses = client.upsert(this.jsc.parallelize(records, 1), newCommitTime3);
            client.commit(newCommitTime3, (Object)writeStatuses);
            HoodieTableMetaClient metadataMetaClient = HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)HoodieTableMetadata.getMetadataTableBasePath((String)this.basePath), (HoodieTableType)tableType, (Properties)new Properties());
            String completionTimeForCommit3 = (String)metadataMetaClient.getActiveTimeline().filter(instant -> instant.requestedTime().equals(newCommitTime3)).firstInstant().map(HoodieInstant::getCompletionTime).orElseThrow(() -> new IllegalStateException(newCommitTime3 + " should exist on the metadata"));
            String completionTimeForRollback = (String)metadataMetaClient.getActiveTimeline().filter(instant -> instant.getAction().equals("rollback")).firstInstant().map(HoodieInstant::getCompletionTime).orElseThrow(() -> new IllegalStateException("A rollback commit should exist on the metadata"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)InstantComparison.compareTimestamps((String)completionTimeForCommit3, (BiPredicate)InstantComparison.GREATER_THAN, (String)completionTimeForRollback));
        }
    }

    @Test
    public void testMetadataRollbackDuringInit() throws Exception {
        HoodieTableType tableType = HoodieTableType.COPY_ON_WRITE;
        this.init(tableType, false);
        this.writeConfig = this.getWriteConfigBuilder(false, true, false).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).withEnableRecordIndex(true).build()).build();
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        String newCommitTime1 = "20230809230000000";
        List records1 = this.dataGen.generateInserts(newCommitTime1, Integer.valueOf(100));
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, this.writeConfig);){
            client.startCommitWithTime(newCommitTime1);
            JavaRDD writeStatuses = client.insert(this.jsc.parallelize(records1, 1), newCommitTime1);
            client.commit(newCommitTime1, (Object)writeStatuses);
        }
        this.revertTableToInflightState(this.writeConfig);
        String newCommitTime2 = "20230809232000000";
        List records2 = this.dataGen.generateInserts(newCommitTime2, Integer.valueOf(20));
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, this.writeConfig);){
            client.startCommitWithTime(newCommitTime2);
            JavaRDD writeStatuses = client.insert(this.jsc.parallelize(records2, 1), newCommitTime2);
            client.commit(newCommitTime2, (Object)writeStatuses);
        }
        HoodieTableMetadata metadataReader = HoodieTableMetadata.create((HoodieEngineContext)this.context, (HoodieStorage)this.storage, (HoodieMetadataConfig)this.writeConfig.getMetadataConfig(), (String)this.writeConfig.getBasePath());
        Map result = metadataReader.readRecordIndex(records1.stream().map(HoodieRecord::getRecordKey).collect(Collectors.toList()));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)result.size(), (String)"RI should not return entries that are rolled back.");
        result = metadataReader.readRecordIndex(records2.stream().map(HoodieRecord::getRecordKey).collect(Collectors.toList()));
        org.junit.jupiter.api.Assertions.assertEquals((int)records2.size(), (int)result.size(), (String)"RI should return entries in the commit.");
    }

    private void revertTableToInflightState(HoodieWriteConfig writeConfig) throws IOException {
        String basePath = writeConfig.getBasePath();
        String mdtBasePath = HoodieTableMetadata.getMetadataTableBasePath((String)basePath);
        HoodieTableMetaClient metaClient = this.createMetaClient(basePath);
        HoodieTableMetaClient mdtMetaClient = this.createMetaClient(mdtBasePath);
        HoodieActiveTimeline timeline = metaClient.getActiveTimeline();
        HoodieActiveTimeline mdtTimeline = mdtMetaClient.getActiveTimeline();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)timeline.countInstants());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)timeline.getCommitsTimeline().filterCompletedInstants().countInstants());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)mdtTimeline.countInstants());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)mdtTimeline.getCommitsTimeline().filterCompletedInstants().countInstants());
        String mdtInitCommit2 = ((HoodieInstant)mdtTimeline.getCommitsTimeline().filterCompletedInstants().getInstants().get(1)).requestedTime();
        Pair lastCommitMetadataWithValidData = (Pair)mdtTimeline.getLastCommitMetadataWithValidData().get();
        String commit = ((HoodieInstant)lastCommitMetadataWithValidData.getLeft()).requestedTime();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)timeline.getCommitsTimeline().containsInstant(commit));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)mdtTimeline.getCommitsTimeline().containsInstant(commit));
        TestHoodieBackedMetadata.deleteMetaFile(metaClient.getStorage(), basePath, commit, ".commit");
        List dataFiles = ((HoodieCommitMetadata)lastCommitMetadataWithValidData.getRight()).getWriteStats().stream().map(HoodieWriteStat::getPath).collect(Collectors.toList());
        for (String relativeFilePath : dataFiles) {
            TestHoodieBackedMetadata.deleteFileFromStorage(metaClient.getStorage(), mdtBasePath + "/" + relativeFilePath);
        }
        TestHoodieBackedMetadata.deleteMetaFile(metaClient.getStorage(), mdtBasePath, commit, ".deltacommit");
        TestHoodieBackedMetadata.deleteMetaFile(metaClient.getStorage(), mdtBasePath, commit, ".deltacommit.inflight");
        TestHoodieBackedMetadata.deleteMetaFile(metaClient.getStorage(), mdtBasePath, commit, ".deltacommit.requested");
        TestHoodieBackedMetadata.deleteMetaFile(metaClient.getStorage(), mdtBasePath, mdtInitCommit2, ".deltacommit");
        metaClient.getTableConfig().setMetadataPartitionState(metaClient, MetadataPartitionType.RECORD_INDEX.getPartitionPath(), false);
        metaClient.getTableConfig().setMetadataPartitionsInflight(metaClient, new MetadataPartitionType[]{MetadataPartitionType.RECORD_INDEX});
        timeline = metaClient.getActiveTimeline().reload();
        mdtTimeline = mdtMetaClient.getActiveTimeline().reload();
        org.junit.jupiter.api.Assertions.assertEquals((Object)commit, (Object)((HoodieInstant)timeline.lastInstant().get()).requestedTime());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((HoodieInstant)timeline.lastInstant().get()).isInflight());
        org.junit.jupiter.api.Assertions.assertEquals((Object)mdtInitCommit2, (Object)((HoodieInstant)mdtTimeline.lastInstant().get()).requestedTime());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((HoodieInstant)mdtTimeline.lastInstant().get()).isInflight());
    }

    public static void deleteFileFromStorage(HoodieStorage storage, String targetPath) throws IOException {
        if (storage.exists(new StoragePath(targetPath))) {
            storage.deleteFile(new StoragePath(targetPath));
        }
    }

    public static void deleteMetaFile(HoodieStorage storage, String basePath, String instantTime, String suffix) throws IOException {
        if (suffix.contains(".requested") || suffix.contains(".inflight")) {
            String targetPath = basePath + "/" + ".hoodie" + "/" + "timeline" + "/" + instantTime + suffix;
            TestHoodieBackedMetadata.deleteFileFromStorage(storage, targetPath);
        } else {
            try {
                StoragePath completeInstantPath = HoodieTestUtils.getCompleteInstantPath((HoodieStorage)storage, (StoragePath)new StoragePath(new StoragePath(basePath + "/" + ".hoodie"), "timeline"), (String)instantTime, (String)suffix.replaceFirst(".", ""));
                TestHoodieBackedMetadata.deleteFileFromStorage(storage, completeInstantPath.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static List<Arguments> testMetadataRecordKeyExcludeFromPayloadArgs() {
        return Arrays.asList(Arguments.of((Object[])new Object[]{HoodieTableType.COPY_ON_WRITE, false}), Arguments.of((Object[])new Object[]{HoodieTableType.MERGE_ON_READ, false}));
    }

    @ParameterizedTest
    @MethodSource(value={"testMetadataRecordKeyExcludeFromPayloadArgs"})
    public void testMetadataRecordKeyExcludeFromPayload(HoodieTableType tableType, boolean enableMetaFields) throws Exception {
        this.initPath();
        this.writeConfig = this.getWriteConfigBuilder(true, true, false).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).withMaxNumDeltaCommitsBeforeCompaction(3).build()).build();
        this.init(tableType, this.writeConfig);
        this.doWriteOperation(testTable, "0000001", WriteOperationType.INSERT);
        HoodieTableMetaClient metadataMetaClient = this.createMetaClient(this.metadataTableBasePath);
        HoodieWriteConfig metadataTableWriteConfig = this.getMetadataWriteConfig(this.writeConfig);
        metadataMetaClient.reloadActiveTimeline();
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)metadataTableWriteConfig, (HoodieEngineContext)this.context, (HoodieTableMetaClient)metadataMetaClient);
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.lambda$testMetadataRecordKeyExcludeFromPayload$7((HoodieTable)table, metadataMetaClient, enableMetaFields), (String)"Metadata table should have valid log files!");
        this.verifyMetadataRecordKeyExcludeFromPayloadBaseFiles((HoodieTable)table, enableMetaFields);
        this.doWriteOperation(testTable, "0000002", WriteOperationType.UPSERT);
        this.doWriteOperation(testTable, "0000004", WriteOperationType.UPSERT);
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.lambda$testMetadataRecordKeyExcludeFromPayload$8((HoodieTable)table, metadataMetaClient, enableMetaFields), (String)"Metadata table should have valid log files!");
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.lambda$testMetadataRecordKeyExcludeFromPayload$9((HoodieTable)table, enableMetaFields), (String)"Metadata table should have a valid base file!");
        this.doWriteOperation(testTable, "0000005", WriteOperationType.UPSERT);
        this.doClean(testTable, "0000006", Arrays.asList("0000004"));
        this.doWriteOperation(testTable, "0000007", WriteOperationType.UPSERT);
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.lambda$testMetadataRecordKeyExcludeFromPayload$10((HoodieTable)table, metadataMetaClient, enableMetaFields), (String)"Metadata table should have valid log files!");
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.lambda$testMetadataRecordKeyExcludeFromPayload$11((HoodieTable)table, enableMetaFields), (String)"Metadata table should have a valid base file!");
        this.validateMetadata(testTable);
    }

    private void verifyMetadataRecordKeyExcludeFromPayloadLogFiles(HoodieTable table, HoodieTableMetaClient metadataMetaClient, String latestCommitTimestamp, boolean enableMetaFields) throws IOException {
        table.getHoodieView().sync();
        List fileSlices = table.getSliceView().getLatestFileSlices(MetadataPartitionType.FILES.getPartitionPath()).collect(Collectors.toList());
        if (fileSlices.isEmpty()) {
            throw new IllegalStateException("LogFile slices are not available!");
        }
        List<HoodieLogFile> logFiles = ((FileSlice)fileSlices.get(0)).getLogFiles().map(logFile -> logFile).collect(Collectors.toList());
        List<String> logFilePaths = logFiles.stream().map(logFile -> logFile.getPath().toString()).collect(Collectors.toList());
        TestHoodieBackedMetadata.verifyMetadataRawRecords(table, logFiles, enableMetaFields);
        this.verifyMetadataMergedRecords(metadataMetaClient, logFilePaths, latestCommitTimestamp, enableMetaFields);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void verifyMetadataRawRecords(HoodieTable table, List<HoodieLogFile> logFiles, boolean enableMetaFields) throws IOException {
        HoodieStorage storage = table.getStorage();
        Iterator<HoodieLogFile> iterator = logFiles.iterator();
        block17: while (iterator.hasNext()) {
            HoodieLogFile logFile = iterator.next();
            List pathInfoList = storage.listDirectEntries(logFile.getPath());
            Schema writerSchema = TableSchemaResolver.readSchemaFromLogFile((HoodieStorage)storage, (StoragePath)logFile.getPath());
            if (writerSchema == null) continue;
            HoodieLogFormat.Reader logFileReader = HoodieLogFormat.newReader((HoodieStorage)storage, (HoodieLogFile)new HoodieLogFile(((StoragePathInfo)pathInfoList.get(0)).getPath()), (Schema)writerSchema);
            Throwable throwable = null;
            try {
                while (true) {
                    ClosableIterator recordItr;
                    block21: {
                        if (!logFileReader.hasNext()) continue block17;
                        HoodieLogBlock logBlock = (HoodieLogBlock)logFileReader.next();
                        if (!(logBlock instanceof HoodieDataBlock)) continue;
                        recordItr = ((HoodieDataBlock)logBlock).getRecordIterator(HoodieRecord.HoodieRecordType.AVRO);
                        Throwable throwable2 = null;
                        try {
                            recordItr.forEachRemaining(indexRecord -> {
                                GenericRecord record = (GenericRecord)indexRecord.getData();
                                if (enableMetaFields) {
                                    org.junit.jupiter.api.Assertions.assertNotNull((Object)record.get(HoodieRecord.RECORD_KEY_METADATA_FIELD));
                                    org.junit.jupiter.api.Assertions.assertNotNull((Object)record.get(HoodieRecord.COMMIT_TIME_METADATA_FIELD));
                                } else {
                                    org.junit.jupiter.api.Assertions.assertNull((Object)record.get(HoodieRecord.RECORD_KEY_METADATA_FIELD));
                                    org.junit.jupiter.api.Assertions.assertNull((Object)record.get(HoodieRecord.COMMIT_TIME_METADATA_FIELD));
                                }
                                String key = String.valueOf(record.get("key"));
                                org.junit.jupiter.api.Assertions.assertFalse((boolean)key.isEmpty());
                                if (enableMetaFields) {
                                    org.junit.jupiter.api.Assertions.assertTrue((boolean)key.equals(String.valueOf(record.get(HoodieRecord.RECORD_KEY_METADATA_FIELD))));
                                }
                            });
                            if (recordItr == null) continue;
                            if (throwable2 == null) break block21;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (recordItr == null) throw throwable4;
                                if (throwable2 != null) {
                                    try {
                                        recordItr.close();
                                        throw throwable4;
                                    }
                                    catch (Throwable throwable5) {
                                        throwable2.addSuppressed(throwable5);
                                        throw throwable4;
                                    }
                                }
                                recordItr.close();
                                throw throwable4;
                            }
                        }
                        try {
                            recordItr.close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    recordItr.close();
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
            finally {
                if (logFileReader == null) continue;
                if (throwable != null) {
                    try {
                        logFileReader.close();
                    }
                    catch (Throwable throwable8) {
                        throwable.addSuppressed(throwable8);
                    }
                    continue;
                }
                logFileReader.close();
            }
        }
    }

    private void verifyMetadataMergedRecords(HoodieTableMetaClient metadataMetaClient, List<String> logFilePaths, String latestCommitTimestamp, boolean enableMetaFields) {
        Schema schema = HoodieAvroUtils.addMetadataFields((Schema)HoodieMetadataRecord.getClassSchema());
        if (enableMetaFields) {
            schema = HoodieAvroUtils.addMetadataFields((Schema)schema);
        }
        HoodieMetadataLogRecordReader logRecordReader = HoodieMetadataLogRecordReader.newBuilder().withStorage(metadataMetaClient.getStorage()).withBasePath(metadataMetaClient.getBasePath()).withLogFilePaths(logFilePaths).withLatestInstantTime(latestCommitTimestamp).withPartition(MetadataPartitionType.FILES.getPartitionPath()).withReaderSchema(schema).withMaxMemorySizeInBytes(Long.valueOf(100000L)).withBufferSize(4096).withSpillableMapBasePath(this.tempDir.toString()).withDiskMapType(ExternalSpillableMap.DiskMapType.BITCASK).build();
        for (HoodieRecord entry : logRecordReader.getRecords()) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)entry.getRecordKey().isEmpty());
            org.junit.jupiter.api.Assertions.assertEquals((Object)entry.getKey().getRecordKey(), (Object)entry.getRecordKey());
        }
    }

    private void verifyMetadataRecordKeyExcludeFromPayloadBaseFiles(HoodieTable table, boolean enableMetaFields) throws IOException {
        table.getHoodieView().sync();
        List fileSlices = table.getSliceView().getLatestFileSlices(MetadataPartitionType.FILES.getPartitionPath()).collect(Collectors.toList());
        if (!((FileSlice)fileSlices.get(0)).getBaseFile().isPresent()) {
            throw new IllegalStateException("Base file not available!");
        }
        HoodieBaseFile baseFile = (HoodieBaseFile)((FileSlice)fileSlices.get(0)).getBaseFile().get();
        HoodieAvroHFileReaderImplBase hoodieHFileReader = (HoodieAvroHFileReaderImplBase)HoodieSparkIOFactory.getHoodieSparkIOFactory((HoodieStorage)this.storage).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader((HoodieConfig)table.getConfig(), new StoragePath(baseFile.getPath()));
        List records = HoodieAvroHFileReaderImplBase.readAllRecords((HoodieAvroFileReader)hoodieHFileReader);
        records.forEach(entry -> {
            if (enableMetaFields) {
                org.junit.jupiter.api.Assertions.assertNotNull((Object)((GenericRecord)entry).get(HoodieRecord.RECORD_KEY_METADATA_FIELD));
            } else {
                org.junit.jupiter.api.Assertions.assertNull((Object)((GenericRecord)entry).get(HoodieRecord.RECORD_KEY_METADATA_FIELD));
            }
            String keyInPayload = (String)((GenericRecord)entry).get("key");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)keyInPayload.isEmpty());
        });
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRollbackOperations(HoodieTableType tableType) throws Exception {
        this.init(tableType);
        this.doWriteInsertAndUpsert(testTable);
        this.doWriteOperation(testTable, "0000003", WriteOperationType.UPSERT);
        this.doWriteOperation(testTable, "0000004");
        this.doRollbackAndValidate(testTable, "0000004", "0000005");
        for (int i = 6; i < 10; ++i) {
            this.doWriteOperation(testTable, "000000" + i);
        }
        this.validateMetadata(testTable);
        this.doWriteOperation(testTable, "0000010");
        this.doRollbackAndValidate(testTable, "0000010", "0000011");
        if (HoodieTableType.MERGE_ON_READ.equals((Object)tableType)) {
            this.doCompactionAndValidate(testTable, "0000012");
            this.doRollbackAndValidate(testTable, "0000012", "0000013");
        }
        this.doWriteOperation(testTable, "0000014", WriteOperationType.DELETE);
        this.doRollbackAndValidate(testTable, "0000014", "0000015");
        this.writeConfig = this.getWriteConfigBuilder(true, true, false).withRollbackUsingMarkers(false).build();
        this.doWriteOperation(testTable, "0000016");
        testTable.doRollback("0000016", "0000017");
        this.validateMetadata(testTable);
        this.writeConfig = this.getWriteConfigBuilder(true, true, false).withRollbackUsingMarkers(true).build();
        this.doWriteOperation(testTable, "0000018");
        testTable.doRollback("0000018", "0000019");
        this.validateMetadata(testTable, true);
    }

    @Test
    public void testRollbackOperationsNonPartitioned() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE);
        testTable.setNonPartitioned();
        this.doWriteInsertAndUpsertNonPartitioned(testTable);
        this.doWriteOperationNonPartitioned(testTable, "0000003", WriteOperationType.UPSERT);
        this.doWriteOperationNonPartitioned(testTable, "0000004", WriteOperationType.UPSERT);
        this.doRollback(testTable, "0000004", "0000005");
        this.validateMetadata(testTable);
        for (int i = 6; i < 10; ++i) {
            this.doWriteOperationNonPartitioned(testTable, "000000" + i, WriteOperationType.UPSERT);
        }
        this.validateMetadata(testTable);
    }

    @Test
    public void testManualRollbacks() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE, false);
        int maxDeltaCommitsBeforeCompaction = 4;
        int minArchiveCommitsDataset = 4;
        this.writeConfig = this.getWriteConfigBuilder(true, true, false).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).withMaxNumDeltaCommitsBeforeCompaction(4).build()).withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(1).retainFileVersions(1).withAutoClean(Boolean.valueOf(false)).withAsyncClean(Boolean.valueOf(true)).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(4, 5).build()).build();
        this.initWriteConfigAndMetatableWriter(this.writeConfig, true);
        String commit1 = this.metaClient.createNewInstantTime();
        String commit2 = this.metaClient.createNewInstantTime();
        this.doWriteInsertAndUpsert(testTable, commit1, commit2, false);
        for (int i = 3; i < 10; ++i) {
            this.doWriteOperation(testTable, this.metaClient.createNewInstantTime());
            this.archiveDataTable(this.writeConfig, this.metaClient);
        }
        this.validateMetadata(testTable);
        List allInstants = this.metaClient.reloadActiveTimeline().getCommitsTimeline().getReverseOrderedInstants().collect(Collectors.toList());
        for (HoodieInstant instantToRollback : allInstants) {
            try {
                testTable.doRollback(instantToRollback.requestedTime(), this.metaClient.createNewInstantTime());
                this.validateMetadata(testTable);
            }
            catch (HoodieMetadataException e) {
                break;
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testSync(HoodieTableType tableType) throws Exception {
        this.init(tableType, false);
        this.writeConfig = this.getWriteConfigBuilder(true, false, false).build();
        this.doPreBootstrapOperations(testTable, "00000001", "00000002");
        this.writeConfig = this.getWriteConfigBuilder(true, true, false).build();
        this.initWriteConfigAndMetatableWriter(this.writeConfig, true);
        this.syncTableMetadata(this.writeConfig);
        this.validateMetadata(testTable);
        this.doWriteOperation(testTable, "00000003", WriteOperationType.INSERT);
        this.doWriteOperation(testTable, "00000004", WriteOperationType.UPSERT);
        this.doWriteOperation(testTable, "00000005", WriteOperationType.UPSERT);
        if (HoodieTableType.MERGE_ON_READ.equals((Object)tableType)) {
            this.doCompactionAndValidate(testTable, "00000006");
        }
        this.doWriteOperation(testTable, "00000008");
        this.doWriteOperation(testTable, "00000009", WriteOperationType.DELETE);
        this.doCleanAndValidate(testTable, "00000010", Arrays.asList("00000003", "00000004"));
        this.doWriteOperation(testTable, "00000011");
        this.doClusterAndValidate(testTable, "00000012");
        HoodieCommitMetadata inflightCommitMeta = testTable.doWriteOperation("00000007", WriteOperationType.UPSERT, Collections.emptyList(), Arrays.asList("p1", "p2"), 2, false, true);
        this.doWriteOperation(testTable, "00000013");
        this.validateMetadata(testTable, Collections.singletonList("00000007"));
        testTable.moveInflightCommitToComplete("00000007", inflightCommitMeta);
        this.validateMetadata(testTable);
        this.doWriteOperation(testTable, "00000014");
        this.validateMetadata(testTable, Collections.emptyList(), true);
    }

    @ParameterizedTest
    @MethodSource(value={"tableTypeAndEnableOperationArgs"})
    public void testMetadataBootstrapLargeCommitList(HoodieTableType tableType, boolean nonPartitionedDataset) throws Exception {
        this.init(tableType, true, true, true, false);
        if (nonPartitionedDataset) {
            testTable.setNonPartitioned();
        }
        for (int i = 1; i < 25; i += 7) {
            String commitTime1 = InProcessTimeGenerator.createNewInstantTime();
            this.doWriteOperation(testTable, commitTime1, WriteOperationType.INSERT, nonPartitionedDataset);
            this.doWriteOperation(testTable, InProcessTimeGenerator.createNewInstantTime(), WriteOperationType.UPSERT, nonPartitionedDataset);
            this.doClean(testTable, InProcessTimeGenerator.createNewInstantTime(), Collections.singletonList(commitTime1));
            this.doWriteOperation(testTable, InProcessTimeGenerator.createNewInstantTime(), WriteOperationType.UPSERT, nonPartitionedDataset);
            if (tableType == HoodieTableType.MERGE_ON_READ) {
                this.doCompaction(testTable, InProcessTimeGenerator.createNewInstantTime(), nonPartitionedDataset);
            }
            String commitTime6 = HoodieInstantTimeGenerator.instantTimePlusMillis((String)InProcessTimeGenerator.createNewInstantTime(), (long)60000L);
            this.doWriteOperation(testTable, commitTime6, WriteOperationType.UPSERT, nonPartitionedDataset);
            this.doRollback(testTable, commitTime6, InProcessTimeGenerator.createNewInstantTime());
        }
        this.validateMetadata(testTable, Collections.emptyList(), nonPartitionedDataset);
    }

    @Test
    public void testClusteringWithRecordIndex() throws Exception {
        this.initPath();
        HoodieWriteConfig writeConfig = this.getWriteConfigBuilder(true, true, false).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.RECORD_INDEX).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).withEnableRecordIndex(true).withRecordIndexFileGroupCount(5, 5).build()).withClusteringConfig(HoodieClusteringConfig.newBuilder().withInlineClustering(Boolean.valueOf(true)).withInlineClusteringNumCommits(2).build()).build();
        this.init(HoodieTableType.COPY_ON_WRITE, writeConfig);
        this.testTableOperationsForMetaIndexImpl(writeConfig);
    }

    @Test
    public void testFailedBootstrap() throws Exception {
        HoodieBackedTableMetadata metadataReader;
        this.init(HoodieTableType.COPY_ON_WRITE);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        HoodieWriteConfig writeConfig = this.getWriteConfigBuilder(true, true, false).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).withEnableRecordIndex(true).withRecordIndexFileGroupCount(5, 5).build()).build();
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, writeConfig);){
            String newCommitTime = client.createNewInstantTime();
            List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(100));
            client.startCommitWithTime(newCommitTime);
            List writeStatuses = client.insert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            this.validateMetadata(client);
            StoragePath metadataTablePath = new StoragePath(HoodieTableMetadata.getMetadataTableBasePath((String)writeConfig.getBasePath()));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.storage.exists(metadataTablePath));
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.metaClient.getTableConfig().isMetadataTableAvailable());
            metadataReader = (HoodieBackedTableMetadata)TestHoodieBackedMetadata.metadata(client, this.storage);
            org.junit.jupiter.api.Assertions.assertEquals((int)HoodieTableMetadataUtil.getPartitionLatestFileSlices((HoodieTableMetaClient)metadataReader.getMetadataMetaClient(), (Option)Option.empty(), (String)MetadataPartitionType.FILES.getPartitionPath()).size(), (int)1);
            org.junit.jupiter.api.Assertions.assertEquals((int)HoodieTableMetadataUtil.getPartitionLatestFileSlices((HoodieTableMetaClient)metadataReader.getMetadataMetaClient(), (Option)Option.empty(), (String)MetadataPartitionType.RECORD_INDEX.getPartitionPath()).size(), (int)5);
        }
        Properties updateProperties = new Properties();
        updateProperties.setProperty(HoodieTableConfig.TABLE_METADATA_PARTITIONS.key(), "");
        HoodieTableConfig.update((HoodieStorage)this.storage, (StoragePath)new StoragePath(this.basePath + "/" + ".hoodie"), (Properties)updateProperties);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.metaClient.getTableConfig().isMetadataTableAvailable());
        writeConfig = this.getWriteConfigBuilder(true, true, false).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).withEnableRecordIndex(true).withRecordIndexFileGroupCount(3, 3).build()).build();
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, writeConfig);){
            String newCommitTime = client.createNewInstantTime();
            List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(100));
            client.startCommitWithTime(newCommitTime);
            List writeStatuses = client.insert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.metaClient.getTableConfig().isMetadataTableAvailable());
            this.validateMetadata(client);
            metadataReader = (HoodieBackedTableMetadata)TestHoodieBackedMetadata.metadata(client, this.storage);
            org.junit.jupiter.api.Assertions.assertEquals((int)HoodieTableMetadataUtil.getPartitionLatestFileSlices((HoodieTableMetaClient)metadataReader.getMetadataMetaClient(), (Option)Option.empty(), (String)MetadataPartitionType.FILES.getPartitionPath()).size(), (int)1);
            org.junit.jupiter.api.Assertions.assertEquals((int)HoodieTableMetadataUtil.getPartitionLatestFileSlices((HoodieTableMetaClient)metadataReader.getMetadataMetaClient(), (Option)Option.empty(), (String)MetadataPartitionType.RECORD_INDEX.getPartitionPath()).size(), (int)3);
        }
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testFirstCommitRollback(HoodieTableType tableType) throws Exception {
        this.init(tableType);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, this.getWriteConfigBuilder(true, true, false).withRollbackUsingMarkers(false).build());){
            String commitTime = "0000001";
            List records = this.dataGen.generateInserts(commitTime, Integer.valueOf(20));
            client.startCommitWithTime(commitTime);
            List writeStatuses = client.insert(this.jsc.parallelize(records, 1), commitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            this.validateMetadata(client);
            client.rollback(commitTime);
            commitTime = "0000002";
            records = this.dataGen.generateInserts(commitTime, Integer.valueOf(10));
            client.startCommitWithTime(commitTime);
            writeStatuses = client.upsert(this.jsc.parallelize(records, 1), commitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            this.validateMetadata(client);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMetadataPayloadSpuriousDeletes(boolean ignoreSpuriousDeletes) throws Exception {
        this.tableType = HoodieTableType.COPY_ON_WRITE;
        this.init(this.tableType, true, true, false, ignoreSpuriousDeletes);
        this.doWriteInsertAndUpsert(testTable);
        this.doWriteOperationAndValidate(testTable, "0000003");
        this.doWriteOperation(testTable, "0000004");
        HashMap<String, List<String>> extraFiles = new HashMap<String, List<String>>();
        extraFiles.put("p1", Collections.singletonList("f10"));
        extraFiles.put("p2", Collections.singletonList("f12"));
        testTable.doRollbackWithExtraFiles("0000004", "0000005", extraFiles);
        this.validateMetadata(testTable);
    }

    @Test
    public void testTableOperationsWithRestore() throws Exception {
        HoodieTableType tableType = HoodieTableType.COPY_ON_WRITE;
        this.init(tableType);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        HoodieWriteConfig writeConfig = this.getWriteConfigBuilder(true, true, false).withRollbackUsingMarkers(false).build();
        this.testTableOperationsImpl(engineContext, writeConfig);
    }

    @Test
    public void testTableOperationsWithRestoreforMOR() throws Exception {
        HoodieTableType tableType = HoodieTableType.MERGE_ON_READ;
        this.init(tableType);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        HoodieWriteConfig writeConfig = this.getWriteConfigBuilder(true, true, false).withRollbackUsingMarkers(false).build();
        this.testTableOperationsImpl(engineContext, writeConfig);
    }

    @Test
    public void testColStatsPrefixLookup() throws IOException {
        this.tableType = HoodieTableType.COPY_ON_WRITE;
        this.initPath();
        this.initSparkContexts("TestHoodieMetadata");
        this.initHoodieStorage();
        this.storage.createDirectory(new StoragePath(this.basePath));
        this.initTimelineService();
        this.initMetaClient(this.tableType);
        this.initTestDataGenerator();
        this.metadataTableBasePath = HoodieTableMetadata.getMetadataTableBasePath((String)this.basePath);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        HoodieWriteConfig writeConfig = this.getWriteConfigBuilder(true, true, false).withRollbackUsingMarkers(false).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.EAGER).withAutoClean(Boolean.valueOf(false)).retainCommits(1).retainFileVersions(1).build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().compactionSmallFileSize(0L).withInlineCompaction(Boolean.valueOf(false)).withMaxNumDeltaCommitsBeforeCompaction(1).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexColumnStats(true).build()).build();
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, writeConfig);){
            String firstCommit = "0000001";
            List records = this.dataGen.generateInserts(firstCommit, Integer.valueOf(20));
            AtomicInteger counter = new AtomicInteger();
            List processedRecords = records.stream().map(entry -> new HoodieAvroRecord(new HoodieKey("key1_" + counter.getAndIncrement(), entry.getPartitionPath()), (HoodieRecordPayload)entry.getData())).collect(Collectors.toList());
            client.startCommitWithTime(firstCommit);
            List writeStatuses = client.insert(this.jsc.parallelize(processedRecords, 1), firstCommit).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            String secondCommit = "0000002";
            client.startCommitWithTime(secondCommit);
            records = this.dataGen.generateInserts(secondCommit, Integer.valueOf(20));
            AtomicInteger counter1 = new AtomicInteger();
            processedRecords = records.stream().map(entry -> new HoodieAvroRecord(new HoodieKey("key2_" + counter1.getAndIncrement(), entry.getPartitionPath()), (HoodieRecordPayload)entry.getData())).collect(Collectors.toList());
            writeStatuses = client.insert(this.jsc.parallelize(processedRecords, 1), secondCommit).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            HashMap commitToPartitionsToFiles = new HashMap();
            this.metaClient.getActiveTimeline().getInstants().forEach(entry -> {
                try {
                    HoodieCommitMetadata commitMetadata = this.metaClient.getActiveTimeline().readCommitMetadata(entry);
                    String commitTime = entry.requestedTime();
                    if (!commitToPartitionsToFiles.containsKey(commitTime)) {
                        commitToPartitionsToFiles.put(commitTime, new HashMap());
                    }
                    commitMetadata.getPartitionToWriteStats().entrySet().stream().forEach(partitionWriteStat -> {
                        String partitionStatName = (String)partitionWriteStat.getKey();
                        List writeStats = (List)partitionWriteStat.getValue();
                        String partition = HoodieTableMetadataUtil.getColumnStatsIndexPartitionIdentifier((String)partitionStatName);
                        if (!((Map)commitToPartitionsToFiles.get(commitTime)).containsKey(partition)) {
                            ((Map)commitToPartitionsToFiles.get(commitTime)).put(partition, new ArrayList());
                        }
                        writeStats.forEach(writeStat -> ((List)((Map)commitToPartitionsToFiles.get(commitTime)).get(partition)).add(writeStat.getPath()));
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            HoodieTableMetadata tableMetadata = TestHoodieBackedMetadata.metadata(client, this.storage);
            ColumnIndexID columnIndexID = new ColumnIndexID(HoodieRecord.RECORD_KEY_METADATA_FIELD);
            List result = tableMetadata.getRecordsByKeyPrefixes(Collections.singletonList(columnIndexID.asBase64EncodedString()), MetadataPartitionType.COLUMN_STATS.getPartitionPath(), true).collectAsList();
            org.junit.jupiter.api.Assertions.assertEquals((int)result.size(), (int)6);
            PartitionIndexID partitionIndexID = new PartitionIndexID("2016/03/15");
            result = tableMetadata.getRecordsByKeyPrefixes(Collections.singletonList(columnIndexID.asBase64EncodedString().concat(partitionIndexID.asBase64EncodedString())), MetadataPartitionType.COLUMN_STATS.getPartitionPath(), true).collectAsList();
            org.junit.jupiter.api.Assertions.assertEquals((int)result.size(), (int)2);
            result.forEach(entry -> {
                HoodieMetadataColumnStats metadataColumnStats = (HoodieMetadataColumnStats)((HoodieMetadataPayload)entry.getData()).getColumnStatMetadata().get();
                String fileName = metadataColumnStats.getFileName();
                if (fileName.contains(firstCommit)) {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)((List)((Map)commitToPartitionsToFiles.get(firstCommit)).get("2016/03/15")).contains("2016/03/15/" + fileName));
                } else {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)((List)((Map)commitToPartitionsToFiles.get(secondCommit)).get("2016/03/15")).contains("2016/03/15/" + fileName));
                }
            });
            columnIndexID = new ColumnIndexID(HoodieRecord.COMMIT_TIME_METADATA_FIELD);
            result = tableMetadata.getRecordsByKeyPrefixes(Collections.singletonList(columnIndexID.asBase64EncodedString().concat(partitionIndexID.asBase64EncodedString())), MetadataPartitionType.COLUMN_STATS.getPartitionPath(), true).collectAsList();
            org.junit.jupiter.api.Assertions.assertEquals((int)result.size(), (int)2);
            result.forEach(entry -> {
                HoodieMetadataColumnStats metadataColumnStats = (HoodieMetadataColumnStats)((HoodieMetadataPayload)entry.getData()).getColumnStatMetadata().get();
                org.junit.jupiter.api.Assertions.assertEquals((Object)metadataColumnStats.getMinValue(), (Object)metadataColumnStats.getMaxValue());
                String fileName = metadataColumnStats.getFileName();
                if (fileName.contains(firstCommit)) {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)((List)((Map)commitToPartitionsToFiles.get(firstCommit)).get("2016/03/15")).contains("2016/03/15/" + fileName));
                } else {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)((List)((Map)commitToPartitionsToFiles.get(secondCommit)).get("2016/03/15")).contains("2016/03/15/" + fileName));
                }
            });
        }
    }

    @Test
    public void testEagerRollbackinMDT() throws IOException {
        this.tableType = HoodieTableType.MERGE_ON_READ;
        this.initPath();
        this.init(this.tableType);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, this.writeConfig);
        String commit1 = client.createNewInstantTime();
        List records = this.dataGen.generateInserts(commit1, Integer.valueOf(20));
        client.startCommitWithTime(commit1);
        List writeStatuses = client.bulkInsert(this.jsc.parallelize(records, 1), commit1).collect();
        Assertions.assertNoWriteErrors((List)writeStatuses);
        String commit2 = client.createNewInstantTime();
        client.startCommitWithTime(commit2);
        records = this.dataGen.generateInserts(commit2, Integer.valueOf(20));
        writeStatuses = client.insert(this.jsc.parallelize(records, 1), commit2).collect();
        Assertions.assertNoWriteErrors((List)writeStatuses);
        StoragePath toDelete = HoodieTestUtils.getCompleteInstantPath((HoodieStorage)this.metaClient.getStorage(), (StoragePath)new StoragePath(this.metaClient.getMetaPath() + "/metadata/.hoodie/timeline/"), (String)commit2, (String)"deltacommit");
        this.metaClient.getStorage().deleteDirectory(toDelete);
        client.close();
        client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, this.writeConfig);
        String commit3 = client.createNewInstantTime();
        client.startCommitWithTime(commit3);
        records = this.dataGen.generateUniqueUpdates(commit3, Integer.valueOf(10));
        writeStatuses = client.upsert(this.jsc.parallelize(records, 1), commit3).collect();
        Assertions.assertNoWriteErrors((List)writeStatuses);
        HoodieTableMetaClient metadataMetaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)this.metaClient.getStorageConf(), (String)(this.metaClient.getMetaPath() + "/metadata/"));
        HoodieInstant rollbackInstant = (HoodieInstant)metadataMetaClient.getActiveTimeline().getRollbackTimeline().getInstants().get(0);
        List metaFiles = this.metaClient.getStorage().listDirectEntries(new StoragePath(this.metaClient.getMetaPath(), "metadata/.hoodie/timeline/"));
        List commit3Files = metaFiles.stream().filter(pathInfo -> pathInfo.getPath().getName().contains(commit3) && pathInfo.getPath().getName().endsWith("deltacommit")).collect(Collectors.toList());
        List rollbackFiles = metaFiles.stream().filter(pathInfo -> pathInfo.getPath().getName().equals(HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.getFileName(rollbackInstant))).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertTrue((((StoragePathInfo)commit3Files.get(0)).getModificationTime() >= ((StoragePathInfo)rollbackFiles.get(0)).getModificationTime() ? 1 : 0) != 0);
        client.close();
    }

    private void testTableOperationsImpl(HoodieSparkEngineContext engineContext, HoodieWriteConfig writeConfig) throws Exception {
        String newCommitTime = null;
        String instantToRestore = null;
        List records = new ArrayList();
        List writeStatuses = null;
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, writeConfig);){
            newCommitTime = client.createNewInstantTime();
            records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(20));
            client.startCommitWithTime(newCommitTime);
            writeStatuses = client.bulkInsert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            this.validateMetadata(client);
            newCommitTime = client.createNewInstantTime();
            client.startCommitWithTime(newCommitTime);
            this.validateMetadata(client);
            records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(20));
            writeStatuses = client.insert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            this.validateMetadata(client);
            newCommitTime = client.createNewInstantTime();
            client.startCommitWithTime(newCommitTime);
            records = this.dataGen.generateUniqueUpdates(newCommitTime, Integer.valueOf(10));
            writeStatuses = client.upsert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            newCommitTime = client.createNewInstantTime();
            client.startCommitWithTime(newCommitTime);
            records = this.dataGen.generateUpdates(newCommitTime, Integer.valueOf(10));
            writeStatuses = client.upsert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            this.validateMetadata(client);
            if (this.metaClient.getTableType() == HoodieTableType.MERGE_ON_READ) {
                newCommitTime = client.createNewInstantTime();
                client.scheduleCompactionAtInstant(newCommitTime, Option.empty());
                client.compact(newCommitTime);
                this.validateMetadata(client);
            }
            instantToRestore = newCommitTime = client.createNewInstantTime();
            client.startCommitWithTime(newCommitTime);
            records = this.dataGen.generateUpdates(newCommitTime, Integer.valueOf(5));
            writeStatuses = client.upsert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            this.validateMetadata(client);
        }
        client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, writeConfig);
        var8_8 = null;
        try {
            if (this.metaClient.getTableType() == HoodieTableType.MERGE_ON_READ) {
                newCommitTime = client.createNewInstantTime();
                client.scheduleCompactionAtInstant(newCommitTime, Option.empty());
                client.compact(newCommitTime);
                this.validateMetadata(client);
            }
            newCommitTime = client.createNewInstantTime();
            client.startCommitWithTime(newCommitTime);
            records = this.dataGen.generateUpdates(newCommitTime, Integer.valueOf(5));
            writeStatuses = client.upsert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            newCommitTime = client.createNewInstantTime();
            client.clean(newCommitTime);
            this.validateMetadata(client);
            client.restoreToInstant(instantToRestore, writeConfig.isMetadataTableEnabled());
            this.validateMetadata(client);
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (client != null) {
                if (var8_8 != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    client.close();
                }
            }
        }
    }

    @Test
    public void testMetadataMultiWriter() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        Properties properties = new Properties();
        properties.setProperty("hoodie.write.lock.filesystem.path", this.basePath + "/.hoodie/.locks");
        properties.setProperty("hoodie.write.lock.wait_time_ms", "1000");
        properties.setProperty("hoodie.write.lock.client.num_retries", "20");
        HoodieWriteConfig writeConfig = this.getWriteConfigBuilder(true, true, false).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).withAutoClean(Boolean.valueOf(false)).build()).withWriteConcurrencyMode(WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL).withLockConfig(HoodieLockConfig.newBuilder().withLockProvider(InProcessLockProvider.class).build()).withProperties(properties).build();
        SparkRDDWriteClient writeClient = new SparkRDDWriteClient((HoodieEngineContext)engineContext, writeConfig);
        String initialCommit = "0000000";
        List initialRecords = this.dataGen.generateInserts(initialCommit, Integer.valueOf(100));
        writeClient.startCommitWithTime(initialCommit);
        List initialWriteStatuses = writeClient.insert(this.jsc.parallelize(initialRecords, 1), initialCommit).collect();
        Assertions.assertNoWriteErrors((List)initialWriteStatuses);
        writeClient.close();
        ExecutorService executors = Executors.newFixedThreadPool(this.dataGen.getPartitionPaths().length);
        SparkRDDWriteClient[] writeClients = new SparkRDDWriteClient[this.dataGen.getPartitionPaths().length];
        for (int i = 0; i < this.dataGen.getPartitionPaths().length; ++i) {
            writeClients[i] = new SparkRDDWriteClient((HoodieEngineContext)engineContext, writeConfig);
        }
        LinkedList futures = new LinkedList();
        int i = 0;
        while (i < this.dataGen.getPartitionPaths().length) {
            int n = i++;
            String newCommitTime = "000000" + (n + 2);
            Future<?> future = executors.submit(() -> {
                List records = this.dataGen.generateInsertsForPartition(newCommitTime, Integer.valueOf(100), this.dataGen.getPartitionPaths()[index]);
                SparkRDDWriteClient localWriteClient = writeClients[index];
                writeClient.startCommitWithTime(newCommitTime);
                List writeStatuses = localWriteClient.insert(this.jsc.parallelize(records, 1), newCommitTime).collect();
                Assertions.assertNoWriteErrors((List)writeStatuses);
            });
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        executors.shutdown();
        HoodieTableMetaClient metadataMetaClient = this.createMetaClient(this.metadataTableBasePath);
        org.junit.jupiter.api.Assertions.assertEquals((int)metadataMetaClient.getActiveTimeline().getDeltaCommitTimeline().filterCompletedInstants().countInstants(), (int)6);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)metadataMetaClient.getActiveTimeline().containsInstant(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", "0000002")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)metadataMetaClient.getActiveTimeline().containsInstant(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", "0000003")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)metadataMetaClient.getActiveTimeline().containsInstant(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", "0000004")));
        org.junit.jupiter.api.Assertions.assertTrue((metadataMetaClient.getActiveTimeline().getCommitAndReplaceTimeline().filterCompletedInstants().countInstants() <= 1 ? 1 : 0) != 0);
        this.validateMetadata(writeClients[0]);
        Arrays.stream(writeClients).forEach(BaseHoodieWriteClient::close);
    }

    @Test
    public void testMultiWriterForDoubleLocking() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        Properties properties = new Properties();
        properties.setProperty("hoodie.write.lock.filesystem.path", this.basePath + "/.hoodie/.locks");
        properties.setProperty("hoodie.write.lock.wait_time_ms", "3000");
        HoodieWriteConfig writeConfig = this.getWriteConfigBuilder(true, true, false).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).withAutoClean(Boolean.valueOf(true)).retainCommits(4).build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().compactionSmallFileSize(0x40000000L).build()).withAutoCommit(false).withWriteConcurrencyMode(WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL).withLockConfig(HoodieLockConfig.newBuilder().withLockProvider(InProcessLockProvider.class).build()).withProperties(properties).build();
        try (SparkRDDWriteClient writeClient = new SparkRDDWriteClient((HoodieEngineContext)engineContext, writeConfig);){
            String partitionPath = this.dataGen.getPartitionPaths()[0];
            for (int j = 0; j < 6; ++j) {
                String newCommitTime = writeClient.createNewInstantTime();
                List records = this.dataGen.generateInsertsForPartition(newCommitTime, Integer.valueOf(100), partitionPath);
                writeClient.startCommitWithTime(newCommitTime);
                JavaRDD writeStatuses = writeClient.insert(this.jsc.parallelize(records, 1), newCommitTime);
                writeClient.commit(newCommitTime, (Object)writeStatuses);
            }
            HoodieTableMetaClient metadataMetaClient = this.createMetaClient(this.metadataTableBasePath);
            LOG.warn("total commits in metadata table " + metadataMetaClient.getActiveTimeline().getCommitsTimeline().countInstants());
            org.junit.jupiter.api.Assertions.assertEquals((int)metadataMetaClient.getActiveTimeline().getDeltaCommitTimeline().filterCompletedInstants().countInstants(), (int)9);
            org.junit.jupiter.api.Assertions.assertTrue((metadataMetaClient.getActiveTimeline().getCommitAndReplaceTimeline().filterCompletedInstants().countInstants() <= 1 ? 1 : 0) != 0);
            this.validateMetadata(writeClient);
        }
    }

    @Test
    public void testReattemptOfFailedClusteringCommit() throws Exception {
        this.tableType = HoodieTableType.COPY_ON_WRITE;
        this.init(this.tableType);
        this.context = new HoodieSparkEngineContext(this.jsc);
        HoodieWriteConfig config = this.getSmallInsertWriteConfigForMDT(2000, "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", 10L, false);
        SparkRDDWriteClient client = this.getHoodieWriteClient(config);
        String newCommitTime = "0000001";
        List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(20));
        client.startCommitWithTime(newCommitTime);
        List writeStatuses = client.insert(this.jsc.parallelize(records, 1), newCommitTime).collect();
        Assertions.assertNoWriteErrors((List)writeStatuses);
        this.validateMetadata(client);
        newCommitTime = "0000002";
        client.startCommitWithTime(newCommitTime);
        records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(20));
        writeStatuses = client.insert(this.jsc.parallelize(records, 1), newCommitTime).collect();
        Assertions.assertNoWriteErrors((List)writeStatuses);
        this.validateMetadata(client);
        HoodieClusteringConfig clusteringConfig = HoodieClusteringConfig.newBuilder().withClusteringMaxNumGroups(10).withClusteringSortColumns("_row_key").withInlineClustering(Boolean.valueOf(true)).withClusteringTargetPartitions(0).withInlineClusteringNumCommits(1).build();
        HoodieWriteConfig newWriteConfig = this.getConfigBuilder("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", HoodieIndex.IndexType.BLOOM, HoodieFailedWritesCleaningPolicy.EAGER).withAutoCommit(false).withClusteringConfig(clusteringConfig).withRollbackUsingMarkers(false).build();
        SparkRDDWriteClient newClient = this.getHoodieWriteClient(newWriteConfig);
        String clusteringCommitTime = newClient.scheduleClustering(Option.empty()).get().toString();
        HoodieWriteMetadata clusterMetadata = newClient.cluster(clusteringCommitTime, true);
        HashSet replacedFileIds = new HashSet();
        clusterMetadata.getPartitionToReplaceFileIds().entrySet().forEach(partitionFiles -> ((List)partitionFiles.getValue()).stream().forEach(file -> replacedFileIds.add(new HoodieFileGroupId((String)partitionFiles.getKey(), file))));
        newCommitTime = "0000003";
        client.startCommitWithTime(newCommitTime);
        records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(20));
        writeStatuses = client.insert(this.jsc.parallelize(records, 1), newCommitTime).collect();
        Assertions.assertNoWriteErrors((List)writeStatuses);
        this.validateMetadata(client);
        FileCreateUtilsLegacy.deleteReplaceCommit((String)this.basePath, (String)clusteringCommitTime);
        HoodieWriteMetadata updatedClusterMetadata = newClient.cluster(clusteringCommitTime, true);
        this.metaClient.reloadActiveTimeline();
        HashSet updatedReplacedFileIds = new HashSet();
        updatedClusterMetadata.getPartitionToReplaceFileIds().entrySet().forEach(partitionFiles -> ((List)partitionFiles.getValue()).stream().forEach(file -> updatedReplacedFileIds.add(new HoodieFileGroupId((String)partitionFiles.getKey(), file))));
        org.junit.jupiter.api.Assertions.assertEquals(replacedFileIds, updatedReplacedFileIds);
        this.validateMetadata(client);
    }

    @Test
    public void testMDTCompactionWithFailedCommits() throws Exception {
        this.tableType = HoodieTableType.COPY_ON_WRITE;
        this.init(this.tableType);
        this.context = new HoodieSparkEngineContext(this.jsc);
        HoodieWriteConfig initialConfig = this.getSmallInsertWriteConfigForMDT(2000, "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", 10L, false);
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withProperties((Properties)initialConfig.getProps()).withMetadataConfig(HoodieMetadataConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(4).build()).build();
        SparkRDDWriteClient client = this.getHoodieWriteClient(config);
        String newCommitTime = client.createNewInstantTime();
        List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(20));
        client.startCommitWithTime(newCommitTime);
        List writeStatuses = client.insert(this.jsc.parallelize(records, 1), newCommitTime).collect();
        Assertions.assertNoWriteErrors((List)writeStatuses);
        this.validateMetadata(client);
        newCommitTime = client.createNewInstantTime();
        client.startCommitWithTime(newCommitTime);
        records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(20));
        writeStatuses = client.insert(this.jsc.parallelize(records, 1), newCommitTime).collect();
        Assertions.assertNoWriteErrors((List)writeStatuses);
        this.validateMetadata(client);
        HoodieClusteringConfig clusteringConfig = HoodieClusteringConfig.newBuilder().withClusteringMaxNumGroups(10).withClusteringSortColumns("_row_key").withInlineClustering(Boolean.valueOf(true)).withClusteringTargetPartitions(0).withInlineClusteringNumCommits(1).build();
        HoodieWriteConfig newWriteConfig = this.getConfigBuilder("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", HoodieIndex.IndexType.BLOOM, HoodieFailedWritesCleaningPolicy.EAGER).withAutoCommit(false).withClusteringConfig(clusteringConfig).build();
        SparkRDDWriteClient newClient = this.getHoodieWriteClient(newWriteConfig);
        String clusteringCommitTime = newClient.scheduleClustering(Option.empty()).get().toString();
        HoodieWriteMetadata clusterMetadata = newClient.cluster(clusteringCommitTime, true);
        FileCreateUtilsLegacy.deleteReplaceCommit((String)this.basePath, (String)clusteringCommitTime);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieWriteConfig updatedWriteConfig = HoodieWriteConfig.newBuilder().withProperties((Properties)initialConfig.getProps()).withMetadataConfig(HoodieMetadataConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(4).build()).withRollbackUsingMarkers(false).build();
        client = this.getHoodieWriteClient(updatedWriteConfig);
        newCommitTime = client.createNewInstantTime();
        client.startCommitWithTime(newCommitTime);
        records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(20));
        writeStatuses = client.insert(this.jsc.parallelize(records, 1), newCommitTime).collect();
        Assertions.assertNoWriteErrors((List)writeStatuses);
        this.validateMetadata(client, (Option<String>)Option.of((Object)clusteringCommitTime));
    }

    @Test
    public void testMetadataReadWithNoCompletedCommits() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, this.getWriteConfig(true, true));){
            String[] commitTimestamps = new String[]{client.createNewInstantTime(), client.createNewInstantTime()};
            List records = this.dataGen.generateInserts(commitTimestamps[0], Integer.valueOf(5));
            client.startCommitWithTime(commitTimestamps[0]);
            List writeStatuses = client.bulkInsert(this.jsc.parallelize(records, 1), commitTimestamps[0]).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            FileCreateUtilsLegacy.deleteDeltaCommit((String)(this.basePath + "/.hoodie/metadata/"), (String)commitTimestamps[0]);
            FileCreateUtilsLegacy.deleteDeltaCommit((String)(this.basePath + " /.hoodie/metadata/"), (String)"00000000000000");
            org.junit.jupiter.api.Assertions.assertEquals((int)this.getAllFiles(TestHoodieBackedMetadata.metadata(client, this.storage)).stream().map(p -> p.getName()).map(n -> FSUtils.getCommitTime((String)n)).collect(Collectors.toSet()).size(), (int)0);
        }
    }

    @Test
    public void testReader() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, this.getWriteConfig(true, true));){
            int i;
            String[] commitTimestamps = new String[]{client.createNewInstantTime(), client.createNewInstantTime(), client.createNewInstantTime(), client.createNewInstantTime()};
            for (int i2 = 0; i2 < commitTimestamps.length; ++i2) {
                List records = this.dataGen.generateInserts(commitTimestamps[i2], Integer.valueOf(5));
                client.startCommitWithTime(commitTimestamps[i2]);
                List writeStatuses = client.bulkInsert(this.jsc.parallelize(records, 1), commitTimestamps[i2]).collect();
                Assertions.assertNoWriteErrors((List)writeStatuses);
            }
            Set timelineTimestamps = this.getAllFiles(TestHoodieBackedMetadata.metadata(client, this.storage)).stream().map(p -> p.getName()).map(n -> FSUtils.getCommitTime((String)n)).collect(Collectors.toSet());
            org.junit.jupiter.api.Assertions.assertEquals((int)timelineTimestamps.size(), (int)commitTimestamps.length);
            for (i = 0; i < commitTimestamps.length; ++i) {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)timelineTimestamps.contains(commitTimestamps[i]));
            }
            for (i = 0; i < commitTimestamps.length; ++i) {
                FileCreateUtilsLegacy.deleteCommit((String)this.basePath, (String)commitTimestamps[i]);
                timelineTimestamps = this.getAllFiles(TestHoodieBackedMetadata.metadata(client, this.storage)).stream().map(p -> p.getName()).map(n -> FSUtils.getCommitTime((String)n)).collect(Collectors.toSet());
                org.junit.jupiter.api.Assertions.assertEquals((int)timelineTimestamps.size(), (int)(commitTimestamps.length - 1));
                for (int j = 0; j < commitTimestamps.length; ++j) {
                    org.junit.jupiter.api.Assertions.assertTrue((j == i || timelineTimestamps.contains(commitTimestamps[j]) ? 1 : 0) != 0);
                }
                FileCreateUtilsLegacy.createCommit((String)this.basePath, (String)commitTimestamps[i]);
            }
            FileCreateUtilsLegacy.deleteCommit((String)this.basePath, (String)commitTimestamps[0]);
            FileCreateUtilsLegacy.deleteCommit((String)this.basePath, (String)commitTimestamps[2]);
            timelineTimestamps = this.getAllFiles(TestHoodieBackedMetadata.metadata(client, this.storage)).stream().map(p -> p.getName()).map(n -> FSUtils.getCommitTime((String)n)).collect(Collectors.toSet());
            org.junit.jupiter.api.Assertions.assertEquals((int)timelineTimestamps.size(), (int)(commitTimestamps.length - 2));
            for (int j = 0; j < commitTimestamps.length; ++j) {
                org.junit.jupiter.api.Assertions.assertTrue((j == 0 || j == 2 || timelineTimestamps.contains(commitTimestamps[j]) ? 1 : 0) != 0);
            }
            for (i = 0; i < commitTimestamps.length; ++i) {
                FileCreateUtilsLegacy.deleteCommit((String)this.basePath, (String)commitTimestamps[i]);
            }
            timelineTimestamps = this.getAllFiles(TestHoodieBackedMetadata.metadata(client, this.storage)).stream().map(p -> p.getName()).map(n -> FSUtils.getCommitTime((String)n)).collect(Collectors.toSet());
            org.junit.jupiter.api.Assertions.assertEquals((int)timelineTimestamps.size(), (int)0);
        }
    }

    @Disabled
    public void testCleaningArchivingAndCompaction() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE, false);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        int maxDeltaCommitsBeforeCompaction = 3;
        HoodieWriteConfig config = this.getWriteConfigBuilder(true, true, false).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).withMaxNumDeltaCommitsBeforeCompaction(3).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.NEVER).retainCommits(1).retainFileVersions(1).withAutoClean(Boolean.valueOf(true)).withAsyncClean(Boolean.valueOf(false)).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(4, 5).build()).build();
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, config);){
            List records;
            String newCommitTime;
            for (int i = 0; i < 1; ++i) {
                newCommitTime = client.createNewInstantTime();
                records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(5));
                client.startCommitWithTime(newCommitTime);
                client.insert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            }
            HoodieTableMetaClient metadataMetaClient = this.createMetaClient(this.metadataTableBasePath);
            HoodieTableMetaClient datasetMetaClient = this.createMetaClient(config.getBasePath());
            HoodieActiveTimeline metadataTimeline = metadataMetaClient.reloadActiveTimeline();
            org.junit.jupiter.api.Assertions.assertEquals((int)metadataTimeline.getCommitAndReplaceTimeline().filterCompletedInstants().countInstants(), (int)0);
            org.junit.jupiter.api.Assertions.assertEquals((int)metadataTimeline.getCommitsTimeline().filterCompletedInstants().countInstants(), (int)2);
            org.junit.jupiter.api.Assertions.assertEquals((int)datasetMetaClient.getArchivedTimeline().reload().countInstants(), (int)0);
            newCommitTime = client.createNewInstantTime();
            records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(5));
            client.startCommitWithTime(newCommitTime);
            client.insert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            metadataTimeline = metadataMetaClient.reloadActiveTimeline();
            org.junit.jupiter.api.Assertions.assertEquals((int)metadataTimeline.getCommitAndReplaceTimeline().filterCompletedInstants().countInstants(), (int)1);
            org.junit.jupiter.api.Assertions.assertEquals((int)metadataTimeline.getCommitsTimeline().filterCompletedInstants().countInstants(), (int)4);
            org.junit.jupiter.api.Assertions.assertEquals((int)datasetMetaClient.getArchivedTimeline().reload().countInstants(), (int)0);
            String inflightCommitTime = newCommitTime;
            for (int i = 0; i < 4; ++i) {
                newCommitTime = client.createNewInstantTime();
                records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(5));
                client.startCommitWithTime(newCommitTime);
                client.insert(this.jsc.parallelize(records, 1), newCommitTime).collect();
                if (i != 0) continue;
                FileCreateUtilsLegacy.deleteCommit((String)this.basePath, (String)newCommitTime);
                FileCreateUtilsLegacy.createInflightCommit((String)this.basePath, (String)newCommitTime);
                inflightCommitTime = newCommitTime;
            }
            metadataTimeline = metadataMetaClient.reloadActiveTimeline();
            org.junit.jupiter.api.Assertions.assertEquals((int)metadataTimeline.getCommitAndReplaceTimeline().filterCompletedInstants().countInstants(), (int)1);
            org.junit.jupiter.api.Assertions.assertEquals((int)metadataTimeline.getDeltaCommitTimeline().filterCompletedInstants().countInstants(), (int)10);
            FileCreateUtilsLegacy.createCommit((String)this.basePath, (String)inflightCommitTime);
            newCommitTime = client.createNewInstantTime();
            records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(5));
            client.startCommitWithTime(newCommitTime);
            client.insert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            metadataTimeline = metadataMetaClient.reloadActiveTimeline();
            org.junit.jupiter.api.Assertions.assertEquals((int)metadataTimeline.getCommitAndReplaceTimeline().filterCompletedInstants().countInstants(), (int)2);
            org.junit.jupiter.api.Assertions.assertEquals((int)metadataTimeline.getDeltaCommitTimeline().filterCompletedInstants().countInstants(), (int)12);
            org.junit.jupiter.api.Assertions.assertTrue((datasetMetaClient.getArchivedTimeline().reload().countInstants() > 0 ? 1 : 0) != 0);
            this.validateMetadata(client);
        }
    }

    @Test
    public void testUpgradeDowngrade() throws IOException {
        List writeStatuses;
        List records;
        String commitTimestamp;
        this.init(HoodieTableType.COPY_ON_WRITE, false);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        HoodieTableConfig tableConfig = this.metaClient.getTableConfig();
        tableConfig.setTableVersion(HoodieTableVersion.SIX);
        this.initMetaClient(HoodieTableType.COPY_ON_WRITE, (Properties)tableConfig.getProps());
        HoodieWriteConfig writeConfig = this.getWriteConfigBuilder(true, true, false).withWriteTableVersion(6).build();
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, writeConfig);){
            commitTimestamp = client.createNewInstantTime();
            records = this.dataGen.generateInserts(commitTimestamp, Integer.valueOf(5));
            client.startCommitWithTime(commitTimestamp);
            writeStatuses = client.bulkInsert(this.jsc.parallelize(records, 1), commitTimestamp).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.storage.exists(new StoragePath(this.metadataTableBasePath)), (String)"Metadata table should exist");
        StoragePathInfo oldInfo = this.storage.getPathInfo(new StoragePath(this.metadataTableBasePath));
        this.changeTableVersion(HoodieTableVersion.TWO);
        HoodieTableConfig tableConfig2 = this.metaClient.getTableConfig();
        tableConfig2.setTableVersion(HoodieTableVersion.SIX);
        this.initMetaClient(HoodieTableType.COPY_ON_WRITE, (Properties)tableConfig2.getProps());
        HoodieWriteConfig writeConfig2 = this.getWriteConfigBuilder(true, true, false).withWriteTableVersion(HoodieTableVersion.SIX.versionCode()).build();
        this.metaClient.reloadActiveTimeline();
        StoragePathInfo prevInfo = this.storage.getPathInfo(new StoragePath(this.metadataTableBasePath));
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, writeConfig2);){
            commitTimestamp = client.createNewInstantTime();
            records = this.dataGen.generateInserts(commitTimestamp, Integer.valueOf(5));
            client.startCommitWithTime(commitTimestamp);
            writeStatuses = client.bulkInsert(this.jsc.parallelize(records, 1), commitTimestamp).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.storage.exists(new StoragePath(this.metadataTableBasePath)), (String)"Metadata table should exist");
        StoragePathInfo currentInfo = this.storage.getPathInfo(new StoragePath(this.metadataTableBasePath));
        org.junit.jupiter.api.Assertions.assertTrue((currentInfo.getModificationTime() == prevInfo.getModificationTime() ? 1 : 0) != 0);
        this.initMetaClient();
        org.junit.jupiter.api.Assertions.assertEquals((int)this.metaClient.getTableConfig().getTableVersion().versionCode(), (int)HoodieTableVersion.current().versionCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.storage.exists(new StoragePath(this.metadataTableBasePath)), (String)"Metadata table should exist");
        StoragePathInfo newInfo = this.storage.getPathInfo(new StoragePath(this.metadataTableBasePath));
        org.junit.jupiter.api.Assertions.assertTrue((oldInfo.getModificationTime() == newInfo.getModificationTime() ? 1 : 0) != 0);
        new UpgradeDowngrade(this.metaClient, writeConfig, (HoodieEngineContext)this.context, (SupportsUpgradeDowngrade)SparkUpgradeDowngradeHelper.getInstance()).run(HoodieTableVersion.TWO, null);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        org.junit.jupiter.api.Assertions.assertEquals((int)HoodieTableVersion.TWO.versionCode(), (int)this.metaClient.getTableConfig().getTableVersion().versionCode());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.storage.exists(new StoragePath(this.metadataTableBasePath)), (String)"Metadata table should not exist");
    }

    @Test
    public void testRollbackDuringUpgradeForDoubleLocking() throws IOException {
        JavaRDD writeStatuses;
        List records;
        String commitTimestamp;
        this.init(HoodieTableType.COPY_ON_WRITE, false);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        Properties properties = new Properties();
        properties.setProperty("hoodie.write.lock.filesystem.path", this.basePath + "/.hoodie/.locks");
        properties.setProperty("hoodie.write.lock.client.num_retries", "3");
        properties.setProperty("hoodie.write.lock.wait_time_ms", "3000");
        HoodieWriteConfig writeConfig = this.getWriteConfigBuilder(false, true, false).withWriteTableVersion(6).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).withAutoClean(Boolean.valueOf(false)).build()).withWriteConcurrencyMode(WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL).withLockConfig(HoodieLockConfig.newBuilder().withLockProvider(InProcessLockProvider.class).build()).withProperties(properties).build();
        HoodieTableConfig tableConfig = this.metaClient.getTableConfig();
        tableConfig.setTableVersion(HoodieTableVersion.SIX);
        this.initMetaClient(HoodieTableType.COPY_ON_WRITE, (Properties)tableConfig.getProps());
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, writeConfig);){
            commitTimestamp = client.createNewInstantTime();
            records = this.dataGen.generateInserts(commitTimestamp, Integer.valueOf(5));
            client.startCommitWithTime(commitTimestamp);
            writeStatuses = client.insert(this.jsc.parallelize(records, 1), commitTimestamp);
            client.commit(commitTimestamp, (Object)writeStatuses);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.storage.exists(new StoragePath(this.metadataTableBasePath)), (String)"Metadata table should exist");
        StoragePathInfo oldInfo = this.storage.getPathInfo(new StoragePath(this.metadataTableBasePath));
        this.metaClient.reloadActiveTimeline();
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, writeConfig);){
            commitTimestamp = client.createNewInstantTime();
            records = this.dataGen.generateInserts(commitTimestamp, Integer.valueOf(5));
            client.startCommitWithTime(commitTimestamp);
            writeStatuses = client.insert(this.jsc.parallelize(records, 1), commitTimestamp);
        }
        this.changeTableVersion(HoodieTableVersion.TWO);
        HoodieTableConfig tableConfig2 = this.metaClient.getTableConfig();
        tableConfig2.setTableVersion(HoodieTableVersion.SIX);
        this.initMetaClient(HoodieTableType.COPY_ON_WRITE, (Properties)tableConfig2.getProps());
        writeConfig = this.getWriteConfigBuilder(true, true, false).withRollbackUsingMarkers(false).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).withAutoClean(Boolean.valueOf(false)).build()).withWriteConcurrencyMode(WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL).withLockConfig(HoodieLockConfig.newBuilder().withLockProvider(InProcessLockProvider.class).build()).withProperties(properties).withEmbeddedTimelineServerEnabled(false).withWriteTableVersion(HoodieTableVersion.SIX.versionCode()).build();
        this.metaClient.reloadActiveTimeline();
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, writeConfig);){
            commitTimestamp = client.createNewInstantTime();
            records = this.dataGen.generateInserts(commitTimestamp, Integer.valueOf(5));
            client.startCommitWithTime(commitTimestamp);
            writeStatuses = client.insert(this.jsc.parallelize(records, 1), commitTimestamp);
            Assertions.assertNoWriteErrors((List)writeStatuses.collect());
        }
        this.initMetaClient();
        org.junit.jupiter.api.Assertions.assertEquals((int)this.metaClient.getTableConfig().getTableVersion().versionCode(), (int)HoodieTableVersion.current().versionCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.storage.exists(new StoragePath(this.metadataTableBasePath)), (String)"Metadata table should exist");
        StoragePathInfo newInfo = this.storage.getPathInfo(new StoragePath(this.metadataTableBasePath));
        org.junit.jupiter.api.Assertions.assertTrue((oldInfo.getModificationTime() == newInfo.getModificationTime() ? 1 : 0) != 0);
    }

    @Test
    public void testRollbackOfPartiallyFailedCommitWithNewPartitions() throws Exception {
        List records;
        String newCommitTime;
        this.init(HoodieTableType.COPY_ON_WRITE);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, this.getWriteConfigBuilder(HoodieFailedWritesCleaningPolicy.EAGER, true, true, false, false, false).build(), Option.empty());){
            newCommitTime = client.createNewInstantTime();
            client.startCommitWithTime(newCommitTime);
            records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(10));
            ArrayList<HoodieRecord> upsertRecords = new ArrayList<HoodieRecord>();
            for (HoodieRecord entry : records) {
                if (!entry.getPartitionPath().equals("2016/03/15") && !entry.getPartitionPath().equals("2015/03/16")) continue;
                upsertRecords.add(entry);
            }
            List writeStatuses = client.upsert(this.jsc.parallelize(upsertRecords, 1), newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            this.validateMetadata(client);
            newCommitTime = client.createNewInstantTime();
            client.startCommitWithTime(newCommitTime);
            records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(20));
            writeStatuses = client.insert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            this.validateMetadata(client);
            String commitInstantFileName = HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.getFileName((HoodieInstant)this.metaClient.getActiveTimeline().getReverseOrderedInstants().findFirst().get());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.storage.deleteFile(new StoragePath(this.basePath + "/" + ".hoodie" + "/" + "timeline", commitInstantFileName)));
        }
        client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, this.getWriteConfigBuilder(HoodieFailedWritesCleaningPolicy.EAGER, true, true, false, false, false).build(), Option.empty());
        var3_3 = null;
        try {
            newCommitTime = client.startCommit();
            records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(20));
            List writeStatuses = client.upsert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            this.validateMetadata(client);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (client != null) {
                if (var3_3 != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    client.close();
                }
            }
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testRollbackPendingCommitWithRecordIndex(boolean performUpsert) throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE);
        Properties props = new Properties();
        props.setProperty(HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key(), "true");
        props.setProperty(HoodieIndexConfig.INDEX_TYPE.key(), "RECORD_INDEX");
        HoodieWriteConfig cfg = this.getWriteConfigBuilder(true, true, false).withProps((Map)props).build();
        SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);
        String commitTime = client.createNewInstantTime();
        List records = this.dataGen.generateInserts(commitTime, Integer.valueOf(100));
        client.startCommitWithTime(commitTime);
        List writeStatuses = client.insert(this.jsc.parallelize(records, 1), commitTime).collect();
        Assertions.assertNoWriteErrors((List)writeStatuses);
        HoodieWriteConfig autoCommitDisabled = this.getWriteConfigBuilder(false, true, false).withProps((Map)props).build();
        SparkRDDWriteClient client2 = this.getHoodieWriteClient(autoCommitDisabled);
        commitTime = client2.createNewInstantTime();
        records = this.dataGen.generateInserts(commitTime, Integer.valueOf(100));
        client.startCommitWithTime(commitTime);
        writeStatuses = client2.insert(this.jsc.parallelize(records, 1), commitTime).collect();
        Assertions.assertNoWriteErrors((List)writeStatuses);
        client.dropIndex(Arrays.asList(MetadataPartitionType.RECORD_INDEX.getPartitionPath(), MetadataPartitionType.FILES.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.storage.exists(new StoragePath(HoodieTableMetadata.getMetadataTableBasePath((String)this.basePath) + "/" + MetadataPartitionType.FILES.getPartitionPath())));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.storage.exists(new StoragePath(HoodieTableMetadata.getMetadataTableBasePath((String)this.basePath) + "/" + MetadataPartitionType.RECORD_INDEX.getPartitionPath())));
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        client = this.getHoodieWriteClient(cfg);
        commitTime = client.createNewInstantTime();
        if (performUpsert) {
            records = this.dataGen.generateUpdates(commitTime, Integer.valueOf(100));
            records.addAll(this.dataGen.generateInserts(commitTime, Integer.valueOf(20)));
            client.startCommitWithTime(commitTime);
            writeStatuses = client.upsert(this.jsc.parallelize(records, 1), commitTime).collect();
        } else {
            records = this.dataGen.generateInserts(commitTime, Integer.valueOf(100));
            client.startCommitWithTime(commitTime);
            writeStatuses = client.insert(this.jsc.parallelize(records, 1), commitTime).collect();
        }
        Assertions.assertNoWriteErrors((List)writeStatuses);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.storage.exists(new StoragePath(this.basePath + "/" + ".hoodie")));
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.metaClient.getActiveTimeline().filterCompletedInstants().filterCompletedInstants().findInstantsAfterOrEquals(commitTime, 1).empty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.storage.exists(new StoragePath(HoodieTableMetadata.getMetadataTableBasePath((String)this.basePath) + "/" + MetadataPartitionType.FILES.getPartitionPath())));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.storage.exists(new StoragePath(HoodieTableMetadata.getMetadataTableBasePath((String)this.basePath) + "/" + MetadataPartitionType.RECORD_INDEX.getPartitionPath())));
    }

    @Test
    public void testBootstrapWithTableNotFound() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        HoodieWriteConfig writeConfig = this.getWriteConfigBuilder(true, true, false).build();
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, writeConfig);){
            String newCommitTime = client.createNewInstantTime();
            List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(1));
            client.startCommitWithTime(newCommitTime);
            List writeStatuses = client.insert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            this.validateMetadata(client);
        }
        StoragePath metadataTablePath = new StoragePath(HoodieTableMetadata.getMetadataTableBasePath((String)writeConfig.getBasePath()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.storage.exists(metadataTablePath), (String)"metadata table should exist.");
        HoodieTableMetadataUtil.deleteMetadataTable((HoodieTableMetaClient)this.metaClient, (HoodieEngineContext)this.context, (boolean)false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.storage.exists(metadataTablePath), (String)"metadata table should not exist after being deleted.");
        writeConfig = this.getWriteConfigBuilder(true, true, false).build();
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, writeConfig);){
            String newCommitTime = client.createNewInstantTime();
            List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(1));
            client.startCommitWithTime(newCommitTime);
            List writeStatuses = client.insert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.storage.exists(metadataTablePath));
    }

    @Test
    public void testbootstrapWithEmptyCommit() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE);
        HoodieWriteConfig writeConfig = this.getWriteConfigBuilder(true, true, false).build();
        this.initWriteConfigAndMetatableWriter(writeConfig, true);
        testTable.doWriteOperation(this.getHoodieWriteClient(writeConfig).createNewInstantTime(), WriteOperationType.INSERT, Collections.EMPTY_LIST, 0);
        this.syncTableMetadata(writeConfig);
        this.validateMetadata(testTable);
    }

    @Test
    public void testDeletePartitions() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE);
        int maxCommits = 1;
        HoodieWriteConfig cfg = this.getConfigBuilder("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", HoodieIndex.IndexType.BLOOM, HoodieFailedWritesCleaningPolicy.EAGER).withCleanConfig(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).retainCommits(maxCommits).build()).withParallelism(1, 1).withBulkInsertParallelism(1).withFinalizeWriteParallelism(1).withDeleteParallelism(1).withConsistencyGuardConfig(ConsistencyGuardConfig.newBuilder().withConsistencyCheckEnabled(true).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).build()).build();
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);){
            String newCommitTime = client.createNewInstantTime();
            client.startCommitWithTime(newCommitTime);
            List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(10));
            ArrayList<HoodieRecord> upsertRecords = new ArrayList<HoodieRecord>();
            for (HoodieRecord entry : records) {
                if (!entry.getPartitionPath().equals("2016/03/15") && !entry.getPartitionPath().equals("2015/03/16")) continue;
                upsertRecords.add(entry);
            }
            List writeStatuses = client.upsert(this.jsc.parallelize(upsertRecords, 1), newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            this.validateMetadata(client);
            newCommitTime = client.createNewInstantTime();
            client.deletePartitions(Collections.singletonList("2016/03/15"), newCommitTime);
            newCommitTime = client.createNewInstantTime();
            client.startCommitWithTime(newCommitTime);
            records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(10));
            upsertRecords = new ArrayList();
            for (HoodieRecord entry : records) {
                if (!entry.getPartitionPath().equals("2015/03/16")) continue;
                upsertRecords.add(entry);
            }
            writeStatuses = client.upsert(this.jsc.parallelize(upsertRecords, 1), newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            this.validateMetadata(client);
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)TestHoodieBackedMetadata.metadata(client, this.storage).getAllPartitionPaths().size());
        }
    }

    @Test
    public void testErrorCases() throws Exception {
        List writeStatuses;
        List records;
        String newCommitTime;
        this.init(HoodieTableType.COPY_ON_WRITE);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, this.getWriteConfigBuilder(HoodieFailedWritesCleaningPolicy.EAGER, true, true, false, false, false).build(), Option.empty());){
            newCommitTime = client.createNewInstantTime();
            client.startCommitWithTime(newCommitTime);
            records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(10));
            writeStatuses = client.upsert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            this.validateMetadata(client);
            newCommitTime = client.createNewInstantTime();
            client.startCommitWithTime(newCommitTime);
            records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(5));
            writeStatuses = client.bulkInsert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            this.validateMetadata(client);
            String commitInstantFileName = HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.getFileName((HoodieInstant)this.metaClient.getActiveTimeline().getReverseOrderedInstants().findFirst().get());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.storage.deleteFile(new StoragePath(this.basePath + "/" + ".hoodie" + "/" + "timeline", commitInstantFileName)));
        }
        client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, this.getWriteConfigBuilder(HoodieFailedWritesCleaningPolicy.EAGER, true, true, false, false, false).build(), Option.empty());
        var3_3 = null;
        try {
            newCommitTime = client.startCommit();
            records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(5));
            writeStatuses = client.upsert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            this.validateMetadata(client);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (client != null) {
                if (var3_3 != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    client.close();
                }
            }
        }
    }

    @Test
    public void testMetadataTableWithLongLog() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE, false);
        int maxNumDeltaCommits = 3;
        this.writeConfig = this.getWriteConfigBuilder(true, true, false).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).enableMetrics(false).withMaxNumDeltaCommitsBeforeCompaction(103).withMaxNumDeltacommitsWhenPending(3).build()).build();
        this.initWriteConfigAndMetatableWriter(this.writeConfig, true);
        testTable.addRequestedCommit(String.format("%016d", 0));
        for (int i = 1; i <= 3; ++i) {
            this.doWriteOperation(testTable, String.format("%016d", i));
        }
        int instant = 4;
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.doWriteOperation(testTable, String.format("%016d", instant)));
    }

    @Test
    public void testMORCheckNumDeltaCommits() throws Exception {
        this.init(HoodieTableType.MERGE_ON_READ, true);
        int maxNumDeltaCommits = 3;
        this.writeConfig = this.getWriteConfigBuilder(true, true, false).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).enableMetrics(false).withMaxNumDeltaCommitsBeforeCompaction(2).withMaxNumDeltacommitsWhenPending(3).build()).build();
        this.initWriteConfigAndMetatableWriter(this.writeConfig, true);
        this.doWriteOperation(testTable, InProcessTimeGenerator.createNewInstantTime((long)1L));
        this.doWriteOperation(testTable, InProcessTimeGenerator.createNewInstantTime((long)1L));
        try (HoodieBackedTableMetadata metadata = new HoodieBackedTableMetadata((HoodieEngineContext)this.context, this.storage, this.writeConfig.getMetadataConfig(), this.writeConfig.getBasePath(), true);){
            HoodieTableMetaClient metadataMetaClient = metadata.getMetadataMetaClient();
            HoodieActiveTimeline activeTimeline = metadataMetaClient.reloadActiveTimeline();
            Option lastCompaction = activeTimeline.filterCompletedInstants().filter(s -> s.getAction().equals("commit")).lastInstant();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)lastCompaction.isPresent());
            testTable.addRequestedCommit(InProcessTimeGenerator.createNewInstantTime((long)1L));
            for (int i = 0; i <= 3; ++i) {
                this.doWriteOperation(testTable, InProcessTimeGenerator.createNewInstantTime((long)1L));
            }
            org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.doWriteOperation(testTable, InProcessTimeGenerator.createNewInstantTime((long)1L)));
        }
    }

    @Test
    public void testNonPartitioned() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE, false);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        HoodieTestDataGenerator nonPartitionedGenerator = new HoodieTestDataGenerator(new String[]{""});
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, this.getWriteConfig(true, true));){
            String newCommitTime = "0000001";
            List records = nonPartitionedGenerator.generateInserts(newCommitTime, Integer.valueOf(10));
            client.startCommitWithTime(newCommitTime);
            List writeStatuses = client.bulkInsert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            this.validateMetadata(client);
            List metadataPartitions = TestHoodieBackedMetadata.metadata(client, this.storage).getAllPartitionPaths();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)metadataPartitions.contains(""), (String)"Must contain empty partition");
        }
    }

    @Test
    public void testNonPartitionedColStats() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE, false);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        HoodieTestDataGenerator nonPartitionedGenerator = new HoodieTestDataGenerator(new String[]{""});
        HoodieWriteConfig writeConfig = this.getWriteConfigBuilder(true, true, false).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexColumnStats(true).build()).build();
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, writeConfig);){
            String newCommitTime = "0000001";
            List records = nonPartitionedGenerator.generateInserts(newCommitTime, Integer.valueOf(10));
            client.startCommitWithTime(newCommitTime);
            List writeStatuses = client.bulkInsert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            this.validateMetadata(client);
            List metadataPartitions = TestHoodieBackedMetadata.metadata(client, this.storage).getAllPartitionPaths();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)metadataPartitions.contains(""), (String)"Must contain empty partition");
        }
    }

    @Test
    public void testMetadataMetrics() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE, false);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, this.getWriteConfigBuilder(true, true, true).build());){
            String newCommitTime = client.createNewInstantTime();
            List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(20));
            client.startCommitWithTime(newCommitTime);
            List writeStatuses = client.insert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            this.validateMetadata(client);
            Metrics metrics = Metrics.getInstance((HoodieMetricsConfig)this.writeConfig.getMetricsConfig(), (HoodieStorage)this.storage);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)metrics.getRegistry().getGauges().containsKey("initialize.count"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)metrics.getRegistry().getGauges().containsKey("initialize.totalDuration"));
            org.junit.jupiter.api.Assertions.assertTrue(((Long)((Gauge)metrics.getRegistry().getGauges().get("initialize.count")).getValue() >= 1L ? 1 : 0) != 0);
            String prefix = MetadataPartitionType.FILES.getPartitionPath() + ".";
            org.junit.jupiter.api.Assertions.assertTrue((boolean)metrics.getRegistry().getGauges().containsKey(prefix + "baseFileCount"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)metrics.getRegistry().getGauges().containsKey(prefix + "logFileCount"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)metrics.getRegistry().getGauges().containsKey(prefix + "totalBaseFileSizeInBytes"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)metrics.getRegistry().getGauges().containsKey(prefix + "totalLogFileSizeInBytes"));
        }
    }

    @Test
    public void testGetFileGroupIndexFromFileId() {
        int index = new Random().nextInt(10000);
        String fileId = HoodieTableMetadataUtil.getFileIDForFileGroup((MetadataPartitionType)MetadataPartitionType.FILES, (int)index, (String)MetadataPartitionType.FILES.getPartitionPath());
        org.junit.jupiter.api.Assertions.assertEquals((Object)fileId.substring(0, fileId.length() - 2), (Object)HoodieTableMetadataUtil.getFileGroupPrefix((String)fileId));
        org.junit.jupiter.api.Assertions.assertEquals((int)index, (int)HoodieTableMetadataUtil.getFileGroupIndexFromFileId((String)fileId));
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTableMetadataUtil.getFileGroupPrefix((String)"some-file-id-0"), (Object)"some-file-id");
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTableMetadataUtil.getFileGroupPrefix((String)"some-file-id"), (Object)"some-file-id");
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTableMetadataUtil.getFileGroupPrefix((String)"some-file-id-2"), (Object)"some-file-id-2");
    }

    @Test
    public void testDuplicatesDuringRecordIndexBootstrap() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE, true);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        ArrayList<String> commitTimestamps = new ArrayList<String>();
        HoodieWriteConfig customConfig = this.getWriteConfigBuilder(true, true, false).build();
        ArrayList recordsFirstBatch = new ArrayList();
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, customConfig);){
            String firstCommitTime = client.createNewInstantTime();
            List insertRecords = this.dataGen.generateInserts(firstCommitTime, Integer.valueOf(100));
            recordsFirstBatch.addAll(insertRecords);
            recordsFirstBatch.addAll(insertRecords);
            client.startCommitWithTime(firstCommitTime);
            List writeStatuses = client.insert(this.jsc.parallelize(recordsFirstBatch, 1), firstCommitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses);
            commitTimestamps.add(firstCommitTime);
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)false, (Object)this.storage.exists(new StoragePath(this.metaClient.getMetaPath(), "metadata/record_index")));
        customConfig = this.getWriteConfigBuilder(false, true, false).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).enableMetrics(false).ignoreSpuriousDeletes(false).withEnableRecordIndex(true).build()).build();
        client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, customConfig);
        var6_6 = null;
        try {
            String secondCommitTime = client.createNewInstantTime();
            List recordsSecondBatch = this.dataGen.generateInserts(secondCommitTime, Integer.valueOf(100));
            client.startCommitWithTime(secondCommitTime);
            org.junit.jupiter.api.Assertions.assertThrows(HoodieException.class, () -> client.insert(this.jsc.parallelize(recordsSecondBatch, 1), secondCommitTime));
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (client != null) {
                if (var6_6 != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    client.close();
                }
            }
        }
    }

    @Test
    public void testRepeatedActionWithSameInstantTime() throws Exception {
        int index;
        this.init(HoodieTableType.COPY_ON_WRITE);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        Properties props = new Properties();
        props.put(HoodieCleanConfig.ALLOW_MULTIPLE_CLEANS.key(), "false");
        HoodieWriteConfig writeConfig = this.getWriteConfigBuilder(true, true, false).withProps((Map)props).build();
        String partition = "2015/03/16";
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, writeConfig);){
            for (index = 0; index < 3; ++index) {
                String newCommitTime = "00" + index;
                List records = index == 0 ? this.dataGen.generateInsertsForPartition(newCommitTime, Integer.valueOf(10), "2015/03/16") : this.dataGen.generateUniqueUpdates(newCommitTime, Integer.valueOf(5));
                client.startCommitWithTime(newCommitTime);
                client.upsert(this.jsc.parallelize(records, 1), newCommitTime).collect();
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)this.metaClient.reloadActiveTimeline().getCommitAndReplaceTimeline().filterCompletedInstants().countInstants(), (int)3);
        client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, writeConfig);
        var7_7 = null;
        try {
            String cleanInstantTime = "00" + index++;
            HoodieCleanMetadata cleanMetadata = client.clean(cleanInstantTime);
            org.junit.jupiter.api.Assertions.assertEquals((int)cleanMetadata.getPartitionMetadata().size(), (int)1);
            org.junit.jupiter.api.Assertions.assertEquals((int)((HoodieCleanPartitionMetadata)cleanMetadata.getPartitionMetadata().get("2015/03/16")).getSuccessDeleteFiles().size(), (int)1);
            org.junit.jupiter.api.Assertions.assertEquals((int)((HoodieCleanPartitionMetadata)cleanMetadata.getPartitionMetadata().get("2015/03/16")).getFailedDeleteFiles().size(), (int)0);
            org.junit.jupiter.api.Assertions.assertEquals((int)((HoodieCleanPartitionMetadata)cleanMetadata.getPartitionMetadata().get("2015/03/16")).getDeletePathPatterns().size(), (int)1);
            String cleanInstantFileName = HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.getFileName((HoodieInstant)this.metaClient.reloadActiveTimeline().getCleanerTimeline().filterCompletedInstants().getReverseOrderedInstants().findFirst().get());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.storage.deleteFile(new StoragePath(this.basePath + "/" + ".hoodie" + "/" + "timeline", cleanInstantFileName)));
            org.junit.jupiter.api.Assertions.assertEquals((int)this.metaClient.reloadActiveTimeline().getCleanerTimeline().filterInflights().countInstants(), (int)1);
            org.junit.jupiter.api.Assertions.assertEquals((int)this.metaClient.reloadActiveTimeline().getCleanerTimeline().filterCompletedInstants().countInstants(), (int)0);
            String newCleanInstantTime = "00" + index++;
            cleanMetadata = client.clean(newCleanInstantTime);
            org.junit.jupiter.api.Assertions.assertEquals((int)cleanMetadata.getPartitionMetadata().size(), (int)1);
            org.junit.jupiter.api.Assertions.assertEquals((int)((HoodieCleanPartitionMetadata)cleanMetadata.getPartitionMetadata().get("2015/03/16")).getSuccessDeleteFiles().size(), (int)0);
            org.junit.jupiter.api.Assertions.assertEquals((int)((HoodieCleanPartitionMetadata)cleanMetadata.getPartitionMetadata().get("2015/03/16")).getFailedDeleteFiles().size(), (int)1);
            org.junit.jupiter.api.Assertions.assertEquals((int)((HoodieCleanPartitionMetadata)cleanMetadata.getPartitionMetadata().get("2015/03/16")).getDeletePathPatterns().size(), (int)1);
            this.validateMetadata(client);
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (client != null) {
                if (var7_7 != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    client.close();
                }
            }
        }
    }

    private void doPreBootstrapOperations(HoodieTestTable testTable) throws Exception {
        this.doPreBootstrapOperations(testTable, "0000001", "0000002");
    }

    private void doPreBootstrapOperations(HoodieTestTable testTable, String commit1, String commit2) throws Exception {
        testTable.doWriteOperation(commit1, WriteOperationType.INSERT, Arrays.asList("p1", "p2"), Arrays.asList("p1", "p2"), 2, true);
        testTable.doWriteOperation(commit2, WriteOperationType.UPSERT, Arrays.asList("p1", "p2"), 2, true);
        this.validateMetadata(testTable);
    }

    private void doWriteInsertAndUpsertNonPartitioned(HoodieTestTable testTable) throws Exception {
        this.doWriteInsertAndUpsert(testTable, "0000001", "0000002", true);
    }

    private void doWriteInsertAndUpsert(HoodieTestTable testTable) throws Exception {
        this.doWriteInsertAndUpsert(testTable, "0000001", "0000002", false);
    }

    public HoodieWriteConfig.Builder getConfigBuilder(String schemaStr, HoodieIndex.IndexType indexType, HoodieFailedWritesCleaningPolicy cleaningPolicy) {
        Properties properties = TestHoodieBackedMetadata.getDisabledRowWriterProperties();
        return HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema(schemaStr).withParallelism(2, 2).withBulkInsertParallelism(2).withFinalizeWriteParallelism(2).withDeleteParallelism(2).withTimelineLayoutVersion(TimelineLayoutVersion.CURR_VERSION.intValue()).withWriteStatusClass(MetadataMergeWriteStatus.class).withConsistencyGuardConfig(ConsistencyGuardConfig.newBuilder().withConsistencyCheckEnabled(true).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(cleaningPolicy).build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().compactionSmallFileSize(0x100000L).build()).withStorageConfig(HoodieStorageConfig.newBuilder().hfileMaxFileSize(0x100000L).parquetMaxFileSize(0x100000L).orcMaxFileSize(0x100000L).build()).forTable("test-trip-table").withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(indexType).build()).withEmbeddedTimelineServerEnabled(true).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withEnableBackupForRemoteFileSystemView(false).withRemoteServerPort(Integer.valueOf(timelineServicePort)).build()).withProperties(properties);
    }

    @Test
    public void testClusterOperationOnMainTable() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE);
        Properties props = new Properties();
        props.setProperty(HoodieCompactionConfig.PARQUET_SMALL_FILE_LIMIT.key(), "0");
        HoodieWriteConfig cfg = this.getWriteConfigBuilder(true, true, false).withProps((Map)props).build();
        SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);
        String commitTime = "0000001";
        List records = this.dataGen.generateInserts(commitTime, Integer.valueOf(100));
        client.startCommitWithTime(commitTime);
        List writeStatuses = client.insert(this.jsc.parallelize(records, 1), commitTime).collect();
        Assertions.assertNoWriteErrors((List)writeStatuses);
        commitTime = "0000002";
        records = this.dataGen.generateInserts(commitTime, Integer.valueOf(100));
        client.startCommitWithTime(commitTime);
        writeStatuses = client.insert(this.jsc.parallelize(records, 1), commitTime).collect();
        Assertions.assertNoWriteErrors((List)writeStatuses);
        HoodieWriteConfig clusterWriteCfg = this.getWriteConfigBuilder(true, true, false).withClusteringConfig(HoodieClusteringConfig.newBuilder().withInlineClusteringNumCommits(0).build()).withProperties(TestHoodieBackedMetadata.getDisabledRowWriterProperties()).build();
        SparkRDDWriteClient clusteringClient = this.getHoodieWriteClient(clusterWriteCfg);
        clusteringClient.scheduleTableService("0000003", Option.empty(), TableServiceType.CLUSTER);
        clusteringClient.cluster("0000003", true);
        this.validateMetadata(client);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieTableMetadata tableMetadata = TestHoodieBackedMetadata.metadata(client, this.storage);
        HoodieTableFileSystemView metadataFileSystemView = new HoodieTableFileSystemView(tableMetadata, this.metaClient, (HoodieTimeline)this.metaClient.reloadActiveTimeline());
        HoodieTableFileSystemView fsView = HoodieTableFileSystemView.fileListingBasedFileSystemView((HoodieEngineContext)this.getEngineContext(), (HoodieTableMetaClient)this.metaClient, (HoodieTimeline)this.metaClient.getActiveTimeline());
        tableMetadata.getAllPartitionPaths().forEach(partition -> {
            List fileNamesFromMetadataFileListing = metadataFileSystemView.getLatestBaseFiles(partition).map(baseFile -> baseFile.getFileName()).sorted().collect(Collectors.toList());
            List fileNamesFromBaseFileView = fsView.getLatestBaseFiles(partition).map(baseFile -> baseFile.getFileName()).sorted().collect(Collectors.toList());
            org.junit.jupiter.api.Assertions.assertEquals(fileNamesFromBaseFileView, fileNamesFromMetadataFileListing);
        });
    }

    @Test
    public void testOutOfOrderCommits() throws Exception {
        this.init(HoodieTableType.COPY_ON_WRITE);
        Properties props = new Properties();
        props.setProperty(HoodieCompactionConfig.PARQUET_SMALL_FILE_LIMIT.key(), "0");
        HoodieWriteConfig cfg = this.getWriteConfigBuilder(true, true, false).withProps((Map)props).build();
        SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);
        String commitTime = "0000001";
        List records = this.dataGen.generateInserts(commitTime, Integer.valueOf(100));
        client.startCommitWithTime(commitTime);
        List writeStatuses = client.insert(this.jsc.parallelize(records, 1), commitTime).collect();
        Assertions.assertNoWriteErrors((List)writeStatuses);
        commitTime = "0000002";
        records = this.dataGen.generateInserts(commitTime, Integer.valueOf(100));
        client.startCommitWithTime(commitTime);
        writeStatuses = client.insert(this.jsc.parallelize(records, 1), commitTime).collect();
        Assertions.assertNoWriteErrors((List)writeStatuses);
        HoodieWriteConfig clusterWriteCfg = this.getWriteConfigBuilder(true, true, false).withClusteringConfig(HoodieClusteringConfig.newBuilder().withInlineClusteringNumCommits(0).build()).withProperties(TestHoodieBackedMetadata.getDisabledRowWriterProperties()).build();
        SparkRDDWriteClient clusteringClient = this.getHoodieWriteClient(clusterWriteCfg);
        clusteringClient.scheduleTableService("0000003", Option.empty(), TableServiceType.CLUSTER);
        commitTime = "0000004";
        records = this.dataGen.generateInserts(commitTime, Integer.valueOf(100));
        client = this.getHoodieWriteClient(cfg);
        client.startCommitWithTime(commitTime);
        writeStatuses = client.insert(this.jsc.parallelize(records, 1), commitTime).collect();
        Assertions.assertNoWriteErrors((List)writeStatuses);
        this.validateMetadata(client);
        this.metadataWriter = SparkHoodieBackedTableMetadataWriter.create((StorageConfiguration)this.storageConf, (HoodieWriteConfig)client.getConfig(), (HoodieEngineContext)this.context);
        TypedProperties metadataProps = ((SparkHoodieBackedTableMetadataWriter)this.metadataWriter).getWriteConfig().getProps();
        metadataProps.setProperty(HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key(), "3");
        HoodieWriteConfig metadataWriteConfig = HoodieWriteConfig.newBuilder().withProperties((Properties)metadataProps).build();
        try (SparkRDDWriteClient metadataWriteClient = new SparkRDDWriteClient((HoodieEngineContext)this.context, metadataWriteConfig, Option.empty());){
            String compactionInstantTime = client.createNewInstantTime();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)metadataWriteClient.scheduleCompactionAtInstant(compactionInstantTime, Option.empty()));
            metadataWriteClient.compact(compactionInstantTime);
            this.validateMetadata(client);
            clusteringClient = this.getHoodieWriteClient(clusterWriteCfg);
            clusteringClient.cluster("0000003", true);
            this.validateMetadata(client);
        }
    }

    @Test
    public void testDeleteWithRecordIndex() throws Exception {
        List keysToDelete;
        List recordsToDelete;
        ArrayList allRecords;
        this.init(HoodieTableType.COPY_ON_WRITE, true);
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        HoodieWriteConfig writeConfig = this.getWriteConfigBuilder(true, true, false).withMetadataConfig(HoodieMetadataConfig.newBuilder().withEnableRecordIndex(true).withMaxNumDeltaCommitsBeforeCompaction(1).build()).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.RECORD_INDEX).build()).build();
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, writeConfig);){
            String firstCommitTime = client.createNewInstantTime();
            List firstBatchOfrecords = this.dataGen.generateInserts(firstCommitTime, Integer.valueOf(10));
            client.startCommitWithTime(firstCommitTime);
            client.insert(this.jsc.parallelize(firstBatchOfrecords, 1), firstCommitTime).collect();
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.metaClient.getTableConfig().isMetadataPartitionAvailable(MetadataPartitionType.RECORD_INDEX), (String)"RI is disabled");
            org.junit.jupiter.api.Assertions.assertEquals((long)firstBatchOfrecords.size(), (long)HoodieClientTestUtils.readCommit((String)writeConfig.getBasePath(), (SQLContext)engineContext.getSqlContext(), (HoodieTimeline)this.metaClient.reloadActiveTimeline(), (String)firstCommitTime, (boolean)true, (InstantGenerator)HoodieTestUtils.INSTANT_GENERATOR).count());
            String secondCommitTime = client.createNewInstantTime();
            List secondBatchOfrecords = this.dataGen.generateInserts(secondCommitTime, Integer.valueOf(5));
            client.startCommitWithTime(secondCommitTime);
            client.bulkInsert(this.jsc.parallelize(secondBatchOfrecords, 1), secondCommitTime).collect();
            org.junit.jupiter.api.Assertions.assertEquals((long)secondBatchOfrecords.size(), (long)HoodieClientTestUtils.readCommit((String)writeConfig.getBasePath(), (SQLContext)engineContext.getSqlContext(), (HoodieTimeline)this.metaClient.reloadActiveTimeline(), (String)secondCommitTime, (boolean)true, (InstantGenerator)HoodieTestUtils.INSTANT_GENERATOR).count());
            allRecords = new ArrayList(firstBatchOfrecords);
            allRecords.addAll(secondBatchOfrecords);
            HoodieTableMetadata metadataReader = HoodieTableMetadata.create((HoodieEngineContext)this.context, (HoodieStorage)this.storage, (HoodieMetadataConfig)writeConfig.getMetadataConfig(), (String)writeConfig.getBasePath());
            Map result = metadataReader.readRecordIndex(allRecords.stream().map(HoodieRecord::getRecordKey).collect(Collectors.toList()));
            org.junit.jupiter.api.Assertions.assertEquals((int)allRecords.size(), (int)result.size(), (String)"RI should have mapping for all the records in firstCommit");
            recordsToDelete = firstBatchOfrecords.subList(0, 3);
            recordsToDelete.addAll(secondBatchOfrecords.subList(0, 2));
            keysToDelete = recordsToDelete.stream().map(HoodieRecord::getRecordKey).collect(Collectors.toList());
            String deleteTime = client.createNewInstantTime();
            client.startCommitWithTime(deleteTime);
            client.delete(this.jsc.parallelize(recordsToDelete, 1).map(HoodieRecord::getKey), deleteTime);
            metadataReader = HoodieTableMetadata.create((HoodieEngineContext)this.context, (HoodieStorage)this.storage, (HoodieMetadataConfig)writeConfig.getMetadataConfig(), (String)writeConfig.getBasePath());
            result = metadataReader.readRecordIndex(allRecords.stream().map(HoodieRecord::getRecordKey).collect(Collectors.toList()));
            org.junit.jupiter.api.Assertions.assertEquals((int)(allRecords.size() - recordsToDelete.size()), (int)result.size(), (String)"RI should not have mapping for deleted records");
            result.keySet().forEach(mappingKey -> org.junit.jupiter.api.Assertions.assertFalse((boolean)keysToDelete.contains(mappingKey), (String)"RI should not have mapping for deleted records"));
        }
        client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, writeConfig);
        var8_4 = null;
        try {
            String deleteTime = client.startCommit();
            client.delete(this.jsc.emptyRDD(), deleteTime);
            HoodieTableMetadata metadataReader = HoodieTableMetadata.create((HoodieEngineContext)this.context, (HoodieStorage)this.storage, (HoodieMetadataConfig)writeConfig.getMetadataConfig(), (String)writeConfig.getBasePath());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)metadataReader.getLatestCompactionTime().isPresent(), (String)"Compaction should have taken place on MDT");
            metadataReader = HoodieTableMetadata.create((HoodieEngineContext)this.context, (HoodieStorage)this.storage, (HoodieMetadataConfig)writeConfig.getMetadataConfig(), (String)writeConfig.getBasePath());
            Map result = metadataReader.readRecordIndex(allRecords.stream().map(HoodieRecord::getRecordKey).collect(Collectors.toList()));
            org.junit.jupiter.api.Assertions.assertEquals((int)(allRecords.size() - keysToDelete.size()), (int)result.size(), (String)"RI should not have mapping for deleted records");
            result.keySet().forEach(mappingKey -> org.junit.jupiter.api.Assertions.assertFalse((boolean)keysToDelete.contains(mappingKey), (String)"RI should not have mapping for deleted records"));
            String reinsertTime = client.startCommit();
            client.upsert(this.jsc.parallelize(recordsToDelete, 1), reinsertTime).collect();
            metadataReader = HoodieTableMetadata.create((HoodieEngineContext)this.context, (HoodieStorage)this.storage, (HoodieMetadataConfig)writeConfig.getMetadataConfig(), (String)writeConfig.getBasePath());
            result = metadataReader.readRecordIndex(allRecords.stream().map(HoodieRecord::getRecordKey).collect(Collectors.toList()));
            org.junit.jupiter.api.Assertions.assertEquals((int)allRecords.size(), (int)result.size(), (String)"RI should have mappings for re-inserted records");
            for (String reInsertedKey : keysToDelete) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)reinsertTime, (Object)((HoodieRecordGlobalLocation)result.get(reInsertedKey)).getInstantTime(), (String)"RI mapping for re-inserted keys should have new commit time");
            }
        }
        catch (Throwable throwable) {
            var8_4 = throwable;
            throw throwable;
        }
        finally {
            if (client != null) {
                if (var8_4 != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable) {
                        var8_4.addSuppressed(throwable);
                    }
                } else {
                    client.close();
                }
            }
        }
    }

    private void validateMetadata(SparkRDDWriteClient testClient) throws Exception {
        this.validateMetadata(testClient, (Option<String>)Option.empty());
    }

    private void validateMetadata(SparkRDDWriteClient testClient, Option<String> ignoreFilesWithCommit) throws Exception {
        SparkRDDWriteClient client;
        HoodieWriteConfig config = testClient.getConfig();
        if (config.isEmbeddedTimelineServerEnabled()) {
            testClient.close();
            client = new SparkRDDWriteClient(testClient.getEngineContext(), testClient.getConfig());
        } else {
            client = testClient;
        }
        this.clientsToClose.add((BaseHoodieWriteClient)client);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieTableMetadata tableMetadata = TestHoodieBackedMetadata.metadata(client, this.storage);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)tableMetadata, (String)"MetadataReader should have been initialized");
        if (!config.isMetadataTableEnabled()) {
            return;
        }
        HoodieTimer timer = HoodieTimer.start();
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        TestHoodieBackedMetadata.validateMetadata(config, ignoreFilesWithCommit, this.storage, this.basePath, this.metaClient, this.storageConf, engineContext, tableMetadata, client, timer);
        HoodieBackedTableMetadataWriter<JavaRDD<HoodieRecord>> metadataWriter = TestHoodieBackedMetadata.metadataWriter(client, this.storageConf, engineContext.jsc());
        org.junit.jupiter.api.Assertions.assertNotNull(metadataWriter, (String)"MetadataWriter should have been initialized");
        HoodieWriteConfig metadataWriteConfig = metadataWriter.getWriteConfig();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)metadataWriteConfig.isMetadataTableEnabled(), (String)"No metadata table for metadata table");
        HoodieTableMetaClient metadataMetaClient = HoodieTableMetaClient.builder().setConf(this.storageConf).setBasePath(this.metadataTableBasePath).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)metadataMetaClient.getTableType(), (Object)HoodieTableType.MERGE_ON_READ, (String)"Metadata Table should be MOR");
        org.junit.jupiter.api.Assertions.assertEquals((Object)metadataMetaClient.getTableConfig().getBaseFileFormat(), (Object)HoodieFileFormat.HFILE, (String)"Metadata Table base file format should be HFile");
        List metadataTablePartitions = FSUtils.getAllPartitionPaths((HoodieEngineContext)engineContext, (HoodieStorage)this.storage, (String)HoodieTableMetadata.getMetadataTableBasePath((String)this.basePath), (boolean)false);
        boolean isPartitionStatsEnabled = metadataWriter.getEnabledPartitionTypes().contains(MetadataPartitionType.COLUMN_STATS);
        long enabledMDTPartitionsSize = metadataWriter.getEnabledPartitionTypes().stream().filter(partition -> !partition.equals((Object)MetadataPartitionType.SECONDARY_INDEX)).filter(partition -> isPartitionStatsEnabled || !partition.equals((Object)MetadataPartitionType.PARTITION_STATS)).count();
        org.junit.jupiter.api.Assertions.assertEquals((long)enabledMDTPartitionsSize, (long)metadataTablePartitions.size());
        HashMap metadataEnabledPartitionTypes = new HashMap();
        metadataWriter.getEnabledPartitionTypes().forEach(e -> metadataEnabledPartitionTypes.put(e.getPartitionPath(), e));
        int numFileVersions = metadataWriteConfig.getCleanerFileVersionsRetained() + 1;
        FileSystemBackedTableMetadata mdtMetadata = new FileSystemBackedTableMetadata((HoodieEngineContext)engineContext, this.storage, this.metadataTableBasePath);
        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView((HoodieTableMetadata)mdtMetadata, metadataMetaClient, (HoodieTimeline)metadataMetaClient.getActiveTimeline());
        metadataTablePartitions.forEach(partition -> {
            List latestSlices = fsView.getLatestFileSlices(partition).collect(Collectors.toList());
            org.junit.jupiter.api.Assertions.assertTrue((latestSlices.stream().map(FileSlice::getBaseFile).count() <= (long)latestSlices.size() ? 1 : 0) != 0, (String)"Should have a single latest base file per file group");
            List<HoodieLogFile> logFiles = ((FileSlice)latestSlices.get(0)).getLogFiles().collect(Collectors.toList());
            try {
                if (MetadataPartitionType.FILES.getPartitionPath().equals(partition)) {
                    HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)engineContext);
                    TestHoodieBackedMetadata.verifyMetadataRawRecords((HoodieTable)table, logFiles, false);
                }
                if (MetadataPartitionType.COLUMN_STATS.getPartitionPath().equals(partition)) {
                    TestHoodieBackedMetadata.verifyMetadataColumnStatsRecords(this.storage, logFiles);
                }
            }
            catch (IOException e) {
                LOG.error("Metadata record validation failed", (Throwable)e);
                org.junit.jupiter.api.Assertions.fail((String)"Metadata record validation failed");
            }
        });
    }

    public static void validateMetadata(HoodieWriteConfig config, Option<String> ignoreFilesWithCommit, HoodieStorage storage, String basePath, HoodieTableMetaClient metaClient, StorageConfiguration storageConf, HoodieSparkEngineContext engineContext, HoodieTableMetadata tableMetadata, SparkRDDWriteClient client, HoodieTimer timer) throws Exception {
        FileSystemBackedTableMetadata fsBackedTableMetadata = new FileSystemBackedTableMetadata((HoodieEngineContext)engineContext, metaClient.getTableConfig(), metaClient.getStorage(), config.getBasePath());
        List fsPartitions = fsBackedTableMetadata.getAllPartitionPaths();
        List metadataPartitions = tableMetadata.getAllPartitionPaths();
        Collections.sort(fsPartitions);
        Collections.sort(metadataPartitions);
        org.junit.jupiter.api.Assertions.assertEquals((int)fsPartitions.size(), (int)metadataPartitions.size(), (String)"Partitions should match");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fsPartitions.equals(metadataPartitions), (String)"Partitions should match");
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)engineContext);
        SyncableFileSystemView tableView = table.getHoodieView();
        List fullPartitionPaths = fsPartitions.stream().map(partition -> basePath + "/" + partition).collect(Collectors.toList());
        Map partitionToFilesMap = tableMetadata.getAllFilesInPartitions(fullPartitionPaths);
        org.junit.jupiter.api.Assertions.assertEquals((int)fsPartitions.size(), (int)partitionToFilesMap.size());
        fsPartitions.forEach(arg_0 -> TestHoodieBackedMetadata.lambda$validateMetadata$66(basePath, storage, ignoreFilesWithCommit, tableMetadata, partitionToFilesMap, (TableFileSystemView)tableView, arg_0));
        try (HoodieBackedTableMetadataWriter<JavaRDD<HoodieRecord>> metadataWriter = TestHoodieBackedMetadata.metadataWriter(client, storageConf, engineContext.jsc());){
            org.junit.jupiter.api.Assertions.assertNotNull(metadataWriter, (String)"MetadataWriter should have been initialized");
            HoodieWriteConfig metadataWriteConfig = metadataWriter.getWriteConfig();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)metadataWriteConfig.isMetadataTableEnabled(), (String)"No metadata table for metadata table");
            HoodieTableMetaClient metadataMetaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)storageConf, (String)(metaClient.getMetaPath().toString() + "/metadata/"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)metadataMetaClient.getTableType(), (Object)HoodieTableType.MERGE_ON_READ, (String)"Metadata Table should be MOR");
            org.junit.jupiter.api.Assertions.assertEquals((Object)metadataMetaClient.getTableConfig().getBaseFileFormat(), (Object)HoodieFileFormat.HFILE, (String)"Metadata Table base file format should be HFile");
            List metadataTablePartitions = FSUtils.getAllPartitionPaths((HoodieEngineContext)engineContext, (HoodieStorage)storage, (String)HoodieTableMetadata.getMetadataTableBasePath((String)basePath), (boolean)false);
            metaClient.reloadActiveTimeline().getReverseOrderedInstants().findFirst().ifPresent(instant -> {
                if (instant.getAction().equals("restore")) {
                    metadataWriter.getEnabledPartitionTypes().stream().filter(partitionType -> !MetadataPartitionType.shouldDeletePartitionOnRestore((String)partitionType.getPartitionPath())).forEach(partitionType -> org.junit.jupiter.api.Assertions.assertTrue((boolean)metadataTablePartitions.contains(partitionType.getPartitionPath())));
                }
            });
            int numFileVersions = metadataWriteConfig.getCleanerFileVersionsRetained() + 1;
            HoodieTableFileSystemView fsView = HoodieTableFileSystemView.fileListingBasedFileSystemView((HoodieEngineContext)engineContext, (HoodieTableMetaClient)metadataMetaClient, (HoodieTimeline)metadataMetaClient.getActiveTimeline());
            metadataTablePartitions.forEach(arg_0 -> TestHoodieBackedMetadata.lambda$validateMetadata$70(fsView, (HoodieTable)table, storage, arg_0));
            LOG.info("Validation time=" + timer.endTimer());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void verifyMetadataColumnStatsRecords(HoodieStorage storage, List<HoodieLogFile> logFiles) throws IOException {
        Iterator<HoodieLogFile> iterator = logFiles.iterator();
        block17: while (iterator.hasNext()) {
            HoodieLogFile logFile = iterator.next();
            List pathInfoList = storage.listDirectEntries(logFile.getPath());
            Schema writerSchema = TableSchemaResolver.readSchemaFromLogFile((HoodieStorage)storage, (StoragePath)logFile.getPath());
            if (writerSchema == null) continue;
            HoodieLogFormat.Reader logFileReader = HoodieLogFormat.newReader((HoodieStorage)storage, (HoodieLogFile)new HoodieLogFile(((StoragePathInfo)pathInfoList.get(0)).getPath()), (Schema)writerSchema);
            Throwable throwable = null;
            try {
                while (true) {
                    ClosableIterator recordItr;
                    block21: {
                        if (!logFileReader.hasNext()) continue block17;
                        HoodieLogBlock logBlock = (HoodieLogBlock)logFileReader.next();
                        if (!(logBlock instanceof HoodieDataBlock)) continue;
                        recordItr = ((HoodieDataBlock)logBlock).getRecordIterator(HoodieRecord.HoodieRecordType.AVRO);
                        Throwable throwable2 = null;
                        try {
                            recordItr.forEachRemaining(indexRecord -> {
                                GenericRecord record = (GenericRecord)indexRecord.getData();
                                GenericRecord colStatsRecord = (GenericRecord)record.get("ColumnStatsMetadata");
                                org.junit.jupiter.api.Assertions.assertNotNull((Object)colStatsRecord);
                                org.junit.jupiter.api.Assertions.assertNotNull((Object)colStatsRecord.get("columnName"));
                                org.junit.jupiter.api.Assertions.assertNotNull((Object)colStatsRecord.get("nullCount"));
                            });
                            if (recordItr == null) continue;
                            if (throwable2 == null) break block21;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (recordItr == null) throw throwable4;
                                if (throwable2 != null) {
                                    try {
                                        recordItr.close();
                                        throw throwable4;
                                    }
                                    catch (Throwable throwable5) {
                                        throwable2.addSuppressed(throwable5);
                                        throw throwable4;
                                    }
                                }
                                recordItr.close();
                                throw throwable4;
                            }
                        }
                        try {
                            recordItr.close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    recordItr.close();
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
            finally {
                if (logFileReader == null) continue;
                if (throwable != null) {
                    try {
                        logFileReader.close();
                    }
                    catch (Throwable throwable8) {
                        throwable.addSuppressed(throwable8);
                    }
                    continue;
                }
                logFileReader.close();
            }
        }
    }

    private List<StoragePath> getAllFiles(HoodieTableMetadata metadata) throws Exception {
        LinkedList<StoragePath> allfiles = new LinkedList<StoragePath>();
        for (String partition : metadata.getAllPartitionPaths()) {
            for (StoragePathInfo pathInfo : metadata.getAllFilesInPartition(new StoragePath(this.basePath, partition))) {
                allfiles.add(pathInfo.getPath());
            }
        }
        return allfiles;
    }

    private static HoodieBackedTableMetadataWriter<JavaRDD<HoodieRecord>> metadataWriter(SparkRDDWriteClient client, StorageConfiguration<?> storageConf, JavaSparkContext jsc) {
        return (HoodieBackedTableMetadataWriter)SparkHoodieBackedTableMetadataWriter.create(storageConf, (HoodieWriteConfig)client.getConfig(), (HoodieEngineContext)new HoodieSparkEngineContext(jsc));
    }

    public static HoodieTableMetadata metadata(SparkRDDWriteClient client, HoodieStorage storage) {
        HoodieWriteConfig clientConfig = client.getConfig();
        return HoodieTableMetadata.create((HoodieEngineContext)client.getEngineContext(), (HoodieStorage)storage, (HoodieMetadataConfig)clientConfig.getMetadataConfig(), (String)clientConfig.getBasePath());
    }

    private void changeTableVersion(HoodieTableVersion version) throws IOException {
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        this.metaClient.getTableConfig().setTableVersion(version);
        StoragePath propertyFile = new StoragePath(this.metaClient.getMetaPath(), "hoodie.properties");
        try (OutputStream os = this.metaClient.getStorage().create(propertyFile);){
            this.metaClient.getTableConfig().getProps().store(os, "");
        }
    }

    protected HoodieTableType getTableType() {
        return this.tableType;
    }

    private static Properties getDisabledRowWriterProperties() {
        Properties properties = new Properties();
        properties.setProperty("hoodie.datasource.write.row.writer.enable", String.valueOf(false));
        return properties;
    }

    private static /* synthetic */ void lambda$validateMetadata$70(HoodieTableFileSystemView fsView, HoodieTable table, HoodieStorage storage, String partition) {
        List latestSlices = fsView.getLatestFileSlices(partition).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertTrue((latestSlices.stream().map(FileSlice::getBaseFile).count() <= (long)latestSlices.size() ? 1 : 0) != 0, (String)"Should have a single latest base file per file group");
        List<HoodieLogFile> logFiles = ((FileSlice)latestSlices.get(0)).getLogFiles().collect(Collectors.toList());
        try {
            if (MetadataPartitionType.FILES.getPartitionPath().equals(partition)) {
                TestHoodieBackedMetadata.verifyMetadataRawRecords(table, logFiles, false);
            }
            if (MetadataPartitionType.COLUMN_STATS.getPartitionPath().equals(partition)) {
                TestHoodieBackedMetadata.verifyMetadataColumnStatsRecords(storage, logFiles);
            }
        }
        catch (Exception e) {
            LOG.error("Metadata record validation failed", (Throwable)e);
            org.junit.jupiter.api.Assertions.fail((String)"Metadata record validation failed");
        }
    }

    private static /* synthetic */ void lambda$validateMetadata$66(String basePath, HoodieStorage storage, Option ignoreFilesWithCommit, HoodieTableMetadata tableMetadata, Map partitionToFilesMap, TableFileSystemView tableView, String partition) {
        try {
            StoragePath partitionPath = partition.equals("") ? new StoragePath(basePath) : new StoragePath(basePath, partition);
            List pathInfoList = FSUtils.getAllDataFilesInPartition((HoodieStorage)storage, (StoragePath)partitionPath);
            if (ignoreFilesWithCommit.isPresent()) {
                pathInfoList = pathInfoList.stream().filter(pathInfo -> !pathInfo.getPath().getName().contains((CharSequence)ignoreFilesWithCommit.get())).collect(Collectors.toList());
            }
            List metaFilesList = tableMetadata.getAllFilesInPartition(partitionPath);
            List fsFileNames = pathInfoList.stream().map(s -> s.getPath().getName()).collect(Collectors.toList());
            List metadataFilenames = metaFilesList.stream().map(s -> s.getPath().getName()).collect(Collectors.toList());
            Collections.sort(fsFileNames);
            Collections.sort(metadataFilenames);
            org.junit.jupiter.api.Assertions.assertEquals((int)pathInfoList.size(), (int)((List)partitionToFilesMap.get(partitionPath.toString())).size(), (String)("Files within partition " + partition + " should match"));
            metaFilesList.stream().forEach(s -> org.junit.jupiter.api.Assertions.assertTrue((s.getLength() > 0L ? 1 : 0) != 0));
            if (fsFileNames.size() != metadataFilenames.size() || !fsFileNames.equals(metadataFilenames)) {
                LOG.info("*** File system listing = " + Arrays.toString(fsFileNames.toArray()));
                LOG.info("*** Metadata listing = " + Arrays.toString(metadataFilenames.toArray()));
                for (String fileName : fsFileNames) {
                    if (metadataFilenames.contains(fileName)) continue;
                    LOG.error(partition + "FsFilename " + fileName + " not found in Meta data");
                }
                for (String fileName : metadataFilenames) {
                    if (fsFileNames.contains(fileName)) continue;
                    LOG.error(partition + "Metadata file " + fileName + " not found in original FS");
                }
            }
            metaFilesList.forEach(s -> org.junit.jupiter.api.Assertions.assertTrue((s.getBlockSize() > 0L ? 1 : 0) != 0));
            List fsBlockSizes = pathInfoList.stream().map(StoragePathInfo::getBlockSize).collect(Collectors.toList());
            Collections.sort(fsBlockSizes);
            List metadataBlockSizes = metaFilesList.stream().map(StoragePathInfo::getBlockSize).collect(Collectors.toList());
            Collections.sort(metadataBlockSizes);
            org.junit.jupiter.api.Assertions.assertEquals(fsBlockSizes, metadataBlockSizes);
            org.junit.jupiter.api.Assertions.assertEquals((int)fsFileNames.size(), (int)metadataFilenames.size(), (String)("Files within partition " + partition + " should match"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)fsFileNames.equals(metadataFilenames), (String)("Files within partition " + partition + " should match"));
            List<HoodieFileGroup> fileGroups = tableView.getAllFileGroups(partition).collect(Collectors.toList());
            fileGroups.addAll(tableView.getAllReplacedFileGroups(partition).collect(Collectors.toList()));
            fileGroups.forEach(g -> LoggerFactory.getLogger(TestHoodieBackedMetadata.class).info(g.toString()));
            fileGroups.forEach(g -> g.getAllBaseFiles().forEach(b -> LoggerFactory.getLogger(TestHoodieBackedMetadata.class).info(b.toString())));
            fileGroups.forEach(g -> g.getAllFileSlices().forEach(s -> LoggerFactory.getLogger(TestHoodieBackedMetadata.class).info(s.toString())));
            long numFiles = fileGroups.stream().mapToLong(g -> g.getAllBaseFiles().count() + g.getAllFileSlices().mapToLong(s -> s.getLogFiles().count()).sum()).sum();
            org.junit.jupiter.api.Assertions.assertEquals((long)metadataFilenames.size(), (long)numFiles);
        }
        catch (IOException e) {
            e.printStackTrace();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)false, (String)("Exception should not be raised: " + e));
        }
    }

    private /* synthetic */ void lambda$testMetadataRecordKeyExcludeFromPayload$11(HoodieTable table, boolean enableMetaFields) throws Throwable {
        this.verifyMetadataRecordKeyExcludeFromPayloadBaseFiles(table, enableMetaFields);
    }

    private /* synthetic */ void lambda$testMetadataRecordKeyExcludeFromPayload$10(HoodieTable table, HoodieTableMetaClient metadataMetaClient, boolean enableMetaFields) throws Throwable {
        this.verifyMetadataRecordKeyExcludeFromPayloadLogFiles(table, metadataMetaClient, "7", enableMetaFields);
    }

    private /* synthetic */ void lambda$testMetadataRecordKeyExcludeFromPayload$9(HoodieTable table, boolean enableMetaFields) throws Throwable {
        this.verifyMetadataRecordKeyExcludeFromPayloadBaseFiles(table, enableMetaFields);
    }

    private /* synthetic */ void lambda$testMetadataRecordKeyExcludeFromPayload$8(HoodieTable table, HoodieTableMetaClient metadataMetaClient, boolean enableMetaFields) throws Throwable {
        this.verifyMetadataRecordKeyExcludeFromPayloadLogFiles(table, metadataMetaClient, "0000002", enableMetaFields);
    }

    private /* synthetic */ void lambda$testMetadataRecordKeyExcludeFromPayload$7(HoodieTable table, HoodieTableMetaClient metadataMetaClient, boolean enableMetaFields) throws Throwable {
        this.verifyMetadataRecordKeyExcludeFromPayloadLogFiles(table, metadataMetaClient, "0000001", enableMetaFields);
    }
}

