/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.functional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.transaction.lock.InProcessLockProvider;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieUnMergedLogRecordScanner;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.testutils.GenericRecordValidationTestUtils;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.hudi.testutils.HoodieSparkWriteableTestTable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHoodieClientOnMergeOnReadStorage
extends HoodieClientTestBase {
    private HoodieTestTable testTable;

    @BeforeEach
    public void setUpTestTable() {
        this.testTable = HoodieSparkWriteableTestTable.of((HoodieTableMetaClient)this.metaClient);
    }

    @Test
    public void testReadingMORTableWithoutBaseFile() throws Exception {
        HoodieWriteConfig config = this.getConfigBuilder("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", HoodieIndex.IndexType.INMEMORY).withAutoCommit(true).withCompactionConfig(HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(2).build()).build();
        SparkRDDWriteClient client = this.getHoodieWriteClient(config);
        String commitTime = client.createNewInstantTime();
        this.insertBatch(config, client, commitTime, "000", 100, SparkRDDWriteClient::insert, false, false, 100, 100, 1, Option.empty(), HoodieTestUtils.INSTANT_GENERATOR);
        String commitTimeBetweenPrevAndNew = commitTime;
        commitTime = client.createNewInstantTime();
        this.updateBatch(config, client, commitTime, commitTimeBetweenPrevAndNew, Option.of(Arrays.asList(commitTimeBetweenPrevAndNew)), "000", 50, SparkRDDWriteClient::upsert, false, false, 50, 100, 2, config.populateMetaFields(), HoodieTestUtils.INSTANT_GENERATOR);
        String prevCommitTime = commitTime;
        commitTime = client.createNewInstantTime();
        this.deleteBatch(config, client, commitTime, prevCommitTime, "000", 25, false, false, 0, 100, HoodieTestUtils.TIMELINE_FACTORY, HoodieTestUtils.INSTANT_GENERATOR);
        this.metaClient.reloadActiveTimeline();
        Map recordMap = GenericRecordValidationTestUtils.getRecordsMap((HoodieWriteConfig)config, (StorageConfiguration)this.storageConf, (HoodieTestDataGenerator)this.dataGen);
        Assertions.assertEquals((int)75, (int)recordMap.size());
    }

    @Test
    public void testCompactionOnMORTable() throws Exception {
        HoodieWriteConfig config = this.getConfigBuilder("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", HoodieIndex.IndexType.INMEMORY).withAutoCommit(true).withCompactionConfig(HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(2).build()).build();
        SparkRDDWriteClient client = this.getHoodieWriteClient(config);
        String commitTime = client.createNewInstantTime();
        this.insertBatch(config, client, commitTime, "000", 100, SparkRDDWriteClient::insert, false, false, 100, 100, 1, Option.empty(), HoodieTestUtils.INSTANT_GENERATOR);
        String commitTimeBetweenPrevAndNew = commitTime;
        commitTime = client.createNewInstantTime();
        this.updateBatch(config, client, commitTime, commitTimeBetweenPrevAndNew, Option.of(Arrays.asList(commitTimeBetweenPrevAndNew)), "000", 50, SparkRDDWriteClient::upsert, false, false, 5, 100, 2, config.populateMetaFields(), HoodieTestUtils.INSTANT_GENERATOR);
        Option timeStamp = client.scheduleCompaction(Option.empty());
        Assertions.assertTrue((boolean)timeStamp.isPresent());
        client.compact((String)timeStamp.get());
        this.metaClient.reloadActiveTimeline();
        GenericRecordValidationTestUtils.assertDataInMORTable((HoodieWriteConfig)config, (String)commitTime, (String)((String)timeStamp.get()), (StorageConfiguration)this.storageConf, Arrays.asList(this.dataGen.getPartitionPaths()));
    }

    @Test
    public void testLogCompactionOnMORTable() throws Exception {
        HoodieCompactionConfig compactionConfig = HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(1).withLogCompactionBlocksThreshold(1).build();
        HoodieWriteConfig config = this.getConfigBuilder("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", HoodieIndex.IndexType.INMEMORY).withAutoCommit(true).withCompactionConfig(compactionConfig).build();
        SparkRDDWriteClient client = this.getHoodieWriteClient(config);
        int expectedTotalRecs = 100;
        String newCommitTime = client.createNewInstantTime();
        this.insertBatch(config, client, newCommitTime, "000", expectedTotalRecs, SparkRDDWriteClient::insert, false, false, expectedTotalRecs, expectedTotalRecs, 1, Option.empty(), HoodieTestUtils.INSTANT_GENERATOR);
        String prevCommitTime = newCommitTime;
        for (int i = 0; i < 5; ++i) {
            newCommitTime = client.createNewInstantTime();
            this.updateBatch(config, client, newCommitTime, prevCommitTime, Option.of(Arrays.asList(prevCommitTime)), "000", 50, SparkRDDWriteClient::upsert, false, false, 50, expectedTotalRecs += 50, i + 2, config.populateMetaFields(), HoodieTestUtils.INSTANT_GENERATOR);
            prevCommitTime = newCommitTime;
        }
        Option compactionTimeStamp = client.scheduleCompaction(Option.empty());
        Assertions.assertTrue((boolean)compactionTimeStamp.isPresent());
        client.compact((String)compactionTimeStamp.get());
        prevCommitTime = (String)compactionTimeStamp.get();
        for (int i = 0; i < 2; ++i) {
            newCommitTime = client.createNewInstantTime();
            this.updateBatch(config, client, newCommitTime, prevCommitTime, Option.of(Arrays.asList(prevCommitTime)), "000", 50, SparkRDDWriteClient::upsert, false, false, 50, expectedTotalRecs += 50, i + 8, config.populateMetaFields(), HoodieTestUtils.INSTANT_GENERATOR);
            prevCommitTime = newCommitTime;
        }
        String lastCommitBeforeLogCompaction = prevCommitTime;
        Option logCompactionTimeStamp = client.scheduleLogCompaction(Option.empty());
        Assertions.assertTrue((boolean)logCompactionTimeStamp.isPresent());
        client.logCompact((String)logCompactionTimeStamp.get());
        GenericRecordValidationTestUtils.assertDataInMORTable((HoodieWriteConfig)config, (String)lastCommitBeforeLogCompaction, (String)((String)logCompactionTimeStamp.get()), (StorageConfiguration)this.storageConf, Arrays.asList(this.dataGen.getPartitionPaths()));
    }

    @Test
    public void testLogCompactionOnMORTableWithoutBaseFile() throws Exception {
        HoodieCompactionConfig compactionConfig = HoodieCompactionConfig.newBuilder().withEnableOptimizedLogBlocksScan("true").withMaxNumDeltaCommitsBeforeCompaction(1).withLogCompactionBlocksThreshold(1).build();
        HoodieWriteConfig config = this.getConfigBuilder("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", HoodieIndex.IndexType.INMEMORY).withAutoCommit(true).withCompactionConfig(compactionConfig).build();
        SparkRDDWriteClient client = this.getHoodieWriteClient(config);
        String newCommitTime = client.createNewInstantTime();
        this.insertBatch(config, client, newCommitTime, "000", 100, SparkRDDWriteClient::insert, false, false, 100, 100, 1, Option.of((Object)"2016/03/15"), HoodieTestUtils.INSTANT_GENERATOR);
        String prevCommitTime = newCommitTime;
        newCommitTime = client.createNewInstantTime();
        this.updateBatch(config, client, newCommitTime, prevCommitTime, Option.of(Arrays.asList(prevCommitTime)), "000", 50, SparkRDDWriteClient::upsert, false, false, 50, 100, 2, config.populateMetaFields(), HoodieTestUtils.INSTANT_GENERATOR);
        prevCommitTime = newCommitTime;
        newCommitTime = client.createNewInstantTime();
        this.deleteBatch(config, client, newCommitTime, prevCommitTime, "000", 30, false, false, 0, 70, HoodieTestUtils.TIMELINE_FACTORY, HoodieTestUtils.INSTANT_GENERATOR);
        String lastCommitBeforeLogCompaction = newCommitTime;
        Option timeStamp = client.scheduleLogCompaction(Option.empty());
        Assertions.assertTrue((boolean)timeStamp.isPresent());
        client.logCompact((String)timeStamp.get());
        GenericRecordValidationTestUtils.assertDataInMORTable((HoodieWriteConfig)config, (String)lastCommitBeforeLogCompaction, (String)((String)timeStamp.get()), (StorageConfiguration)this.storageConf, Arrays.asList("2016/03/15"));
    }

    @Test
    public void testSchedulingLogCompactionAfterSchedulingCompaction() throws Exception {
        HoodieCompactionConfig compactionConfig = HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(1).withLogCompactionBlocksThreshold(1).build();
        HoodieWriteConfig config = this.getConfigBuilder("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", HoodieIndex.IndexType.INMEMORY).withAutoCommit(true).withCompactionConfig(compactionConfig).build();
        SparkRDDWriteClient client = this.getHoodieWriteClient(config);
        String newCommitTime = client.createNewInstantTime();
        this.insertBatch(config, client, newCommitTime, "000", 100, SparkRDDWriteClient::insert, false, false, 100, 100, 1, Option.empty(), HoodieTestUtils.INSTANT_GENERATOR);
        String prevCommitTime = newCommitTime;
        newCommitTime = client.createNewInstantTime();
        this.updateBatch(config, client, newCommitTime, prevCommitTime, Option.of(Arrays.asList(prevCommitTime)), "000", 50, SparkRDDWriteClient::upsert, false, false, 50, 100, 2, config.populateMetaFields(), HoodieTestUtils.INSTANT_GENERATOR);
        Option compactionTimeStamp = client.scheduleCompaction(Option.empty());
        Assertions.assertTrue((boolean)compactionTimeStamp.isPresent());
        Option logCompactionTimeStamp = client.scheduleLogCompaction(Option.empty());
        Assertions.assertFalse((boolean)logCompactionTimeStamp.isPresent());
    }

    @Test
    public void testSchedulingCompactionAfterSchedulingLogCompaction() throws Exception {
        HoodieCompactionConfig compactionConfig = HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(1).withLogCompactionBlocksThreshold(1).build();
        HoodieWriteConfig config = this.getConfigBuilder("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", HoodieIndex.IndexType.INMEMORY).withAutoCommit(true).withCompactionConfig(compactionConfig).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).withAutoClean(Boolean.valueOf(false)).build()).withWriteConcurrencyMode(WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL).withMarkersType(MarkerType.DIRECT.name()).withLockConfig(HoodieLockConfig.newBuilder().withLockProvider(InProcessLockProvider.class).build()).build();
        SparkRDDWriteClient client = this.getHoodieWriteClient(config);
        String newCommitTime = client.createNewInstantTime();
        this.insertBatch(config, client, newCommitTime, "000", 100, SparkRDDWriteClient::insert, false, false, 10, 100, 1, Option.empty(), HoodieTestUtils.INSTANT_GENERATOR);
        String prevCommitTime = newCommitTime;
        newCommitTime = client.createNewInstantTime();
        this.updateBatch(config, client, newCommitTime, prevCommitTime, Option.of(Arrays.asList(prevCommitTime)), "000", 50, SparkRDDWriteClient::upsert, false, false, 50, 10, 2, config.populateMetaFields(), HoodieTestUtils.INSTANT_GENERATOR);
        Option logCompactionTimeStamp = client.scheduleLogCompaction(Option.empty());
        Assertions.assertTrue((boolean)logCompactionTimeStamp.isPresent());
        Option compactionTimeStamp = client.scheduleCompaction(Option.empty());
        Assertions.assertTrue((boolean)compactionTimeStamp.isPresent());
    }

    @Test
    public void testCleanFunctionalityWhenCompactionRequestedInstantIsPresent() throws Exception {
        HoodieWriteConfig config = this.getConfigBuilder("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", HoodieIndex.IndexType.INMEMORY).withAutoCommit(true).withCompactionConfig(HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(1).build()).withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(4).build()).build();
        SparkRDDWriteClient client = this.getHoodieWriteClient(config);
        String newCommitTime = client.createNewInstantTime();
        this.insertBatch(config, client, newCommitTime, "000", 100, SparkRDDWriteClient::insert, false, false, 100, 100, 1, Option.empty(), HoodieTestUtils.INSTANT_GENERATOR);
        Option compactionTimeStamp = client.scheduleCompaction(Option.empty());
        Assertions.assertTrue((boolean)compactionTimeStamp.isPresent());
        client.compact((String)compactionTimeStamp.get());
        String prevCommitTime = (String)compactionTimeStamp.get();
        newCommitTime = client.createNewInstantTime();
        this.updateBatch(config, client, newCommitTime, prevCommitTime, Option.of(Arrays.asList(prevCommitTime)), "000", 50, SparkRDDWriteClient::upsert, false, false, 50, 100, 2, config.populateMetaFields(), HoodieTestUtils.INSTANT_GENERATOR);
        prevCommitTime = newCommitTime;
        compactionTimeStamp = client.scheduleCompaction(Option.empty());
        Assertions.assertTrue((boolean)compactionTimeStamp.isPresent());
        prevCommitTime = (String)compactionTimeStamp.get();
        for (int i = 0; i < 6; ++i) {
            newCommitTime = client.createNewInstantTime();
            this.updateBatch(config, client, newCommitTime, prevCommitTime, Option.of(Arrays.asList(prevCommitTime)), "000", 50, SparkRDDWriteClient::upsert, false, false, 50, 100, 2, config.populateMetaFields(), HoodieTestUtils.INSTANT_GENERATOR);
            prevCommitTime = newCommitTime;
            if (i == 2) {
                HoodieInstant cleanInstant = (HoodieInstant)this.metaClient.reloadActiveTimeline().lastInstant().get();
                Assertions.assertEquals((Object)"clean", (Object)cleanInstant.getAction());
                continue;
            }
            Assertions.assertEquals((Object)"deltacommit", (Object)((HoodieInstant)this.metaClient.reloadActiveTimeline().lastInstant().get()).getAction());
        }
    }

    @Test
    public void testRollbackOnLogCompaction() throws Exception {
        HoodieCompactionConfig compactionConfig = HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(1).withLogCompactionBlocksThreshold(1).build();
        HoodieWriteConfig lcConfig = this.getConfigBuilder("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", HoodieIndex.IndexType.INMEMORY).withAutoCommit(false).withCompactionConfig(compactionConfig).build();
        HoodieWriteConfig config = this.getConfigBuilder("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", HoodieIndex.IndexType.INMEMORY).withAutoCommit(true).build();
        try (SparkRDDWriteClient lcClient = new SparkRDDWriteClient((HoodieEngineContext)this.context, lcConfig);
             SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)this.context, config);){
            String newCommitTime = client.createNewInstantTime();
            this.insertBatch(config, client, newCommitTime, "000", 100, SparkRDDWriteClient::insert, false, false, 100, 100, 1, Option.empty(), HoodieTestUtils.INSTANT_GENERATOR);
            String prevCommitTime = newCommitTime;
            newCommitTime = client.createNewInstantTime();
            this.updateBatch(config, client, newCommitTime, prevCommitTime, Option.of(Arrays.asList(prevCommitTime)), "000", 10, SparkRDDWriteClient::upsert, false, false, 10, 100, 4, config.populateMetaFields(), HoodieTestUtils.INSTANT_GENERATOR);
            prevCommitTime = newCommitTime;
            Option logCompactionTimeStamp = lcClient.scheduleLogCompaction(Option.empty());
            Assertions.assertTrue((boolean)logCompactionTimeStamp.isPresent());
            lcClient.logCompact((String)logCompactionTimeStamp.get());
            HoodieInstant instant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "logcompaction", (String)logCompactionTimeStamp.get());
            this.getHoodieTable(this.metaClient, config).rollbackInflightLogCompaction(instant);
            HoodieActiveTimeline activeTimeline = this.metaClient.reloadActiveTimeline();
            HoodieInstant rollbackInstant = (HoodieInstant)activeTimeline.lastInstant().get();
            Assertions.assertEquals((int)3, (int)activeTimeline.countInstants());
            Assertions.assertEquals((Object)"rollback", (Object)rollbackInstant.getAction());
            this.validateBlockInstantsBeforeAndAfterRollback(config, prevCommitTime, rollbackInstant.requestedTime());
            prevCommitTime = rollbackInstant.requestedTime();
            newCommitTime = client.createNewInstantTime();
            this.updateBatch(config, client, newCommitTime, prevCommitTime, Option.of(Arrays.asList(prevCommitTime)), "000", 10, SparkRDDWriteClient::upsert, false, false, 10, 100, 4, config.populateMetaFields(), HoodieTestUtils.INSTANT_GENERATOR);
            prevCommitTime = newCommitTime;
            logCompactionTimeStamp = lcClient.scheduleLogCompaction(Option.empty());
            Assertions.assertTrue((boolean)logCompactionTimeStamp.isPresent());
            HoodieWriteMetadata metadata = lcClient.logCompact((String)logCompactionTimeStamp.get());
            lcClient.commitLogCompaction((String)logCompactionTimeStamp.get(), (HoodieCommitMetadata)metadata.getCommitMetadata().get(), Option.empty());
            GenericRecordValidationTestUtils.assertDataInMORTable((HoodieWriteConfig)config, (String)prevCommitTime, (String)((String)logCompactionTimeStamp.get()), (StorageConfiguration)this.storageConf, Arrays.asList(this.dataGen.getPartitionPaths()));
        }
    }

    private void validateBlockInstantsBeforeAndAfterRollback(HoodieWriteConfig config, String instant, String currentInstant) {
        HoodieSparkTable table = this.getHoodieTable(this.metaClient, config);
        SyncableFileSystemView fileSystemView = (SyncableFileSystemView)table.getSliceView();
        List partitionPaths = Stream.of(HoodieTestDataGenerator.DEFAULT_PARTITION_PATHS).collect(Collectors.toList());
        for (String partitionPath : partitionPaths) {
            fileSystemView.getLatestFileSlices(partitionPath).forEach(arg_0 -> this.lambda$validateBlockInstantsBeforeAndAfterRollback$2((HoodieTable)table, instant, config, currentInstant, arg_0));
        }
    }

    @Test
    public void testArchivalOnLogCompaction() throws Exception {
        HoodieCompactionConfig logCompactionConfig = HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(1).withLogCompactionBlocksThreshold(1).build();
        HoodieWriteConfig lcWriteConfig = this.getConfigBuilder("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", HoodieIndex.IndexType.INMEMORY).withAutoCommit(true).withCompactionConfig(logCompactionConfig).build();
        HoodieCompactionConfig compactionConfig = HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(1).build();
        HoodieWriteConfig config = this.getConfigBuilder("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", HoodieIndex.IndexType.INMEMORY).withAutoCommit(true).withCompactionConfig(compactionConfig).withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(2).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(4, 5).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(2).build()).build();
        try (SparkRDDWriteClient lcWriteClient = new SparkRDDWriteClient((HoodieEngineContext)this.context, lcWriteConfig);
             SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)this.context, config);){
            String newCommitTime = client.createNewInstantTime();
            this.insertBatch(config, client, newCommitTime, "000", 100, SparkRDDWriteClient::insert, false, false, 10, 100, 1, Option.empty(), HoodieTestUtils.INSTANT_GENERATOR);
            String prevCommitTime = newCommitTime;
            ArrayList<Object> logCompactionInstantTimes = new ArrayList<Object>();
            for (int i = 0; i < 6; ++i) {
                if (i % 4 == 0) {
                    Option compactionTimeStamp = client.scheduleCompaction(Option.empty());
                    Assertions.assertTrue((boolean)compactionTimeStamp.isPresent());
                    client.compact((String)compactionTimeStamp.get());
                    prevCommitTime = (String)compactionTimeStamp.get();
                }
                newCommitTime = client.createNewInstantTime();
                this.updateBatch(config, client, newCommitTime, prevCommitTime, Option.of(Arrays.asList(prevCommitTime)), "000", 50, SparkRDDWriteClient::upsert, false, false, 50, 10, 0, config.populateMetaFields(), HoodieTestUtils.INSTANT_GENERATOR);
                Option logCompactionTimeStamp = lcWriteClient.scheduleLogCompaction(Option.empty());
                if (!logCompactionTimeStamp.isPresent()) continue;
                logCompactionInstantTimes.add(logCompactionTimeStamp.get());
                lcWriteClient.logCompact((String)logCompactionTimeStamp.get());
                prevCommitTime = (String)logCompactionTimeStamp.get();
            }
            boolean logCompactionInstantArchived = false;
            Map<String, List<HoodieInstant>> instantsMap = this.metaClient.getArchivedTimeline().getInstantsAsStream().collect(Collectors.groupingBy(HoodieInstant::requestedTime));
            for (String string : logCompactionInstantTimes) {
                List<HoodieInstant> instants = instantsMap.get(string);
                if (instants == null) continue;
                Assertions.assertEquals((int)1, (int)instants.size());
                Assertions.assertEquals((Object)"deltacommit", (Object)instants.get(0).getAction());
                logCompactionInstantArchived = true;
            }
            Assertions.assertTrue((boolean)logCompactionInstantArchived);
        }
    }

    protected HoodieTableType getTableType() {
        return HoodieTableType.MERGE_ON_READ;
    }

    private /* synthetic */ void lambda$validateBlockInstantsBeforeAndAfterRollback$2(HoodieTable table, String instant, HoodieWriteConfig config, String currentInstant, FileSlice slice) {
        HoodieUnMergedLogRecordScanner scanner = HoodieUnMergedLogRecordScanner.newBuilder().withStorage(this.metaClient.getStorage()).withBasePath(table.getMetaClient().getBasePath()).withLogFilePaths(slice.getLogFiles().sorted(HoodieLogFile.getLogFileComparator()).map(file -> file.getPath().toString()).collect(Collectors.toList())).withLatestInstantTime(instant).withBufferSize(config.getMaxDFSStreamBufferSize()).withOptimizedLogBlocksScan(true).withTableMetaClient(this.metaClient).build();
        scanner.scan(true);
        List prevInstants = scanner.getValidBlockInstants();
        HoodieUnMergedLogRecordScanner scanner2 = HoodieUnMergedLogRecordScanner.newBuilder().withStorage(this.metaClient.getStorage()).withBasePath(table.getMetaClient().getBasePath()).withLogFilePaths(slice.getLogFiles().sorted(HoodieLogFile.getLogFileComparator()).map(file -> file.getPath().toString()).collect(Collectors.toList())).withLatestInstantTime(currentInstant).withBufferSize(config.getMaxDFSStreamBufferSize()).withOptimizedLogBlocksScan(true).withTableMetaClient(table.getMetaClient()).build();
        scanner2.scan(true);
        List currentInstants = scanner2.getValidBlockInstants();
        Assertions.assertEquals((Object)prevInstants, (Object)currentInstants);
    }
}

