/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.functional;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.avro.model.HoodieSecondaryIndexInfo;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.EmptyHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.metadata.BaseFileRecordParsingUtils;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.SecondaryIndexKeyUtils;
import org.apache.hudi.metadata.SecondaryIndexRecordGenerationUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.testutils.Assertions;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.spark.api.java.JavaRDD;
import org.junit.jupiter.api.Test;

public class TestMetadataUtilRLIandSIRecordGeneration
extends HoodieClientTestBase {
    @Test
    public void testRecordGenerationAPIsForCOW() throws IOException {
        HoodieTableType tableType = HoodieTableType.COPY_ON_WRITE;
        this.cleanupClients();
        this.initMetaClient(tableType);
        this.cleanupTimelineService();
        this.initTimelineService();
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        HoodieWriteConfig writeConfig = this.getConfigBuilder(HoodieFailedWritesCleaningPolicy.EAGER).build();
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, writeConfig);){
            String commitTime = client.createNewInstantTime();
            List records1 = this.dataGen.generateInserts(commitTime, Integer.valueOf(100));
            client.startCommitWithTime(commitTime);
            List writeStatuses1 = client.insert(this.jsc.parallelize(records1, 1), commitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses1);
            String finalCommitTime = commitTime;
            HashMap recordKeyToPartitionMapping1 = new HashMap();
            HashMap<String, String> fileIdToFileNameMapping1 = new HashMap<String, String>();
            writeStatuses1.forEach(writeStatus -> {
                org.junit.jupiter.api.Assertions.assertEquals((long)writeStatus.getStat().getNumDeletes(), (long)0L);
                String writeStatFileId = writeStatus.getFileId();
                if (!fileIdToFileNameMapping1.containsKey(writeStatFileId)) {
                    fileIdToFileNameMapping1.put(writeStatFileId, writeStatus.getStat().getPath().substring(writeStatus.getStat().getPath().lastIndexOf("/") + 1));
                }
                Iterator rliRecordsItr = BaseFileRecordParsingUtils.generateRLIMetadataHoodieRecordsForBaseFile((String)this.metaClient.getBasePath().toString(), (HoodieWriteStat)writeStatus.getStat(), (Integer)writeConfig.getWritesFileIdEncoding(), (String)finalCommitTime, (HoodieStorage)this.metaClient.getStorage());
                while (rliRecordsItr.hasNext()) {
                    HoodieRecord rliRecord = (HoodieRecord)rliRecordsItr.next();
                    String key = rliRecord.getRecordKey();
                    String partition = ((HoodieMetadataPayload)rliRecord.getData()).getRecordGlobalLocation().getPartitionPath();
                    recordKeyToPartitionMapping1.put(key, partition);
                }
            });
            HashMap expectedRecordToPartitionMapping1 = new HashMap();
            records1.forEach(record -> expectedRecordToPartitionMapping1.put(record.getRecordKey(), record.getPartitionPath()));
            org.junit.jupiter.api.Assertions.assertEquals(expectedRecordToPartitionMapping1, recordKeyToPartitionMapping1);
            commitTime = client.createNewInstantTime();
            client.startCommitWithTime(commitTime);
            String finalCommitTime2 = commitTime;
            List deletes2 = this.dataGen.generateUniqueDeleteRecords(commitTime, Integer.valueOf(30));
            List updates2 = this.dataGen.generateUniqueUpdates(commitTime, Integer.valueOf(30));
            List inserts2 = this.dataGen.generateInserts(commitTime, Integer.valueOf(30));
            ArrayList records2 = new ArrayList();
            records2.addAll(inserts2);
            records2.addAll(updates2);
            records2.addAll(deletes2);
            List writeStatuses2 = client.upsert(this.jsc.parallelize(records2, 1), commitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses2);
            List<String> expectedInserts = inserts2.stream().map(record -> record.getKey().getRecordKey()).collect(Collectors.toList());
            List<String> expectedDeletes = deletes2.stream().map(record -> record.getKey().getRecordKey()).collect(Collectors.toList());
            ArrayList<String> actualInserts = new ArrayList<String>();
            ArrayList<String> actualDeletes = new ArrayList<String>();
            this.generateRliRecordsAndAssert(writeStatuses2, fileIdToFileNameMapping1, finalCommitTime2, writeConfig, actualInserts, actualDeletes);
            this.assertListEquality(expectedInserts, actualInserts);
            this.assertListEquality(expectedDeletes, actualDeletes);
            actualInserts = new ArrayList();
            actualDeletes = new ArrayList();
            ArrayList<String> actualUpdates = new ArrayList<String>();
            List<String> expectedUpdates = updates2.stream().map(record -> record.getKey().getRecordKey()).collect(Collectors.toList());
            this.parseRecordKeysFromBaseFiles(writeStatuses2, fileIdToFileNameMapping1, finalCommitTime2, writeConfig, actualInserts, actualDeletes, actualUpdates);
            this.assertListEquality(expectedInserts, actualInserts);
            this.assertListEquality(expectedDeletes, actualDeletes);
            expectedUpdates.forEach(entry -> org.junit.jupiter.api.Assertions.assertTrue((boolean)actualUpdates.contains(entry)));
        }
    }

    @Test
    public void testRecordGenerationAPIsForMOR() throws IOException {
        HoodieTableType tableType = HoodieTableType.MERGE_ON_READ;
        this.cleanupClients();
        Properties props = new Properties();
        props.put(HoodieTableConfig.PRECOMBINE_FIELD.key(), "timestamp");
        this.initMetaClient(tableType, props);
        this.cleanupTimelineService();
        this.initTimelineService();
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        HoodieWriteConfig writeConfig = this.getConfigBuilder(HoodieFailedWritesCleaningPolicy.EAGER).withCompactionConfig(HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(2).withInlineCompaction(Boolean.valueOf(true)).compactionSmallFileSize(0L).build()).build();
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, writeConfig);){
            String commitTime = client.createNewInstantTime();
            List records1 = this.dataGen.generateInserts(commitTime, Integer.valueOf(100));
            client.startCommitWithTime(commitTime);
            List writeStatuses1 = client.insert(this.jsc.parallelize(records1, 1), commitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses1);
            String finalCommitTime = commitTime;
            HashMap recordKeyToPartitionMapping1 = new HashMap();
            HashMap fileIdToFileNameMapping1 = new HashMap();
            writeStatuses1.forEach(writeStatus -> {
                org.junit.jupiter.api.Assertions.assertEquals((long)writeStatus.getStat().getNumDeletes(), (long)0L);
                String writeStatFileId = writeStatus.getFileId();
                if (!fileIdToFileNameMapping1.containsKey(writeStatFileId)) {
                    fileIdToFileNameMapping1.put(writeStatFileId, writeStatus.getStat().getPath().substring(writeStatus.getStat().getPath().lastIndexOf("/") + 1));
                }
                Iterator rliRecordsItr = BaseFileRecordParsingUtils.generateRLIMetadataHoodieRecordsForBaseFile((String)this.metaClient.getBasePath().toString(), (HoodieWriteStat)writeStatus.getStat(), (Integer)writeConfig.getWritesFileIdEncoding(), (String)finalCommitTime, (HoodieStorage)this.metaClient.getStorage());
                while (rliRecordsItr.hasNext()) {
                    HoodieRecord rliRecord = (HoodieRecord)rliRecordsItr.next();
                    String key = rliRecord.getRecordKey();
                    String partition = ((HoodieMetadataPayload)rliRecord.getData()).getRecordGlobalLocation().getPartitionPath();
                    recordKeyToPartitionMapping1.put(key, partition);
                }
            });
            HashMap expectedRecordToPartitionMapping1 = new HashMap();
            records1.forEach(record -> expectedRecordToPartitionMapping1.put(record.getRecordKey(), record.getPartitionPath()));
            org.junit.jupiter.api.Assertions.assertEquals(expectedRecordToPartitionMapping1, recordKeyToPartitionMapping1);
            commitTime = client.createNewInstantTime();
            client.startCommitWithTime(commitTime);
            List deletes2 = this.dataGen.generateUniqueDeleteRecords(commitTime, Integer.valueOf(30));
            List updates2 = this.dataGen.generateUniqueUpdates(commitTime, Integer.valueOf(30));
            List inserts2 = this.dataGen.generateInserts(commitTime, Integer.valueOf(30));
            ArrayList records2 = new ArrayList();
            records2.addAll(inserts2);
            records2.addAll(updates2);
            records2.addAll(deletes2);
            List writeStatuses2 = client.upsert(this.jsc.parallelize(records2, 1), commitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses2);
            this.assertRLIandSIRecordGenerationAPIs(inserts2, updates2, deletes2, writeStatuses2, commitTime, writeConfig);
            commitTime = client.createNewInstantTime();
            client.startCommitWithTime(commitTime);
            String finalCommitTime3 = commitTime;
            List deletes3 = this.dataGen.generateUniqueDeleteRecords(commitTime, Integer.valueOf(30));
            List updates3 = this.dataGen.generateUniqueUpdates(commitTime, Integer.valueOf(30));
            List inserts3 = this.dataGen.generateInserts(commitTime, Integer.valueOf(30));
            ArrayList records3 = new ArrayList();
            records3.addAll(inserts3);
            records3.addAll(updates3);
            records3.addAll(deletes3);
            List writeStatuses3 = client.upsert(this.jsc.parallelize(records3, 1), commitTime).collect();
            Assertions.assertNoWriteErrors((List)writeStatuses3);
            this.assertRLIandSIRecordGenerationAPIs(inserts3, updates3, deletes3, writeStatuses3, finalCommitTime3, writeConfig);
            Option compactionInstantOpt = client.scheduleCompaction(Option.empty());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)compactionInstantOpt.isPresent());
            HoodieWriteMetadata compactionWriteMetadata = client.compact((String)compactionInstantOpt.get());
            HoodieCommitMetadata compactionCommitMetadata = (HoodieCommitMetadata)compactionWriteMetadata.getCommitMetadata().get();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetadataUtil.convertMetadataToRecordIndexRecords((HoodieEngineContext)this.context, (HoodieCommitMetadata)compactionCommitMetadata, (HoodieMetadataConfig)writeConfig.getMetadataConfig(), (HoodieTableMetaClient)this.metaClient, (int)writeConfig.getWritesFileIdEncoding(), (String)((String)compactionInstantOpt.get()), (EngineType)EngineType.SPARK).isEmpty());
        }
    }

    @Test
    public void testSecondaryIndexRecordGenerationForMOR() throws IOException {
        HoodieTableType tableType = HoodieTableType.MERGE_ON_READ;
        this.cleanupClients();
        Properties props = new Properties();
        props.put(HoodieTableConfig.PRECOMBINE_FIELD.key(), "timestamp");
        this.initMetaClient(tableType, props);
        this.cleanupTimelineService();
        this.initTimelineService();
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        HoodieWriteConfig writeConfig = this.getConfigBuilder(HoodieFailedWritesCleaningPolicy.EAGER).withAutoCommit(false).withCompactionConfig(HoodieCompactionConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(3).withInlineCompaction(Boolean.valueOf(false)).compactionSmallFileSize(0L).build()).build();
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, writeConfig);){
            String commitTime = client.createNewInstantTime();
            int initialRecordsCount = 10;
            List records1 = this.dataGen.generateInserts(commitTime, Integer.valueOf(initialRecordsCount));
            client.startCommitWithTime(commitTime);
            JavaRDD writeStatuses1 = client.insert(this.jsc.parallelize(records1, 1), commitTime);
            Assertions.assertNoWriteErrors((List)writeStatuses1.collect());
            client.commit(commitTime, (Object)writeStatuses1);
            List<String> expectedSecondaryIndexKeys = records1.stream().map(TestMetadataUtilRLIandSIRecordGeneration::getSecondaryIndexKey).collect(Collectors.toList());
            String firstCommitTime = commitTime;
            HoodieIndexDefinition indexDefinition = HoodieIndexDefinition.newBuilder().withIndexName("secondary_index_idx_rider").withIndexType("").withIndexFunction("").withSourceFields(Collections.singletonList("rider")).withIndexOptions(Collections.emptyMap()).build();
            HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).withSecondaryIndexParallelism(2).build();
            HoodieTableMetadata metadata = HoodieTableMetadata.create((HoodieEngineContext)engineContext, (HoodieStorage)this.storage, (HoodieMetadataConfig)metadataConfig, (String)this.metaClient.getBasePath().toString());
            HoodieTableFileSystemView metadataView = new HoodieTableFileSystemView(metadata, this.metaClient, (HoodieTimeline)this.metaClient.getActiveTimeline());
            metadataView.loadAllPartitions();
            ArrayList partitionFileSlicePairs = new ArrayList();
            HoodieTableFileSystemView finalMetadataView = metadataView;
            Arrays.asList(this.dataGen.getPartitionPaths()).forEach(partition -> finalMetadataView.getLatestMergedFileSlicesBeforeOrOn(partition, firstCommitTime).forEach(fs -> partitionFileSlicePairs.add(Pair.of((Object)partition, (Object)fs))));
            List secondaryIndexRecords = SecondaryIndexRecordGenerationUtils.readSecondaryKeysFromFileSlices((HoodieEngineContext)engineContext, partitionFileSlicePairs, (int)metadataConfig.getSecondaryIndexParallelism(), (String)((Object)((Object)this)).getClass().getSimpleName(), (HoodieTableMetaClient)this.metaClient, (EngineType)EngineType.SPARK, (HoodieIndexDefinition)indexDefinition).collectAsList();
            this.assertListEquality(expectedSecondaryIndexKeys, secondaryIndexRecords.stream().map(HoodieRecord::getRecordKey).collect(Collectors.toList()));
            commitTime = client.createNewInstantTime();
            client.startCommitWithTime(commitTime);
            List updates2 = this.dataGen.generateUniqueUpdates(commitTime, Integer.valueOf(1));
            List expectedUpdatedIndexKeys = updates2.stream().map(TestMetadataUtilRLIandSIRecordGeneration::getSecondaryIndexKey).collect(Collectors.toList());
            List inserts2 = this.dataGen.generateInserts(commitTime, Integer.valueOf(1));
            List expectedInsertedIndexKeys = inserts2.stream().map(TestMetadataUtilRLIandSIRecordGeneration::getSecondaryIndexKey).collect(Collectors.toList());
            ArrayList records2 = new ArrayList();
            records2.addAll(inserts2);
            records2.addAll(updates2);
            JavaRDD writeStatuses2 = client.upsert(this.jsc.parallelize(records2, 1), commitTime);
            Assertions.assertNoWriteErrors((List)writeStatuses2.collect());
            String secondCommitTime = commitTime;
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            metadata.reset();
            metadataView = new HoodieTableFileSystemView(metadata, this.metaClient, (HoodieTimeline)this.metaClient.getActiveTimeline());
            List allWriteStats = writeStatuses2.collect().stream().map(WriteStatus::getStat).collect(Collectors.toList());
            secondaryIndexRecords = SecondaryIndexRecordGenerationUtils.convertWriteStatsToSecondaryIndexRecords(allWriteStats, (String)secondCommitTime, (HoodieIndexDefinition)indexDefinition, (HoodieMetadataConfig)metadataConfig, (HoodieTableFileSystemView)metadataView, (HoodieTableMetaClient)this.metaClient, (HoodieEngineContext)engineContext, (EngineType)EngineType.SPARK).collectAsList();
            client.commit(secondCommitTime, (Object)writeStatuses2);
            org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)secondaryIndexRecords.size());
            ArrayList<String> validSecondaryIndexKeys = new ArrayList<String>(expectedInsertedIndexKeys);
            validSecondaryIndexKeys.addAll(expectedUpdatedIndexKeys);
            ArrayList deletedSecondaryIndexRecords = new ArrayList();
            ArrayList validSecondaryIndexRecords = new ArrayList();
            secondaryIndexRecords.forEach(record -> TestMetadataUtilRLIandSIRecordGeneration.populateValidAndDeletedSecondaryIndexRecords(record, deletedSecondaryIndexRecords, validSecondaryIndexRecords));
            this.assertListEquality(validSecondaryIndexKeys, validSecondaryIndexRecords.stream().map(HoodieRecord::getRecordKey).collect(Collectors.toList()));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)expectedSecondaryIndexKeys.containsAll(deletedSecondaryIndexRecords.stream().map(HoodieRecord::getRecordKey).collect(Collectors.toList())));
            commitTime = client.createNewInstantTime();
            client.startCommitWithTime(commitTime);
            List deletes = this.dataGen.generateUniqueDeleteRecords(commitTime, Integer.valueOf(1));
            List expectedDeletedIndexKeys = deletes.stream().map(TestMetadataUtilRLIandSIRecordGeneration::getSecondaryIndexKey).collect(Collectors.toList());
            ArrayList records3 = new ArrayList();
            records3.addAll(deletes);
            JavaRDD writeStatuses3 = client.upsert(this.jsc.parallelize(records3, 1), commitTime);
            Assertions.assertNoWriteErrors((List)writeStatuses3.collect());
            String thirdCommitTime = commitTime;
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            metadata.reset();
            metadataView = new HoodieTableFileSystemView(metadata, this.metaClient, (HoodieTimeline)this.metaClient.getActiveTimeline());
            allWriteStats = writeStatuses3.collect().stream().map(WriteStatus::getStat).collect(Collectors.toList());
            secondaryIndexRecords = SecondaryIndexRecordGenerationUtils.convertWriteStatsToSecondaryIndexRecords(allWriteStats, (String)thirdCommitTime, (HoodieIndexDefinition)indexDefinition, (HoodieMetadataConfig)metadataConfig, (HoodieTableFileSystemView)metadataView, (HoodieTableMetaClient)this.metaClient, (HoodieEngineContext)engineContext, (EngineType)EngineType.SPARK).collectAsList();
            client.commit(thirdCommitTime, (Object)writeStatuses3);
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)secondaryIndexRecords.size());
            ArrayList validSecondaryIndexRecords2 = new ArrayList();
            ArrayList deletedSecondaryIndexRecords2 = new ArrayList();
            secondaryIndexRecords.forEach(record -> TestMetadataUtilRLIandSIRecordGeneration.populateValidAndDeletedSecondaryIndexRecords(record, deletedSecondaryIndexRecords2, validSecondaryIndexRecords2));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)validSecondaryIndexRecords2.isEmpty());
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)deletedSecondaryIndexRecords2.size());
            org.junit.jupiter.api.Assertions.assertEquals((Object)SecondaryIndexKeyUtils.getRecordKeyFromSecondaryIndexKey((String)((String)expectedDeletedIndexKeys.get(0))), (Object)SecondaryIndexKeyUtils.getRecordKeyFromSecondaryIndexKey((String)((HoodieRecord)deletedSecondaryIndexRecords2.get(0)).getRecordKey()));
            commitTime = client.createNewInstantTime();
            client.startCommitWithTime(commitTime);
            List inserts4 = this.dataGen.generateSameKeyInserts(commitTime, deletes);
            List expectedRevivedIndexKeys = inserts4.stream().map(TestMetadataUtilRLIandSIRecordGeneration::getSecondaryIndexKey).collect(Collectors.toList());
            ArrayList records4 = new ArrayList();
            records4.addAll(inserts4);
            JavaRDD writeStatuses4 = client.upsert(this.jsc.parallelize(records4, 1), commitTime);
            Assertions.assertNoWriteErrors((List)writeStatuses4.collect());
            String fourthCommitTime = commitTime;
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            metadata.reset();
            metadataView = new HoodieTableFileSystemView(metadata, this.metaClient, (HoodieTimeline)this.metaClient.getActiveTimeline());
            allWriteStats = writeStatuses4.collect().stream().map(WriteStatus::getStat).collect(Collectors.toList());
            secondaryIndexRecords = SecondaryIndexRecordGenerationUtils.convertWriteStatsToSecondaryIndexRecords(allWriteStats, (String)fourthCommitTime, (HoodieIndexDefinition)indexDefinition, (HoodieMetadataConfig)metadataConfig, (HoodieTableFileSystemView)metadataView, (HoodieTableMetaClient)this.metaClient, (HoodieEngineContext)engineContext, (EngineType)EngineType.SPARK).collectAsList();
            client.commit(fourthCommitTime, (Object)writeStatuses4);
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)secondaryIndexRecords.size());
            org.junit.jupiter.api.Assertions.assertEquals(expectedRevivedIndexKeys.get(0), (Object)((HoodieRecord)secondaryIndexRecords.get(0)).getRecordKey());
            commitTime = client.createNewInstantTime();
            client.startCommitWithTime(commitTime);
            List updates5 = this.dataGen.generateUpdatesWithTimestamp(fourthCommitTime, inserts4, Long.parseLong(commitTime));
            List expectedUpdatedIndexKeys2 = updates5.stream().map(TestMetadataUtilRLIandSIRecordGeneration::getSecondaryIndexKey).collect(Collectors.toList());
            ArrayList records5 = new ArrayList();
            records5.addAll(updates5);
            JavaRDD writeStatuses5 = client.upsert(this.jsc.parallelize(records5, 1), commitTime);
            Assertions.assertNoWriteErrors((List)writeStatuses5.collect());
            String fifthCommitTime = commitTime;
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            metadata.reset();
            metadataView = new HoodieTableFileSystemView(metadata, this.metaClient, (HoodieTimeline)this.metaClient.getActiveTimeline());
            allWriteStats = writeStatuses5.collect().stream().map(WriteStatus::getStat).collect(Collectors.toList());
            secondaryIndexRecords = SecondaryIndexRecordGenerationUtils.convertWriteStatsToSecondaryIndexRecords(allWriteStats, (String)fifthCommitTime, (HoodieIndexDefinition)indexDefinition, (HoodieMetadataConfig)metadataConfig, (HoodieTableFileSystemView)metadataView, (HoodieTableMetaClient)this.metaClient, (HoodieEngineContext)engineContext, (EngineType)EngineType.SPARK).collectAsList();
            client.commit(fifthCommitTime, (Object)writeStatuses5);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)secondaryIndexRecords.size());
            Option compactionInstantOpt = client.scheduleCompaction(Option.empty());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)compactionInstantOpt.isPresent());
            HoodieWriteMetadata compactionWriteMetadata = client.compact((String)compactionInstantOpt.get());
            HoodieCommitMetadata compactionCommitMetadata = (HoodieCommitMetadata)compactionWriteMetadata.getCommitMetadata().get();
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
            metadata.reset();
            metadataView = new HoodieTableFileSystemView(metadata, this.metaClient, (HoodieTimeline)this.metaClient.getActiveTimeline());
            allWriteStats = compactionCommitMetadata.getWriteStats();
            secondaryIndexRecords = SecondaryIndexRecordGenerationUtils.convertWriteStatsToSecondaryIndexRecords((List)allWriteStats, (String)((String)compactionInstantOpt.get()), (HoodieIndexDefinition)indexDefinition, (HoodieMetadataConfig)metadataConfig, (HoodieTableFileSystemView)metadataView, (HoodieTableMetaClient)this.metaClient, (HoodieEngineContext)engineContext, (EngineType)EngineType.SPARK).collectAsList();
            ArrayList validSecondaryIndexRecords3 = new ArrayList();
            ArrayList deletedSecondaryIndexRecords3 = new ArrayList();
            secondaryIndexRecords.forEach(record -> TestMetadataUtilRLIandSIRecordGeneration.populateValidAndDeletedSecondaryIndexRecords(record, deletedSecondaryIndexRecords3, validSecondaryIndexRecords3));
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)deletedSecondaryIndexRecords3.size());
            org.junit.jupiter.api.Assertions.assertEquals((int)initialRecordsCount, (int)this.dataGen.getNumExistingKeys("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}"));
        }
    }

    private static void populateValidAndDeletedSecondaryIndexRecords(HoodieRecord record, List<HoodieRecord> deletedSecondaryIndexRecords, List<HoodieRecord> validSecondaryIndexRecords) {
        try {
            if (record.isDelete(HoodieSecondaryIndexInfo.getClassSchema(), new Properties())) {
                deletedSecondaryIndexRecords.add(record);
            } else {
                validSecondaryIndexRecords.add(record);
            }
        }
        catch (IOException e) {
            org.junit.jupiter.api.Assertions.fail((String)"Failed to check if record is deleted.", (Throwable)e);
        }
    }

    private static String getSecondaryIndexKey(HoodieRecord record) {
        try {
            return SecondaryIndexKeyUtils.constructSecondaryIndexKey((String)((RawTripTestPayload)record.getData()).getJsonDataAsMap().get("rider").toString(), (String)record.getRecordKey());
        }
        catch (IOException e) {
            throw new HoodieException("Failed to construct secondary index key for record key: " + record.getRecordKey(), (Throwable)e);
        }
    }

    private void assertRLIandSIRecordGenerationAPIs(List<HoodieRecord> inserts3, List<HoodieRecord> updates3, List<HoodieRecord> deletes3, List<WriteStatus> writeStatuses3, String finalCommitTime3, HoodieWriteConfig writeConfig) {
        List<String> expectedRLIInserts = inserts3.stream().map(record -> record.getKey().getRecordKey()).collect(Collectors.toList());
        List expectedUpdates = updates3.stream().map(record -> record.getKey().getRecordKey()).collect(Collectors.toList());
        List<String> expectedRLIDeletes = deletes3.stream().map(record -> record.getKey().getRecordKey()).collect(Collectors.toList());
        ArrayList<String> expectedUpatesAndDeletes = new ArrayList<String>(expectedRLIDeletes);
        expectedUpatesAndDeletes.addAll(expectedUpdates);
        ArrayList<String> actualInserts = new ArrayList<String>();
        ArrayList<String> actualDeletes = new ArrayList<String>();
        ArrayList<String> actualUpdatesAndDeletes = new ArrayList<String>();
        this.generateRliRecordsAndAssert(writeStatuses3.stream().filter(writeStatus -> !FSUtils.isLogFile((String)FSUtils.getFileName((String)writeStatus.getStat().getPath(), (String)writeStatus.getPartitionPath()))).collect(Collectors.toList()), Collections.emptyMap(), finalCommitTime3, writeConfig, actualInserts, actualDeletes);
        String latestCommitTimestamp = ((HoodieInstant)this.metaClient.reloadActiveTimeline().getCommitsTimeline().lastInstant().get()).requestedTime();
        Option<Schema> writerSchemaOpt = TestMetadataUtilRLIandSIRecordGeneration.tryResolveSchemaForTable(this.metaClient);
        ArrayList<String> finalActualDeletes = actualDeletes;
        writeStatuses3.stream().filter(writeStatus -> FSUtils.isLogFile((String)FSUtils.getFileName((String)writeStatus.getStat().getPath(), (String)writeStatus.getPartitionPath()))).forEach(writeStatus -> {
            try {
                StoragePath fullFilePath = new StoragePath(this.basePath, writeStatus.getStat().getPath());
                finalActualDeletes.addAll((Collection)HoodieTableMetadataUtil.getRevivedAndDeletedKeysFromMergedLogs((HoodieTableMetaClient)this.metaClient, (String)latestCommitTimestamp, (EngineType)EngineType.SPARK, Collections.singletonList(fullFilePath.toString()), (Option)writerSchemaOpt, Collections.singletonList(fullFilePath.toString())).getValue());
                actualUpdatesAndDeletes.addAll(HoodieTableMetadataUtil.getRecordKeys(Collections.singletonList(fullFilePath.toString()), (HoodieTableMetaClient)this.metaClient, (Option)writerSchemaOpt, (int)writeConfig.getMetadataConfig().getMaxReaderBufferSize(), (String)latestCommitTimestamp, (boolean)true, (boolean)true));
            }
            catch (IOException e) {
                throw new HoodieIOException("Failed w/ IOException ", e);
            }
        });
        this.assertListEquality(expectedRLIInserts, actualInserts);
        this.assertListEquality(expectedRLIDeletes, actualDeletes);
        this.assertListEquality(expectedUpatesAndDeletes, actualUpdatesAndDeletes);
    }

    @Test
    public void testReducedByKeysForRLIRecords() throws IOException {
        HoodieTableType tableType = HoodieTableType.COPY_ON_WRITE;
        this.cleanupClients();
        this.initMetaClient(tableType);
        this.cleanupTimelineService();
        this.initTimelineService();
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(this.jsc);
        HoodieWriteConfig writeConfig = this.getConfigBuilder(HoodieFailedWritesCleaningPolicy.EAGER).build();
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)engineContext, writeConfig);){
            String commitTime = client.createNewInstantTime();
            List inserts = this.dataGen.generateInserts(commitTime, Integer.valueOf(100));
            List deletes = this.dataGen.generateUniqueDeleteRecords(commitTime, Integer.valueOf(20));
            String randomFileId = UUID.randomUUID().toString() + "-0";
            List deletedRecordKeys = deletes.stream().map(record -> record.getRecordKey()).collect(Collectors.toList());
            List adjustedInserts = inserts.stream().filter(record -> !deletedRecordKeys.contains(record.getRecordKey())).collect(Collectors.toList());
            List insertRecords = inserts.stream().map(record -> HoodieMetadataPayload.createRecordIndexUpdate((String)record.getRecordKey(), (String)"abc", (String)randomFileId, (String)commitTime, (int)0)).collect(Collectors.toList());
            List deleteRecords = inserts.stream().map(record -> HoodieMetadataPayload.createRecordIndexDelete((String)record.getRecordKey())).collect(Collectors.toList());
            ArrayList<Object> recordsToTest = new ArrayList<HoodieRecord>();
            recordsToTest.addAll(adjustedInserts);
            recordsToTest.addAll(deleteRecords);
            List actualRecords = HoodieTableMetadataUtil.reduceByKeys((HoodieData)this.context.parallelize(recordsToTest, 2), (int)2).collectAsList();
            this.assertHoodieRecordListEquality(actualRecords, recordsToTest);
            recordsToTest = new ArrayList();
            recordsToTest.addAll(insertRecords);
            recordsToTest.addAll(deleteRecords);
            actualRecords = HoodieTableMetadataUtil.reduceByKeys((HoodieData)this.context.parallelize(recordsToTest, 2), (int)2).collectAsList();
            ArrayList<Object> expectedList = new ArrayList<HoodieRecord>();
            expectedList.addAll(insertRecords);
            this.assertHoodieRecordListEquality(actualRecords, expectedList);
            recordsToTest = new ArrayList();
            recordsToTest.addAll(adjustedInserts);
            recordsToTest.addAll(deleteRecords);
            recordsToTest.addAll(deleteRecords.subList(0, 10));
            actualRecords = HoodieTableMetadataUtil.reduceByKeys((HoodieData)this.context.parallelize(recordsToTest, 2), (int)2).collectAsList();
            expectedList = new ArrayList();
            expectedList.addAll(adjustedInserts);
            expectedList.addAll(deleteRecords);
            this.assertHoodieRecordListEquality(actualRecords, expectedList);
            recordsToTest = new ArrayList();
            recordsToTest.addAll(adjustedInserts);
            recordsToTest.addAll(adjustedInserts.subList(0, 5));
            try {
                HoodieTableMetadataUtil.reduceByKeys((HoodieData)this.context.parallelize(recordsToTest, 2), (int)2).collectAsList();
                org.junit.jupiter.api.Assertions.fail((String)"Should not have reached here");
            }
            catch (Exception e) {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)(e.getCause() instanceof HoodieIOException));
            }
        }
    }

    private void assertHoodieRecordListEquality(List<HoodieRecord> actualList, List<HoodieRecord> expectedList) {
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedList.size(), (int)actualList.size());
        List<String> expectedInsertRecordKeys = expectedList.stream().filter(record -> !(record.getData() instanceof EmptyHoodieRecordPayload)).map(record -> record.getRecordKey()).collect(Collectors.toList());
        List<String> expectedDeletedRecordKeys = expectedList.stream().filter(record -> record.getData() instanceof EmptyHoodieRecordPayload).map(record -> record.getRecordKey()).collect(Collectors.toList());
        List<String> actualInsertRecordKeys = actualList.stream().filter(record -> !(record.getData() instanceof EmptyHoodieRecordPayload)).map(record -> record.getRecordKey()).collect(Collectors.toList());
        List<String> actualDeletedRecordKeys = actualList.stream().filter(record -> record.getData() instanceof EmptyHoodieRecordPayload).map(record -> record.getRecordKey()).collect(Collectors.toList());
        this.assertListEquality(expectedInsertRecordKeys, actualInsertRecordKeys);
        this.assertListEquality(expectedDeletedRecordKeys, actualDeletedRecordKeys);
    }

    private void assertListEquality(List<String> list1, List<String> list2) {
        Collections.sort(list1);
        Collections.sort(list2);
        org.junit.jupiter.api.Assertions.assertEquals(list1, list2);
    }

    private static Option<Schema> tryResolveSchemaForTable(HoodieTableMetaClient dataTableMetaClient) {
        if (dataTableMetaClient.getCommitsTimeline().filterCompletedInstants().countInstants() == 0) {
            return Option.empty();
        }
        try {
            TableSchemaResolver schemaResolver = new TableSchemaResolver(dataTableMetaClient);
            return Option.of((Object)schemaResolver.getTableAvroSchema());
        }
        catch (Exception e) {
            throw new HoodieException("Failed to get latest columns for " + dataTableMetaClient.getBasePath(), (Throwable)e);
        }
    }

    private void generateRliRecordsAndAssert(List<WriteStatus> writeStatuses, Map<String, String> fileIdToFileNameMapping, String commitTime, HoodieWriteConfig writeConfig, List<String> actualInserts, List<String> actualDeletes) {
        writeStatuses.forEach(writeStatus -> {
            if (!FSUtils.isLogFile((String)FSUtils.getFileName((String)writeStatus.getStat().getPath(), (String)writeStatus.getPartitionPath()))) {
                String writeStatFileId = writeStatus.getFileId();
                if (!fileIdToFileNameMapping.isEmpty()) {
                    org.junit.jupiter.api.Assertions.assertEquals((Object)writeStatus.getStat().getPrevBaseFile(), fileIdToFileNameMapping.get(writeStatFileId));
                }
                Iterator rliRecordsItr = BaseFileRecordParsingUtils.generateRLIMetadataHoodieRecordsForBaseFile((String)this.metaClient.getBasePath().toString(), (HoodieWriteStat)writeStatus.getStat(), (Integer)writeConfig.getWritesFileIdEncoding(), (String)commitTime, (HoodieStorage)this.metaClient.getStorage());
                while (rliRecordsItr.hasNext()) {
                    HoodieRecord rliRecord = (HoodieRecord)rliRecordsItr.next();
                    String key = rliRecord.getRecordKey();
                    if (rliRecord.getData() instanceof EmptyHoodieRecordPayload) {
                        actualDeletes.add(key);
                        continue;
                    }
                    actualInserts.add(key);
                }
            }
        });
    }

    private void parseRecordKeysFromBaseFiles(List<WriteStatus> writeStatuses, Map<String, String> fileIdToFileNameMapping, String commitTime, HoodieWriteConfig writeConfig, List<String> actualInserts, List<String> actualDeletes, List<String> actualUpdates) {
        writeStatuses.forEach(writeStatus -> {
            if (!FSUtils.isLogFile((String)FSUtils.getFileName((String)writeStatus.getStat().getPath(), (String)writeStatus.getPartitionPath()))) {
                String writeStatFileId = writeStatus.getFileId();
                if (!fileIdToFileNameMapping.isEmpty()) {
                    org.junit.jupiter.api.Assertions.assertEquals((Object)writeStatus.getStat().getPrevBaseFile(), fileIdToFileNameMapping.get(writeStatFileId));
                }
                String partition = writeStatus.getStat().getPartitionPath();
                String latestFileName = FSUtils.getFileNameFromPath((String)writeStatus.getStat().getPath());
                HashSet<BaseFileRecordParsingUtils.RecordStatus> recordStatusSet = new HashSet<BaseFileRecordParsingUtils.RecordStatus>();
                recordStatusSet.add(BaseFileRecordParsingUtils.RecordStatus.INSERT);
                recordStatusSet.add(BaseFileRecordParsingUtils.RecordStatus.UPDATE);
                recordStatusSet.add(BaseFileRecordParsingUtils.RecordStatus.DELETE);
                Map recordKeyMappings = BaseFileRecordParsingUtils.getRecordKeyStatuses((String)this.metaClient.getBasePath().toString(), (String)partition, (String)latestFileName, (String)writeStatus.getStat().getPrevBaseFile(), (HoodieStorage)this.storage, recordStatusSet);
                if (recordKeyMappings.containsKey(BaseFileRecordParsingUtils.RecordStatus.INSERT)) {
                    actualInserts.addAll((Collection)recordKeyMappings.get(BaseFileRecordParsingUtils.RecordStatus.INSERT));
                }
                if (recordKeyMappings.containsKey(BaseFileRecordParsingUtils.RecordStatus.UPDATE)) {
                    actualUpdates.addAll((Collection)recordKeyMappings.get(BaseFileRecordParsingUtils.RecordStatus.UPDATE));
                }
                if (recordKeyMappings.containsKey(BaseFileRecordParsingUtils.RecordStatus.DELETE)) {
                    actualDeletes.addAll((Collection)recordKeyMappings.get(BaseFileRecordParsingUtils.RecordStatus.DELETE));
                }
            }
        });
    }
}

