/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Objects;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.client.model.HoodieInternalRow;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieEmptyRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieSparkRecord;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.model.TestHoodieRecordSerialization$;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001B\u000b\u0017\u0001\u0005BQ\u0001\u000b\u0001\u0005\u0002%Bq\u0001\f\u0001C\u0002\u0013%Q\u0006\u0003\u00049\u0001\u0001\u0006IA\f\u0005\u0006s\u0001!\tA\u000f\u0005\u0006\u0019\u0002!\tA\u000f\u0005\u0006\u001d\u0002!\tA\u000f\u0005\u0006!\u0002!I!U\u0004\u0006OZA\t\u0001\u001b\u0004\u0006+YA\t!\u001b\u0005\u0006Q%!\t!\u001c\u0005\u0006]&!Ia\u001c\u0005\b\u0003+IA\u0011BA\f\u0011\u001d\t)\"\u0003C\u0005\u0003sAq!a\u0012\n\t\u0013\tIE\u0002\u0004\u0002N%\u0001\u0011q\n\u0005\t3>\u0011\t\u0011)A\u00055\"Q\u0011\u0011K\b\u0003\u0002\u0003\u0006I!a\u0015\t\r!zA\u0011AA6\u0011\u001d\tih\u0004C!\u0003\u007fBq!a#\u0010\t\u0003\niIA\u000fUKN$\bj\\8eS\u0016\u0014VmY8sIN+'/[1mSj\fG/[8o\u0015\t9\u0002$A\u0003n_\u0012,GN\u0003\u0002\u001a5\u000511m\\7n_:T!a\u0007\u000f\u0002\t!,H-\u001b\u0006\u0003;y\ta!\u00199bG\",'\"A\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0003CA\u0012'\u001b\u0005!#BA\u0013\u001b\u0003%!Xm\u001d;vi&d7/\u0003\u0002(I\t\u00013\u000b]1sW\u000ec\u0017.\u001a8u\rVt7\r^5p]\u0006dG+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\t!\u0006\u0005\u0002,\u00015\ta#A\u0005s_^\u001c6\r[3nCV\ta\u0006\u0005\u00020m5\t\u0001G\u0003\u00022e\u0005)A/\u001f9fg*\u00111\u0007N\u0001\u0004gFd'BA\u001b\u001d\u0003\u0015\u0019\b/\u0019:l\u0013\t9\u0004G\u0001\u0006TiJ,8\r\u001e+za\u0016\f!B]8x'\u000eDW-\\1!\u0003=!Xm\u001d;Ta\u0006\u00148NU3d_J$G#A\u001e\u0011\u0005qzT\"A\u001f\u000b\u0003y\nQa]2bY\u0006L!\u0001Q\u001f\u0003\tUs\u0017\u000e\u001e\u0015\u0003\t\t\u0003\"a\u0011&\u000e\u0003\u0011S!!\u0012$\u0002\u0007\u0005\u0004\u0018N\u0003\u0002H\u0011\u00069!.\u001e9ji\u0016\u0014(BA%\u001f\u0003\u0015QWO\\5u\u0013\tYEI\u0001\u0003UKN$\u0018a\u0004;fgR\feO]8SK\u000e|'\u000fZ:)\u0005\u0015\u0011\u0015a\u0004;fgR,U\u000e\u001d;z%\u0016\u001cwN\u001d3)\u0005\u0019\u0011\u0015A\u0005;p\u0019\u0016<\u0017mY=BmJ|'+Z2pe\u0012$2A\u0015-c!\rY3+V\u0005\u0003)Z\u0011\u0001\u0003S8pI&,\u0017I\u001e:p%\u0016\u001cwN\u001d3\u0011\u0005-2\u0016BA,\u0017\u0005yye/\u001a:xe&$XmV5uQ2\u000bG/Z:u\u0003Z\u0014x\u000eU1zY>\fG\rC\u0003Z\u000f\u0001\u0007!,\u0001\u0006bmJ|'+Z2pe\u0012\u0004\"a\u00171\u000e\u0003qS!!\u00180\u0002\u000f\u001d,g.\u001a:jG*\u0011q\fH\u0001\u0005CZ\u0014x.\u0003\u0002b9\niq)\u001a8fe&\u001c'+Z2pe\u0012DQaY\u0004A\u0002\u0011\f1a[3z!\tYS-\u0003\u0002g-\tI\u0001j\\8eS\u0016\\U-_\u0001\u001e)\u0016\u001cH\u000fS8pI&,'+Z2pe\u0012\u001cVM]5bY&T\u0018\r^5p]B\u00111&C\n\u0003\u0013)\u0004\"\u0001P6\n\u00051l$AB!osJ+g\rF\u0001i\u00039\u0019Gn\u001c8f+NLgnZ&ss>,\"\u0001]=\u0015\u0007E\f\t\u0002E\u0003=eR\f)!\u0003\u0002t{\t1A+\u001e9mKJ\u00022aK;x\u0013\t1hC\u0001\u0007I_>$\u0017.\u001a*fG>\u0014H\r\u0005\u0002ys2\u0001A!\u0002>\f\u0005\u0004Y(!\u0001+\u0012\u0005q|\bC\u0001\u001f~\u0013\tqXHA\u0004O_RD\u0017N\\4\u0011\u0007q\n\t!C\u0002\u0002\u0004u\u00121!\u00118z!\u0015a\u0014qAA\u0006\u0013\r\tI!\u0010\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004y\u00055\u0011bAA\b{\t!!)\u001f;f\u0011\u0019\t\u0019b\u0003a\u0001i\u0006\t!/A\u0006u_Vs7/\u00194f%><HCBA\r\u0003S\t)\u0004\u0005\u0003\u0002\u001c\u0005\u0015RBAA\u000f\u0015\u0011\ty\"!\t\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0004\u0003G\u0011\u0014\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005\u001d\u0012Q\u0004\u0002\n+:\u001c\u0018MZ3S_^Dq!a\u000b\r\u0001\u0004\ti#A\u0002s_^\u0004B!a\f\u000225\u0011\u0011\u0011E\u0005\u0005\u0003g\t\tCA\u0006J]R,'O\\1m%><\bBBA\u001c\u0019\u0001\u0007a&\u0001\u0004tG\",W.\u0019\u000b\u0007\u00033\tY$!\u0012\t\u000f\u0005-R\u00021\u0001\u0002>A!\u0011qHA!\u001b\u0005\u0011\u0014bAA\"e\t\u0019!k\\<\t\r\u0005]R\u00021\u0001/\u0003M\u0019wN\u001c<feR$v.\u0011<s_J+7m\u001c:e)\rQ\u00161\n\u0005\b\u0003Wq\u0001\u0019AA\u001f\u0005)ze/\u001a:xe&$XmV5uQ2\u000bG/Z:u\u0003Z\u0014x\u000eU1zY>\fGmV5uQ\u0016\u000bX/\u00197jif\u001c\"aD+\u0002\u0019}{'\u000fZ3sS:<g+\u001971\t\u0005U\u0013q\r\t\u0007\u0003/\n\t'!\u001a\u000e\u0005\u0005e#\u0002BA.\u0003;\nA\u0001\\1oO*\u0011\u0011qL\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002d\u0005e#AC\"p[B\f'/\u00192mKB\u0019\u00010a\u001a\u0005\u0015\u0005%\u0014#!A\u0001\u0002\u000b\u00051PA\u0002`IM\"b!!\u001c\u0002r\u0005M\u0004cAA8\u001f5\t\u0011\u0002C\u0003Z%\u0001\u0007!\fC\u0004\u0002RI\u0001\r!!\u001e1\t\u0005]\u00141\u0010\t\u0007\u0003/\n\t'!\u001f\u0011\u0007a\fY\bB\u0006\u0002j\u0005M\u0014\u0011!A\u0001\u0006\u0003Y\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0002\u0006\u001d\u0005c\u0001\u001f\u0002\u0004&\u0019\u0011QQ\u001f\u0003\u000f\t{w\u000e\\3b]\"1\u0011\u0011R\nA\u0002}\f1a\u001c2k\u0003!A\u0017m\u001d5D_\u0012,GCAAH!\ra\u0014\u0011S\u0005\u0004\u0003'k$aA%oi\u0002")
public class TestHoodieRecordSerialization
extends SparkClientFunctionalTestHarness {
    private final StructType rowSchema = StructType$.MODULE$.fromDDL("a INT, b STRING, c DATE, d TIMESTAMP, e STRUCT<a: DECIMAL(3, 2)>");

    private StructType rowSchema() {
        return this.rowSchema;
    }

    @Test
    public void testSparkRecord() {
        Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "test", Date.valueOf(LocalDate.of(2022, 10, 1)), Timestamp.from(Instant.parse("2022-10-01T23:59:59.00Z")), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Decimal$.MODULE$.apply(123L, 3, 2)}))}));
        UnsafeRow unsafeRow = TestHoodieRecordSerialization$.MODULE$.org$apache$hudi$common$model$TestHoodieRecordSerialization$$toUnsafeRow(row, this.rowSchema());
        HoodieInternalRow hoodieInternalRow = new HoodieInternalRow(new UTF8String[5], (InternalRow)unsafeRow, false);
        ((IterableLike)new .colon.colon((Object)new Tuple3((Object)unsafeRow, (Object)this.rowSchema(), (Object)BoxesRunTime.boxToInteger((int)89)), (List)new .colon.colon((Object)new Tuple3((Object)hoodieInternalRow, (Object)HoodieSqlCommonUtils$.MODULE$.addMetaFields(this.rowSchema()), (Object)BoxesRunTime.boxToInteger((int)129)), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TestHoodieRecordSerialization.$anonfun$testSparkRecord$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAvroRecords() {
        GenericRowWithSchema row = new GenericRowWithSchema(new Object[]{BoxesRunTime.boxToInteger((int)1), "test", Date.valueOf(LocalDate.of(2022, 10, 1)), Timestamp.from(Instant.parse("2022-10-01T23:59:59.00Z")), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Decimal$.MODULE$.apply(123L, 3, 2)}))}, this.rowSchema());
        GenericRecord avroRecord = TestHoodieRecordSerialization$.MODULE$.org$apache$hudi$common$model$TestHoodieRecordSerialization$$convertToAvroRecord((Row)row);
        HoodieKey key = new HoodieKey("rec-key", "part-path");
        HoodieAvroRecord<OverwriteWithLatestAvroPayload> legacyRecord = this.toLegacyAvroRecord(avroRecord, key);
        legacyRecord.setIgnoreIndexUpdate(true);
        HoodieAvroIndexedRecord avroIndexedRecord = new HoodieAvroIndexedRecord(key, (IndexedRecord)avroRecord);
        avroIndexedRecord.setIgnoreIndexUpdate(true);
        int expectedLagacyRecordSize = HoodieSparkUtils$.MODULE$.gteqSpark3_4() ? 536 : 530;
        ((IterableLike)new .colon.colon((Object)new Tuple2(legacyRecord, (Object)BoxesRunTime.boxToInteger((int)expectedLagacyRecordSize)), (List)new .colon.colon((Object)new Tuple2((Object)avroIndexedRecord, (Object)BoxesRunTime.boxToInteger((int)391)), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TestHoodieRecordSerialization.$anonfun$testAvroRecords$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testEmptyRecord() {
        HoodieKey key = new HoodieKey("rec-key", "part-path");
        int expectedEmptyRecordSize = HoodieSparkUtils$.MODULE$.gteqSpark3_4() ? 32 : 29;
        ((IterableLike)new .colon.colon((Object)new Tuple2((Object)new HoodieEmptyRecord(key, HoodieOperation.INSERT, (Comparable)Predef$.MODULE$.int2Integer(1), HoodieRecord.HoodieRecordType.AVRO), (Object)BoxesRunTime.boxToInteger((int)expectedEmptyRecordSize)), (List)new .colon.colon((Object)new Tuple2((Object)new HoodieEmptyRecord(key, HoodieOperation.INSERT, (Comparable)Predef$.MODULE$.int2Integer(2), HoodieRecord.HoodieRecordType.SPARK), (Object)BoxesRunTime.boxToInteger((int)expectedEmptyRecordSize)), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TestHoodieRecordSerialization.$anonfun$testEmptyRecord$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private HoodieAvroRecord<OverwriteWithLatestAvroPayload> toLegacyAvroRecord(GenericRecord avroRecord, HoodieKey key) {
        OverwriteWithLatestAvroPayloadWithEquality avroRecordPayload = new OverwriteWithLatestAvroPayloadWithEquality(avroRecord, Predef$.MODULE$.int2Integer(0));
        HoodieAvroRecord legacyRecord = new HoodieAvroRecord(key, (HoodieRecordPayload)avroRecordPayload);
        return legacyRecord;
    }

    private static final void routine$1(InternalRow row, StructType schema, int serializedSize) {
        HoodieSparkRecord hoodieSparkRecord;
        InternalRow internalRow = row;
        if (internalRow instanceof UnsafeRow) {
            UnsafeRow unsafeRow = (UnsafeRow)internalRow;
            hoodieSparkRecord = new HoodieSparkRecord(unsafeRow);
        } else {
            hoodieSparkRecord = new HoodieSparkRecord(row, schema);
        }
        HoodieSparkRecord record = hoodieSparkRecord;
        Tuple2 tuple2 = TestHoodieRecordSerialization$.MODULE$.org$apache$hudi$common$model$TestHoodieRecordSerialization$$cloneUsingKryo(record);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        HoodieRecord cloned = (HoodieRecord)tuple2._1();
        byte[] originalBytes = (byte[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)cloned, (Object)originalBytes);
        HoodieRecord cloned2 = (HoodieRecord)tuple22._1();
        byte[] originalBytes2 = (byte[])tuple22._2();
        Assertions.assertEquals((int)serializedSize, (int)originalBytes2.length);
        InternalRow internalRow2 = row;
        if (internalRow2 instanceof UnsafeRow) {
            Assertions.assertEquals((Object)record, (Object)cloned2);
        } else {
            HoodieSparkRecord convertedRecord = new HoodieSparkRecord(TestHoodieRecordSerialization$.MODULE$.org$apache$hudi$common$model$TestHoodieRecordSerialization$$toUnsafeRow(row, schema));
            Assertions.assertEquals((Object)convertedRecord, (Object)cloned2);
        }
        Tuple2 tuple23 = TestHoodieRecordSerialization$.MODULE$.org$apache$hudi$common$model$TestHoodieRecordSerialization$$cloneUsingKryo(cloned2);
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        byte[] clonedBytes = (byte[])tuple23._2();
        byte[] clonedBytes2 = clonedBytes;
        Assertions.assertEquals((Object)ByteBuffer.wrap(originalBytes2), (Object)ByteBuffer.wrap(clonedBytes2));
    }

    public static final /* synthetic */ void $anonfun$testSparkRecord$1(Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            InternalRow row = (InternalRow)tuple3._1();
            StructType schema = (StructType)tuple3._2();
            int expectedSize = BoxesRunTime.unboxToInt((Object)tuple3._3());
            TestHoodieRecordSerialization.routine$1(row, schema, expectedSize);
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    private static final void routine$2(HoodieRecord record, int expectedSize) {
        Tuple2 tuple2 = TestHoodieRecordSerialization$.MODULE$.org$apache$hudi$common$model$TestHoodieRecordSerialization$$cloneUsingKryo(record);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        HoodieRecord cloned = (HoodieRecord)tuple2._1();
        byte[] originalBytes = (byte[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)cloned, (Object)originalBytes);
        HoodieRecord cloned2 = (HoodieRecord)tuple22._1();
        byte[] originalBytes2 = (byte[])tuple22._2();
        Assertions.assertEquals((int)expectedSize, (int)originalBytes2.length);
        Assertions.assertEquals((Object)record, (Object)cloned2);
        Tuple2 tuple23 = TestHoodieRecordSerialization$.MODULE$.org$apache$hudi$common$model$TestHoodieRecordSerialization$$cloneUsingKryo(cloned2);
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        byte[] clonedBytes = (byte[])tuple23._2();
        byte[] clonedBytes2 = clonedBytes;
        Assertions.assertEquals((Object)ByteBuffer.wrap(originalBytes2), (Object)ByteBuffer.wrap(clonedBytes2));
    }

    public static final /* synthetic */ void $anonfun$testAvroRecords$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            HoodieRecord record = (HoodieRecord)tuple2._1();
            int expectedSize = tuple2._2$mcI$sp();
            TestHoodieRecordSerialization.routine$2(record, expectedSize);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final void routine$3(HoodieRecord record, int expectedSize) {
        Tuple2 tuple2 = TestHoodieRecordSerialization$.MODULE$.org$apache$hudi$common$model$TestHoodieRecordSerialization$$cloneUsingKryo(record);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        HoodieRecord cloned = (HoodieRecord)tuple2._1();
        byte[] originalBytes = (byte[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)cloned, (Object)originalBytes);
        HoodieRecord cloned2 = (HoodieRecord)tuple22._1();
        byte[] originalBytes2 = (byte[])tuple22._2();
        Assertions.assertEquals((int)expectedSize, (int)originalBytes2.length);
        Assertions.assertEquals((Object)record, (Object)cloned2);
        Tuple2 tuple23 = TestHoodieRecordSerialization$.MODULE$.org$apache$hudi$common$model$TestHoodieRecordSerialization$$cloneUsingKryo(cloned2);
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        byte[] clonedBytes = (byte[])tuple23._2();
        byte[] clonedBytes2 = clonedBytes;
        Assertions.assertEquals((Object)ByteBuffer.wrap(originalBytes2), (Object)ByteBuffer.wrap(clonedBytes2));
    }

    public static final /* synthetic */ void $anonfun$testEmptyRecord$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            HoodieEmptyRecord record = (HoodieEmptyRecord)tuple2._1();
            int expectedSize = tuple2._2$mcI$sp();
            TestHoodieRecordSerialization.routine$3((HoodieRecord)record, expectedSize);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static class OverwriteWithLatestAvroPayloadWithEquality
    extends OverwriteWithLatestAvroPayload {
        private final GenericRecord avroRecord;
        private final Comparable<?> _orderingVal;

        public boolean equals(Object obj) {
            Object object = obj;
            if (object instanceof OverwriteWithLatestAvroPayloadWithEquality) {
                OverwriteWithLatestAvroPayloadWithEquality overwriteWithLatestAvroPayloadWithEquality = (OverwriteWithLatestAvroPayloadWithEquality)((Object)object);
                return Objects.equals(ByteBuffer.wrap(this.recordBytes), ByteBuffer.wrap(overwriteWithLatestAvroPayloadWithEquality.recordBytes)) && Objects.equals(this.orderingVal, overwriteWithLatestAvroPayloadWithEquality.orderingVal);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.avroRecord, this._orderingVal);
        }

        public OverwriteWithLatestAvroPayloadWithEquality(GenericRecord avroRecord, Comparable<?> _orderingVal) {
            this.avroRecord = avroRecord;
            this._orderingVal = _orderingVal;
            super(avroRecord, _orderingVal);
        }
    }
}

