/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.SparkFileFormatInternalRowReaderContext;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.read.CustomPayloadForTesting;
import org.apache.hudi.common.table.read.TestHoodieFileGroupReaderBase;
import org.apache.hudi.common.table.read.TestHoodieFileGroupReaderOnSpark$;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.spark.HoodieSparkKryoRegistrar$;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.HoodieInternalRowUtils$;
import org.apache.spark.sql.HoodieUnsafeUtils$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.execution.datasources.parquet.SparkParquetReader;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tMd\u0001\u0002\u000e\u001c\u0001!BQa\u000f\u0001\u0005\u0002qB\u0011\u0002\u000e\u0001A\u0002\u0003\u0007I\u0011\u0001 \t\u0013\r\u0003\u0001\u0019!a\u0001\n\u0003!\u0005\"C'\u0001\u0001\u0004\u0005\t\u0015)\u0003@\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u0015Y\u0006\u0001\"\u0001P\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u0015!\b\u0001\"\u0011v\u0011\u001d\t\u0019\u0001\u0001C!\u0003\u000bAq!!\u000e\u0001\t\u0003\n9\u0004C\u0004\u0002p\u0001!\t%!\u001d\t\r\u0005U\u0005\u0001\"\u0011v\u0011\u001d\t9\n\u0001C!\u00033Ca!!*\u0001\t\u0003y\u0005\"CAX\u0001\t\u0007I\u0011AAY\u0011!\t9\u000e\u0001Q\u0001\n\u0005M\u0006\"CAm\u0001\t\u0007I\u0011AAY\u0011!\tY\u000e\u0001Q\u0001\n\u0005M\u0006bBAo\u0001\u0011\u0005\u0011q\u001c\u0005\b\u0003K\u0003A\u0011\u0002B\u000b\u000f\u001d\u0011id\u0007E\u0001\u0005\u007f1aAG\u000e\t\u0002\t\u0005\u0003BB\u001e\u0017\t\u0003\u0011I\u0005C\u0004\u0003\nY!\tAa\u0013\t\u000f\tUc\u0003\"\u0001\u0003X\t\u0001C+Z:u\u0011>|G-[3GS2,wI]8vaJ+\u0017\rZ3s\u001f:\u001c\u0006/\u0019:l\u0015\taR$\u0001\u0003sK\u0006$'B\u0001\u0010 \u0003\u0015!\u0018M\u00197f\u0015\t\u0001\u0013%\u0001\u0004d_6lwN\u001c\u0006\u0003E\r\nA\u0001[;eS*\u0011A%J\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\n1a\u001c:h\u0007\u0001\u00192\u0001A\u00158!\rQ3&L\u0007\u00027%\u0011Af\u0007\u0002\u001e)\u0016\u001cH\u000fS8pI&,g)\u001b7f\u000fJ|W\u000f\u001d*fC\u0012,'OQ1tKB\u0011a&N\u0007\u0002_)\u0011\u0001'M\u0001\tG\u0006$\u0018\r\\=ti*\u0011!gM\u0001\u0004gFd'B\u0001\u001b$\u0003\u0015\u0019\b/\u0019:l\u0013\t1tFA\u0006J]R,'O\\1m%><\bC\u0001\u001d:\u001b\u0005\t\u0013B\u0001\u001e\"\u0005M\u0019\u0006/\u0019:l\u0003\u0012\f\u0007\u000f^3s'V\u0004\bo\u001c:u\u0003\u0019a\u0014N\\5u}Q\tQ\b\u0005\u0002+\u0001U\tq\b\u0005\u0002A\u00036\t\u0011'\u0003\u0002Cc\ta1\u000b]1sWN+7o]5p]\u0006I1\u000f]1sW~#S-\u001d\u000b\u0003\u000b.\u0003\"AR%\u000e\u0003\u001dS\u0011\u0001S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0015\u001e\u0013A!\u00168ji\"9AjAA\u0001\u0002\u0004y\u0014a\u0001=%c\u000511\u000f]1sW\u0002\nQa]3ukB$\u0012!\u0012\u0015\u0003\u000bE\u0003\"AU-\u000e\u0003MS!\u0001V+\u0002\u0007\u0005\u0004\u0018N\u0003\u0002W/\u00069!.\u001e9ji\u0016\u0014(B\u0001-&\u0003\u0015QWO\\5u\u0013\tQ6K\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012|wO\u001c\u0015\u0003\ru\u0003\"A\u00150\n\u0005}\u001b&!C!gi\u0016\u0014X)Y2i\u000399W\r^*u_J\fw-Z\"p]\u001a$\u0012A\u0019\u0019\u0003G.\u00042\u0001Z4j\u001b\u0005)'B\u00014\"\u0003\u001d\u0019Ho\u001c:bO\u0016L!\u0001[3\u0003)M#xN]1hK\u000e{gNZ5hkJ\fG/[8o!\tQ7\u000e\u0004\u0001\u0005\u00131<\u0011\u0011!A\u0001\u0006\u0003i'aA0%cE\u0011a.\u001d\t\u0003\r>L!\u0001]$\u0003\u000f9{G\u000f[5oOB\u0011aI]\u0005\u0003g\u001e\u00131!\u00118z\u0003-9W\r\u001e\"bg\u0016\u0004\u0016\r\u001e5\u0015\u0003Y\u0004\"a\u001e@\u000f\u0005ad\bCA=H\u001b\u0005Q(BA>(\u0003\u0019a$o\\8u}%\u0011QpR\u0001\u0007!J,G-\u001a4\n\u0007}\f\tA\u0001\u0004TiJLgn\u001a\u0006\u0003{\u001e\u000bacZ3u\u0011>|G-[3SK\u0006$WM]\"p]R,\u0007\u0010\u001e\u000b\t\u0003\u000f\t\u0019\"a\u0006\u0002(A)\u0011\u0011BA\b[5\u0011\u00111\u0002\u0006\u0004\u0003\u001by\u0012AB3oO&tW-\u0003\u0003\u0002\u0012\u0005-!a\u0005%p_\u0012LWMU3bI\u0016\u00148i\u001c8uKb$\bBBA\u000b\u0013\u0001\u0007a/A\u0005uC\ndW\rU1uQ\"9\u0011\u0011D\u0005A\u0002\u0005m\u0011AC1we>\u001c6\r[3nCB!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"\r\nA!\u0019<s_&!\u0011QEA\u0010\u0005\u0019\u00196\r[3nC\"9\u0011\u0011F\u0005A\u0002\u0005-\u0012aC:u_J\fw-Z\"p]\u001a\u0004D!!\f\u00022A!AmZA\u0018!\rQ\u0017\u0011\u0007\u0003\f\u0003g\t9#!A\u0001\u0002\u000b\u0005QNA\u0002`II\nQbY8n[&$Hk\u001c+bE2,GcB#\u0002:\u0005\u0005\u0014Q\r\u0005\b\u0003wQ\u0001\u0019AA\u001f\u0003)\u0011XmY8sI2K7\u000f\u001e\t\u0007\u0003\u007f\tI%!\u0014\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\nA!\u001e;jY*\u0011\u0011qI\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002L\u0005\u0005#\u0001\u0002'jgR\u0004D!a\u0014\u0002^A1\u0011\u0011KA,\u00037j!!a\u0015\u000b\u0007\u0005Us$A\u0003n_\u0012,G.\u0003\u0003\u0002Z\u0005M#\u0001\u0004%p_\u0012LWMU3d_J$\u0007c\u00016\u0002^\u0011Y\u0011qLA\u001d\u0003\u0003\u0005\tQ!\u0001n\u0005\ryFe\r\u0005\u0007\u0003GR\u0001\u0019\u0001<\u0002\u0013=\u0004XM]1uS>t\u0007bBA4\u0015\u0001\u0007\u0011\u0011N\u0001\b_B$\u0018n\u001c8t!\u0019\ty$a\u001bwm&!\u0011QNA!\u0005\ri\u0015\r]\u0001\u001bm\u0006d\u0017\u000eZ1uKJ+7m\u001c:eg&sg)\u001b7f\u000fJ|W\u000f\u001d\u000b\f\u000b\u0006M\u0014qOA?\u0003\u0003\u000bY\t\u0003\u0004\u0002v-\u0001\rA^\u0001\tE\u0006\u001cX\rU1uQ\"9\u0011\u0011P\u0006A\u0002\u0005m\u0014\u0001E1diV\fGNU3d_J$G*[:u!\u0015\ty$!\u0013.\u0011\u001d\tyh\u0003a\u0001\u00037\taa]2iK6\f\u0007bBAB\u0017\u0001\u0007\u0011QQ\u0001\nM&dWm\u00157jG\u0016\u0004B!!\u0015\u0002\b&!\u0011\u0011RA*\u0005%1\u0015\u000e\\3TY&\u001cW\rC\u0004\u0002\u000e.\u0001\r!a$\u0002\u0017%\u001c8k[5q\u001b\u0016\u0014x-\u001a\t\u0004\r\u0006E\u0015bAAJ\u000f\n9!i\\8mK\u0006t\u0017\u0001E4fi\u000e+8\u000f^8n!\u0006LHn\\1e\u0003I\t7o]3siJ+7m\u001c:eg\u0016\u000bX/\u00197\u0015\u000f\u0015\u000bY*!(\u0002\"\"9\u0011qP\u0007A\u0002\u0005m\u0001BBAP\u001b\u0001\u0007Q&\u0001\u0005fqB,7\r^3e\u0011\u0019\t\u0019+\u0004a\u0001[\u00051\u0011m\u0019;vC2\fA\u0003^3ti\u001e+Go\u0014:eKJLgn\u001a,bYV,\u0007f\u0001\b\u0002*B\u0019!+a+\n\u0007\u000556K\u0001\u0003UKN$\u0018AF3ya\u0016\u001cG/\u001a3Fm\u0016tG\u000fV5nK\n\u000b7/\u001a3\u0016\u0005\u0005M\u0006CBA[\u0003\u007f\u000b)M\u0004\u0003\u00028\u0006mfbA=\u0002:&\t\u0001*C\u0002\u0002>\u001e\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002B\u0006\r'aA*fc*\u0019\u0011QX$\u0011\u0017\u0019\u000b9-a3wmZ\f\tN^\u0005\u0004\u0003\u0013<%A\u0002+va2,g\u0007E\u0002G\u0003\u001bL1!a4H\u0005\rIe\u000e\u001e\t\u0004\r\u0006M\u0017bAAk\u000f\n1Ai\\;cY\u0016\fq#\u001a=qK\u000e$X\rZ#wK:$H+[7f\u0005\u0006\u001cX\r\u001a\u0011\u0002/\u0015D\b/Z2uK\u0012\u001cu.\\7jiRKW.\u001a\"bg\u0016$\u0017\u0001G3ya\u0016\u001cG/\u001a3D_6l\u0017\u000e\u001e+j[\u0016\u0014\u0015m]3eA\u0005\u0001B/Z:u\u0007V\u001cHo\\7EK2,G/\u001a\u000b\n\u000b\u0006\u0005\u0018Q]Au\u0003[Da!a9\u0014\u0001\u00041\u0018aC;tK\u001a;'+Z1eKJDa!a:\u0014\u0001\u00041\u0018!\u0003;bE2,G+\u001f9f\u0011\u0019\tYo\u0005a\u0001m\u0006a\u0001o\\:ji&|g.V:fI\"1\u0011q^\nA\u0002Y\f\u0011\"\\3sO\u0016lu\u000eZ3)\u000fM\t\u0019Pa\u0001\u0003\u0006A!\u0011Q_A\u0000\u001b\t\t9P\u0003\u0003\u0002z\u0006m\u0018\u0001\u00039s_ZLG-\u001a:\u000b\u0007\u0005uX+\u0001\u0004qCJ\fWn]\u0005\u0005\u0005\u0003\t9P\u0001\u0007NKRDw\u000eZ*pkJ\u001cW-A\u0003wC2,X\r\f\u0002\u0003\b\u0005\u0012!\u0011B\u0001\u0017GV\u001cHo\\7EK2,G/\u001a+fgR\u0004\u0016M]1ng\"\u001a1C!\u0004\u0011\t\t=!\u0011C\u0007\u0003\u0003wLAAa\u0005\u0002|\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0015\u0017\u0015\u00139Ba\u0007\u0003 \t\u0005\"Q\u0005\u0005\b\u00053!\u0002\u0019AA\u0004\u0003I\u0019\b/\u0019:l%\u0016\fG-\u001a:D_:$X\r\u001f;\t\r\tuA\u00031\u0001.\u0003\r\u0011xn\u001e\u0005\b\u00033!\u0002\u0019AA\u000e\u0011\u0019\u0011\u0019\u0003\u0006a\u0001m\u0006qqN\u001d3fe&twmQ8mk6t\u0007b\u0002B\u0014)\u0001\u0007!\u0011F\u0001\u0016Kb\u0004Xm\u0019;fI>\u0013H-\u001a:j]\u001e4\u0016\r\\;fa\u0011\u0011YC!\u000f\u0011\r\t5\"1\u0007B\u001c\u001b\t\u0011yC\u0003\u0003\u00032\u0005\u0015\u0013\u0001\u00027b]\u001eLAA!\u000e\u00030\tQ1i\\7qCJ\f'\r\\3\u0011\u0007)\u0014I\u0004B\u0006\u0003<\t\u0015\u0012\u0011!A\u0001\u0006\u0003i'aA0%i\u0005\u0001C+Z:u\u0011>|G-[3GS2,wI]8vaJ+\u0017\rZ3s\u001f:\u001c\u0006/\u0019:l!\tQccE\u0002\u0017\u0005\u0007\u00022A\u0012B#\u0013\r\u00119e\u0012\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t}BC\u0001B'!\u0019\ty$!\u0013\u0003PA!\u0011Q\u001fB)\u0013\u0011\u0011\u0019&a>\u0003\u0013\u0005\u0013x-^7f]R\u001c\u0018\u0001D4fi\u001aKG.Z\"pk:$HC\u0002B-\u0005K\u0012\t\bE\u0004G\u00057\u0012yFa\u0018\n\u0007\tusI\u0001\u0004UkBdWM\r\t\u0004\r\n\u0005\u0014b\u0001B2\u000f\n!Aj\u001c8h\u0011\u001d\u00119'\u0007a\u0001\u0005S\n!\"\\3uC\u000ec\u0017.\u001a8u!\u0011\u0011YG!\u001c\u000e\u0003uI1Aa\u001c\u001e\u0005UAun\u001c3jKR\u000b'\r\\3NKR\f7\t\\5f]RDa!!\u001e\u001a\u0001\u00041\b")
public class TestHoodieFileGroupReaderOnSpark
extends TestHoodieFileGroupReaderBase<InternalRow>
implements SparkAdapterSupport {
    private SparkSession spark;
    private final Seq<Tuple6<Object, String, String, String, Object, String>> expectedEventTimeBased;
    private final Seq<Tuple6<Object, String, String, String, Object, String>> expectedCommitTimeBased;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    public static Tuple2<Object, Object> getFileCount(HoodieTableMetaClient hoodieTableMetaClient, String string) {
        return TestHoodieFileGroupReaderOnSpark$.MODULE$.getFileCount(hoodieTableMetaClient, string);
    }

    public static java.util.List<Arguments> customDeleteTestParams() {
        return TestHoodieFileGroupReaderOnSpark$.MODULE$.customDeleteTestParams();
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        TestHoodieFileGroupReaderOnSpark testHoodieFileGroupReaderOnSpark = this;
        synchronized (testHoodieFileGroupReaderOnSpark) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$((SparkAdapterSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    public SparkAdapter sparkAdapter() {
        if (!this.bitmap$0) {
            return this.sparkAdapter$lzycompute();
        }
        return this.sparkAdapter;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @BeforeEach
    public void setup() {
        SparkConf sparkConf = new SparkConf();
        sparkConf.set("spark.app.name", this.getClass().getName());
        sparkConf.set("spark.master", "local[8]");
        sparkConf.set("spark.default.parallelism", "4");
        sparkConf.set("spark.sql.shuffle.partitions", "4");
        sparkConf.set("spark.driver.maxResultSize", "2g");
        sparkConf.set("spark.hadoop.mapred.output.compress", "true");
        sparkConf.set("spark.hadoop.mapred.output.compression.codec", "true");
        sparkConf.set("spark.hadoop.mapred.output.compression.codec", "org.apache.hadoop.io.compress.GzipCodec");
        sparkConf.set("spark.hadoop.mapred.output.compression.type", "BLOCK");
        sparkConf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        sparkConf.set("spark.kryo.registrator", "org.apache.spark.HoodieSparkKryoRegistrar");
        sparkConf.set("spark.sql.extensions", "org.apache.spark.sql.hudi.HoodieSparkSessionExtension");
        sparkConf.set("spark.sql.parquet.enableVectorizedReader", "false");
        HoodieSparkKryoRegistrar$.MODULE$.register(sparkConf);
        this.spark_$eq(SparkSession$.MODULE$.builder().config(sparkConf).getOrCreate());
    }

    @AfterEach
    public void teardown() {
        if (this.spark() != null) {
            this.spark().stop();
            return;
        }
    }

    public StorageConfiguration<?> getStorageConf() {
        return HoodieTestUtils.getDefaultStorageConf().getInline();
    }

    public String getBasePath() {
        return this.tempDir.toAbsolutePath().toUri().toString();
    }

    public HoodieReaderContext<InternalRow> getHoodieReaderContext(String tablePath, Schema avroSchema, StorageConfiguration<?> storageConf) {
        SparkParquetReader reader = this.sparkAdapter().createParquetFileReader(false, this.spark().sessionState().conf(), Predef$.MODULE$.Map().empty(), (Configuration)storageConf.unwrapAs(Configuration.class));
        return new SparkFileFormatInternalRowReaderContext(reader, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$);
    }

    public void commitToTable(java.util.List<HoodieRecord<?>> recordList, String operation, java.util.Map<String, String> options) {
        java.util.List recs = RawTripTestPayload.recordsToStrings(recordList);
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(recs).asScala()).toList(), 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF.write().format("hudi").options(options).option("hoodie.compact.inline", "false").option("hoodie.datasource.write.operation", operation).option("hoodie.datasource.write.table.type", "MERGE_ON_READ").mode(operation.equalsIgnoreCase(WriteOperationType.INSERT.value()) ? SaveMode.Overwrite : SaveMode.Append).save(this.getBasePath());
    }

    public void validateRecordsInFileGroup(String basePath, java.util.List<InternalRow> actualRecordList, Schema schema, FileSlice fileSlice, boolean isSkipMerge) {
        if (!isSkipMerge || fileSlice.getLogFiles().count() < 2L) {
            Dataset expectedDf = this.spark().read().format("hudi").option(HoodieReaderConfig.FILE_GROUP_READER_ENABLED.key(), "false").option(HoodieReaderConfig.MERGE_TYPE.key(), isSkipMerge ? "skip_merge" : "payload_combine").load(basePath).where(functions$.MODULE$.col(HoodieRecord.FILENAME_METADATA_FIELD).contains((Object)fileSlice.getFileId()));
            Assertions.assertEquals((long)expectedDf.count(), (long)actualRecordList.size());
            Dataset actualDf = HoodieUnsafeUtils$.MODULE$.createDataFrameFromInternalRows(this.spark(), ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(actualRecordList).asScala()).toSeq(), HoodieInternalRowUtils$.MODULE$.getCachedSchema(schema));
            Assertions.assertEquals((long)0L, (long)expectedDf.except(actualDf).count());
            Assertions.assertEquals((long)0L, (long)actualDf.except(expectedDf).count());
            return;
        }
    }

    public String getCustomPayload() {
        return CustomPayloadForTesting.class.getName();
    }

    public void assertRecordsEqual(Schema schema, InternalRow expected, InternalRow actual) {
        Assertions.assertEquals((int)expected.numFields(), (int)actual.numFields());
        StructType expectedStruct = (StructType)this.sparkAdapter().getAvroSchemaConverters().toSqlType(schema)._1();
        ((IterableLike)expected.toSeq(expectedStruct).zip((GenIterable)actual.toSeq(expectedStruct), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)converted -> {
            TestHoodieFileGroupReaderOnSpark.$anonfun$assertRecordsEqual$1(converted);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetOrderingValue() {
        SparkParquetReader reader = (SparkParquetReader)Mockito.mock(SparkParquetReader.class);
        SparkFileFormatInternalRowReaderContext sparkReaderContext = new SparkFileFormatInternalRowReaderContext(reader, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$);
        String orderingFieldName = "col2";
        Schema avroSchema = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"test\",\"namespace\": \"org.apache.hudi\",\"fields\": [{\"name\": \"col1\", \"type\": \"string\" },{\"name\": \"col2\", \"type\": \"long\" },{ \"name\": \"col3\", \"type\": [\"null\", \"string\"], \"default\": null}]}");
        InternalRow row = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"item", BoxesRunTime.boxToLong((long)1000L), "blue"}));
        this.testGetOrderingValue((HoodieReaderContext<InternalRow>)sparkReaderContext, row, avroSchema, orderingFieldName, Predef$.MODULE$.long2Long(1000L));
        this.testGetOrderingValue((HoodieReaderContext<InternalRow>)sparkReaderContext, row, avroSchema, "col3", (Comparable<?>)UTF8String.fromString((String)"blue"));
        this.testGetOrderingValue((HoodieReaderContext<InternalRow>)sparkReaderContext, row, avroSchema, "non_existent_col", Predef$.MODULE$.int2Integer(0));
    }

    public Seq<Tuple6<Object, String, String, String, Object, String>> expectedEventTimeBased() {
        return this.expectedEventTimeBased;
    }

    public Seq<Tuple6<Object, String, String, String, Object, String>> expectedCommitTimeBased() {
        return this.expectedCommitTimeBased;
    }

    @ParameterizedTest
    @MethodSource(value={"customDeleteTestParams"})
    public void testCustomDelete(String useFgReader, String tableType, String positionUsed, String mergeMode) {
        scala.collection.immutable.Map readOpts;
        String payloadClass = "org.apache.hudi.common.table.read.CustomPayloadForTesting";
        scala.collection.immutable.Map fgReaderOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT.key()), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieReaderConfig.FILE_GROUP_READER_ENABLED.key()), (Object)useFgReader), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieReaderConfig.MERGE_USE_RECORD_POSITIONS.key()), (Object)positionUsed), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.RECORD_MERGE_MODE.key()), (Object)mergeMode)}));
        scala.collection.immutable.Map deleteOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.payload.delete.field"), (Object)"op"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.payload.delete.marker"), (Object)"d")}));
        scala.collection.immutable.Map opts = readOpts = mergeMode.equals("CUSTOM") ? fgReaderOpts.$plus$plus((GenTraversableOnce)deleteOpts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.WRITE_PAYLOAD_CLASS_NAME.key()), (Object)payloadClass)}))) : fgReaderOpts.$plus$plus((GenTraversableOnce)deleteOpts);
        Seq columns = (Seq)new .colon.colon((Object)"ts", (List)new .colon.colon((Object)"key", (List)new .colon.colon((Object)"rider", (List)new .colon.colon((Object)"driver", (List)new .colon.colon((Object)"fare", (List)new .colon.colon((Object)"op", (List)Nil$.MODULE$))))));
        Seq data = (Seq)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)10), (Object)"1", (Object)"rider-A", (Object)"driver-A", (Object)BoxesRunTime.boxToDouble((double)19.1), (Object)"i"), (List)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)10), (Object)"2", (Object)"rider-B", (Object)"driver-B", (Object)BoxesRunTime.boxToDouble((double)27.7), (Object)"i"), (List)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)10), (Object)"3", (Object)"rider-C", (Object)"driver-C", (Object)BoxesRunTime.boxToDouble((double)33.9), (Object)"i"), (List)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)10), (Object)"4", (Object)"rider-D", (Object)"driver-D", (Object)BoxesRunTime.boxToDouble((double)34.15), (Object)"i"), (List)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)10), (Object)"5", (Object)"rider-E", (Object)"driver-E", (Object)BoxesRunTime.boxToDouble((double)17.85), (Object)"i"), (List)Nil$.MODULE$)))));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestHoodieFileGroupReaderOnSpark.class.getClassLoader());
        public final class Org_apache_hudi_common_table_read_TestHoodieFileGroupReaderOnSpark$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple6"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)))))));
            }

            public Org_apache_hudi_common_table_read_TestHoodieFileGroupReaderOnSpark$$typecreator1$1(TestHoodieFileGroupReaderOnSpark $outer) {
            }
        }
        Dataset inserts = this.spark().createDataFrame(data, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_common_table_read_TestHoodieFileGroupReaderOnSpark$$typecreator1$1(null))).toDF(columns);
        inserts.write().format("hudi").option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "key").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), tableType).option(DataSourceWriteOptions$.MODULE$.TABLE_NAME().key(), "test_table").option(HoodieCompactionConfig.INLINE_COMPACT.key(), "false").options((Map)opts).mode(SaveMode.Overwrite).save(this.getBasePath());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.getStorageConf()).setBasePath(this.getBasePath()).build();
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 0), TestHoodieFileGroupReaderOnSpark$.MODULE$.getFileCount(metaClient, this.getBasePath()));
        Seq updateData = (Seq)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)11), (Object)"1", (Object)"rider-X", (Object)"driver-X", (Object)BoxesRunTime.boxToDouble((double)19.1), (Object)"d"), (List)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)9), (Object)"2", (Object)"rider-Y", (Object)"driver-Y", (Object)BoxesRunTime.boxToDouble((double)27.7), (Object)"d"), (List)Nil$.MODULE$));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(TestHoodieFileGroupReaderOnSpark.class.getClassLoader());
        public final class Org_apache_hudi_common_table_read_TestHoodieFileGroupReaderOnSpark$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple6"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)))))));
            }

            public Org_apache_hudi_common_table_read_TestHoodieFileGroupReaderOnSpark$$typecreator2$1(TestHoodieFileGroupReaderOnSpark $outer) {
            }
        }
        Dataset updates = this.spark().createDataFrame(updateData, ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_common_table_read_TestHoodieFileGroupReaderOnSpark$$typecreator2$1(null))).toDF(columns);
        updates.write().format("hudi").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), "upsert").option(HoodieCompactionConfig.INLINE_COMPACT.key(), "false").options((Map)opts).mode(SaveMode.Append).save(this.getBasePath());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 1), TestHoodieFileGroupReaderOnSpark$.MODULE$.getFileCount(metaClient, this.getBasePath()));
        Seq deletesData = (Seq)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)-5), (Object)"4", (Object)"rider-D", (Object)"driver-D", (Object)BoxesRunTime.boxToDouble((double)34.15), (Object)BoxesRunTime.boxToInteger((int)6)), (List)Nil$.MODULE$);
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(TestHoodieFileGroupReaderOnSpark.class.getClassLoader());
        public final class Org_apache_hudi_common_table_read_TestHoodieFileGroupReaderOnSpark$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple6"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))))));
            }

            public Org_apache_hudi_common_table_read_TestHoodieFileGroupReaderOnSpark$$typecreator3$1(TestHoodieFileGroupReaderOnSpark $outer) {
            }
        }
        Dataset deletes = this.spark().createDataFrame(deletesData, ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_hudi_common_table_read_TestHoodieFileGroupReaderOnSpark$$typecreator3$1(null))).toDF(columns);
        deletes.write().format("hudi").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), "DELETE").option(HoodieCompactionConfig.INLINE_COMPACT.key(), "false").options((Map)opts).mode(SaveMode.Append).save(this.getBasePath());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 2), TestHoodieFileGroupReaderOnSpark$.MODULE$.getFileCount(metaClient, this.getBasePath()));
        Seq updateDataSecond = (Seq)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)20), (Object)"1", (Object)"rider-Z", (Object)"driver-Z", (Object)BoxesRunTime.boxToDouble((double)27.7), (Object)"i"), (List)Nil$.MODULE$);
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(TestHoodieFileGroupReaderOnSpark.class.getClassLoader());
        public final class Org_apache_hudi_common_table_read_TestHoodieFileGroupReaderOnSpark$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple6"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)))))));
            }

            public Org_apache_hudi_common_table_read_TestHoodieFileGroupReaderOnSpark$$typecreator4$1(TestHoodieFileGroupReaderOnSpark $outer) {
            }
        }
        Dataset updatesSecond = this.spark().createDataFrame(updateDataSecond, ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_hudi_common_table_read_TestHoodieFileGroupReaderOnSpark$$typecreator4$1(null))).toDF(columns);
        updatesSecond.write().format("hudi").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), "upsert").option(HoodieCompactionConfig.INLINE_COMPACT.key(), "false").options((Map)opts).mode(SaveMode.Append).save(this.getBasePath());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 3), TestHoodieFileGroupReaderOnSpark$.MODULE$.getFileCount(metaClient, this.getBasePath()));
        scala.collection.immutable.Set columnsToCompare = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ts", "key", "rider", "driver", "fare", "op"}));
        Dataset df = this.spark().read().options((Map)readOpts).format("hudi").load(this.getBasePath());
        Dataset finalDf = df.select("ts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", "rider", "driver", "fare", "op"})).sort("key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        String string = mergeMode;
        String string2 = RecordMergeMode.COMMIT_TIME_ORDERING.name();
        Seq<Tuple6<Object, String, String, String, Object, String>> expected = (string == null ? string2 != null : !string.equals(string2)) ? this.expectedEventTimeBased() : this.expectedCommitTimeBased();
        JavaUniverse $u5 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(TestHoodieFileGroupReaderOnSpark.class.getClassLoader());
        public final class Org_apache_hudi_common_table_read_TestHoodieFileGroupReaderOnSpark$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple6"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)))))));
            }

            public Org_apache_hudi_common_table_read_TestHoodieFileGroupReaderOnSpark$$typecreator5$1(TestHoodieFileGroupReaderOnSpark $outer) {
            }
        }
        Dataset expectedDf = this.spark().createDataFrame(expected, ((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_apache_hudi_common_table_read_TestHoodieFileGroupReaderOnSpark$$typecreator5$1(null))).toDF(columns).sort("key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        Assertions.assertTrue((boolean)SparkClientFunctionalTestHarness.areDataframesEqual((Dataset)expectedDf, (Dataset)finalDf, (java.util.Set)((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)columnsToCompare).asJava())));
    }

    private void testGetOrderingValue(HoodieReaderContext<InternalRow> sparkReaderContext, InternalRow row, Schema avroSchema, String orderingColumn, Comparable<?> expectedOrderingValue) {
        Assertions.assertEquals(expectedOrderingValue, (Object)sparkReaderContext.getOrderingValue((Object)row, avroSchema, Option.of((Object)orderingColumn)));
    }

    public static final /* synthetic */ void $anonfun$assertRecordsEqual$1(Tuple2 converted) {
        Assertions.assertEquals((Object)converted._1(), (Object)converted._2());
    }

    public TestHoodieFileGroupReaderOnSpark() {
        SparkAdapterSupport.$init$((SparkAdapterSupport)this);
        this.expectedEventTimeBased = (Seq)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)10), (Object)"5", (Object)"rider-E", (Object)"driver-E", (Object)BoxesRunTime.boxToDouble((double)17.85), (Object)"i"), (List)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)10), (Object)"3", (Object)"rider-C", (Object)"driver-C", (Object)BoxesRunTime.boxToDouble((double)33.9), (Object)"i"), (List)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)10), (Object)"2", (Object)"rider-B", (Object)"driver-B", (Object)BoxesRunTime.boxToDouble((double)27.7), (Object)"i"), (List)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)20), (Object)"1", (Object)"rider-Z", (Object)"driver-Z", (Object)BoxesRunTime.boxToDouble((double)27.7), (Object)"i"), (List)Nil$.MODULE$))));
        this.expectedCommitTimeBased = (Seq)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)10), (Object)"5", (Object)"rider-E", (Object)"driver-E", (Object)BoxesRunTime.boxToDouble((double)17.85), (Object)"i"), (List)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)10), (Object)"3", (Object)"rider-C", (Object)"driver-C", (Object)BoxesRunTime.boxToDouble((double)33.9), (Object)"i"), (List)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)20), (Object)"1", (Object)"rider-Z", (Object)"driver-Z", (Object)BoxesRunTime.boxToDouble((double)27.7), (Object)"i"), (List)Nil$.MODULE$)));
    }
}

