/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hudi.ColumnStatsIndexSupport$;
import org.apache.hudi.avro.model.DecimalWrapper;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.functional.ColumnStatIndexTestBase;
import org.junit.jupiter.params.provider.Arguments;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.ArrayOps;
import scala.math.BigDecimal$;
import scala.reflect.ClassTag$;

public final class ColumnStatIndexTestBase$ {
    public static ColumnStatIndexTestBase$ MODULE$;

    static {
        new ColumnStatIndexTestBase$();
    }

    public Stream<Arguments> testMetadataColumnStatsIndexParams() {
        return Stream.of((Object[])((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])HoodieTableType.values())).toStream().flatMap((Function1 & Serializable & scala.Serializable)tableType -> (Seq)new .colon.colon((Object)Arguments.arguments((Object[])new Object[]{new ColumnStatIndexTestBase.ColumnStatsTestCase((HoodieTableType)tableType, true, 6)}), (List)new .colon.colon((Object)Arguments.arguments((Object[])new Object[]{new ColumnStatIndexTestBase.ColumnStatsTestCase((HoodieTableType)tableType, false, 6)}), (List)new .colon.colon((Object)Arguments.arguments((Object[])new Object[]{new ColumnStatIndexTestBase.ColumnStatsTestCase((HoodieTableType)tableType, true, 8)}), (List)new .colon.colon((Object)Arguments.arguments((Object[])new Object[]{new ColumnStatIndexTestBase.ColumnStatsTestCase((HoodieTableType)tableType, false, 8)}), (List)Nil$.MODULE$)))), Stream$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Arguments.class)));
    }

    public Stream<Arguments> testMetadataColumnStatsIndexParamsInMemory() {
        return Stream.of((Object[])((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])HoodieTableType.values())).toStream().flatMap((Function1 & Serializable & scala.Serializable)tableType -> (Seq)new .colon.colon((Object)Arguments.arguments((Object[])new Object[]{new ColumnStatIndexTestBase.ColumnStatsTestCase((HoodieTableType)tableType, true, 6)}), (List)new .colon.colon((Object)Arguments.arguments((Object[])new Object[]{new ColumnStatIndexTestBase.ColumnStatsTestCase((HoodieTableType)tableType, true, 8)}), (List)Nil$.MODULE$)), Stream$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Arguments.class)));
    }

    public Stream<Arguments> testMetadataColumnStatsIndexParamsForMOR() {
        return Stream.of((Object[])((TraversableOnce)new .colon.colon((Object)Arguments.arguments((Object[])new Object[]{new ColumnStatIndexTestBase.ColumnStatsTestCase(HoodieTableType.MERGE_ON_READ, true, 6)}), (List)new .colon.colon((Object)Arguments.arguments((Object[])new Object[]{new ColumnStatIndexTestBase.ColumnStatsTestCase(HoodieTableType.MERGE_ON_READ, false, 6)}), (List)new .colon.colon((Object)Arguments.arguments((Object[])new Object[]{new ColumnStatIndexTestBase.ColumnStatsTestCase(HoodieTableType.MERGE_ON_READ, true, 8)}), (List)new .colon.colon((Object)Arguments.arguments((Object[])new Object[]{new ColumnStatIndexTestBase.ColumnStatsTestCase(HoodieTableType.MERGE_ON_READ, false, 8)}), (List)Nil$.MODULE$))))).toArray(ClassTag$.MODULE$.apply(Arguments.class)));
    }

    public Stream<Arguments> testTableTypePartitionTypeParams() {
        return Stream.of((Object[])((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Arguments[]{Arguments.arguments((Object[])new Object[]{HoodieTableType.COPY_ON_WRITE, "c8", "6"}), Arguments.arguments((Object[])new Object[]{HoodieTableType.COPY_ON_WRITE, "", "6"}), Arguments.arguments((Object[])new Object[]{HoodieTableType.MERGE_ON_READ, "c8", "6"}), Arguments.arguments((Object[])new Object[]{HoodieTableType.MERGE_ON_READ, "", "6"}), Arguments.arguments((Object[])new Object[]{HoodieTableType.COPY_ON_WRITE, "c8", "8"}), Arguments.arguments((Object[])new Object[]{HoodieTableType.COPY_ON_WRITE, "", "8"}), Arguments.arguments((Object[])new Object[]{HoodieTableType.MERGE_ON_READ, "c8", "8"}), Arguments.arguments((Object[])new Object[]{HoodieTableType.MERGE_ON_READ, "", "8"})}))).toArray(ClassTag$.MODULE$.apply(Arguments.class)));
    }

    public Stream<Arguments> decimalWrapperTestCases() {
        return Stream.of((Object[])new Arguments[]{Arguments.of((Object[])new Object[]{"ByteBuffer Test", new BigDecimal("123.45"), new ColumnStatIndexTestBase.WrapperCreator(){

            public DecimalWrapper create(BigDecimal orig, Schema sch) {
                return new DecimalWrapper(null, orig, sch){
                    private final BigDecimal orig$1;
                    private final Schema sch$1;

                    public ByteBuffer getValue() {
                        return ColumnStatsIndexSupport$.MODULE$.decConv().toBytes(this.orig$1, this.sch$1, this.sch$1.getLogicalType());
                    }
                    {
                        this.orig$1 = orig$1;
                        this.sch$1 = sch$1;
                    }
                };
            }
        }}), Arguments.of((Object[])new Object[]{"Java BigDecimal Test", new BigDecimal("543.21"), new ColumnStatIndexTestBase.WrapperCreator(){

            public DecimalWrapper create(BigDecimal orig, Schema sch) {
                return new DecimalWrapper(null, orig, sch){
                    private final BigDecimal orig$2;
                    private final Schema sch$2;

                    public ByteBuffer getValue() {
                        return ColumnStatsIndexSupport$.MODULE$.decConv().toBytes(this.orig$2, this.sch$2, this.sch$2.getLogicalType());
                    }
                    {
                        this.orig$2 = orig$2;
                        this.sch$2 = sch$2;
                    }
                };
            }
        }}), Arguments.of((Object[])new Object[]{"Scala BigDecimal Test", BigDecimal$.MODULE$.apply("987.65").bigDecimal(), new ColumnStatIndexTestBase.WrapperCreator(){

            public DecimalWrapper create(BigDecimal orig, Schema sch) {
                return new DecimalWrapper(null, orig, sch){
                    private final BigDecimal orig$3;
                    private final Schema sch$3;

                    public ByteBuffer getValue() {
                        return ColumnStatsIndexSupport$.MODULE$.decConv().toBytes(this.orig$3, this.sch$3, this.sch$3.getLogicalType());
                    }
                    {
                        this.orig$3 = orig$3;
                        this.sch$3 = sch$3;
                    }
                };
            }
        }})});
    }

    private ColumnStatIndexTestBase$() {
        MODULE$ = this;
    }
}

