/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import java.util.function.Consumer;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.ScalaAssertionSupport;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.exception.ExceptionUtil;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieKeyGeneratorException;
import org.apache.hudi.functional.CommonOptionUtils$;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.keygen.TimestampBasedKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.testutils.HoodieSparkClientTestBase;
import org.apache.hudi.util.JFunction$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSessionExtensions;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hudi.HoodieSparkSessionExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.EnumSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u000e\u001d\u0001\u0015BQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001A\u0002\u0013\u0005Q\u0007C\u0004>\u0001\u0001\u0007I\u0011\u0001 \t\r\u001d\u0003\u0001\u0015)\u00037\u0011\u001dA\u0005A1A\u0005\u0002%Ca!\u0016\u0001!\u0002\u0013Q\u0005b\u0002,\u0001\u0005\u0004%\t!\u0013\u0005\u0007/\u0002\u0001\u000b\u0011\u0002&\t\u000ba\u0003A\u0011I-\t\u000b9\u0004A\u0011I8\t\u000bm\u0004A\u0011I8\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004!1\u0011q\u000e\u0001\u0005\u0002=Da!!\u001f\u0001\t\u0003y\u0007BBA?\u0001\u0011\u0005q\u000eC\u0004\u0002\u0002\u0002!\t!a!\t\u0013\u0005u\u0005!%A\u0005\u0002\u0005}\u0005\"CA[\u0001E\u0005I\u0011AA\\\u0011%\tY\fAI\u0001\n\u0003\ty\nC\u0005\u0002>\u0002\t\n\u0011\"\u0001\u0002@\"I\u00111\u0019\u0001\u0012\u0002\u0013\u0005\u0011q\u0018\u0005\b\u0003\u000b\u0004A\u0011AAd\u0011\u0019\t\u0019\u000f\u0001C\u0001_\"1\u0011q\u001d\u0001\u0005\u0002=Dq!a;\u0001\t\u0003\ti\u000f\u0003\u0007\u0002~\u0002\u0001\n\u0011!A\u0001\n\u0003\tyP\u0001\u0010UKN$\u0018)\u001e;p\u000f\u0016tWM]1uS>twJ\u001a*fG>\u0014HmS3zg*\u0011QDH\u0001\u000bMVt7\r^5p]\u0006d'BA\u0010!\u0003\u0011AW\u000fZ5\u000b\u0005\u0005\u0012\u0013AB1qC\u000eDWMC\u0001$\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0005\f\t\u0003O)j\u0011\u0001\u000b\u0006\u0003Sy\t\u0011\u0002^3tiV$\u0018\u000e\\:\n\u0005-B#!\u0007%p_\u0012LWm\u00159be.\u001cE.[3oiR+7\u000f\u001e\"bg\u0016\u0004\"!\f\u0018\u000e\u0003yI!a\f\u0010\u0003+M\u001b\u0017\r\\1BgN,'\u000f^5p]N+\b\u000f]8si\u00061A(\u001b8jiz\"\u0012A\r\t\u0003g\u0001i\u0011\u0001H\u0001\u0006gB\f'o[\u000b\u0002mA\u0011qgO\u0007\u0002q)\u0011\u0011HO\u0001\u0004gFd'B\u0001\u001b!\u0013\ta\u0004H\u0001\u0007Ta\u0006\u00148nU3tg&|g.A\u0005ta\u0006\u00148n\u0018\u0013fcR\u0011q(\u0012\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0002\u0005\u0006)1oY1mC&\u0011A)\u0011\u0002\u0005+:LG\u000fC\u0004G\u0007\u0005\u0005\t\u0019\u0001\u001c\u0002\u0007a$\u0013'\u0001\u0004ta\u0006\u00148\u000eI\u0001\u0010m\u0016\u0014\u0018NZ5dCRLwN\\\"pYV\t!\n\u0005\u0002L%:\u0011A\n\u0015\t\u0003\u001b\u0006k\u0011A\u0014\u0006\u0003\u001f\u0012\na\u0001\u0010:p_Rt\u0014BA)B\u0003\u0019\u0001&/\u001a3fM&\u00111\u000b\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005E\u000b\u0015\u0001\u0005<fe&4\u0017nY1uS>t7i\u001c7!\u0003Y)\b\u000fZ1uK\u00124VM]5gS\u000e\fG/[8o-\u0006d\u0017aF;qI\u0006$X\r\u001a,fe&4\u0017nY1uS>tg+\u00197!\u0003\u0005:W\r^*qCJ\\7+Z:tS>tW\t\u001f;f]NLwN\\:J]*,7\r^8s)\u0005Q\u0006cA.aE6\tAL\u0003\u0002^=\u0006!Q\u000f^5m\u0015\tyf$\u0001\u0004d_6lwN\\\u0005\u0003Cr\u0013aa\u00149uS>t\u0007cA2jW6\tAM\u0003\u0002fM\u0006Aa-\u001e8di&|gN\u0003\u0002^O*\t\u0001.\u0001\u0003kCZ\f\u0017B\u00016e\u0005!\u0019uN\\:v[\u0016\u0014\bCA\u001cm\u0013\ti\u0007H\u0001\fTa\u0006\u00148nU3tg&|g.\u0012=uK:\u001c\u0018n\u001c8t\u0003\u0015\u0019X\r^+q)\u0005y\u0004F\u0001\u0006r!\t\u0011\u00180D\u0001t\u0015\t!X/A\u0002ba&T!A^<\u0002\u000f),\b/\u001b;fe*\u0011\u0001PI\u0001\u0006UVt\u0017\u000e^\u0005\u0003uN\u0014!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007FA\u0006~!\t\u0011h0\u0003\u0002\u0000g\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0016i\u0016\u001cHOU3d_J$7*Z=t\u0003V$xnR3o)\u001dy\u0014QAA\u0018\u0003gAq!a\u0002\r\u0001\u0004\tI!\u0001\u0006sK\u000e|'\u000f\u001a+za\u0016\u0004B!a\u0003\u0002*9!\u0011QBA\u0012\u001d\u0011\ty!a\b\u000f\t\u0005E\u0011Q\u0004\b\u0005\u0003'\tYB\u0004\u0003\u0002\u0016\u0005eabA'\u0002\u0018%\t1%\u0003\u0002\"E%\u0011q\u0004I\u0005\u0003?zI1!!\t_\u0003\u0015iw\u000eZ3m\u0013\u0011\t)#a\n\u0002\u0019!{w\u000eZ5f%\u0016\u001cwN\u001d3\u000b\u0007\u0005\u0005b,\u0003\u0003\u0002,\u00055\"\u0001\u0005%p_\u0012LWMU3d_J$G+\u001f9f\u0015\u0011\t)#a\n\t\r\u0005EB\u00021\u0001K\u0003\ty\u0007\u000fC\u0004\u000261\u0001\r!a\u000e\u0002\u0013Q\f'\r\\3UsB,\u0007\u0003BA\u001d\u0003wi!!a\n\n\t\u0005u\u0012q\u0005\u0002\u0010\u0011>|G-[3UC\ndW\rV=qK\":A\"!\u0011\u0002R\u0005M\u0003\u0003BA\"\u0003\u001bj!!!\u0012\u000b\t\u0005\u001d\u0013\u0011J\u0001\taJ|g/\u001b3fe*\u0019\u00111J;\u0002\rA\f'/Y7t\u0013\u0011\ty%!\u0012\u0003\u0013\r\u001bhoU8ve\u000e,\u0017!\u0002<bYV,G\u0006CA+\u00033\ni&!\u0019\"\u0005\u0005]\u0013!G!W%>c\u0013N\\:feRd3i\u0014)Z?>sul\u0016*J)\u0016\u000b#!a\u0017\u0002=\u00053&k\u0014\u0017ck2\\w,\u001b8tKJ$HfQ(Q3~{ejX,S\u0013R+\u0015EAA0\u0003e\teKU(-S:\u001cXM\u001d;-\u001b\u0016\u0013v)R0P\u001d~\u0013V)\u0011#\"\u0005\u0005\r\u0014AH!W%>c#-\u001e7l?&t7/\u001a:uY5+%kR#`\u001f:{&+R!EQ\ra\u0011q\r\t\u0005\u0003S\nY'\u0004\u0002\u0002J%!\u0011QNA%\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001-i\u0016\u001cHOU3d_J$7*Z=BkR|w)\u001a8XSRDG+[7fgR\fW\u000e\u001d\"bg\u0016$7*Z=HK:D3!DA:!\r\u0011\u0018QO\u0005\u0004\u0003o\u001a(\u0001\u0002+fgR\fQ\u0005^3tiJ+7m\u001c:e\u0017\u0016L\u0018)\u001e;p\u000f\u0016tw+\u001b;i\u0007>l\u0007\u000f\\3y\u0017\u0016Lx)\u001a8)\u00079\t\u0019(\u0001\u0017uKN$(+Z2pe\u0012\\U-_!vi><UM\\,ji\"tuN\u001c)beRLG/[8oK\u0012\\U-_$f]\"\u001aq\"a\u001d\u0002;Q,7\u000f\u001e*fG>\u0014HmS3zg\u0006+Ho\\$f]&sG/\u001a:oC2$RbPAC\u0003\u000f\u000bI)a#\u0002\u0010\u0006e\u0005bBA\u0004!\u0001\u0007\u0011\u0011\u0002\u0005\t\u0003c\u0001\u0002\u0013!a\u0001\u0015\"I\u0011Q\u0007\t\u0011\u0002\u0003\u0007\u0011q\u0007\u0005\t\u0003\u001b\u0003\u0002\u0013!a\u0001\u0015\u0006Y1.Z=HK:\u001cE.Y:t\u0011%\t\t\n\u0005I\u0001\u0002\u0004\t\u0019*\u0001\u000bd_6\u0004H.\u001a=QCJ$\u0018\u000e^5p]B\u000bG\u000f\u001b\t\u0004\u0001\u0006U\u0015bAAL\u0003\n9!i\\8mK\u0006t\u0007\"CAN!A\u0005\t\u0019AAJ\u0003UqwN\u001c)beRLG/[8oK\u0012$\u0015\r^1tKR\fq\u0005^3tiJ+7m\u001c:e\u0017\u0016L8/Q;u_\u001e+g.\u00138uKJt\u0017\r\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0015\u0016\u0004\u0015\u0006\r6FAAS!\u0011\t9+!-\u000e\u0005\u0005%&\u0002BAV\u0003[\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=\u0016)\u0001\u0006b]:|G/\u0019;j_:LA!a-\u0002*\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002OQ,7\u000f\u001e*fG>\u0014HmS3zg\u0006+Ho\\$f]&sG/\u001a:oC2$C-\u001a4bk2$HeM\u000b\u0003\u0003sSC!a\u000e\u0002$\u00069C/Z:u%\u0016\u001cwN\u001d3LKf\u001c\u0018)\u001e;p\u000f\u0016t\u0017J\u001c;fe:\fG\u000e\n3fM\u0006,H\u000e\u001e\u00135\u0003\u001d\"Xm\u001d;SK\u000e|'\u000fZ&fsN\fU\u000f^8HK:Le\u000e^3s]\u0006dG\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005\u0005'\u0006BAJ\u0003G\u000bq\u0005^3tiJ+7m\u001c:e\u0017\u0016L8/Q;u_\u001e+g.\u00138uKJt\u0017\r\u001c\u0013eK\u001a\fW\u000f\u001c;%m\u0005\u0011C/Z:u%\u0016\u001cwN\u001d3LKf\u001c\u0018)\u001e;p\u000f\u0016t\u0017J\u001c<bY&$\u0007+\u0019:b[N$RaPAe\u0003\u001bDa!a3\u0017\u0001\u0004Q\u0015!C2p]\u001aLwmS3z\u0011\u0019\tyM\u0006a\u0001\u0015\u0006Y1m\u001c8gS\u001e4\u0016\r\\;fQ\u001d1\u0012\u0011IA)\u0003'dc!!6\u0002Z\u0006u\u0017EAAl\u0003\u0005Bwn\u001c3jK:\u0002x\u000e];mCR,g&\\3uC:2\u0017.\u001a7eg22\u0017\r\\:fC\t\tY.A\u0011i_>$\u0017.\u001a\u0018d_6\u0014\u0017N\\3/E\u00164wN]3/S:\u001cXM\u001d;-iJ,X-\t\u0002\u0002`\u0006\u0019\u0004n\\8eS\u0016tC-\u0019;bg>,(oY3/oJLG/\u001a\u0018j]N,'\u000f\u001e\u0018ee>\u0004h\u0006Z;qY&\u001c\u0017\r^3tYQ\u0014X/\u001a\u0015\u0004-\u0005\u001d\u0014\u0001\n;fgR\u0014VmY8sI.+\u0017p]!vi><UM\\#oC\ndW\rV8ESN\f'\r\\3)\u0007]\t\u0019(\u0001\u0011uKN$xK]5uKR{\u0007*\u001e3j/&$\bn\\;u\u0003:L8i\u001c8gS\u001e\u001c\bf\u0001\r\u0002t\u0005yB/Z:u+B\u001cXM\u001d;t\u0003:$G)\u001a7fi\u0016\u001cx+\u001b;i!.dUm]:\u0015\u0007}\ny\u000fC\u0004\u00026e\u0001\r!a\u000e)\u000fe\t\u00190!\u0015\u0002zB!\u00111IA{\u0013\u0011\t90!\u0012\u0003\u0015\u0015sW/\\*pkJ\u001cWm\t\u0002\u00028!\u001a\u0011$a\u001a\u0002%A\u0014x\u000e^3di\u0016$GEY1tKB\u000bG\u000f\u001b\u000b\u0005\u0005\u0003\u0011Y\u0001\u0005\u0003\u0003\u0004\t%QB\u0001B\u0003\u0015\r\u00119aZ\u0001\u0005Y\u0006tw-C\u0002T\u0005\u000bAqA\u0012\u000e\u0002\u0002\u0003\u0007!\u0007")
public class TestAutoGenerationOfRecordKeys
extends HoodieSparkClientTestBase
implements ScalaAssertionSupport {
    private SparkSession spark;
    private final String verificationCol;
    private final String updatedVerificationVal;

    @Override
    public <T extends Throwable, R> T assertThrows(Class<T> expectedExceptionClass, Function0<R> f) {
        return (T)ScalaAssertionSupport.assertThrows$(this, expectedExceptionClass, f);
    }

    public /* synthetic */ String protected$basePath(TestAutoGenerationOfRecordKeys x$1) {
        return x$1.basePath;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public String verificationCol() {
        return this.verificationCol;
    }

    public String updatedVerificationVal() {
        return this.updatedVerificationVal;
    }

    @Override
    public org.apache.hudi.common.util.Option<Consumer<SparkSessionExtensions>> getSparkSessionExtensionsInjector() {
        return HoodieConversionUtils$.MODULE$.toJavaOption((Option)new Some((Object)JFunction$.MODULE$.toJavaConsumer((Function1 & Serializable & scala.Serializable)receiver -> {
            TestAutoGenerationOfRecordKeys.$anonfun$getSparkSessionExtensionsInjector$1(receiver);
            return BoxedUnit.UNIT;
        })));
    }

    @BeforeEach
    public void setUp() {
        this.initPath();
        this.initSparkContexts();
        this.spark_$eq(this.sqlContext.sparkSession());
        this.initTestDataGenerator();
        this.initHoodieStorage();
    }

    @AfterEach
    public void tearDown() {
        this.cleanupSparkContexts();
        this.cleanupTestDataGenerator();
        this.cleanupFileSystem();
        FileSystem.closeAll();
        System.gc();
    }

    @ParameterizedTest
    @CsvSource(value={"AVRO,insert,COPY_ON_WRITE", "AVRO,bulk_insert,COPY_ON_WRITE", "AVRO,insert,MERGE_ON_READ", "AVRO,bulk_insert,MERGE_ON_READ"})
    public void testRecordKeysAutoGen(HoodieRecord.HoodieRecordType recordType, String op, HoodieTableType tableType) {
        this.testRecordKeysAutoGenInternal(recordType, op, tableType, this.testRecordKeysAutoGenInternal$default$4(), this.testRecordKeysAutoGenInternal$default$5(), this.testRecordKeysAutoGenInternal$default$6());
    }

    @Test
    public void testRecordKeyAutoGenWithTimestampBasedKeyGen() {
        this.testRecordKeysAutoGenInternal(HoodieRecord.HoodieRecordType.AVRO, "insert", HoodieTableType.COPY_ON_WRITE, TimestampBasedKeyGenerator.class.getName(), this.testRecordKeysAutoGenInternal$default$5(), this.testRecordKeysAutoGenInternal$default$6());
    }

    @Test
    public void testRecordKeyAutoGenWithComplexKeyGen() {
        this.testRecordKeysAutoGenInternal(HoodieRecord.HoodieRecordType.AVRO, "insert", HoodieTableType.COPY_ON_WRITE, ComplexKeyGenerator.class.getName(), true, this.testRecordKeysAutoGenInternal$default$6());
    }

    @Test
    public void testRecordKeyAutoGenWithNonPartitionedKeyGen() {
        this.testRecordKeysAutoGenInternal(HoodieRecord.HoodieRecordType.AVRO, "insert", HoodieTableType.COPY_ON_WRITE, NonpartitionedKeyGenerator.class.getName(), false, true);
    }

    public void testRecordKeysAutoGenInternal(HoodieRecord.HoodieRecordType recordType, String op, HoodieTableType tableType, String keyGenClass, boolean complexPartitionPath, boolean nonPartitionedDataset) {
        Tuple2<scala.collection.immutable.Map<String, String>, scala.collection.immutable.Map<String, String>> tuple2 = CommonOptionUtils$.MODULE$.getWriterReaderOpts(recordType, CommonOptionUtils$.MODULE$.getWriterReaderOpts$default$2(), CommonOptionUtils$.MODULE$.getWriterReaderOpts$default$3());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.immutable.Map vanillaWriteOpts = (scala.collection.immutable.Map)tuple2._1();
        scala.collection.immutable.Map readOpts = (scala.collection.immutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)vanillaWriteOpts, (Object)readOpts);
        scala.collection.immutable.Map vanillaWriteOpts2 = (scala.collection.immutable.Map)tuple22._1();
        scala.collection.immutable.Map readOpts2 = (scala.collection.immutable.Map)tuple22._2();
        scala.collection.immutable.Map options = vanillaWriteOpts2.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)keyGenClass)})));
        boolean isTimestampBasedKeyGen = TimestampBasedKeyGenerator.class.getName().equals(keyGenClass);
        if (isTimestampBasedKeyGen) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KeyGeneratorOptions.Config.TIMESTAMP_TYPE_FIELD_PROP), (Object)"DATE_STRING"));
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KeyGeneratorOptions.Config.TIMESTAMP_INPUT_DATE_FORMAT_PROP), (Object)"yyyy/MM/dd"));
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KeyGeneratorOptions.Config.TIMESTAMP_OUTPUT_DATE_FORMAT_PROP), (Object)"yyyyMMdd"));
        }
        if (complexPartitionPath) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()), (Object)"rider,_hoodie_is_deleted"));
        }
        if (nonPartitionedDataset) {
            options = (scala.collection.immutable.Map)options.$minus$minus((GenTraversableOnce)new .colon.colon((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), (List)Nil$.MODULE$));
        }
        scala.collection.immutable.Map writeOpts = (scala.collection.immutable.Map)options.$minus$minus((GenTraversableOnce)new .colon.colon((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), (List)Nil$.MODULE$));
        List records = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(5)))).asScala()).toList();
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF.cache();
        inputDF.write().format("hudi").options((Map)writeOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), op).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), tableType.name()).mode(SaveMode.Overwrite).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((HoodieStorage)this.storage, (String)this.basePath, (String)"000"));
        Dataset inputDF2 = inputDF;
        inputDF2.write().format("hudi").options((Map)writeOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), op).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), tableType.name()).mode(SaveMode.Append).save(this.basePath);
        Dataset readDF = this.spark().read().format("hudi").options((Map)readOpts2).load(this.basePath);
        readDF.cache();
        Buffer recordKeys = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(readDF.select(HoodieRecord.RECORD_KEY_METADATA_FIELD, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().collectAsList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getString(0), Buffer$.MODULE$.canBuildFrom());
        Assertions.assertEquals((int)10, (int)recordKeys.size());
        Dataset expectedInputDf = inputDF.union(inputDF2).drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition", "rider", "_hoodie_is_deleted"}));
        Dataset actualDf = readDF.drop(((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).toSeq()).drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition", "rider", "_hoodie_is_deleted"}));
        Assertions.assertEquals((long)expectedInputDf.except(actualDf).count(), (long)0L);
    }

    public String testRecordKeysAutoGenInternal$default$2() {
        return "insert";
    }

    public HoodieTableType testRecordKeysAutoGenInternal$default$3() {
        return HoodieTableType.COPY_ON_WRITE;
    }

    public String testRecordKeysAutoGenInternal$default$4() {
        return SimpleKeyGenerator.class.getCanonicalName();
    }

    public boolean testRecordKeysAutoGenInternal$default$5() {
        return false;
    }

    public boolean testRecordKeysAutoGenInternal$default$6() {
        return false;
    }

    @ParameterizedTest
    @CsvSource(value={"hoodie.populate.meta.fields,false", "hoodie.combine.before.insert,true", "hoodie.datasource.write.insert.drop.duplicates,true"})
    public void testRecordKeysAutoGenInvalidParams(String configKey, String configValue) {
        Tuple2<scala.collection.immutable.Map<String, String>, scala.collection.immutable.Map<String, String>> tuple2 = CommonOptionUtils$.MODULE$.getWriterReaderOpts(HoodieRecord.HoodieRecordType.AVRO, CommonOptionUtils$.MODULE$.getWriterReaderOpts$default$2(), CommonOptionUtils$.MODULE$.getWriterReaderOpts$default$3());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.immutable.Map writeOpts = (scala.collection.immutable.Map)tuple2._1();
        scala.collection.immutable.Map writeOpts2 = writeOpts;
        ObjectRef opts = ObjectRef.create((Object)((scala.collection.immutable.Map)writeOpts2.$minus$minus((GenTraversableOnce)new .colon.colon((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), (List)Nil$.MODULE$))));
        List records = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(1)))).asScala()).toList();
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        HoodieKeyGeneratorException e = this.assertThrows((Class)HoodieKeyGeneratorException.class, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> inputDF.write().format("hudi").options((Map)((scala.collection.immutable.Map)opts$1.elem)).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), "insert").option(configKey, configValue).mode(SaveMode.Overwrite).save(this.protected$basePath(this)));
        Assertions.assertTrue((boolean)ExceptionUtil.getRootCause((Throwable)e).getMessage().contains(new StringBuilder(53).append(configKey).append(" is not supported with auto generation of record keys").toString()));
    }

    @Test
    public void testRecordKeysAutoGenEnableToDisable() {
        Tuple2<scala.collection.immutable.Map<String, String>, scala.collection.immutable.Map<String, String>> tuple2 = CommonOptionUtils$.MODULE$.getWriterReaderOpts(HoodieRecord.HoodieRecordType.AVRO, CommonOptionUtils$.MODULE$.getWriterReaderOpts$default$2(), CommonOptionUtils$.MODULE$.getWriterReaderOpts$default$3());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.immutable.Map vanillaWriteOpts = (scala.collection.immutable.Map)tuple2._1();
        scala.collection.immutable.Map readOpts = (scala.collection.immutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)vanillaWriteOpts, (Object)readOpts);
        scala.collection.immutable.Map vanillaWriteOpts2 = (scala.collection.immutable.Map)tuple22._1();
        scala.collection.immutable.Map readOpts2 = (scala.collection.immutable.Map)tuple22._2();
        scala.collection.immutable.Map options = vanillaWriteOpts2.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)SimpleKeyGenerator.class.getCanonicalName())})));
        ObjectRef writeOpts = ObjectRef.create((Object)((scala.collection.immutable.Map)options.$minus$minus((GenTraversableOnce)new .colon.colon((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), (List)Nil$.MODULE$))));
        List records = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(5)))).asScala()).toList();
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF.cache();
        inputDF.write().format("hudi").options((Map)((scala.collection.immutable.Map)writeOpts.elem)).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), "insert").mode(SaveMode.Overwrite).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((HoodieStorage)this.storage, (String)this.basePath, (String)"000"));
        HoodieException e = this.assertThrows((Class)HoodieException.class, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset inputDF2 = inputDF;
            inputDF2.write().format("hudi").options((Map)((scala.collection.immutable.Map)writeOpts$1.elem).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key")})))).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), "insert").mode(SaveMode.Append).save(this.protected$basePath(this));
        });
        String expectedMsg = "RecordKey:\t_row_key\tnull";
        Assertions.assertTrue((boolean)ExceptionUtil.getRootCause((Throwable)e).getMessage().contains(expectedMsg));
    }

    @Test
    public void testWriteToHudiWithoutAnyConfigs() {
        List records = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(5)))).asScala()).toList();
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF.cache();
        inputDF.write().format("hudi").option("hoodie.table.name", "hudi_tbl").mode(SaveMode.Overwrite).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((HoodieStorage)this.storage, (String)this.basePath, (String)"000"));
        Dataset snapshot0 = this.spark().read().format("hudi").load(this.basePath);
        Assertions.assertEquals((long)5L, (long)snapshot0.count());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testUpsertsAndDeletesWithPkLess(HoodieTableType tableType) {
        Tuple2<scala.collection.immutable.Map<String, String>, scala.collection.immutable.Map<String, String>> tuple2 = CommonOptionUtils$.MODULE$.getWriterReaderOpts(HoodieRecord.HoodieRecordType.AVRO, CommonOptionUtils$.MODULE$.getWriterReaderOpts$default$2(), CommonOptionUtils$.MODULE$.getWriterReaderOpts$default$3());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.immutable.Map vanillaWriteOpts = (scala.collection.immutable.Map)tuple2._1();
        scala.collection.immutable.Map readOpts = (scala.collection.immutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)vanillaWriteOpts, (Object)readOpts);
        scala.collection.immutable.Map vanillaWriteOpts2 = (scala.collection.immutable.Map)tuple22._1();
        scala.collection.immutable.Map readOpts2 = (scala.collection.immutable.Map)tuple22._2();
        scala.collection.immutable.Map options = vanillaWriteOpts2.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)SimpleKeyGenerator.class.getCanonicalName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name())})));
        scala.collection.immutable.Map writeOpts = (scala.collection.immutable.Map)options.$minus$minus((GenTraversableOnce)new .colon.colon((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), (List)Nil$.MODULE$));
        List records = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(20)))).asScala()).toList();
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF.cache();
        inputDF.write().format("hudi").options((Map)writeOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), "insert").mode(SaveMode.Overwrite).save(this.basePath);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((HoodieStorage)this.storage, (String)this.basePath, (String)"000"));
        Dataset snapshotDf = this.spark().read().format("hudi").load(this.basePath);
        snapshotDf.cache();
        Assertions.assertEquals((long)snapshotDf.count(), (long)20L);
        Dataset updateDf = snapshotDf.limit(5).withColumn("rider", functions$.MODULE$.lit((Object)"rider-123456"));
        updateDf.write().format("hudi").options((Map)writeOpts).mode(SaveMode.Append).save(this.basePath);
        Dataset snapshotDf1 = this.spark().read().format("hudi").load(this.basePath);
        snapshotDf1.cache();
        Assertions.assertEquals((long)20L, (long)snapshotDf1.count());
        Assertions.assertEquals((long)5L, (long)snapshotDf1.filter("rider == 'rider-123456'").count());
        snapshotDf1.filter("rider == 'rider-123456'").write().format("hudi").options((Map)writeOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), "delete").mode(SaveMode.Append).save(this.basePath);
        Dataset snapshotDf2 = this.spark().read().format("hudi").load(this.basePath);
        snapshotDf2.cache();
        Assertions.assertEquals((long)15L, (long)snapshotDf2.count());
        Assertions.assertEquals((long)0L, (long)snapshotDf2.filter("rider == 'rider-123456'").count());
    }

    public static final /* synthetic */ void $anonfun$getSparkSessionExtensionsInjector$1(SparkSessionExtensions receiver) {
        new HoodieSparkSessionExtension().apply(receiver);
    }

    public TestAutoGenerationOfRecordKeys() {
        ScalaAssertionSupport.$init$(this);
        this.spark = null;
        this.verificationCol = "driver";
        this.updatedVerificationVal = "driver_update";
    }
}

