/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.DataSourceWriteOptions;
import org.apache.hudi.client.bootstrap.selector.BootstrapRegexModeSelector;
import org.apache.hudi.client.bootstrap.selector.FullRecordBootstrapModeSelector;
import org.apache.hudi.client.bootstrap.selector.MetadataOnlyBootstrapModeSelector;
import org.apache.hudi.client.bootstrap.translator.DecodedBootstrapPartitionPathTranslator;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.config.HoodieBootstrapConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.testutils.HoodieSparkClientTestBase;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.functions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.io.TempDir;

@Tag(value="functional")
public abstract class TestBootstrapReadBase
extends HoodieSparkClientTestBase {
    @TempDir
    public Path tmpFolder;
    protected String bootstrapBasePath = null;
    protected String bootstrapTargetPath = null;
    protected String hudiBasePath = null;
    protected int nInserts = 100;
    protected int nUpdates = 20;
    protected static String[] dashPartitionPaths = new String[]{"2016-03-14", "2016-03-15", "2015-03-16", "2015-03-17"};
    protected static String[] slashPartitionPaths = new String[]{"2016/03/15", "2015/03/16", "2015/03/17"};
    protected String bootstrapType;
    protected Boolean dashPartitions;
    protected HoodieTableType tableType;
    protected Integer nPartitions;
    protected String[] partitionCols;
    protected static String[] dropColumns = new String[]{"_hoodie_commit_time", "_hoodie_commit_seqno", "_hoodie_record_key", "_hoodie_file_name", "city_to_state"};

    @BeforeEach
    public void setUp() throws Exception {
        this.bootstrapBasePath = this.tmpFolder.toAbsolutePath() + "/bootstrapBasePath";
        this.hudiBasePath = this.tmpFolder.toAbsolutePath() + "/hudiBasePath";
        this.bootstrapTargetPath = this.tmpFolder.toAbsolutePath() + "/bootstrapTargetPath";
        this.initSparkContexts();
    }

    @AfterEach
    public void tearDown() throws IOException {
        this.cleanupSparkContexts();
        this.cleanupClients();
        this.cleanupTestDataGenerator();
    }

    protected Map<String, String> basicOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(DataSourceWriteOptions.TABLE_TYPE().key(), this.tableType.name());
        options.put(DataSourceWriteOptions.HIVE_STYLE_PARTITIONING().key(), "true");
        options.put(DataSourceWriteOptions.RECORDKEY_FIELD().key(), "_row_key");
        options.put(HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key(), "false");
        if (this.nPartitions == 0) {
            options.put(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), NonpartitionedKeyGenerator.class.getName());
        } else {
            options.put(DataSourceWriteOptions.PARTITIONPATH_FIELD().key(), String.join((CharSequence)",", this.partitionCols));
            if (this.nPartitions == 1) {
                options.put(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), SimpleKeyGenerator.class.getName());
            } else {
                options.put(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), ComplexKeyGenerator.class.getName());
            }
        }
        options.put(DataSourceWriteOptions.PRECOMBINE_FIELD().key(), "timestamp");
        if (this.tableType.equals((Object)HoodieTableType.MERGE_ON_READ)) {
            options.put(HoodieCompactionConfig.INLINE_COMPACT.key(), "true");
        }
        options.put(HoodieWriteConfig.TBL_NAME.key(), "test");
        return options;
    }

    protected Map<String, String> setBootstrapOptions() {
        Map<String, String> options = this.basicOptions();
        options.put(DataSourceWriteOptions.OPERATION().key(), DataSourceWriteOptions.BOOTSTRAP_OPERATION_OPT_VAL());
        options.put(HoodieBootstrapConfig.BASE_PATH.key(), this.bootstrapBasePath);
        options.put(HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key(), "false");
        if (!this.dashPartitions.booleanValue()) {
            options.put(HoodieBootstrapConfig.PARTITION_PATH_TRANSLATOR_CLASS_NAME.key(), DecodedBootstrapPartitionPathTranslator.class.getName());
        }
        switch (this.bootstrapType) {
            case "metadata": {
                options.put(HoodieBootstrapConfig.MODE_SELECTOR_CLASS_NAME.key(), MetadataOnlyBootstrapModeSelector.class.getName());
                break;
            }
            case "full": {
                options.put(HoodieBootstrapConfig.MODE_SELECTOR_CLASS_NAME.key(), FullRecordBootstrapModeSelector.class.getName());
                break;
            }
            case "mixed": {
                options.put(HoodieBootstrapConfig.MODE_SELECTOR_CLASS_NAME.key(), BootstrapRegexModeSelector.class.getName());
                String regexPattern = this.dashPartitions != false ? "partition_path=2015-03-1[5-7]" : "partition_path=2015%2F03%2F1[5-7]";
                if (this.nPartitions > 1) {
                    regexPattern = regexPattern + "\\/.*";
                }
                options.put(HoodieBootstrapConfig.PARTITION_SELECTOR_REGEX_PATTERN.key(), regexPattern);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return options;
    }

    protected void doUpdate(Map<String, String> options, String instantTime) {
        Dataset<Row> updates = this.generateTestUpdates(instantTime, this.nUpdates);
        this.doUpsert(options, updates);
    }

    protected void doInsert(Map<String, String> options, String instantTime) {
        Dataset<Row> inserts = this.generateTestInserts(instantTime, this.nUpdates);
        this.doUpsert(options, inserts);
    }

    protected void doDelete(Map<String, String> options, String instantTime) {
        Dataset<Row> deletes = this.generateTestDeletes(instantTime, this.nUpdates);
        this.doUpsert(options, deletes);
    }

    protected void doUpsert(Map<String, String> options, Dataset<Row> df) {
        String nCompactCommits = "3";
        df.write().format("hudi").options(options).option(HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key(), nCompactCommits).mode(SaveMode.Append).save(this.hudiBasePath);
        if (this.bootstrapType.equals("mixed")) {
            nCompactCommits = "4";
        }
        df.write().format("hudi").options(options).option(HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key(), nCompactCommits).mode(SaveMode.Append).save(this.bootstrapTargetPath);
    }

    protected void compareTables() {
        Dataset hudiDf = this.sparkSession.read().format("hudi").load(this.hudiBasePath);
        Dataset bootstrapDf = this.sparkSession.read().format("hudi").load(this.bootstrapTargetPath);
        if (this.nPartitions == 0) {
            this.compareDf((Dataset<Row>)hudiDf.drop(dropColumns), (Dataset<Row>)bootstrapDf.drop(dropColumns));
            return;
        }
        this.compareDf((Dataset<Row>)hudiDf.drop(dropColumns).drop(this.partitionCols), (Dataset<Row>)bootstrapDf.drop(dropColumns).drop(this.partitionCols));
        this.compareDf((Dataset<Row>)hudiDf.select("_row_key", this.partitionCols), (Dataset<Row>)bootstrapDf.select("_row_key", this.partitionCols));
    }

    protected void verifyMetaColOnlyRead(Integer iteration) {
        Dataset hudiDf = this.sparkSession.read().format("hudi").load(this.hudiBasePath).select("_hoodie_commit_time", new String[]{"_hoodie_record_key"});
        Dataset bootstrapDf = this.sparkSession.read().format("hudi").load(this.bootstrapTargetPath).select("_hoodie_commit_time", new String[]{"_hoodie_record_key"});
        hudiDf.show(100, false);
        bootstrapDf.show(100, false);
        if (iteration > 0) {
            Assertions.assertEquals((long)this.sparkSession.sql("select * from hudi_iteration_" + (iteration - 1)).intersect(hudiDf).count(), (long)this.sparkSession.sql("select * from bootstrap_iteration_" + (iteration - 1)).intersect(bootstrapDf).count());
        }
        hudiDf.createOrReplaceTempView("hudi_iteration_" + iteration);
        bootstrapDf.createOrReplaceTempView("bootstrap_iteration_" + iteration);
    }

    protected void compareDf(Dataset<Row> df1, Dataset<Row> df2) {
        Assertions.assertEquals((long)0L, (long)df1.except(df2).count());
        Assertions.assertEquals((long)0L, (long)df2.except(df1).count());
    }

    protected void setupDirs() {
        this.dataGen = new HoodieTestDataGenerator(this.dashPartitions != false ? dashPartitionPaths : slashPartitionPaths);
        Dataset inserts = this.generateTestInserts("000", this.nInserts);
        if (this.dashPartitions.booleanValue()) {
            inserts = inserts.filter("partition_path != '2016-03-14'");
        }
        if (this.nPartitions > 0) {
            this.partitionCols = new String[this.nPartitions.intValue()];
            this.partitionCols[0] = "partition_path";
            for (int i = 1; i < this.partitionCols.length; ++i) {
                this.partitionCols[i] = "partpath" + (i + 1);
            }
            inserts.write().partitionBy(this.partitionCols).save(this.bootstrapBasePath);
        } else {
            inserts.write().save(this.bootstrapBasePath);
        }
        inserts.write().format("hudi").options(this.basicOptions()).mode(SaveMode.Overwrite).save(this.hudiBasePath);
    }

    protected Dataset<Row> makeDeleteDf(String instantTime, Integer n) {
        List records = this.dataGen.generateUniqueDeleteRecords(instantTime, n).stream().map(r -> (String)RawTripTestPayload.recordToString((HoodieRecord)r).get()).collect(Collectors.toList());
        JavaRDD rdd = this.jsc.parallelize(records);
        return this.sparkSession.read().json(rdd);
    }

    protected Dataset<Row> generateTestDeletes(String instantTime, Integer n) {
        return TestBootstrapReadBase.addPartitionColumns(this.makeDeleteDf(instantTime, n), this.nPartitions);
    }

    protected Dataset<Row> makeInsertDf(String instantTime, Integer n) {
        List records = this.dataGen.generateInserts(instantTime, n).stream().map(r -> (String)RawTripTestPayload.recordToString((HoodieRecord)r).get()).collect(Collectors.toList());
        JavaRDD rdd = this.jsc.parallelize(records);
        return this.sparkSession.read().json(rdd);
    }

    protected Dataset<Row> generateTestInserts(String instantTime, Integer n) {
        return TestBootstrapReadBase.addPartitionColumns(this.makeInsertDf(instantTime, n), this.nPartitions);
    }

    protected Dataset<Row> makeUpdateDf(String instantTime, Integer n) {
        try {
            List records = this.dataGen.generateUpdates(instantTime, n).stream().map(r -> (String)RawTripTestPayload.recordToString((HoodieRecord)r).get()).collect(Collectors.toList());
            JavaRDD rdd = this.jsc.parallelize(records);
            return this.sparkSession.read().json(rdd);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Dataset<Row> generateTestUpdates(String instantTime, Integer n) {
        return TestBootstrapReadBase.addPartitionColumns(this.makeUpdateDf(instantTime, n), this.nPartitions);
    }

    protected static Dataset<Row> addPartitionColumns(Dataset<Row> df, Integer nPartitions) {
        if (nPartitions < 2) {
            return df;
        }
        for (int i = 2; i <= nPartitions; ++i) {
            df = TestBootstrapReadBase.applyPartition(df, i);
        }
        return df;
    }

    protected static Dataset<Row> applyPartition(Dataset<Row> df, Integer n) {
        return df.withColumn("partpath" + n, functions.md5((Column)functions.concat_ws((String)("," + n + ","), (Column[])new Column[]{df.col("partition_path"), functions.hash((Column[])new Column[]{df.col("_row_key")}).mod((Object)n)})));
    }
}

