/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.BucketIndexSupport;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.bucket.BucketIdentifier;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.testutils.HoodieSparkClientTestBase;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.HoodieCatalystExpressionUtils$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.encoders.DummyExpressionHolder;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.util.collection.BitSet;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction1;

@Tag(value="functional")
@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\n\u0015\u0001uAQ\u0001\r\u0001\u0005\u0002EB\u0011\"\f\u0001A\u0002\u0003\u0007I\u0011\u0001\u001b\t\u0013e\u0002\u0001\u0019!a\u0001\n\u0003Q\u0004\"C\"\u0001\u0001\u0004\u0005\t\u0015)\u00036\u0011\u001d!\u0005A1A\u0005\u0002\u0015CaA\u0014\u0001!\u0002\u00131\u0005bB(\u0001\u0005\u0004%\t\u0001\u0015\u0005\u0007/\u0002\u0001\u000b\u0011B)\t\u000fa\u0003!\u0019!C\u00013\"1\u0001\r\u0001Q\u0001\niCQ!\u0019\u0001\u0005B\tDQA\u001c\u0001\u0005B\tDQa\u001d\u0001\u0005\u0002QDQ!\u001f\u0001\u0005\u0002\tDQa\u001f\u0001\u0005\u0002\tDQ\u0001 \u0001\u0005\u0002uDq!a\u0012\u0001\t\u0003\tI\u0005\u0003\u0004\u0002^\u0001!\tA\u0019\u0002\u0017)\u0016\u001cHOQ;dW\u0016$\u0018J\u001c3fqN+\b\u000f]8si*\u0011QCF\u0001\u000bMVt7\r^5p]\u0006d'BA\f\u0019\u0003\u0011AW\u000fZ5\u000b\u0005eQ\u0012AB1qC\u000eDWMC\u0001\u001c\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0004\n\t\u0003?\tj\u0011\u0001\t\u0006\u0003CY\t\u0011\u0002^3tiV$\u0018\u000e\\:\n\u0005\r\u0002#!\u0007%p_\u0012LWm\u00159be.\u001cE.[3oiR+7\u000f\u001e\"bg\u0016\u0004\"!\n\u0018\u000e\u0003\u0019R!a\n\u0015\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003S)\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003W1\n1a]9m\u0015\ti\u0003$A\u0003ta\u0006\u00148.\u0003\u00020M\ty\u0001K]3eS\u000e\fG/\u001a%fYB,'/\u0001\u0004=S:LGO\u0010\u000b\u0002eA\u00111\u0007A\u0007\u0002)U\tQ\u0007\u0005\u00027o5\t!&\u0003\u00029U\ta1\u000b]1sWN+7o]5p]\u0006I1\u000f]1sW~#S-\u001d\u000b\u0003w\u0005\u0003\"\u0001P \u000e\u0003uR\u0011AP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0001v\u0012A!\u00168ji\"9!iAA\u0001\u0002\u0004)\u0014a\u0001=%c\u000511\u000f]1sW\u0002\nQ\"\u0019<s_N\u001b\u0007.Z7b'R\u0014X#\u0001$\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015\u0001\u00027b]\u001eT\u0011aS\u0001\u0005U\u00064\u0018-\u0003\u0002N\u0011\n11\u000b\u001e:j]\u001e\fa\"\u0019<s_N\u001b\u0007.Z7b'R\u0014\b%\u0001\u0007tiJ,8\r^*dQ\u0016l\u0017-F\u0001R!\t\u0011V+D\u0001T\u0015\t!&&A\u0003usB,7/\u0003\u0002W'\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u001bM$(/^2u'\u000eDW-\\1!\u0003)\tgO]8TG\",W.Y\u000b\u00025B\u00111LX\u0007\u00029*\u0011Q\fG\u0001\u0005CZ\u0014x.\u0003\u0002`9\n11k\u00195f[\u0006\f1\"\u0019<s_N\u001b\u0007.Z7bA\u0005)1/\u001a;VaR\t1\b\u000b\u0002\fIB\u0011Q\r\\\u0007\u0002M*\u0011q\r[\u0001\u0004CBL'BA5k\u0003\u001dQW\u000f]5uKJT!a\u001b\u000e\u0002\u000b),h.\u001b;\n\u000554'A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000e\u000b\u0002\raB\u0011Q-]\u0005\u0003e\u001a\u0014\u0011\"\u00114uKJ,\u0015m\u00195\u0002=Q,7\u000f^*j]\u001edW\rS1tQ\u001aKW\r\u001c3t\u000bb\u0004(/Z:tS>tW#A\u001e)\u000551\bCA3x\u0013\tAhM\u0001\u0003UKN$\u0018!\b;fgRlU\u000f\u001c;ja2,\u0007*Y:i\r&,G\u000eZ:FqB\u0014Xm]:)\u000591\u0018A\f;fgRlU\u000f\u001c;ja2,\u0007*Y:i\r&,G\u000eZ:FqB\u0014Xm]:j_:<\u0016\u000e\u001e5D_6\u0004H.\u001a=LKf\fQ#\u001a=qe\n+8m[3u\u0003:\u001cx/\u001a:DQ\u0016\u001c7\u000e\u0006\u0005<}\u0006%\u0011\u0011EA\u001f\u0011\u0019y\b\u00031\u0001\u0002\u0002\u0005\u0011\"-^2lKRLe\u000eZ3y'V\u0004\bo\u001c:u!\u0011\t\u0019!!\u0002\u000e\u0003YI1!a\u0002\u0017\u0005I\u0011UoY6fi&sG-\u001a=TkB\u0004xN\u001d;\t\u000f\u0005-\u0001\u00031\u0001\u0002\u000e\u00059Q\r\u001f9s%\u0006<\b\u0003BA\b\u0003;qA!!\u0005\u0002\u001aA\u0019\u00111C\u001f\u000e\u0005\u0005U!bAA\f9\u00051AH]8pizJ1!a\u0007>\u0003\u0019\u0001&/\u001a3fM&\u0019Q*a\b\u000b\u0007\u0005mQ\bC\u0004\u0002$A\u0001\r!!\n\u0002\u0019\u0015D\b/Z2u%\u0016\u001cX\u000f\u001c;\u0011\r\u0005\u001d\u0012\u0011GA\u001c\u001d\u0011\tI#!\f\u000f\t\u0005M\u00111F\u0005\u0002}%\u0019\u0011qF\u001f\u0002\u000fA\f7m[1hK&!\u00111GA\u001b\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005=R\bE\u0002=\u0003sI1!a\u000f>\u0005\rIe\u000e\u001e\u0005\b\u0003\u007f\u0001\u0002\u0019AA!\u0003!1\u0017\r\u001c7cC\u000e\\\u0007c\u0001\u001f\u0002D%\u0019\u0011QI\u001f\u0003\u000f\t{w\u000e\\3b]\u00069R\r\u001f9s\r&dW\rU1uQ\u0006s7o^3s\u0007\",7m\u001b\u000b\fw\u0005-\u0013QJA(\u0003/\nY\u0006\u0003\u0004\u0000#\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003\u0017\t\u0002\u0019AA\u0007\u0011\u001d\t\u0019#\u0005a\u0001\u0003#\u0002b!a\u0004\u0002T\u00055\u0011\u0002BA+\u0003?\u00111aU3u\u0011\u001d\tI&\u0005a\u0001\u0003#\nQ\"\u00197m\r&dWm\u0015;biV\u001c\bbBA #\u0001\u0007\u0011\u0011I\u0001\u001bi\u0016\u001cHOQ;dW\u0016$\u0018+^3ss&\u001b\u0018I^1mS\u0006\u0014G.\u001a\u0015\u0003%YDs\u0001AA2\u0003S\nY\u0007E\u0002f\u0003KJ1!a\u001ag\u0005\r!\u0016mZ\u0001\u0006m\u0006dW/Z\u0011\u0002+\u0001")
public class TestBucketIndexSupport
extends HoodieSparkClientTestBase
implements PredicateHelper {
    private SparkSession spark;
    private final String avroSchemaStr;
    private final StructType structSchema;
    private final Schema avroSchema;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public String avroSchemaStr() {
        return this.avroSchemaStr;
    }

    public StructType structSchema() {
        return this.structSchema;
    }

    public Schema avroSchema() {
        return this.avroSchema;
    }

    @BeforeEach
    public void setUp() {
        this.initPath();
        this.initSparkContexts();
        this.setTableName("hoodie_test");
        this.initMetaClient();
        this.spark_$eq(this.sqlContext.sparkSession());
    }

    @AfterEach
    public void tearDown() {
        this.cleanupSparkContexts();
    }

    @Test
    public void testSingleHashFieldsExpression() {
        int bucketNumber = 19;
        TypedProperties configProperties = new TypedProperties();
        configProperties.setProperty(HoodieIndexConfig.BUCKET_INDEX_HASH_FIELD.key(), "A");
        configProperties.setProperty(HoodieTableConfig.RECORDKEY_FIELDS.key(), "A");
        configProperties.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "A");
        configProperties.setProperty(HoodieIndexConfig.BUCKET_INDEX_NUM_BUCKETS.key(), String.valueOf(bucketNumber));
        this.metaClient.getTableConfig().setValue(HoodieTableConfig.CREATE_SCHEMA.key(), this.avroSchemaStr());
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties((Properties)configProperties).enable(configProperties.getBoolean(HoodieMetadataConfig.ENABLE.key(), true)).build();
        BucketIndexSupport bucketIndexSupport = new BucketIndexSupport(this.spark(), metadataConfig, this.metaClient);
        KeyGenerator keyGenerator = bucketIndexSupport.getKeyGenerator();
        Predef$.MODULE$.assert(keyGenerator instanceof NonpartitionedKeyGenerator);
        NonpartitionedKeyGenerator testKeyGenerator = new NonpartitionedKeyGenerator(configProperties);
        GenericData.Record record = new GenericData.Record(this.avroSchema());
        record.put("A", (Object)"1");
        int bucket1Id4 = BucketIdentifier.getBucketId((HoodieKey)testKeyGenerator.getKey((GenericRecord)record), (String)"A", (int)bucketNumber);
        record = new GenericData.Record(this.avroSchema());
        record.put("A", (Object)"2");
        int bucket2Id5 = BucketIdentifier.getBucketId((HoodieKey)testKeyGenerator.getKey((GenericRecord)record), (String)"A", (int)bucketNumber);
        record = new GenericData.Record(this.avroSchema());
        record.put("A", (Object)"3");
        int bucket3Id6 = BucketIdentifier.getBucketId((HoodieKey)testKeyGenerator.getKey((GenericRecord)record), (String)"A", (int)bucketNumber);
        record = new GenericData.Record(this.avroSchema());
        record.put("A", (Object)"4");
        int bucket4Id7 = BucketIdentifier.getBucketId((HoodieKey)testKeyGenerator.getKey((GenericRecord)record), (String)"A", (int)bucketNumber);
        record = new GenericData.Record(this.avroSchema());
        record.put("A", (Object)"5");
        int bucket5Id8 = BucketIdentifier.getBucketId((HoodieKey)testKeyGenerator.getKey((GenericRecord)record), (String)"A", (int)bucketNumber);
        Predef$.MODULE$.assert(bucket1Id4 == 4 && bucket2Id5 == 5 && bucket3Id6 == 6 && bucket4Id7 == 7 && bucket5Id8 == 8);
        String token = FSUtils.makeWriteToken((int)1, (int)0, (long)1L);
        String bucket1Id4FileName = FSUtils.makeBaseFileName((String)"00000000000000000", (String)token, (String)new StringBuilder(2).append(BucketIdentifier.newBucketFileIdPrefix((int)bucket1Id4)).append("-0").toString(), (String)((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension());
        String bucket2Id5FileName = FSUtils.makeBaseFileName((String)"00000000000000000", (String)token, (String)new StringBuilder(2).append(BucketIdentifier.newBucketFileIdPrefix((int)bucket2Id5)).append("-0").toString(), (String)((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension());
        String bucket3Id6FileName = FSUtils.makeBaseFileName((String)"00000000000000000", (String)token, (String)new StringBuilder(2).append(BucketIdentifier.newBucketFileIdPrefix((int)bucket3Id6)).append("-0").toString(), (String)((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension());
        String bucket4Id7FileName = FSUtils.makeBaseFileName((String)"00000000000000000", (String)token, (String)new StringBuilder(2).append(BucketIdentifier.newBucketFileIdPrefix((int)bucket4Id7)).append("-0").toString(), (String)((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension());
        String bucket5Id8FileName = FSUtils.makeBaseFileName((String)"00000000000000000", (String)token, (String)new StringBuilder(2).append(BucketIdentifier.newBucketFileIdPrefix((int)bucket5Id8)).append("-0").toString(), (String)((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension());
        Set allFileNames = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{bucket1Id4FileName, bucket2Id5FileName, bucket3Id6FileName, bucket4Id7FileName, bucket5Id8FileName}));
        String equalTo = "A = 3";
        this.exprBucketAnswerCheck(bucketIndexSupport, equalTo, (List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{bucket3Id6})), false);
        this.exprFilePathAnswerCheck(bucketIndexSupport, equalTo, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{bucket3Id6FileName}))), (Set<String>)allFileNames, false);
        equalTo = "A = 3 And A = 4 and B = '6'";
        this.exprBucketAnswerCheck(bucketIndexSupport, equalTo, (List<Object>)List$.MODULE$.empty(), false);
        this.exprFilePathAnswerCheck(bucketIndexSupport, equalTo, (Set<String>)Predef$.MODULE$.Set().empty(), (Set<String>)allFileNames, false);
        equalTo = "A = 5 And B = 'abc'";
        this.exprBucketAnswerCheck(bucketIndexSupport, equalTo, (List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{bucket5Id8})), false);
        this.exprFilePathAnswerCheck(bucketIndexSupport, equalTo, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{bucket5Id8FileName}))), (Set<String>)allFileNames, false);
        equalTo = "A = C and A = 1";
        this.exprBucketAnswerCheck(bucketIndexSupport, equalTo, (List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{bucket1Id4})), false);
        this.exprFilePathAnswerCheck(bucketIndexSupport, equalTo, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{bucket1Id4FileName}))), (Set<String>)allFileNames, false);
        equalTo = "A = 5 Or A = 2";
        this.exprBucketAnswerCheck(bucketIndexSupport, equalTo, (List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{bucket5Id8, bucket2Id5})), false);
        this.exprFilePathAnswerCheck(bucketIndexSupport, equalTo, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{bucket5Id8FileName, bucket2Id5FileName}))), (Set<String>)allFileNames, false);
        equalTo = "A = 5 Or A = 2 Or A = 8";
        this.exprBucketAnswerCheck(bucketIndexSupport, equalTo, (List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{bucket5Id8, bucket2Id5})), false);
        this.exprFilePathAnswerCheck(bucketIndexSupport, equalTo, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{bucket5Id8FileName, bucket2Id5FileName}))), (Set<String>)allFileNames, false);
        equalTo = "A = 5 Or (A = 2 and B = 'abc')";
        this.exprBucketAnswerCheck(bucketIndexSupport, equalTo, (List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{bucket5Id8, bucket2Id5})), false);
        this.exprFilePathAnswerCheck(bucketIndexSupport, equalTo, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{bucket5Id8FileName, bucket2Id5FileName}))), (Set<String>)allFileNames, false);
        equalTo = "A = 5 And (A = 2 Or B = 'abc')";
        this.exprBucketAnswerCheck(bucketIndexSupport, equalTo, (List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{bucket5Id8})), false);
        this.exprFilePathAnswerCheck(bucketIndexSupport, equalTo, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{bucket5Id8FileName}))), (Set<String>)allFileNames, false);
        equalTo = "A = 5 And (A = 2 Or B = 'abc')";
        this.exprBucketAnswerCheck(bucketIndexSupport, equalTo, (List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{bucket5Id8})), false);
        this.exprFilePathAnswerCheck(bucketIndexSupport, equalTo, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{bucket5Id8FileName}))), (Set<String>)allFileNames, false);
        String inExpr = "A in (3)";
        this.exprBucketAnswerCheck(bucketIndexSupport, inExpr, (List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{bucket3Id6})), false);
        this.exprFilePathAnswerCheck(bucketIndexSupport, inExpr, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{bucket3Id6FileName}))), (Set<String>)allFileNames, false);
        inExpr = "A in (3, 5)";
        this.exprBucketAnswerCheck(bucketIndexSupport, inExpr, (List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{bucket3Id6, bucket5Id8})), false);
        this.exprFilePathAnswerCheck(bucketIndexSupport, inExpr, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{bucket3Id6FileName, bucket5Id8FileName}))), (Set<String>)allFileNames, false);
        String complexExpr = "A = 3 And A in (3)";
        this.exprBucketAnswerCheck(bucketIndexSupport, complexExpr, (List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{bucket3Id6})), false);
        this.exprFilePathAnswerCheck(bucketIndexSupport, complexExpr, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{bucket3Id6FileName}))), (Set<String>)allFileNames, false);
        complexExpr = "A = 3 Or A in (3, 5)";
        this.exprBucketAnswerCheck(bucketIndexSupport, complexExpr, (List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{bucket3Id6, bucket5Id8})), false);
        this.exprFilePathAnswerCheck(bucketIndexSupport, complexExpr, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{bucket3Id6FileName, bucket5Id8FileName}))), (Set<String>)allFileNames, false);
        complexExpr = "A = 3 Or A in (5, 2)";
        this.exprBucketAnswerCheck(bucketIndexSupport, complexExpr, (List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{bucket3Id6, bucket5Id8, bucket2Id5})), false);
        this.exprFilePathAnswerCheck(bucketIndexSupport, complexExpr, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{bucket3Id6FileName, bucket5Id8FileName, bucket2Id5FileName}))), (Set<String>)allFileNames, false);
        complexExpr = "A = 3 and C in (3, 5)";
        this.exprBucketAnswerCheck(bucketIndexSupport, complexExpr, (List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{bucket3Id6})), false);
        this.exprFilePathAnswerCheck(bucketIndexSupport, complexExpr, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{bucket3Id6FileName}))), (Set<String>)allFileNames, false);
        String fallBack = "B = 'abc'";
        this.exprBucketAnswerCheck(bucketIndexSupport, fallBack, (List<Object>)List$.MODULE$.empty(), true);
        fallBack = "A = 5 Or B = 'abc'";
        this.exprBucketAnswerCheck(bucketIndexSupport, fallBack, (List<Object>)List$.MODULE$.empty(), true);
        fallBack = "A = C";
        this.exprBucketAnswerCheck(bucketIndexSupport, fallBack, (List<Object>)List$.MODULE$.empty(), true);
        fallBack = "A = C and C = 1";
        this.exprBucketAnswerCheck(bucketIndexSupport, fallBack, (List<Object>)List$.MODULE$.empty(), true);
        fallBack = "C in (3)";
        this.exprBucketAnswerCheck(bucketIndexSupport, fallBack, (List<Object>)List$.MODULE$.empty(), true);
        fallBack = "A = 3 Or C in (3, 5)";
        this.exprBucketAnswerCheck(bucketIndexSupport, fallBack, (List<Object>)List$.MODULE$.empty(), true);
    }

    @Test
    public void testMultipleHashFieldsExpress() {
        int bucketNumber = 19;
        TypedProperties configProperties = new TypedProperties();
        configProperties.setProperty(HoodieIndexConfig.BUCKET_INDEX_HASH_FIELD.key(), "A,B");
        configProperties.setProperty(HoodieTableConfig.RECORDKEY_FIELDS.key(), "A,B");
        configProperties.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "A,B");
        configProperties.setProperty(HoodieIndexConfig.BUCKET_INDEX_NUM_BUCKETS.key(), String.valueOf(bucketNumber));
        this.metaClient.getTableConfig().setValue(HoodieTableConfig.CREATE_SCHEMA.key(), this.avroSchemaStr());
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties((Properties)configProperties).enable(configProperties.getBoolean(HoodieMetadataConfig.ENABLE.key(), true)).build();
        BucketIndexSupport bucketIndexSupport = new BucketIndexSupport(this.spark(), metadataConfig, this.metaClient);
        KeyGenerator keyGenerator = bucketIndexSupport.getKeyGenerator();
        Predef$.MODULE$.assert(keyGenerator instanceof NonpartitionedKeyGenerator);
        NonpartitionedKeyGenerator testKeyGenerator = new NonpartitionedKeyGenerator(configProperties);
        GenericData.Record record = new GenericData.Record(this.avroSchema());
        record.put("A", (Object)"1");
        record.put("B", (Object)"2");
        int bucket1Id4 = BucketIdentifier.getBucketId((HoodieKey)testKeyGenerator.getKey((GenericRecord)record), (String)"A,B", (int)bucketNumber);
        record = new GenericData.Record(this.avroSchema());
        record.put("A", (Object)"2");
        record.put("B", (Object)"3");
        int bucket2Id5 = BucketIdentifier.getBucketId((HoodieKey)testKeyGenerator.getKey((GenericRecord)record), (String)"A,B", (int)bucketNumber);
        record = new GenericData.Record(this.avroSchema());
        record.put("A", (Object)"3");
        record.put("B", (Object)"4");
        int bucket3Id6 = BucketIdentifier.getBucketId((HoodieKey)testKeyGenerator.getKey((GenericRecord)record), (String)"A,B", (int)bucketNumber);
        record = new GenericData.Record(this.avroSchema());
        record.put("A", (Object)"4");
        record.put("B", (Object)"5");
        int bucket4Id7 = BucketIdentifier.getBucketId((HoodieKey)testKeyGenerator.getKey((GenericRecord)record), (String)"A,B", (int)bucketNumber);
        record = new GenericData.Record(this.avroSchema());
        record.put("A", (Object)"5");
        record.put("B", (Object)"6");
        int bucket5Id8 = BucketIdentifier.getBucketId((HoodieKey)testKeyGenerator.getKey((GenericRecord)record), (String)"A,B", (int)bucketNumber);
        Predef$.MODULE$.assert(bucket1Id4 == 3 && bucket2Id5 == 16 && bucket3Id6 == 10 && bucket4Id7 == 4 && bucket5Id8 == 17);
        String token = FSUtils.makeWriteToken((int)1, (int)0, (long)1L);
        String bucket1Id4FileName = FSUtils.makeBaseFileName((String)"00000000000000000", (String)token, (String)new StringBuilder(2).append(BucketIdentifier.newBucketFileIdPrefix((int)bucket1Id4)).append("-0").toString(), (String)((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension());
        String bucket2Id5FileName = FSUtils.makeBaseFileName((String)"00000000000000000", (String)token, (String)new StringBuilder(2).append(BucketIdentifier.newBucketFileIdPrefix((int)bucket2Id5)).append("-0").toString(), (String)((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension());
        String bucket3Id6FileName = FSUtils.makeBaseFileName((String)"00000000000000000", (String)token, (String)new StringBuilder(2).append(BucketIdentifier.newBucketFileIdPrefix((int)bucket3Id6)).append("-0").toString(), (String)((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension());
        String bucket4Id7FileName = FSUtils.makeBaseFileName((String)"00000000000000000", (String)token, (String)new StringBuilder(2).append(BucketIdentifier.newBucketFileIdPrefix((int)bucket4Id7)).append("-0").toString(), (String)((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension());
        String bucket5Id8FileName = FSUtils.makeBaseFileName((String)"00000000000000000", (String)token, (String)new StringBuilder(2).append(BucketIdentifier.newBucketFileIdPrefix((int)bucket5Id8)).append("-0").toString(), (String)((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension());
        Set allFileNames = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{bucket1Id4FileName, bucket2Id5FileName, bucket3Id6FileName, bucket4Id7FileName, bucket5Id8FileName}));
        String equalTo = "A = 2 and B = '3'";
        this.exprBucketAnswerCheck(bucketIndexSupport, equalTo, (List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{bucket2Id5})), false);
        this.exprFilePathAnswerCheck(bucketIndexSupport, equalTo, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{bucket2Id5FileName}))), (Set<String>)allFileNames, false);
        equalTo = "A = 4 and B = '5'";
        this.exprBucketAnswerCheck(bucketIndexSupport, equalTo, (List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{bucket4Id7})), false);
        this.exprFilePathAnswerCheck(bucketIndexSupport, equalTo, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{bucket4Id7FileName}))), (Set<String>)allFileNames, false);
        String fallBack = "B = '5'";
        this.exprBucketAnswerCheck(bucketIndexSupport, fallBack, (List<Object>)List$.MODULE$.empty(), true);
        fallBack = "A = 3";
        this.exprBucketAnswerCheck(bucketIndexSupport, fallBack, (List<Object>)List$.MODULE$.empty(), true);
        fallBack = "A = 3 or B = '4'";
        this.exprBucketAnswerCheck(bucketIndexSupport, fallBack, (List<Object>)List$.MODULE$.empty(), true);
    }

    public void testMultipleHashFieldsExpressionWithComplexKey() {
        int bucketNumber = 19;
        TypedProperties configProperties = new TypedProperties();
        configProperties.setProperty(HoodieIndexConfig.BUCKET_INDEX_HASH_FIELD.key(), "A,B");
        configProperties.setProperty(HoodieTableConfig.RECORDKEY_FIELDS.key(), "A,B");
        configProperties.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "A,B");
        configProperties.setProperty(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), "C");
        configProperties.setProperty(HoodieIndexConfig.BUCKET_INDEX_NUM_BUCKETS.key(), String.valueOf(bucketNumber));
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties((Properties)configProperties).enable(configProperties.getBoolean(HoodieMetadataConfig.ENABLE.key(), true)).build();
        BucketIndexSupport bucketIndexSupport = new BucketIndexSupport(this.spark(), metadataConfig, this.metaClient);
        KeyGenerator keyGenerator = bucketIndexSupport.getKeyGenerator();
        Predef$.MODULE$.assert(keyGenerator instanceof ComplexKeyGenerator);
        ComplexKeyGenerator testKeyGenerator = new ComplexKeyGenerator(configProperties);
        GenericData.Record record = new GenericData.Record(this.avroSchema());
        record.put("A", (Object)"1");
        record.put("B", (Object)"2");
        int bucket1Id4 = BucketIdentifier.getBucketId((HoodieKey)testKeyGenerator.getKey((GenericRecord)record), (String)"A,B", (int)bucketNumber);
        record = new GenericData.Record(this.avroSchema());
        record.put("A", (Object)"2");
        record.put("B", (Object)"3");
        int bucket2Id5 = BucketIdentifier.getBucketId((HoodieKey)testKeyGenerator.getKey((GenericRecord)record), (String)"A,B", (int)bucketNumber);
        record = new GenericData.Record(this.avroSchema());
        record.put("A", (Object)"3");
        record.put("B", (Object)"4");
        int bucket3Id6 = BucketIdentifier.getBucketId((HoodieKey)testKeyGenerator.getKey((GenericRecord)record), (String)"A,B", (int)bucketNumber);
        record = new GenericData.Record(this.avroSchema());
        record.put("A", (Object)"4");
        record.put("B", (Object)"5");
        int bucket4Id7 = BucketIdentifier.getBucketId((HoodieKey)testKeyGenerator.getKey((GenericRecord)record), (String)"A,B", (int)bucketNumber);
        record = new GenericData.Record(this.avroSchema());
        record.put("A", (Object)"5");
        record.put("B", (Object)"6");
        int bucket5Id8 = BucketIdentifier.getBucketId((HoodieKey)testKeyGenerator.getKey((GenericRecord)record), (String)"A,B", (int)bucketNumber);
        Predef$.MODULE$.assert(bucket1Id4 == 3 && bucket2Id5 == 16 && bucket3Id6 == 10 && bucket4Id7 == 4 && bucket5Id8 == 17);
        String token = FSUtils.makeWriteToken((int)1, (int)0, (long)1L);
        String bucket1Id4FileName = FSUtils.makeBaseFileName((String)"00000000000000000", (String)token, (String)new StringBuilder(2).append(BucketIdentifier.newBucketFileIdPrefix((int)bucket1Id4)).append("-0").toString(), (String)((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension());
        String bucket2Id5FileName = FSUtils.makeBaseFileName((String)"00000000000000000", (String)token, (String)new StringBuilder(2).append(BucketIdentifier.newBucketFileIdPrefix((int)bucket2Id5)).append("-0").toString(), (String)((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension());
        String bucket3Id6FileName = FSUtils.makeBaseFileName((String)"00000000000000000", (String)token, (String)new StringBuilder(2).append(BucketIdentifier.newBucketFileIdPrefix((int)bucket3Id6)).append("-0").toString(), (String)((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension());
        String bucket4Id7FileName = FSUtils.makeBaseFileName((String)"00000000000000000", (String)token, (String)new StringBuilder(2).append(BucketIdentifier.newBucketFileIdPrefix((int)bucket4Id7)).append("-0").toString(), (String)((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension());
        String bucket5Id8FileName = FSUtils.makeBaseFileName((String)"00000000000000000", (String)token, (String)new StringBuilder(2).append(BucketIdentifier.newBucketFileIdPrefix((int)bucket5Id8)).append("-0").toString(), (String)((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension());
        Set allFileNames = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{bucket1Id4FileName, bucket2Id5FileName, bucket3Id6FileName, bucket4Id7FileName, bucket5Id8FileName}));
        String equalTo = "A = 2 and B = '3'";
        this.exprBucketAnswerCheck(bucketIndexSupport, equalTo, (List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{bucket2Id5})), false);
        this.exprFilePathAnswerCheck(bucketIndexSupport, equalTo, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{bucket2Id5FileName}))), (Set<String>)allFileNames, false);
        equalTo = "A = 4 and B = '5'";
        this.exprBucketAnswerCheck(bucketIndexSupport, equalTo, (List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{bucket4Id7})), false);
        this.exprFilePathAnswerCheck(bucketIndexSupport, equalTo, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{bucket4Id7FileName}))), (Set<String>)allFileNames, false);
        String fallBack = "B = '5'";
        this.exprBucketAnswerCheck(bucketIndexSupport, fallBack, (List<Object>)List$.MODULE$.empty(), true);
        fallBack = "A = 3";
        this.exprBucketAnswerCheck(bucketIndexSupport, fallBack, (List<Object>)List$.MODULE$.empty(), true);
        fallBack = "A = 3 or B = '4'";
        this.exprBucketAnswerCheck(bucketIndexSupport, fallBack, (List<Object>)List$.MODULE$.empty(), true);
    }

    public void exprBucketAnswerCheck(BucketIndexSupport bucketIndexSupport, String exprRaw, List<Object> expectResult, boolean fallback) {
        Expression resolveExpr = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr(this.spark(), exprRaw, this.structSchema());
        LogicalPlan optimizerPlan = (LogicalPlan)this.spark().sessionState().optimizer().execute((TreeNode)new DummyExpressionHolder((Seq)new .colon.colon((Object)resolveExpr, (List)Nil$.MODULE$)));
        Expression optimizerExpr = (Expression)((DummyExpressionHolder)optimizerPlan).exprs().head();
        Option bucketSet = bucketIndexSupport.filterQueriesWithBucketHashField(this.splitConjunctivePredicates(optimizerExpr));
        if (fallback) {
            Predef$.MODULE$.assert(bucketSet.isEmpty());
        }
        if (expectResult.nonEmpty()) {
            Predef$.MODULE$.assert(bucketSet.isDefined());
            expectResult.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)expectId -> Predef$.MODULE$.assert(((BitSet)bucketSet.get()).get(expectId)));
            return;
        }
        Predef$.MODULE$.assert(bucketSet.isEmpty() || ((BitSet)bucketSet.get()).cardinality() == 0);
    }

    public void exprFilePathAnswerCheck(BucketIndexSupport bucketIndexSupport, String exprRaw, Set<String> expectResult, Set<String> allFileStatus, boolean fallback) {
        Expression resolveExpr = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr(this.spark(), exprRaw, this.structSchema());
        LogicalPlan optimizerPlan = (LogicalPlan)this.spark().sessionState().optimizer().execute((TreeNode)new DummyExpressionHolder((Seq)new .colon.colon((Object)resolveExpr, (List)Nil$.MODULE$)));
        Expression optimizerExpr = (Expression)((DummyExpressionHolder)optimizerPlan).exprs().head();
        Option bucketSet = bucketIndexSupport.filterQueriesWithBucketHashField(this.splitConjunctivePredicates(optimizerExpr));
        if (fallback) {
            Predef$.MODULE$.assert(bucketSet.isEmpty());
        }
        if (expectResult.nonEmpty()) {
            Predef$.MODULE$.assert(bucketSet.isDefined());
            Set candidateFiles = bucketIndexSupport.getCandidateFiles(allFileStatus, (BitSet)bucketSet.get());
            Set<String> set = expectResult;
            Set set2 = candidateFiles;
            Predef$.MODULE$.assert(!(set != null ? !set.equals((Object)set2) : set2 != null));
            return;
        }
        Predef$.MODULE$.assert(bucketSet.isEmpty() || ((BitSet)bucketSet.get()).cardinality() == 0);
    }

    @Test
    public void testBucketQueryIsAvaliable() {
        TypedProperties configProperties = new TypedProperties();
        configProperties.setProperty(HoodieTableConfig.RECORDKEY_FIELDS.key(), "A");
        configProperties.setProperty(HoodieIndexConfig.INDEX_TYPE.key(), "BUCKET");
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties((Properties)configProperties).enable(configProperties.getBoolean(HoodieMetadataConfig.ENABLE.key(), false)).build();
        BucketIndexSupport bucketIndexSupport = new BucketIndexSupport(this.spark(), metadataConfig, this.metaClient);
        Predef$.MODULE$.assert(bucketIndexSupport.isIndexAvailable());
        metadataConfig.setValue(HoodieTableConfig.RECORDKEY_FIELDS.key(), "A,B");
        Predef$.MODULE$.assert(bucketIndexSupport.isIndexAvailable());
        metadataConfig.setValue(HoodieIndexConfig.BUCKET_INDEX_HASH_FIELD.key(), "A");
        Predef$.MODULE$.assert(bucketIndexSupport.isIndexAvailable());
        metadataConfig.setValue(HoodieIndexConfig.INDEX_TYPE.key(), "SIMPLE");
        Predef$.MODULE$.assert(!bucketIndexSupport.isIndexAvailable());
        metadataConfig.setValue(HoodieIndexConfig.INDEX_TYPE.key(), "BUCKET");
        Predef$.MODULE$.assert(bucketIndexSupport.isIndexAvailable());
        metadataConfig.setValue(HoodieIndexConfig.BUCKET_INDEX_ENGINE_TYPE, HoodieIndex.BucketIndexEngineType.CONSISTENT_HASHING.name());
        Predef$.MODULE$.assert(!bucketIndexSupport.isIndexAvailable());
        metadataConfig.setValue(HoodieIndexConfig.BUCKET_INDEX_ENGINE_TYPE, HoodieIndex.BucketIndexEngineType.SIMPLE.name());
        Predef$.MODULE$.assert(bucketIndexSupport.isIndexAvailable());
        metadataConfig.setValue(HoodieIndexConfig.BUCKET_QUERY_INDEX, "false");
        Predef$.MODULE$.assert(!bucketIndexSupport.isIndexAvailable());
        metadataConfig.setValue(HoodieIndexConfig.BUCKET_QUERY_INDEX, "true");
        Predef$.MODULE$.assert(bucketIndexSupport.isIndexAvailable());
    }

    public TestBucketIndexSupport() {
        AliasHelper.$init$((AliasHelper)this);
        Logging.$init$((Logging)this);
        PredicateHelper.$init$((PredicateHelper)this);
        this.avroSchemaStr = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"logicalTypes\",\"fields\": [{\"name\": \"A\", \"type\": [\"null\", \"long\"], \"default\": null},{\"name\": \"B\", \"type\": [\"null\", \"string\"], \"default\": null},{\"name\": \"C\", \"type\": [\"null\", \"long\"], \"default\": null},{\"name\": \"D\", \"type\": [\"null\", \"string\"], \"default\": null}]}";
        this.structSchema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("A", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("B", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("C", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("D", (DataType)new VarcharType(32), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
        this.avroSchema = new Schema.Parser().parse(this.avroSchemaStr());
    }
}

