/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.client.validator.SqlQueryEqualityPreCommitValidator;
import org.apache.hudi.client.validator.SqlQueryInequalityPreCommitValidator;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TimestampKeyGeneratorConfig;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.config.HoodiePreCommitValidatorConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.exception.HoodieValidationException;
import org.apache.hudi.functional.TestCOWDataSourceStorage$;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.TimestampBasedKeyGenerator;
import org.apache.hudi.testutils.DataSourceTestUtils;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Tag(value="functional")
@ScalaSignature(bytes="\u0006\u0001\tEb\u0001\u0002\u0011\"\u0001)BQ!\r\u0001\u0005\u0002IBq!\u000e\u0001A\u0002\u0013\u0005a\u0007C\u0004J\u0001\u0001\u0007I\u0011\u0001&\t\rE\u0003\u0001\u0015)\u00038\u0011\u001d\u0011\u0006A1A\u0005\u0002MCaA\u0018\u0001!\u0002\u0013!\u0006bB0\u0001\u0005\u0004%\ta\u0015\u0005\u0007A\u0002\u0001\u000b\u0011\u0002+\t\u000b\u0005\u0004A\u0011\t2\t\u000b%\u0004A\u0011\u00016\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u00111\n\u0001\u0005\u0002\u00055\u0003bBA<\u0001\u0011\u0005\u0011\u0011\u0010\u0005\b\u0003\u001f\u0003A\u0011AAI\u0011\u001d\t)\f\u0001C\u0001\u0003o;q!!5\"\u0011\u0003\t\u0019N\u0002\u0004!C!\u0005\u0011Q\u001b\u0005\u0007cE!\t!!8\t\u0013\u0005}\u0017C1A\u0005\u000e\u0005\u0005\bbBAr#\u0001\u0006i!\u0011\u0005\n\u0003K\f\"\u0019!C\u0007\u0003CDq!a:\u0012A\u00035\u0011\tC\u0005\u0002jF\u0011\r\u0011\"\u0004\u0002l\"A\u00111_\t!\u0002\u001b\ti\u000fC\u0005\u0002vF\u0011\r\u0011\"\u0004\u0002x\"A\u0011q`\t!\u0002\u001b\tI\u0010C\u0005\u0003\u0002E\u0011\r\u0011\"\u0004\u0003\u0004!A!1B\t!\u0002\u001b\u0011)\u0001C\u0005\u0003\u000eE\u0011\r\u0011\"\u0004\u0003\u0010!A!qC\t!\u0002\u001b\u0011\t\u0002C\u0004\u0002tE!\tA!\u0007\u00031Q+7\u000f^\"P/\u0012\u000bG/Y*pkJ\u001cWm\u0015;pe\u0006<WM\u0003\u0002#G\u0005Qa-\u001e8di&|g.\u00197\u000b\u0005\u0011*\u0013\u0001\u00025vI&T!AJ\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0013aA8sO\u000e\u00011C\u0001\u0001,!\tas&D\u0001.\u0015\tq3%A\u0005uKN$X\u000f^5mg&\u0011\u0001'\f\u0002!'B\f'o[\"mS\u0016tGOR;oGRLwN\\1m)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002gA\u0011A\u0007A\u0007\u0002C\u0005Q1m\\7n_:|\u0005\u000f^:\u0016\u0003]\u0002B\u0001O B\u00036\t\u0011H\u0003\u0002;w\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003yu\n!bY8mY\u0016\u001cG/[8o\u0015\u0005q\u0014!B:dC2\f\u0017B\u0001!:\u0005\ri\u0015\r\u001d\t\u0003\u0005\u001ek\u0011a\u0011\u0006\u0003\t\u0016\u000bA\u0001\\1oO*\ta)\u0001\u0003kCZ\f\u0017B\u0001%D\u0005\u0019\u0019FO]5oO\u0006q1m\\7n_:|\u0005\u000f^:`I\u0015\fHCA&P!\taU*D\u0001>\u0013\tqUH\u0001\u0003V]&$\bb\u0002)\u0004\u0003\u0003\u0005\raN\u0001\u0004q\u0012\n\u0014aC2p[6|gn\u00149ug\u0002\nqB^3sS\u001aL7-\u0019;j_:\u001cu\u000e\\\u000b\u0002)B\u0011Q\u000b\u0018\b\u0003-j\u0003\"aV\u001f\u000e\u0003aS!!W\u0015\u0002\rq\u0012xn\u001c;?\u0013\tYV(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0011vS!aW\u001f\u0002!Y,'/\u001b4jG\u0006$\u0018n\u001c8D_2\u0004\u0013AF;qI\u0006$X\r\u001a,fe&4\u0017nY1uS>tg+\u00197\u0002/U\u0004H-\u0019;fIZ+'/\u001b4jG\u0006$\u0018n\u001c8WC2\u0004\u0013\u0001B2p]\u001a$\u0012a\u0019\t\u0003I\u001el\u0011!\u001a\u0006\u0003M\u0016\nQa\u001d9be.L!\u0001[3\u0003\u0013M\u0003\u0018M]6D_:4\u0017A\u0006;fgR\u001cu\u000e]=P]^\u0013\u0018\u000e^3Ti>\u0014\u0018mZ3\u0015\t-[\u0007O\u001d\u0005\u0006Y*\u0001\r!\\\u0001\u0012SNlU\r^1eCR\fWI\\1cY\u0016$\u0007C\u0001'o\u0013\tyWHA\u0004C_>dW-\u00198\t\u000bET\u0001\u0019\u0001+\u0002\u0017-,\u0017pR3o\u00072\f7o\u001d\u0005\u0006g*\u0001\r\u0001V\u0001\u000be\u0016\u001cwN\u001d3LKf\u001c\bF\u0003\u0006v\u0003\u0007\t)!a\b\u0002\"A\u0011ao`\u0007\u0002o*\u0011\u00010_\u0001\taJ|g/\u001b3fe*\u0011!p_\u0001\u0007a\u0006\u0014\u0018-\\:\u000b\u0005ql\u0018a\u00026va&$XM\u001d\u0006\u0003}\u001e\nQA[;oSRL1!!\u0001x\u0005%\u00195O^*pkJ\u001cW-A\u0003wC2,X\r\f\u0007\u0002\b\u0005-\u0011qBA\n\u0003/\tY\"\t\u0002\u0002\n\u00059DO];fy>\u0014xML1qC\u000eDWM\f5vI&t3.Z=hK:t3+[7qY\u0016\\U-_$f]\u0016\u0014\u0018\r^8sy~\u0013xn^0lKf\f#!!\u0004\u0002\rR\u0014X/\u001a?pe\u001et\u0013\r]1dQ\u0016t\u0003.\u001e3j]-,\u0017pZ3o]\r{W\u000e\u001d7fq.+\u0017pR3oKJ\fGo\u001c:}?J|woX6fs22\u0017M]3/GV\u0014(/\u001a8ds\u0006\u0012\u0011\u0011C\u0001@iJ,X\r`8sO:\n\u0007/Y2iK:BW\u000fZ5/W\u0016Lx-\u001a8/)&lWm\u001d;b[B\u0014\u0015m]3e\u0017\u0016Lx)\u001a8fe\u0006$xN\u001d?`e><xl[3zC\t\t)\"\u0001\u001dgC2\u001cX\r`8sO:\n\u0007/Y2iK:BW\u000fZ5/W\u0016Lx-\u001a8/'&l\u0007\u000f\\3LKf<UM\\3sCR|'\u000f`0s_^|6.Z=\"\u0005\u0005e\u0011a\u00124bYN,Gp\u001c:h]\u0005\u0004\u0018m\u00195f]!,H-\u001b\u0018lKf<WM\u001c\u0018D_6\u0004H.\u001a=LKf<UM\\3sCR|'\u000f`0s_^|6.Z=-M\u0006\u0014XML2veJ,gnY=\"\u0005\u0005u\u0011\u0001\u00114bYN,Gp\u001c:h]\u0005\u0004\u0018m\u00195f]!,H-\u001b\u0018lKf<WM\u001c\u0018US6,7\u000f^1na\n\u000b7/\u001a3LKf<UM\\3sCR|'\u000f`0s_^|6.Z=\u0002\u0013\u0011,G.[7ji\u0016\u0014H$\u0001?)\u0007)\t)\u0003\u0005\u0003\u0002(\u0005%R\"A=\n\u0007\u0005-\u0012PA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fA\u0005^3ti\u0006\u00138\r[5wC2<\u0016\u000e\u001e5SKBd\u0017mY3D_6l\u0017\u000e^!di&|gn\u001d\u000b\u0004\u0017\u0006E\u0002BBA\u001a\u0017\u0001\u0007A+\u0001\bxe&$Xm\u00149fe\u0006$\u0018n\u001c8)\u000f-\t9$!\u0010\u0002@A\u0019a/!\u000f\n\u0007\u0005mrOA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0005\u0003\u0003\n)%\t\u0002\u0002D\u0005\u0001\u0012N\\:feR|vN^3soJLG/Z\u0011\u0003\u0003\u000f\n\u0001\u0003Z3mKR,w\f]1si&$\u0018n\u001c8)\u0007-\t)#A\u001buKN$\bK]3D_6l\u0017\u000e\u001e,bY&$\u0017\r^5p]^KG\u000f[*R\u0019F+XM]=FcV\fG.\u001b;z\u0013:,\u0017/^1mSRLHcC&\u0002P\u0005M\u0013qKA0\u0003GBa!!\u0015\r\u0001\u0004!\u0016a\u00079sK\u000e{W.\\5u-\u0006d\u0017\u000eZ1u_J\u001cE.Y:t\u001d\u0006lW\r\u0003\u0004\u0002V1\u0001\r\u0001V\u0001\tgFd\u0017+^3ss\"9\u0011\u0011\f\u0007A\u0002\u0005m\u0013AE5t)\u0006\u0014G.\u001a)beRLG/[8oK\u0012\u00042AQA/\u0013\ty7\tC\u0004\u0002b1\u0001\r!a\u0017\u000211\f7\u000f^,sSR,\u0017J\\*b[\u0016\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002f1\u0001\r!a\u0017\u0002\u001bMDw.\u001e7e'V\u001c7-Z3eQ\u001da\u0011\u0011NA\u0002\u0003_\u00022A^A6\u0013\r\tig\u001e\u0002\r\u001b\u0016$\bn\u001c3T_V\u00148-\u001a\u0017\u0003\u0003c\n#!a\u001d\u0002-Q,7\u000f^*rYZ\u000bG.\u001b3bi>\u0014\b+\u0019:b[ND3\u0001DA\u0013\u0003\t\n7o]3siRC'o\\<t/&$\b\u000e\u0015:f\u0007>lW.\u001b;WC2LG-\u0019;peR\u00191*a\u001f\t\u000f\u0005uT\u00021\u0001\u0002\u0000\u0005QQ\r_3dkR\f'\r\\3\u0011\t\u0005\u0005\u00151R\u0007\u0003\u0003\u0007SA!!\"\u0002\b\u0006Aa-\u001e8di&|gNC\u0002\u0002\nn\f1!\u00199j\u0013\u0011\ti)a!\u0003\u0015\u0015CXmY;uC\ndW-\u0001\u0007xe&$XMU3d_J$7\u000fF\u0005L\u0003'\u000bi*a,\u00022\"9\u0011Q\u0013\bA\u0002\u0005]\u0015AC2p[6LG\u000fV5nKB\u0019A*!'\n\u0007\u0005mUHA\u0002J]RDq!a(\u000f\u0001\u0004\t\t+A\u0004eCR\fw)\u001a8\u0011\t\u0005\r\u00161V\u0007\u0003\u0003KS1ALAT\u0015\r\tIkI\u0001\u0007G>lWn\u001c8\n\t\u00055\u0016Q\u0015\u0002\u0018\u0011>|G-[3UKN$H)\u0019;b\u000f\u0016tWM]1u_JDa!a\r\u000f\u0001\u0004!\u0006BBAZ\u001d\u0001\u0007A+\u0001\u0005cCN,\u0007+\u0019;i\u0003E\t7o]3siJ+7m\u001c:e\u0007>,h\u000e\u001e\u000b\u0006\u0017\u0006e\u00161\u0018\u0005\u0007\u0003g{\u0001\u0019\u0001+\t\u000f\u0005uv\u00021\u0001\u0002@\u0006\u0019R\r\u001f9fGR,GMU3d_J$7i\\;oiB\u0019A*!1\n\u0007\u0005\rWH\u0001\u0003M_:<\u0007f\u0002\u0001\u0002H\u0006\r\u0011q\u001a\t\u0005\u0003\u0013\fY-\u0004\u0002\u0002\b&!\u0011QZAD\u0005\r!\u0016mZ\u0011\u0002E\u0005AB+Z:u\u0007>;F)\u0019;b'>,(oY3Ti>\u0014\u0018mZ3\u0011\u0005Q\n2cA\t\u0002XB\u0019A*!7\n\u0007\u0005mWH\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003'\fqeU)M?F+VIU-`\u000bF+\u0016\tT%U3~3\u0016\tT%E\u0003R{%kX\"M\u0003N\u001bvLT!N\u000bV\t\u0011)\u0001\u0015T#2{\u0016+V#S3~+\u0015+V!M\u0013RKvLV!M\u0013\u0012\u000bEk\u0014*`\u00072\u000b5kU0O\u00036+\u0005%A\u0015T#2{\u0016+V#S3~Ke*R)V\u00032KE+W0W\u00032KE)\u0011+P%~\u001bE*Q*T?:\u000bU*R\u0001+'Fcu,U+F%f{\u0016JT#R+\u0006c\u0015\nV-`-\u0006c\u0015\nR!U\u001fJ{6\tT!T'~s\u0015)T#!\u0003I\u0019\u0016\u000bT0E%&3VIU0J'~sU\u000b\u0014'\u0016\u0005\u00055xBAAxC\t\t\t0\u0001\u001ctK2,7\r\u001e\u0011d_VtG\u000f\u000b\u0016*A\u0019\u0014x.\u001c\u0011=)\u0006\u0013E*R0O\u00036+e\bI<iKJ,\u0007\u0005\u001a:jm\u0016\u0014\b%[:!]VdG.A\nT#2{FIU%W\u000bJ{\u0016jU0O+2c\u0005%A\tT#2{&+\u0013#F%~K5k\u0018(V\u00192+\"!!?\u0010\u0005\u0005m\u0018EAA\u007f\u0003U\u001aX\r\\3di\u0002\u001aw.\u001e8uQ)J\u0003E\u001a:p[\u0002bD+\u0011\"M\u000b~s\u0015)T#?A]DWM]3!e&$WM\u001d\u0011jg\u0002rW\u000f\u001c7\u0002%M\u000bFj\u0018*J\t\u0016\u0013v,S*`\u001dVcE\nI\u0001\u0017'Fcu\f\u0012*J-\u0016\u0013v,S*`\u001d>#vLT+M\u0019V\u0011!QA\b\u0003\u0005\u000f\t#A!\u0003\u0002uM,G.Z2uA\r|WO\u001c;)U%\u0002cM]8nAq\"\u0016I\u0011'F?:\u000bU*\u0012 !o\",'/\u001a\u0011ee&4XM\u001d\u0011jg\u0002rw\u000e\u001e\u0011ok2d\u0017aF*R\u0019~#%+\u0013,F%~K5k\u0018(P)~sU\u000b\u0014'!\u0003U\u0019\u0016\u000bT0S\u0013\u0012+%kX%T?:{Ek\u0018(V\u00192+\"A!\u0005\u0010\u0005\tM\u0011E\u0001B\u000b\u0003e\u001aX\r\\3di\u0002\u001aw.\u001e8uQ)J\u0003E\u001a:p[\u0002bD+\u0011\"M\u000b~s\u0015)T#?A]DWM]3!e&$WM\u001d\u0011jg\u0002rw\u000e\u001e\u0011ok2d\u0017AF*R\u0019~\u0013\u0016\nR#S?&\u001bvLT(U?:+F\n\u0014\u0011\u0015\u0005\tm\u0001C\u0002B\u000f\u0005O\u0011Y#\u0004\u0002\u0003 )!!\u0011\u0005B\u0012\u0003\u0019\u0019HO]3b[*\u0019!QE#\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005S\u0011yB\u0001\u0004TiJ,\u0017-\u001c\t\u0004m\n5\u0012b\u0001B\u0018o\nI\u0011I]4v[\u0016tGo\u001d")
public class TestCOWDataSourceStorage
extends SparkClientFunctionalTestHarness {
    private scala.collection.immutable.Map<String, String> commonOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.bulkinsert.shuffle.parallelism"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.delete.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key()), (Object)"false")}));
    private final String verificationCol;
    private final String updatedVerificationVal;

    public static Stream<Arguments> testSqlValidatorParams() {
        return TestCOWDataSourceStorage$.MODULE$.testSqlValidatorParams();
    }

    public scala.collection.immutable.Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    public void commonOpts_$eq(scala.collection.immutable.Map<String, String> x$1) {
        this.commonOpts = x$1;
    }

    public String verificationCol() {
        return this.verificationCol;
    }

    public String updatedVerificationVal() {
        return this.updatedVerificationVal;
    }

    public SparkConf conf() {
        return this.conf(SparkClientFunctionalTestHarness.getSparkSqlConf());
    }

    @ParameterizedTest
    @CsvSource(value={"true|org.apache.hudi.keygen.SimpleKeyGenerator|_row_key", "true|org.apache.hudi.keygen.ComplexKeyGenerator|_row_key,fare.currency", "true|org.apache.hudi.keygen.TimestampBasedKeyGenerator|_row_key", "false|org.apache.hudi.keygen.SimpleKeyGenerator|_row_key", "false|org.apache.hudi.keygen.ComplexKeyGenerator|_row_key,fare.currency", "false|org.apache.hudi.keygen.TimestampBasedKeyGenerator|_row_key"}, delimiter=124)
    public void testCopyOnWriteStorage(boolean isMetadataEnabled, String keyGenClass, String recordKeys) {
        scala.collection.immutable.Map options = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)String.valueOf(isMetadataEnabled)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)keyGenClass), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)recordKeys), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.SCHEMA_ALLOW_AUTO_EVOLUTION_COLUMN_DROP.key()), (Object)"true")})));
        boolean isTimestampBasedKeyGen = TimestampBasedKeyGenerator.class.getName().equals(keyGenClass);
        if (isTimestampBasedKeyGen) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"));
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimestampKeyGeneratorConfig.TIMESTAMP_TYPE_FIELD.key()), (Object)"DATE_STRING"));
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimestampKeyGeneratorConfig.TIMESTAMP_INPUT_DATE_FORMAT.key()), (Object)"yyyy/MM/dd"));
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimestampKeyGeneratorConfig.TIMESTAMP_OUTPUT_DATE_FORMAT.key()), (Object)"yyyyMMdd"));
        }
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(57069L);
        FileSystem fs = HadoopFSUtils.getFs((String)this.basePath(), (Configuration)this.spark().sparkContext().hadoopConfiguration());
        List records0 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(100)))).asScala()).toList();
        Dataset inputDF0 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records0, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF0.write().format("org.apache.hudi").options((Map)options).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath());
        String completionTime1 = DataSourceTestUtils.latestCommitCompletionTime(fs, this.basePath());
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)fs, (String)this.basePath(), (String)"000"));
        Dataset snapshotDF1 = this.spark().read().format("org.apache.hudi").option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).load(this.basePath());
        Assertions.assertEquals((long)100L, (long)snapshotDF1.count());
        List records1 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateUpdates("001", Predef$.MODULE$.int2Integer(100)))).asScala()).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        String verificationRowKey = ((Row)inputDF1.limit(1).select("_row_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first()).getString(0);
        Dataset updateDf = null;
        if (isTimestampBasedKeyGen) {
            Row originalRow = (Row)snapshotDF1.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)verificationRowKey)).collectAsList().get(0);
            updateDf = inputDF1.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)verificationRowKey)).withColumn(this.verificationCol(), functions$.MODULE$.lit((Object)this.updatedVerificationVal())).withColumn("current_ts", functions$.MODULE$.lit(originalRow.getAs("current_ts"))).limit(1);
            Row updatedRow = (Row)updateDf.collectAsList().get(0);
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)originalRow.getAs("current_ts")), (long)BoxesRunTime.unboxToLong((Object)updatedRow.getAs("current_ts")));
        } else {
            updateDf = snapshotDF1.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)verificationRowKey)).withColumn(this.verificationCol(), functions$.MODULE$.lit((Object)this.updatedVerificationVal()));
        }
        updateDf.write().format("org.apache.hudi").options((Map)options).mode(SaveMode.Append).save(this.basePath());
        Dataset snapshotDF2 = this.spark().read().format("hudi").option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).load(this.basePath());
        Assertions.assertEquals((long)100L, (long)snapshotDF2.count());
        Assertions.assertEquals((Object)this.updatedVerificationVal(), (Object)((Row)snapshotDF2.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)verificationRowKey)).select(this.verificationCol(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first()).getString(0));
        List records2 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateUpdates("002", Predef$.MODULE$.int2Integer(100)))).asScala()).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        if (isTimestampBasedKeyGen) {
            Dataset inputDF2WithTempCols = inputDF2.withColumn("current_ts_temp", functions$.MODULE$.col("current_ts")).withColumn("_row_key_temp", functions$.MODULE$.col("_row_key"));
            Dataset originalRowCurrentTsDf = inputDF0.select("_row_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current_ts"}));
            Dataset joinedDf = inputDF2WithTempCols.drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_row_key", "current_ts"})).join(originalRowCurrentTsDf, inputDF2WithTempCols.apply("_row_key_temp").$eq$eq$eq((Object)originalRowCurrentTsDf.apply("_row_key")));
            inputDF2 = joinedDf.withColumn("current_ts_temp", functions$.MODULE$.col("current_ts")).drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current_ts", "_row_key_temp"})).withColumn("current_ts", functions$.MODULE$.col("current_ts_temp")).drop("current_ts_temp");
        }
        long uniqueKeyCnt = inputDF2.select("_row_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count();
        inputDF2.write().format("org.apache.hudi").options((Map)options).mode(SaveMode.Append).save(this.basePath());
        String commitInstantTime3 = HoodieDataSourceHelpers.latestCommit((FileSystem)fs, (String)this.basePath());
        String completionTime3 = DataSourceTestUtils.latestCommitCompletionTime(fs, this.basePath());
        Assertions.assertEquals((int)3, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)fs, (String)this.basePath(), (String)"000").size());
        Dataset snapshotDF3 = this.spark().read().format("org.apache.hudi").option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).load(this.basePath());
        Assertions.assertEquals((long)100L, (long)snapshotDF3.count());
        String firstCommit = (String)HoodieDataSourceHelpers.listCommitsSince((FileSystem)fs, (String)this.basePath(), (String)"000").get(0);
        this.spark().sparkContext().hadoopConfiguration().set("mapreduce.input.pathFilter.class", "org.apache.hudi.hadoop.HoodieROTablePathFilter");
        Dataset hoodieIncViewDF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.START_COMMIT().key(), completionTime1).option(DataSourceReadOptions$.MODULE$.END_COMMIT().key(), completionTime1).load(this.basePath());
        Assertions.assertEquals((long)100L, (long)hoodieIncViewDF1.count());
        this.spark().sparkContext().hadoopConfiguration().unset("mapreduce.input.pathFilter.class");
        Row[] countsPerCommit = (Row[])hoodieIncViewDF1.groupBy("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().collect();
        Assertions.assertEquals((int)1, (int)countsPerCommit.length);
        Assertions.assertEquals((Object)firstCommit, (Object)countsPerCommit[0].get(0));
        Dataset emptyIncDF = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.START_COMMIT().key(), "000").option(DataSourceReadOptions$.MODULE$.END_COMMIT().key(), "002").load(this.basePath());
        Assertions.assertEquals((long)0L, (long)emptyIncDF.count());
        List emptyRecords = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateUpdates("003", Predef$.MODULE$.int2Integer(0)))).asScala()).toList();
        Dataset emptyDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)emptyRecords, 1, ClassTag$.MODULE$.apply(String.class)));
        emptyDF.write().format("org.apache.hudi").options((Map)options).mode(SaveMode.Append).save(this.basePath());
        Dataset hoodieIncViewDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.START_COMMIT().key(), completionTime3).load(this.basePath());
        Assertions.assertEquals((long)uniqueKeyCnt, (long)hoodieIncViewDF2.count());
        countsPerCommit = (Row[])hoodieIncViewDF2.groupBy("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().collect();
        Assertions.assertEquals((int)1, (int)countsPerCommit.length);
        Assertions.assertEquals((Object)commitInstantTime3, (Object)countsPerCommit[0].get(0));
        Dataset hoodieIncViewDF3 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.START_COMMIT().key(), completionTime3).option(DataSourceReadOptions$.MODULE$.INCR_PATH_GLOB().key(), isTimestampBasedKeyGen ? "/2016*/*" : "/2016/*/*/*").load(this.basePath());
        Assertions.assertEquals((long)hoodieIncViewDF2.filter(functions$.MODULE$.col("_hoodie_partition_path").startsWith("2016")).count(), (long)hoodieIncViewDF3.count());
        Dataset timeTravelDF = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.START_COMMIT().key(), completionTime1).option(DataSourceReadOptions$.MODULE$.END_COMMIT().key(), completionTime1).load(this.basePath());
        Assertions.assertEquals((long)100L, (long)timeTravelDF.count());
    }

    @ParameterizedTest
    @ValueSource(strings={"insert_overwrite", "delete_partition"})
    public void testArchivalWithReplaceCommitActions(String writeOperation) {
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator();
        HoodieTestDataGenerator dataGenPartition1 = new HoodieTestDataGenerator((String[])((Object[])new String[]{"2016/03/15"}));
        HoodieTestDataGenerator dataGenPartition2 = new HoodieTestDataGenerator((String[])((Object[])new String[]{"2015/03/16"}));
        List records = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateInserts(new StringOps(Predef$.MODULE$.augmentString("%05d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), Predef$.MODULE$.int2Integer(100)))).asScala()).toList();
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        long partition1RecordCount = inputDF.filter((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)TestCOWDataSourceStorage.$anonfun$testArchivalWithReplaceCommitActions$1(row))).count();
        inputDF.write().format("hudi").options(this.commonOpts()).option("hoodie.keep.min.commits", "2").option("hoodie.keep.max.commits", "3").option("hoodie.clean.commits.retained", "1").option("hoodie.metadata.enable", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath());
        this.assertRecordCount(this.basePath(), 100L);
        this.writeRecords(2, dataGenPartition1, writeOperation, this.basePath());
        long expectedRecCount = writeOperation.equals(DataSourceWriteOptions$.MODULE$.INSERT_OVERWRITE_OPERATION_OPT_VAL()) ? 200L - partition1RecordCount : 100L - partition1RecordCount;
        this.assertRecordCount(this.basePath(), expectedRecCount);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(3), 7).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.writeRecords(i, dataGenPartition2, DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL(), this.basePath()));
        this.assertRecordCount(this.basePath(), expectedRecCount + 500L);
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)this.spark(), (String)this.basePath());
        String[] commits = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(metaClient.getActiveTimeline().filterCompletedInstants().getInstants().toArray())).map((Function1 & Serializable & scala.Serializable)instant -> ((HoodieInstant)instant).getAction(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Assertions.assertFalse((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commits)).contains((Object)"replacecommit"));
        HoodieArchivedTimeline archivedTimeline = metaClient.getArchivedTimeline();
        Assertions.assertTrue((new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(archivedTimeline.getInstants().toArray())).map((Function1 & Serializable & scala.Serializable)instant -> ((HoodieInstant)instant).getAction(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)action -> BoxesRunTime.boxToBoolean((boolean)action.equals("replacecommit"))))).size() > 0 ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @MethodSource(value={"testSqlValidatorParams"})
    public void testPreCommitValidationWithSQLQueryEqualityInequality(String preCommitValidatorClassName, String sqlQuery, Boolean isTablePartitioned, Boolean lastWriteInSamePartition, Boolean shouldSucceed) {
        Dataset dataset;
        ObjectRef options = ObjectRef.create((Object)this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()), (Object)WriteOperationType.INSERT.value()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodiePreCommitValidatorConfig.VALIDATOR_CLASS_NAMES.key()), (Object)preCommitValidatorClassName)}))));
        if (!Predef$.MODULE$.Boolean2boolean(isTablePartitioned)) {
            options.elem = ((scala.collection.immutable.Map)options.elem).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)NonpartitionedKeyGenerator.class.getCanonicalName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"")})));
        }
        if (SqlQueryEqualityPreCommitValidator.class.getCanonicalName().equals(preCommitValidatorClassName)) {
            options.elem = ((scala.collection.immutable.Map)options.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodiePreCommitValidatorConfig.EQUALITY_SQL_QUERIES.key()), (Object)sqlQuery));
        } else if (SqlQueryInequalityPreCommitValidator.class.getCanonicalName().equals(preCommitValidatorClassName)) {
            options.elem = ((scala.collection.immutable.Map)options.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodiePreCommitValidatorConfig.INEQUALITY_SQL_QUERIES.key()), (Object)sqlQuery));
        }
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(57069L);
        FileSystem fs = HadoopFSUtils.getFs((String)this.basePath(), (Configuration)this.spark().sparkContext().hadoopConfiguration());
        List records = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).asScala()).toList();
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        Dataset inputDF1 = inputDF.filter(functions$.MODULE$.col("partition").$eq$eq$eq((Object)"2016/03/15"));
        inputDF1.write().format("hudi").options((Map)((scala.collection.immutable.Map)options.elem)).mode(SaveMode.Overwrite).save(this.basePath());
        Assertions.assertEquals((int)1, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)fs, (String)this.basePath(), (String)"000").size());
        Dataset inputDF2All = inputDF.filter(functions$.MODULE$.col("partition").$eq$eq$eq((Object)"2015/03/16"));
        int count = (int)inputDF2All.count();
        Row[] input2Rows = (Row[])inputDF2All.take(count);
        int firstHalfCount = count / 2;
        SparkContext qual$1 = this.spark().sparkContext();
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])input2Rows)).slice(0, firstHalfCount));
        int x$2 = qual$1.parallelize$default$2();
        Dataset inputDF2 = this.spark().createDataFrame(qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), inputDF2All.schema());
        inputDF2.write().format("hudi").options((Map)((scala.collection.immutable.Map)options.elem)).mode(SaveMode.Append).save(this.basePath());
        Assertions.assertEquals((int)2, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)fs, (String)this.basePath(), (String)"000").size());
        if (Predef$.MODULE$.Boolean2boolean(lastWriteInSamePartition)) {
            SparkContext qual$2 = this.spark().sparkContext();
            WrappedArray x$3 = Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])input2Rows)).slice(firstHalfCount, count));
            int x$4 = qual$2.parallelize$default$2();
            dataset = this.spark().createDataFrame(qual$2.parallelize((Seq)x$3, x$4, ClassTag$.MODULE$.apply(Row.class)), inputDF2All.schema());
        } else {
            dataset = inputDF.filter(functions$.MODULE$.col("partition").$eq$eq$eq((Object)"2015/03/17"));
        }
        Dataset inputDF3Original = dataset;
        Dataset inputDF3 = inputDF3Original.withColumn("driver", functions$.MODULE$.lit(null).cast((DataType)StringType$.MODULE$));
        if (Predef$.MODULE$.Boolean2boolean(shouldSucceed)) {
            inputDF3.write().format("hudi").options((Map)((scala.collection.immutable.Map)options.elem)).mode(SaveMode.Append).save(this.basePath());
            Assertions.assertEquals((int)3, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)fs, (String)this.basePath(), (String)"000").size());
            return;
        }
        this.assertThrowsWithPreCommitValidator(new Executable(this, inputDF3, options){
            private final /* synthetic */ TestCOWDataSourceStorage $outer;
            private final Dataset inputDF3$1;
            private final ObjectRef options$1;

            public void execute() {
                this.inputDF3$1.write().format("hudi").options((Map)((scala.collection.immutable.Map)this.options$1.elem)).mode(SaveMode.Append).save(this.$outer.basePath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.inputDF3$1 = inputDF3$1;
                this.options$1 = options$1;
            }
        });
    }

    public void assertThrowsWithPreCommitValidator(Executable executable) {
        HoodieUpsertException thrown = (HoodieUpsertException)Assertions.assertThrows(HoodieUpsertException.class, (Executable)executable, (String)"Commit should fail due to HoodieUpsertException with pre-commit validator.");
        Assertions.assertTrue((boolean)(thrown.getCause() instanceof HoodieValidationException));
        Assertions.assertTrue((boolean)thrown.getCause().getMessage().contains("At least one pre-commit validation failed"));
    }

    public void writeRecords(int commitTime, HoodieTestDataGenerator dataGen, String writeOperation, String basePath) {
        List records = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateInserts(new StringOps(Predef$.MODULE$.augmentString("%05d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)commitTime)})), Predef$.MODULE$.int2Integer(100)))).asScala()).toList();
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF.write().format("hudi").options(this.commonOpts()).option("hoodie.keep.min.commits", "2").option("hoodie.keep.max.commits", "3").option("hoodie.clean.commits.retained", "1").option("hoodie.metadata.enable", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), writeOperation).mode(SaveMode.Append).save(basePath);
    }

    public void assertRecordCount(String basePath, long expectedRecordCount) {
        Dataset snapshotDF = this.spark().read().format("org.apache.hudi").load(basePath);
        Assertions.assertEquals((long)expectedRecordCount, (long)snapshotDF.count());
    }

    public static final /* synthetic */ boolean $anonfun$testArchivalWithReplaceCommitActions$1(Row row) {
        return row.getAs("partition_path").equals("2016/03/15");
    }

    public TestCOWDataSourceStorage() {
        this.verificationCol = "driver";
        this.updatedVerificationVal = "driver_update";
    }
}

