/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.util.Map;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.functional.TestBootstrapReadBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.internal.SQLConf;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="functional")
public class TestFiltersInFileGroupReader
extends TestBootstrapReadBase {
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testFiltersInFileFormat(boolean mergeUseRecordPositions) {
        this.bootstrapType = "mixed";
        this.dashPartitions = true;
        this.tableType = HoodieTableType.MERGE_ON_READ;
        this.nPartitions = 2;
        this.nInserts = 100;
        this.nUpdates = 20;
        this.sparkSession.conf().set(SQLConf.PARQUET_RECORD_FILTER_ENABLED().key(), "true");
        this.setupDirs();
        Map<String, String> options = this.setBootstrapOptions();
        Dataset bootstrapDf = this.sparkSession.emptyDataFrame();
        bootstrapDf.write().format("hudi").options(options).mode(SaveMode.Overwrite).save(this.bootstrapTargetPath);
        this.runComparison(mergeUseRecordPositions);
        options = this.basicOptions();
        options.put(HoodieReaderConfig.MERGE_USE_RECORD_POSITIONS.key(), String.valueOf(mergeUseRecordPositions));
        options.put(HoodieWriteConfig.WRITE_RECORD_POSITIONS.key(), String.valueOf(mergeUseRecordPositions));
        this.doUpdate(options, "001");
        this.runComparison(mergeUseRecordPositions);
        this.doInsert(options, "002");
        this.runComparison(mergeUseRecordPositions);
        this.doDelete(options, "003");
        this.runComparison(mergeUseRecordPositions);
    }

    protected void runComparison(boolean mergeUseRecordPositions) {
        this.compareDf(this.createDf(this.hudiBasePath, true, mergeUseRecordPositions), this.createDf(this.hudiBasePath, false, false));
        this.compareDf(this.createDf(this.bootstrapTargetPath, true, mergeUseRecordPositions), this.createDf(this.bootstrapTargetPath, false, false));
        this.compareDf(this.createDf2(this.hudiBasePath, true, mergeUseRecordPositions), this.createDf2(this.hudiBasePath, false, false));
        this.compareDf(this.createDf2(this.bootstrapTargetPath, true, mergeUseRecordPositions), this.createDf2(this.bootstrapTargetPath, false, false));
    }

    protected Dataset<Row> createDf(String tableBasePath, Boolean fgReaderEnabled, Boolean mergeUseRecordPositions) {
        return this.sparkSession.read().format("hudi").option(HoodieReaderConfig.FILE_GROUP_READER_ENABLED.key(), fgReaderEnabled.booleanValue()).option(HoodieReaderConfig.MERGE_USE_RECORD_POSITIONS.key(), mergeUseRecordPositions.booleanValue()).load(tableBasePath).drop("city_to_state").where("begin_lat > 0.5 and _hoodie_record_key LIKE '%00%'");
    }

    protected Dataset<Row> createDf2(String tableBasePath, Boolean fgReaderEnabled, Boolean mergeUseRecordPositions) {
        return this.sparkSession.read().format("hudi").option(HoodieReaderConfig.FILE_GROUP_READER_ENABLED.key(), fgReaderEnabled.booleanValue()).option(HoodieReaderConfig.MERGE_USE_RECORD_POSITIONS.key(), mergeUseRecordPositions.booleanValue()).load(tableBasePath).drop("city_to_state").where("begin_lat > 0.5 or _hoodie_record_key LIKE '%00%'");
    }
}

