/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.FileNotFoundException;
import java.io.Serializable;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.testutils.HoodieSparkClientTestBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000194AAD\b\u00011!)q\u0004\u0001C\u0001A!91\u0005\u0001a\u0001\n\u0003!\u0003b\u0002\u0017\u0001\u0001\u0004%\t!\f\u0005\u0007m\u0001\u0001\u000b\u0015B\u0013\t\u000f]\u0002!\u0019!C\u0005q!1q\b\u0001Q\u0001\neBq\u0001\u0011\u0001C\u0002\u0013\u0005\u0011\t\u0003\u0004S\u0001\u0001\u0006IA\u0011\u0005\u0006'\u0002!\t\u0005\u0016\u0005\u0006A\u0002!\t\u0005\u0016\u0005\u0006K\u0002!\t\u0001\u0016\u0005\u0006U\u0002!\t\u0001\u0016\u0005\u0006Y\u0002!\t\u0001\u0016\u0002\u0019)\u0016\u001cH\u000fS8pI&,\u0017i\u0019;jm\u0016$\u0016.\\3mS:,'B\u0001\t\u0012\u0003)1WO\\2uS>t\u0017\r\u001c\u0006\u0003%M\tA\u0001[;eS*\u0011A#F\u0001\u0007CB\f7\r[3\u000b\u0003Y\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\r\u0011\u0005iiR\"A\u000e\u000b\u0005q\t\u0012!\u0003;fgR,H/\u001b7t\u0013\tq2DA\rI_>$\u0017.Z*qCJ\\7\t\\5f]R$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001\"!\t\u0011\u0003!D\u0001\u0010\u0003\u0015\u0019\b/\u0019:l+\u0005)\u0003C\u0001\u0014+\u001b\u00059#B\u0001\u0015*\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003GMI!aK\u0014\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\u0013M\u0004\u0018M]6`I\u0015\fHC\u0001\u00185!\ty#'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0005\u0011)f.\u001b;\t\u000fU\u001a\u0011\u0011!a\u0001K\u0005\u0019\u0001\u0010J\u0019\u0002\rM\u0004\u0018M]6!\u0003\rawnZ\u000b\u0002sA\u0011!(P\u0007\u0002w)\u0011A(F\u0001\u0006g24GG[\u0005\u0003}m\u0012a\u0001T8hO\u0016\u0014\u0018\u0001\u00027pO\u0002\n!bY8n[>tw\n\u001d;t+\u0005\u0011\u0005\u0003B\"I\u0015*k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005\u001d\u0003\u0014AC2pY2,7\r^5p]&\u0011\u0011\n\u0012\u0002\u0004\u001b\u0006\u0004\bCA&Q\u001b\u0005a%BA'O\u0003\u0011a\u0017M\\4\u000b\u0003=\u000bAA[1wC&\u0011\u0011\u000b\u0014\u0002\u0007'R\u0014\u0018N\\4\u0002\u0017\r|W.\\8o\u001fB$8\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002]!\u0012\u0011B\u0016\t\u0003/zk\u0011\u0001\u0017\u0006\u00033j\u000b1!\u00199j\u0015\tYF,A\u0004kkBLG/\u001a:\u000b\u0005u+\u0012!\u00026v]&$\u0018BA0Y\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u0012!B\u0019\t\u0003/\u000eL!\u0001\u001a-\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001\f;fgR<U\r\u001e'bgR\u001cu.\\7ji6+G/\u00193bi\u0006<\u0016\u000e\u001e5WC2LG\rR1uC\u001a{'oQ(XQ\tYq\r\u0005\u0002XQ&\u0011\u0011\u000e\u0017\u0002\u0005)\u0016\u001cH/\u0001\u0017uKN$x)\u001a;MCN$8i\\7nSRlU\r^1eCR\fw+\u001b;i-\u0006d\u0017\u000e\u001a#bi\u00064uN]'P%\"\u0012AbZ\u0001\u0016i\u0016\u001cHoR3u\u0013:\u001cH/\u00198u\t\u0016$\u0018-\u001b7tQ\tiq\r")
public class TestHoodieActiveTimeline
extends HoodieSparkClientTestBase {
    private SparkSession spark = null;
    private final Logger log = LoggerFactory.getLogger(TestHoodieActiveTimeline.class);
    private final Map<String, String> commonOpts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}));

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private Logger log() {
        return this.log;
    }

    public Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    @BeforeEach
    public void setUp() {
        this.setTableName("hoodie_test");
        this.initPath();
        this.initSparkContexts();
        this.spark_$eq(this.sqlContext.sparkSession());
        this.initTestDataGenerator();
        this.initHoodieStorage();
    }

    @AfterEach
    public void tearDown() {
        this.cleanupSparkContexts();
        this.cleanupTestDataGenerator();
        this.cleanupFileSystem();
    }

    @Test
    public void testGetLastCommitMetadataWithValidDataForCOW() {
        List records1 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).asScala()).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        String commit1Time = HoodieDataSourceHelpers.latestCommit((HoodieStorage)this.storage, (String)this.basePath);
        String[] partitionsForCommit1 = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.spark().read().format("org.apache.hudi").load(this.basePath).select("_hoodie_partition_path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().collect())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.get(0).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).sorted((Ordering)Ordering.String$.MODULE$);
        Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"2015/03/16", "2015/03/17", "2016/03/15"})).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])partitionsForCommit1)));
        HoodieTableMetaClient metaClient = this.createMetaClient(this.basePath);
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        Option ret1 = activeTimeline.getLastCommitMetadataWithValidData();
        Predef$.MODULE$.assert(ret1.isPresent());
        Tuple2 tuple2 = new Tuple2(((Pair)ret1.get()).getLeft(), ((Pair)ret1.get()).getRight());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        HoodieInstant instant1 = (HoodieInstant)tuple2._1();
        HoodieCommitMetadata commitMetadata1 = (HoodieCommitMetadata)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)instant1, (Object)commitMetadata1);
        HoodieInstant instant12 = (HoodieInstant)tuple22._1();
        HoodieCommitMetadata commitMetadata12 = (HoodieCommitMetadata)tuple22._2();
        Assertions.assertEquals((Object)instant12.requestedTime(), (Object)commit1Time);
        String relativePath1 = (String)commitMetadata12.getFileIdAndRelativePaths().values().stream().findAny().get();
        Predef$.MODULE$.assert(relativePath1.contains(commit1Time));
        Predef$.MODULE$.assert(relativePath1.contains(HoodieFileFormat.PARQUET.getFileExtension()));
        this.spark().emptyDataFrame().write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.DELETE_PARTITION_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.PARTITIONS_TO_DELETE().key(), "2015/03/16").mode(SaveMode.Append).save(this.basePath);
        String commit2Time = HoodieDataSourceHelpers.latestCommit((HoodieStorage)this.storage, (String)this.basePath);
        long countPartitionDropped = this.spark().read().format("org.apache.hudi").load(this.basePath).where("_hoodie_partition_path = '2015/03/16'").count();
        Assertions.assertEquals((long)countPartitionDropped, (long)0L);
        activeTimeline = activeTimeline.reload();
        Option ret2 = activeTimeline.getLastCommitMetadataWithValidData();
        Predef$.MODULE$.assert(ret2.isPresent());
        Tuple2 tuple23 = new Tuple2(((Pair)ret2.get()).getLeft(), ((Pair)ret2.get()).getRight());
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        HoodieInstant instant2 = (HoodieInstant)tuple23._1();
        HoodieCommitMetadata commitMetadata2 = (HoodieCommitMetadata)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)instant2, (Object)commitMetadata2);
        HoodieInstant instant22 = (HoodieInstant)tuple24._1();
        HoodieCommitMetadata commitMetadata22 = (HoodieCommitMetadata)tuple24._2();
        Assertions.assertEquals((Object)instant22.requestedTime(), (Object)commit1Time);
        String relativePath2 = (String)commitMetadata22.getFileIdAndRelativePaths().values().stream().findAny().get();
        Predef$.MODULE$.assert(relativePath2.contains(commit1Time));
        Predef$.MODULE$.assert(relativePath2.contains(HoodieFileFormat.PARQUET.getFileExtension()));
        List records3 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueUpdates("003", Predef$.MODULE$.int2Integer(50)))).asScala()).toList();
        Dataset inputDF3 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records3, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF3.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        String commit3Time = HoodieDataSourceHelpers.latestCommit((HoodieStorage)this.storage, (String)this.basePath);
        activeTimeline = activeTimeline.reload();
        Option ret3 = activeTimeline.getLastCommitMetadataWithValidData();
        Predef$.MODULE$.assert(ret3.isPresent());
        Tuple2 tuple25 = new Tuple2(((Pair)ret3.get()).getLeft(), ((Pair)ret3.get()).getRight());
        if (tuple25 == null) {
            throw new MatchError((Object)tuple25);
        }
        HoodieInstant instant3 = (HoodieInstant)tuple25._1();
        HoodieCommitMetadata commitMetadata3 = (HoodieCommitMetadata)tuple25._2();
        Tuple2 tuple26 = new Tuple2((Object)instant3, (Object)commitMetadata3);
        HoodieInstant instant32 = (HoodieInstant)tuple26._1();
        HoodieCommitMetadata commitMetadata32 = (HoodieCommitMetadata)tuple26._2();
        Assertions.assertEquals((Object)instant32.requestedTime(), (Object)commit3Time);
        String relativePath3 = (String)commitMetadata32.getFileIdAndRelativePaths().values().stream().findAny().get();
        Predef$.MODULE$.assert(relativePath3.contains(commit3Time));
        Predef$.MODULE$.assert(relativePath3.contains(HoodieFileFormat.PARQUET.getFileExtension()));
    }

    @Test
    public void testGetLastCommitMetadataWithValidDataForMOR() {
        List records1 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).asScala()).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        String commit1Time = HoodieDataSourceHelpers.latestCommit((HoodieStorage)this.storage, (String)this.basePath);
        HoodieTableMetaClient metaClient = this.createMetaClient(this.basePath);
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        Option ret1 = activeTimeline.getLastCommitMetadataWithValidData();
        Predef$.MODULE$.assert(ret1.isPresent());
        Tuple2 tuple2 = new Tuple2(((Pair)ret1.get()).getLeft(), ((Pair)ret1.get()).getRight());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        HoodieInstant instant1 = (HoodieInstant)tuple2._1();
        HoodieCommitMetadata commitMetadata1 = (HoodieCommitMetadata)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)instant1, (Object)commitMetadata1);
        HoodieInstant instant12 = (HoodieInstant)tuple22._1();
        HoodieCommitMetadata commitMetadata12 = (HoodieCommitMetadata)tuple22._2();
        Assertions.assertEquals((Object)instant12.requestedTime(), (Object)commit1Time);
        String relativePath1 = (String)commitMetadata12.getFileIdAndRelativePaths().values().stream().findAny().get();
        Predef$.MODULE$.assert(relativePath1.contains(commit1Time));
        Predef$.MODULE$.assert(relativePath1.contains(HoodieFileFormat.PARQUET.getFileExtension()));
        List records2 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueUpdates("002", Predef$.MODULE$.int2Integer(100)))).asScala()).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        String commit2Time = HoodieDataSourceHelpers.latestCommit((HoodieStorage)this.storage, (String)this.basePath);
        activeTimeline = activeTimeline.reload();
        Option ret2 = activeTimeline.getLastCommitMetadataWithValidData();
        Predef$.MODULE$.assert(ret2.isPresent());
        Tuple2 tuple23 = new Tuple2(((Pair)ret2.get()).getLeft(), ((Pair)ret2.get()).getRight());
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        HoodieInstant instant2 = (HoodieInstant)tuple23._1();
        HoodieCommitMetadata commitMetadata2 = (HoodieCommitMetadata)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)instant2, (Object)commitMetadata2);
        HoodieInstant instant22 = (HoodieInstant)tuple24._1();
        HoodieCommitMetadata commitMetadata22 = (HoodieCommitMetadata)tuple24._2();
        Assertions.assertEquals((Object)instant22.requestedTime(), (Object)commit2Time);
        String relativePath2 = (String)commitMetadata22.getFileIdAndRelativePaths().values().stream().findAny().get();
        Predef$.MODULE$.assert(relativePath2.contains(commit2Time));
        Predef$.MODULE$.assert(relativePath2.contains(HoodieFileFormat.HOODIE_LOG.getFileExtension()));
        List records3 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueUpdates("003", Predef$.MODULE$.int2Integer(50)))).asScala()).toList();
        Dataset inputDF3 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records3, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF3.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "true").option("hoodie.compact.inline.max.delta.commits", "1").mode(SaveMode.Append).save(this.basePath);
        String commit3Time = HoodieDataSourceHelpers.latestCommit((HoodieStorage)this.storage, (String)this.basePath);
        activeTimeline = activeTimeline.reload();
        Option ret3 = activeTimeline.getLastCommitMetadataWithValidData();
        Predef$.MODULE$.assert(ret3.isPresent());
        Tuple2 tuple25 = new Tuple2(((Pair)ret3.get()).getLeft(), ((Pair)ret3.get()).getRight());
        if (tuple25 == null) {
            throw new MatchError((Object)tuple25);
        }
        HoodieInstant instant3 = (HoodieInstant)tuple25._1();
        HoodieCommitMetadata commitMetadata3 = (HoodieCommitMetadata)tuple25._2();
        Tuple2 tuple26 = new Tuple2((Object)instant3, (Object)commitMetadata3);
        HoodieInstant instant32 = (HoodieInstant)tuple26._1();
        HoodieCommitMetadata commitMetadata32 = (HoodieCommitMetadata)tuple26._2();
        Assertions.assertEquals((Object)instant32.requestedTime(), (Object)commit3Time);
        String relativePath3 = (String)commitMetadata32.getFileIdAndRelativePaths().values().stream().findAny().get();
        Predef$.MODULE$.assert(relativePath3.contains(commit3Time));
        Predef$.MODULE$.assert(relativePath3.contains(HoodieFileFormat.PARQUET.getFileExtension()));
        List records4 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueUpdates("004", Predef$.MODULE$.int2Integer(50)))).asScala()).toList();
        Dataset inputDF4 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records4, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF4.write().format("org.apache.hudi").options(this.commonOpts()).mode(SaveMode.Append).save(this.basePath);
        String commit4Time = HoodieDataSourceHelpers.latestCommit((HoodieStorage)this.storage, (String)this.basePath);
        activeTimeline = activeTimeline.reload();
        Option ret4 = activeTimeline.getLastCommitMetadataWithValidData();
        Predef$.MODULE$.assert(ret4.isPresent());
        Tuple2 tuple27 = new Tuple2(((Pair)ret4.get()).getLeft(), ((Pair)ret4.get()).getRight());
        if (tuple27 == null) {
            throw new MatchError((Object)tuple27);
        }
        HoodieInstant instant4 = (HoodieInstant)tuple27._1();
        HoodieCommitMetadata commitMetadata4 = (HoodieCommitMetadata)tuple27._2();
        Tuple2 tuple28 = new Tuple2((Object)instant4, (Object)commitMetadata4);
        HoodieInstant instant42 = (HoodieInstant)tuple28._1();
        HoodieCommitMetadata commitMetadata42 = (HoodieCommitMetadata)tuple28._2();
        Assertions.assertEquals((Object)instant42.requestedTime(), (Object)commit4Time);
        String relativePath4 = (String)commitMetadata42.getFileIdAndRelativePaths().values().stream().findAny().get();
        Predef$.MODULE$.assert(relativePath4.contains(commit4Time));
        Predef$.MODULE$.assert(relativePath4.contains(HoodieFileFormat.HOODIE_LOG.getFileExtension()));
    }

    @Test
    public void testGetInstantDetails() {
        List records1 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).asScala()).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath);
        HoodieTableMetaClient metaClient = this.createMetaClient(this.basePath);
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        try {
            activeTimeline.getInstantContentStream(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "clustering", metaClient.createNewInstantTime()));
        }
        catch (HoodieIOException e) {
            Assertions.assertTrue((boolean)FileNotFoundException.class.equals(e.getCause().getClass()));
        }
        catch (Throwable throwable) {
            Assertions.fail((String)"Should have failed with FileNotFoundException");
        }
    }
}

