/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.util.List;
import java.util.stream.Stream;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.DefaultSparkRecordMerger;
import org.apache.hudi.SparkDatasetMixin;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.functional.TestMORDataSource;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.testutils.HoodieSparkClientTestBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001\u0002\u000b\u0016\u0001yAQ!\u000b\u0001\u0005\u0002)Bq!\f\u0001A\u0002\u0013\u0005a\u0006C\u00047\u0001\u0001\u0007I\u0011A\u001c\t\r\u0001\u0003\u0001\u0015)\u00030\u0011\u001d\t\u0005A1A\u0005\n\tCa!\u0013\u0001!\u0002\u0013\u0019\u0005b\u0002&\u0001\u0005\u0004%\ta\u0013\u0005\u00079\u0002\u0001\u000b\u0011\u0002'\t\u000fu\u0003!\u0019!C\u0001\u0017\"1a\f\u0001Q\u0001\n1Cqa\u0018\u0001C\u0002\u0013\u0005\u0001\r\u0003\u0004l\u0001\u0001\u0006I!\u0019\u0005\bY\u0002\u0011\r\u0011\"\u0001a\u0011\u0019i\u0007\u0001)A\u0005C\")a\u000e\u0001C!_\")1\u0010\u0001C!_\"1\u0011\u0011\u0001\u0001\u0005\u0002=Da!a\u0003\u0001\t\u0003y\u0007bBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0002!)\u0016\u001cH\u000fS8pI&,W*\u001e7uSBdWMQ1tK\u001aKG.\u001a$pe6\fGO\u0003\u0002\u0017/\u0005Qa-\u001e8di&|g.\u00197\u000b\u0005aI\u0012\u0001\u00025vI&T!AG\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0012aA8sO\u000e\u00011c\u0001\u0001 KA\u0011\u0001eI\u0007\u0002C)\u0011!eF\u0001\ni\u0016\u001cH/\u001e;jYNL!\u0001J\u0011\u00033!{w\u000eZ5f'B\f'o[\"mS\u0016tG\u000fV3ti\n\u000b7/\u001a\t\u0003M\u001dj\u0011aF\u0005\u0003Q]\u0011\u0011c\u00159be.$\u0015\r^1tKRl\u0015\u000e_5o\u0003\u0019a\u0014N\\5u}Q\t1\u0006\u0005\u0002-\u00015\tQ#A\u0003ta\u0006\u00148.F\u00010!\t\u0001D'D\u00012\u0015\t\u00114'A\u0002tc2T!!L\r\n\u0005U\n$\u0001D*qCJ\\7+Z:tS>t\u0017!C:qCJ\\w\fJ3r)\tAd\b\u0005\u0002:y5\t!HC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$H\u0001\u0003V]&$\bbB \u0004\u0003\u0003\u0005\raL\u0001\u0004q\u0012\n\u0014AB:qCJ\\\u0007%A\u0002m_\u001e,\u0012a\u0011\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\rn\tQa\u001d7gi)L!\u0001S#\u0003\r1{wmZ3s\u0003\u0011awn\u001a\u0011\u0002\u0015\r|W.\\8o\u001fB$8/F\u0001M!\u0011i%\u000b\u0016+\u000e\u00039S!a\u0014)\u0002\u0013%lW.\u001e;bE2,'BA);\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003':\u00131!T1q!\t)&,D\u0001W\u0015\t9\u0006,\u0001\u0003mC:<'\"A-\u0002\t)\fg/Y\u0005\u00037Z\u0013aa\u0015;sS:<\u0017aC2p[6|gn\u00149ug\u0002\n\u0011b\u001d9be.|\u0005\u000f^:\u0002\u0015M\u0004\u0018M]6PaR\u001c\b%A\bwKJLg-[2bi&|gnQ8m+\u0005\t\u0007C\u00012j\u001d\t\u0019w\r\u0005\u0002eu5\tQM\u0003\u0002g;\u00051AH]8pizJ!\u0001\u001b\u001e\u0002\rA\u0013X\rZ3g\u0013\tY&N\u0003\u0002iu\u0005\u0001b/\u001a:jM&\u001c\u0017\r^5p]\u000e{G\u000eI\u0001\u0017kB$\u0017\r^3e-\u0016\u0014\u0018NZ5dCRLwN\u001c,bY\u00069R\u000f\u001d3bi\u0016$g+\u001a:jM&\u001c\u0017\r^5p]Z\u000bG\u000eI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002q!\u0012q\"\u001d\t\u0003efl\u0011a\u001d\u0006\u0003iV\f1!\u00199j\u0015\t1x/A\u0004kkBLG/\u001a:\u000b\u0005a\\\u0012!\u00026v]&$\u0018B\u0001>t\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u0012\u0001# \t\u0003ezL!a`:\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\t;fgRlU\u000f\u001c;j\r&dWMR8s[\u0006$hi\u001c:D\u001f^#\u0016M\u00197f)f\u0004X\rK\u0002\u0012\u0003\u000b\u00012A]A\u0004\u0013\r\tIa\u001d\u0002\u0005)\u0016\u001cH/\u0001\u0012uKN$X*\u001e7uS\u001aKG.\u001a$pe6\fGOR8s\u001b>\u0013F+\u00192mKRK\b/\u001a\u0015\u0004%\u0005\u0015\u0011!G5og\u0016\u0014H/\u00118e-\u0006d\u0017\u000eZ1uKNs\u0017\r]:i_R$R\u0001OA\n\u0003/Aa!!\u0006\u0014\u0001\u0004\t\u0017\u0001\u00032bg\u0016\u0004\u0016\r\u001e5\t\r\u0005e1\u00031\u0001b\u0003%!\u0018M\u00197f)f\u0004X\r")
public class TestHoodieMultipleBaseFileFormat
extends HoodieSparkClientTestBase
implements SparkDatasetMixin {
    private SparkSession spark;
    private final Logger log;
    private final Map<String, String> commonOpts;
    private final Map<String, String> sparkOpts;
    private final String verificationCol;
    private final String updatedVerificationVal;

    @Override
    public Dataset<Row> toDataset(SparkSession spark, List<HoodieRecord<?>> records) {
        return SparkDatasetMixin.toDataset$(this, spark, records);
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private Logger log() {
        return this.log;
    }

    public Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    public Map<String, String> sparkOpts() {
        return this.sparkOpts;
    }

    public String verificationCol() {
        return this.verificationCol;
    }

    public String updatedVerificationVal() {
        return this.updatedVerificationVal;
    }

    @BeforeEach
    public void setUp() {
        this.setTableName("hoodie_test");
        this.initPath();
        this.initSparkContexts();
        this.spark_$eq(this.sqlContext.sparkSession());
        this.initTestDataGenerator();
        this.initHoodieStorage();
    }

    @AfterEach
    public void tearDown() {
        this.cleanupSparkContexts();
        this.cleanupTestDataGenerator();
        this.cleanupFileSystem();
    }

    @Test
    public void testMultiFileFormatForCOWTableType() {
        this.insertAndValidateSnapshot(this.basePath, HoodieTableType.COPY_ON_WRITE.name());
    }

    @Test
    public void testMultiFileFormatForMORTableType() {
        this.insertAndValidateSnapshot(this.basePath, HoodieTableType.MERGE_ON_READ.name());
    }

    public void insertAndValidateSnapshot(String basePath, String tableType) {
        Seq records1 = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((List)this.dataGen.generateInsertsForPartition("001", Predef$.MODULE$.int2Integer(10), "2016/03/15"))).asScala()).toSeq();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize(records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), tableType).mode(SaveMode.Overwrite).save(basePath);
        Seq records2 = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((List)this.dataGen.generateInsertsForPartition("002", Predef$.MODULE$.int2Integer(10), "2015/03/16"))).asScala()).toSeq();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize(records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), tableType).option(HoodieWriteConfig.BASE_FILE_FORMAT.key(), HoodieFileFormat.ORC.name()).mode(SaveMode.Append).save(basePath);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(basePath).setStorage(this.storage).build();
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(this.storageConf);
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().build();
        FileSystemViewManager viewManager = FileSystemViewManager.createViewManager((HoodieEngineContext)engineContext, (HoodieMetadataConfig)metadataConfig, (FileSystemViewStorageConfig)FileSystemViewStorageConfig.newBuilder().build(), (HoodieCommonConfig)HoodieCommonConfig.newBuilder().build(), arg_0 -> TestHoodieMultipleBaseFileFormat.$anonfun$insertAndValidateSnapshot$1((HoodieEngineContext)engineContext, metadataConfig, basePath, arg_0));
        SyncableFileSystemView fsView = viewManager.getFileSystemView(metaClient);
        Stream<HoodieBaseFile> orcFiles = fsView.getAllBaseFiles("2015/03/16").filter(bf -> bf.getFileName().endsWith("orc"));
        Assertions.assertTrue((orcFiles.count() > 0L ? 1 : 0) != 0);
        Dataset hudiDf = this.spark().read().format("hudi").load(basePath);
        Assertions.assertEquals((long)20L, (long)hudiDf.count());
        Seq records3 = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((List)this.dataGen.generateUniqueUpdates("003", Predef$.MODULE$.int2Integer(10)))).asScala()).toSeq();
        Dataset inputDF3 = this.spark().read().json(this.spark().sparkContext().parallelize(records3, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF3.write().format("hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), tableType).mode(SaveMode.Append).save(basePath);
        Dataset hudiDfAfterUpdate = this.spark().read().format("hudi").load(basePath);
        Assertions.assertEquals((long)20L, (long)hudiDfAfterUpdate.count());
    }

    public static final /* synthetic */ HoodieTableMetadata $anonfun$insertAndValidateSnapshot$1(HoodieEngineContext engineContext$1, HoodieMetadataConfig metadataConfig$1, String basePath$1, HoodieTableMetaClient mc) {
        return HoodieTableMetadata.create((HoodieEngineContext)engineContext$1, (HoodieStorage)mc.getStorage(), (HoodieMetadataConfig)metadataConfig$1, (String)basePath$1);
    }

    public TestHoodieMultipleBaseFileFormat() {
        SparkDatasetMixin.$init$(this);
        this.spark = null;
        this.log = LoggerFactory.getLogger(TestMORDataSource.class);
        this.commonOpts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTableConfig.MULTIPLE_BASE_FILE_FORMATS_ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}));
        this.sparkOpts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.RECORD_MERGE_IMPL_CLASSES.key()), (Object)DefaultSparkRecordMerger.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieStorageConfig.LOGFILE_DATA_BLOCK_FORMAT.key()), (Object)"parquet")}));
        this.verificationCol = "driver";
        this.updatedVerificationVal = "driver_update";
    }
}

