/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.testutils.HoodieSparkClientTestBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q4AAC\u0006\u0001)!)1\u0004\u0001C\u00019!9q\u0004\u0001a\u0001\n\u0003\u0001\u0003b\u0002\u0015\u0001\u0001\u0004%\t!\u000b\u0005\u0007e\u0001\u0001\u000b\u0015B\u0011\t\u000fM\u0002!\u0019!C\u0001i!1Q\t\u0001Q\u0001\nUBQA\u0012\u0001\u0005B\u001dCQa\u0015\u0001\u0005B\u001dCQ\u0001\u0017\u0001\u0005\u0002e\u0013\u0001\u0006V3ti&s7M]3nK:$\u0018\r\u001c*fC\u0012\u0014\u0015p\u0015;bi\u0016$&/\u00198tSRLwN\u001c+j[\u0016T!\u0001D\u0007\u0002\u0015\u0019,hn\u0019;j_:\fGN\u0003\u0002\u000f\u001f\u0005!\u0001.\u001e3j\u0015\t\u0001\u0012#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002%\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0006\t\u0003-ei\u0011a\u0006\u0006\u000315\t\u0011\u0002^3tiV$\u0018\u000e\\:\n\u0005i9\"!\u0007%p_\u0012LWm\u00159be.\u001cE.[3oiR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"A\u0006\u0002\u000bM\u0004\u0018M]6\u0016\u0003\u0005\u0002\"A\t\u0014\u000e\u0003\rR!\u0001J\u0013\u0002\u0007M\fHN\u0003\u0002 \u001f%\u0011qe\t\u0002\r'B\f'o[*fgNLwN\\\u0001\ngB\f'o[0%KF$\"A\u000b\u0019\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\tUs\u0017\u000e\u001e\u0005\bc\r\t\t\u00111\u0001\"\u0003\rAH%M\u0001\u0007gB\f'o\u001b\u0011\u0002\u0015\r|W.\\8o\u001fB$8/F\u00016!\u001114(P\u001f\u000e\u0003]R!\u0001O\u001d\u0002\u0013%lW.\u001e;bE2,'B\u0001\u001e-\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003y]\u00121!T1q!\tq4)D\u0001@\u0015\t\u0001\u0015)\u0001\u0003mC:<'\"\u0001\"\u0002\t)\fg/Y\u0005\u0003\t~\u0012aa\u0015;sS:<\u0017aC2p[6|gn\u00149ug\u0002\nQa]3u+B$\u0012A\u000b\u0015\u0003\u000f%\u0003\"AS)\u000e\u0003-S!\u0001T'\u0002\u0007\u0005\u0004\u0018N\u0003\u0002O\u001f\u00069!.\u001e9ji\u0016\u0014(B\u0001)\u0012\u0003\u0015QWO\\5u\u0013\t\u00116J\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003\u0011U\u0003\"A\u0013,\n\u0005][%!C!gi\u0016\u0014X)Y2i\u0003\t\"Xm\u001d;SK\u0006$\u0017N\\4XSRD7\u000b^1uKR\u0013\u0018M\\:ji&|g\u000eV5nKR\u0011!F\u0017\u0005\u00067&\u0001\r\u0001X\u0001\ni\u0006\u0014G.\u001a+za\u0016\u0004\"!\u00182\u000e\u0003yS!a\u00181\u0002\u000b5|G-\u001a7\u000b\u0005\u0005l\u0011AB2p[6|g.\u0003\u0002d=\ny\u0001j\\8eS\u0016$\u0016M\u00197f)f\u0004X\r\u000b\u0003\nK6t\u0007C\u00014l\u001b\u00059'B\u00015j\u0003!\u0001(o\u001c<jI\u0016\u0014(B\u00016N\u0003\u0019\u0001\u0018M]1ng&\u0011An\u001a\u0002\u000b\u000b:,XnU8ve\u000e,\u0017!\u0002<bYV,7%\u0001/)\u0005%\u0001\bCA9s\u001b\u0005I\u0017BA:j\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f\u001e")
public class TestIncrementalReadByStateTransitionTime
extends HoodieSparkClientTestBase {
    private SparkSession spark = null;
    private final Map<String, String> commonOpts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()), (Object)"1")}));

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    @BeforeEach
    public void setUp() {
        this.setTableName("hoodie_test");
        this.initPath();
        this.initSparkContexts();
        this.spark_$eq(this.sqlContext.sparkSession());
        this.initTestDataGenerator();
        this.initHoodieStorage();
    }

    @AfterEach
    public void tearDown() {
        this.cleanupSparkContexts();
        this.cleanupTestDataGenerator();
        this.cleanupFileSystem();
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testReadingWithStateTransitionTime(HoodieTableType tableType) {
        List records = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).asScala()).toList();
        Dataset inputDF = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF.write().format("org.apache.hudi").options(this.commonOpts()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), tableType.name()).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        HoodieTableMetaClient metaClient = this.createMetaClient(this.spark(), this.basePath);
        HoodieInstant firstInstant = (HoodieInstant)metaClient.getActiveTimeline().filterCompletedInstants().getInstantsOrderedByCompletionTime().findFirst().get();
        long result1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.START_COMMIT().key(), "000").option(DataSourceReadOptions$.MODULE$.INCREMENTAL_READ_HANDLE_HOLLOW_COMMIT().key(), TimelineUtils.HollowCommitHandling.USE_TRANSITION_TIME.name()).option(DataSourceReadOptions$.MODULE$.END_COMMIT().key(), firstInstant.requestedTime()).load(this.basePath).count();
        Assertions.assertEquals((long)result1, (long)0L);
        long result2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.START_COMMIT().key(), "000").option(DataSourceReadOptions$.MODULE$.INCREMENTAL_READ_HANDLE_HOLLOW_COMMIT().key(), TimelineUtils.HollowCommitHandling.USE_TRANSITION_TIME.name()).option(DataSourceReadOptions$.MODULE$.END_COMMIT().key(), firstInstant.getCompletionTime()).load(this.basePath).count();
        Assertions.assertEquals((long)result2, (long)100L);
    }
}

