/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import java.util.stream.Stream;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieFileIndex;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.functional.TestLayoutOptimization$;
import org.apache.hudi.testutils.HoodieSparkClientTestBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Tag(value="functional")
@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\n\u0015\u0001uAQ\u0001\n\u0001\u0005\u0002\u0015B\u0011\u0002\u000b\u0001A\u0002\u0003\u0007I\u0011A\u0015\t\u0013E\u0002\u0001\u0019!a\u0001\n\u0003\u0011\u0004\"C\u001e\u0001\u0001\u0004\u0005\t\u0015)\u0003+\u0011\u001da\u0004A1A\u0005\u0002uBa\u0001\u0012\u0001!\u0002\u0013q\u0004bB#\u0001\u0005\u0004%\tA\u0012\u0005\u0007/\u0002\u0001\u000b\u0011B$\t\u000fa\u0003!\u0019!C\u0001\r\"1\u0011\f\u0001Q\u0001\n\u001dCQA\u0017\u0001\u0005BmCQa\u001a\u0001\u0005BmCQ\u0001\u001c\u0001\u0005\u00025Dq!!\n\u0001\t\u0013\t9cB\u0004\u0002ZQA\t!a\u0017\u0007\rM!\u0002\u0012AA/\u0011\u0019!\u0003\u0003\"\u0001\u0002f!9\u0011\u0011\u0004\t\u0005\u0002\u0005\u001d$A\u0006+fgRd\u0015-_8vi>\u0003H/[7ju\u0006$\u0018n\u001c8\u000b\u0005U1\u0012A\u00034v]\u000e$\u0018n\u001c8bY*\u0011q\u0003G\u0001\u0005QV$\u0017N\u0003\u0002\u001a5\u00051\u0011\r]1dQ\u0016T\u0011aG\u0001\u0004_J<7\u0001A\n\u0003\u0001y\u0001\"a\b\u0012\u000e\u0003\u0001R!!\t\f\u0002\u0013Q,7\u000f^;uS2\u001c\u0018BA\u0012!\u0005eAun\u001c3jKN\u0003\u0018M]6DY&,g\u000e\u001e+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u00051\u0003CA\u0014\u0001\u001b\u0005!\u0012!B:qCJ\\W#\u0001\u0016\u0011\u0005-zS\"\u0001\u0017\u000b\u00055r\u0013aA:rY*\u0011\u0001\u0006G\u0005\u0003a1\u0012Ab\u00159be.\u001cVm]:j_:\f\u0011b\u001d9be.|F%Z9\u0015\u0005MJ\u0004C\u0001\u001b8\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*$\u0001B+oSRDqAO\u0002\u0002\u0002\u0003\u0007!&A\u0002yIE\naa\u001d9be.\u0004\u0013!E:pkJ\u001cW\rV1cY\u0016\u001c6\r[3nCV\ta\b\u0005\u0002@\u00056\t\u0001I\u0003\u0002BY\u0005)A/\u001f9fg&\u00111\t\u0011\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017AE:pkJ\u001cW\rV1cY\u0016\u001c6\r[3nC\u0002\nA\"\\3uC\u0012\fG/Y(qiN,\u0012a\u0012\t\u0005\u00116{u*D\u0001J\u0015\tQ5*A\u0005j[6,H/\u00192mK*\u0011A*N\u0001\u000bG>dG.Z2uS>t\u0017B\u0001(J\u0005\ri\u0015\r\u001d\t\u0003!Vk\u0011!\u0015\u0006\u0003%N\u000bA\u0001\\1oO*\tA+\u0001\u0003kCZ\f\u0017B\u0001,R\u0005\u0019\u0019FO]5oO\u0006iQ.\u001a;bI\u0006$\u0018m\u00149ug\u0002\n!bY8n[>tw\n\u001d;t\u0003-\u0019w.\\7p]>\u0003Ho\u001d\u0011\u0002\u000bM,G/\u00169\u0015\u0003MB#aC/\u0011\u0005y+W\"A0\u000b\u0005\u0001\f\u0017aA1qS*\u0011!mY\u0001\bUV\u0004\u0018\u000e^3s\u0015\t!'$A\u0003kk:LG/\u0003\u0002g?\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D#\u0001D5\u0011\u0005yS\u0017BA6`\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u0011uKN$H*Y=pkR|\u0005\u000f^5nSj\fG/[8o\rVt7\r^5p]\u0006dG#B\u001aourt\b\"B8\u000e\u0001\u0004\u0001\u0018!\u0003;bE2,G+\u001f9f!\t\t\bP\u0004\u0002smB\u00111/N\u0007\u0002i*\u0011Q\u000fH\u0001\u0007yI|w\u000e\u001e \n\u0005],\u0014A\u0002)sK\u0012,g-\u0003\u0002Ws*\u0011q/\u000e\u0005\u0006w6\u0001\r\u0001]\u0001\u0010G2,8\u000f^3sS:<\u0017i\u001d*po\")Q0\u0004a\u0001a\u0006QB.Y=pkR|\u0005\u000f^5nSj\fG/[8o'R\u0014\u0018\r^3hs\")q0\u0004a\u0001a\u0006y2\u000f]1uS\u0006d7)\u001e:wK\u000e{W\u000e]8tSRLwN\\*ue\u0006$XmZ=)\u000f5\t\u0019!a\u0005\u0002\u0016A!\u0011QAA\b\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011\u0001\u00039s_ZLG-\u001a:\u000b\u0007\u00055\u0011-\u0001\u0004qCJ\fWn]\u0005\u0005\u0003#\t9A\u0001\u0007NKRDw\u000eZ*pkJ\u001cW-A\u0003wC2,X\r\f\u0002\u0002\u0018\u0005\u0012\u0011\u0011D\u0001!i\u0016\u001cH\u000fT1z_V$x\n\u001d;j[&T\u0018\r^5p]B\u000b'/Y7fi\u0016\u00148\u000fK\u0002\u000e\u0003;\u0001B!a\b\u0002\"5\u0011\u00111B\u0005\u0005\u0003G\tYAA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fq\"Y:tKJ$(k\\<t\u001b\u0006$8\r\u001b\u000b\u0006g\u0005%\u00121\n\u0005\b\u0003Wq\u0001\u0019AA\u0017\u0003\ryg.\u001a\t\u0005\u0003_\t)E\u0004\u0003\u00022\u0005\u0005c\u0002BA\u001a\u0003\u007fqA!!\u000e\u0002>9!\u0011qGA\u001e\u001d\r\u0019\u0018\u0011H\u0005\u00027%\u0011\u0011DG\u0005\u0003QaI!!\f\u0018\n\u0007\u0005\rC&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0013\u0011\n\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1!a\u0011-\u0011\u001d\tiE\u0004a\u0001\u0003[\tQa\u001c;iKJDs\u0001AA)\u0003'\t9\u0006E\u0002_\u0003'J1!!\u0016`\u0005\r!\u0016mZ\u0011\u0002+\u00051B+Z:u\u0019\u0006Lx.\u001e;PaRLW.\u001b>bi&|g\u000e\u0005\u0002(!M\u0019\u0001#a\u0018\u0011\u0007Q\n\t'C\u0002\u0002dU\u0012a!\u00118z%\u00164GCAA.)\t\tI\u0007\u0005\u0004\u0002l\u0005U\u0014\u0011P\u0007\u0003\u0003[RA!a\u001c\u0002r\u000511\u000f\u001e:fC6T1!a\u001dT\u0003\u0011)H/\u001b7\n\t\u0005]\u0014Q\u000e\u0002\u0007'R\u0014X-Y7\u0011\t\u0005\u0015\u00111P\u0005\u0005\u0003{\n9AA\u0005Be\u001e,X.\u001a8ug\u0002")
public class TestLayoutOptimization
extends HoodieSparkClientTestBase {
    private SparkSession spark;
    private final StructType sourceTableSchema = new StructType().add("c1", (DataType)IntegerType$.MODULE$).add("c2", (DataType)StringType$.MODULE$).add("c3", (DataType)new DecimalType(9, 3)).add("c4", (DataType)TimestampType$.MODULE$).add("c5", (DataType)ShortType$.MODULE$).add("c6", (DataType)DateType$.MODULE$).add("c7", (DataType)BinaryType$.MODULE$).add("c8", (DataType)ByteType$.MODULE$);
    private final Map<String, String> metadataOpts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"true")}));
    private final Map<String, String> commonOpts = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.bulkinsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}))).$plus$plus(this.metadataOpts());

    public static Stream<Arguments> testLayoutOptimizationParameters() {
        return TestLayoutOptimization$.MODULE$.testLayoutOptimizationParameters();
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public StructType sourceTableSchema() {
        return this.sourceTableSchema;
    }

    public Map<String, String> metadataOpts() {
        return this.metadataOpts;
    }

    public Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    @BeforeEach
    public void setUp() {
        this.initPath();
        this.initSparkContexts();
        this.spark_$eq(this.sqlContext.sparkSession());
        this.initTestDataGenerator();
        this.initHoodieStorage();
    }

    @AfterEach
    public void tearDown() {
        this.cleanupSparkContexts();
        this.cleanupTestDataGenerator();
        this.cleanupFileSystem();
    }

    @ParameterizedTest
    @MethodSource(value={"testLayoutOptimizationParameters"})
    public void testLayoutOptimizationFunctional(String tableType, String clusteringAsRow, String layoutOptimizationStrategy, String spatialCurveCompositionStrategy) {
        String curveCompositionStrategy = (String)Option$.MODULE$.apply((Object)spatialCurveCompositionStrategy).getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)HoodieClusteringConfig.LAYOUT_OPTIMIZE_SPATIAL_CURVE_BUILD_METHOD.defaultValue());
        int targetRecordsCount = 10000;
        List records = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(targetRecordsCount)))).asScala()).toList();
        Dataset writeDf = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records, 2, ClassTag$.MODULE$.apply(String.class)));
        this.spark().sqlContext().setConf(HoodieFileIndex.DataSkippingFailureMode$.MODULE$.configName(), HoodieFileIndex.DataSkippingFailureMode$.MODULE$.Strict().value());
        writeDf.write().format("org.apache.hudi").options(this.commonOpts()).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), tableType).option("hoodie.parquet.small.file.limit", "0").option("hoodie.clustering.inline", "true").option("hoodie.clustering.inline.max.commits", "1").option("hoodie.clustering.plan.strategy.target.file.max.bytes", "1073741824").option("hoodie.clustering.plan.strategy.small.file.limit", "629145600").option("hoodie.clustering.plan.strategy.max.bytes.per.group", "2147483648").option(DataSourceWriteOptions$.MODULE$.ENABLE_ROW_WRITER().key(), clusteringAsRow).option(HoodieClusteringConfig.LAYOUT_OPTIMIZE_STRATEGY.key(), layoutOptimizationStrategy).option(HoodieClusteringConfig.LAYOUT_OPTIMIZE_SPATIAL_CURVE_BUILD_METHOD.key(), curveCompositionStrategy).option(HoodieClusteringConfig.PLAN_STRATEGY_SORT_COLUMNS.key(), "begin_lat,begin_lon").mode(SaveMode.Overwrite).save(this.basePath);
        HoodieTableMetaClient hudiMetaClient = this.createMetaClient(this.basePath);
        HoodieInstant lastCommit = (HoodieInstant)hudiMetaClient.getActiveTimeline().getAllCommitsTimeline().lastInstant().get();
        Assertions.assertEquals((Object)"replacecommit", (Object)lastCommit.getAction());
        Assertions.assertEquals((Object)HoodieInstant.State.COMPLETED, (Object)lastCommit.getState());
        Dataset readDf = this.spark().read().format("hudi").load(this.basePath);
        Dataset readDfSkip = this.spark().read().option(DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key(), "true").options(this.metadataOpts()).format("hudi").load(this.basePath);
        Assertions.assertEquals((long)targetRecordsCount, (long)readDf.count());
        Assertions.assertEquals((long)targetRecordsCount, (long)readDfSkip.count());
        readDf.createOrReplaceTempView("hudi_snapshot_raw");
        readDfSkip.createOrReplaceTempView("hudi_snapshot_skipping");
        this.assertRowsMatch((Dataset<Row>)this.select$1("hudi_snapshot_raw"), (Dataset<Row>)this.select$1("hudi_snapshot_skipping"));
    }

    private void assertRowsMatch(Dataset<Row> one, Dataset<Row> other) {
        long rows = one.count();
        Predef$.MODULE$.assert(rows == other.count() && one.intersect(other).count() == rows);
    }

    private final Dataset select$1(String tableName) {
        return this.spark().sql(new StringBuilder(102).append("SELECT * FROM ").append(tableName).append(" WHERE begin_lat >= 0.49 AND begin_lat < 0.51 AND begin_lon >= 0.49 AND begin_lon < 0.51").toString());
    }
}

