/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.client.transaction.lock.InProcessLockProvider;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.log.HoodieLogFileReader;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.functions$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.roaringbitmap.longlong.Roaring64NavigableMap;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Tag(value="functional")
@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\u0005\u000b\u0001MAQA\u0007\u0001\u0005\u0002mAQA\b\u0001\u0005B}AQA\n\u0001\u0005\u0002\u001dBQA\u0018\u0001\u0005\u0002}CQa\u001a\u0001\u0005\u0002!DQA\u001e\u0001\u0005\u0002]D\u0011\"a\u000b\u0001#\u0003%\t!!\f\t\rY\u0004A\u0011AA\"\u0005a!Vm\u001d;N\u001fJ#\u0015\r^1T_V\u00148-Z*u_J\fw-\u001a\u0006\u0003\u00171\t!BZ;oGRLwN\\1m\u0015\tia\"\u0001\u0003ik\u0012L'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003D\u0001\ni\u0016\u001cH/\u001e;jYNL!!\u0007\f\u0003AM\u0003\u0018M]6DY&,g\u000e\u001e$v]\u000e$\u0018n\u001c8bYR+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"!\b\u0001\u000e\u0003)\tAaY8oMR\t\u0001\u0005\u0005\u0002\"I5\t!E\u0003\u0002$\u001d\u0005)1\u000f]1sW&\u0011QE\t\u0002\n'B\f'o[\"p]\u001a\fa\u0003^3ti6+'oZ3P]J+\u0017\rZ*u_J\fw-\u001a\u000b\u0005Q9\u001a\u0004\t\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0003V]&$\b\"B\u0018\u0004\u0001\u0004\u0001\u0014!E5t\u001b\u0016$\u0018\rZ1uC\u0016s\u0017M\u00197fIB\u0011\u0011&M\u0005\u0003e)\u0012qAQ8pY\u0016\fg\u000eC\u00035\u0007\u0001\u0007Q'A\bqe\u0016\u001cu.\u001c2j]\u00164\u0015.\u001a7e!\t1TH\u0004\u00028wA\u0011\u0001HK\u0007\u0002s)\u0011!HE\u0001\u0007yI|w\u000e\u001e \n\u0005qR\u0013A\u0002)sK\u0012,g-\u0003\u0002?\u007f\t11\u000b\u001e:j]\u001eT!\u0001\u0010\u0016\t\u000b\u0005\u001b\u0001\u0019\u0001\u0019\u0002%U\u001cXMR5mK\u001e\u0013x.\u001e9SK\u0006$WM\u001d\u0015\u0005\u0007\r{\u0005\u000b\u0005\u0002E\u001b6\tQI\u0003\u0002G\u000f\u0006A\u0001O]8wS\u0012,'O\u0003\u0002I\u0013\u00061\u0001/\u0019:b[NT!AS&\u0002\u000f),\b/\u001b;fe*\u0011A\nE\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u001d\u0016\u0013\u0011bQ:w'>,(oY3\u0002\u000bY\fG.^3-\tE\u001bVkV\u0011\u0002%\u0006YAO];fY12\u0017\r\\:fC\u0005!\u0016\u0001\u0007;sk\u0016dc-\u0019:f]\r,(O]3oGfdc-\u00197tK\u0006\na+\u0001\u0007gC2\u001cX\r\f\u0017gC2\u001cX-I\u0001Y\u0003a1\u0017\r\\:fY\u0019\f'/\u001a\u0018dkJ\u0014XM\\2zYQ\u0014X/\u001a\u0015\u0003\u0007i\u0003\"a\u0017/\u000e\u0003\u001dK!!X$\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/A\u0014uKN$X*\u001a:hK>s'+Z1e'R|'/Y4f\t\u00164\u0017-\u001e7u\u0007>l\u0007/Y2uS>tG#\u0001\u0015)\u0005\u0011\t\u0007C\u00012f\u001b\u0005\u0019'B\u00013J\u0003\r\t\u0007/[\u0005\u0003M\u000e\u0014A\u0001V3ti\u00061D/Z:u\u0003V$x\u000eR5tC\nd\u0017N\\4SK\u000e|'\u000f\u001a)pg&$\u0018n\u001c8t+:$WM\u001d)f]\u0012LgnZ\"p[B\f7\r^5p]R\u0019\u0001&[6\t\u000b),\u0001\u0019\u0001\u0019\u0002']\u0014\u0018\u000e^3SK\u000e|'\u000f\u001a)pg&$\u0018n\u001c8\t\u000b1,\u0001\u0019\u0001\u0019\u0002\u0015\u0015t\u0017M\u00197f\u001d\n\u001b5\t\u000b\u0003\u0006\u0007>sGfA8rg\u0006\n\u0001/A\u0006gC2\u001cX\r\f4bYN,\u0017%\u0001:\u0002\u0013Q\u0014X/\u001a\u0017ueV,\u0017%\u0001;\u0002\u0015Q\u0014X/\u001a\u0017gC2\u001cX\r\u000b\u0002\u00065\u0006\tc/\u00197jI\u0006$XMU3d_J$\u0007k\\:ji&|gn]%o\u0019><g)\u001b7fgR9\u00010a\u0005\u0002$\u0005\u001d\u0002\u0003B=\u007f\u0003\u0007q!A\u001f?\u000f\u0005aZ\u0018\"A\u0016\n\u0005uT\u0013a\u00029bG.\fw-Z\u0005\u0004\u007f\u0006\u0005!\u0001\u0002'jgRT!! \u0016\u0011\t\u0005\u0015\u0011qB\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005)Qn\u001c3fY*\u0019\u0011Q\u0002\u0007\u0002\r\r|W.\\8o\u0013\u0011\t\t\"a\u0002\u0003\u001b!{w\u000eZ5f\u0019><g)\u001b7f\u0011\u001d\t)B\u0002a\u0001\u0003/\t!\"\\3uC\u000ec\u0017.\u001a8u!\u0011\tI\"a\b\u000e\u0005\u0005m!\u0002BA\u000f\u0003\u0017\tQ\u0001^1cY\u0016LA!!\t\u0002\u001c\t)\u0002j\\8eS\u0016$\u0016M\u00197f\u001b\u0016$\u0018m\u00117jK:$\bBBA\u0013\r\u0001\u0007\u0001'A\u000etQ>,H\u000eZ\"p]R\f\u0017N\u001c*fG>\u0014H\rU8tSRLwN\u001c\u0005\t\u0003S1\u0001\u0013!a\u0001a\u0005q2\u000f[8vY\u0012\u0014\u0015m]3GS2,\u0017J\\:uC:$H+[7f\u001b\u0006$8\r[\u0001,m\u0006d\u0017\u000eZ1uKJ+7m\u001c:e!>\u001c\u0018\u000e^5p]NLe\u000eT8h\r&dWm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u0006\u0016\u0004a\u0005E2FAA\u001a!\u0011\t)$a\u0010\u000e\u0005\u0005]\"\u0002BA\u001d\u0003w\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005u\"&\u0001\u0006b]:|G/\u0019;j_:LA!!\u0011\u00028\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0015\u0013!\n)%a\u0012\u0002J\u00055\u0003bBA\u000b\u0011\u0001\u0007\u0011q\u0003\u0005\u0007\u0003KA\u0001\u0019\u0001\u0019\t\r\u0005-\u0003\u00021\u0001y\u0003-awn\u001a$jY\u0016d\u0015n\u001d;\t\r\u0005%\u0002\u00021\u00011Q\u0019\u0001\u0011\u0011K(\u0002XA\u0019!-a\u0015\n\u0007\u0005U3MA\u0002UC\u001e\f\u0013a\u0003")
public class TestMORDataSourceStorage
extends SparkClientFunctionalTestHarness {
    public SparkConf conf() {
        return this.conf(SparkClientFunctionalTestHarness.getSparkSqlConf());
    }

    @ParameterizedTest
    @CsvSource(value={"true,,false", "true,fare.currency,false", "false,,false", "false,fare.currency,true"})
    public void testMergeOnReadStorage(boolean isMetadataEnabled, String preCombineField, boolean useFileGroupReader) {
        scala.collection.immutable.Map commonOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.bulkinsert.shuffle.parallelism"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.delete.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition_path"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}));
        String verificationCol = "driver";
        String updatedVerificationVal = "driver_update";
        scala.collection.immutable.Map options = commonOpts.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)String.valueOf(isMetadataEnabled)));
        if (!StringUtils.isNullOrEmpty((String)preCombineField)) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)preCombineField));
        }
        if (useFileGroupReader) {
            options = options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieReaderConfig.FILE_GROUP_READER_ENABLED.key()), (Object)String.valueOf(useFileGroupReader)));
        }
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(57071L);
        FileSystem fs = HadoopFSUtils.getFs((String)this.basePath(), (Configuration)this.spark().sparkContext().hadoopConfiguration());
        List records1 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).asScala()).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options((Map)options).option("hoodie.compact.inline", "false").option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath());
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)fs, (String)this.basePath(), (String)"000"));
        Dataset hudiRODF1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).load(this.basePath());
        Assertions.assertEquals((long)100L, (long)hudiRODF1.count());
        String insertCommitTime = HoodieDataSourceHelpers.latestCommit((FileSystem)fs, (String)this.basePath());
        List insertCommitTimes = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(hudiRODF1.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().collectAsList()).asScala()).map((Function1 & Serializable & scala.Serializable)r -> r.getString(0), Buffer$.MODULE$.canBuildFrom())).toList();
        Assertions.assertEquals((Object)new .colon.colon((Object)insertCommitTime, (List)Nil$.MODULE$), (Object)insertCommitTimes);
        List records2 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateUniqueUpdates("002", Predef$.MODULE$.int2Integer(100)))).asScala()).toList();
        Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF2.write().format("org.apache.hudi").options((Map)options).mode(SaveMode.Append).save(this.basePath());
        String updateCommitTime = HoodieDataSourceHelpers.latestCommit((FileSystem)fs, (String)this.basePath());
        Dataset hudiSnapshotDF2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).load(this.basePath());
        List updateCommitTimes = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(hudiSnapshotDF2.select("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().collectAsList()).asScala()).map((Function1 & Serializable & scala.Serializable)r -> r.getString(0), Buffer$.MODULE$.canBuildFrom())).toList();
        Assertions.assertEquals((Object)new .colon.colon((Object)updateCommitTime, (List)Nil$.MODULE$), (Object)updateCommitTimes);
        String verificationRowKey = ((Row)hudiSnapshotDF2.limit(1).select("_row_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first()).getString(0);
        Dataset inputDF3 = hudiSnapshotDF2.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)verificationRowKey)).withColumn(verificationCol, functions$.MODULE$.lit((Object)updatedVerificationVal));
        inputDF3.write().format("org.apache.hudi").options((Map)options).mode(SaveMode.Append).save(this.basePath());
        Dataset hudiSnapshotDF3 = this.spark().read().format("hudi").option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabled).load(this.basePath());
        Assertions.assertEquals((long)100L, (long)hudiSnapshotDF3.count());
        Assertions.assertEquals((Object)updatedVerificationVal, (Object)((Row)hudiSnapshotDF3.filter(functions$.MODULE$.col("_row_key").$eq$eq$eq((Object)verificationRowKey)).select(verificationCol, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first()).getString(0));
    }

    @Test
    public void testMergeOnReadStorageDefaultCompaction() {
        scala.collection.immutable.Map commonOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.bulkinsert.shuffle.parallelism"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.delete.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.merge.small.file.group.candidates.limit"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.WRITE_RECORD_POSITIONS.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition_path"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}));
        ObjectRef options = ObjectRef.create((Object)commonOpts);
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(57071L);
        FileSystem fs = HadoopFSUtils.getFs((String)this.basePath(), (Configuration)this.spark().sparkContext().hadoopConfiguration());
        List records1 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).asScala()).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 2, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("org.apache.hudi").options((Map)((scala.collection.immutable.Map)options.elem)).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath());
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)fs, (String)this.basePath(), (String)"000"));
        Dataset hudiDF1 = this.spark().read().format("org.apache.hudi").load(this.basePath());
        Assertions.assertEquals((long)100L, (long)hudiDF1.count());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)a -> {
            List records2 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateUniqueUpdates("002", Predef$.MODULE$.int2Integer(100)))).asScala()).toList();
            Dataset inputDF2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, 2, ClassTag$.MODULE$.apply(String.class)));
            inputDF2.write().format("org.apache.hudi").options((Map)((scala.collection.immutable.Map)options$1.elem)).mode(SaveMode.Append).save(this.basePath());
        });
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)new HadoopStorageConfiguration(fs.getConf()), (String)this.basePath());
        Assertions.assertEquals((int)1, (int)metaClient.getActiveTimeline().getCommitAndReplaceTimeline().countInstants());
    }

    @ParameterizedTest
    @CsvSource(value={"false,false", "true,true", "true,false"})
    public void testAutoDisablingRecordPositionsUnderPendingCompaction(boolean writeRecordPosition, boolean enableNBCC) {
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.bulkinsert.shuffle.parallelism"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.delete.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.merge.small.file.group.candidates.limit"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.WRITE_RECORD_POSITIONS.key()), (Object)Boolean.toString(writeRecordPosition)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)NonpartitionedKeyGenerator.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndexConfig.INDEX_TYPE.key()), (Object)(enableNBCC ? HoodieIndex.IndexType.BUCKET.name() : HoodieIndex.IndexType.SIMPLE.name())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key()), (Object)InProcessLockProvider.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.key()), (Object)(enableNBCC ? WriteConcurrencyMode.NON_BLOCKING_CONCURRENCY_CONTROL.name() : WriteConcurrencyMode.SINGLE_WRITER.name())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTableConfig.TYPE.key()), (Object)HoodieTableType.MERGE_ON_READ.name())}));
        scala.collection.immutable.Map optionWithoutCompactionExecution = options.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.INLINE_COMPACT.key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.SCHEDULE_INLINE_COMPACT.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key()), (Object)"2")})));
        scala.collection.immutable.Map optionWithCompactionExecution = options.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.INLINE_COMPACT.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.SCHEDULE_INLINE_COMPACT.key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key()), (Object)"6")})));
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(57071L);
        HoodieStorage storage = HoodieStorageUtils.getStorage((String)this.basePath(), (StorageConfiguration)new HadoopStorageConfiguration(this.spark().sparkContext().hadoopConfiguration()));
        List records1 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(100)))).asScala()).toList();
        Dataset inputDF1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, 1, ClassTag$.MODULE$.apply(String.class)));
        inputDF1.write().format("hudi").options((Map)optionWithoutCompactionExecution).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath());
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((HoodieStorage)storage, (String)this.basePath(), (String)"000"));
        Assertions.assertEquals((long)100L, (long)this.spark().read().format("hudi").option(HoodieReaderConfig.MERGE_USE_RECORD_POSITIONS.key(), "true").load(this.basePath()).count());
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)storage.getConf(), (String)this.basePath());
        ObjectRef logFileList = ObjectRef.create((Object)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            List updates2 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateUniqueUpdates("002", Predef$.MODULE$.int2Integer(5)))).asScala()).toList();
            List deletes2 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateUniqueDeleteRecords("002", Predef$.MODULE$.int2Integer(15)))).asScala()).toList();
            Dataset inputDF2 = i == 3 ? this.spark().read().json(this.spark().sparkContext().parallelize((Seq)deletes2, 2, ClassTag$.MODULE$.apply(String.class))) : this.spark().read().json(this.spark().sparkContext().parallelize((Seq)updates2, 2, ClassTag$.MODULE$.apply(String.class))).union(this.spark().read().json(this.spark().sparkContext().parallelize((Seq)deletes2, 2, ClassTag$.MODULE$.apply(String.class))));
            inputDF2.write().format("hudi").options((Map)optionWithoutCompactionExecution).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), i == 3 ? DataSourceWriteOptions$.MODULE$.DELETE_OPERATION_OPT_VAL() : DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath());
            Assertions.assertEquals((long)(100 - i * 15), (long)this.spark().read().format("hudi").option(HoodieReaderConfig.MERGE_USE_RECORD_POSITIONS.key(), "true").load(this.basePath()).count());
            Assertions.assertEquals((int)1, (int)metaClient.reloadActiveTimeline().filterPendingCompactionTimeline().countInstants());
            Assertions.assertEquals((int)(i + 1), (int)metaClient.getActiveTimeline().getDeltaCommitTimeline().countInstants());
            logFileList$1.elem = this.validateRecordPositionsInLogFiles(metaClient, writeRecordPosition && !enableNBCC, this.validateRecordPositionsInLogFiles$default$3());
        });
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(4), 6).foreach((Function1 & Serializable & scala.Serializable)i -> TestMORDataSourceStorage.$anonfun$testAutoDisablingRecordPositionsUnderPendingCompaction$2(this, dataGen, optionWithCompactionExecution, metaClient, writeRecordPosition, enableNBCC, logFileList, BoxesRunTime.unboxToInt((Object)i)));
    }

    public List<HoodieLogFile> validateRecordPositionsInLogFiles(HoodieTableMetaClient metaClient, boolean shouldContainRecordPosition, boolean shouldBaseFileInstantTimeMatch) {
        HoodieInstant instant = (HoodieInstant)metaClient.getActiveTimeline().getDeltaCommitTimeline().lastInstant().get();
        HoodieCommitMetadata commitMetadata = metaClient.getActiveTimeline().readCommitMetadata(instant);
        List logFileList = ((TraversableOnce)((TraversableLike)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)commitMetadata.getFileIdAndFullPaths(metaClient.getBasePath())).asScala()).values().filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)TestMORDataSourceStorage.$anonfun$validateRecordPositionsInLogFiles$1(e)))).map((Function1 & Serializable & scala.Serializable)e -> new HoodieLogFile(new StoragePath(e)), Iterable$.MODULE$.canBuildFrom())).toList();
        Assertions.assertFalse((boolean)logFileList.isEmpty());
        this.validateRecordPositionsInLogFiles(metaClient, shouldContainRecordPosition, (List<HoodieLogFile>)logFileList, shouldBaseFileInstantTimeMatch);
        return logFileList;
    }

    public void validateRecordPositionsInLogFiles(HoodieTableMetaClient metaClient, boolean shouldContainRecordPosition, List<HoodieLogFile> logFileList, boolean shouldBaseFileInstantTimeMatch) {
        Schema schema = new TableSchemaResolver(metaClient).getTableAvroSchema();
        HoodieTableFileSystemView fsv = FileSystemViewManager.createInMemoryFileSystemView((HoodieEngineContext)this.context(), (HoodieTableMetaClient)metaClient, (HoodieMetadataConfig)HoodieMetadataConfig.newBuilder().build());
        logFileList.foreach((Function1 & Serializable & scala.Serializable)filename -> {
            TestMORDataSourceStorage.$anonfun$validateRecordPositionsInLogFiles$3(metaClient, schema, shouldContainRecordPosition, fsv, shouldBaseFileInstantTimeMatch, filename);
            return BoxedUnit.UNIT;
        });
    }

    public boolean validateRecordPositionsInLogFiles$default$3() {
        return true;
    }

    public static final /* synthetic */ List $anonfun$testAutoDisablingRecordPositionsUnderPendingCompaction$2(TestMORDataSourceStorage $this, HoodieTestDataGenerator dataGen$2, scala.collection.immutable.Map optionWithCompactionExecution$1, HoodieTableMetaClient metaClient$1, boolean writeRecordPosition$1, boolean enableNBCC$1, ObjectRef logFileList$1, int i) {
        List updates3 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen$2.generateUniqueUpdates("004", Predef$.MODULE$.int2Integer(5)))).asScala()).toList();
        List deletes3 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen$2.generateUniqueDeleteRecords("004", Predef$.MODULE$.int2Integer(15)))).asScala()).toList();
        Dataset inputDF3 = i == 3 ? $this.spark().read().json($this.spark().sparkContext().parallelize((Seq)deletes3, 2, ClassTag$.MODULE$.apply(String.class))) : $this.spark().read().json($this.spark().sparkContext().parallelize((Seq)updates3, 2, ClassTag$.MODULE$.apply(String.class))).union($this.spark().read().json($this.spark().sparkContext().parallelize((Seq)deletes3, 2, ClassTag$.MODULE$.apply(String.class))));
        inputDF3.write().format("hudi").options((Map)optionWithCompactionExecution$1).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), i == 3 ? DataSourceWriteOptions$.MODULE$.DELETE_OPERATION_OPT_VAL() : DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).mode(SaveMode.Append).save($this.basePath());
        Assertions.assertEquals((long)(100 - i * 15), (long)$this.spark().read().format("hudi").option(HoodieReaderConfig.MERGE_USE_RECORD_POSITIONS.key(), "true").load($this.basePath()).count());
        Assertions.assertTrue((boolean)metaClient$1.reloadActiveTimeline().filterPendingCompactionTimeline().empty());
        Assertions.assertEquals((int)1, (int)metaClient$1.getActiveTimeline().getCommitAndReplaceTimeline().countInstants());
        Assertions.assertEquals((int)(i + 1), (int)metaClient$1.getActiveTimeline().getDeltaCommitTimeline().countInstants());
        if (i == 4) {
            $this.validateRecordPositionsInLogFiles(metaClient$1, writeRecordPosition$1 && !enableNBCC$1, (List<HoodieLogFile>)((List)logFileList$1.elem), false);
        }
        return $this.validateRecordPositionsInLogFiles(metaClient$1, writeRecordPosition$1 && !enableNBCC$1, i != 4);
    }

    public static final /* synthetic */ boolean $anonfun$validateRecordPositionsInLogFiles$1(String e) {
        return FSUtils.isLogFile((StoragePath)new StoragePath(e));
    }

    public static final /* synthetic */ void $anonfun$validateRecordPositionsInLogFiles$3(HoodieTableMetaClient metaClient$2, Schema schema$1, boolean shouldContainRecordPosition$1, HoodieTableFileSystemView fsv$1, boolean shouldBaseFileInstantTimeMatch$1, HoodieLogFile filename) {
        HoodieLogFileReader logFormatReader = new HoodieLogFileReader(metaClient$2.getStorage(), filename, schema$1, 81920);
        int numBlocks = 0;
        while (logFormatReader.hasNext()) {
            HoodieLogBlock logBlock = logFormatReader.next();
            Roaring64NavigableMap recordPositions = logBlock.getRecordPositions();
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)shouldContainRecordPosition$1), (Object)BoxesRunTime.boxToBoolean((!recordPositions.isEmpty() ? 1 : 0) != 0));
            if (shouldContainRecordPosition$1) {
                Option baseFile = fsv$1.getLatestBaseFile("", filename.getFileId());
                Assertions.assertTrue((boolean)baseFile.isPresent());
                Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)shouldBaseFileInstantTimeMatch$1), (Object)BoxesRunTime.boxToBoolean((boolean)((HoodieBaseFile)baseFile.get()).getCommitTime().equals(logBlock.getBaseFileInstantTimeOfPositions())));
            }
            ++numBlocks;
        }
        logFormatReader.close();
        Assertions.assertTrue((numBlocks > 0 ? 1 : 0) != 0);
    }
}

