/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.hudi.DataSourceReadOptions;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.functional.TestBootstrapReadBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;

@Tag(value="functional-b")
public class TestNewHoodieParquetFileFormat
extends TestBootstrapReadBase {
    private static Stream<Arguments> testArgs() {
        Stream.Builder<Arguments> b = Stream.builder();
        b.add(Arguments.of((Object[])new Object[]{HoodieTableType.MERGE_ON_READ, 0}));
        b.add(Arguments.of((Object[])new Object[]{HoodieTableType.COPY_ON_WRITE, 1}));
        b.add(Arguments.of((Object[])new Object[]{HoodieTableType.MERGE_ON_READ, 2}));
        return b.build();
    }

    @ParameterizedTest
    @MethodSource(value={"testArgs"})
    public void testNewParquetFileFormat(HoodieTableType tableType, Integer nPartitions) {
        this.bootstrapType = nPartitions == 0 ? "metadata" : "mixed";
        this.dashPartitions = true;
        this.tableType = tableType;
        this.nPartitions = nPartitions;
        this.setupDirs();
        Map<String, String> options = this.setBootstrapOptions();
        Dataset bootstrapDf = this.sparkSession.emptyDataFrame();
        bootstrapDf.write().format("hudi").options(options).mode(SaveMode.Overwrite).save(this.bootstrapTargetPath);
        this.runComparisons();
        options = this.basicOptions();
        this.doUpdate(options, "001");
        this.runComparisons();
        this.doInsert(options, "002");
        this.runComparisons();
        this.doDelete(options, "003");
        this.runComparisons();
    }

    protected void runComparisons() {
        if (this.tableType.equals((Object)HoodieTableType.MERGE_ON_READ)) {
            this.runComparison(this.hudiBasePath);
        }
        this.runComparison(this.bootstrapTargetPath);
    }

    protected void runComparison(String tableBasePath) {
        this.testCount(tableBasePath);
        this.runIndividualComparison(tableBasePath);
        this.runIndividualComparison(tableBasePath, "partition_path", new String[0]);
        this.runIndividualComparison(tableBasePath, "_hoodie_record_key", "_hoodie_commit_time", "_hoodie_partition_path");
        this.runIndividualComparison(tableBasePath, "_hoodie_commit_time", "_hoodie_commit_seqno");
        this.runIndividualComparison(tableBasePath, "_hoodie_commit_time", "_hoodie_commit_seqno", "partition_path");
        this.runIndividualComparison(tableBasePath, "_row_key", "_hoodie_commit_seqno", "_hoodie_record_key", "_hoodie_partition_path");
        this.runIndividualComparison(tableBasePath, "_row_key", "partition_path", "_hoodie_is_deleted", "begin_lon");
    }

    protected void testCount(String tableBasePath) {
        Dataset legacyDf = this.sparkSession.read().format("hudi").option(HoodieReaderConfig.FILE_GROUP_READER_ENABLED.key(), "false").load(tableBasePath);
        Dataset fileFormatDf = this.sparkSession.read().format("hudi").option(HoodieReaderConfig.FILE_GROUP_READER_ENABLED.key(), "true").load(tableBasePath);
        Assertions.assertEquals((long)legacyDf.count(), (long)fileFormatDf.count());
    }

    protected Seq<String> seq(String ... a) {
        return ((Buffer)JavaConverters.asScalaBufferConverter(Arrays.asList(a)).asScala()).toSeq();
    }

    protected void runIndividualComparison(String tableBasePath) {
        this.runIndividualComparison(tableBasePath, "", new String[0]);
    }

    protected void runIndividualComparison(String tableBasePath, String firstColumn, String ... columns) {
        ArrayList<String> queryTypes = new ArrayList<String>();
        queryTypes.add(DataSourceReadOptions.QUERY_TYPE_SNAPSHOT_OPT_VAL());
        if (this.tableType.equals((Object)HoodieTableType.MERGE_ON_READ)) {
            queryTypes.add(DataSourceReadOptions.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL());
        }
        for (String queryType : queryTypes) {
            Dataset legacyDf = this.sparkSession.read().format("hudi").option(HoodieReaderConfig.FILE_GROUP_READER_ENABLED.key(), "false").option(DataSourceReadOptions.QUERY_TYPE().key(), queryType).load(tableBasePath);
            Dataset fileFormatDf = this.sparkSession.read().format("hudi").option(HoodieReaderConfig.FILE_GROUP_READER_ENABLED.key(), "true").option(DataSourceReadOptions.QUERY_TYPE().key(), queryType).load(tableBasePath);
            if (firstColumn.isEmpty()) {
                legacyDf = legacyDf.drop("city_to_state");
                fileFormatDf = fileFormatDf.drop("city_to_state");
                if (queryType.equals(DataSourceReadOptions.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()) && this.tableType.equals((Object)HoodieTableType.MERGE_ON_READ) && this.nPartitions > 0) {
                    legacyDf = legacyDf.drop("partition_path");
                    fileFormatDf = fileFormatDf.drop("partition_path");
                }
            } else if (columns.length > 0) {
                legacyDf = legacyDf.select(firstColumn, columns);
                fileFormatDf = fileFormatDf.select(firstColumn, columns);
            } else {
                legacyDf = legacyDf.select(firstColumn, new String[0]);
                fileFormatDf = fileFormatDf.select(firstColumn, new String[0]);
            }
            this.compareDf((Dataset<Row>)legacyDf, (Dataset<Row>)fileFormatDf);
        }
    }
}

