/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.util.List;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.functional.ColumnStatIndexTestBase;
import org.apache.hudi.functional.ColumnStatIndexTestBase$ColumnStatsTestParams$;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.spark.sql.SaveMode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0005\u000b\u0001MAQ\u0001\u0007\u0001\u0005\u0002eAqa\u0007\u0001C\u0002\u0013\u0005A\u0004\u0003\u0004.\u0001\u0001\u0006I!\b\u0005\u0006]\u0001!\ta\f\u0005\u0006=\u0002!\ta\u0018\u0005\u0006I\u0002!\t!\u001a\u0005\u0006U\u0002!\ta\u001b\u0005\u0006a\u0002!\t!\u001d\u0002\u001a)\u0016\u001cH\u000fU1si&$\u0018n\u001c8Ti\u0006$8\u000f\u0015:v]&twM\u0003\u0002\f\u0019\u0005Qa-\u001e8di&|g.\u00197\u000b\u00055q\u0011\u0001\u00025vI&T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)b#D\u0001\u000b\u0013\t9\"BA\fD_2,XN\\*uCRLe\u000eZ3y)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012A\u0007\t\u0003+\u0001\t\u0001\u0004R#G\u0003VcEkX\"P\u0019VkejU0U\u001f~Ke\nR#Y+\u0005i\u0002c\u0001\u0010$K5\tqD\u0003\u0002!C\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0010\u0003\u0007M+\u0017\u000f\u0005\u0002'W5\tqE\u0003\u0002)S\u0005!A.\u00198h\u0015\u0005Q\u0013\u0001\u00026bm\u0006L!\u0001L\u0014\u0003\rM#(/\u001b8h\u0003e!UIR!V\u0019R{6i\u0014'V\u001b:\u001bv\fV(`\u0013:#U\t\u0017\u0011\u0002+Q,7\u000f^'fi\u0006$\u0017\r^1Q'&\u001b\u0016.\u001c9mKR\u0011\u0001\u0007\u000e\t\u0003cIj\u0011!I\u0005\u0003g\u0005\u0012A!\u00168ji\")Q\u0007\u0002a\u0001m\u0005AA/Z:u\u0007\u0006\u001cX\r\u0005\u00028\u000b:\u0011\u0001h\u0011\b\u0003s\ts!AO!\u000f\u0005m\u0002eB\u0001\u001f@\u001b\u0005i$B\u0001 \u0013\u0003\u0019a$o\\8u}%\t\u0011#\u0003\u0002\u0010!%\u0011QBD\u0005\u0003\u00171I!\u0001\u0012\u0006\u0002/\r{G.^7o'R\fG/\u00138eKb$Vm\u001d;CCN,\u0017B\u0001$H\u0005M\u0019u\u000e\\;n]N#\u0018\r^:UKN$8)Y:f\u0015\t!%\u0002\u000b\u0003\u0005\u0013V3\u0006C\u0001&T\u001b\u0005Y%B\u0001'N\u0003!\u0001(o\u001c<jI\u0016\u0014(B\u0001(P\u0003\u0019\u0001\u0018M]1ng*\u0011\u0001+U\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0011\u0006#A\u0003kk:LG/\u0003\u0002U\u0017\naQ*\u001a;i_\u0012\u001cv.\u001e:dK\u0006)a/\u00197vK2\nq+I\u0001Y\u0003)\"Xm\u001d;NKR\fG-\u0019;b\u0007>dW/\u001c8Ti\u0006$8/\u00138eKb\u0004\u0016M]1ng&sW*Z7pefD#\u0001\u0002.\u0011\u0005mcV\"A'\n\u0005uk%!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006aB/Z:u\u001b\u0016$\u0018\rZ1uC\u000e{G.^7o'R\fGo]%oI\u0016DHC\u0001\u0019a\u0011\u0015)T\u00011\u00017Q\u0011)\u0011*\u00162-\u0003]C#!\u0002.\u0002kQ,7\u000f^'fi\u0006$\u0017\r^1D_2,XN\\*uCR\u001c\u0018J\u001c3fq&s\u0017\u000e^5bY&T\u0018\r^5p]^KG\u000f[+qg\u0016\u0014Ho\u001d\u000b\u0003a\u0019DQ!\u000e\u0004A\u0002YBCAB%VQ2\nq\u000b\u000b\u0002\u00075\u00069D/Z:u\u001b\u0016$\u0018\rZ1uC\u000e{G.^7o'R\fGo]%oI\u0016D\u0018J\\5uS\u0006d\u0017N_1uS>tw+\u001b;i%>dGNY1dWN$\"\u0001\r7\t\u000bU:\u0001\u0019\u0001\u001c)\t\u001dIUK\u001c\u0017\u0002/\"\u0012qAW\u0001\u001fg&lW\u000f\\1uK\u001a\u000b\u0017\u000e\\;sK\u001a{'\u000fT1uKN$8i\\7nSR$2\u0001\r:}\u0011\u0015\u0019\b\u00021\u0001u\u0003%!\u0018M\u00197f)f\u0004X\r\u0005\u0002vu6\taO\u0003\u0002xq\u0006)Qn\u001c3fY*\u0011\u0011\u0010D\u0001\u0007G>lWn\u001c8\n\u0005m4(a\u0004%p_\u0012LW\rV1cY\u0016$\u0016\u0010]3\t\u000buD\u0001\u0019\u0001@\u0002\u0019A\f'\u000f^5uS>t7i\u001c7\u0011\u0007}\f9A\u0004\u0003\u0002\u0002\u0005\r\u0001C\u0001\u001f\"\u0013\r\t)!I\u0001\u0007!J,G-\u001a4\n\u00071\nIAC\u0002\u0002\u0006\u0005\u0002")
public class TestPartitionStatsPruning
extends ColumnStatIndexTestBase {
    private final Seq<String> DEFAULT_COLUMNS_TO_INDEX = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{HoodieRecord.COMMIT_TIME_METADATA_FIELD, HoodieRecord.RECORD_KEY_METADATA_FIELD, HoodieRecord.PARTITION_PATH_METADATA_FIELD, "c1", "c2", "c3", "c4", "c5", "c6", "c7", "c8"}));

    public Seq<String> DEFAULT_COLUMNS_TO_INDEX() {
        return this.DEFAULT_COLUMNS_TO_INDEX;
    }

    @ParameterizedTest
    @MethodSource(value={"testMetadataColumnStatsIndexParamsInMemory"})
    public void testMetadataPSISimple(ColumnStatIndexTestBase.ColumnStatsTestCase testCase) {
        Map metadataOpts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_PARTITION_STATS.key()), (Object)"true")}));
        Map commonOpts = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)testCase.tableType().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"c1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"c1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"c8"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTableConfig.POPULATE_META_FIELDS.key()), (Object)"true")}))).$plus$plus((GenTraversableOnce)metadataOpts);
        ColumnStatIndexTestBase.ColumnStatsTestCase x$1 = testCase;
        Map x$2 = metadataOpts;
        Map x$3 = commonOpts;
        String x$4 = "index/colstats/input-table-json";
        String x$5 = "index/colstats/partition-stats-index-table.json";
        String x$6 = DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL();
        SaveMode x$7 = SaveMode.Overwrite;
        boolean x$8 = false;
        boolean x$9 = true;
        boolean x$10 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$9();
        String x$11 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$10();
        Integer x$12 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$11();
        Integer x$13 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$12();
        Integer x$14 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$13();
        Seq<String> x$15 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$15();
        this.doWriteAndValidateColumnStats(new ColumnStatIndexTestBase.ColumnStatsTestParams(x$1, (Map<String, String>)x$2, (Map<String, String>)x$3, x$4, x$5, x$6, x$7, x$8, x$10, x$11, x$12, x$13, x$14, x$9, x$15), this.doWriteAndValidateColumnStats$default$2());
    }

    @ParameterizedTest
    @MethodSource(value={"testMetadataColumnStatsIndexParamsInMemory"})
    public void testMetadataColumnStatsIndex(ColumnStatIndexTestBase.ColumnStatsTestCase testCase) {
        Map metadataOpts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_PARTITION_STATS.key()), (Object)"true")}));
        Map commonOpts = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)testCase.tableType().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"c1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"c1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"c8"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTableConfig.POPULATE_META_FIELDS.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.compact.inline.max.delta.commits"), (Object)"10")}))).$plus$plus((GenTraversableOnce)metadataOpts);
        ColumnStatIndexTestBase.ColumnStatsTestCase x$1 = testCase;
        Map x$2 = metadataOpts;
        Map x$3 = commonOpts;
        String x$4 = "index/colstats/input-table-json";
        String x$5 = "index/colstats/partition-stats-index-table.json";
        String x$6 = DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL();
        SaveMode x$7 = SaveMode.Overwrite;
        boolean x$8 = false;
        boolean x$9 = true;
        boolean x$10 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$9();
        String x$11 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$10();
        Integer x$12 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$11();
        Integer x$13 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$12();
        Integer x$14 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$13();
        Seq<String> x$15 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$15();
        this.doWriteAndValidateColumnStats(new ColumnStatIndexTestBase.ColumnStatsTestParams(x$1, (Map<String, String>)x$2, (Map<String, String>)x$3, x$4, x$5, x$6, x$7, x$8, x$10, x$11, x$12, x$13, x$14, x$9, x$15), this.doWriteAndValidateColumnStats$default$2());
        ColumnStatIndexTestBase.ColumnStatsTestCase x$16 = testCase;
        Map x$17 = metadataOpts;
        Map x$18 = commonOpts;
        String x$19 = "index/colstats/another-input-table-json";
        String x$20 = "index/colstats/updated-partition-stats-index-table.json";
        String x$21 = DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL();
        SaveMode x$22 = SaveMode.Append;
        boolean x$23 = false;
        boolean x$24 = true;
        boolean x$25 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$9();
        String x$26 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$10();
        Integer x$27 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$11();
        Integer x$28 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$12();
        Integer x$29 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$13();
        Seq<String> x$30 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$15();
        this.doWriteAndValidateColumnStats(new ColumnStatIndexTestBase.ColumnStatsTestParams(x$16, (Map<String, String>)x$17, (Map<String, String>)x$18, x$19, x$20, x$21, x$22, x$23, x$25, x$26, x$27, x$28, x$29, x$24, x$30), this.doWriteAndValidateColumnStats$default$2());
        ColumnStatIndexTestBase.ColumnStatsTestCase x$31 = testCase;
        Map x$32 = metadataOpts;
        Map x$33 = commonOpts;
        String x$34 = "index/colstats/update-input-table-json";
        String x$35 = "index/colstats/updated-partition-stats-2-index-table.json";
        String x$36 = DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL();
        SaveMode x$37 = SaveMode.Append;
        boolean x$38 = false;
        boolean x$39 = true;
        boolean x$40 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$9();
        String x$41 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$10();
        Integer x$42 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$11();
        Integer x$43 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$12();
        Integer x$44 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$13();
        Seq<String> x$45 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$15();
        this.doWriteAndValidateColumnStats(new ColumnStatIndexTestBase.ColumnStatsTestParams(x$31, (Map<String, String>)x$32, (Map<String, String>)x$33, x$34, x$35, x$36, x$37, x$38, x$40, x$41, x$42, x$43, x$44, x$39, x$45), this.doWriteAndValidateColumnStats$default$2());
        this.validateColumnsToIndex(this.metaClient, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{HoodieRecord.COMMIT_TIME_METADATA_FIELD, HoodieRecord.RECORD_KEY_METADATA_FIELD, HoodieRecord.PARTITION_PATH_METADATA_FIELD, "c1", "c2", "c3", "c4", "c5", "c6", "c7", "c8"}))));
        Map metadataOpts1 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_PARTITION_STATS.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COLUMN_STATS_INDEX_FOR_COLUMNS.key()), (Object)"c1,c2,c3,c5,c6,c7,c8")}));
        ColumnStatIndexTestBase.ColumnStatsTestCase x$46 = testCase;
        Map x$47 = metadataOpts1;
        Map x$48 = commonOpts;
        String x$49 = "index/colstats/update5-input-table-json";
        String x$50 = "index/colstats/updated-partition-stats-3-index-table.json";
        String x$51 = DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL();
        SaveMode x$52 = SaveMode.Append;
        boolean x$53 = false;
        boolean x$54 = true;
        boolean x$55 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$9();
        String x$56 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$10();
        Integer x$57 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$11();
        Integer x$58 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$12();
        Integer x$59 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$13();
        Seq<String> x$60 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$15();
        this.doWriteAndValidateColumnStats(new ColumnStatIndexTestBase.ColumnStatsTestParams(x$46, (Map<String, String>)x$47, (Map<String, String>)x$48, x$49, x$50, x$51, x$52, x$53, x$55, x$56, x$57, x$58, x$59, x$54, x$60), this.doWriteAndValidateColumnStats$default$2());
        this.validateColumnsToIndex(this.metaClient, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{HoodieRecord.COMMIT_TIME_METADATA_FIELD, HoodieRecord.RECORD_KEY_METADATA_FIELD, HoodieRecord.PARTITION_PATH_METADATA_FIELD, "c1", "c2", "c3", "c5", "c6", "c7", "c8"}))));
        Map metadataOpts2 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_PARTITION_STATS.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COLUMN_STATS_INDEX_FOR_COLUMNS.key()), (Object)"c1,c2,c3,c5,c7,c8")}));
        ColumnStatIndexTestBase.ColumnStatsTestCase x$61 = testCase;
        Map x$62 = metadataOpts2;
        Map x$63 = commonOpts;
        String x$64 = "index/colstats/update6-input-table-json";
        String x$65 = "index/colstats/updated-partition-stats-4-index-table.json";
        String x$66 = DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL();
        SaveMode x$67 = SaveMode.Append;
        boolean x$68 = false;
        boolean x$69 = true;
        boolean x$70 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$9();
        String x$71 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$10();
        Integer x$72 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$11();
        Integer x$73 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$12();
        Integer x$74 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$13();
        Seq<String> x$75 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$15();
        this.doWriteAndValidateColumnStats(new ColumnStatIndexTestBase.ColumnStatsTestParams(x$61, (Map<String, String>)x$62, (Map<String, String>)x$63, x$64, x$65, x$66, x$67, x$68, x$70, x$71, x$72, x$73, x$74, x$69, x$75), this.doWriteAndValidateColumnStats$default$2());
        this.validateColumnsToIndex(this.metaClient, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{HoodieRecord.COMMIT_TIME_METADATA_FIELD, HoodieRecord.RECORD_KEY_METADATA_FIELD, HoodieRecord.PARTITION_PATH_METADATA_FIELD, "c1", "c2", "c3", "c5", "c7", "c8"}))));
        Map metadataOpts3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_PARTITION_STATS.key()), (Object)"false")}));
        this.doWriteAndValidateColumnStats(new ColumnStatIndexTestBase.ColumnStatsTestParams(testCase, (Map<String, String>)metadataOpts3, (Map<String, String>)commonOpts, "index/colstats/update6-input-table-json", "", DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, false, false, ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$10(), ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$11(), ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$12(), ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$13(), ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$14(), ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$15()), this.doWriteAndValidateColumnStats$default$2());
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        this.validateNonExistantColumnsToIndexDefn(this.metaClient);
    }

    @ParameterizedTest
    @MethodSource(value={"testMetadataColumnStatsIndexParamsInMemory"})
    public void testMetadataColumnStatsIndexInitializationWithUpserts(ColumnStatIndexTestBase.ColumnStatsTestCase testCase) {
        String partitionCol = "c8";
        Map metadataOpts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_PARTITION_STATS.key()), (Object)"false")}));
        Map commonOpts = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)testCase.tableType().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"c1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"c1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)partitionCol), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTableConfig.POPULATE_META_FIELDS.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key()), (Object)"3")}))).$plus$plus((GenTraversableOnce)metadataOpts);
        ColumnStatIndexTestBase.ColumnStatsTestCase x$1 = testCase;
        Map x$2 = metadataOpts;
        Map x$3 = commonOpts;
        String x$4 = "index/colstats/input-table-json";
        Object x$5 = null;
        String x$6 = DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL();
        SaveMode x$7 = SaveMode.Overwrite;
        boolean x$8 = false;
        Integer x$9 = Predef$.MODULE$.int2Integer(1);
        Integer x$10 = Predef$.MODULE$.int2Integer(0x6400000);
        Integer x$11 = Predef$.MODULE$.int2Integer(0);
        boolean x$12 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$9();
        String x$13 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$10();
        boolean x$14 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$14();
        Seq<String> x$15 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$15();
        this.doWriteAndValidateColumnStats(new ColumnStatIndexTestBase.ColumnStatsTestParams(x$1, (Map<String, String>)x$2, (Map<String, String>)x$3, x$4, null, x$6, x$7, x$8, x$12, x$13, x$9, x$10, x$11, x$14, x$15), this.doWriteAndValidateColumnStats$default$2());
        Map metadataOpts0 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_PARTITION_STATS.key()), (Object)"false")}));
        ColumnStatIndexTestBase.ColumnStatsTestCase x$16 = testCase;
        Map x$17 = metadataOpts0;
        Map x$18 = commonOpts;
        String x$19 = "index/colstats/update2-input-table-json/";
        String x$20 = "";
        String x$21 = DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL();
        SaveMode x$22 = SaveMode.Append;
        Integer x$23 = Predef$.MODULE$.int2Integer(1);
        Integer x$24 = Predef$.MODULE$.int2Integer(0x6400000);
        Integer x$25 = Predef$.MODULE$.int2Integer(0);
        boolean x$26 = false;
        boolean x$27 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$9();
        String x$28 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$10();
        boolean x$29 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$14();
        Seq<String> x$30 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$15();
        this.doWriteAndValidateColumnStats(new ColumnStatIndexTestBase.ColumnStatsTestParams(x$16, (Map<String, String>)x$17, (Map<String, String>)x$18, x$19, x$20, x$21, x$22, x$26, x$27, x$28, x$23, x$24, x$25, x$29, x$30), this.doWriteAndValidateColumnStats$default$2());
        ColumnStatIndexTestBase.ColumnStatsTestCase x$31 = testCase;
        Map x$32 = metadataOpts0;
        Map x$33 = commonOpts;
        String x$34 = "index/colstats/delete-input-table-json/";
        String x$35 = "";
        String x$36 = DataSourceWriteOptions$.MODULE$.DELETE_OPERATION_OPT_VAL();
        SaveMode x$37 = SaveMode.Append;
        Integer x$38 = Predef$.MODULE$.int2Integer(1);
        Integer x$39 = Predef$.MODULE$.int2Integer(0x6400000);
        Integer x$40 = Predef$.MODULE$.int2Integer(0);
        boolean x$41 = false;
        boolean x$42 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$9();
        String x$43 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$10();
        boolean x$44 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$14();
        Seq<String> x$45 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$15();
        this.doWriteAndValidateColumnStats(new ColumnStatIndexTestBase.ColumnStatsTestParams(x$31, (Map<String, String>)x$32, (Map<String, String>)x$33, x$34, x$35, x$36, x$37, x$41, x$42, x$43, x$38, x$39, x$40, x$44, x$45), this.doWriteAndValidateColumnStats$default$2());
        Map metadataOpts1 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_PARTITION_STATS.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COLUMN_STATS_INDEX_FOR_COLUMNS.key()), (Object)"c1,c2,c3,c4,c5,c6,c7,c8")}));
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        String latestCompletedCommit = ((HoodieInstant)this.metaClient.getActiveTimeline().filterCompletedInstants().lastInstant().get()).requestedTime();
        HoodieTableType hoodieTableType = testCase.tableType();
        HoodieTableType hoodieTableType2 = HoodieTableType.COPY_ON_WRITE;
        String expectedColStatsSourcePath = !(hoodieTableType != null ? !hoodieTableType.equals(hoodieTableType2) : hoodieTableType2 != null) ? "index/colstats/cow-bootstrap1-partition-stats-index-table.json" : "index/colstats/mor-bootstrap1-partition-stats-index-table.json";
        ColumnStatIndexTestBase.ColumnStatsTestCase x$46 = testCase;
        Map x$47 = metadataOpts1;
        Map x$48 = commonOpts;
        String x$49 = "index/colstats/update3-input-table-json";
        String x$50 = expectedColStatsSourcePath;
        String x$51 = DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL();
        SaveMode x$52 = SaveMode.Append;
        String x$53 = latestCompletedCommit;
        Integer x$54 = Predef$.MODULE$.int2Integer(1);
        Integer x$55 = Predef$.MODULE$.int2Integer(0x6400000);
        Integer x$56 = Predef$.MODULE$.int2Integer(0);
        boolean x$57 = false;
        boolean x$58 = true;
        boolean x$59 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$9();
        Seq<String> x$60 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$15();
        this.doWriteAndValidateColumnStats(new ColumnStatIndexTestBase.ColumnStatsTestParams(x$46, (Map<String, String>)x$47, (Map<String, String>)x$48, x$49, x$50, x$51, x$52, x$57, x$59, x$53, x$54, x$55, x$56, x$58, x$60), this.doWriteAndValidateColumnStats$default$2());
        HoodieTableType hoodieTableType3 = testCase.tableType();
        HoodieTableType hoodieTableType4 = HoodieTableType.COPY_ON_WRITE;
        expectedColStatsSourcePath = !(hoodieTableType3 != null ? !hoodieTableType3.equals(hoodieTableType4) : hoodieTableType4 != null) ? "index/colstats/cow-bootstrap2-partition-stats-index-table.json" : "index/colstats/mor-bootstrap2-partition-stats-index-table.json";
        ColumnStatIndexTestBase.ColumnStatsTestCase x$61 = testCase;
        Map x$62 = metadataOpts1;
        Map x$63 = commonOpts;
        String x$64 = "index/colstats/update4-input-table-json";
        String x$65 = expectedColStatsSourcePath;
        String x$66 = DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL();
        SaveMode x$67 = SaveMode.Append;
        String x$68 = latestCompletedCommit;
        Integer x$69 = Predef$.MODULE$.int2Integer(1);
        Integer x$70 = Predef$.MODULE$.int2Integer(0x6400000);
        Integer x$71 = Predef$.MODULE$.int2Integer(0);
        boolean x$72 = false;
        boolean x$73 = true;
        boolean x$74 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$9();
        Seq<String> x$75 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$15();
        this.doWriteAndValidateColumnStats(new ColumnStatIndexTestBase.ColumnStatsTestParams(x$61, (Map<String, String>)x$62, (Map<String, String>)x$63, x$64, x$65, x$66, x$67, x$72, x$74, x$68, x$69, x$70, x$71, x$73, x$75), this.doWriteAndValidateColumnStats$default$2());
        this.validateColumnsToIndex(this.metaClient, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{HoodieRecord.COMMIT_TIME_METADATA_FIELD, HoodieRecord.RECORD_KEY_METADATA_FIELD, HoodieRecord.PARTITION_PATH_METADATA_FIELD, "c1", "c2", "c3", "c4", "c5", "c6", "c7", "c8"}))));
    }

    @ParameterizedTest
    @MethodSource(value={"testMetadataColumnStatsIndexParamsInMemory"})
    public void testMetadataColumnStatsIndexInitializationWithRollbacks(ColumnStatIndexTestBase.ColumnStatsTestCase testCase) {
        String partitionCol = "c8";
        Map metadataOpts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"false")}));
        Map commonOpts = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)testCase.tableType().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"c1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"c1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)partitionCol), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.write.markers.type"), (Object)"DIRECT"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTableConfig.POPULATE_META_FIELDS.key()), (Object)"true")}))).$plus$plus((GenTraversableOnce)metadataOpts);
        ColumnStatIndexTestBase.ColumnStatsTestCase x$1 = testCase;
        Map x$2 = metadataOpts;
        Map x$3 = commonOpts;
        String x$4 = "index/colstats/input-table-json";
        Object x$5 = null;
        String x$6 = DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL();
        SaveMode x$7 = SaveMode.Overwrite;
        boolean x$8 = false;
        Integer x$9 = Predef$.MODULE$.int2Integer(1);
        Integer x$10 = Predef$.MODULE$.int2Integer(0x6400000);
        Integer x$11 = Predef$.MODULE$.int2Integer(0);
        boolean x$12 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$9();
        String x$13 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$10();
        boolean x$14 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$14();
        Seq<String> x$15 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$15();
        this.doWriteAndValidateColumnStats(new ColumnStatIndexTestBase.ColumnStatsTestParams(x$1, (Map<String, String>)x$2, (Map<String, String>)x$3, x$4, null, x$6, x$7, x$8, x$12, x$13, x$9, x$10, x$11, x$14, x$15), this.doWriteAndValidateColumnStats$default$2());
        ColumnStatIndexTestBase.ColumnStatsTestCase x$16 = testCase;
        Map x$17 = metadataOpts;
        Map x$18 = commonOpts;
        String x$19 = "index/colstats/update2-input-table-json/";
        Object x$20 = null;
        String x$21 = DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL();
        SaveMode x$22 = SaveMode.Append;
        boolean x$23 = false;
        Integer x$24 = Predef$.MODULE$.int2Integer(1);
        Integer x$25 = Predef$.MODULE$.int2Integer(0x6400000);
        Integer x$26 = Predef$.MODULE$.int2Integer(0);
        boolean x$27 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$9();
        String x$28 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$10();
        boolean x$29 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$14();
        Seq<String> x$30 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$15();
        this.doWriteAndValidateColumnStats(new ColumnStatIndexTestBase.ColumnStatsTestParams(x$16, (Map<String, String>)x$17, (Map<String, String>)x$18, x$19, null, x$21, x$22, x$23, x$27, x$28, x$24, x$25, x$26, x$29, x$30), this.doWriteAndValidateColumnStats$default$2());
        this.simulateFailureForLatestCommit(testCase.tableType(), partitionCol);
        Map metadataOpts1 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_PARTITION_STATS.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COLUMN_STATS_INDEX_FOR_COLUMNS.key()), (Object)"c1,c2,c3,c4,c5,c6,c7,c8")}));
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        String latestCompletedCommit = ((HoodieInstant)this.metaClient.getActiveTimeline().filterCompletedInstants().lastInstant().get()).requestedTime();
        ColumnStatIndexTestBase.ColumnStatsTestCase x$31 = testCase;
        Map x$32 = metadataOpts1;
        Map x$33 = commonOpts;
        String x$34 = "index/colstats/update3-input-table-json";
        String x$35 = "index/colstats/cow-bootstrap-rollback1-partition-stats-index-table.json";
        String x$36 = DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL();
        SaveMode x$37 = SaveMode.Append;
        String x$38 = latestCompletedCommit;
        Integer x$39 = Predef$.MODULE$.int2Integer(1);
        Integer x$40 = Predef$.MODULE$.int2Integer(0x6400000);
        Integer x$41 = Predef$.MODULE$.int2Integer(0);
        boolean x$42 = false;
        boolean x$43 = true;
        boolean x$44 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$9();
        Seq<String> x$45 = ColumnStatIndexTestBase$ColumnStatsTestParams$.MODULE$.apply$default$15();
        this.doWriteAndValidateColumnStats(new ColumnStatIndexTestBase.ColumnStatsTestParams(x$31, (Map<String, String>)x$32, (Map<String, String>)x$33, x$34, x$35, x$36, x$37, x$42, x$44, x$38, x$39, x$40, x$41, x$43, x$45), this.doWriteAndValidateColumnStats$default$2());
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        Assertions.assertTrue((this.metaClient.getActiveTimeline().getRollbackTimeline().countInstants() > 0 ? 1 : 0) != 0);
        this.validateColumnsToIndex(this.metaClient, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{HoodieRecord.COMMIT_TIME_METADATA_FIELD, HoodieRecord.RECORD_KEY_METADATA_FIELD, HoodieRecord.PARTITION_PATH_METADATA_FIELD, "c1", "c2", "c3", "c4", "c5", "c6", "c7", "c8"}))));
    }

    public void simulateFailureForLatestCommit(HoodieTableType tableType, String partitionCol) {
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        String baseFileName = null;
        String logFileName = null;
        HoodieInstant lastCompletedCommit = (HoodieInstant)this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().lastInstant().get();
        HoodieTableType hoodieTableType = tableType;
        HoodieTableType hoodieTableType2 = HoodieTableType.MERGE_ON_READ;
        if (!(hoodieTableType != null ? !hoodieTableType.equals(hoodieTableType2) : hoodieTableType2 != null)) {
            List dataFiles = StringUtils.isNullOrEmpty((String)partitionCol) ? this.metaClient.getStorage().listFiles(new StoragePath(this.metaClient.getBasePath(), "/")) : this.metaClient.getStorage().listFiles(new StoragePath(this.metaClient.getBasePath(), "9"));
            StoragePathInfo logFileFileStatus = dataFiles.stream().filter(fileStatus -> fileStatus.getPath().getName().contains(".log")).findFirst().get();
            logFileName = logFileFileStatus.getPath().getName();
        } else {
            List dataFiles = StringUtils.isNullOrEmpty((String)partitionCol) ? this.metaClient.getStorage().listFiles(new StoragePath(this.metaClient.getBasePath().toString())) : this.metaClient.getStorage().listFiles(new StoragePath(this.metaClient.getBasePath(), "9"));
            StoragePathInfo baseFileFileStatus = dataFiles.stream().filter(fileStatus -> fileStatus.getPath().getName().contains(lastCompletedCommit.requestedTime())).findFirst().get();
            baseFileName = baseFileFileStatus.getPath().getName();
        }
        String latestCompletedFileName = HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.getFileName(lastCompletedCommit);
        this.metaClient.getStorage().deleteFile(new StoragePath(new StringBuilder(18).append(this.metaClient.getBasePath().toString()).append("/.hoodie/timeline/").append(latestCompletedFileName).toString()));
        HoodieTableType hoodieTableType3 = tableType;
        HoodieTableType hoodieTableType4 = HoodieTableType.MERGE_ON_READ;
        if (!(hoodieTableType3 != null ? !hoodieTableType3.equals(hoodieTableType4) : hoodieTableType4 != null)) {
            if (StringUtils.isNullOrEmpty((String)partitionCol)) {
                this.metaClient.getStorage().create(new StoragePath(new StringBuilder(30).append(this.metaClient.getBasePath().toString()).append("/.hoodie/.temp/").append(lastCompletedCommit.requestedTime()).append("/").append(logFileName).append(".marker.APPEND").toString()));
                return;
            }
            this.metaClient.getStorage().create(new StoragePath(new StringBuilder(32).append(this.metaClient.getBasePath().toString()).append("/.hoodie/.temp/").append(lastCompletedCommit.requestedTime()).append("/9/").append(logFileName).append(".marker.APPEND").toString()));
            return;
        }
        if (StringUtils.isNullOrEmpty((String)partitionCol)) {
            this.metaClient.getStorage().create(new StoragePath(new StringBuilder(29).append(this.metaClient.getBasePath().toString()).append("/.hoodie/.temp/").append(lastCompletedCommit.requestedTime()).append("/").append(baseFileName).append(".marker.MERGE").toString()));
            return;
        }
        this.metaClient.getStorage().create(new StoragePath(new StringBuilder(31).append(this.metaClient.getBasePath().toString()).append("/.hoodie/.temp/").append(lastCompletedCommit.requestedTime()).append("/9/").append(baseFileName).append(".marker.MERGE").toString()));
    }
}

