/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.transaction.PreferWriterConflictResolutionStrategy;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.ActionType;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.InProcessTimeGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieWriteConflictException;
import org.apache.hudi.functional.RecordLevelIndexTestBase;
import org.apache.hudi.functional.TestRecordLevelIndex$;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.util.JavaConversions$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.functions$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Try;
import scala.util.Using;
import scala.util.Using$;

@Tag(value="functional")
@ScalaSignature(bytes="\u0006\u0001\tub\u0001B\u000f\u001f\u0001\u001dBQ\u0001\f\u0001\u0005\u00025BQa\f\u0001\u0005\u0002ABQ!\u0016\u0001\u0005\u0002YCQA\u0018\u0001\u0005\n}CQa\u001b\u0001\u0005\u00021DQ\u0001\u001d\u0001\u0005\u0002EDQ!\u001e\u0001\u0005\u0002YDq!a\u0006\u0001\t\u0003\tI\u0002C\u0004\u0002\"\u0001!\t!a\t\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.!9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0002BBA.\u0001\u0011\u0005a\u000bC\u0004\u0002`\u0001!\t!!\u0019\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!9\u00111\u000f\u0001\u0005\u0002\u0005U\u0004bBA?\u0001\u0011\u0005\u0011q\u0010\u0005\u0007\u0003\u000f\u0003A\u0011\u0001,\t\u000f\u0005-\u0005\u0001\"\u0001\u0002\u000e\"9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0005bBA_\u0001\u0011\u0005\u0011q\u0018\u0005\b\u0003/\u0004A\u0011AAm\u0011\u001d\t\t\u000f\u0001C\u0001\u0003GDq!a;\u0001\t\u0003\ti\u000f\u0003\u0007\u0002v\u0002\u0001\n\u0011!A\u0001\n\u0003\t9pB\u0004\u0003\u0014yA\tA!\u0006\u0007\ruq\u0002\u0012\u0001B\f\u0011\u0019a#\u0004\"\u0001\u0003 !9\u00111\u001b\u000e\u0005\u0002\t\u0005\"\u0001\u0006+fgR\u0014VmY8sI2+g/\u001a7J]\u0012,\u0007P\u0003\u0002 A\u0005Qa-\u001e8di&|g.\u00197\u000b\u0005\u0005\u0012\u0013\u0001\u00025vI&T!a\t\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0013aA8sO\u000e\u00011C\u0001\u0001)!\tI#&D\u0001\u001f\u0013\tYcD\u0001\rSK\u000e|'\u000f\u001a'fm\u0016d\u0017J\u001c3fqR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#\u0001\u0018\u0011\u0005%\u0002\u0011!\u0006;fgR\u0014F*S%oSRL\u0017\r\\5{CRLwN\u001c\u000b\u0003c]\u0002\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012A!\u00168ji\")\u0001H\u0001a\u0001s\u0005IA/\u00192mKRK\b/\u001a\t\u0003u}j\u0011a\u000f\u0006\u0003yu\nQ!\\8eK2T!A\u0010\u0011\u0002\r\r|W.\\8o\u0013\t\u00015HA\bI_>$\u0017.\u001a+bE2,G+\u001f9fQ\u0011\u0011!IT(\u0011\u0005\rcU\"\u0001#\u000b\u0005\u00153\u0015\u0001\u00039s_ZLG-\u001a:\u000b\u0005\u001dC\u0015A\u00029be\u0006l7O\u0003\u0002J\u0015\u00069!.\u001e9ji\u0016\u0014(BA&%\u0003\u0015QWO\\5u\u0013\tiEI\u0001\u0006F]Vl7k\\;sG\u0016\fQA^1mk\u0016\u001c\u0013!\u000f\u0015\u0003\u0005E\u0003\"AU*\u000e\u0003\u0019K!\u0001\u0016$\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0014uKN$(\u000bT%J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8G_JluN]$m_\n\fG.\u00138eKb$\u0012!\r\u0015\u0003\u0007a\u0003\"!\u0017/\u000e\u0003iS!a\u0017%\u0002\u0007\u0005\u0004\u0018.\u0003\u0002^5\n!A+Z:u\u0003E9W\r\u001e(fo&s7\u000f^1oiRKW.\u001a\u000b\u0002AB\u0011\u0011\r\u001b\b\u0003E\u001a\u0004\"aY\u001a\u000e\u0003\u0011T!!\u001a\u0014\u0002\rq\u0012xn\u001c;?\u0013\t97'\u0001\u0004Qe\u0016$WMZ\u0005\u0003S*\u0014aa\u0015;sS:<'BA44\u00035!Xm\u001d;S\u0019&+\u0006o]3siR\u0011\u0011'\u001c\u0005\u0006q\u0015\u0001\r!\u000f\u0015\u0005\u000b\tsu\n\u000b\u0002\u0006#\u0006YB/Z:u%2KU\u000b]:feRtuN\u001c)beRLG/[8oK\u0012$\"!\r:\t\u000ba2\u0001\u0019A\u001d)\t\u0019\u0011ej\u0014\u0015\u0003\rE\u000bA\u0005^3tiJc\u0015JQ;mW&s7/\u001a:u)\",g.\u00138tKJ$xJ^3soJLG/\u001a\u000b\u0004c]D\b\"\u0002\u001d\b\u0001\u0004I\u0004\"B=\b\u0001\u0004Q\u0018aD3oC\ndWMU8x/JLG/\u001a:\u0011\u0005IZ\u0018B\u0001?4\u0005\u001d\u0011un\u001c7fC:DSa\u0002@O\u0003\u0007\u0001\"aQ@\n\u0007\u0005\u0005AIA\u0005DgZ\u001cv.\u001e:dK2B\u0011QAA\u0005\u0003\u001b\t\t\"\t\u0002\u0002\b\u0005\u00112i\u0014)Z?>sul\u0016*J)\u0016cCO];fC\t\tY!A\nD\u001fBKvl\u0014(`/JKE+\u0012\u0017gC2\u001cX-\t\u0002\u0002\u0010\u0005\u0011R*\u0012*H\u000b~{ej\u0018*F\u0003\u0012cCO];fC\t\t\u0019\"A\nN\u000bJ;UiX(O?J+\u0015\t\u0012\u0017gC2\u001cX\r\u000b\u0002\b#\u0006AB/Z:u%2KU\u000b]:feR\fe\u000e\u001a*pY2\u0014\u0017mY6\u0015\u0007E\nY\u0002C\u00039\u0011\u0001\u0007\u0011\b\u000b\u0003\t\u0005:{\u0005F\u0001\u0005R\u0003\u001d\"Xm\u001d;S\u0019&\u0003\u0016M\u001d;jC2d\u0017PR1jY\u0016$W\u000b]:feR\fe\u000e\u001a*pY2\u0014\u0017mY6\u0015\u0007E\n)\u0003C\u00039\u0013\u0001\u0007\u0011\b\u000b\u0003\n\u0005:{\u0005FA\u0005R\u0003Q\"Xm\u001d;S\u0019&\u0003\u0016M\u001d;jC2d\u0017PR1jY\u0016$W*\u001a;bI\u0006$\u0018\rV1cY\u0016\u001cu.\\7ji\u0006sGMU8mY\n\f7m\u001b\u000b\u0004c\u0005=\u0002\"\u0002\u001d\u000b\u0001\u0004I\u0004\u0006\u0002\u0006C\u001d>C#AC)\u0002#Q,7\u000f\u001e*M\u0013^KG\u000f\u001b#fY\u0016$X\rF\u00032\u0003s\tY\u0004C\u00039\u0017\u0001\u0007\u0001\rC\u0004\u0002>-\u0001\r!a\u0010\u0002\u0019Q\f'\r\\3WKJ\u001c\u0018n\u001c8\u0011\u0007I\n\t%C\u0002\u0002DM\u00121!\u00138uQ\u0015YaPTA$Y!\tI%!\u0014\u0002R\u0005U\u0013EAA&\u0003=\u0019u\nU-`\u001f:{vKU%U\u000b22\u0014EAA(\u0003=\u0019u\nU-`\u001f:{vKU%U\u000b2B\u0014EAA*\u0003=iUIU$F?>suLU#B\t22\u0014EAA,\u0003=iUIU$F?>suLU#B\t2B\u0004FA\u0006R\u0003]!Xm\u001d;S\u0019&;\u0016\u000e\u001e5F[B$\u0018\u0010U1zY>\fG\r\u000b\u0002\r1\u0006QC/Z:u%2Kei\u001c:EK2,G/Z:XSRD\u0007j\\8eS\u0016L5\u000fR3mKR,GmQ8mk6tGcA\u0019\u0002d!)\u0001(\u0004a\u0001s!\"QB\u0011(PQ\ti\u0011+\u0001\u000euKN$(\u000bT%XSRDG)\u001a7fi\u0016\u0004\u0016M\u001d;ji&|g\u000eF\u00022\u0003[BQ\u0001\u000f\bA\u0002eBCA\u0004\"O\u001f\"\u0012a\"U\u0001\u001ai\u0016\u001cHO\u0015'J+B\u001cXM\u001d;B]\u0012$%o\u001c9J]\u0012,\u0007\u0010F\u00022\u0003oBQ\u0001O\bA\u0002eBCa\u0004\"O\u001f\"\u0012q\"U\u0001\u0016i\u0016\u001cHO\u0015'J/&$\b\u000e\u0012+DY\u0016\fg.\u001b8h)\r\t\u0014\u0011\u0011\u0005\u0006qA\u0001\r!\u000f\u0015\u0005!\tsu\n\u000b\u0002\u0011#\u00069B/Z:u%2Ku+\u001b;i\tR\u001bu.\u001c9bGRLwN\u001c\u0015\u0003#a\u000bq\u0003^3tiJc\u0015jV5uQ\u0012#6\t\\;ti\u0016\u0014\u0018N\\4\u0015\u0007E\ny\tC\u00039%\u0001\u0007\u0011\b\u000b\u0003\u0013\u0005:{\u0005F\u0001\nR\u0003\t\"Xm\u001d;S\u0019&;\u0016\u000e\u001e5Pi\",'/T3uC\u0012\fG/\u0019)beRLG/[8ogR)\u0011'!'\u0002\u001c\")\u0001h\u0005a\u0001A\"1\u0011QT\nA\u0002\u0001\fa#\\3uC\u0012\fG/\u0019)beRLG/[8o)f\u0004Xm\u001d\u0015\u0006'yt\u0015\u0011\u0015\u0017\r\u0003G\u000b9+a+\u00020\u0006M\u0016qW\u0011\u0003\u0003K\u000b!dQ(Q3~{ejX,S\u0013R+EfQ(M+6sul\u0015+B)N\u000b#!!+\u00027\r{\u0005+W0P\u001d~;&+\u0013+FY\tcujT'`\r&cE+\u0012*TC\t\ti+\u0001\u0015D\u001fBKvl\u0014(`/JKE+\u0012\u0017D\u001f2+VJT0T)\u0006#6K\u000f\"M\u001f>kuLR%M)\u0016\u00136+\t\u0002\u00022\u0006QR*\u0012*H\u000b~{ej\u0018*F\u0003\u0012c3i\u0014'V\u001b:{6\u000bV!U'\u0006\u0012\u0011QW\u0001\u001c\u001b\u0016\u0013v)R0P\u001d~\u0013V)\u0011#-\u00052{u*T0G\u00132#VIU*\"\u0005\u0005e\u0016\u0001K'F%\u001e+ul\u0014(`%\u0016\u000bE\tL\"P\u0019VkejX*U\u0003R\u001b&H\u0011'P\u001f6{f)\u0013'U\u000bJ\u001b\u0006FA\nR\u0003Q!Xm\u001d;F]\u0006\u0014G.\u001a#jg\u0006\u0014G.\u001a*M\u0013R)\u0011'!1\u0002D\")\u0001\b\u0006a\u0001s!1\u0011Q\u0019\u000bA\u0002i\fQ\"[:QCJ$\u0018\u000e^5p]\u0016$\u0007F\u0002\u000b\u0002J:\u000by\rE\u0002D\u0003\u0017L1!!4E\u00051iU\r\u001e5pIN{WO]2fY\t\t\t.\t\u0002\u0002T\u0006QB/Z:u\u000b:\f'\r\\3ESN\f'\r\\3S\u0019&\u0003\u0016M]1ng\"\u0012A#U\u0001\u0019i\u0016\u001cHO\u0015'J/&$\b.\u0014#U\u0007>l\u0007/Y2uS>tGcA\u0019\u0002\\\")\u0001(\u0006a\u0001s!\"QC\u0011(PQ\t)\u0012+\u0001\fuKN$(\u000bT%XSRDW\n\u0012+DY\u0016\fg.\u001b8h)\r\t\u0014Q\u001d\u0005\u0006qY\u0001\r!\u000f\u0015\u0005-\tsu\n\u000b\u0002\u0017#\u00061B/Z:u%2Ku+\u001b;i\u001bVdG/[,sSR,'\u000fF\u00022\u0003_DQ\u0001O\fA\u0002eBCa\u0006\"O\u001f\"\u0012q#U\u0001\u0012aJ|G/Z2uK\u0012$C-\u0019;b\u000f\u0016tG\u0003BA}\u0005\u000b\u0001B!a?\u0003\u00025\u0011\u0011Q \u0006\u0004\u0003\u007fl\u0014!\u0003;fgR,H/\u001b7t\u0013\u0011\u0011\u0019!!@\u0003/!{w\u000eZ5f)\u0016\u001cH\u000fR1uC\u001e+g.\u001a:bi>\u0014\b\u0002\u0003B\u00041\u0005\u0005\t\u0019\u0001\u0018\u0002\u0007a$\u0013\u0007\u000b\u0004\u0001\u0005\u0017q%\u0011\u0003\t\u00043\n5\u0011b\u0001B\b5\n\u0019A+Y4\"\u0003}\tA\u0003V3tiJ+7m\u001c:e\u0019\u00164X\r\\%oI\u0016D\bCA\u0015\u001b'\rQ\"\u0011\u0004\t\u0004e\tm\u0011b\u0001B\u000fg\t1\u0011I\\=SK\u001a$\"A!\u0006\u0015\u0005\t\r\u0002C\u0002B\u0013\u0005g\u00119$\u0004\u0002\u0003()!!\u0011\u0006B\u0016\u0003\u0019\u0019HO]3b[*!!Q\u0006B\u0018\u0003\u0011)H/\u001b7\u000b\u0005\tE\u0012\u0001\u00026bm\u0006LAA!\u000e\u0003(\t11\u000b\u001e:fC6\u00042a\u0011B\u001d\u0013\r\u0011Y\u0004\u0012\u0002\n\u0003J<W/\\3oiN\u0004")
public class TestRecordLevelIndex
extends RecordLevelIndexTestBase {
    public static Stream<Arguments> testEnableDisableRLIParams() {
        return TestRecordLevelIndex$.MODULE$.testEnableDisableRLIParams();
    }

    public /* synthetic */ HoodieTestDataGenerator protected$dataGen(TestRecordLevelIndex x$1) {
        return x$1.dataGen;
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIInitialization(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
    }

    @Test
    public void testRLIInitializationForMorGlobalIndex() {
        HoodieTableType tableType = HoodieTableType.MERGE_ON_READ;
        scala.collection.immutable.Map hudiOpts = (scala.collection.immutable.Map)this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name())).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.RECORD_INDEX_MIN_FILE_GROUP_COUNT_PROP.key()), (Object)"1")).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.RECORD_INDEX_MAX_FILE_GROUP_COUNT_PROP.key()), (Object)"1")).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndexConfig.INDEX_TYPE.key()), (Object)"RECORD_INDEX")).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndexConfig.RECORD_INDEX_UPDATE_PARTITION_PATH_ENABLE.key()), (Object)"true")).$minus((Object)HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key());
        HoodieTestDataGenerator dataGen1 = HoodieTestDataGenerator.createTestGeneratorFirstPartition();
        HoodieTestDataGenerator dataGen2 = HoodieTestDataGenerator.createTestGeneratorSecondPartition();
        String instantTime1 = this.getNewInstantTime();
        Seq latestBatch = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen1.generateInserts(instantTime1, Predef$.MODULE$.int2Integer(5)))).asScala()).toSeq();
        String operation = DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL();
        Dataset latestBatchDf = this.spark().read().json(this.spark().sparkContext().parallelize(latestBatch, 1, ClassTag$.MODULE$.apply(String.class)));
        latestBatchDf.cache();
        latestBatchDf.write().format("org.apache.hudi").options((Map)hudiOpts).mode(SaveMode.Overwrite).save(this.basePath);
        Dataset<Row> deletedDf1 = this.calculateMergedDf((Dataset<Row>)latestBatchDf, operation, true);
        deletedDf1.cache();
        String instantTime2 = this.getNewInstantTime();
        Seq latestBatch2_1 = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen1.generateUniqueUpdates(instantTime2, Predef$.MODULE$.int2Integer(3)))).asScala()).toSeq();
        Dataset latestBatchDf2_1 = this.spark().read().json(this.spark().sparkContext().parallelize(latestBatch2_1, 1, ClassTag$.MODULE$.apply(String.class)));
        Dataset latestBatchDf2_2 = latestBatchDf2_1.withColumn("partition", functions$.MODULE$.lit((Object)"2015/03/16")).withColumn("partition_path", functions$.MODULE$.lit((Object)"2015/03/16"));
        Seq latestBatch2_3 = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen2.generateInserts(instantTime2, Predef$.MODULE$.int2Integer(2)))).asScala()).toSeq();
        Dataset latestBatchDf2_3 = this.spark().read().json(this.spark().sparkContext().parallelize(latestBatch2_3, 1, ClassTag$.MODULE$.apply(String.class)));
        Dataset latestBatchDf2Final = latestBatchDf2_3.union(latestBatchDf2_2);
        latestBatchDf2Final.cache();
        latestBatchDf2Final.write().format("org.apache.hudi").options((Map)hudiOpts).mode(SaveMode.Append).save(this.basePath);
        operation = DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL();
        Dataset<Row> deletedDf2 = this.calculateMergedDf((Dataset<Row>)latestBatchDf2Final, operation, true);
        deletedDf2.cache();
        scala.collection.immutable.Map hudiOpts2 = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name())).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.RECORD_INDEX_MIN_FILE_GROUP_COUNT_PROP.key()), (Object)"1")).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.RECORD_INDEX_MAX_FILE_GROUP_COUNT_PROP.key()), (Object)"1")).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndexConfig.INDEX_TYPE.key()), (Object)"RECORD_INDEX")).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndexConfig.RECORD_INDEX_UPDATE_PARTITION_PATH_ENABLE.key()), (Object)"true")).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key()), (Object)"true"));
        String instantTime3 = this.getNewInstantTime();
        Seq latestBatch3 = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen2.generateUniqueUpdates(instantTime3, Predef$.MODULE$.int2Integer(2)))).asScala()).toSeq();
        Dataset latestBatchDf3 = this.spark().read().json(this.spark().sparkContext().parallelize(latestBatch3, 1, ClassTag$.MODULE$.apply(String.class)));
        latestBatchDf3.cache();
        latestBatchDf.write().format("org.apache.hudi").options((Map)hudiOpts2).mode(SaveMode.Append).save(this.basePath);
        Dataset<Row> deletedDf3 = this.calculateMergedDf((Dataset<Row>)latestBatchDf, operation, true);
        deletedDf3.cache();
        this.metaClient = HoodieTableMetaClient.builder().setBasePath(this.basePath).setConf(this.storageConf).build();
        this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts, deletedDf3);
    }

    private String getNewInstantTime() {
        return InProcessTimeGenerator.createNewInstantTime();
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIUpsert(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIUpsertNonPartitioned(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = ((scala.collection.immutable.Map)this.commonOpts().$minus((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key())).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
    }

    @ParameterizedTest
    @CsvSource(value={"COPY_ON_WRITE,true", "COPY_ON_WRITE,false", "MERGE_ON_READ,true", "MERGE_ON_READ,false"})
    public void testRLIBulkInsertThenInsertOverwrite(HoodieTableType tableType, boolean enableRowWriter) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.ENABLE_ROW_WRITER().key()), (Object)Boolean.toString(enableRowWriter))})));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OVERWRITE_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OVERWRITE_TABLE_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIUpsertAndRollback(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.rollbackLastInstant((scala.collection.immutable.Map<String, String>)hudiOpts);
        this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts, this.validateDataAndRecordIndices$default$2());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIPartiallyFailedUpsertAndRollback(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.deleteLastCompletedCommitFromTimeline((scala.collection.immutable.Map<String, String>)hudiOpts);
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIPartiallyFailedMetadataTableCommitAndRollback(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.deleteLastCompletedCommitFromDataAndMetadataTimeline((scala.collection.immutable.Map<String, String>)hudiOpts);
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
    }

    @ParameterizedTest
    @CsvSource(value={"COPY_ON_WRITE,6", "COPY_ON_WRITE,8", "MERGE_ON_READ,6", "MERGE_ON_READ,8"})
    public void testRLIWithDelete(String tableType, int tableVersion) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieTableConfig.VERSION.key()), (Object)Integer.toString(tableVersion)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.WRITE_TABLE_VERSION.key()), (Object)Integer.toString(tableVersion))})));
        Properties props = new Properties();
        hudiOpts.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TestRecordLevelIndex.$anonfun$testRLIWithDelete$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return props.put(k, v);
            }
            throw new MatchError((Object)tuple2);
        });
        this.initMetaClient(HoodieTableType.valueOf((String)tableType), props);
        Dataset<Row> insertDf = this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        Dataset deleteDf = insertDf.limit(1);
        deleteDf.write().format("org.apache.hudi").options((Map)hudiOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.DELETE_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(this.basePath);
        Dataset prevDf = (Dataset)this.mergedDfList().last();
        this.mergedDfList_$eq((List<Dataset<Row>>)((List)this.mergedDfList().$colon$plus((Object)prevDf.except(deleteDf), List$.MODULE$.canBuildFrom())));
        this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts, (Dataset<Row>)deleteDf);
    }

    @Test
    public void testRLIWithEmptyPayload() {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)HoodieTableType.MERGE_ON_READ.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT.key()), (Object)"0")})));
        Dataset<Row> insertDf = this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        Dataset deleteDf = insertDf.limit(2);
        deleteDf.cache();
        deleteDf.write().format("hudi").options((Map)hudiOpts).option("hoodie.datasource.write.payload.class", "org.apache.hudi.common.model.EmptyHoodieRecordPayload").mode(SaveMode.Append).save(this.basePath);
        Dataset prevDf = (Dataset)this.mergedDfList().last();
        this.mergedDfList_$eq((List<Dataset<Row>>)((List)this.mergedDfList().$colon$plus((Object)prevDf.except(deleteDf), List$.MODULE$.canBuildFrom())));
        this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts, (Dataset<Row>)deleteDf);
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIForDeletesWithHoodieIsDeletedColumn(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()));
        Dataset<Row> insertDf = this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        insertDf.cache();
        Buffer deleteBatch = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)this.dataGen.generateUniqueDeleteRecords(this.getNewInstantTime(), Predef$.MODULE$.int2Integer(1)))).asScala();
        Dataset deleteDf = this.spark().read().json(this.spark().sparkContext().parallelize(deleteBatch.toSeq(), 1, ClassTag$.MODULE$.apply(String.class)));
        deleteDf.cache();
        String recordKeyToDelete = (String)((Row)deleteDf.collectAsList().get(0)).getAs("_row_key");
        deleteDf.write().format("org.apache.hudi").options((Map)hudiOpts).mode(SaveMode.Append).save(this.basePath);
        Dataset prevDf = (Dataset)this.mergedDfList().last();
        this.mergedDfList_$eq((List<Dataset<Row>>)((List)this.mergedDfList().$colon$plus((Object)prevDf.filter((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)TestRecordLevelIndex.$anonfun$testRLIForDeletesWithHoodieIsDeletedColumn$1(recordKeyToDelete, row))), List$.MODULE$.canBuildFrom())));
        this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts, (Dataset<Row>)deleteDf);
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIWithDeletePartition(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()));
        Dataset<Row> latestSnapshot = this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.getHoodieWriteClient(this.getWriteConfig((scala.collection.immutable.Map<String, String>)hudiOpts)), (Function1 & Serializable & scala.Serializable)client -> {
            TestRecordLevelIndex.$anonfun$testRLIWithDeletePartition$2(this, latestSnapshot, hudiOpts, client);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIUpsertAndDropIndex(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        HoodieWriteConfig writeConfig = this.getWriteConfig((scala.collection.immutable.Map<String, String>)hudiOpts);
        writeConfig.setSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
        this.getHoodieWriteClient(writeConfig).dropIndex(Collections.singletonList(MetadataPartitionType.RECORD_INDEX.getPartitionPath()));
        Assertions.assertEquals((long)0L, (long)this.getFileGroupCountForRecordIndex(writeConfig));
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((int)0, (int)this.metaClient.getTableConfig().getMetadataPartitionsInflight().size());
        Assertions.assertEquals((int)3, (int)this.metaClient.getTableConfig().getMetadataPartitions().size());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIWithDTCleaning(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCleanConfig.CLEANER_COMMITS_RETAINED.key()), (Object)"1")})));
        HoodieTableType hoodieTableType = tableType;
        HoodieTableType hoodieTableType2 = HoodieTableType.MERGE_ON_READ;
        if (!(hoodieTableType != null ? !hoodieTableType.equals(hoodieTableType2) : hoodieTableType2 != null)) {
            hudiOpts = hudiOpts.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.INLINE_COMPACT.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()), (Object)"15")})));
        }
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        Option lastCleanInstant = this.getLatestMetaClient(false).getActiveTimeline().getCleanerTimeline().lastInstant();
        Assertions.assertTrue((boolean)lastCleanInstant.isPresent());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        Assertions.assertTrue((((HoodieInstant)this.getLatestMetaClient(false).getActiveTimeline().getCleanerTimeline().lastInstant().get()).requestedTime().compareTo(((HoodieInstant)lastCleanInstant.get()).requestedTime()) > 0 ? 1 : 0) != 0);
        scala.Option rollbackedInstant = Option$.MODULE$.empty();
        while (true) {
            if (!rollbackedInstant.isEmpty()) {
                String string = ((HoodieInstant)rollbackedInstant.get()).getAction();
                String string2 = ActionType.clean.name();
                if (!(string == null ? string2 != null : !string.equals(string2))) break;
            }
            rollbackedInstant = Option$.MODULE$.apply((Object)this.rollbackLastInstant((scala.collection.immutable.Map<String, String>)hudiOpts));
        }
        this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts, this.validateDataAndRecordIndices$default$2());
    }

    @Test
    public void testRLIWithDTCompaction() {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)HoodieTableType.MERGE_ON_READ.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.INLINE_COMPACT.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.PARQUET_SMALL_FILE_LIMIT.key()), (Object)"0")})));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        Option<HoodieInstant> lastCompactionInstant = this.getLatestCompactionInstant();
        Assertions.assertTrue((boolean)lastCompactionInstant.isPresent());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        Assertions.assertTrue((((HoodieInstant)this.getLatestCompactionInstant().get()).requestedTime().compareTo(((HoodieInstant)lastCompactionInstant.get()).requestedTime()) > 0 ? 1 : 0) != 0);
        lastCompactionInstant = this.getLatestCompactionInstant();
        scala.Option rollbackedInstant = Option$.MODULE$.empty();
        while (true) {
            if (!rollbackedInstant.isEmpty()) {
                String string = ((HoodieInstant)rollbackedInstant.get()).requestedTime();
                String string2 = ((HoodieInstant)lastCompactionInstant.get()).requestedTime();
                if (!(string == null ? string2 != null : !string.equals(string2))) break;
            }
            rollbackedInstant = Option$.MODULE$.apply((Object)this.rollbackLastInstant((scala.collection.immutable.Map<String, String>)hudiOpts));
        }
        this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts, this.validateDataAndRecordIndices$default$2());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIWithDTClustering(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.INLINE_CLUSTERING.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.INLINE_CLUSTERING_MAX_COMMITS.key()), (Object)"2")})));
        Properties props = new Properties();
        hudiOpts.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)TestRecordLevelIndex.$anonfun$testRLIWithDTClustering$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return props.put(k, v);
            }
            throw new MatchError((Object)tuple2);
        });
        this.initMetaClient(tableType, props);
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        Option<HoodieInstant> lastClusteringInstant = this.getLatestClusteringInstant();
        Assertions.assertTrue((boolean)lastClusteringInstant.isPresent());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        Assertions.assertTrue((((HoodieInstant)this.getLatestClusteringInstant().get()).requestedTime().compareTo(((HoodieInstant)lastClusteringInstant.get()).requestedTime()) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals(this.getLatestClusteringInstant(), (Object)this.metaClient.getActiveTimeline().lastInstant());
        this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts, this.validateDataAndRecordIndices$default$2());
        this.rollbackLastInstant((scala.collection.immutable.Map<String, String>)hudiOpts);
        this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts, this.validateDataAndRecordIndices$default$2());
    }

    @ParameterizedTest
    @CsvSource(value={"COPY_ON_WRITE,COLUMN_STATS", "COPY_ON_WRITE,BLOOM_FILTERS", "COPY_ON_WRITE,COLUMN_STATS:BLOOM_FILTERS", "MERGE_ON_READ,COLUMN_STATS", "MERGE_ON_READ,BLOOM_FILTERS", "MERGE_ON_READ,COLUMN_STATS:BLOOM_FILTERS"})
    public void testRLIWithOtherMetadataPartitions(String tableType, String metadataPartitionTypes) {
        ObjectRef hudiOpts = ObjectRef.create(this.commonOpts());
        List metadataPartitions = ((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metadataPartitionTypes.split(":"))).toStream().map((Function1 & Serializable & scala.Serializable)p -> MetadataPartitionType.valueOf((String)p), Stream$.MODULE$.canBuildFrom())).toList();
        metadataPartitions.foreach((Function1 & Serializable & scala.Serializable)metadataPartition -> {
            TestRecordLevelIndex.$anonfun$testRLIWithOtherMetadataPartitions$2(hudiOpts, metadataPartition);
            return BoxedUnit.UNIT;
        });
        hudiOpts.elem = ((scala.collection.immutable.Map)hudiOpts.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)hudiOpts.elem), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)hudiOpts.elem), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        Assertions.assertTrue((boolean)this.metadataWriter(this.getWriteConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)hudiOpts.elem))).getEnabledPartitionTypes().containsAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)metadataPartitions).asJava()));
    }

    @ParameterizedTest
    @MethodSource(value={"testEnableDisableRLIParams"})
    public void testEnableDisableRLI(HoodieTableType tableType, boolean isPartitioned) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name())})));
        if (!isPartitioned) {
            hudiOpts = (scala.collection.immutable.Map)hudiOpts.$minus((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key());
        }
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        hudiOpts = hudiOpts.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key()), (Object)"false"));
        this.metaClient.getTableConfig().setMetadataPartitionState(this.metaClient, MetadataPartitionType.RECORD_INDEX.getPartitionPath(), false);
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, false, this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        try {
            this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts, this.validateDataAndRecordIndices$default$2());
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof IllegalStateException));
            Assertions.assertTrue((boolean)e.getMessage().contains("Record index is not initialized in MDT"));
        }
        hudiOpts = hudiOpts.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key()), (Object)"true"));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts, this.validateDataAndRecordIndices$default$2());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIWithMDTCompaction(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()), (Object)"1")})));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        HoodieTableFileSystemView metadataTableFSView = ((HoodieBackedTableMetadata)this.getHoodieTable(this.metaClient, this.getWriteConfig((scala.collection.immutable.Map<String, String>)hudiOpts)).getMetadataTable()).getMetadataFileSystemView();
        HoodieTimeline compactionTimeline = metadataTableFSView.getVisibleCommitsAndCompactionTimeline().filterCompletedAndCompactionInstants();
        Option lastCompactionInstant = compactionTimeline.filter(JavaConversions$.MODULE$.getPredicate((Function1 & Serializable & scala.Serializable)instant -> BoxesRunTime.boxToBoolean((boolean)TestRecordLevelIndex.$anonfun$testRLIWithMDTCompaction$1(compactionTimeline, instant)))).lastInstant();
        Optional compactionBaseFile = metadataTableFSView.getAllBaseFiles(MetadataPartitionType.RECORD_INDEX.getPartitionPath()).filter(JavaConversions$.MODULE$.getPredicate((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)TestRecordLevelIndex.$anonfun$testRLIWithMDTCompaction$2(lastCompactionInstant, f)))).findAny();
        Assertions.assertTrue((boolean)compactionBaseFile.isPresent());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIWithMDTCleaning(HoodieTableType tableType) {
        ObjectRef hudiOpts = ObjectRef.create((Object)this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()), (Object)"1")}))));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)hudiOpts.elem), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        hudiOpts.elem = ((scala.collection.immutable.Map)hudiOpts.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCleanConfig.CLEANER_FILE_VERSIONS_RETAINED.key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS.key()), (Object)"4"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        Function0 & Serializable & scala.Serializable function = (Function0 & Serializable & scala.Serializable)() -> this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)hudiOpts$3.elem), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, this.doWriteAndValidateDataAndRecordIndex$default$4(), this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.executeFunctionNTimes(function, 5);
        Assertions.assertTrue((boolean)this.getMetadataMetaClient((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)hudiOpts.elem)).getActiveTimeline().getCleanerTimeline().lastInstant().isPresent());
        this.rollbackLastInstant((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)hudiOpts.elem));
        this.rollbackLastInstant((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)hudiOpts.elem));
        this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)hudiOpts.elem), this.validateDataAndRecordIndices$default$2());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testRLIWithMultiWriter(HoodieTableType tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.key()), (Object)"optimistic_concurrency_control"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.key()), (Object)"LAZY"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key()), (Object)"org.apache.hudi.client.transaction.lock.FileSystemBasedLockProvider"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieLockConfig.WRITE_CONFLICT_RESOLUTION_STRATEGY_CLASS_NAME.key()), (Object)PreferWriterConflictResolutionStrategy.class.getName())})));
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, false, this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        ExecutorService executor = Executors.newFixedThreadPool(2);
        ExecutionContextExecutor executorContext = ExecutionContext$.MODULE$.fromExecutor((Executor)executor);
        Function0.mcZ.sp function = new Function0.mcZ.sp(this, hudiOpts){
            private final /* synthetic */ TestRecordLevelIndex $outer;
            private final scala.collection.immutable.Map hudiOpts$4;

            public byte apply$mcB$sp() {
                return Function0.apply$mcB$sp$((Function0)this);
            }

            public char apply$mcC$sp() {
                return Function0.apply$mcC$sp$((Function0)this);
            }

            public double apply$mcD$sp() {
                return Function0.apply$mcD$sp$((Function0)this);
            }

            public float apply$mcF$sp() {
                return Function0.apply$mcF$sp$((Function0)this);
            }

            public int apply$mcI$sp() {
                return Function0.apply$mcI$sp$((Function0)this);
            }

            public long apply$mcJ$sp() {
                return Function0.apply$mcJ$sp$((Function0)this);
            }

            public short apply$mcS$sp() {
                return Function0.apply$mcS$sp$((Function0)this);
            }

            public void apply$mcV$sp() {
                Function0.apply$mcV$sp$((Function0)this);
            }

            public String toString() {
                return Function0.toString$((Function0)this);
            }

            public boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                boolean bl;
                try {
                    this.$outer.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)this.hudiOpts$4, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, false, this.$outer.doWriteAndValidateDataAndRecordIndex$default$5(), this.$outer.doWriteAndValidateDataAndRecordIndex$default$6());
                    bl = true;
                }
                catch (HoodieWriteConflictException hoodieWriteConflictException) {
                    bl = false;
                }
                catch (Throwable e) {
                    throw new Exception("Multi write failed", e);
                }
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hudiOpts$4 = hudiOpts$4;
                Function0.$init$((Function0)this);
            }
        };
        Future f1 = Future$.MODULE$.apply((Function0)function, (ExecutionContext)executorContext);
        Future f2 = Future$.MODULE$.apply((Function0)function, (ExecutionContext)executorContext);
        Await$.MODULE$.result((Awaitable)f1, Duration$.MODULE$.apply("5 minutes"));
        Await$.MODULE$.result((Awaitable)f2, Duration$.MODULE$.apply("5 minutes"));
        Assertions.assertTrue((BoxesRunTime.unboxToBoolean((Object)((Try)f1.value().get()).get()) || BoxesRunTime.unboxToBoolean((Object)((Try)f2.value().get()).get()) ? 1 : 0) != 0);
        executor.shutdownNow();
        this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts, this.validateDataAndRecordIndices$default$2());
    }

    public static final /* synthetic */ boolean $anonfun$testRLIWithDelete$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$testRLIForDeletesWithHoodieIsDeletedColumn$1(String recordKeyToDelete$1, Row row) {
        String string = (String)row.getAs("_row_key");
        String string2 = recordKeyToDelete$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$testRLIWithDeletePartition$2(TestRecordLevelIndex $this, Dataset latestSnapshot$1, scala.collection.immutable.Map hudiOpts$1, SparkRDDWriteClient client) {
        String commitTime = client.startCommit();
        client.startCommitWithTime(commitTime, "replacecommit");
        String deletingPartition = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.protected$dataGen($this).getPartitionPaths())).last();
        java.util.List<String> partitionList = Collections.singletonList(deletingPartition);
        client.deletePartitions(partitionList, commitTime);
        Dataset deletedDf = latestSnapshot$1.filter(new StringBuilder(12).append("partition = ").append(deletingPartition).toString());
        $this.validateDataAndRecordIndices((scala.collection.immutable.Map<String, String>)hudiOpts$1, (Dataset<Row>)deletedDf);
    }

    public static final /* synthetic */ boolean $anonfun$testRLIWithDTClustering$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$testRLIWithOtherMetadataPartitions$2(ObjectRef hudiOpts$2, MetadataPartitionType metadataPartition) {
        MetadataPartitionType metadataPartitionType = metadataPartition;
        MetadataPartitionType metadataPartitionType2 = MetadataPartitionType.COLUMN_STATS;
        if (!(metadataPartitionType != null ? !metadataPartitionType.equals(metadataPartitionType2) : metadataPartitionType2 != null)) {
            hudiOpts$2.elem = ((scala.collection.immutable.Map)hudiOpts$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()), (Object)"true"));
            return;
        }
        MetadataPartitionType metadataPartitionType3 = metadataPartition;
        MetadataPartitionType metadataPartitionType4 = MetadataPartitionType.BLOOM_FILTERS;
        if (!(metadataPartitionType3 != null ? !metadataPartitionType3.equals(metadataPartitionType4) : metadataPartitionType4 != null)) {
            hudiOpts$2.elem = ((scala.collection.immutable.Map)hudiOpts$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_BLOOM_FILTER.key()), (Object)"true"));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testRLIWithMDTCompaction$1(HoodieTimeline compactionTimeline$1, HoodieInstant instant) {
        WriteOperationType writeOperationType = compactionTimeline$1.readCommitMetadata(instant).getOperationType();
        WriteOperationType writeOperationType2 = WriteOperationType.COMPACT;
        return !(writeOperationType != null ? !writeOperationType.equals(writeOperationType2) : writeOperationType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testRLIWithMDTCompaction$2(Option lastCompactionInstant$1, HoodieBaseFile f) {
        return f.getCommitTime().equals(((HoodieInstant)lastCompactionInstant$1.get()).requestedTime());
    }
}

