/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import java.util.Properties;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieFileIndex;
import org.apache.hudi.HoodieFileIndex$;
import org.apache.hudi.RecordLevelIndexSupport;
import org.apache.hudi.RecordLevelIndexSupport$;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.functional.RecordLevelIndexTestBase;
import org.apache.hudi.functional.TestRecordLevelIndexWithSQL$;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.util.JFunction$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.HoodieCatalystExpressionUtils$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.BinaryOperator;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.util.Using;
import scala.util.Using$;

@Tag(value="functional")
@ScalaSignature(bytes="\u0006\u0001\t=b\u0001B\f\u0019\u0001\u0005BQA\n\u0001\u0005\u0002\u001dBq!\u000b\u0001C\u0002\u0013\u0005!\u0006\u0003\u00044\u0001\u0001\u0006Ia\u000b\u0005\u0006i\u0001!\t!\u000e\u0005\u0006A\u0002!I!\u0019\u0005\u0006}\u0002!\ta \u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011\u001d\ty\u0004\u0001C\u0005\u0003\u0003Bq!a\u0016\u0001\t\u0013\tI\u0006C\u0004\u0002f\u0001!I!a\u001a\t\u000f\u0005\u0015\u0004\u0001\"\u0003\u0002\u0004\"9\u0011\u0011\u0015\u0001\u0005\n\u0005\r\u0006bBAS\u0001\u0011%\u0011q\u0015\u0005\n\u0003k\u0003\u0011\u0013!C\u0005\u0003oCq!!4\u0001\t\u0013\ty\rC\u0004\u0002`\u0002!I!!9\t\u000f\u0005\u0015\b\u0001\"\u0001\u0002h\"9\u0011q\u001f\u0001\u0005\u0002\u0005e\bb\u0002B\u0005\u0001\u0011\u0005\u0011q\u001d\u0005\b\u0005\u001b\u0001A\u0011AAt\u0011\u0019q\b\u0001\"\u0001\u0003\u0012!a!Q\u0004\u0001\u0011\u0002\u0003\u0005\t\u0011\"\u0001\u0003 \tYB+Z:u%\u0016\u001cwN\u001d3MKZ,G.\u00138eKb<\u0016\u000e\u001e5T#2S!!\u0007\u000e\u0002\u0015\u0019,hn\u0019;j_:\fGN\u0003\u0002\u001c9\u0005!\u0001.\u001e3j\u0015\tib$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002?\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\t\t\u0003G\u0011j\u0011\u0001G\u0005\u0003Ka\u0011\u0001DU3d_J$G*\u001a<fY&sG-\u001a=UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0006\u0005\u0002$\u0001\u0005a1/\u001d7UK6\u0004H+\u00192mKV\t1\u0006\u0005\u0002-c5\tQF\u0003\u0002/_\u0005!A.\u00198h\u0015\u0005\u0001\u0014\u0001\u00026bm\u0006L!AM\u0017\u0003\rM#(/\u001b8h\u00035\u0019\u0018\u000f\u001c+f[B$\u0016M\u00197fA\u0005qA/Z:u%2Ku+\u001b;i'FcEC\u0001\u001c=!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\u0011)f.\u001b;\t\u000bu\"\u0001\u0019\u0001 \u0002\u0013Q\f'\r\\3UsB,\u0007CA G\u001d\t\u0001E\t\u0005\u0002Bq5\t!I\u0003\u0002DA\u00051AH]8pizJ!!\u0012\u001d\u0002\rA\u0013X\rZ3g\u0013\t\u0011tI\u0003\u0002Fq!\"A!S+W!\tQ5+D\u0001L\u0015\taU*\u0001\u0005qe>4\u0018\u000eZ3s\u0015\tqu*\u0001\u0004qCJ\fWn\u001d\u0006\u0003!F\u000bqA[;qSR,'O\u0003\u0002S=\u0005)!.\u001e8ji&\u0011Ak\u0013\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\u0005]K\u0016%\u0001-\u0002\u001b\r{\u0005+W0P\u001d~;&+\u0013+FC\u0005Q\u0016!D'F%\u001e+ul\u0014(`%\u0016\u000bE\t\u000b\u0002\u00059B\u0011QLX\u0007\u0002\u001b&\u0011q,\u0014\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018a\u0006<fe&4\u0017PT3hCRLg/\u001a+fgR\u001c\u0015m]3t)\u00111$mZ5\t\u000b\r,\u0001\u0019\u00013\u0002\u0011!,H-[(qiN\u0004BaP3?}%\u0011am\u0012\u0002\u0004\u001b\u0006\u0004\b\"\u00025\u0006\u0001\u0004q\u0014aB2pY:\u000bW.\u001a\u0005\u0006U\u0016\u0001\ra[\u0001\u0011Y\u0006$Xm\u001d;T]\u0006\u00048\u000f[8u\t\u001a\u0004\"\u0001\\>\u000f\u00055DhB\u00018v\u001d\ty7O\u0004\u0002qe:\u0011\u0011)]\u0005\u0002?%\u0011QDH\u0005\u0003ir\tQa\u001d9be.L!A^<\u0002\u0007M\fHN\u0003\u0002u9%\u0011\u0011P_\u0001\ba\u0006\u001c7.Y4f\u0015\t1x/\u0003\u0002}{\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003sj\f!C^3sS\u001aLX)];bYR{\u0017+^3ssR9a'!\u0001\u0002\u0004\u0005\u0015\u0001\"B2\u0007\u0001\u0004!\u0007\"\u00025\u0007\u0001\u0004q\u0004\"\u00026\u0007\u0001\u0004Y\u0017!\u0004<fe&4\u00170\u00138Rk\u0016\u0014\u0018\u0010F\b7\u0003\u0017\ti!a\u0006\u0002\u001a\u0005u\u0011\u0011EA\u001b\u0011\u0015\u0019w\u00011\u0001e\u0011\u001d\tya\u0002a\u0001\u0003#\t\u0001bY8m\u001d\u0006lWm\u001d\t\u0005o\u0005Ma(C\u0002\u0002\u0016a\u0012Q!\u0011:sCfDQA[\u0004A\u0002-Da!a\u0007\b\u0001\u0004q\u0014!\u0003;bE2,g*Y7f\u0011\u0019\tyb\u0002a\u0001}\u0005\u0011\u0002/\u0019:uSRLwN\u001c$jK2$g*Y7f\u0011\u001d\t\u0019c\u0002a\u0001\u0003K\t!\u0002]1si&$\u0018n\u001c8t!\u0015\t9#a\f?\u001d\u0011\tI#!\f\u000f\u0007\u0005\u000bY#C\u0001:\u0013\tI\b(\u0003\u0003\u00022\u0005M\"aA*fc*\u0011\u0011\u0010\u000f\u0005\b\u0003o9\u0001\u0019AA\u001d\u0003-\u0019\bn\\;mIB\u0013XO\\3\u0011\u0007]\nY$C\u0002\u0002>a\u0012qAQ8pY\u0016\fg.A\u0005biR\u0014\u0018NY;uKR!\u00111IA*!\u0011\t)%a\u0014\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\n1\"\u001a=qe\u0016\u001c8/[8og*\u0019\u0011Q\n>\u0002\u0011\r\fG/\u00197zgRLA!!\u0015\u0002H\t\u0011\u0012\t\u001e;sS\n,H/\u001a*fM\u0016\u0014XM\\2f\u0011\u0019\t)\u0006\u0003a\u0001}\u0005I\u0001/\u0019:uSRLwN\\\u0001\bY&$XM]1m)\u0011\tY&!\u0019\u0011\t\u0005\u0015\u0013QL\u0005\u0005\u0003?\n9EA\u0004MSR,'/\u00197\t\r\u0005\r\u0014\u00021\u0001?\u0003\u00151\u0018\r\\;f\u0003Y1XM]5gsB\u0013XO\\5oO\u001aKG.Z\"pk:$H#\u0003\u001c\u0002j\u00055\u0014qOAA\u0011\u0019\tYG\u0003a\u0001I\u0006!q\u000e\u001d;t\u0011\u001d\tyG\u0003a\u0001\u0003c\n!\u0002Z1uC\u001aKG\u000e^3s!\u0011\t)%a\u001d\n\t\u0005U\u0014q\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007bBA=\u0015\u0001\u0007\u00111P\u0001\t]Vlg)\u001b7fgB\u0019q'! \n\u0007\u0005}\u0004HA\u0002J]RDq!a\u000e\u000b\u0001\u0004\tI\u0004F\u00067\u0003\u000b\u000b9)!#\u0002\f\u0006}\u0005BBA6\u0017\u0001\u0007A\rC\u0004\u0002p-\u0001\r!!\u001d\t\u000f\u0005e4\u00021\u0001\u0002|!9\u0011QR\u0006A\u0002\u0005=\u0015AC7fi\u0006\u001cE.[3oiB!\u0011\u0011SAN\u001b\t\t\u0019J\u0003\u0003\u0002\u0016\u0006]\u0015!\u0002;bE2,'bAAM5\u000511m\\7n_:LA!!(\u0002\u0014\n)\u0002j\\8eS\u0016$\u0016M\u00197f\u001b\u0016$\u0018m\u00117jK:$\bbBA\u001c\u0017\u0001\u0007\u0011\u0011H\u0001\u000bSN$\u0016M\u00197f\u001b>\u0013FCAA\u001d\u0003]9W\r\u001e'bi\u0016\u001cH\u000fR1uC\u001aKG.Z:D_VtG\u000f\u0006\u0004\u0002*\u0006=\u0016\u0011\u0017\t\u0004o\u0005-\u0016bAAWq\t!Aj\u001c8h\u0011\u0019\tY'\u0004a\u0001I\"I\u00111W\u0007\u0011\u0002\u0003\u0007\u0011\u0011H\u0001\u0010S:\u001cG.\u001e3f\u0019><g)\u001b7fg\u0006\ts-\u001a;MCR,7\u000f\u001e#bi\u00064\u0015\u000e\\3t\u0007>,h\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0018\u0016\u0005\u0003s\tYl\u000b\u0002\u0002>B!\u0011qXAe\u001b\t\t\tM\u0003\u0003\u0002D\u0006\u0015\u0017!C;oG\",7m[3e\u0015\r\t9\rO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAf\u0003\u0003\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Y9W\r\u001e+bE2,g)\u001b7f'f\u001cH/Z7WS\u0016<H\u0003BAi\u0003;\u0004B!a5\u0002Z6\u0011\u0011Q\u001b\u0006\u0005\u0003/\f\u0019*\u0001\u0003wS\u0016<\u0018\u0002BAn\u0003+\u0014\u0011\u0004S8pI&,G+\u00192mK\u001aKG.Z*zgR,WNV5fo\"1\u00111N\bA\u0002\u0011\fqb\u0019:fCR,G+Z7q)\u0006\u0014G.\u001a\u000b\u0004m\u0005\r\b\"B2\u0011\u0001\u0004!\u0017A\u0007;fgRLeNR5mi\u0016\u0014xJ\u001c(p]J+7m\u001c:e\u0017\u0016LH#\u0001\u001c)\u0007E\tY\u000f\u0005\u0003\u0002n\u0006MXBAAx\u0015\r\t\tpT\u0001\u0004CBL\u0017\u0002BA{\u0003_\u0014A\u0001V3ti\u00061B/Z:u!J,h.\u001a3Ti>\u0014\u0018mZ3QCRD7\u000fF\u00027\u0003wDq!a-\u0013\u0001\u0004\tI\u0004\u000b\u0004\u0013\u0013\u0006}(\u0011A\u0001\tE>|G.Z1og2\"!1\u0001B\u00033\u0005\t\u0011$\u0001\u0001)\u0005Ia\u0016!\b;fgR\u0014F*S,ji\"$vo\u001c*fG>\u0014HmS3z\r&,G\u000eZ:)\u0007M\tY/A\u0010uKN$(\u000bT%XSRDG\u000b\u001b:fKJ+7m\u001c:e\u0017\u0016Lh)[3mIND3\u0001FAv)-1$1\u0003B\u000b\u0005/\u0011IBa\u0007\t\u000b\r,\u0002\u0019\u00013\t\u000f\u0005=Q\u00031\u0001\u0002&!1\u00111D\u000bA\u0002yBQA[\u000bA\u0002-Dq!!$\u0016\u0001\u0004\ty)\u0001\u000bqe>$Xm\u0019;fI\u0012jW\r^1DY&,g\u000e\u001e\u000b\u0005\u0003\u001f\u0013\t\u0003\u0003\u0005\u0003$Y\t\t\u00111\u0001)\u0003\rAH%\r\u0015\b\u0001\t\u001d\u00121\rB\u0017!\u0011\tiO!\u000b\n\t\t-\u0012q\u001e\u0002\u0004)\u0006<\u0017%A\r")
public class TestRecordLevelIndexWithSQL
extends RecordLevelIndexTestBase {
    private final String sqlTempTable;

    public /* synthetic */ HoodieTableMetaClient protected$metaClient(TestRecordLevelIndexWithSQL x$1) {
        return x$1.metaClient;
    }

    public String sqlTempTable() {
        return this.sqlTempTable;
    }

    @ParameterizedTest
    @ValueSource(strings={"COPY_ON_WRITE", "MERGE_ON_READ"})
    public void testRLIWithSQL(String tableType) {
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.metadata.index.column.stats.enable"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true")})));
        Dataset<Row> df = this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, false, this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, false, ((Row[])df.collect()).length, true);
        this.createTempTable((scala.collection.immutable.Map<String, String>)hudiOpts);
        Dataset latestSnapshotDf = this.spark().read().format("hudi").options((Map)hudiOpts).load(this.basePath);
        this.verifyInQuery((scala.collection.immutable.Map<String, String>)hudiOpts, (String[])((Object[])new String[]{"_row_key"}), (Dataset<Row>)latestSnapshotDf, this.sqlTempTable(), "partition", (Seq<String>)((Seq)new .colon.colon((Object)"2015/03/16", (List)new .colon.colon((Object)"2015/03/17", (List)Nil$.MODULE$))), true);
        this.verifyEqualToQuery((scala.collection.immutable.Map<String, String>)hudiOpts, "_row_key", (Dataset<Row>)latestSnapshotDf);
        this.verifyNegativeTestCases((scala.collection.immutable.Map<String, String>)hudiOpts, "_row_key", (Dataset<Row>)latestSnapshotDf);
        this.verifyInQuery((scala.collection.immutable.Map<String, String>)hudiOpts, (String[])((Object[])new String[]{HoodieRecord.HoodieMetadataField.RECORD_KEY_METADATA_FIELD.getFieldName()}), (Dataset<Row>)latestSnapshotDf, this.sqlTempTable(), "partition", (Seq<String>)((Seq)new .colon.colon((Object)"2015/03/16", (List)new .colon.colon((Object)"2015/03/17", (List)Nil$.MODULE$))), true);
        this.verifyEqualToQuery((scala.collection.immutable.Map<String, String>)hudiOpts, HoodieRecord.HoodieMetadataField.RECORD_KEY_METADATA_FIELD.getFieldName(), (Dataset<Row>)latestSnapshotDf);
        this.verifyNegativeTestCases((scala.collection.immutable.Map<String, String>)hudiOpts, HoodieRecord.HoodieMetadataField.RECORD_KEY_METADATA_FIELD.getFieldName(), (Dataset<Row>)latestSnapshotDf);
    }

    private void verifyNegativeTestCases(scala.collection.immutable.Map<String, String> hudiOpts, String colName, Dataset<Row> latestSnapshotDf) {
        scala.collection.immutable.Map commonOpts = hudiOpts.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)this.basePath));
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        SparkSession x$1 = this.spark();
        HoodieTableMetaClient x$2 = this.metaClient;
        None$ x$3 = None$.MODULE$;
        scala.collection.immutable.Map x$4 = commonOpts;
        boolean x$5 = true;
        FileStatusCache x$6 = HoodieFileIndex$.MODULE$.apply$default$5();
        boolean x$7 = HoodieFileIndex$.MODULE$.apply$default$7();
        HoodieFileIndex fileIndex = new HoodieFileIndex(x$1, x$2, (Option)x$3, x$4, x$6, x$5, x$7);
        Assertions.assertEquals((long)this.getLatestDataFilesCount((scala.collection.immutable.Map<String, String>)commonOpts, this.getLatestDataFilesCount$default$2()), (long)((SeqLike)fileIndex.listFiles((Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$).flatMap((Function1 & Serializable & scala.Serializable)s -> s.files(), Seq$.MODULE$.canBuildFrom())).size());
        Assertions.assertEquals((long)5L, (long)this.spark().sql(new StringBuilder(14).append("select * from ").append(this.sqlTempTable()).toString()).count());
        EqualTo dataFilter = new EqualTo((Expression)this.attribute(colName), (Expression)Literal$.MODULE$.apply((Object)"xyz"));
        Assertions.assertEquals((long)0L, (long)this.spark().sql(new StringBuilder(21).append("select * from ").append(this.sqlTempTable()).append(" where ").append(dataFilter.sql()).toString()).count());
        Assertions.assertEquals((int)0, (int)((SeqLike)fileIndex.listFiles((Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$)).flatMap((Function1 & Serializable & scala.Serializable)s -> s.files(), Seq$.MODULE$.canBuildFrom())).size());
        dataFilter = new In((Expression)this.attribute(colName), (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"xyz"), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"abc"), (List)Nil$.MODULE$)));
        Assertions.assertEquals((long)0L, (long)this.spark().sql(new StringBuilder(21).append("select * from ").append(this.sqlTempTable()).append(" where ").append(dataFilter.sql()).toString()).count());
        Assertions.assertEquals((int)0, (int)((SeqLike)fileIndex.listFiles((Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$)).flatMap((Function1 & Serializable & scala.Serializable)s -> s.files(), Seq$.MODULE$.canBuildFrom())).size());
        String[] reckey = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])latestSnapshotDf.limit(2).collect())).map((Function1 & Serializable & scala.Serializable)row -> row.getAs(colName).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        dataFilter = new GreaterThan((Expression)this.attribute(colName), (Expression)Literal$.MODULE$.apply((Object)reckey[0]));
        Assertions.assertTrue((((SeqLike)fileIndex.listFiles((Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$)).flatMap((Function1 & Serializable & scala.Serializable)s -> s.files(), Seq$.MODULE$.canBuildFrom())).size() >= 3 ? 1 : 0) != 0);
        dataFilter = new Or((Expression)new EqualTo((Expression)this.attribute(colName), (Expression)Literal$.MODULE$.apply((Object)reckey[0])), (Expression)new GreaterThanOrEqual((Expression)this.attribute("timestamp"), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))));
        Assertions.assertEquals((long)5L, (long)this.spark().sql(new StringBuilder(21).append("select * from ").append(this.sqlTempTable()).append(" where ").append(dataFilter.sql()).toString()).count());
        Assertions.assertTrue((((SeqLike)fileIndex.listFiles((Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$)).flatMap((Function1 & Serializable & scala.Serializable)s -> s.files(), Seq$.MODULE$.canBuildFrom())).size() >= 3 ? 1 : 0) != 0);
    }

    public void verifyEqualToQuery(scala.collection.immutable.Map<String, String> hudiOpts, String colName, Dataset<Row> latestSnapshotDf) {
        String[] reckey = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])latestSnapshotDf.limit(1).collect())).map((Function1 & Serializable & scala.Serializable)row -> row.getAs(colName).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        EqualTo dataFilter = new EqualTo((Expression)this.attribute(colName), (Expression)Literal$.MODULE$.apply((Object)reckey[0]));
        Assertions.assertEquals((long)1L, (long)this.spark().sql(new StringBuilder(21).append("select * from ").append(this.sqlTempTable()).append(" where ").append(dataFilter.sql()).toString()).count());
        int numFiles = this.isTableMOR() ? 2 : 1;
        this.verifyPruningFileCount(hudiOpts, (Expression)dataFilter, numFiles, true);
    }

    public void verifyInQuery(scala.collection.immutable.Map<String, String> hudiOpts, String[] colNames, Dataset<Row> latestSnapshotDf, String tableName, String partitionFieldName, Seq<String> partitions, boolean shouldPrune) {
        Expression dataFilter = null;
        int numFiles = 0;
        ObjectRef recKeys = ObjectRef.create(null);
        In[] inQueries = (In[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])colNames)).map((Function1 & Serializable & scala.Serializable)colName -> {
            recKeys$1.elem = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])latestSnapshotDf.limit(1).collect())).map((Function1 & Serializable & scala.Serializable)row -> row.getAs(colName).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            return new In((Expression)this.attribute((String)colName), (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String[])recKeys$1.elem))).map((Function1 & Serializable & scala.Serializable)l -> this.literal((String)l), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Literal.class))))).toList());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(In.class)));
        dataFilter = (Expression)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inQueries)).reduceLeft((Function2)And$.MODULE$);
        Assertions.assertEquals((long)1L, (long)this.spark().sql(new StringBuilder(21).append("select * from ").append(tableName).append(" where ").append(dataFilter.sql()).toString()).count());
        numFiles = this.isTableMOR() ? 2 : 1;
        this.verifyPruningFileCount(hudiOpts, dataFilter, numFiles, shouldPrune);
        inQueries = (In[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])colNames)).map((Function1 & Serializable & scala.Serializable)colName -> {
            recKeys$1.elem = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])latestSnapshotDf.collect())).filter((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)partitions.contains((Object)row.getAs(partitionFieldName).toString()))))).map((Function1 & Serializable & scala.Serializable)row -> row.getAs(colName).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            return new In((Expression)this.attribute((String)colName), (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String[])recKeys$1.elem))).map((Function1 & Serializable & scala.Serializable)l -> this.literal((String)l), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Literal.class))))).toList());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(In.class)));
        dataFilter = (Expression)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inQueries)).reduceLeft((Function2)And$.MODULE$);
        Assertions.assertEquals((long)((String[])recKeys.elem).length, (long)this.spark().sql(new StringBuilder(21).append("select * from ").append(tableName).append(" where ").append(dataFilter.sql()).toString()).count());
        numFiles = this.isTableMOR() ? 4 : 2;
        this.verifyPruningFileCount(hudiOpts, dataFilter, numFiles, shouldPrune);
    }

    private AttributeReference attribute(String partition) {
        String x$1 = partition;
        StringType$ x$2 = StringType$.MODULE$;
        boolean x$3 = true;
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$4);
        return new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$5, x$6);
    }

    private Literal literal(String value) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestRecordLevelIndexWithSQL.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestRecordLevelIndexWithSQL$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_apache_hudi_functional_TestRecordLevelIndexWithSQL$$typecreator1$1(TestRecordLevelIndexWithSQL $outer) {
            }
        }
        return Literal$.MODULE$.create((Object)value, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_functional_TestRecordLevelIndexWithSQL$$typecreator1$1(null)));
    }

    private void verifyPruningFileCount(scala.collection.immutable.Map<String, String> opts, Expression dataFilter, int numFiles, boolean shouldPrune) {
        this.verifyPruningFileCount(opts, dataFilter, numFiles, HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient), shouldPrune);
    }

    private void verifyPruningFileCount(scala.collection.immutable.Map<String, String> opts, Expression dataFilter, int numFiles, HoodieTableMetaClient metaClient, boolean shouldPrune) {
        scala.collection.immutable.Map commonOpts = opts.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)metaClient.getBasePath().toString()));
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
        SparkSession x$1 = this.spark();
        HoodieTableMetaClient x$2 = metaClient;
        None$ x$3 = None$.MODULE$;
        scala.collection.immutable.Map x$4 = commonOpts;
        boolean x$5 = true;
        FileStatusCache x$6 = HoodieFileIndex$.MODULE$.apply$default$5();
        boolean x$7 = HoodieFileIndex$.MODULE$.apply$default$7();
        HoodieFileIndex fileIndex = new HoodieFileIndex(x$1, x$2, (Option)x$3, x$4, x$6, x$5, x$7);
        Seq filteredPartitionDirectories = fileIndex.listFiles((Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$));
        int filteredFilesCount = ((SeqLike)filteredPartitionDirectories.flatMap((Function1 & Serializable & scala.Serializable)s -> s.files(), Seq$.MODULE$.canBuildFrom())).size();
        if (shouldPrune) {
            Assertions.assertEquals((int)numFiles, (int)filteredFilesCount);
        } else {
            Assertions.assertEquals((long)filteredFilesCount, (long)this.getLatestDataFilesCount(opts, this.getLatestDataFilesCount$default$2()));
        }
        SparkSession x$8 = this.spark();
        HoodieTableMetaClient x$9 = metaClient;
        None$ x$10 = None$.MODULE$;
        scala.collection.immutable.Map x$11 = commonOpts.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"false"));
        boolean x$12 = true;
        FileStatusCache x$13 = HoodieFileIndex$.MODULE$.apply$default$5();
        boolean x$14 = HoodieFileIndex$.MODULE$.apply$default$7();
        fileIndex = new HoodieFileIndex(x$8, x$9, (Option)x$10, x$11, x$13, x$12, x$14);
        int filesCountWithNoSkipping = ((SeqLike)fileIndex.listFiles((Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$)).flatMap((Function1 & Serializable & scala.Serializable)s -> s.files(), Seq$.MODULE$.canBuildFrom())).size();
        if (!shouldPrune) {
            Assertions.assertEquals((int)filteredFilesCount, (int)filesCountWithNoSkipping);
            return;
        }
    }

    private boolean isTableMOR() {
        HoodieTableType hoodieTableType = this.metaClient.getTableType();
        HoodieTableType hoodieTableType2 = HoodieTableType.MERGE_ON_READ;
        return !(hoodieTableType != null ? !hoodieTableType.equals(hoodieTableType2) : hoodieTableType2 != null);
    }

    private long getLatestDataFilesCount(scala.collection.immutable.Map<String, String> opts, boolean includeLogFiles) {
        LongRef totalLatestDataFiles = LongRef.create((long)0L);
        return BoxesRunTime.unboxToLong((Object)Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.getTableFileSystemView(opts), (Function1 & Serializable & scala.Serializable)fsView -> BoxesRunTime.boxToLong((long)TestRecordLevelIndexWithSQL.$anonfun$getLatestDataFilesCount$2(this, totalLatestDataFiles, includeLogFiles, fsView)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$).get());
    }

    private boolean getLatestDataFilesCount$default$2() {
        return true;
    }

    private HoodieTableFileSystemView getTableFileSystemView(scala.collection.immutable.Map<String, String> opts) {
        Properties props = new Properties();
        opts.foreach((Function1 & Serializable & scala.Serializable)kv -> props.setProperty((String)kv._1(), (String)kv._2()));
        return FileSystemViewManager.createInMemoryFileSystemView((HoodieEngineContext)new HoodieSparkEngineContext(this.jsc), (HoodieTableMetaClient)this.metaClient, (HoodieMetadataConfig)HoodieMetadataConfig.newBuilder().fromProperties(props).build());
    }

    private void createTempTable(scala.collection.immutable.Map<String, String> hudiOpts) {
        Dataset readDf = this.spark().read().format("hudi").options(hudiOpts).load(this.basePath);
        readDf.registerTempTable(this.sqlTempTable());
    }

    @Test
    public void testInFilterOnNonRecordKey() {
        scala.collection.immutable.Map hudiOpts = this.commonOpts();
        String recordKeyFields = "record_key_col";
        hudiOpts = hudiOpts.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)HoodieTableType.COPY_ON_WRITE.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        String dummyTablePath = ((Object)this.tempDir.resolve("dummy_table").toAbsolutePath()).toString();
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(519).append("\n         |create table dummy_table (\n         |  record_key_col string,\n         |  not_record_key_col string,\n         |  partition_key_col string\n         |) using hudi\n         | options (\n         |  primaryKey ='").append(recordKeyFields).append("',\n         |  hoodie.metadata.enable = 'true',\n         |  hoodie.metadata.record.index.enable = 'true',\n         |  hoodie.datasource.write.recordkey.field = '").append(recordKeyFields).append("',\n         |  hoodie.enable.data.skipping = 'true'\n         | )\n         | partitioned by(partition_key_col)\n         | location '").append(dummyTablePath).append("'\n       ").toString())).stripMargin());
        this.spark().sql("insert into dummy_table values('row1', 'row2', 'p1')");
        this.spark().sql("insert into dummy_table values('row2', 'row1', 'p2')");
        this.spark().sql("insert into dummy_table values('row3', 'row1', 'p2')");
        Assertions.assertEquals((long)2L, (long)this.spark().read().format("hudi").options((Map)hudiOpts).load(dummyTablePath).filter("not_record_key_col in ('row1', 'abc')").count());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testPrunedStoragePaths(boolean includeLogFiles) {
        Seq x$13;
        ExprId x$12;
        Metadata x$11;
        scala.collection.immutable.Map hudiOpts = this.commonOpts().$plus$plus(this.metadataOpts()).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)"MERGE_ON_READ"));
        Dataset<Row> df = this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, false, this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        Dataset<Row> dataset = includeLogFiles ? this.doWriteAndValidateDataAndRecordIndex((scala.collection.immutable.Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, false, ((Row[])df.collect()).length, true) : BoxedUnit.UNIT;
        String globbedPaths = new StringBuilder(35).append(this.basePath).append("/2015/03/16,").append(this.basePath).append("/2015/03/17,").append(this.basePath).append("/2016/03/15").toString();
        SparkSession x$1 = this.sparkSession;
        HoodieTableMetaClient x$2 = this.metaClient;
        Option x$3 = Option$.MODULE$.empty();
        scala.collection.immutable.Map x$4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"glob.paths"), (Object)globbedPaths)}));
        boolean x$5 = includeLogFiles;
        FileStatusCache x$6 = HoodieFileIndex$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = HoodieFileIndex$.MODULE$.$lessinit$greater$default$7();
        HoodieFileIndex fileIndex = new HoodieFileIndex(x$1, x$2, x$3, x$4, x$6, x$5, x$7);
        String selectedPartition = "2016/03/15";
        String x$8 = "partition";
        StringType$ x$9 = StringType$.MODULE$;
        boolean x$10 = AttributeReference$.MODULE$.apply$default$3();
        EqualTo partitionFilter = new EqualTo((Expression)new AttributeReference(x$8, (DataType)x$9, x$10, x$11 = AttributeReference$.MODULE$.apply$default$4(), x$12 = AttributeReference$.MODULE$.apply$default$5(x$8, (DataType)x$9, x$10, x$11), x$13 = AttributeReference$.MODULE$.apply$default$6(x$8, (DataType)x$9, x$10, x$11)), (Expression)Literal$.MODULE$.apply((Object)selectedPartition));
        Tuple2 tuple2 = fileIndex.prunePartitionsAndGetFileSlices((Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)partitionFilter, (List)Nil$.MODULE$));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean isPruned = tuple2._1$mcZ$sp();
        Seq prunedPaths = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)isPruned), (Object)prunedPaths);
        boolean isPruned2 = tuple22._1$mcZ$sp();
        Seq prunedPaths2 = (Seq)tuple22._2();
        Seq storagePaths = RecordLevelIndexSupport$.MODULE$.getPrunedStoragePaths(prunedPaths2, fileIndex);
        Assertions.assertTrue((boolean)isPruned2);
        Assertions.assertEquals((int)(includeLogFiles ? 2 : 1), (int)storagePaths.size());
        Assertions.assertTrue((boolean)storagePaths.forall((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)TestRecordLevelIndexWithSQL.$anonfun$testPrunedStoragePaths$1(selectedPartition, path))));
        String recordKey = (String)((Row[])df.filter(new StringBuilder(14).append("partition = '").append(selectedPartition).append("'").toString()).limit(1).collect())[0].getAs("_row_key");
        EqualTo dataFilter = new EqualTo((Expression)this.attribute("_row_key"), (Expression)Literal$.MODULE$.apply((Object)recordKey));
        RecordLevelIndexSupport rliIndexSupport = new RecordLevelIndexSupport(this.spark(), this.getConfig().getMetadataConfig(), this.metaClient);
        Option fileNames = rliIndexSupport.computeCandidateFileNames(fileIndex, (Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$), null, prunedPaths2, false);
        Assertions.assertEquals((int)(includeLogFiles ? 2 : 1), (int)((TraversableOnce)fileNames.get()).size());
    }

    @Test
    public void testRLIWithTwoRecordKeyFields() {
        String tableName = "dummy_table_two_pk";
        String recordKeyFields = "record_key_col,name";
        String dummyTablePath = ((Object)this.tempDir.resolve(tableName).toAbsolutePath()).toString();
        scala.collection.immutable.Map hudiOpts = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)tableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)String.valueOf(recordKeyFields)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition_key_col"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.metadata.index.column.stats.enable"), (Object)"false")}))).$plus$plus(this.metadataOpts());
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(598).append("\n         |create table ").append(tableName).append(" (\n         |  record_key_col string,\n         |  name string,\n         |  not_record_key_col string,\n         |  partition_key_col string\n         |) using hudi\n         | options (\n         |  primaryKey ='").append(recordKeyFields).append("',\n         |  hoodie.metadata.enable = 'true',\n         |  hoodie.metadata.record.index.enable = 'true',\n         |  hoodie.datasource.write.recordkey.field = '").append(recordKeyFields).append("',\n         |  hoodie.enable.data.skipping = 'true',\n         |  hoodie.metadata.index.column.stats.enable = 'false'\n         | )\n         | partitioned by(partition_key_col)\n         | location '").append(dummyTablePath).append("'\n       ").toString())).stripMargin());
        this.spark().sql(new StringBuilder(47).append("insert into ").append(tableName).append(" values('row1', 'name1', 'a', 'p1')").toString());
        this.spark().sql(new StringBuilder(47).append("insert into ").append(tableName).append(" values('row2', 'name2', 'b', 'p2')").toString());
        this.spark().sql(new StringBuilder(47).append("insert into ").append(tableName).append(" values('row3', 'name3', 'c', 'p3')").toString());
        Dataset latestSnapshotDf = this.spark().read().format("hudi").options((Map)hudiOpts).load(dummyTablePath);
        this.metaClient = HoodieTableMetaClient.builder().setBasePath(dummyTablePath).setConf(HoodieTestUtils.getDefaultStorageConf()).build();
        this.verifyEqualToQuery((scala.collection.immutable.Map<String, String>)hudiOpts, (Seq<String>)((Seq)new .colon.colon((Object)"record_key_col", (List)new .colon.colon((Object)"name", (List)Nil$.MODULE$))), tableName, (Dataset<Row>)latestSnapshotDf, HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient));
        this.verifyInQuery((scala.collection.immutable.Map<String, String>)hudiOpts, (String[])((Object[])new String[]{"record_key_col", "name"}), (Dataset<Row>)latestSnapshotDf, tableName, "partition_key_col", (Seq<String>)((Seq)new .colon.colon((Object)"p2", (List)new .colon.colon((Object)"p3", (List)Nil$.MODULE$))), true);
        this.verifyInQuery((scala.collection.immutable.Map<String, String>)hudiOpts, (String[])((Object[])new String[]{"name", "record_key_col"}), (Dataset<Row>)latestSnapshotDf, tableName, "partition_key_col", (Seq<String>)((Seq)new .colon.colon((Object)"p2", (List)new .colon.colon((Object)"p3", (List)Nil$.MODULE$))), true);
        this.verifyInQuery((scala.collection.immutable.Map<String, String>)hudiOpts, (String[])((Object[])new String[]{"record_key_col"}), (Dataset<Row>)latestSnapshotDf, tableName, "partition_key_col", (Seq<String>)((Seq)new .colon.colon((Object)"p2", (List)new .colon.colon((Object)"p3", (List)Nil$.MODULE$))), false);
    }

    @Test
    public void testRLIWithThreeRecordKeyFields() {
        String tableName = "dummy_table_three_pk";
        String recordKeyFields = "record_key_col1,record_key_col2,record_key_col3";
        String dummyTablePath = ((Object)this.tempDir.resolve(tableName).toAbsolutePath()).toString();
        scala.collection.immutable.Map hudiOpts = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)tableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)recordKeyFields), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"partition_key_col"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true")}))).$plus$plus(this.metadataOpts());
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(608).append("\n         |create table ").append(tableName).append(" (\n         |  record_key_col1 string,\n         |  record_key_col2 string,\n         |  record_key_col3 string,\n         |  partition_key_col string\n         |) using hudi\n         | options (\n         |  primaryKey = '").append(recordKeyFields).append("',\n         |  hoodie.metadata.enable = 'true',\n         |  hoodie.metadata.record.index.enable = 'true',\n         |  hoodie.datasource.write.recordkey.field = '").append(recordKeyFields).append("',\n         |  hoodie.enable.data.skipping = 'true',\n         |  hoodie.metadata.index.column.stats.enable = 'false'\n         | )\n         | partitioned by(partition_key_col)\n         | location '").append(dummyTablePath).append("'\n       ").toString())).stripMargin());
        this.spark().sql(new StringBuilder(47).append("insert into ").append(tableName).append(" values('row1', 'name1', 'a', 'p1')").toString());
        this.spark().sql(new StringBuilder(47).append("insert into ").append(tableName).append(" values('row2', 'name2', 'b', 'p2')").toString());
        this.spark().sql(new StringBuilder(47).append("insert into ").append(tableName).append(" values('row3', 'name3', 'c', 'p3')").toString());
        Dataset latestSnapshotDf = this.spark().read().format("hudi").options((Map)hudiOpts).load(dummyTablePath);
        this.metaClient = HoodieTableMetaClient.builder().setBasePath(dummyTablePath).setConf(HoodieTestUtils.getDefaultStorageConf()).build();
        this.verifyEqualToQuery((scala.collection.immutable.Map<String, String>)hudiOpts, (Seq<String>)((Seq)new .colon.colon((Object)"record_key_col1", (List)new .colon.colon((Object)"record_key_col2", (List)new .colon.colon((Object)"record_key_col3", (List)Nil$.MODULE$)))), tableName, (Dataset<Row>)latestSnapshotDf, HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient));
        this.verifyInQuery((scala.collection.immutable.Map<String, String>)hudiOpts, (String[])((Object[])new String[]{"record_key_col1", "record_key_col2", "record_key_col3"}), (Dataset<Row>)latestSnapshotDf, tableName, "partition_key_col", (Seq<String>)((Seq)new .colon.colon((Object)"p2", (List)new .colon.colon((Object)"p3", (List)Nil$.MODULE$))), true);
        this.verifyInQuery((scala.collection.immutable.Map<String, String>)hudiOpts, (String[])((Object[])new String[]{"record_key_col3", "record_key_col1", "record_key_col2"}), (Dataset<Row>)latestSnapshotDf, tableName, "partition_key_col", (Seq<String>)((Seq)new .colon.colon((Object)"p2", (List)new .colon.colon((Object)"p3", (List)Nil$.MODULE$))), true);
        this.verifyInQuery((scala.collection.immutable.Map<String, String>)hudiOpts, (String[])((Object[])new String[]{"record_key_col3", "record_key_col3", "record_key_col2"}), (Dataset<Row>)latestSnapshotDf, tableName, "partition_key_col", (Seq<String>)((Seq)new .colon.colon((Object)"p2", (List)new .colon.colon((Object)"p3", (List)Nil$.MODULE$))), false);
        this.verifyInQuery((scala.collection.immutable.Map<String, String>)hudiOpts, (String[])((Object[])new String[]{"record_key_col1", "record_key_col2"}), (Dataset<Row>)latestSnapshotDf, tableName, "partition_key_col", (Seq<String>)((Seq)new .colon.colon((Object)"p2", (List)new .colon.colon((Object)"p3", (List)Nil$.MODULE$))), false);
        this.verifyInQuery((scala.collection.immutable.Map<String, String>)hudiOpts, (String[])((Object[])new String[]{"record_key_col1"}), (Dataset<Row>)latestSnapshotDf, tableName, "partition_key_col", (Seq<String>)((Seq)new .colon.colon((Object)"p2", (List)new .colon.colon((Object)"p3", (List)Nil$.MODULE$))), false);
        StructType tableSchema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("record_key_col1", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("record_key_col2", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("record_key_col3", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("partition_key_col", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
        this.verifyPruningFileCount((scala.collection.immutable.Map<String, String>)hudiOpts, HoodieCatalystExpressionUtils$.MODULE$.resolveExpr(this.spark(), "record_key_col2 in ('name1', 'name2', 'name3') AND record_key_col1 in ('row1', 'row2', 'row3') AND record_key_col3 in ('a', 'b', 'c')", tableSchema), 3, this.metaClient, true);
        this.verifyPruningFileCount((scala.collection.immutable.Map<String, String>)hudiOpts, HoodieCatalystExpressionUtils$.MODULE$.resolveExpr(this.spark(), "record_key_col2 in ('name1', 'name2') AND record_key_col1 in ('row1', 'row2') AND record_key_col3 in ('a', 'b')", tableSchema), 2, this.metaClient, true);
        this.verifyPruningFileCount((scala.collection.immutable.Map<String, String>)hudiOpts, HoodieCatalystExpressionUtils$.MODULE$.resolveExpr(this.spark(), "record_key_col2 in ('name1', 'name2') AND record_key_col1 in ('row2') AND record_key_col3 in ('a', 'b', 'c')", tableSchema), 1, this.metaClient, true);
    }

    public void verifyEqualToQuery(scala.collection.immutable.Map<String, String> hudiOpts, Seq<String> colNames, String tableName, Dataset<Row> latestSnapshotDf, HoodieTableMetaClient metaClient) {
        Seq rowValues = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])latestSnapshotDf.limit(1).collect())).map((Function1 & Serializable & scala.Serializable)row -> (Seq)colNames.map((Function1 & Serializable & scala.Serializable)colName -> row.getAs(colName).toString(), Seq$.MODULE$.canBuildFrom()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class))))).head();
        BinaryOperator dataFilter = (BinaryOperator)((TraversableOnce)((TraversableLike)colNames.zip((GenIterable)rowValues, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String colName = (String)tuple2._1();
                String value = (String)tuple2._2();
                return new EqualTo((Expression)this.attribute(colName), (Expression)Literal$.MODULE$.apply((Object)value));
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom())).reduceLeft((Function2)And$.MODULE$);
        Assertions.assertEquals((long)1L, (long)this.spark().sql(new StringBuilder(21).append("select * from ").append(tableName).append(" where ").append(dataFilter.sql()).toString()).count());
        this.verifyPruningFileCount(hudiOpts, (Expression)dataFilter, 1, metaClient, true);
    }

    public static final /* synthetic */ long $anonfun$getLatestDataFilesCount$2(TestRecordLevelIndexWithSQL $this, LongRef totalLatestDataFiles$1, boolean includeLogFiles$1, HoodieTableFileSystemView fsView) {
        fsView.getAllLatestFileSlicesBeforeOrOn(((HoodieInstant)$this.protected$metaClient($this).getActiveTimeline().lastInstant().get()).requestedTime()).values().forEach(JFunction$.MODULE$.toJavaConsumer((Function1 & Serializable & scala.Serializable)slices -> {
            slices.forEach(JFunction$.MODULE$.toJavaConsumer((Function1 & Serializable & scala.Serializable)slice -> {
                totalLatestDataFiles$1.elem = totalLatestDataFiles$1.elem + ((includeLogFiles$1 ? slice.getLogFiles().count() : 0L) + (long)(slice.getBaseFile().isPresent() ? 1 : 0));
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }));
        return totalLatestDataFiles$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$testPrunedStoragePaths$1(String selectedPartition$1, StoragePath path) {
        return path.toString().contains(selectedPartition$1);
    }

    public TestRecordLevelIndexWithSQL() {
        this.sqlTempTable = "tbl";
    }
}

