/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import java.util.List;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.functional.RecordLevelIndexTestBase;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.upgrade.SparkUpgradeDowngradeHelper;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeDowngrade;
import org.apache.spark.sql.SaveMode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001\u0002\u0007\u000e\u0001YAQa\u0007\u0001\u0005\u0002qAqA\b\u0001A\u0002\u0013%q\u0004C\u0004/\u0001\u0001\u0007I\u0011B\u0018\t\ra\u0002\u0001\u0015)\u0003!\u0011\u0015I\u0004\u0001\"\u0001;\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011\u00159\u0007\u0001\"\u0003i\u0011\u0015a\b\u0001\"\u0003~\u0011\u001d\ty\u0001\u0001C\u0005\u0003#AA\"a\u0006\u0001!\u0003\u0005\t\u0011!C\u0001\u00033\u0011Q\u0004V3tiNK\u0007\u0010V8GSZ,Gi\\<oOJ\fG-\u001a%b]\u0012dWM\u001d\u0006\u0003\u001d=\t!BZ;oGRLwN\\1m\u0015\t\u0001\u0012#\u0001\u0003ik\u0012L'B\u0001\n\u0014\u0003\u0019\t\u0007/Y2iK*\tA#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001/A\u0011\u0001$G\u0007\u0002\u001b%\u0011!$\u0004\u0002\u0019%\u0016\u001cwN\u001d3MKZ,G.\u00138eKb$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001\u001e!\tA\u0002!\u0001\bqCJ$\u0018\u000e^5p]B\u000bG\u000f[:\u0016\u0003\u0001\u00022!\t\u0014)\u001b\u0005\u0011#BA\u0012%\u0003\u0011)H/\u001b7\u000b\u0003\u0015\nAA[1wC&\u0011qE\t\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002*Y5\t!F\u0003\u0002,\u001f\u000591\u000f^8sC\u001e,\u0017BA\u0017+\u0005-\u0019Fo\u001c:bO\u0016\u0004\u0016\r\u001e5\u0002%A\f'\u000f^5uS>t\u0007+\u0019;ig~#S-\u001d\u000b\u0003aY\u0002\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012A!\u00168ji\"9qgAA\u0001\u0002\u0004\u0001\u0013a\u0001=%c\u0005y\u0001/\u0019:uSRLwN\u001c)bi\"\u001c\b%A\u0010uKN$Hi\\<oOJ\fG-Z,ji\"lE\tV!oI2{wMR5mKN$\"\u0001M\u001e\t\u000bq*\u0001\u0019A\u001f\u0002\u0013Q\f'\r\\3UsB,\u0007C\u0001 D\u001b\u0005y$B\u0001!B\u0003\u0015iw\u000eZ3m\u0015\t\u0011u\"\u0001\u0004d_6lwN\\\u0005\u0003\t~\u0012q\u0002S8pI&,G+\u00192mKRK\b/\u001a\u0015\u0005\u000b\u0019\u00136\u000b\u0005\u0002H!6\t\u0001J\u0003\u0002J\u0015\u0006A\u0001O]8wS\u0012,'O\u0003\u0002L\u0019\u00061\u0001/\u0019:b[NT!!\u0014(\u0002\u000f),\b/\u001b;fe*\u0011qjE\u0001\u0006UVt\u0017\u000e^\u0005\u0003#\"\u0013!\"\u00128v[N{WO]2f\u0003\u00151\u0018\r\\;fG\u0005i\u0004FA\u0003V!\t1v+D\u0001K\u0013\tA&JA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fA\u0004^3ti\u0012{wO\\4sC\u0012,w+\u001b;i_V$Hj\\4GS2,7\u000fF\u00011Q\t1A\f\u0005\u0002^A6\taL\u0003\u0002`\u0019\u0006\u0019\u0011\r]5\n\u0005\u0005t&\u0001\u0002+fgR\fq\u0003^3ti\u0012{wO\\4sC\u0012,w+\u001b;i_V$X\n\u0012+\u0015\u0005A\"\u0007\"\u0002\u001f\b\u0001\u0004i\u0004\u0006B\u0004G%NC#aB+\u0002!\u001d,G\u000fT8h\r&dWm]\"pk:$HCA5m!\t\t$.\u0003\u0002le\t!Aj\u001c8h\u0011\u0015i\u0007\u00021\u0001o\u0003\u0011y\u0007\u000f^:\u0011\t=4\u00180\u001f\b\u0003aR\u0004\"!\u001d\u001a\u000e\u0003IT!a]\u000b\u0002\rq\u0012xn\u001c;?\u0013\t)('\u0001\u0004Qe\u0016$WMZ\u0005\u0003ob\u00141!T1q\u0015\t)(\u0007\u0005\u0002pu&\u00111\u0010\u001f\u0002\u0007'R\u0014\u0018N\\4\u0002-\u001d,G\u000fV1cY\u00164\u0015\u000e\\3TsN$X-\u001c,jK^$2A`A\u0007!\ry\u0018\u0011B\u0007\u0003\u0003\u0003QA!a\u0001\u0002\u0006\u0005!a/[3x\u0015\r\t9!Q\u0001\u0006i\u0006\u0014G.Z\u0005\u0005\u0003\u0017\t\tAA\rI_>$\u0017.\u001a+bE2,g)\u001b7f'f\u001cH/Z7WS\u0016<\b\"B7\n\u0001\u0004q\u0017!F4fi\u0006cG\u000eU1si&$\u0018\u000e^8o!\u0006$\bn\u001d\u000b\u0004A\u0005M\u0001BBA\u000b\u0015\u0001\u0007a0\u0001\u0004ggZKWm^\u0001\u0015aJ|G/Z2uK\u0012$S.\u001a;b\u00072LWM\u001c;\u0015\t\u0005m\u00111\u0005\t\u0005\u0003;\ty\"\u0004\u0002\u0002\u0006%!\u0011\u0011EA\u0003\u0005UAun\u001c3jKR\u000b'\r\\3NKR\f7\t\\5f]RDqaN\u0006\u0002\u0002\u0003\u0007Q\u0004")
public class TestSixToFiveDowngradeHandler
extends RecordLevelIndexTestBase {
    private List<StoragePath> partitionPaths = null;

    public /* synthetic */ HoodieTableMetaClient protected$metaClient(TestSixToFiveDowngradeHandler x$1) {
        return x$1.metaClient;
    }

    private List<StoragePath> partitionPaths() {
        return this.partitionPaths;
    }

    private void partitionPaths_$eq(List<StoragePath> x$1) {
        this.partitionPaths = x$1;
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testDowngradeWithMDTAndLogFiles(HoodieTableType tableType) {
        Map hudiOpts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.PARQUET_SMALL_FILE_LIMIT.key()), (Object)"0"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.doWriteAndValidateDataAndRecordIndex((Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, false, this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.doWriteAndValidateDataAndRecordIndex((Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL(), SaveMode.Append, false, this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        Assertions.assertTrue((boolean)this.metaClient.getTableConfig().isMetadataTableAvailable());
        HoodieTableType hoodieTableType = tableType;
        HoodieTableType hoodieTableType2 = HoodieTableType.MERGE_ON_READ;
        if (!(hoodieTableType != null ? !hoodieTableType.equals(hoodieTableType2) : hoodieTableType2 != null)) {
            Assertions.assertTrue((this.getLogFilesCount((Map<String, String>)hudiOpts) > 0L ? 1 : 0) != 0);
        }
        new UpgradeDowngrade(this.metaClient, this.getWriteConfig((Map<String, String>)hudiOpts), (HoodieEngineContext)this.context, (SupportsUpgradeDowngrade)SparkUpgradeDowngradeHelper.getInstance()).run(HoodieTableVersion.FIVE, null);
        this.metaClient = this.getHoodieMetaClient(this.metaClient.getStorageConf(), this.basePath);
        Assertions.assertFalse((boolean)this.metaClient.getTableConfig().isMetadataTableAvailable());
        Assertions.assertEquals((Object)HoodieTableVersion.FIVE, (Object)this.metaClient.getTableConfig().getTableVersion());
        HoodieTableType hoodieTableType3 = tableType;
        HoodieTableType hoodieTableType4 = HoodieTableType.MERGE_ON_READ;
        if (!(hoodieTableType3 != null ? !hoodieTableType3.equals(hoodieTableType4) : hoodieTableType4 != null)) {
            Assertions.assertEquals((long)0L, (long)this.getLogFilesCount((Map<String, String>)hudiOpts));
            return;
        }
    }

    @Test
    public void testDowngradeWithoutLogFiles() {
        Map hudiOpts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)HoodieTableType.MERGE_ON_READ.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.PARQUET_SMALL_FILE_LIMIT.key()), (Object)"0"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.doWriteAndValidateDataAndRecordIndex((Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, false, this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((long)0L, (long)this.getLogFilesCount((Map<String, String>)hudiOpts));
        new UpgradeDowngrade(this.metaClient, this.getWriteConfig((Map<String, String>)hudiOpts), (HoodieEngineContext)this.context, (SupportsUpgradeDowngrade)SparkUpgradeDowngradeHelper.getInstance()).run(HoodieTableVersion.FIVE, null);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((long)0L, (long)this.getLogFilesCount((Map<String, String>)hudiOpts));
        Assertions.assertEquals((Object)HoodieTableVersion.FIVE, (Object)this.metaClient.getTableConfig().getTableVersion());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testDowngradeWithoutMDT(HoodieTableType tableType) {
        Map hudiOpts = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"false"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.doWriteAndValidateDataAndRecordIndex((Map<String, String>)hudiOpts, DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL(), SaveMode.Overwrite, false, this.doWriteAndValidateDataAndRecordIndex$default$5(), this.doWriteAndValidateDataAndRecordIndex$default$6());
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        Assertions.assertFalse((boolean)this.metaClient.getTableConfig().isMetadataTableAvailable());
        new UpgradeDowngrade(this.metaClient, this.getWriteConfig((Map<String, String>)hudiOpts), (HoodieEngineContext)this.context, (SupportsUpgradeDowngrade)SparkUpgradeDowngradeHelper.getInstance()).run(HoodieTableVersion.FIVE, null);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        Assertions.assertFalse((boolean)this.metaClient.getTableConfig().isMetadataTableAvailable());
        Assertions.assertEquals((Object)HoodieTableVersion.FIVE, (Object)this.metaClient.getTableConfig().getTableVersion());
    }

    private long getLogFilesCount(Map<String, String> opts) {
        LongRef numFileSlicesWithLogFiles = LongRef.create((long)0L);
        HoodieTableFileSystemView fsView = this.getTableFileSystemView(opts);
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.getAllPartititonPaths(fsView)).asScala()).flatMap((Function1 & Serializable & scala.Serializable)partitionPath -> {
            String relativePath = FSUtils.getRelativePartitionPath((StoragePath)this.protected$metaClient(this).getBasePath(), (StoragePath)partitionPath);
            Option lastInstantOption = this.getLatestMetaClient(false).getActiveTimeline().lastInstant();
            if (lastInstantOption.isPresent()) {
                return ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(fsView.getLatestMergedFileSlicesBeforeOrOn(relativePath, ((HoodieInstant)this.getLatestMetaClient(false).getActiveTimeline().lastInstant().get()).requestedTime()).iterator()).asScala()).toSeq();
            }
            return (Seq)Nil$.MODULE$;
        }, Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)slice -> {
            TestSixToFiveDowngradeHandler.$anonfun$getLogFilesCount$2(numFileSlicesWithLogFiles, slice);
            return BoxedUnit.UNIT;
        });
        return numFileSlicesWithLogFiles.elem;
    }

    private HoodieTableFileSystemView getTableFileSystemView(Map<String, String> opts) {
        if (this.metaClient.getTableConfig().isMetadataTableAvailable()) {
            return new HoodieTableFileSystemView((HoodieTableMetadata)this.metadataWriter(this.getWriteConfig(opts)).getTableMetadata(), this.metaClient, (HoodieTimeline)this.metaClient.getActiveTimeline());
        }
        return HoodieTableFileSystemView.fileListingBasedFileSystemView((HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient, (HoodieTimeline)this.metaClient.getActiveTimeline());
    }

    private List<StoragePath> getAllPartititonPaths(HoodieTableFileSystemView fsView) {
        block0: {
            if (this.partitionPaths() != null) break block0;
            fsView.loadAllPartitions();
            this.partitionPaths_$eq(fsView.getPartitionPaths());
        }
        return this.partitionPaths();
    }

    public static final /* synthetic */ void $anonfun$getLogFilesCount$2(LongRef numFileSlicesWithLogFiles$1, FileSlice slice) {
        if (slice.getLogFiles().count() > 0L) {
            ++numFileSlicesWithLogFiles$1.elem;
            return;
        }
    }
}

