/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.spark.api.java.JavaRDD;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="functional")
public class TestSparkClusteringCornerCases
extends HoodieClientTestBase {
    @Test
    void testClusteringWithEmptyPartitions() throws IOException {
        Properties props = TestSparkClusteringCornerCases.getPropertiesForKeyGen((boolean)true);
        HoodieWriteConfig hoodieWriteConfig = this.getConfigBuilder().withProperties(props).build();
        this.initMetaClient(this.getTableType(), props);
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(hoodieWriteConfig);){
            String firstInstant = client.createNewInstantTime();
            List recordList = this.dataGen.generateInserts(firstInstant, Integer.valueOf(100));
            this.writeData(client, firstInstant, recordList);
            String secondInstant = client.createNewInstantTime();
            this.writeData(client, secondInstant, this.dataGen.generateUpdates(secondInstant, Integer.valueOf(20)));
            this.writeData(client, client.createNewInstantTime(), this.dataGen.generateDeletesFromExistingRecords(recordList));
            String clusteringInstantTime = (String)client.scheduleClustering(Option.empty()).get();
            client.cluster(clusteringInstantTime);
            this.metaClient.reloadActiveTimeline();
            HoodieInstant lastClusteringInstant = (HoodieInstant)this.metaClient.getActiveTimeline().getLastClusteringInstant().get();
            HoodieReplaceCommitMetadata replaceCommitMetadata = this.metaClient.getActiveTimeline().readReplaceCommitMetadata(lastClusteringInstant);
            Assertions.assertTrue((boolean)replaceCommitMetadata.getPartitionToWriteStats().isEmpty());
            Assertions.assertEquals((int)3, (int)replaceCommitMetadata.getPartitionToReplaceFileIds().size());
        }
    }

    protected HoodieTableType getTableType() {
        return HoodieTableType.MERGE_ON_READ;
    }

    private List<HoodieRecord> writeData(SparkRDDWriteClient client, String instant, List<HoodieRecord> recordList) {
        JavaRDD records = this.jsc.parallelize(recordList, 2);
        client.startCommitWithTime(instant);
        List writeStatuses = client.upsert(records, instant).collect();
        org.apache.hudi.testutils.Assertions.assertNoWriteErrors((List)writeStatuses);
        return recordList;
    }
}

