/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.functional.CommonOptionUtils$;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.testutils.DataSourceTestUtils;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tmc\u0001B\t\u0013\u0001mAQA\t\u0001\u0005\u0002\rBQA\n\u0001\u0005B\u001dBqA\f\u0001C\u0002\u0013\u0005q\u0006\u0003\u00049\u0001\u0001\u0006I\u0001\r\u0005\bs\u0001\u0011\r\u0011\"\u0001;\u0011\u0019Y\u0005\u0001)A\u0005w!)A\n\u0001C\u0001\u001b\")!\u0010\u0001C\u0001w\"9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002bBAZ\u0001\u0011\u0005\u0011Q\u0017\u0005\b\u0003[\u0004A\u0011AAx\u0011\u001d\u00119\u0002\u0001C\u0001\u00053AqAa\t\u0001\t\u0003\u0011)\u0003C\u0004\u0003.\u0001!\tAa\f\t\u000f\t\u0005\u0003\u0001\"\u0001\u0003D!9!Q\n\u0001\u0005\u0002\t=#a\u0005+fgR\u001c\u0006/\u0019:l\t\u0006$\u0018mU8ve\u000e,'BA\n\u0015\u0003)1WO\\2uS>t\u0017\r\u001c\u0006\u0003+Y\tA\u0001[;eS*\u0011q\u0003G\u0001\u0007CB\f7\r[3\u000b\u0003e\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000f\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}!\u0012!\u0003;fgR,H/\u001b7t\u0013\t\tcD\u0001\u0011Ta\u0006\u00148n\u00117jK:$h)\u001e8di&|g.\u00197UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001%!\t)\u0003!D\u0001\u0013\u0003\u0011\u0019wN\u001c4\u0015\u0003!\u0002\"!\u000b\u0017\u000e\u0003)R!a\u000b\f\u0002\u000bM\u0004\u0018M]6\n\u00055R#!C*qCJ\\7i\u001c8g\u0003-\u0001\u0018M]1mY\u0016d\u0017n]7\u0016\u0003A\u0002\"!\r\u001c\u000e\u0003IR!a\r\u001b\u0002\t1\fgn\u001a\u0006\u0002k\u0005!!.\u0019<b\u0013\t9$GA\u0004J]R,w-\u001a:\u0002\u0019A\f'/\u00197mK2L7/\u001c\u0011\u0002\u0015\r|W.\\8o\u001fB$8/F\u0001<!\u0011aT\t\u0013%\u000f\u0005u\u001a\u0005C\u0001 B\u001b\u0005y$B\u0001!\u001b\u0003\u0019a$o\\8u})\t!)A\u0003tG\u0006d\u0017-\u0003\u0002E\u0003\u00061\u0001K]3eK\u001aL!AR$\u0003\u00075\u000b\u0007O\u0003\u0002E\u0003B\u0011A(S\u0005\u0003\u0015\u001e\u0013aa\u0015;sS:<\u0017aC2p[6|gn\u00149ug\u0002\nA\u0002^3ti\u000e{'/\u001a$m_^$BA\u0014*U-B\u0011q\nU\u0007\u0002\u0003&\u0011\u0011+\u0011\u0002\u0005+:LG\u000fC\u0003T\u000f\u0001\u0007\u0001*A\u0005uC\ndW\rV=qK\")Qk\u0002a\u0001\u0011\u0006Y1.Z=HK:\u001cE.Y:t\u0011\u00159v\u00011\u0001I\u0003%Ig\u000eZ3y)f\u0004X\r\u000b\u0004\b3\u001647\u000f\u001e\t\u00035\u000el\u0011a\u0017\u0006\u00039v\u000b\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003=~\u000ba\u0001]1sC6\u001c(B\u00011b\u0003\u001dQW\u000f]5uKJT!A\u0019\r\u0002\u000b),h.\u001b;\n\u0005\u0011\\&!C\"tmN{WO]2f\u0003\u00151\u0018\r\\;fY\u00199\u0017n[7pc\u0006\n\u0001.A\u001fD\u001fBKvl\u0014(`/JKE+\u0012?pe\u001et\u0013\r]1dQ\u0016t\u0003.\u001e3j]-,\u0017pZ3o]MKW\u000e\u001d7f\u0017\u0016Lx)\u001a8fe\u0006$xN\u001d?C\u0019>{U*I\u0001k\u0003y\u001au\nU-`\u001f:{vKU%U\u000br|'o\u001a\u0018ba\u0006\u001c\u0007.\u001a\u0018ik\u0012Lgf[3zO\u0016tgfU5na2,7*Z=HK:,'/\u0019;per\u001c\u0016*\u0014)M\u000b\u0006\nA.\u0001'D\u001fBKvl\u0014(`/JKE+\u0012?pe\u001et\u0013\r]1dQ\u0016t\u0003.\u001e3j]-,\u0017pZ3o]9{g\u000e]1si&$\u0018n\u001c8fI.+\u0017pR3oKJ\fGo\u001c:}\u000f2{%)\u0011'`\u00052{u*T\u0011\u0002]\u0006iT*\u0012*H\u000b~{ej\u0018*F\u0003\u0012cxN]4/CB\f7\r[3/QV$\u0017NL6fs\u001e,gNL*j[BdWmS3z\u000f\u0016tWM]1u_Jd(\tT(P\u001b\u0006\n\u0001/\u0001 N\u000bJ;UiX(O?J+\u0015\t\u0012?pe\u001et\u0013\r]1dQ\u0016t\u0003.\u001e3j]-,\u0017pZ3o]MKW\u000e\u001d7f\u0017\u0016Lx)\u001a8fe\u0006$xN\u001d?T\u00136\u0003F*R\u0011\u0002e\u0006aU*\u0012*H\u000b~{ej\u0018*F\u0003\u0012cxN]4/CB\f7\r[3/QV$\u0017NL6fs\u001e,gN\f(p]B\f'\u000f^5uS>tW\rZ&fs\u001e+g.\u001a:bi>\u0014Hp\u0012'P\u0005\u0006cuL\u0011'P\u001f6\u000b\u0011\u0002Z3mS6LG/\u001a:\u001d\u0003qD#a\u0002<\u0011\u0005]DX\"A/\n\u0005el&!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006)B/Z:u\u00136lW\u000f^1cY\u0016,6/\u001a:GY><HC\u0002(}{~\f\t\u0001C\u0003T\u0011\u0001\u0007\u0001\nC\u0003\u007f\u0011\u0001\u0007\u0001*A\u0005pa\u0016\u0014\u0018\r^5p]\")Q\u000b\u0003a\u0001\u0011\")q\u000b\u0003a\u0001\u0011\":\u0001\"W3\u0002\u0006M$H\u0006GA\u0004\u0003\u0017\ty!a\u0005\u0002\u0018\u0005m\u0011qDA\u0012\u0003O\tY#a\f\u00024\u0005\u0012\u0011\u0011B\u0001E\u0007>\u0003\u0016lX(O?^\u0013\u0016\nV#}S:\u001cXM\u001d;}_J<g&\u00199bG\",g\u0006[;eS:ZW-_4f]:\u001a\u0016.\u001c9mK.+\u0017pR3oKJ\fGo\u001c:}\u00052{u*T\u0011\u0003\u0003\u001b\tQiQ(Q3~{ejX,S\u0013R+E0\u001b8tKJ$Hp\u001c:h]\u0005\u0004\u0018m\u00195f]!,H-\u001b\u0018lKf<WM\u001c\u0018TS6\u0004H.Z&fs\u001e+g.\u001a:bi>\u0014HpU%N!2+\u0015EAA\t\u0003M\u001bu\nU-`\u001f:{vKU%U\u000brLgn]3sir|'o\u001a\u0018ba\u0006\u001c\u0007.\u001a\u0018ik\u0012Lgf[3zO\u0016tgFT8oa\u0006\u0014H/\u001b;j_:,GmS3z\u000f\u0016tWM]1u_Jdx\tT(C\u00032{&\tT(P\u001b\u0006\u0012\u0011QC\u0001E\u001b\u0016\u0013v)R0P\u001d~\u0013V)\u0011#}S:\u001cXM\u001d;}_J<g&\u00199bG\",g\u0006[;eS:ZW-_4f]:\u001a\u0016.\u001c9mK.+\u0017pR3oKJ\fGo\u001c:}\u00052{u*T\u0011\u0003\u00033\tQ)T#S\u000f\u0016{vJT0S\u000b\u0006#E0\u001b8tKJ$Hp\u001c:h]\u0005\u0004\u0018m\u00195f]!,H-\u001b\u0018lKf<WM\u001c\u0018TS6\u0004H.Z&fs\u001e+g.\u001a:bi>\u0014HpU%N!2+\u0015EAA\u000f\u0003MkUIU$F?>suLU#B\trLgn]3sir|'o\u001a\u0018ba\u0006\u001c\u0007.\u001a\u0018ik\u0012Lgf[3zO\u0016tgFT8oa\u0006\u0014H/\u001b;j_:,GmS3z\u000f\u0016tWM]1u_Jdx\tT(C\u00032{&\tT(P\u001b\u0006\u0012\u0011\u0011E\u0001J\u0007>\u0003\u0016lX(O?^\u0013\u0016\nV#}EVd7nX5og\u0016\u0014H\u000f`8sO:\n\u0007/Y2iK:BW\u000fZ5/W\u0016Lx-\u001a8/'&l\u0007\u000f\\3LKf<UM\\3sCR|'\u000f \"M\u001f>k\u0015EAA\u0013\u0003)\u001bu\nU-`\u001f:{vKU%U\u000br\u0014W\u000f\\6`S:\u001cXM\u001d;}_J<g&\u00199bG\",g\u0006[;eS:ZW-_4f]:\u001a\u0016.\u001c9mK.+\u0017pR3oKJ\fGo\u001c:}'&k\u0005\u000bT#\"\u0005\u0005%\u0012\u0001W\"P!f{vJT0X%&#V\t 2vY.|\u0016N\\:feRdxN]4/CB\f7\r[3/QV$\u0017NL6fs\u001e,gN\f(p]B\f'\u000f^5uS>tW\rZ&fs\u001e+g.\u001a:bi>\u0014Hp\u0012'P\u0005\u0006cuL\u0011'P\u001f6\u000b#!!\f\u0002\u00136+%kR#`\u001f:{&+R!Ey\n,Hn[0j]N,'\u000f\u001e?pe\u001et\u0013\r]1dQ\u0016t\u0003.\u001e3j]-,\u0017pZ3o]MKW\u000e\u001d7f\u0017\u0016Lx)\u001a8fe\u0006$xN\u001d?C\u0019>{U*\t\u0002\u00022\u0005QU*\u0012*H\u000b~{ej\u0018*F\u0003\u0012c(-\u001e7l?&t7/\u001a:uy>\u0014xML1qC\u000eDWM\f5vI&t3.Z=hK:t3+[7qY\u0016\\U-_$f]\u0016\u0014\u0018\r^8syNKU\n\u0015'FC\t\t)$\u0001-N\u000bJ;UiX(O?J+\u0015\t\u0012?ck2\\w,\u001b8tKJ$Hp\u001c:h]\u0005\u0004\u0018m\u00195f]!,H-\u001b\u0018lKf<WM\u001c\u0018O_:\u0004\u0018M\u001d;ji&|g.\u001a3LKf<UM\\3sCR|'\u000f`$M\u001f\n\u000bEj\u0018\"M\u001f>k\u0005F\u0001\u0005w\u0003y!Xm\u001d;EK2,G/Z:XSRD\u0007j\\8eS\u0016L5\u000fR3mKR,G\rF\u0005O\u0003{\ty%!\u0017\u0002j!11+\u0003a\u0001\u0003\u007f\u0001B!!\u0011\u0002L5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%A\u0003n_\u0012,GNC\u0002\u0002JQ\taaY8n[>t\u0017\u0002BA'\u0003\u0007\u0012q\u0002S8pI&,G+\u00192mKRK\b/\u001a\u0005\b\u0003#J\u0001\u0019AA*\u00031!\u0018M\u00197f-\u0016\u00148/[8o!\ry\u0015QK\u0005\u0004\u0003/\n%aA%oi\"9\u00111L\u0005A\u0002\u0005u\u0013!C7fe\u001e,Wj\u001c3f!\u0011\ty&!\u001a\u000e\u0005\u0005\u0005$\u0002BA2\u0003\u000f\naaY8oM&<\u0017\u0002BA4\u0003C\u0012qBU3d_J$W*\u001a:hK6{G-\u001a\u0005\u0007/&\u0001\r!a\u001b\u0011\t\u00055\u0014q\u0011\b\u0005\u0003_\n\tI\u0004\u0003\u0002r\u0005ud\u0002BA:\u0003wrA!!\u001e\u0002z9\u0019a(a\u001e\n\u0003eI!a\u0006\r\n\u0005U1\u0012bAA@)\u0005)\u0011N\u001c3fq&!\u00111QAC\u0003-Aun\u001c3jK&sG-\u001a=\u000b\u0007\u0005}D#\u0003\u0003\u0002\n\u0006-%!C%oI\u0016DH+\u001f9f\u0015\u0011\t\u0019)!\")\u000b%IV-a$-!\u0005E\u0015QSAM\u0003;\u000b\t+!*\u0002*\u00065\u0016EAAJ\u0003A\u001au\nU-`\u001f:{vKU%U\u000b2BD&\u0012,F\u001dR{F+S'F?>\u0013F)\u0012*J\u001d\u001ec#+R\"P%\u0012{\u0016J\u0014#F1\u0006\u0012\u0011qS\u00012\u0007>\u0003\u0016lX(O?^\u0013\u0016\nV#-q1\u001au*T'J)~#\u0016*T#`\u001fJ#UIU%O\u000f2\u0012ViQ(S\t~Ke\nR#YC\t\tY*A\u0019D\u001fBKvl\u0014(`/JKE+\u0012\u00179Y\u00153VI\u0014+`)&kUiX(S\t\u0016\u0013\u0016JT$-\u000f2{%)\u0011'`'&k\u0005\u000bT#\"\u0005\u0005}\u0015AM\"P!f{vJT0X%&#V\t\f\u001d-\u0007>kU*\u0013+`)&kUiX(S\t\u0016\u0013\u0016JT$-\u000f2{%)\u0011'`'&k\u0005\u000bT#\"\u0005\u0005\r\u0016\u0001M'F%\u001e+ul\u0014(`%\u0016\u000bE\t\f\u001d-\u000bZ+e\nV0U\u00136+ul\u0014*E\u000bJKej\u0012\u0017S\u000b\u000e{%\u000bR0J\u001d\u0012+\u0005,\t\u0002\u0002(\u0006\tT*\u0012*H\u000b~{ej\u0018*F\u0003\u0012c\u0003\bL\"P\u001b6KEk\u0018+J\u001b\u0016{vJ\u0015#F%&su\t\f*F\u0007>\u0013FiX%O\t\u0016C\u0016EAAV\u0003EjUIU$F?>suLU#B\t2BD&\u0012,F\u001dR{F+S'F?>\u0013F)\u0012*J\u001d\u001ecs\tT(C\u00032{6+S'Q\u0019\u0016\u000b#!a,\u0002e5+%kR#`\u001f:{&+R!EYab3iT'N\u0013R{F+S'F?>\u0013F)\u0012*J\u001d\u001ecs\tT(C\u00032{6+S'Q\u0019\u0016C#!\u0003<\u0002\u001d%tw-Z:u\u001d\u0016<()\u0019;dQRYa*a.\u0002:\u0006u\u0016\u0011[Au\u0011\u0019\u0019&\u00021\u0001\u0002@!1\u00111\u0018\u0006A\u0002A\nqB]3d_J$7\u000fV8Va\u0012\fG/\u001a\u0005\b\u0003\u007fS\u0001\u0019AAa\u0003)\u0019HO];diRK\b/\u001a\t\u0005\u0003\u0007\fi-\u0004\u0002\u0002F*!\u0011qYAe\u0003\u0015!\u0018\u0010]3t\u0015\r\tYMK\u0001\u0004gFd\u0017\u0002BAh\u0003\u000b\u0014!b\u0015;sk\u000e$H+\u001f9f\u0011\u001d\t\u0019N\u0003a\u0001\u0003+\fq!\u001b8tKJ$8\u000f\u0005\u0004\u0002X\u0006u\u0017\u0011]\u0007\u0003\u00033T1!a75\u0003\u0011)H/\u001b7\n\t\u0005}\u0017\u0011\u001c\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002d\u0006\u0015XBAAe\u0013\u0011\t9/!3\u0003\u0007I{w\u000f\u0003\u0004\u0002l*\u0001\raO\u0001\noJLG/Z(qiN\f\u0011dY8na\u0006\u0014X-\u00169eCR,GIZ,ji\"DU\u000fZ5EMRIa*!=\u0002|\u0006}(1\u0003\u0005\b\u0003g\\\u0001\u0019AA{\u0003\u001dIg\u000e];u\t\u001a\u0004b!a9\u0002x\u0006\u0005\u0018\u0002BA}\u0003\u0013\u0014q\u0001R1uCN,G\u000fC\u0004\u0002~.\u0001\r!!>\u0002\r!,H-\u001b#g\u0011\u001d\u0011\ta\u0003a\u0001\u0005\u0007\t!BY3g_J,'k\\<t!\u0019\u0011)Aa\u0004\u0002b:!!q\u0001B\u0006\u001d\rq$\u0011B\u0005\u0002\u0005&\u0019!QB!\u0002\u000fA\f7m[1hK&!\u0011q\u001cB\t\u0015\r\u0011i!\u0011\u0005\u0007\u0005+Y\u0001\u0019\u0001%\u0002\u001b\r|Gn\u001d+p\u0007>l\u0007/\u0019:f\u0003\u0001\u001aw.\u001c9be\u0016,e\u000e^5sK&s\u0007/\u001e;S_^\u001cx+\u001b;i\u0011V$\u0017\u000e\u00124\u0015\u000f9\u0013YBa\b\u0003\"!9!Q\u0004\u0007A\u0002\t\r\u0011!C5oaV$(k\\<t\u0011\u001d\ti\u0010\u0004a\u0001\u0003kDaA!\u0006\r\u0001\u0004A\u0015AH2p[B\f'/Z#oi&\u0014X-\u00138qkR$emV5uQ\"+H-\u001b#g)\u001dq%q\u0005B\u0015\u0005WAq!a=\u000e\u0001\u0004\t)\u0010C\u0004\u0002~6\u0001\r!!>\t\r\tUQ\u00021\u0001I\u0003]!w.T(S%\u0016\fGm\u00149uS6L'0\u001a3Rk\u0016\u0014\u0018\u0010F\u0004O\u0005c\u0011\u0019Da\u000e\t\u000f\u0005Mh\u00021\u0001\u0002v\"1!Q\u0007\bA\u0002!\u000bAbY8mgR{7+\u001a7fGRDqA!\u000f\u000f\u0001\u0004\u0011Y$A\fjg6+G/\u00193bi\u0006,e.\u00192mK\u0012|eNU3bIB\u0019qJ!\u0010\n\u0007\t}\u0012IA\u0004C_>dW-\u00198\u0002\u001d\r|W\u000e]1sKJ{\u0015I\u001c3S)R9aJ!\u0012\u0003J\t-\u0003B\u0002B$\u001f\u0001\u0007\u0001*\u0001\u0005cCN,\u0007+\u0019;i\u0011\u0019\u0011)b\u0004a\u0001\u0011\"9!\u0011H\bA\u0002\tm\u0012aE2p]Z,'\u000f\u001e*po2K7\u000f\u001e+p'\u0016\fH\u0003\u0002B)\u0005/\u0002bA!\u0002\u0003T\u0005\u0005\u0018\u0002\u0002B+\u0005#\u00111aU3r\u0011\u001d\u0011I\u0006\u0005a\u0001\u0003+\f\u0011\"\u001b8qkRd\u0015n\u001d;")
public class TestSparkDataSource
extends SparkClientFunctionalTestHarness {
    private final Integer parallelism = Predef$.MODULE$.int2Integer(4);
    private final scala.collection.immutable.Map<String, String> commonOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)String.valueOf(this.parallelism())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)String.valueOf(this.parallelism())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.bulkinsert.shuffle.parallelism"), (Object)String.valueOf(this.parallelism())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.delete.shuffle.parallelism"), (Object)String.valueOf(this.parallelism())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"_row_key"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}));

    public SparkConf conf() {
        return this.conf(SparkClientFunctionalTestHarness.getSparkSqlConf());
    }

    public Integer parallelism() {
        return this.parallelism;
    }

    public scala.collection.immutable.Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    @ParameterizedTest
    @CsvSource(value={"COPY_ON_WRITE|org.apache.hudi.keygen.SimpleKeyGenerator|BLOOM", "COPY_ON_WRITE|org.apache.hudi.keygen.SimpleKeyGenerator|SIMPLE", "COPY_ON_WRITE|org.apache.hudi.keygen.NonpartitionedKeyGenerator|GLOBAL_BLOOM", "MERGE_ON_READ|org.apache.hudi.keygen.SimpleKeyGenerator|BLOOM", "MERGE_ON_READ|org.apache.hudi.keygen.SimpleKeyGenerator|SIMPLE", "MERGE_ON_READ|org.apache.hudi.keygen.NonpartitionedKeyGenerator|GLOBAL_BLOOM"}, delimiter=124)
    public void testCoreFlow(String tableType, String keyGenClass, String indexType) {
        boolean isMetadataEnabledOnWrite = true;
        boolean isMetadataEnabledOnRead = true;
        String partitionField = NonpartitionedKeyGenerator.class.getName().equals(keyGenClass) ? "" : "partition";
        scala.collection.immutable.Map options = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)String.valueOf(isMetadataEnabledOnWrite))).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)keyGenClass)).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)partitionField)).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType)).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndexConfig.INDEX_TYPE.key()), (Object)indexType));
        String colsToSelect = "_row_key, begin_lat,  begin_lon, city_to_state.LA, current_date, current_ts, distance_in_meters, driver, end_lat, end_lon, fare.amount, fare.currency, partition, partition_path, rider, timestamp, weight, _hoodie_is_deleted";
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(57069L);
        FileSystem fs = HadoopFSUtils.getFs((String)this.basePath(), (Configuration)this.spark().sparkContext().hadoopConfiguration());
        List records0 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(10)))).asScala()).toList();
        Dataset inputDf0 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records0, Predef$.MODULE$.Integer2int(this.parallelism()), ClassTag$.MODULE$.apply(String.class))).cache();
        inputDf0.write().format("org.apache.hudi").options((Map)options).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Overwrite).save(this.basePath());
        String commitCompletionTime1 = DataSourceTestUtils.latestCommitCompletionTime(fs, this.basePath());
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)fs, (String)this.basePath(), (String)"000"));
        Dataset snapshotDf1 = this.spark().read().format("org.apache.hudi").option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabledOnRead).load(this.basePath()).cache();
        Assertions.assertEquals((long)10L, (long)snapshotDf1.count());
        this.compareEntireInputDfWithHudiDf((Dataset<Row>)inputDf0, (Dataset<Row>)snapshotDf1, colsToSelect);
        List snapshotRows1 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])snapshotDf1.collect())).toList();
        snapshotDf1.unpersist(true);
        List records1 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateUniqueUpdates("001", Predef$.MODULE$.int2Integer(5)))).asScala()).toList();
        Dataset updateDf = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, Predef$.MODULE$.Integer2int(this.parallelism()), ClassTag$.MODULE$.apply(String.class))).cache();
        updateDf.write().format("org.apache.hudi").options((Map)options).mode(SaveMode.Append).save(this.basePath());
        String commitInstantTime2 = HoodieDataSourceHelpers.latestCommit((FileSystem)fs, (String)this.basePath());
        Dataset snapshotDf2 = this.spark().read().format("org.apache.hudi").option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabledOnRead).load(this.basePath()).cache();
        Assertions.assertEquals((long)10L, (long)snapshotDf2.count());
        this.compareUpdateDfWithHudiDf((Dataset<Row>)updateDf, (Dataset<Row>)snapshotDf2, (List<Row>)snapshotRows1, colsToSelect);
        List snapshotRows2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])snapshotDf2.collect())).toList();
        snapshotDf2.unpersist(true);
        List records2 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateUniqueUpdates("002", Predef$.MODULE$.int2Integer(6)))).asScala()).toList();
        Dataset inputDf2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, Predef$.MODULE$.Integer2int(this.parallelism()), ClassTag$.MODULE$.apply(String.class))).cache();
        long uniqueKeyCnt2 = inputDf2.select("_row_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count();
        inputDf2.write().format("org.apache.hudi").options((Map)options).mode(SaveMode.Append).save(this.basePath());
        String commitInstantTime3 = HoodieDataSourceHelpers.latestCommit((FileSystem)fs, (String)this.basePath());
        String commitCompletionTime3 = DataSourceTestUtils.latestCommitCompletionTime(fs, this.basePath());
        Assertions.assertEquals((int)3, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)fs, (String)this.basePath(), (String)"000").size());
        Dataset snapshotDf3 = this.spark().read().format("org.apache.hudi").option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabledOnRead).load(this.basePath()).cache();
        Assertions.assertEquals((long)10L, (long)snapshotDf3.count(), (String)"should still be 10, since we only updated");
        this.compareUpdateDfWithHudiDf((Dataset<Row>)inputDf2, (Dataset<Row>)snapshotDf3, (List<Row>)snapshotRows2, colsToSelect);
        snapshotDf3.unpersist(true);
        String firstCommit = (String)HoodieDataSourceHelpers.listCommitsSince((FileSystem)fs, (String)this.basePath(), (String)"000").get(0);
        Dataset hoodieIncViewDf1 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.START_COMMIT().key(), commitCompletionTime1).option(DataSourceReadOptions$.MODULE$.END_COMMIT().key(), commitCompletionTime1).option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabledOnRead).load(this.basePath());
        Assertions.assertEquals((long)10L, (long)hoodieIncViewDf1.count(), (String)"should have pulled 10 initial inserts");
        Row[] countsPerCommit = (Row[])hoodieIncViewDf1.groupBy("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().collect();
        Assertions.assertEquals((int)1, (int)countsPerCommit.length);
        Assertions.assertEquals((Object)firstCommit, (Object)countsPerCommit[0].get(0));
        List records3 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateUniqueUpdates("003", Predef$.MODULE$.int2Integer(8)))).asScala()).toList();
        Dataset inputDf3 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records3, Predef$.MODULE$.Integer2int(this.parallelism()), ClassTag$.MODULE$.apply(String.class))).cache();
        inputDf3.write().format("org.apache.hudi").options((Map)options).mode(SaveMode.Append).save(this.basePath());
        Dataset hoodieIncViewDf2 = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.START_COMMIT().key(), commitCompletionTime3).option(DataSourceReadOptions$.MODULE$.END_COMMIT().key(), commitCompletionTime3).option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabledOnRead).load(this.basePath());
        Assertions.assertEquals((long)uniqueKeyCnt2, (long)hoodieIncViewDf2.count(), (String)"should have pulled 6 records");
        countsPerCommit = (Row[])hoodieIncViewDf2.groupBy("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().collect();
        Assertions.assertEquals((int)1, (int)countsPerCommit.length);
        Assertions.assertEquals((Object)commitInstantTime3, (Object)countsPerCommit[0].get(0));
        Dataset timeTravelDf = this.spark().read().format("org.apache.hudi").option("as.of.instant", commitInstantTime2).load(this.basePath()).cache();
        Assertions.assertEquals((long)10L, (long)timeTravelDf.count());
        this.compareEntireInputRowsWithHudiDf((List<Row>)snapshotRows2, (Dataset<Row>)timeTravelDf, colsToSelect);
        timeTravelDf.unpersist(true);
        if (tableType.equals("MERGE_ON_READ")) {
            this.doMORReadOptimizedQuery((Dataset<Row>)inputDf0, colsToSelect, isMetadataEnabledOnRead);
            List snapshotRows4 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.spark().read().format("org.apache.hudi").option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabledOnRead).load(this.basePath()).collect())).toList();
            Assertions.assertEquals((int)10, (int)snapshotRows4.length());
            List records4 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateUniqueUpdates("004", Predef$.MODULE$.int2Integer(4)))).asScala()).toList();
            Dataset inputDf4 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records4, Predef$.MODULE$.Integer2int(this.parallelism()), ClassTag$.MODULE$.apply(String.class))).cache();
            inputDf4.write().format("org.apache.hudi").options((Map)options).option(HoodieCompactionConfig.INLINE_COMPACT.key(), "true").option(HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key(), "3").mode(SaveMode.Append).save(this.basePath());
            Dataset snapshotDf5 = this.spark().read().format("org.apache.hudi").option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabledOnRead).load(this.basePath()).cache();
            this.compareUpdateDfWithHudiDf((Dataset<Row>)inputDf4, (Dataset<Row>)snapshotDf5, (List<Row>)snapshotRows4, colsToSelect);
            inputDf4.unpersist(true);
            snapshotDf5.unpersist(true);
            this.compareROAndRT(this.basePath(), colsToSelect, isMetadataEnabledOnRead);
        }
        inputDf0.unpersist(true);
        updateDf.unpersist(true);
        inputDf2.unpersist(true);
        inputDf3.unpersist(true);
    }

    @ParameterizedTest
    @CsvSource(value={"COPY_ON_WRITE|insert|org.apache.hudi.keygen.SimpleKeyGenerator|BLOOM", "COPY_ON_WRITE|insert|org.apache.hudi.keygen.SimpleKeyGenerator|SIMPLE", "COPY_ON_WRITE|insert|org.apache.hudi.keygen.NonpartitionedKeyGenerator|GLOBAL_BLOOM", "MERGE_ON_READ|insert|org.apache.hudi.keygen.SimpleKeyGenerator|BLOOM", "MERGE_ON_READ|insert|org.apache.hudi.keygen.SimpleKeyGenerator|SIMPLE", "MERGE_ON_READ|insert|org.apache.hudi.keygen.NonpartitionedKeyGenerator|GLOBAL_BLOOM", "COPY_ON_WRITE|bulk_insert|org.apache.hudi.keygen.SimpleKeyGenerator|BLOOM", "COPY_ON_WRITE|bulk_insert|org.apache.hudi.keygen.SimpleKeyGenerator|SIMPLE", "COPY_ON_WRITE|bulk_insert|org.apache.hudi.keygen.NonpartitionedKeyGenerator|GLOBAL_BLOOM", "MERGE_ON_READ|bulk_insert|org.apache.hudi.keygen.SimpleKeyGenerator|BLOOM", "MERGE_ON_READ|bulk_insert|org.apache.hudi.keygen.SimpleKeyGenerator|SIMPLE", "MERGE_ON_READ|bulk_insert|org.apache.hudi.keygen.NonpartitionedKeyGenerator|GLOBAL_BLOOM"}, delimiter=124)
    public void testImmutableUserFlow(String tableType, String operation, String keyGenClass, String indexType) {
        boolean isMetadataEnabledOnWrite = true;
        boolean isMetadataEnabledOnRead = true;
        String partitionField = NonpartitionedKeyGenerator.class.getName().equals(keyGenClass) ? "" : "partition";
        scala.collection.immutable.Map options = this.commonOpts().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)String.valueOf(isMetadataEnabledOnWrite))).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)keyGenClass)).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)partitionField)).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType)).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndexConfig.INDEX_TYPE.key()), (Object)indexType));
        String colsToSelect = "_row_key, begin_lat,  begin_lon, city_to_state.LA, current_date, current_ts, distance_in_meters, driver, end_lat, end_lon, fare.amount, fare.currency, partition, partition_path, rider, timestamp, weight, _hoodie_is_deleted";
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(57069L);
        FileSystem fs = HadoopFSUtils.getFs((String)this.basePath(), (Configuration)this.spark().sparkContext().hadoopConfiguration());
        List records0 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateInserts("000", Predef$.MODULE$.int2Integer(10)))).asScala()).toList();
        Dataset inputDf0 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records0, Predef$.MODULE$.Integer2int(this.parallelism()), ClassTag$.MODULE$.apply(String.class))).cache();
        inputDf0.write().format("org.apache.hudi").options((Map)options).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), operation).mode(SaveMode.Overwrite).save(this.basePath());
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)fs, (String)this.basePath(), (String)"000"));
        Dataset snapshotDf1 = this.spark().read().format("org.apache.hudi").option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabledOnRead).load(this.basePath());
        Assertions.assertEquals((long)10L, (long)snapshotDf1.count());
        List records1 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateInserts("001", Predef$.MODULE$.int2Integer(5)))).asScala()).toList();
        Dataset inputDf1 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records1, Predef$.MODULE$.Integer2int(this.parallelism()), ClassTag$.MODULE$.apply(String.class))).cache();
        inputDf1.write().format("org.apache.hudi").options((Map)options).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), operation).mode(SaveMode.Append).save(this.basePath());
        Dataset snapshotDf2 = this.spark().read().format("hudi").option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabledOnRead).load(this.basePath()).cache();
        Assertions.assertEquals((long)15L, (long)snapshotDf2.count());
        this.compareEntireInputDfWithHudiDf((Dataset<Row>)inputDf1.union(inputDf0), (Dataset<Row>)snapshotDf2, colsToSelect);
        snapshotDf2.unpersist(true);
        List records2 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)dataGen.generateInserts("002", Predef$.MODULE$.int2Integer(6)))).asScala()).toList();
        Dataset inputDf2 = this.spark().read().json(this.spark().sparkContext().parallelize((Seq)records2, Predef$.MODULE$.Integer2int(this.parallelism()), ClassTag$.MODULE$.apply(String.class))).cache();
        inputDf2.write().format("org.apache.hudi").options((Map)options).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), operation).mode(SaveMode.Append).save(this.basePath());
        Assertions.assertEquals((int)3, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)fs, (String)this.basePath(), (String)"000").size());
        Dataset snapshotDf3 = this.spark().read().format("org.apache.hudi").option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabledOnRead).load(this.basePath()).cache();
        Assertions.assertEquals((long)21L, (long)snapshotDf3.count());
        this.compareEntireInputDfWithHudiDf((Dataset<Row>)inputDf1.union(inputDf0).union(inputDf2), (Dataset<Row>)snapshotDf3, colsToSelect);
        snapshotDf3.unpersist(true);
        inputDf0.unpersist(true);
        inputDf1.unpersist(true);
        inputDf2.unpersist(true);
    }

    @ParameterizedTest
    @CsvSource(value={"COPY_ON_WRITE,8,EVENT_TIME_ORDERING,RECORD_INDEX", "COPY_ON_WRITE,8,COMMIT_TIME_ORDERING,RECORD_INDEX", "COPY_ON_WRITE,8,EVENT_TIME_ORDERING,GLOBAL_SIMPLE", "COPY_ON_WRITE,8,COMMIT_TIME_ORDERING,GLOBAL_SIMPLE", "MERGE_ON_READ,8,EVENT_TIME_ORDERING,RECORD_INDEX", "MERGE_ON_READ,8,COMMIT_TIME_ORDERING,RECORD_INDEX", "MERGE_ON_READ,8,EVENT_TIME_ORDERING,GLOBAL_SIMPLE", "MERGE_ON_READ,8,COMMIT_TIME_ORDERING,GLOBAL_SIMPLE"})
    public void testDeletesWithHoodieIsDeleted(HoodieTableType tableType, int tableVersion, RecordMergeMode mergeMode, HoodieIndex.IndexType indexType) {
        Tuple2<scala.collection.immutable.Map<String, String>, scala.collection.immutable.Map<String, String>> tuple2 = CommonOptionUtils$.MODULE$.getWriterReaderOpts(HoodieRecord.HoodieRecordType.AVRO, CommonOptionUtils$.MODULE$.getWriterReaderOpts$default$2(), CommonOptionUtils$.MODULE$.getWriterReaderOpts$default$3());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.immutable.Map writeOpts = (scala.collection.immutable.Map)tuple2._1();
        scala.collection.immutable.Map readOpts = (scala.collection.immutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)writeOpts, (Object)readOpts);
        scala.collection.immutable.Map writeOpts2 = (scala.collection.immutable.Map)tuple22._1();
        scala.collection.immutable.Map readOpts2 = (scala.collection.immutable.Map)tuple22._2();
        writeOpts2 = writeOpts2.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.write.table.version"), (Object)Integer.toString(tableVersion)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.write.table.type"), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.write.precombine.field"), (Object)"ts"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.write.record.merge.mode"), (Object)mergeMode.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.index.type"), (Object)indexType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.metadata.record.index.enable"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.record.index.update.partition.path"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.parquet.small.file.limit"), (Object)"0")})));
        HoodieIndex.IndexType indexType2 = indexType;
        HoodieIndex.IndexType indexType3 = HoodieIndex.IndexType.RECORD_INDEX;
        writeOpts2 = writeOpts2.$plus(!(indexType2 != null ? !indexType2.equals(indexType3) : indexType3 != null) ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.record.index.update.partition.path"), (Object)"true") : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.simple.index.update.partition.path"), (Object)"true"));
        Schema schema = DataSourceTestUtils.getStructTypeExampleSchema();
        StructType structType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
        java.util.List<Row> inserts = DataSourceTestUtils.generateRandomRows(400);
        SparkContext qual$1 = this.spark().sparkContext();
        Seq<Row> x$1 = this.convertRowListToSeq(inserts);
        int x$2 = qual$1.parallelize$default$2();
        Dataset df = this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), structType);
        df.write().format("hudi").options((Map)writeOpts2).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), tableType.name()).mode(SaveMode.Overwrite).save(this.basePath());
        Dataset hudiSnapshotDF1 = this.spark().read().format("hudi").options((Map)readOpts2).load(this.basePath());
        Assertions.assertEquals((long)400L, (long)hudiSnapshotDF1.count());
        this.ingestNewBatch(tableType, Predef$.MODULE$.int2Integer(200), structType, inserts.subList(0, 200), (scala.collection.immutable.Map<String, String>)writeOpts2);
        RecordMergeMode recordMergeMode = mergeMode;
        RecordMergeMode recordMergeMode2 = RecordMergeMode.EVENT_TIME_ORDERING;
        int expectedRecordCount2 = !(recordMergeMode != null ? !recordMergeMode.equals(recordMergeMode2) : recordMergeMode2 != null) ? 350 : 300;
        Dataset hudiSnapshotDF2 = this.spark().read().format("hudi").options((Map)readOpts2).load(this.basePath());
        Assertions.assertEquals((long)expectedRecordCount2, (long)hudiSnapshotDF2.count());
        Assertions.assertEquals((long)expectedRecordCount2, (long)this.spark().read().format("hudi").options((Map)readOpts2).load(this.basePath()).select("_hoodie_record_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_partition_path"})).count());
        this.ingestNewBatch(tableType, Predef$.MODULE$.int2Integer(200), structType, inserts.subList(200, 400), (scala.collection.immutable.Map<String, String>)writeOpts2);
        RecordMergeMode recordMergeMode3 = mergeMode;
        RecordMergeMode recordMergeMode4 = RecordMergeMode.EVENT_TIME_ORDERING;
        int expectedRecordCount3 = !(recordMergeMode3 != null ? !recordMergeMode3.equals(recordMergeMode4) : recordMergeMode4 != null) ? 300 : 200;
        Dataset hudiSnapshotDF3 = this.spark().read().format("hudi").options((Map)readOpts2).load(this.basePath());
        Assertions.assertEquals((long)expectedRecordCount3, (long)hudiSnapshotDF3.count());
        Assertions.assertEquals((long)expectedRecordCount3, (long)this.spark().read().format("hudi").options((Map)readOpts2).load(this.basePath()).select("_hoodie_record_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_partition_path"})).count());
    }

    public void ingestNewBatch(HoodieTableType tableType, Integer recordsToUpdate, StructType structType, java.util.List<Row> inserts, scala.collection.immutable.Map<String, String> writeOpts) {
        java.util.List toUpdate = this.sqlContext().createDataFrame(DataSourceTestUtils.getUniqueRows(inserts, Predef$.MODULE$.Integer2int(recordsToUpdate)), structType).collectAsList();
        Dataset updateToSamePartitionHigherTs = this.sqlContext().createDataFrame(toUpdate.subList(0, Predef$.MODULE$.Integer2int(recordsToUpdate) / 4), structType);
        java.util.List<Row> rowsToUpdate1 = DataSourceTestUtils.updateRowsWithUpdatedTs((Dataset<Row>)updateToSamePartitionHigherTs);
        java.util.List<Row> updates1 = rowsToUpdate1.subList(0, Predef$.MODULE$.Integer2int(recordsToUpdate) / 8);
        SparkContext qual$1 = this.spark().sparkContext();
        Seq<Row> x$1 = this.convertRowListToSeq(updates1);
        int x$2 = qual$1.parallelize$default$2();
        Dataset updateDf1 = this.spark().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), structType);
        java.util.List<Row> deletes1 = rowsToUpdate1.subList(Predef$.MODULE$.Integer2int(recordsToUpdate) / 8, Predef$.MODULE$.Integer2int(recordsToUpdate) / 4);
        SparkContext qual$2 = this.spark().sparkContext();
        Seq<Row> x$3 = this.convertRowListToSeq(deletes1);
        int x$4 = qual$2.parallelize$default$2();
        Dataset deleteDf1 = this.spark().createDataFrame(qual$2.parallelize(x$3, x$4, ClassTag$.MODULE$.apply(Row.class)), structType);
        Dataset batch1 = deleteDf1.withColumn("_hoodie_is_deleted", functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true))).union(updateDf1);
        batch1.cache();
        Dataset updateToDiffPartitionHigherTs = this.sqlContext().createDataFrame(toUpdate.subList(Predef$.MODULE$.Integer2int(recordsToUpdate) / 4, Predef$.MODULE$.Integer2int(recordsToUpdate) / 2), structType);
        java.util.List<Row> rowsToUpdate2 = DataSourceTestUtils.updateRowsWithUpdatedTs((Dataset<Row>)updateToDiffPartitionHigherTs, Predef$.MODULE$.boolean2Boolean(false), Predef$.MODULE$.boolean2Boolean(true));
        java.util.List<Row> updates2 = rowsToUpdate2.subList(0, Predef$.MODULE$.Integer2int(recordsToUpdate) / 8);
        SparkContext qual$3 = this.spark().sparkContext();
        Seq<Row> x$5 = this.convertRowListToSeq(updates2);
        int x$6 = qual$3.parallelize$default$2();
        Dataset updateDf2 = this.spark().createDataFrame(qual$3.parallelize(x$5, x$6, ClassTag$.MODULE$.apply(Row.class)), structType);
        java.util.List<Row> deletes2 = rowsToUpdate2.subList(Predef$.MODULE$.Integer2int(recordsToUpdate) / 8, Predef$.MODULE$.Integer2int(recordsToUpdate) / 4);
        SparkContext qual$4 = this.spark().sparkContext();
        Seq<Row> x$7 = this.convertRowListToSeq(deletes2);
        int x$8 = qual$4.parallelize$default$2();
        Dataset deleteDf2 = this.spark().createDataFrame(qual$4.parallelize(x$7, x$8, ClassTag$.MODULE$.apply(Row.class)), structType);
        Dataset batch2 = deleteDf2.withColumn("_hoodie_is_deleted", functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true))).union(updateDf2);
        batch2.cache();
        Dataset updateToSamePartitionLowerTs = this.sqlContext().createDataFrame(toUpdate.subList(Predef$.MODULE$.Integer2int(recordsToUpdate) / 2, Predef$.MODULE$.Integer2int(recordsToUpdate) * 3 / 4), structType);
        java.util.List<Row> rowsToUpdate3 = DataSourceTestUtils.updateRowsWithUpdatedTs((Dataset<Row>)updateToSamePartitionLowerTs, Predef$.MODULE$.boolean2Boolean(true), Predef$.MODULE$.boolean2Boolean(false));
        java.util.List<Row> updates3 = rowsToUpdate3.subList(0, Predef$.MODULE$.Integer2int(recordsToUpdate) / 8);
        SparkContext qual$5 = this.spark().sparkContext();
        Seq<Row> x$9 = this.convertRowListToSeq(updates3);
        int x$10 = qual$5.parallelize$default$2();
        Dataset updateDf3 = this.spark().createDataFrame(qual$5.parallelize(x$9, x$10, ClassTag$.MODULE$.apply(Row.class)), structType);
        java.util.List<Row> deletes3 = rowsToUpdate3.subList(Predef$.MODULE$.Integer2int(recordsToUpdate) / 8, Predef$.MODULE$.Integer2int(recordsToUpdate) / 4);
        SparkContext qual$6 = this.spark().sparkContext();
        Seq<Row> x$11 = this.convertRowListToSeq(deletes3);
        int x$12 = qual$6.parallelize$default$2();
        Dataset deleteDf3 = this.spark().createDataFrame(qual$6.parallelize(x$11, x$12, ClassTag$.MODULE$.apply(Row.class)), structType);
        Dataset batch3 = deleteDf3.withColumn("_hoodie_is_deleted", functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true))).union(updateDf3);
        batch3.cache();
        Dataset updateToDiffPartitionLowerTs = this.sqlContext().createDataFrame(toUpdate.subList(Predef$.MODULE$.Integer2int(recordsToUpdate) * 3 / 4, Predef$.MODULE$.Integer2int(recordsToUpdate)), structType);
        java.util.List<Row> rowsToUpdate4 = DataSourceTestUtils.updateRowsWithUpdatedTs((Dataset<Row>)updateToDiffPartitionLowerTs, Predef$.MODULE$.boolean2Boolean(true), Predef$.MODULE$.boolean2Boolean(true));
        java.util.List<Row> updates4 = rowsToUpdate4.subList(0, Predef$.MODULE$.Integer2int(recordsToUpdate) / 8);
        SparkContext qual$7 = this.spark().sparkContext();
        Seq<Row> x$13 = this.convertRowListToSeq(updates4);
        int x$14 = qual$7.parallelize$default$2();
        Dataset updateDf4 = this.spark().createDataFrame(qual$7.parallelize(x$13, x$14, ClassTag$.MODULE$.apply(Row.class)), structType);
        java.util.List<Row> deletes4 = rowsToUpdate4.subList(Predef$.MODULE$.Integer2int(recordsToUpdate) / 8, Predef$.MODULE$.Integer2int(recordsToUpdate) / 4);
        SparkContext qual$8 = this.spark().sparkContext();
        Seq<Row> x$15 = this.convertRowListToSeq(deletes4);
        int x$16 = qual$8.parallelize$default$2();
        Dataset deleteDf4 = this.spark().createDataFrame(qual$8.parallelize(x$15, x$16, ClassTag$.MODULE$.apply(Row.class)), structType);
        Dataset batch4 = deleteDf4.withColumn("_hoodie_is_deleted", functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true))).union(updateDf4);
        batch4.cache();
        batch1.union(batch2).union(batch3).union(batch4).write().format("hudi").options(writeOpts).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), tableType.name()).mode(SaveMode.Append).save(this.basePath());
    }

    public void compareUpdateDfWithHudiDf(Dataset<Row> inputDf, Dataset<Row> hudiDf, List<Row> beforeRows, String colsToCompare) {
        Dataset hudiWithoutMetaDf = hudiDf.drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{HoodieRecord.RECORD_KEY_METADATA_FIELD, HoodieRecord.PARTITION_PATH_METADATA_FIELD, HoodieRecord.COMMIT_SEQNO_METADATA_FIELD, HoodieRecord.COMMIT_TIME_METADATA_FIELD, HoodieRecord.FILENAME_METADATA_FIELD}));
        hudiWithoutMetaDf.registerTempTable("hudiTbl");
        inputDf.registerTempTable("inputTbl");
        Dataset beforeDf = this.spark().createDataFrame((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(beforeRows).asJava(), hudiDf.schema());
        beforeDf.registerTempTable("beforeTbl");
        Dataset hudiDfToCompare = this.spark().sqlContext().sql(new StringBuilder(20).append("select ").append(colsToCompare).append(" from hudiTbl").toString());
        Dataset inputDfToCompare = this.spark().sqlContext().sql(new StringBuilder(21).append("select ").append(colsToCompare).append(" from inputTbl").toString());
        Dataset beforeDfToCompare = this.spark().sqlContext().sql(new StringBuilder(22).append("select ").append(colsToCompare).append(" from beforeTbl").toString());
        Assertions.assertEquals((long)inputDfToCompare.count(), (long)hudiDfToCompare.intersect(inputDfToCompare).count());
        Assertions.assertEquals((float)0.0f, (float)hudiDfToCompare.except(inputDfToCompare).except(beforeDfToCompare).count(), (float)0.0f);
    }

    public void compareEntireInputRowsWithHudiDf(List<Row> inputRows, Dataset<Row> hudiDf, String colsToCompare) {
        Dataset inputDf = this.spark().createDataFrame((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(inputRows).asJava(), hudiDf.schema());
        this.compareEntireInputDfWithHudiDf((Dataset<Row>)inputDf, hudiDf, colsToCompare);
    }

    public void compareEntireInputDfWithHudiDf(Dataset<Row> inputDf, Dataset<Row> hudiDf, String colsToCompare) {
        Dataset hudiWithoutMetaDf = hudiDf.drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{HoodieRecord.RECORD_KEY_METADATA_FIELD, HoodieRecord.PARTITION_PATH_METADATA_FIELD, HoodieRecord.COMMIT_SEQNO_METADATA_FIELD, HoodieRecord.COMMIT_TIME_METADATA_FIELD, HoodieRecord.FILENAME_METADATA_FIELD}));
        hudiWithoutMetaDf.registerTempTable("hudiTbl");
        inputDf.registerTempTable("inputTbl");
        Dataset hudiDfToCompare = this.spark().sqlContext().sql(new StringBuilder(20).append("select ").append(colsToCompare).append(" from hudiTbl").toString());
        Dataset inputDfToCompare = this.spark().sqlContext().sql(new StringBuilder(21).append("select ").append(colsToCompare).append(" from inputTbl").toString());
        Assertions.assertEquals((long)inputDfToCompare.count(), (long)hudiDfToCompare.intersect(inputDfToCompare).count());
        Assertions.assertEquals((long)0L, (long)hudiDfToCompare.except(inputDfToCompare).count());
    }

    public void doMORReadOptimizedQuery(Dataset<Row> inputDf, String colsToSelect, boolean isMetadataEnabledOnRead) {
        Dataset readOptDf = this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabledOnRead).load(this.basePath());
        this.compareEntireInputDfWithHudiDf(inputDf, (Dataset<Row>)readOptDf, colsToSelect);
    }

    public void compareROAndRT(String basePath, String colsToCompare, boolean isMetadataEnabledOnRead) {
        Dataset roDf = this.spark().read().format("org.apache.hudi").option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabledOnRead).option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).load(basePath);
        Dataset rtDf = this.spark().read().format("org.apache.hudi").option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabledOnRead).load(basePath);
        Dataset hudiWithoutMeta1Df = roDf.drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{HoodieRecord.RECORD_KEY_METADATA_FIELD, HoodieRecord.PARTITION_PATH_METADATA_FIELD, HoodieRecord.COMMIT_SEQNO_METADATA_FIELD, HoodieRecord.COMMIT_TIME_METADATA_FIELD, HoodieRecord.FILENAME_METADATA_FIELD}));
        Dataset hudiWithoutMeta2Df = rtDf.drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{HoodieRecord.RECORD_KEY_METADATA_FIELD, HoodieRecord.PARTITION_PATH_METADATA_FIELD, HoodieRecord.COMMIT_SEQNO_METADATA_FIELD, HoodieRecord.COMMIT_TIME_METADATA_FIELD, HoodieRecord.FILENAME_METADATA_FIELD}));
        hudiWithoutMeta1Df.registerTempTable("hudiTbl1");
        hudiWithoutMeta2Df.registerTempTable("hudiTbl2");
        Dataset hudiDf1ToCompare = this.spark().sqlContext().sql(new StringBuilder(21).append("select ").append(colsToCompare).append(" from hudiTbl1").toString());
        Dataset hudiDf2ToCompare = this.spark().sqlContext().sql(new StringBuilder(21).append("select ").append(colsToCompare).append(" from hudiTbl2").toString());
        Assertions.assertEquals((long)hudiDf1ToCompare.count(), (long)hudiDf1ToCompare.intersect(hudiDf2ToCompare).count());
        Assertions.assertEquals((long)0L, (long)hudiDf1ToCompare.except(hudiDf2ToCompare).count());
    }

    public Seq<Row> convertRowListToSeq(java.util.List<Row> inputList) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(inputList.iterator()).asScala()).toSeq();
    }
}

