/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.functional.SparkSQLCoreFlow;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.Assertions;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Inspectors$;
import org.scalatest.Tag;
import org.scalatest.enablers.Collecting$;
import org.scalatest.enablers.InspectorAsserting$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@SparkSQLCoreFlow
@ScalaSignature(bytes="\u0006\u0001\t}a\u0001\u0002\u000e\u001c\u0001\u0011BQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001C\u0002\u0013\u0005Q\u0007\u0003\u0004?\u0001\u0001\u0006IA\u000e\u0005\b\u007f\u0001\u0011\r\u0011\"\u0001A\u0011\u00191\u0006\u0001)A\u0005\u0003\")q\u000b\u0001C\u00011\")\u0001\u000f\u0001C\u0005c\"9\u00111\u0002\u0001\u0005\n\u00055\u0001bBA\n\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0003O\u0001A\u0011AA\u0015\u0011\u001d\tI\u0006\u0001C\u0001\u00037Bq!!\u001a\u0001\t\u0003\t9\u0007C\u0004\u0002r\u0001!\t!a\u001d\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002\u0006\"9\u0011\u0011\u0013\u0001\u0005\u0002\u0005M\u0005bBAW\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0003o\u0003A\u0011AA]\u0011\u001d\tI\r\u0001C\u0001\u0003\u0017Dq!a8\u0001\t\u0003\t\t\u000fC\u0004\u0002l\u0002!\t!!<\t\u000f\u0005M\b\u0001\"\u0001\u0002v\"9\u0011Q \u0001\u0005\u0002\u0005}\b\u0002\u0003B\u0002\u0001\t\u0007I\u0011\u0001!\t\u000f\t\u0015\u0001\u0001)A\u0005\u0003\"9!q\u0001\u0001\u0005\u0002\t%!\u0001\u0006+fgR\u001c\u0006/\u0019:l'Fd7i\u001c:f\r2|wO\u0003\u0002\u001d;\u0005Qa-\u001e8di&|g.\u00197\u000b\u0005yy\u0012\u0001\u00025vI&T!\u0001I\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0013aA8sO\u000e\u00011C\u0001\u0001&!\t1c&D\u0001(\u0015\tA\u0013&\u0001\u0004d_6lwN\u001c\u0006\u0003=)R!a\u000b\u0017\u0002\u0007M\fHN\u0003\u0002.?\u0005)1\u000f]1sW&\u0011qf\n\u0002\u0017\u0011>|G-[3Ta\u0006\u00148nU9m)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012A\r\t\u0003g\u0001i\u0011aG\u0001\u000eG>d7\u000fV8D_6\u0004\u0018M]3\u0016\u0003Y\u0002\"a\u000e\u001f\u000e\u0003aR!!\u000f\u001e\u0002\t1\fgn\u001a\u0006\u0002w\u0005!!.\u0019<b\u0013\ti\u0004H\u0001\u0004TiJLgnZ\u0001\u000fG>d7\u000fV8D_6\u0004\u0018M]3!\u0003\u0019\u0001\u0018M]1ngV\t\u0011\tE\u0002C\u0019>s!aQ%\u000f\u0005\u0011;U\"A#\u000b\u0005\u0019\u001b\u0013A\u0002\u001fs_>$h(C\u0001I\u0003\u0015\u00198-\u00197b\u0013\tQ5*A\u0004qC\u000e\\\u0017mZ3\u000b\u0003!K!!\u0014(\u0003\t1K7\u000f\u001e\u0006\u0003\u0015.\u0003\"\u0001\u0015+\u000f\u0005E\u0013\u0006C\u0001#L\u0013\t\u00196*\u0001\u0004Qe\u0016$WMZ\u0005\u0003{US!aU&\u0002\u000fA\f'/Y7tA\u0005iA/Z:u\u0007>\u0014XM\u00127poN$b!W/fO2t\u0007C\u0001.\\\u001b\u0005Y\u0015B\u0001/L\u0005\u0011)f.\u001b;\t\u000by3\u0001\u0019A0\u0002\u0011\t\f7/\u001a)bi\"\u0004\"\u0001Y2\u000e\u0003\u0005T!A\u0019\u001e\u0002\u0005%|\u0017B\u00013b\u0005\u00111\u0015\u000e\\3\t\u000b\u00194\u0001\u0019A(\u0002\u0013Q\f'\r\\3UsB,\u0007\"\u00025\u0007\u0001\u0004I\u0017!E5t\u001b\u0016$\u0018\rZ1uC\u0016s\u0017M\u00197fIB\u0011!L[\u0005\u0003W.\u0013qAQ8pY\u0016\fg\u000eC\u0003n\r\u0001\u0007q*A\u0006lKf<UM\\\"mCN\u001c\b\"B8\u0007\u0001\u0004y\u0015!C5oI\u0016DH+\u001f9f\u00039\u0019\u0017M\\8oS\u000e\fG.\u001b>f\t\u001a#\"A]=\u0011\u0005M4hB\u0001;v\u001b\u0005Q\u0013B\u0001&+\u0013\t9\bPA\u0005ECR\fgI]1nK*\u0011!J\u000b\u0005\u0006u\u001e\u0001\ra_\u0001\tS:\u0004X\u000f\u001e#gaA\u0011AP\u001e\b\u0003{Vt1A`A\u0005\u001d\ry\u0018q\u0001\b\u0005\u0003\u0003\t)AD\u0002E\u0003\u0007I\u0011AI\u0005\u0003A\u0005J!!L\u0010\n\u0005-b\u0013AE1eI6Kg.[7v[RKW.Z+oSR$2aTA\b\u0011\u0019\t\t\u0002\u0003a\u0001\u001f\u0006)2m\\7nSR\u001cu.\u001c9mKRLwN\u001c+j[\u0016\u0014\u0014A\u00043p':\f\u0007o\u001d5piJ+\u0017\r\u001a\u000b\u0007\u0003/\ty\"a\t\u0011\u0007\u0005eaOD\u0002\u0002\u001cUtA!!\b\u0002\n5\tA\u0006\u0003\u0004\u0002\"%\u0001\raT\u0001\ni\u0006\u0014G.\u001a(b[\u0016Da!!\n\n\u0001\u0004I\u0017aF5t\u001b\u0016$\u0018\rZ1uC\u0016s\u0017M\u00197fI>s'+Z1e\u0003=!w.\u00138mS:,7i\\7qC\u000e$HcD-\u0002,\u00055\u0012\u0011GA\u001b\u0003\u000f\nY%a\u0014\t\r\u0005\u0005\"\u00021\u0001P\u0011\u0019\tyC\u0003a\u0001\u001f\u0006iA/\u00192mK\n\u000b7/\u001a)bi\"Dq!a\r\u000b\u0001\u0004\t9\"A\u0003sK\u000e$e\rC\u0004\u00028)\u0001\r!!\u000f\u0002\u000f]\u0014\u0018\u000e^3PaB!\u00111HA\"\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013!B7pI\u0016d'B\u0001\u0015\u001e\u0013\u0011\t)%!\u0010\u0003%]\u0013\u0018\u000e^3Pa\u0016\u0014\u0018\r^5p]RK\b/\u001a\u0005\u0007\u0003\u0013R\u0001\u0019A5\u00021%\u001cX*\u001a;bI\u0006$\u0018-\u00128bE2,Gm\u00148Xe&$X\r\u0003\u0004\u0002N)\u0001\raT\u0001\u0010]VlG)\u001a7uC\u000e{W.\\5ug\"9\u0011\u0011\u000b\u0006A\u0002\u0005M\u0013!B2pk:$\bc\u0001.\u0002V%\u0019\u0011qK&\u0003\u0007%sG/A\bhKR<&/\u001b;f\u001fB$\u0018n\u001c8t)%y\u0015QLA0\u0003C\n\u0019\u0007\u0003\u0004\u0002\"-\u0001\ra\u0014\u0005\u0006M.\u0001\ra\u0014\u0005\u0006[.\u0001\ra\u0014\u0005\u0006_.\u0001\raT\u0001\u0010CN\u001cXM\u001d;Pa\u0016\u0014\u0018\r^5p]R9\u0011.!\u001b\u0002l\u00055\u0004\"\u00020\r\u0001\u0004y\u0005bBA)\u0019\u0001\u0007\u00111\u000b\u0005\b\u0003_b\u0001\u0019AA\u001d\u00035y\u0007/\u001a:bi&|g\u000eV=qK\u0006Q\u0011N\\:feRLe\u000e^8\u0015\u001be\u000b)(a\u001e\u0002z\u0005u\u0014qPAA\u0011\u0019\t\t#\u0004a\u0001\u001f\"1\u0011qF\u0007A\u0002=Cq!a\u001f\u000e\u0001\u0004\t9\"A\u0004j]B,H\u000f\u00124\t\u000f\u0005]R\u00021\u0001\u0002:!1\u0011\u0011J\u0007A\u0002%Dq!!\u0015\u000e\u0001\u0004\t\u0019&A\u0006de\u0016\fG/\u001a+bE2,G#C-\u0002\b\u0006%\u00151RAH\u0011\u0019\t\tC\u0004a\u0001\u001f\")QN\u0004a\u0001\u001f\"1\u0011Q\u0012\bA\u0002=\u000bAb\u001e:ji\u0016|\u0005\u000f^5p]NDa!a\f\u000f\u0001\u0004y\u0015aD4f]\u0016\u0014\u0018\r^3J]N,'\u000f^:\u0015\u0011\u0005]\u0011QSAS\u0003SCq!a&\u0010\u0001\u0004\tI*A\u0004eCR\fw)\u001a8\u0011\t\u0005m\u0015\u0011U\u0007\u0003\u0003;SA!a(\u0002B\u0005IA/Z:ukRLGn]\u0005\u0005\u0003G\u000biJA\fI_>$\u0017.\u001a+fgR$\u0015\r^1HK:,'/\u0019;pe\"1\u0011qU\bA\u0002=\u000b1\"\u001b8ti\u0006tG\u000fV5nK\"9\u00111V\bA\u0002\u0005M\u0013!\u00018\u0002+\u001d,g.\u001a:bi\u0016,f.[9vKV\u0003H-\u0019;fgRA\u0011qCAY\u0003g\u000b)\fC\u0004\u0002\u0018B\u0001\r!!'\t\r\u0005\u001d\u0006\u00031\u0001P\u0011\u001d\tY\u000b\u0005a\u0001\u0003'\n\u0011B]8xg\u0016\u000bX/\u00197\u0015\u000b%\fY,!2\t\u000f\u0005u\u0016\u00031\u0001\u0002@\u0006!!o\\<2!\r!\u0018\u0011Y\u0005\u0004\u0003\u0007T#a\u0001*po\"9\u0011qY\tA\u0002\u0005}\u0016\u0001\u0002:poJ\nQdY8na\u0006\u0014X-\u00169eCR,'k\\<t/&$\b\u000eS;eSJ{wo\u001d\u000b\b3\u00065\u0017q[An\u0011\u001d\tyM\u0005a\u0001\u0003#\f\u0011\u0002Z3mi\u0006\u0014vn^:\u0011\u000bi\u000b\u0019.a0\n\u0007\u0005U7JA\u0003BeJ\f\u0017\u0010C\u0004\u0002ZJ\u0001\r!!5\u0002\u0013\u00054G/\u001a:S_^\u001c\bbBAo%\u0001\u0007\u0011\u0011[\u0001\u000bE\u00164wN]3S_^\u001c\u0018AI2p[B\f'/Z#oi&\u0014X-\u00138qkR\u0014vn^:XSRD\u0007*\u001e3j%><8\u000fF\u0003Z\u0003G\f9\u000fC\u0004\u0002fN\u0001\r!!5\u0002\u0019\u0015D\b/Z2uK\u0012\u0014vn^:\t\u000f\u0005%8\u00031\u0001\u0002R\u0006Q\u0011m\u0019;vC2\u0014vn^:\u0002/\u0011|Wj\u0014*SK\u0006$w\n\u001d;j[&TX\rZ)vKJLHCBA\f\u0003_\f\t\u0010\u0003\u0004\u0002&Q\u0001\r!\u001b\u0005\u0006=R\u0001\raT\u0001\u000fG>l\u0007/\u0019:f%>\u000be\u000e\u001a*U)\u001dI\u0016q_A}\u0003wDa!!\n\u0016\u0001\u0004I\u0007BBA\u0011+\u0001\u0007q\nC\u0003_+\u0001\u0007q*A\bee>\u0004X*\u001a;b\u0007>dW/\u001c8t)\u0011\t9B!\u0001\t\u000f\u0005md\u00031\u0001\u0002\u0018\u0005\u0011\u0002/\u0019:b[N4uN]%n[V$\u0018M\u00197f\u0003M\u0001\u0018M]1ng\u001a{'/S7nkR\f'\r\\3!\u0003U!Xm\u001d;J[6,H/\u00192mKV\u001bXM\u001d$m_^$R\"\u0017B\u0006\u0005\u001b\u0011yA!\u0005\u0003\u0014\tU\u0001\"\u00020\u001a\u0001\u0004y\u0006\"\u00024\u001a\u0001\u0004y\u0005bBA\u001c3\u0001\u0007\u0011\u0011\b\u0005\u0006Qf\u0001\r!\u001b\u0005\u0006[f\u0001\ra\u0014\u0005\u0006_f\u0001\ra\u0014\u0015\u0004\u0001\te\u0001cA\u001a\u0003\u001c%\u0019!QD\u000e\u0003!M\u0003\u0018M]6T#2\u001buN]3GY><\b")
public class TestSparkSqlCoreFlow
extends HoodieSparkSqlTestBase {
    private final String colsToCompare;
    private final List<String> params = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COPY_ON_WRITE|false|org.apache.hudi.keygen.SimpleKeyGenerator|GLOBAL_BLOOM", "COPY_ON_WRITE|true|org.apache.hudi.keygen.SimpleKeyGenerator|GLOBAL_BLOOM", "COPY_ON_WRITE|false|org.apache.hudi.keygen.SimpleKeyGenerator|GLOBAL_SIMPLE", "COPY_ON_WRITE|true|org.apache.hudi.keygen.SimpleKeyGenerator|GLOBAL_SIMPLE", "COPY_ON_WRITE|false|org.apache.hudi.keygen.NonpartitionedKeyGenerator|BLOOM", "COPY_ON_WRITE|true|org.apache.hudi.keygen.NonpartitionedKeyGenerator|BLOOM", "COPY_ON_WRITE|false|org.apache.hudi.keygen.NonpartitionedKeyGenerator|SIMPLE", "COPY_ON_WRITE|true|org.apache.hudi.keygen.NonpartitionedKeyGenerator|SIMPLE", "MERGE_ON_READ|false|org.apache.hudi.keygen.SimpleKeyGenerator|GLOBAL_BLOOM", "MERGE_ON_READ|true|org.apache.hudi.keygen.SimpleKeyGenerator|GLOBAL_BLOOM", "MERGE_ON_READ|false|org.apache.hudi.keygen.SimpleKeyGenerator|GLOBAL_SIMPLE", "MERGE_ON_READ|true|org.apache.hudi.keygen.SimpleKeyGenerator|GLOBAL_SIMPLE", "MERGE_ON_READ|false|org.apache.hudi.keygen.NonpartitionedKeyGenerator|BLOOM", "MERGE_ON_READ|true|org.apache.hudi.keygen.NonpartitionedKeyGenerator|BLOOM", "MERGE_ON_READ|false|org.apache.hudi.keygen.NonpartitionedKeyGenerator|SIMPLE", "MERGE_ON_READ|true|org.apache.hudi.keygen.NonpartitionedKeyGenerator|SIMPLE"}));
    private final List<String> paramsForImmutable;

    public String colsToCompare() {
        return this.colsToCompare;
    }

    public List<String> params() {
        return this.params;
    }

    public void testCoreFlows(File basePath, String tableType, boolean isMetadataEnabled, String keyGenClass, String indexType) {
        String tableName = this.generateTableName();
        String tableBasePath = new StringBuilder(1).append(basePath.getCanonicalPath()).append("/").append(tableName).toString();
        String writeOptions = this.getWriteOptions(tableName, tableType, keyGenClass, indexType);
        this.createTable(tableName, keyGenClass, writeOptions, tableBasePath);
        FileSystem fs = HadoopFSUtils.getFs((String)tableBasePath, (Configuration)this.spark().sparkContext().hadoopConfiguration());
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", 57069L);
        Dataset inputDf0 = this.generateInserts(dataGen, "000", 100).cache();
        this.insertInto(tableName, tableBasePath, (Dataset<Row>)inputDf0, WriteOperationType.BULK_INSERT, isMetadataEnabled, 1);
        Row[] inputDf0Rows = (Row[])this.canonicalizeDF((Dataset<Row>)inputDf0).collect();
        inputDf0.unpersist(true);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)fs, (String)tableBasePath, (String)"000"));
        Dataset<Row> snapshotDf1 = this.doSnapshotRead(tableName, isMetadataEnabled);
        Row[] snapshotDf1Rows = (Row[])this.canonicalizeDF(this.dropMetaColumns(snapshotDf1)).collect();
        Assertions.assertEquals((long)100L, (long)snapshotDf1.count());
        this.compareEntireInputRowsWithHudiRows(inputDf0Rows, snapshotDf1Rows);
        Dataset updateDf = this.generateUniqueUpdates(dataGen, "001", 50).cache();
        this.insertInto(tableName, tableBasePath, (Dataset<Row>)updateDf, WriteOperationType.UPSERT, isMetadataEnabled, 2);
        HoodieInstant commitInstant2 = HoodieDataSourceHelpers.latestCompletedCommit((FileSystem)fs, (String)tableBasePath);
        String commitCompletionTime2 = commitInstant2.getCompletionTime();
        Dataset<Row> snapshotDf2 = this.doSnapshotRead(tableName, isMetadataEnabled);
        Row[] snapshotDf2Rows = (Row[])this.canonicalizeDF(this.dropMetaColumns(snapshotDf2)).collect();
        Assertions.assertEquals((int)100, (int)snapshotDf2Rows.length);
        this.compareUpdateRowsWithHudiRows((Row[])this.canonicalizeDF((Dataset<Row>)updateDf).collect(), snapshotDf2Rows, snapshotDf1Rows);
        updateDf.unpersist(true);
        Dataset inputDf2 = this.generateUniqueUpdates(dataGen, "002", 60).cache();
        long uniqueKeyCnt2 = inputDf2.select("_row_key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().count();
        this.insertInto(tableName, tableBasePath, (Dataset<Row>)inputDf2, WriteOperationType.UPSERT, isMetadataEnabled, 3);
        HoodieInstant commitInstant3 = HoodieDataSourceHelpers.latestCompletedCommit((FileSystem)fs, (String)tableBasePath);
        String commitCompletionTime3 = commitInstant3.getCompletionTime();
        Assertions.assertEquals((int)3, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)fs, (String)tableBasePath, (String)"000").size());
        Row[] snapshotDf3Rows = (Row[])this.canonicalizeDF(this.doSnapshotRead(tableName, isMetadataEnabled)).collect();
        Assertions.assertEquals((int)100, (int)snapshotDf3Rows.length);
        this.compareUpdateRowsWithHudiRows((Row[])this.canonicalizeDF((Dataset<Row>)inputDf2).collect(), snapshotDf3Rows, snapshotDf3Rows);
        inputDf2.unpersist(true);
        HoodieInstant firstCommitInstant = (HoodieInstant)HoodieDataSourceHelpers.streamCompletedInstantSince((FileSystem)fs, (String)tableBasePath, (String)"000").findFirst().get();
        String firstCommitCompletionTime = firstCommitInstant.getCompletionTime();
        Dataset hoodieIncViewDf1 = this.spark().sql(new StringBuilder(68).append("select * from hudi_table_changes('").append(tableName).append("', 'latest_state', 'earliest', '").append(firstCommitCompletionTime).append("')").toString());
        Assertions.assertEquals((long)100L, (long)hoodieIncViewDf1.count());
        Row[] countsPerCommit = (Row[])hoodieIncViewDf1.groupBy("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().collect();
        Assertions.assertEquals((int)1, (int)countsPerCommit.length);
        Assertions.assertEquals((Object)firstCommitInstant.requestedTime(), (Object)countsPerCommit[0].get(0).toString());
        Dataset<Row> inputDf3 = this.generateUniqueUpdates(dataGen, "003", 80);
        this.insertInto(tableName, tableBasePath, inputDf3, WriteOperationType.UPSERT, isMetadataEnabled, 4);
        String commitCompletionTime2_1 = this.addMinimumTimeUnit(commitCompletionTime2);
        Dataset hoodieIncViewDf2 = this.spark().sql(new StringBuilder(60).append("select * from hudi_table_changes('").append(tableName).append("', 'latest_state', '").append(commitCompletionTime2_1).append("', '").append(commitCompletionTime3).append("')").toString());
        Assertions.assertEquals((long)uniqueKeyCnt2, (long)hoodieIncViewDf2.count());
        countsPerCommit = (Row[])hoodieIncViewDf2.groupBy("_hoodie_commit_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().collect();
        Assertions.assertEquals((int)1, (int)countsPerCommit.length);
        Assertions.assertEquals((Object)commitInstant3.requestedTime(), (Object)countsPerCommit[0].get(0).toString());
        String commit2RequestTime = commitInstant2.requestedTime();
        Dataset timeTravelDf = this.spark().sql(new StringBuilder(33).append("select * from ").append(tableName).append(" timestamp as of '").append(commit2RequestTime).append("'").toString());
        Row[] timeTravelDfRows = (Row[])this.dropMetaColumns(this.canonicalizeDF((Dataset<Row>)timeTravelDf)).collect();
        Assertions.assertEquals((int)100, (int)timeTravelDfRows.length);
        this.compareEntireInputRowsWithHudiRows(snapshotDf2Rows, timeTravelDfRows);
        timeTravelDf.unpersist(true);
        if (tableType.equals("MERGE_ON_READ")) {
            Row[] readOptRows = (Row[])this.canonicalizeDF(this.doMORReadOptimizedQuery(isMetadataEnabled, tableBasePath)).collect();
            this.compareEntireInputRowsWithHudiRows(inputDf0Rows, readOptRows);
            Row[] snapshotDf4Rows = (Row[])this.canonicalizeDF(this.doSnapshotRead(tableName, isMetadataEnabled)).collect();
            Dataset inputDf4 = this.generateUniqueUpdates(dataGen, "004", 40).cache();
            this.doInlineCompact(tableName, tableBasePath, (Dataset<Row>)inputDf4, WriteOperationType.UPSERT, isMetadataEnabled, "3", 6);
            Row[] snapshotDf5Rows = (Row[])this.canonicalizeDF(this.doSnapshotRead(tableName, isMetadataEnabled)).collect();
            this.compareUpdateRowsWithHudiRows((Row[])this.canonicalizeDF((Dataset<Row>)inputDf4).collect(), snapshotDf5Rows, snapshotDf4Rows);
            inputDf4.unpersist(true);
            this.compareROAndRT(isMetadataEnabled, tableName, tableBasePath);
            return;
        }
    }

    private Dataset<Row> canonicalizeDF(Dataset<Row> inputDf0) {
        return inputDf0.selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.colsToCompare().split(",")));
    }

    private String addMinimumTimeUnit(String commitCompletionTime2) {
        return String.valueOf(new StringOps(Predef$.MODULE$.augmentString(commitCompletionTime2)).toLong() + 1L);
    }

    public Dataset<Row> doSnapshotRead(String tableName, boolean isMetadataEnabledOnRead) {
        Dataset dataset;
        try {
            this.spark().sql(new StringBuilder(33).append("set hoodie.datasource.query.type=").append(DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()).toString());
            this.spark().sql(new StringBuilder(27).append("set hoodie.metadata.enable=").append(isMetadataEnabledOnRead).toString());
            dataset = this.spark().sql(new StringBuilder(14).append("select * from ").append(tableName).toString());
        }
        finally {
            this.spark().conf().unset("hoodie.datasource.query.type");
            this.spark().conf().unset("hoodie.metadata.enable");
        }
        return dataset;
    }

    public void doInlineCompact(String tableName, String tableBasePath, Dataset<Row> recDf, WriteOperationType writeOp, boolean isMetadataEnabledOnWrite, String numDeltaCommits, int count) {
        try {
            this.spark().sql("set hoodie.compact.inline=true");
            this.spark().sql(new StringBuilder(44).append("set hoodie.compact.inline.max.delta.commits=").append(numDeltaCommits).toString());
            this.insertInto(tableName, tableBasePath, recDf, writeOp, isMetadataEnabledOnWrite, count);
        }
        finally {
            this.spark().conf().unset("hoodie.compact.inline");
            this.spark().conf().unset("hoodie.compact.inline.max.delta.commits");
        }
    }

    public String getWriteOptions(String tableName, String tableType, String keyGenClass, String indexType) {
        String typeString = tableType.equals("COPY_ON_WRITE") ? "cow" : (tableType.equals("MERGE_ON_READ") ? "mor" : tableType);
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(496).append("\n       |tblproperties (\n       |  type = '").append(typeString).append("',\n       |  primaryKey = '_row_key',\n       |  preCombineField = 'timestamp',\n       |  hoodie.bulkinsert.shuffle.parallelism = 4,\n       |  hoodie.database.name = \"databaseName\",\n       |  hoodie.table.keygenerator.class = '").append(keyGenClass).append("',\n       |  hoodie.delete.shuffle.parallelism = 2,\n       |  hoodie.index.type = \"").append(indexType).append("\",\n       |  hoodie.insert.shuffle.parallelism = 4,\n       |  hoodie.table.name = \"").append(tableName).append("\",\n       |  hoodie.upsert.shuffle.parallelism = 4\n       | )").toString())).stripMargin();
    }

    public boolean assertOperation(String basePath, int count, WriteOperationType operationType) {
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)this.spark(), (String)basePath);
        HoodieTimeline timeline = metaClient.getActiveTimeline().getAllCommitsTimeline();
        int $org_scalatest_assert_macro_left = timeline.countInstants();
        int $org_scalatest_assert_macro_right = count;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSparkSqlCoreFlow.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        org.apache.hudi.common.util.Option latestCommit = timeline.lastInstant();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(latestCommit.isPresent(), "latestCommit.isPresent()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSparkSqlCoreFlow.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(((HoodieInstant)latestCommit.get()).isCompleted(), "latestCommit.get().isCompleted()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TestSparkSqlCoreFlow.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
        HoodieCommitMetadata metadata = TimelineUtils.getCommitMetadata((HoodieInstant)((HoodieInstant)latestCommit.get()), (HoodieTimeline)timeline);
        return metadata.getOperationType().equals((Object)operationType);
    }

    public void insertInto(String tableName, String tableBasePath, Dataset<Row> inputDf, WriteOperationType writeOp, boolean isMetadataEnabledOnWrite, int count) {
        inputDf.select("timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_row_key", "rider", "driver", "begin_lat", "begin_lon", "end_lat", "end_lon", "fare", "_hoodie_is_deleted", "partition_path"})).createOrReplaceTempView("insert_temp_table");
        try {
            BoxedUnit boxedUnit;
            this.spark().sql(new StringBuilder(27).append("set hoodie.metadata.enable=").append(String.valueOf(isMetadataEnabledOnWrite)).toString());
            if (writeOp.equals((Object)WriteOperationType.UPSERT)) {
                this.spark().sql("set hoodie.sql.bulk.insert.enable=false");
                this.spark().sql("set hoodie.sql.insert.mode=upsert");
                boxedUnit = this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(311).append("\n             | merge into ").append(tableName).append(" as target\n             | using insert_temp_table as source\n             | on target._row_key = source._row_key and\n             | target.partition_path = source.partition_path\n             | when matched then update set *\n             | when not matched then insert *\n             | ").toString())).stripMargin());
            } else if (writeOp.equals((Object)WriteOperationType.BULK_INSERT)) {
                this.spark().sql("set hoodie.sql.bulk.insert.enable=true");
                this.spark().sql("set hoodie.sql.insert.mode=non-strict");
                boxedUnit = this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" select * from insert_temp_table").toString());
            } else if (writeOp.equals((Object)WriteOperationType.INSERT)) {
                this.spark().sql("set hoodie.sql.bulk.insert.enable=false");
                this.spark().sql("set hoodie.sql.insert.mode=non-strict");
                boxedUnit = this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" select * from insert_temp_table").toString());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.assertOperation(tableBasePath, count, writeOp);
        }
        finally {
            this.spark().conf().unset("hoodie.metadata.enable");
            this.spark().conf().unset("hoodie.datasource.write.keygenerator.class");
            this.spark().conf().unset("hoodie.sql.bulk.insert.enable");
            this.spark().conf().unset("hoodie.sql.insert.mode");
        }
    }

    public void createTable(String tableName, String keyGenClass, String writeOptions, String tableBasePath) {
        String partitionedBy = !keyGenClass.equals(NonpartitionedKeyGenerator.class.getName()) ? "partitioned by (partition_path)" : "";
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(502).append("\n         | create table ").append(tableName).append(" (\n         |  timestamp long,\n         |  _row_key string,\n         |  rider string,\n         |  driver string,\n         |  begin_lat double,\n         |  begin_lon double,\n         |  end_lat double,\n         |  end_lon double,\n         |  fare STRUCT<\n         |    amount: double,\n         |    currency: string >,\n         |  _hoodie_is_deleted boolean,\n         |  partition_path string\n         |) using hudi\n         | ").append(partitionedBy).append("\n         | ").append(writeOptions).append("\n         | location '").append(tableBasePath).append("'\n         |\n    ").toString())).stripMargin());
    }

    public Dataset<Row> generateInserts(HoodieTestDataGenerator dataGen, String instantTime, int n) {
        java.util.List recs = dataGen.generateInsertsNestedExample(instantTime, Predef$.MODULE$.int2Integer(n));
        return this.spark().read().json(this.spark().sparkContext().parallelize(((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)recs)).asScala()).toSeq(), 2, ClassTag$.MODULE$.apply(String.class)));
    }

    public Dataset<Row> generateUniqueUpdates(HoodieTestDataGenerator dataGen, String instantTime, int n) {
        java.util.List recs = dataGen.generateUniqueUpdatesNestedExample(instantTime, Predef$.MODULE$.int2Integer(n));
        return this.spark().read().json(this.spark().sparkContext().parallelize(((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(RawTripTestPayload.recordsToStrings((java.util.List)recs)).asScala()).toSeq(), 2, ClassTag$.MODULE$.apply(String.class)));
    }

    public boolean rowsEqual(Row row1, Row row2) {
        StructType schema1 = ((GenericRowWithSchema)row1).schema();
        StructType schema2 = ((GenericRowWithSchema)row2).schema();
        StructType structType = schema1;
        StructType structType2 = schema2;
        if (structType == null ? structType2 != null : !structType.equals(structType2)) {
            throw new AssertionError((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(70).append("Schemas are different:\n            |Schema 1: ").append(schema1.treeString()).append("\n            |Schema 2: ").append(schema2.treeString()).toString())).stripMargin());
        }
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema1.fields())).forall((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)TestSparkSqlCoreFlow.$anonfun$rowsEqual$1(row1, row2, field)));
    }

    public void compareUpdateRowsWithHudiRows(Row[] deltaRows, Row[] afterRows, Row[] beforeRows) {
        Map deltaRowsMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltaRows)).map((Function1 & Serializable & scala.Serializable)row -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TestSparkSqlCoreFlow.getRowKey$1(row)), row), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        Map beforeRowsMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])beforeRows)).map((Function1 & Serializable & scala.Serializable)row -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TestSparkSqlCoreFlow.getRowKey$1(row)), row), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        Assertions.assertEquals((int)deltaRowsMap.size(), (int)deltaRows.length);
        Assertions.assertEquals((int)beforeRowsMap.size(), (int)beforeRows.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltaRows)).foreach((Function1 & Serializable & scala.Serializable)inputRow -> {
            TestSparkSqlCoreFlow.$anonfun$compareUpdateRowsWithHudiRows$3(this, afterRows, inputRow);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])afterRows)).foreach((Function1 & Serializable & scala.Serializable)hudiRow -> {
            TestSparkSqlCoreFlow.$anonfun$compareUpdateRowsWithHudiRows$5(this, deltaRowsMap, beforeRowsMap, hudiRow);
            return BoxedUnit.UNIT;
        });
    }

    public void compareEntireInputRowsWithHudiRows(Row[] expectedRows, Row[] actualRows) {
        this.compareUpdateRowsWithHudiRows((Row[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Row.class)), expectedRows, actualRows);
    }

    public Dataset<Row> doMORReadOptimizedQuery(boolean isMetadataEnabledOnRead, String basePath) {
        return this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL()).option(HoodieMetadataConfig.ENABLE.key(), isMetadataEnabledOnRead).load(basePath);
    }

    public void compareROAndRT(boolean isMetadataEnabledOnRead, String tableName, String basePath) {
        Dataset<Row> roDf = this.doMORReadOptimizedQuery(isMetadataEnabledOnRead, basePath);
        Dataset<Row> rtDf = this.doSnapshotRead(tableName, isMetadataEnabledOnRead);
        this.dropMetaColumns(roDf).createOrReplaceTempView("hudiTbl1");
        this.dropMetaColumns(rtDf).createOrReplaceTempView("hudiTbl2");
        Dataset hudiDf1ToCompare = this.spark().sqlContext().sql(new StringBuilder(21).append("select ").append(this.colsToCompare()).append(" from hudiTbl1").toString());
        Dataset hudiDf2ToCompare = this.spark().sqlContext().sql(new StringBuilder(21).append("select ").append(this.colsToCompare()).append(" from hudiTbl2").toString());
        Assertions.assertEquals((long)hudiDf1ToCompare.intersect(hudiDf2ToCompare).count(), (long)hudiDf1ToCompare.count());
        Assertions.assertEquals((long)hudiDf1ToCompare.except(hudiDf2ToCompare).count(), (long)0L);
    }

    public Dataset<Row> dropMetaColumns(Dataset<Row> inputDf) {
        return inputDf.drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{HoodieRecord.RECORD_KEY_METADATA_FIELD, HoodieRecord.PARTITION_PATH_METADATA_FIELD, HoodieRecord.COMMIT_SEQNO_METADATA_FIELD, HoodieRecord.COMMIT_TIME_METADATA_FIELD, HoodieRecord.FILENAME_METADATA_FIELD}));
    }

    public List<String> paramsForImmutable() {
        return this.paramsForImmutable;
    }

    public void testImmutableUserFlow(File basePath, String tableType, WriteOperationType writeOp, boolean isMetadataEnabled, String keyGenClass, String indexType) {
        String tableName = this.generateTableName();
        String tableBasePath = new StringBuilder(1).append(basePath.getCanonicalPath()).append("/").append(tableName).toString();
        String writeOptions = this.getWriteOptions(tableName, tableType, keyGenClass, indexType);
        this.createTable(tableName, keyGenClass, writeOptions, tableBasePath);
        FileSystem fs = HadoopFSUtils.getFs((String)tableBasePath, (Configuration)this.spark().sparkContext().hadoopConfiguration());
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", 57069L);
        Dataset inputDf0 = this.generateInserts(dataGen, "000", 100).cache();
        this.insertInto(tableName, tableBasePath, (Dataset<Row>)inputDf0, WriteOperationType.BULK_INSERT, isMetadataEnabled, 1);
        Row[] inputDf0Rows = (Row[])this.canonicalizeDF((Dataset<Row>)inputDf0).collect();
        inputDf0.unpersist(true);
        Assertions.assertTrue((boolean)HoodieDataSourceHelpers.hasNewCommits((FileSystem)fs, (String)tableBasePath, (String)"000"));
        Row[] snapshotDf1Rows = (Row[])this.canonicalizeDF(this.doSnapshotRead(tableName, isMetadataEnabled)).collect();
        Assertions.assertEquals((int)100, (int)snapshotDf1Rows.length);
        this.compareEntireInputRowsWithHudiRows(inputDf0Rows, snapshotDf1Rows);
        Dataset inputDf1 = this.generateInserts(dataGen, "001", 50).cache();
        this.insertInto(tableName, tableBasePath, (Dataset<Row>)inputDf1, writeOp, isMetadataEnabled, 2);
        Row[] inputDf1rows = (Row[])this.canonicalizeDF((Dataset<Row>)inputDf0).collect();
        inputDf1.unpersist(true);
        Row[] snapshotDf2 = (Row[])this.canonicalizeDF(this.doSnapshotRead(tableName, isMetadataEnabled)).collect();
        Assertions.assertEquals((int)150, (int)snapshotDf2.length);
        this.compareEntireInputRowsWithHudiRows((Row[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputDf1rows)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputDf0Rows)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))), snapshotDf2);
        Dataset inputDf2 = this.generateInserts(dataGen, "002", 60).cache();
        this.insertInto(tableName, tableBasePath, (Dataset<Row>)inputDf2, writeOp, isMetadataEnabled, 3);
        Row[] inputDf2rows = (Row[])this.canonicalizeDF((Dataset<Row>)inputDf0).collect();
        inputDf2.unpersist(true);
        Assertions.assertEquals((int)3, (int)HoodieDataSourceHelpers.listCommitsSince((FileSystem)fs, (String)tableBasePath, (String)"000").size());
        Row[] snapshotDf3 = (Row[])this.canonicalizeDF(this.doSnapshotRead(tableName, isMetadataEnabled)).collect();
        Assertions.assertEquals((int)210, (int)snapshotDf3.length);
        this.compareEntireInputRowsWithHudiRows((Row[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputDf1rows)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputDf0Rows)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputDf2rows)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))), snapshotDf3);
    }

    public static final /* synthetic */ boolean $anonfun$rowsEqual$1(Row row1$1, Row row2$1, StructField field) {
        int idx1 = row1$1.fieldIndex(field.name());
        int idx2 = row2$1.fieldIndex(field.name());
        return BoxesRunTime.equals((Object)row1$1.get(idx1), (Object)row2$1.get(idx2));
    }

    private static final String getRowKey$1(Row row) {
        return (String)row.getAs("_row_key");
    }

    public static final /* synthetic */ boolean $anonfun$compareUpdateRowsWithHudiRows$4(String key$1, Row row) {
        String string = TestSparkSqlCoreFlow.getRowKey$1(row);
        String string2 = key$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$compareUpdateRowsWithHudiRows$3(TestSparkSqlCoreFlow $this, Row[] afterRows$1, Row inputRow) {
        String key = TestSparkSqlCoreFlow.getRowKey$1(inputRow);
        Option hudiRow = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])afterRows$1)).find((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)TestSparkSqlCoreFlow.$anonfun$compareUpdateRowsWithHudiRows$4(key, row)));
        Assertions.assertTrue((hudiRow.isDefined() && $this.rowsEqual(inputRow, (Row)hudiRow.get()) ? 1 : 0) != 0, (String)new StringBuilder(68).append("Input row with _row_key: ").append(key).append(" not found in Hudi rows or content mismatch").toString());
    }

    public static final /* synthetic */ void $anonfun$compareUpdateRowsWithHudiRows$5(TestSparkSqlCoreFlow $this, Map deltaRowsMap$1, Map beforeRowsMap$1, Row hudiRow) {
        String key = TestSparkSqlCoreFlow.getRowKey$1(hudiRow);
        boolean foundInInput = deltaRowsMap$1.get((Object)key).exists((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)$this.rowsEqual(hudiRow, row)));
        boolean foundInBefore = !foundInInput && beforeRowsMap$1.get((Object)key).exists((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)$this.rowsEqual(hudiRow, row)));
        Assertions.assertTrue((foundInInput || foundInBefore ? 1 : 0) != 0, (String)new StringBuilder(65).append("Hudi row with _row_key: ").append(key).append(" not found in either input or before rows").toString());
    }

    public static final /* synthetic */ void $anonfun$new$6(TestSparkSqlCoreFlow $this, String[] splits$2, File basePath) {
        WriteOperationType writeOperationType;
        if (splits$2[1].equals("insert")) {
            writeOperationType = WriteOperationType.INSERT;
        } else if (splits$2[1].equals("bulk_insert")) {
            writeOperationType = WriteOperationType.BULK_INSERT;
        } else {
            throw new UnsupportedOperationException("This test is only meant for immutable operations.");
        }
        WriteOperationType writeOp = writeOperationType;
        $this.testImmutableUserFlow(basePath, splits$2[0], writeOp, new StringOps(Predef$.MODULE$.augmentString(splits$2[2])).toBoolean(), splits$2[3], splits$2[4]);
    }

    public TestSparkSqlCoreFlow() {
        this.colsToCompare = "timestamp, _row_key, partition_path, rider, driver, begin_lat, begin_lon, end_lat, end_lon, fare.amount, fare.currency, _hoodie_is_deleted";
        Inspectors$.MODULE$.forAll(this.params(), (Function1 & Serializable & scala.Serializable)paramStr -> {
            this.test(new StringBuilder(23).append("Core flow with params: ").append(paramStr).toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String[] splits = new StringOps(Predef$.MODULE$.augmentString(paramStr)).split('|');
                $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)basePath -> {
                    $this.testCoreFlows(basePath, splits[0], new StringOps(Predef$.MODULE$.augmentString(splits[1])).toBoolean(), splits[2], splits[3]);
                    return BoxedUnit.UNIT;
                });
            }, new Position("TestSparkSqlCoreFlow.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            return BoxedUnit.UNIT;
        }, Collecting$.MODULE$.collectingNatureOfGenTraversable(), InspectorAsserting$.MODULE$.assertingNatureOfT(), Prettifier$.MODULE$.default(), new Position("TestSparkSqlCoreFlow.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.paramsForImmutable = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COPY_ON_WRITE|insert|false|org.apache.hudi.keygen.SimpleKeyGenerator|GLOBAL_BLOOM", "COPY_ON_WRITE|insert|true|org.apache.hudi.keygen.SimpleKeyGenerator|GLOBAL_BLOOM", "COPY_ON_WRITE|insert|false|org.apache.hudi.keygen.SimpleKeyGenerator|GLOBAL_SIMPLE", "COPY_ON_WRITE|insert|true|org.apache.hudi.keygen.SimpleKeyGenerator|GLOBAL_SIMPLE", "COPY_ON_WRITE|insert|false|org.apache.hudi.keygen.NonpartitionedKeyGenerator|BLOOM", "COPY_ON_WRITE|insert|true|org.apache.hudi.keygen.NonpartitionedKeyGenerator|BLOOM", "COPY_ON_WRITE|insert|false|org.apache.hudi.keygen.NonpartitionedKeyGenerator|SIMPLE", "COPY_ON_WRITE|insert|true|org.apache.hudi.keygen.NonpartitionedKeyGenerator|SIMPLE", "MERGE_ON_READ|insert|false|org.apache.hudi.keygen.SimpleKeyGenerator|GLOBAL_BLOOM", "MERGE_ON_READ|insert|true|org.apache.hudi.keygen.SimpleKeyGenerator|GLOBAL_BLOOM", "MERGE_ON_READ|insert|false|org.apache.hudi.keygen.SimpleKeyGenerator|GLOBAL_SIMPLE", "MERGE_ON_READ|insert|true|org.apache.hudi.keygen.SimpleKeyGenerator|GLOBAL_SIMPLE", "MERGE_ON_READ|insert|false|org.apache.hudi.keygen.NonpartitionedKeyGenerator|BLOOM", "MERGE_ON_READ|insert|true|org.apache.hudi.keygen.NonpartitionedKeyGenerator|BLOOM", "MERGE_ON_READ|insert|false|org.apache.hudi.keygen.NonpartitionedKeyGenerator|SIMPLE", "MERGE_ON_READ|insert|true|org.apache.hudi.keygen.NonpartitionedKeyGenerator|SIMPLE", "COPY_ON_WRITE|bulk_insert|false|org.apache.hudi.keygen.SimpleKeyGenerator|GLOBAL_BLOOM", "COPY_ON_WRITE|bulk_insert|true|org.apache.hudi.keygen.SimpleKeyGenerator|GLOBAL_BLOOM", "COPY_ON_WRITE|bulk_insert|false|org.apache.hudi.keygen.SimpleKeyGenerator|GLOBAL_SIMPLE", "COPY_ON_WRITE|bulk_insert|true|org.apache.hudi.keygen.SimpleKeyGenerator|GLOBAL_SIMPLE", "COPY_ON_WRITE|bulk_insert|false|org.apache.hudi.keygen.NonpartitionedKeyGenerator|BLOOM", "COPY_ON_WRITE|bulk_insert|true|org.apache.hudi.keygen.NonpartitionedKeyGenerator|BLOOM", "COPY_ON_WRITE|bulk_insert|false|org.apache.hudi.keygen.NonpartitionedKeyGenerator|SIMPLE", "COPY_ON_WRITE|bulk_insert|true|org.apache.hudi.keygen.NonpartitionedKeyGenerator|SIMPLE", "MERGE_ON_READ|bulk_insert|false|org.apache.hudi.keygen.SimpleKeyGenerator|GLOBAL_BLOOM", "MERGE_ON_READ|bulk_insert|true|org.apache.hudi.keygen.SimpleKeyGenerator|GLOBAL_BLOOM", "MERGE_ON_READ|bulk_insert|false|org.apache.hudi.keygen.SimpleKeyGenerator|GLOBAL_SIMPLE", "MERGE_ON_READ|bulk_insert|true|org.apache.hudi.keygen.SimpleKeyGenerator|GLOBAL_SIMPLE", "MERGE_ON_READ|bulk_insert|false|org.apache.hudi.keygen.NonpartitionedKeyGenerator|BLOOM", "MERGE_ON_READ|bulk_insert|true|org.apache.hudi.keygen.NonpartitionedKeyGenerator|BLOOM", "MERGE_ON_READ|bulk_insert|false|org.apache.hudi.keygen.NonpartitionedKeyGenerator|SIMPLE", "MERGE_ON_READ|bulk_insert|true|org.apache.hudi.keygen.NonpartitionedKeyGenerator|SIMPLE"}));
        Inspectors$.MODULE$.forAll(this.paramsForImmutable(), (Function1 & Serializable & scala.Serializable)paramStr -> {
            this.test(new StringBuilder(33).append("Immutable user flow with params: ").append(paramStr).toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String[] splits = new StringOps(Predef$.MODULE$.augmentString(paramStr)).split('|');
                $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)basePath -> {
                    TestSparkSqlCoreFlow.$anonfun$new$6($this, splits, basePath);
                    return BoxedUnit.UNIT;
                });
            }, new Position("TestSparkSqlCoreFlow.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 450));
            return BoxedUnit.UNIT;
        }, Collecting$.MODULE$.collectingNatureOfGenTraversable(), InspectorAsserting$.MODULE$.assertingNatureOfT(), Prettifier$.MODULE$.default(), new Position("TestSparkSqlCoreFlow.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
    }
}

