/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.functional;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.avro.Schema;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.ScalaAssertionSupport;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.ExceptionUtil;
import org.apache.hudi.exception.HoodieTimeTravelException;
import org.apache.hudi.functional.TestTimeTravelQuery$;
import org.apache.hudi.testutils.HoodieSparkClientTestBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001B\u000b\u0017\u0001}AQA\u000b\u0001\u0005\u0002-B\u0011B\f\u0001A\u0002\u0003\u0007I\u0011A\u0018\t\u0013]\u0002\u0001\u0019!a\u0001\n\u0003A\u0004\"C!\u0001\u0001\u0004\u0005\t\u0015)\u00031\u0011\u001d\u0011\u0005A1A\u0005\u0002\rCa\u0001\u0016\u0001!\u0002\u0013!\u0005\"B+\u0001\t\u00032\u0006\"\u00022\u0001\t\u00032\u0006\"B4\u0001\t\u0003A\u0007bBA\u0004\u0001\u0011\u0005\u0011\u0011\u0002\u0005\b\u0003#\u0001A\u0011AA\n\u0011\u001d\tY\u0002\u0001C\u0005\u0003;A\u0011\"a\u001a\u0001#\u0003%I!!\u001b\t\u000f\u0005}\u0004\u0001\"\u0003\u0002\u0002\"9\u0011q\u0011\u0001\u0005\n\u0005%\u0005bBAG\u0001\u0011\u0005\u0011q\u0012\u0005\b\u0003/\u0003A\u0011AAM\u0011\u001d\t\t\u000b\u0001C\u0001\u0003GCq!a+\u0001\t\u0003\ti\u000b\u0003\u0007\u00026\u0002\u0001\n\u0011!A\u0001\n\u0003\t9LA\nUKN$H+[7f)J\fg/\u001a7Rk\u0016\u0014\u0018P\u0003\u0002\u00181\u0005Qa-\u001e8di&|g.\u00197\u000b\u0005eQ\u0012\u0001\u00025vI&T!a\u0007\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0012aA8sO\u000e\u00011c\u0001\u0001!MA\u0011\u0011\u0005J\u0007\u0002E)\u00111\u0005G\u0001\ni\u0016\u001cH/\u001e;jYNL!!\n\u0012\u00033!{w\u000eZ5f'B\f'o[\"mS\u0016tG\u000fV3ti\n\u000b7/\u001a\t\u0003O!j\u0011\u0001G\u0005\u0003Sa\u0011QcU2bY\u0006\f5o]3si&|gnU;qa>\u0014H/\u0001\u0004=S:LGO\u0010\u000b\u0002YA\u0011Q\u0006A\u0007\u0002-\u0005)1\u000f]1sWV\t\u0001\u0007\u0005\u00022k5\t!G\u0003\u00024i\u0005\u00191/\u001d7\u000b\u00059R\u0012B\u0001\u001c3\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003%\u0019\b/\u0019:l?\u0012*\u0017\u000f\u0006\u0002:\u007fA\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t!QK\\5u\u0011\u001d\u00015!!AA\u0002A\n1\u0001\u001f\u00132\u0003\u0019\u0019\b/\u0019:lA\u0005Q1m\\7n_:|\u0005\u000f^:\u0016\u0003\u0011\u0003B!\u0012&M\u00196\taI\u0003\u0002H\u0011\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003\u0013n\n!bY8mY\u0016\u001cG/[8o\u0013\tYeIA\u0002NCB\u0004\"!\u0014*\u000e\u00039S!a\u0014)\u0002\t1\fgn\u001a\u0006\u0002#\u0006!!.\u0019<b\u0013\t\u0019fJ\u0001\u0004TiJLgnZ\u0001\fG>lWn\u001c8PaR\u001c\b%A\u0003tKR,\u0006\u000fF\u0001:Q\t9\u0001\f\u0005\u0002ZA6\t!L\u0003\u0002\\9\u0006\u0019\u0011\r]5\u000b\u0005us\u0016a\u00026va&$XM\u001d\u0006\u0003?r\tQA[;oSRL!!\u0019.\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\tAA\r\u0005\u0002ZK&\u0011aM\u0017\u0002\n\u0003\u001a$XM]#bG\"\f1\u0003^3tiRKW.\u001a+sCZ,G.U;fef$\"!O5\t\u000b)L\u0001\u0019A6\u0002\u0013Q\f'\r\\3UsB,\u0007C\u00017r\u001b\u0005i'B\u00018p\u0003\u0015iw\u000eZ3m\u0015\t\u0001\b$\u0001\u0004d_6lwN\\\u0005\u0003e6\u0014q\u0002S8pI&,G+\u00192mKRK\b/\u001a\u0015\u0005\u0013QdX\u0010\u0005\u0002vu6\taO\u0003\u0002xq\u0006A\u0001O]8wS\u0012,'O\u0003\u0002z9\u00061\u0001/\u0019:b[NL!a\u001f<\u0003\u0015\u0015sW/\\*pkJ\u001cW-A\u0003wC2,XmI\u0001lQ\tIq\u0010\u0005\u0003\u0002\u0002\u0005\rQ\"\u0001=\n\u0007\u0005\u0015\u0001PA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fq\u0005^3tiRKW.\u001a+sCZ,G.U;fef<\u0016\u000e\u001e5J]\u000e|W\u000e\u001d7fi\u0016\u001cu.\\7jiR\u0019\u0011(a\u0003\t\u000b)T\u0001\u0019A6)\t)!H0 \u0015\u0003\u0015}\fa\u0005^3tiRKW.\u001a+sCZ,G.U;fef4uN\u001d)beRLG/[8oK\u0012$\u0016M\u00197f)\rI\u0014Q\u0003\u0005\u0006U.\u0001\ra\u001b\u0015\u0005\u0017QdX\u0010\u000b\u0002\f\u007f\u0006QqO]5uK\n\u000bGo\u00195\u0015\u0011\u0005}\u00111GA+\u0003;\u0002B!!\t\u000209!\u00111EA\u0016!\r\t)cO\u0007\u0003\u0003OQ1!!\u000b\u001f\u0003\u0019a$o\\8u}%\u0019\u0011QF\u001e\u0002\rA\u0013X\rZ3g\u0013\r\u0019\u0016\u0011\u0007\u0006\u0004\u0003[Y\u0004bBA\u001b\u0019\u0001\u0007\u0011qG\u0001\u0003I\u001a\u0004B!!\u000f\u0002P9!\u00111HA&\u001d\u0011\ti$!\u0013\u000f\t\u0005}\u0012q\t\b\u0005\u0003\u0003\n)E\u0004\u0003\u0002&\u0005\r\u0013\"A\u000f\n\u0005ma\u0012B\u0001\u0018\u001b\u0013\t\u0019D'C\u0002\u0002NI\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002R\u0005M#!\u0003#bi\u00064%/Y7f\u0015\r\tiE\r\u0005\b\u0003/b\u0001\u0019AA-\u0003\u001dy\u0007\u000f^5p]N\u0004\u0002\"!\t\u0002\\\u0005}\u0011qD\u0005\u0004\u0017\u0006E\u0002\"CA0\u0019A\u0005\t\u0019AA1\u0003\u0011iw\u000eZ3\u0011\u0007E\n\u0019'C\u0002\u0002fI\u0012\u0001bU1wK6{G-Z\u0001\u0015oJLG/\u001a\"bi\u000eDG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005-$\u0006BA1\u0003[Z#!a\u001c\u0011\t\u0005E\u00141P\u0007\u0003\u0003gRA!!\u001e\u0002x\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003sZ\u0014AC1o]>$\u0018\r^5p]&!\u0011QPA:\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0016I\u00164\u0017-\u001e7u\t\u0006$X\rV5nK\u001a{'/\\1u)\u0011\ty\"a!\t\u000f\u0005\u0015e\u00021\u0001\u0002 \u0005a\u0011/^3ss&s7\u000f^1oi\u0006\tB-\u001a4bk2$H)\u0019;f\r>\u0014X.\u0019;\u0015\t\u0005}\u00111\u0012\u0005\b\u0003\u000b{\u0001\u0019AA\u0010\u0003\u0019\"Xm\u001d;US6,GK]1wK2\fV/\u001a:z/&$\bnU2iK6\fWI^8mkRLwN\u001c\u000b\u0004s\u0005E\u0005\"\u00026\u0011\u0001\u0004Y\u0007\u0006\u0002\tuyvD#\u0001E@\u0002IQ,7\u000f\u001e+j[\u0016$&/\u0019<fYF+XM]=D_6l\u0017\u000e^:CCN,Gm\u00117fC:$2!OAN\u0011\u0015Q\u0017\u00031\u0001lQ\u0011\tB\u000f`?)\u0005Ey\u0018\u0001\u000b;fgR$\u0016.\\3Ue\u00064X\r\\)vKJLh)\u001b7f-\u0016\u00148/[8o\u0005\u0006\u001cX\rZ\"mK\u0006tGcA\u001d\u0002&\")!N\u0005a\u0001W\"\"!\u0003\u001e?~Q\t\u0011r0\u0001\fuKN$H+[7f)J\fg/\u001a7Rk\u0016\u0014\u0018pQ(X)\u0015I\u0014qVAZ\u0011\u001d\t\tl\u0005a\u0001\u0003?\tQb\u00197fC:,'\u000fU8mS\u000eL\b\"\u00026\u0014\u0001\u0004Y\u0017A\u00059s_R,7\r^3eI\t\f7/\u001a)bi\"$2\u0001TA]\u0011\u001d\u0001E#!AA\u00021\u0002")
public class TestTimeTravelQuery
extends HoodieSparkClientTestBase
implements ScalaAssertionSupport {
    private SparkSession spark;
    private final Map<String, String> commonOpts;

    @Override
    public <T extends Throwable, R> T assertThrows(Class<T> expectedExceptionClass, Function0<R> f) {
        return (T)ScalaAssertionSupport.assertThrows$(this, expectedExceptionClass, f);
    }

    public /* synthetic */ String protected$basePath(TestTimeTravelQuery x$1) {
        return x$1.basePath;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public Map<String, String> commonOpts() {
        return this.commonOpts;
    }

    @BeforeEach
    public void setUp() {
        this.setTableName("hoodie_test");
        this.initPath();
        this.initSparkContexts();
        this.spark_$eq(this.sqlContext.sparkSession());
        this.initTestDataGenerator();
        this.initHoodieStorage();
    }

    @AfterEach
    public void tearDown() {
        this.cleanupSparkContexts();
        this.cleanupTestDataGenerator();
        this.cleanupFileSystem();
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testTimeTravelQuery(HoodieTableType tableType) {
        this.initMetaClient(tableType);
        SparkSession _spark = this.spark();
        Map opts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"")})));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestTimeTravelQuery.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator6$1(TestTimeTravelQuery $outer) {
            }
        }
        Dataset df1 = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000)), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator6$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "version"}));
        String firstCommit = this.writeBatch((Dataset<Row>)df1, (Map<String, String>)opts, SaveMode.Overwrite);
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(TestTimeTravelQuery.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator16$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator16$1(TestTimeTravelQuery $outer) {
            }
        }
        Dataset df2 = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToInteger((int)1001)), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator16$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "version"}));
        String secondCommit = this.writeBatch((Dataset<Row>)df2, (Map<String, String>)opts, this.writeBatch$default$3());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(TestTimeTravelQuery.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator26$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator26$1(TestTimeTravelQuery $outer) {
            }
        }
        Dataset df3 = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)13), (Object)BoxesRunTime.boxToInteger((int)1002)), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator26$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "version"}));
        String thirdCommit = this.writeBatch((Dataset<Row>)df3, (Map<String, String>)opts, this.writeBatch$default$3());
        Row result1 = ((Row[])this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.TIME_TRAVEL_AS_OF_INSTANT().key(), firstCommit).load(this.basePath).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "value", "version"})).take(1))[0];
        Assertions.assertEquals((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000)})), (Object)result1);
        Row result2 = ((Row[])this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.TIME_TRAVEL_AS_OF_INSTANT().key(), secondCommit).load(this.basePath).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "value", "version"})).take(1))[0];
        Assertions.assertEquals((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)12), BoxesRunTime.boxToInteger((int)1001)})), (Object)result2);
        Row result3 = ((Row[])this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.TIME_TRAVEL_AS_OF_INSTANT().key(), thirdCommit).load(this.basePath).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "value", "version"})).take(1))[0];
        Assertions.assertEquals((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)13), BoxesRunTime.boxToInteger((int)1002)})), (Object)result3);
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testTimeTravelQueryWithIncompleteCommit(HoodieTableType tableType) {
        this.initMetaClient(tableType);
        SparkSession _spark = this.spark();
        Map opts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"")})));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestTimeTravelQuery.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator6$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator6$2(TestTimeTravelQuery $outer) {
            }
        }
        Dataset df1 = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000)), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator6$2(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "version"}));
        String firstCommit = this.writeBatch((Dataset<Row>)df1, (Map<String, String>)opts, SaveMode.Overwrite);
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(TestTimeTravelQuery.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator16$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator16$2(TestTimeTravelQuery $outer) {
            }
        }
        Dataset df2 = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToInteger((int)1001)), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator16$2(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "version"}));
        String secondCommit = this.writeBatch((Dataset<Row>)df2, (Map<String, String>)opts, this.writeBatch$default$3());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(TestTimeTravelQuery.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator26$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator26$2(TestTimeTravelQuery $outer) {
            }
        }
        Dataset df3 = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)13), (Object)BoxesRunTime.boxToInteger((int)1002)), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator26$2(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "version"}));
        String thirdCommit = this.writeBatch((Dataset<Row>)df3, (Map<String, String>)opts, this.writeBatch$default$3());
        String incompleteCommit = Long.toString(new StringOps(Predef$.MODULE$.augmentString(firstCommit)).toLong() + 1L);
        HoodieTableType hoodieTableType = tableType;
        if (HoodieTableType.COPY_ON_WRITE.equals(hoodieTableType)) {
            HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addInflightCommit(incompleteCommit);
        } else if (HoodieTableType.MERGE_ON_READ.equals(hoodieTableType)) {
            HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addInflightDeltaCommit(incompleteCommit);
        } else {
            throw new MatchError((Object)hoodieTableType);
        }
        Row result1 = ((Row[])this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.TIME_TRAVEL_AS_OF_INSTANT().key(), firstCommit).load(this.basePath).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "value", "version"})).take(1))[0];
        Assertions.assertEquals((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000)})), (Object)result1);
        new .colon.colon((Object)incompleteCommit, (List)new .colon.colon((Object)secondCommit, (List)new .colon.colon((Object)thirdCommit, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)commitTime -> this.assertThrows(HoodieTimeTravelException.class, (Function0 & Serializable & scala.Serializable)() -> ((Row[])this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.TIME_TRAVEL_AS_OF_INSTANT().key(), commitTime).load(this.protected$basePath(this)).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "value", "version"})).take(1))[0]));
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testTimeTravelQueryForPartitionedTable(HoodieTableType tableType) {
        this.initMetaClient(tableType);
        SparkSession _spark = this.spark();
        Map opts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"version"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"dt")})));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestTimeTravelQuery.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator6$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator6$3(TestTimeTravelQuery $outer) {
            }
        }
        Dataset df1 = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000), (Object)"2021-07-26"), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator6$3(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "version", "dt"}));
        String firstCommit = this.writeBatch((Dataset<Row>)df1, (Map<String, String>)opts, SaveMode.Overwrite);
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(TestTimeTravelQuery.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator16$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator16$3(TestTimeTravelQuery $outer) {
            }
        }
        Dataset df2 = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToInteger((int)1001), (Object)"2021-07-26"), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator16$3(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "version", "dt"}));
        String secondCommit = this.writeBatch((Dataset<Row>)df2, (Map<String, String>)opts, this.writeBatch$default$3());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(TestTimeTravelQuery.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator26$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator26$3(TestTimeTravelQuery $outer) {
            }
        }
        Dataset df3 = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)13), (Object)BoxesRunTime.boxToInteger((int)1002), (Object)"2021-07-26"), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator26$3(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "version", "dt"}));
        String thirdCommit = this.writeBatch((Dataset<Row>)df3, (Map<String, String>)opts, this.writeBatch$default$3());
        Row result1 = ((Row[])this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.TIME_TRAVEL_AS_OF_INSTANT().key(), this.defaultDateTimeFormat(firstCommit)).load(this.basePath).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "value", "version", "dt"})).take(1))[0];
        Assertions.assertEquals((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), "2021-07-26"})), (Object)result1);
        Row result2 = ((Row[])this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.TIME_TRAVEL_AS_OF_INSTANT().key(), secondCommit).load(this.basePath).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "value", "version", "dt"})).take(1))[0];
        Assertions.assertEquals((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)12), BoxesRunTime.boxToInteger((int)1001), "2021-07-26"})), (Object)result2);
        Row result3 = ((Row[])this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.TIME_TRAVEL_AS_OF_INSTANT().key(), thirdCommit).load(this.basePath).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "value", "version", "dt"})).take(1))[0];
        Assertions.assertEquals((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)13), BoxesRunTime.boxToInteger((int)1002), "2021-07-26"})), (Object)result3);
        Row[] result4 = (Row[])this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.TIME_TRAVEL_AS_OF_INSTANT().key(), this.defaultDateFormat(thirdCommit)).load(this.basePath).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "value", "version", "dt"})).collect();
        Assertions.assertTrue((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result4)).isEmpty());
    }

    private String writeBatch(Dataset<Row> df, Map<String, String> options, SaveMode mode) {
        df.write().format("hudi").options(options).mode(mode).save(this.basePath);
        this.metaClient.reloadActiveTimeline();
        return ((HoodieInstant)this.metaClient.getActiveTimeline().filterCompletedInstants().lastInstant().get()).requestedTime();
    }

    private SaveMode writeBatch$default$3() {
        return SaveMode.Append;
    }

    private String defaultDateTimeFormat(String queryInstant) {
        Date date = TimelineUtils.parseDateFromInstantTime((String)queryInstant);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return format.format(date);
    }

    private String defaultDateFormat(String queryInstant) {
        Date date = TimelineUtils.parseDateFromInstantTime((String)queryInstant);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(date);
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testTimeTravelQueryWithSchemaEvolution(HoodieTableType tableType) {
        this.initMetaClient(tableType);
        SparkSession _spark = this.spark();
        this.metaClient = this.createMetaClient(this.spark(), this.basePath);
        Map opts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"name")})));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestTimeTravelQuery.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator6$4
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator6$4(TestTimeTravelQuery $outer) {
            }
        }
        Dataset df1 = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000)), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator6$4(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "version"}));
        String firstCommit = this.writeBatch((Dataset<Row>)df1, (Map<String, String>)opts, SaveMode.Overwrite);
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(TestTimeTravelQuery.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator16$4
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))))));
            }

            public Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator16$4(TestTimeTravelQuery $outer) {
            }
        }
        Dataset df2 = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToInteger((int)1001), (Object)"2022"), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator16$4(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "version", "year"}));
        String secondCommit = this.writeBatch((Dataset<Row>)df2, (Map<String, String>)opts, this.writeBatch$default$3());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(TestTimeTravelQuery.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator26$4
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple6"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)))))));
            }

            public Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator26$4(TestTimeTravelQuery $outer) {
            }
        }
        Dataset df3 = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)13), (Object)BoxesRunTime.boxToInteger((int)1002), (Object)"2022", (Object)"08"), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator26$4(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "version", "year", "month"}));
        String thirdCommit = this.writeBatch((Dataset<Row>)df3, (Map<String, String>)opts, this.writeBatch$default$3());
        TableSchemaResolver tableSchemaResolver = new TableSchemaResolver(this.metaClient);
        Row result1 = ((Row[])this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.TIME_TRAVEL_AS_OF_INSTANT().key(), firstCommit).load(this.basePath).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "value", "version"})).take(1))[0];
        Assertions.assertEquals((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000)})), (Object)result1);
        Schema schema1 = tableSchemaResolver.getTableAvroSchema(firstCommit);
        Assertions.assertNull((Object)schema1.getField("year"));
        Assertions.assertNull((Object)schema1.getField("month"));
        Row result2 = ((Row[])this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.TIME_TRAVEL_AS_OF_INSTANT().key(), secondCommit).load(this.basePath).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "value", "version", "year"})).take(1))[0];
        Assertions.assertEquals((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)12), BoxesRunTime.boxToInteger((int)1001), "2022"})), (Object)result2);
        Schema schema2 = tableSchemaResolver.getTableAvroSchema(secondCommit);
        Assertions.assertNotNull((Object)schema2.getField("year"));
        Assertions.assertNull((Object)schema2.getField("month"));
        Row result3 = ((Row[])this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.TIME_TRAVEL_AS_OF_INSTANT().key(), thirdCommit).load(this.basePath).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "value", "version", "year", "month"})).take(1))[0];
        Assertions.assertEquals((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)13), BoxesRunTime.boxToInteger((int)1002), "2022", "08"})), (Object)result3);
        Schema schema3 = tableSchemaResolver.getTableAvroSchema(thirdCommit);
        Assertions.assertNotNull((Object)schema3.getField("year"));
        Assertions.assertNotNull((Object)schema3.getField("month"));
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testTimeTravelQueryCommitsBasedClean(HoodieTableType tableType) {
        this.testTimeTravelQueryCOW(HoodieCleaningPolicy.KEEP_LATEST_COMMITS.name(), tableType);
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    public void testTimeTravelQueryFileVersionBasedClean(HoodieTableType tableType) {
        this.testTimeTravelQueryCOW(HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS.name(), tableType);
    }

    public void testTimeTravelQueryCOW(String cleanerPolicy, HoodieTableType tableType) {
        this.initMetaClient(tableType);
        SparkSession _spark = this.spark();
        Map opts = this.commonOpts().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableType.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCleanConfig.CLEANER_POLICY.key()), (Object)cleanerPolicy), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCleanConfig.CLEANER_COMMITS_RETAINED.key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCleanConfig.CLEANER_FILE_VERSIONS_RETAINED.key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieArchivalConfig.MIN_COMMITS_TO_KEEP.key()), (Object)"3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieArchivalConfig.MAX_COMMITS_TO_KEEP.key()), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key()), (Object)"1")})));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestTimeTravelQuery.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator6$5
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator6$5(TestTimeTravelQuery $outer) {
            }
        }
        Dataset df1 = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1000)), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator6$5(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "version"}));
        String firstCommit = this.writeBatch((Dataset<Row>)df1, (Map<String, String>)opts, SaveMode.Overwrite);
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(TestTimeTravelQuery.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator16$5
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator16$5(TestTimeTravelQuery $outer) {
            }
        }
        this.writeBatch((Dataset<Row>)_spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToInteger((int)1001)), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator16$5(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "version"})), (Map<String, String>)opts, this.writeBatch$default$3());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(TestTimeTravelQuery.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator26$5
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator26$5(TestTimeTravelQuery $outer) {
            }
        }
        Dataset df3 = _spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)13), (Object)BoxesRunTime.boxToInteger((int)1002)), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator26$5(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "version"}));
        String thirdCommit = this.writeBatch((Dataset<Row>)df3, (Map<String, String>)opts, this.writeBatch$default$3());
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(TestTimeTravelQuery.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator36$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator36$1(TestTimeTravelQuery $outer) {
            }
        }
        this.writeBatch((Dataset<Row>)_spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)14), (Object)BoxesRunTime.boxToInteger((int)1003)), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator36$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "version"})), (Map<String, String>)opts, this.writeBatch$default$3());
        Row result3 = ((Row[])this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.TIME_TRAVEL_AS_OF_INSTANT().key(), thirdCommit).load(this.basePath).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "value", "version"})).take(1))[0];
        Assertions.assertEquals((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)13), BoxesRunTime.boxToInteger((int)1002)})), (Object)result3);
        if (!cleanerPolicy.equals(HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS.name())) {
            IllegalArgumentException e1 = this.assertThrows(IllegalArgumentException.class, (Function0 & Serializable & scala.Serializable)() -> (Row[])this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.TIME_TRAVEL_AS_OF_INSTANT().key(), firstCommit).load(this.protected$basePath(this)).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "value", "version"})).take(1));
            Assertions.assertTrue((boolean)ExceptionUtil.getRootCause((Throwable)e1).getMessage().contains("Cleaner cleaned up the timestamp of interest. Please ensure sufficient commits are retained with cleaner for Timestamp as of query to work"));
        }
        JavaUniverse $u5 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(TestTimeTravelQuery.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator46$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator46$1(TestTimeTravelQuery $outer) {
            }
        }
        this.writeBatch((Dataset<Row>)_spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)15), (Object)BoxesRunTime.boxToInteger((int)1004)), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator46$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "version"})), (Map<String, String>)opts, this.writeBatch$default$3());
        JavaUniverse $u6 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m6 = package$.MODULE$.universe().runtimeMirror(TestTimeTravelQuery.class.getClassLoader());
        public final class Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator56$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator56$1(TestTimeTravelQuery $outer) {
            }
        }
        this.writeBatch((Dataset<Row>)_spark.implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a1", (Object)BoxesRunTime.boxToInteger((int)16), (Object)BoxesRunTime.boxToInteger((int)1005)), (List)Nil$.MODULE$), _spark.implicits().newProductEncoder(((TypeTags)$u6).TypeTag().apply((Mirror)$m6, (TypeCreator)new Org_apache_hudi_functional_TestTimeTravelQuery$$typecreator56$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "value", "version"})), (Map<String, String>)opts, this.writeBatch$default$3());
        String expectedErrorMsg = !cleanerPolicy.equals(HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS.name()) ? "Cleaner cleaned up the timestamp of interest. Please ensure sufficient commits are retained with cleaner for Timestamp as of query to work" : "Please ensure sufficient commits are retained (uncleaned and un-archived) for timestamp as of query to work.";
        IllegalArgumentException e2 = this.assertThrows(IllegalArgumentException.class, (Function0 & Serializable & scala.Serializable)() -> (Row[])this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.TIME_TRAVEL_AS_OF_INSTANT().key(), firstCommit).load(this.protected$basePath(this)).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "value", "version"})).take(1));
        Assertions.assertTrue((boolean)ExceptionUtil.getRootCause((Throwable)e2).getMessage().contains(expectedErrorMsg));
    }

    public TestTimeTravelQuery() {
        ScalaAssertionSupport.$init$(this);
        this.commonOpts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.bulkinsert.shuffle.parallelism"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.delete.shuffle.parallelism"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"version"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"hoodie_test")}));
    }
}

